// priority: 8
function all_effect_attack(event) {
    let player = event.source?.player;
    if (!player) return;

    let effects = get_all_effect(player);

    Object.entries(effects).forEach(([originalEffectName, effectValue]) => {
        let strategy = all_effect_attack_strategies[originalEffectName] || all_effect_attack_strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    });
}
const all_effect_attack_strategies = {
    //脉冲风行者水晶
    'pulse_windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        //如果玩家在飞行
        if (player.abilities.flying) {
            event.amount = event.amount * 0.1
        }
    },
    //风行者水晶
    'windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        //如果玩家在飞行
        if (player.abilities.flying) {
            event.amount = event.amount * 0.1
        }
    },
    //噬咬
    'devouring_bites': function (event, player, effectValue,  originalEffectName) {
        let curYingYangCount = player.persistentData.getInt(YingYangCount);
        updateYingYangCount(player, effectValue + curYingYangCount)
    },
    //伤害增加
    'damage_increased': function (event, player, effectValue, originalEffectName) {
        event.amount = event.amount * (1 + effectValue / 100)
    },
    //飞行
    'fei_xing': function (event, player, effectValue, originalEffectName) {
        //如果玩家在飞行
        if (player.abilities.flying) {
            event.amount = event.amount * 0.1
        }
    },
    //火焰增幅
    'fire_increase': function (event, player, effectValue, originalEffectName) {
        let type = event.getSource().getType().toString();
        if (type == 'attributeslib:fire_damage') {
            event.amount = event.amount * (1 + effectValue / 100)
        }
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};