/// <reference path="./internal_*.d.ts" />
declare namespace com.google.common.base {
    abstract class Optional <T> implements Internal.Serializable {
        abstract or(arg0: com.google.common.base.Optional_<T>): this;
        getClass(): typeof any;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static absent<T>(): com.google.common.base.Optional<T>;
        abstract or(arg0: T): T;
        abstract isPresent(): boolean;
        static toJavaUtil<T>(arg0: com.google.common.base.Optional_<T>): Internal.Optional<T>;
        toJavaUtil(): Internal.Optional<T>;
        abstract get(): T;
        abstract orNull(): T;
        static fromNullable<T>(arg0: T): com.google.common.base.Optional<T>;
        abstract "or(com.google.common.base.Optional)"(arg0: com.google.common.base.Optional_<T>): this;
        static fromJavaUtil<T>(arg0: Internal.Optional_<T>): com.google.common.base.Optional<T>;
        abstract toString(): string;
        abstract "or(com.google.common.base.Supplier)"(arg0: com.google.common.base.Supplier_<T>): T;
        abstract transform<V>(arg0: com.google.common.base.Function_<T, V>): com.google.common.base.Optional<V>;
        notifyAll(): void;
        abstract "or(java.lang.Object)"(arg0: T): T;
        abstract or(arg0: com.google.common.base.Supplier_<T>): T;
        abstract hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        abstract asSet(): Internal.Set<T>;
        abstract equals(arg0: any): boolean;
        static of<T>(arg0: T): com.google.common.base.Optional<T>;
        static presentInstances<T>(arg0: Internal.Iterable_<com.google.common.base.Optional<T>>): Internal.Iterable<T>;
        get class(): typeof any
        get present(): boolean
    }
    type Optional_<T> = Optional<T>;
}
declare namespace Internal {
    interface Function <T, R> {
        andThen<V>(arg0: Internal.Function_<R, V>): Internal.Function<T, V>;
        abstract apply(arg0: T): R;
        compose<V>(arg0: Internal.Function_<V, T>): Internal.Function<V, R>;
        identity<T>(): Internal.Function<T, T>;
        (arg0: T): R;
    }
    type Function_<T, R> = ((arg0: T)=> R) | Function<T, R>;
    class SyncedTrackedPlayer {
        constructor(arg0: Internal.UUID_, arg1: number, arg2: number, arg3: number, arg4: Internal.ResourceKey_<Internal.Level>)
        getClass(): typeof any;
        /**
         * @deprecated
        */
        getDimension(): ResourceLocation;
        toString(): string;
        matchesEnough(arg0: Internal.Player_, arg1: number): boolean;
        notifyAll(): void;
        setDimension(arg0: Internal.ResourceKey_<Internal.Level>): this;
        notify(): void;
        update(arg0: Internal.Player_): void;
        getDimensionKey(): Internal.ResourceKey<Internal.Level>;
        wait(arg0: number, arg1: number): void;
        copyFrom(arg0: Internal.SyncedTrackedPlayer_): void;
        getX(): number;
        getY(): number;
        getZ(): number;
        hashCode(): number;
        wait(): void;
        getId(): Internal.UUID;
        setPos(arg0: number, arg1: number, arg2: number): this;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        /**
         * @deprecated
        */
        get dimension(): ResourceLocation
        set dimension(arg0: Internal.ResourceKey_<Internal.Level>)
        get dimensionKey(): Internal.ResourceKey<Internal.Level>
        get x(): number
        get y(): number
        get z(): number
        get id(): Internal.UUID
    }
    type SyncedTrackedPlayer_ = SyncedTrackedPlayer;
    class KeyMappingTickHandler {
        constructor(arg0: Internal.KeyMappingControllerManager_)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        tick(): void;
        get class(): typeof any
        static DISABLE_KEY_MAPPING_OVERRIDES: (false) & (boolean);
    }
    type KeyMappingTickHandler_ = KeyMappingTickHandler;
    class TrueMoltengoldSwordItem extends Internal.SwordItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        biomancy$getDefaultModifiers(): Internal.Multimap<any, any>;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        getDamage(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getTier(): Internal.Tier;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        get damage(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        get tier(): Internal.Tier
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type TrueMoltengoldSwordItem_ = TrueMoltengoldSwordItem;
    interface BiPredicate <T, U> {
        abstract test(arg0: T, arg1: U): boolean;
        or(arg0: Internal.BiPredicate_<T, U>): this;
        and(arg0: Internal.BiPredicate_<T, U>): this;
        negate(): this;
        (arg0: T, arg1: U): boolean;
    }
    type BiPredicate_<T, U> = BiPredicate<T, U> | ((arg0: T, arg1: U)=> boolean);
    /**
     * @deprecated
    */
    abstract class GpuSurface extends icyllis.arc3d.engine.Resource {
        getClass(): typeof any;
        getLabel(): string;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract getSampleCount(): number;
        asImage(): icyllis.arc3d.engine.Image;
        unref(): void;
        getUniqueID(): Internal.UniqueID;
        hasAnyRefs(): boolean;
        abstract getHeight(): number;
        abstract getSurfaceFlags(): number;
        setKey(key: Internal.IResourceKey_): void;
        getMemorySize(): number;
        isBudgeted(): boolean;
        refCommandBuffer(): void;
        asRenderTarget(): Internal.GpuRenderTarget;
        isWrapped(): boolean;
        toString(): string;
        abstract getWidth(): number;
        getContext(): icyllis.arc3d.engine.Context;
        notifyAll(): void;
        getBackendFormat(): Internal.BackendFormat;
        ref(): void;
        abstract getStencilBits(): number;
        hashCode(): number;
        isPurgeable(): boolean;
        unrefCommandBuffer(): void;
        wait(): void;
        abstract isProtected(): boolean;
        setLabel(label: string): void;
        wait(arg0: number): void;
        abstract getDepthBits(): number;
        isDestroyed(): boolean;
        getKey(): Internal.IResourceKey;
        equals(arg0: any): boolean;
        get class(): typeof any
        get label(): string
        get sampleCount(): number
        get uniqueID(): Internal.UniqueID
        get height(): number
        get surfaceFlags(): number
        set key(key: Internal.IResourceKey_)
        get memorySize(): number
        get budgeted(): boolean
        get wrapped(): boolean
        get width(): number
        get context(): icyllis.arc3d.engine.Context
        get backendFormat(): Internal.BackendFormat
        get stencilBits(): number
        get purgeable(): boolean
        get "protected"(): boolean
        set label(label: string)
        get depthBits(): number
        get destroyed(): boolean
        get key(): Internal.IResourceKey
    }
    type GpuSurface_ = GpuSurface;
    class FluidIngredient$FluidStackIngredient extends Internal.FluidIngredient {
        constructor()
        getClass(): typeof any;
        static fromTag(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): Internal.FluidIngredient;
        getRequiredAmount(): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        or(arg0: Internal.Predicate_<Internal.FluidStack>): Internal.Predicate<Internal.FluidStack>;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        getMatchingFluidStacks(): Internal.List<Internal.FluidStack>;
        test(arg0: any): boolean;
        static isFluidIngredient(arg0: Internal.JsonElement_): boolean;
        "test(java.lang.Object)"(arg0: any): boolean;
        and(arg0: Internal.Predicate_<Internal.FluidStack>): Internal.Predicate<Internal.FluidStack>;
        "test(net.minecraftforge.fluids.FluidStack)"(arg0: Internal.FluidStack_): boolean;
        static fromFluidStack(arg0: Internal.FluidStack_): Internal.FluidIngredient;
        static deserialize(arg0: Internal.JsonElement_): Internal.FluidIngredient;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        test(arg0: Internal.FluidStack_): boolean;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        notifyAll(): void;
        serialize(): Internal.JsonObject;
        static read(arg0: Internal.FriendlyByteBuf_): Internal.FluidIngredient;
        hashCode(): number;
        negate(): Internal.Predicate<Internal.FluidStack>;
        wait(): void;
        wait(arg0: number): void;
        static fromFluid(arg0: Internal.Fluid_, arg1: number): Internal.FluidIngredient;
        equals(arg0: any): boolean;
        get class(): typeof any
        get requiredAmount(): number
        get matchingFluidStacks(): Internal.List<Internal.FluidStack>
    }
    type FluidIngredient$FluidStackIngredient_ = FluidIngredient$FluidStackIngredient;
    class SwordEmbryo0Item extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type SwordEmbryo0Item_ = SwordEmbryo0Item;
    class ExtraHoloBuilder {
        constructor(pItem: Internal.Item_)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        setTexture(texture: ResourceLocation_, w: number, h: number, u: number, v: number): void;
        setTexture(texture: ResourceLocation_, u: number, v: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        width: number;
        height: number;
        item: Internal.Item;
        texture: ResourceLocation;
        static ListX: number[];
        static ListY: number[];
        textureX: number;
        itemSupplier: Internal.ItemStack;
        textureY: number;
    }
    type ExtraHoloBuilder_ = ExtraHoloBuilder;
    class OverweightnessMobEffect extends Internal.MobEffect {
        constructor()
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type OverweightnessMobEffect_ = OverweightnessMobEffect;
    abstract class AbstractSoulCandleBlock extends Internal.Block {
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        static extinguish(arg0: Internal.Player_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type AbstractSoulCandleBlock_ = AbstractSoulCandleBlock;
    class DoubleFaceAttachedBlock$DoubleAttachFace extends Internal.Enum<Internal.DoubleFaceAttachedBlock$DoubleAttachFace> implements Internal.StringRepresentable {
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.DoubleFaceAttachedBlock$DoubleAttachFace>>;
        static values(): Internal.DoubleFaceAttachedBlock$DoubleAttachFace[];
        compareTo(arg0: Internal.DoubleFaceAttachedBlock$DoubleAttachFace_): number;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        static valueOf(arg0: string): Internal.DoubleFaceAttachedBlock$DoubleAttachFace;
        toString(): string;
        notifyAll(): void;
        "compareTo(com.simibubi.create.content.redstone.nixieTube.DoubleFaceAttachedBlock$DoubleAttachFace)"(arg0: Internal.DoubleFaceAttachedBlock$DoubleAttachFace_): number;
        name(): string;
        hashCode(): number;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        xRot(): number;
        getDeclaringClass(): typeof Internal.DoubleFaceAttachedBlock$DoubleAttachFace;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.DoubleFaceAttachedBlock$DoubleAttachFace
        static readonly FLOOR: (Internal.DoubleFaceAttachedBlock$DoubleAttachFace) & (Internal.DoubleFaceAttachedBlock$DoubleAttachFace);
        static readonly WALL: (Internal.DoubleFaceAttachedBlock$DoubleAttachFace) & (Internal.DoubleFaceAttachedBlock$DoubleAttachFace);
        static readonly WALL_REVERSED: (Internal.DoubleFaceAttachedBlock$DoubleAttachFace) & (Internal.DoubleFaceAttachedBlock$DoubleAttachFace);
        static readonly CEILING: (Internal.DoubleFaceAttachedBlock$DoubleAttachFace) & (Internal.DoubleFaceAttachedBlock$DoubleAttachFace);
    }
    type DoubleFaceAttachedBlock$DoubleAttachFace_ = "floor" | "ceiling" | "wall_reversed" | "wall" | DoubleFaceAttachedBlock$DoubleAttachFace;
    abstract class ComputePipeline extends Internal.ManagedResource {
        constructor(device: Internal.Device_)
        getClass(): typeof any;
        toString(): string;
        static move<T extends Internal.RefCounted>(sp: T): T;
        getRefCntAcquire(): number;
        notifyAll(): void;
        ref(): void;
        static create<T extends Internal.RefCounted>(sp: T, that: T): T;
        getRefCntVolatile(): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        unref(): void;
        getRefCnt(): number;
        hashCode(): number;
        static move<T extends Internal.RefCounted>(sp: T, that: T): T;
        wait(): void;
        unique(): boolean;
        wait(arg0: number): void;
        static create<T extends Internal.RefCounted>(that: T): T;
        equals(arg0: any): boolean;
        get class(): typeof any
        get refCntAcquire(): number
        get refCntVolatile(): number
        get refCnt(): number
    }
    type ComputePipeline_ = ComputePipeline;
    class Component$BaselineResizeBehavior extends Internal.Enum<Internal.Component$BaselineResizeBehavior> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.Component$BaselineResizeBehavior>>;
        notifyAll(): void;
        static values(): Internal.Component$BaselineResizeBehavior[];
        notify(): void;
        wait(arg0: number, arg1: number): void;
        "compareTo(java.awt.Component$BaselineResizeBehavior)"(arg0: Internal.Component$BaselineResizeBehavior_): number;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        getDeclaringClass(): typeof Internal.Component$BaselineResizeBehavior;
        static valueOf(arg0: string): Internal.Component$BaselineResizeBehavior;
        compareTo(arg0: Internal.Component$BaselineResizeBehavior_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.Component$BaselineResizeBehavior
        static readonly CONSTANT_DESCENT: (Internal.Component$BaselineResizeBehavior) & (Internal.Component$BaselineResizeBehavior);
        static readonly OTHER: (Internal.Component$BaselineResizeBehavior) & (Internal.Component$BaselineResizeBehavior);
        static readonly CENTER_OFFSET: (Internal.Component$BaselineResizeBehavior) & (Internal.Component$BaselineResizeBehavior);
        static readonly CONSTANT_ASCENT: (Internal.Component$BaselineResizeBehavior) & (Internal.Component$BaselineResizeBehavior);
    }
    type Component$BaselineResizeBehavior_ = "other" | "constant_descent" | "constant_ascent" | Component$BaselineResizeBehavior | "center_offset";
    abstract class WaterFluid extends Internal.FlowingFluid {
        constructor()
        getClass(): typeof any;
        getStateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>;
        tick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_): void;
        getFlow(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.FluidState_): Vec3d;
        getHeight(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        canBeReplacedWith(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Fluid_, arg4: Internal.Direction_): boolean;
        abstract isSource(arg0: Internal.FluidState_): boolean;
        getOwnHeight(arg0: Internal.FluidState_): number;
        isEmpty(): boolean;
        notify(): void;
        getFluidType(): Internal.FluidType;
        wait(arg0: number, arg1: number): void;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Fluid>;
        getShape(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        defaultFluidState(): Internal.FluidState;
        getTickDelay(arg0: Internal.LevelReader_): number;
        canConvertToSource(arg0: Internal.FluidState_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
        getDripParticle(): Internal.ParticleOptions;
        abstract getAmount(arg0: Internal.FluidState_): number;
        getSlopeFindDistance(arg0: Internal.LevelReader_): number;
        getSource(arg0: boolean): Internal.FluidState;
        toString(): string;
        getExplosionResistance(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getFlowing(): Internal.Fluid;
        notifyAll(): void;
        getBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: boolean): Internal.BlockPathTypes;
        getBucket(): Internal.Item;
        isSame(arg0: Internal.Fluid_): boolean;
        move(arg0: Internal.FluidState_, arg1: Internal.LivingEntity_, arg2: Vec3d_, arg3: number): boolean;
        canExtinguish(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        shouldUpdateWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_, arg2: Internal.Entity_): boolean;
        animateTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.FluidState_, arg3: Internal.RandomSource_): void;
        getAdjacentBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        hashCode(): number;
        getDropOff(arg0: Internal.LevelReader_): number;
        canHydrate(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_): boolean;
        wait(): void;
        createLegacyBlock(arg0: Internal.FluidState_): Internal.BlockState;
        getFlowing(arg0: number, arg1: boolean): Internal.FluidState;
        wait(arg0: number): void;
        getSource(): Internal.Fluid;
        supportsBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        is(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        get class(): typeof any
        get stateDefinition(): Internal.StateDefinition<Internal.Fluid, Internal.FluidState>
        get empty(): boolean
        get fluidType(): Internal.FluidType
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get dripParticle(): Internal.ParticleOptions
        get flowing(): Internal.Fluid
        get bucket(): Internal.Item
        get source(): Internal.Fluid
    }
    type WaterFluid_ = WaterFluid;
    class TideSwordItem extends Internal.SwordItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        biomancy$getDefaultModifiers(): Internal.Multimap<any, any>;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        getDamage(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getTier(): Internal.Tier;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        get damage(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        get tier(): Internal.Tier
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type TideSwordItem_ = TideSwordItem;
    class MoltengoldShovelItem extends Internal.ShovelItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getAttackDamage(): number;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        static getShovelPathingState(arg0: Internal.BlockState_): Internal.BlockState;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getTier(): Internal.Tier;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get attackDamage(): number
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        get tier(): Internal.Tier
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type MoltengoldShovelItem_ = MoltengoldShovelItem;
    class MonsterSkinItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type MonsterSkinItem_ = MonsterSkinItem;
    abstract class StaticProcessingRecipe implements com.github.elenterius.biomancy.crafting.recipe.ProcessingRecipe {
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getCraftingTimeTicks(arg0: net.minecraft.world.Container_): number;
        isRecipeEqual(arg0: com.github.elenterius.biomancy.crafting.recipe.ProcessingRecipe_): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        abstract matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        toString(): string;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        notifyAll(): void;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        getCraftingCostNutrients(arg0: net.minecraft.world.Container_): number;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type StaticProcessingRecipe_ = StaticProcessingRecipe;
    class SlaverySupervisorUpgradeSmithingTemplate extends Internal.ItemBaseUpgradeSmithingTemplate {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getDisplayName_1(): Internal.MutableComponent;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getDisplayName_0(): Internal.MutableComponent;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        get displayName_1(): Internal.MutableComponent
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get displayName_0(): Internal.MutableComponent
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type SlaverySupervisorUpgradeSmithingTemplate_ = SlaverySupervisorUpgradeSmithingTemplate;
    interface PublicKey extends Internal.Key {
        abstract getAlgorithm(): string;
        abstract getFormat(): string;
        abstract getEncoded(): number[];
        get algorithm(): string
        get format(): string
        get encoded(): number[]
        /**
         * @deprecated
        */
        readonly serialVersionUID: (7187392471159151072) & (number);
    }
    type PublicKey_ = PublicKey;
    class WindKnightSpawnblock2DisplayItem extends Internal.BlockItem implements GeoItem {
        constructor(arg0: Internal.Block_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getTick(arg0: any): number;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isPerspectiveAware(): boolean;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        setAnimData<D>(arg0: Internal.Entity_, arg1: number, arg2: Internal.SerializableDataTicket_<D>, arg3: D): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        "triggerAnim(net.minecraft.world.entity.Entity,long,java.lang.String,java.lang.String)"<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        triggerAnim<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        triggerAnim<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static registerSyncedAnimatable(arg0: Internal.GeoAnimatable_): void;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getBoneResetTime(): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        triggerArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string, arg4: Internal.PacketDistributor$PacketTarget_): void;
        static updateState<T extends Internal.Comparable<T>>(arg0: Internal.BlockState_, arg1: Internal.Property_<T>, arg2: string): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        syncAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>, arg2: D, arg3: Internal.PacketDistributor$PacketTarget_): void;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        static getOrAssignId(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_): number;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static "getId(net.minecraft.world.item.Item)"(arg0: Internal.Item_): number;
        registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        equals(arg0: any): boolean;
        "triggerAnim(long,java.lang.String,java.lang.String,net.minecraftforge.network.PacketDistributor$PacketTarget)"<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>): D;
        shouldPlayAnimsWhileGamePaused(): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        static getId(arg0: Internal.ItemStack_): number;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        static "getId(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        stopTriggeredArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        notify(): void;
        quark$getPlacementState(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(arg0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get perspectiveAware(): boolean
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get boneResetTime(): number
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type WindKnightSpawnblock2DisplayItem_ = WindKnightSpawnblock2DisplayItem;
    class CharmofStealthItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type CharmofStealthItem_ = CharmofStealthItem;
    interface ImageUploadTask$UploadCondition {
        onUploadSubmitted(): boolean;
        abstract needsUpload(arg0: Internal.ImmediateContext_): boolean;
        (arg0: Internal.ImmediateContext): boolean;
        readonly DISCARD: (false) & (boolean);
        readonly PRESERVE: (true) & (boolean);
    }
    type ImageUploadTask$UploadCondition_ = ((arg0: Internal.ImmediateContext)=> boolean) | ImageUploadTask$UploadCondition;
    class AlgorithmParameters {
        getClass(): typeof any;
        static "getInstance(java.lang.String,java.lang.String)"(arg0: string, arg1: string): Internal.AlgorithmParameters;
        toString(): string;
        notifyAll(): void;
        init(arg0: number[], arg1: string): void;
        static getInstance(arg0: string, arg1: string): Internal.AlgorithmParameters;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static "getInstance(java.lang.String,java.security.Provider)"(arg0: string, arg1: Internal.Provider_): Internal.AlgorithmParameters;
        "init(java.security.spec.AlgorithmParameterSpec)"(arg0: Internal.AlgorithmParameterSpec_): void;
        getProvider(): Internal.Provider;
        getAlgorithm(): string;
        getParameterSpec<T extends Internal.AlgorithmParameterSpec>(arg0: T): T;
        getEncoded(arg0: string): number[];
        hashCode(): number;
        init(arg0: Internal.AlgorithmParameterSpec_): void;
        wait(): void;
        wait(arg0: number): void;
        static getInstance(arg0: string): Internal.AlgorithmParameters;
        static getInstance(arg0: string, arg1: Internal.Provider_): Internal.AlgorithmParameters;
        getEncoded(): number[];
        equals(arg0: any): boolean;
        "init(byte[])"(arg0: number[]): void;
        init(arg0: number[]): void;
        get class(): typeof any
        get provider(): Internal.Provider
        get algorithm(): string
        get encoded(): number[]
    }
    type AlgorithmParameters_ = AlgorithmParameters;
    class EnvoyFan extends Internal.Item implements Internal.Vanishable {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getDisplayName(): Internal.MutableComponent;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getRepairIngredient(): Internal.Ingredient;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get displayName(): Internal.MutableComponent
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get repairIngredient(): Internal.Ingredient
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type EnvoyFan_ = EnvoyFan;
    class HazeBlock extends Internal.AbstractGlassBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type HazeBlock_ = HazeBlock;
    class DragonDeathPhase extends Internal.AbstractDragonPhaseInstance {
        constructor(arg0: Internal.EnderDragon_)
        doClientTick(): void;
        getClass(): typeof any;
        onHurt(arg0: DamageSource_, arg1: number): number;
        toString(): string;
        getFlyTargetLocation(): Vec3d;
        getFlySpeed(): number;
        notifyAll(): void;
        begin(): void;
        getPhase(): Internal.EnderDragonPhase<Internal.DragonDeathPhase>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        isSitting(): boolean;
        end(): void;
        wait(): void;
        getTurnSpeed(): number;
        wait(arg0: number): void;
        onCrystalDestroyed(arg0: Internal.EndCrystal_, arg1: BlockPos_, arg2: DamageSource_, arg3: Internal.Player_): void;
        doServerTick(): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get flyTargetLocation(): Vec3d
        get flySpeed(): number
        get phase(): Internal.EnderDragonPhase<Internal.DragonDeathPhase>
        get sitting(): boolean
        get turnSpeed(): number
    }
    type DragonDeathPhase_ = DragonDeathPhase;
    abstract class ForwardingMultimap <K, V> extends Internal.ForwardingObject implements Internal.Multimap<K, V> {
        getClass(): typeof any;
        replaceValues(arg0: K, arg1: Internal.Iterable_<V>): Internal.Collection<V>;
        removeAll(arg0: any): Internal.Collection<V>;
        entries(): Internal.Collection<Internal.Map$Entry<K, V>>;
        containsValue(arg0: any): boolean;
        isEmpty(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        containsKey(arg0: any): boolean;
        putAll(arg0: K, arg1: Internal.Iterable_<V>): boolean;
        keys(): Internal.Multiset<K>;
        keySet(): Internal.Set<K>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        get(arg0: K): Internal.Collection<V>;
        toString(): string;
        values(): Internal.Collection<V>;
        notifyAll(): void;
        remove(arg0: any, arg1: any): boolean;
        containsEntry(arg0: any, arg1: any): boolean;
        hashCode(): number;
        size(): number;
        putAll(arg0: Internal.Multimap_<K, V>): boolean;
        put(arg0: K, arg1: V): boolean;
        wait(): void;
        clear(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        asMap(): Internal.Map<K, Internal.Collection<V>>;
        get class(): typeof any
        get empty(): boolean
    }
    type ForwardingMultimap_<K, V> = ForwardingMultimap<K, V>;
    interface Pack$ResourcesSupplier {
        abstract open(arg0: string): Internal.PackResources;
        (arg0: string): Internal.PackResources_;
    }
    type Pack$ResourcesSupplier_ = ((arg0: string)=> Internal.PackResources_) | Pack$ResourcesSupplier;
    class Axolotl extends Internal.Animal implements Internal.Bucketable, Internal.VariantHolder<Internal.Axolotl$Variant>, Internal.LerpingModel {
        constructor(arg0: Internal.EntityType_<Internal.Axolotl>, arg1: Internal.Level_)
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        static checkMobSpawnRules(arg0: Internal.EntityType_<Internal.Mob>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isSuppressingBounce(): boolean;
        static onStopAttacking(arg0: Internal.Axolotl_, arg1: Internal.LivingEntity_): void;
        setTarget(arg0: Internal.LivingEntity_): void;
        isOnFire(): boolean;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        convertTo<T extends Internal.Mob>(arg0: Internal.EntityType_<T>, arg1: boolean): T;
        getFallFlyingTicks(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        dropLeash(arg0: boolean, arg1: boolean): void;
        gameEvent(arg0: Internal.GameEvent_): void;
        setXxa(arg0: number): void;
        setDelayedLeashHolderId(arg0: number): void;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        setMotionZ(z: number): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        getBlockY(): number;
        isSpectator(): boolean;
        setMainHandItem(item: Internal.ItemStack_): void;
        removeEffectNoUpdate(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getHealth(): number;
        getMaxHealth(): number;
        setPathfindingMalus(arg0: Internal.BlockPathTypes_, arg1: number): void;
        isRegisteredToWorld(): boolean;
        redirect$bjn000$apoth_sunderingGetAmplifier(arg0: Internal.MobEffectInstance_): number;
        getRandomZ(arg0: number): number;
        pehkui_getOnGround(): boolean;
        setAggressive(arg0: boolean): void;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        biomancy$setForcedAge(arg0: number): void;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        setZza(arg0: number): void;
        getBlock(): Internal.BlockContainerJS;
        redirect$bjn000$apoth_applyArmorPen(arg0: number, arg1: number, arg2: number, arg3: DamageSource_, arg4: number): number;
        setEquipment(slot: EquipmentSlot_, item: Internal.ItemStack_): void;
        randomTeleport(arg0: number, arg1: number, arg2: number, arg3: boolean): boolean;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        playAmbientSound(): void;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        getArmorValue(): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        "setVariant(net.minecraft.world.entity.animal.axolotl.Axolotl$Variant)"(arg0: Internal.Axolotl$Variant_): void;
        getKillCredit(): Internal.LivingEntity;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        sinkInFluid(arg0: Internal.FluidType_): void;
        hasPermissions(arg0: number): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        pehkui_readScaleNbt(nbt: Internal.CompoundTag_): void;
        bo$refreshEntityData(data: number): void;
        static createMobAttributes(): Internal.AttributeSupplier$Builder;
        isAutoSpinAttack(): boolean;
        getRemainingFireTicks(): number;
        handler$daa000$onClientRemoval(ci: Internal.CallbackInfo_): void;
        onlyOpCanSetNbt(): boolean;
        handler$cme000$heal(arg0: number, arg1: Internal.CallbackInfo_): void;
        handler$dad000$getMainArm(cir: Internal.CallbackInfoReturnable_<any>): void;
        fireImmune(): boolean;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        getMaxFallDistance(): number;
        isHolding(arg0: Internal.Item_): boolean;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        static areAllEffectsAmbient(arg0: Internal.Collection_<Internal.MobEffectInstance>): boolean;
        doHurtTarget(arg0: Internal.Entity_): boolean;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        create$callSpawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
        handler$daa000$playerTouch(pPlayer: Internal.Player_, ci: Internal.CallbackInfo_): void;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        handler$daa000$getMaxFallDistance(cir: Internal.CallbackInfoReturnable_<any>): void;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        getVoicePitch(): number;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        setSleepingPos(arg0: BlockPos_): void;
        localvar$dng000$fluidCollision(arg0: Vec3d_): Vec3d;
        isDescending(): boolean;
        getAttributeBaseValue(arg0: Internal.Attribute_): number;
        sendEffectToPassengers(arg0: Internal.MobEffectInstance_): void;
        getHeadRotSpeed(): number;
        getYHeadRot(): number;
        getProjectile(arg0: Internal.ItemStack_): Internal.ItemStack;
        damageEquipment(slot: EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        setAbsorptionAmount(arg0: number): void;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        removeAllGoals(arg0: Internal.Predicate_<Internal.Goal>): void;
        swing(): void;
        handler$dad000$canPickUpLoot(cir: Internal.CallbackInfoReturnable_<any>): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        handler$bnk000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        canStartSwimming(): boolean;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        isBaby(): boolean;
        damageEquipment(slot: EquipmentSlot_): void;
        setFireType(arg0: ResourceLocation_): void;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        canBreatheUnderwater(): boolean;
        getWalkTargetValue(arg0: BlockPos_): number;
        die(arg0: DamageSource_): void;
        removeAllEffects(): boolean;
        handler$dnj000$CMcanAttack(arg0: Internal.LivingEntity_, arg1: Internal.CallbackInfoReturnable_<any>): void;
        getLeashOffset(): Vec3d;
        hasLineOfSight(arg0: Internal.Entity_): boolean;
        handler$dad000$ate(ci: Internal.CallbackInfo_): void;
        onClimbable(): boolean;
        isAttackable(): boolean;
        getSlot(arg0: number): Internal.SlotAccess;
        jerotes_$summon(arg0: Internal.VariantZsieinEntity_, arg1: Internal.ServerLevel_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        pehkui_constructScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isUnderWater(): boolean;
        stopRiding(): void;
        getLeashHolder(): Internal.Entity;
        getX(arg0: number): number;
        getSensing(): Internal.Sensing;
        getLegsArmorItem(): Internal.ItemStack;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        canTakeItem(arg0: Internal.ItemStack_): boolean;
        shouldDropExperience(): boolean;
        hasPassenger(arg0: Internal.Entity_): boolean;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        getLootTable(): ResourceLocation;
        getTicksUsingItem(): number;
        getArrowCount(): number;
        create$callSetLevel(arg0: Internal.Level_): void;
        getMoveControl(): Internal.MoveControl;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        getBrain(): Internal.Brain<Internal.Axolotl>;
        handler$daa000$rideTick(ci: Internal.CallbackInfo_): void;
        getDefaultMovementSpeed(): number;
        restoreFrom(arg0: Internal.Entity_): void;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        addEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): boolean;
        ate(): void;
        setPos(arg0: number, arg1: number, arg2: number): void;
        notify(): void;
        getFirstTick(): boolean;
        setPersistenceRequired(): void;
        getLastHurtByMobTimestamp(): number;
        getVehicle(): Internal.Entity;
        canFallInLove(): boolean;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        setSpawnCancelled(arg0: boolean): void;
        getStringUuid(): string;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getMainArm(): Internal.HumanoidArm;
        checkSpawnRules(arg0: Internal.LevelAccessor_, arg1: Internal.MobSpawnType_): boolean;
        getRotationVector(): Internal.Vec2;
        abstract sdl$getDynamicLightY(): number;
        getHurtDir(): number;
        isSprinting(): boolean;
        isMaxGroupSizeReached(arg0: number): boolean;
        handler$daa000$canChangeDimensions(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionY(): number;
        getOffhandItem(): Internal.ItemStack;
        canCollideWith(arg0: Internal.Entity_): boolean;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        clearSleepingPos(): void;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        getLastHurtMob(): Internal.LivingEntity;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        handler$daa000$getMyRidingOffset(cir: Internal.CallbackInfoReturnable_<any>): void;
        getLastDamageSource(): DamageSource;
        getSoundSource(): Internal.SoundSource;
        setNoActionTime(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        equipmentHasChanged(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getPose(): Internal.Pose;
        getAttribute(arg0: Internal.Attribute_): Internal.AttributeInstance;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        canBeAffected(arg0: Internal.MobEffectInstance_): boolean;
        ageUp(arg0: number): void;
        quark$lastHurtByPlayer(): Internal.Player;
        handler$daa000$isPickable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getRestrictCenter(): BlockPos;
        isLeftHanded(): boolean;
        removeVehicle(): void;
        setZ(z: number): void;
        getY(): number;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        finalizeSpawnChildFromBreeding(arg0: Internal.ServerLevel_, arg1: Internal.Animal_, arg2: Internal.AgeableMob_): void;
        eat(arg0: Internal.Level_, arg1: Internal.ItemStack_): Internal.ItemStack;
        bookshelf$makePoofParticles(): void;
        getPickupSound(): Internal.SoundEvent;
        isWithinMeleeAttackRange(arg0: Internal.LivingEntity_): boolean;
        broadcastBreakEvent(arg0: EquipmentSlot_): void;
        handler$daa000$isInvulnerableTo(pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        isBlocking(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        isPushedByFluid(): boolean;
        getArmorCoverPercentage(): number;
        handleRelativeFrictionAndCalculateMovement(arg0: Vec3d_, arg1: number): Vec3d;
        turn(arg0: number, arg1: number): void;
        applySupportingEffects(arg0: Internal.Player_): void;
        getAirSupply(): number;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isAnimal(): boolean;
        isPlayer(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        sdl$isDynamicLightEnabled(): boolean;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        jumpInFluid(arg0: Internal.FluidType_): void;
        getCommandSenderWorld(): Internal.Level;
        quark$lastHurtByPlayerTime(): number;
        getTotalMovementSpeed(): number;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3d_, arg2: number): boolean;
        fromBucket(): boolean;
        pehkui_shouldIgnoreScaleNbt(): boolean;
        isMoving(): boolean;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getAttributes(): Internal.AttributeMap;
        isSpawnCancelled(): boolean;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        spawnChildFromBreeding(arg0: Internal.ServerLevel_, arg1: Internal.Animal_): void;
        setInLoveTime(arg0: number): void;
        abstract sdl$getDynamicLightX(): number;
        isSwimming(): boolean;
        setSprinting(arg0: boolean): void;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        addSyncedData(type: Internal.EntitySerializerType_, key: string, value: any): void;
        static checkAxolotlSpawnRules(arg0: Internal.EntityType_<Internal.LivingEntity>, arg1: Internal.ServerLevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        setPortalCooldown(): void;
        getAttackAnim(arg0: number): number;
        setX(x: number): void;
        handler$dad000$getAmbientSoundInterval(cir: Internal.CallbackInfoReturnable_<any>): void;
        getPortalWaitTime(): number;
        getBlockStateOn(): Internal.BlockState;
        getItemBySlot(arg0: EquipmentSlot_): Internal.ItemStack;
        wantsToPickUp(arg0: Internal.ItemStack_): boolean;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(x: number, y: number, z: number, yaw: number, pitch: number): void;
        handler$bbl000$curio$canFreeze(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isInvisibleTo(arg0: Internal.Player_): boolean;
        handler$dad003$mobInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        stopSleeping(): void;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        isUndead(): boolean;
        static createLivingAttributes(): Internal.AttributeSupplier$Builder;
        pehkui_getScales(): Internal.Map<any, any>;
        getStepHeight(): number;
        setRegisteredToWorld(navigation: Internal.PathNavigation_): void;
        isSleeping(): boolean;
        stopUsingItem(): void;
        acceptsFailure(): boolean;
        pehkui_setShouldIgnoreScaleNbt(ignore: boolean): void;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        getFluidFallingAdjustedMovement(arg0: number, arg1: boolean, arg2: Vec3d_): Vec3d;
        setOldPosAndRot(): void;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        getDismountPoses(): Internal.ImmutableList<Internal.Pose>;
        getLastHurtMobTimestamp(): number;
        getMobSpawnType(): Internal.MobSpawnType;
        lithiumOnEquipmentChanged(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setCanPickUpLoot(arg0: boolean): void;
        getMainHandItem(): Internal.ItemStack;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        handler$dad000$setTarget(pTarget: Internal.LivingEntity_, ci: Internal.CallbackInfo_): void;
        getFireType(): ResourceLocation;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        canBeSeenAsEnemy(): boolean;
        handler$daa000$onAddedToWorld(ci: Internal.CallbackInfo_): void;
        setLeftHanded(arg0: boolean): void;
        getActiveEffects(): Internal.Collection<Internal.MobEffectInstance>;
        handler$cln000$setRemoved(arg0: Internal.Entity$RemovalReason_, arg1: Internal.CallbackInfo_): void;
        isOnPortalCooldown(): boolean;
        canAttack(arg0: Internal.LivingEntity_, arg1: Internal.TargetingConditions_): boolean;
        setUranusEntityData(nbt: Internal.CompoundTag_): void;
        getAttributeValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        /**
         * @deprecated
        */
        static saveDefaultDataToBucketTag(arg0: Internal.Mob_, arg1: Internal.ItemStack_): void;
        handler$daa000$lavaHurt(ci: Internal.CallbackInfo_): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        getParts(): Internal.PartEntity<any>[];
        isUsingItem(): boolean;
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        handler$dgn000$increaseAirSupply(arg0: number, arg1: Internal.CallbackInfoReturnable_<any>): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getForgePersistentData(): Internal.CompoundTag;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        canMate(arg0: Internal.Animal_): boolean;
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        "broadcastBreakEvent(net.minecraft.world.entity.EquipmentSlot)"(arg0: EquipmentSlot_): void;
        setLeashedTo(arg0: Internal.Entity_, arg1: boolean): void;
        isAlive(): boolean;
        biomancy$setMoveControl(arg0: Internal.MoveControl_): void;
        startSleeping(arg0: BlockPos_): void;
        getBbHeight(): number;
        getMeleeAttackRangeSqr(arg0: Internal.LivingEntity_): number;
        handler$daa000$push(pEntity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        bookshelf$getDrinkingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        handler$dad000$isPersistenceRequired(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTags(): Internal.Set<string>;
        getViewVector(arg0: number): Vec3d;
        getLastAttacker(): Internal.LivingEntity;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        onPathfindingStart(): void;
        getPercentFrozen(): number;
        setPortalCooldown(arg0: number): void;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        isLeashed(): boolean;
        addEffect(arg0: Internal.MobEffectInstance_): boolean;
        getVariant(): any;
        ageUp(arg0: number, arg1: boolean): void;
        handler$eoj001$canAttack(arg0: Internal.LivingEntity_, arg1: Internal.CallbackInfoReturnable_<any>): void;
        handler$daa000$canCollideWith(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        canRiderInteract(): boolean;
        getViewXRot(arg0: number): number;
        biomancy$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        setPose(arg0: Internal.Pose_): void;
        getReachDistance(): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        pehkui_getScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getBreedOffspring(arg0: Internal.ServerLevel_, arg1: Internal.AgeableMob_): Internal.AgeableMob;
        saveToBucketTag(arg0: Internal.ItemStack_): void;
        biomancy$getForcedAge(): number;
        setLastHurtByPlayer(arg0: Internal.Player_): void;
        "getServer()"(): Internal.MinecraftServer;
        mobInteract(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        wasExperienceConsumed(): boolean;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        foodEaten(is: Internal.ItemStack_): void;
        onClientRemoval(): void;
        self(): Internal.LivingEntity;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        handler$daa000$isCurrentlyGlowing(cir: Internal.CallbackInfoReturnable_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        handler$dad000$getMeleeAttackRangeSqr(pEntity: Internal.LivingEntity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        abstract sdl$resetDynamicLight(): void;
        calculateEntityAnimation(arg0: boolean): void;
        forceAddEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): void;
        handler$dlf000$onRemove(ci: Internal.CallbackInfo_): void;
        setChestArmorItem(item: Internal.ItemStack_): void;
        abstract sodiumdynamiclights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        bookshelf$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        onAboveBubbleCol(arg0: boolean): void;
        handler$dad000$canHoldItem(pStack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        isSensitiveToWater(): boolean;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        "getAttributeValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        getJumpControl(): Internal.JumpControl;
        handler$daa000$onInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getFeetArmorItem(): Internal.ItemStack;
        static getViewScale(): number;
        getVisualRotationYInDegrees(): number;
        setSpeed(arg0: number): void;
        canAddPassengerJerotes(arg0: Internal.Entity_): boolean;
        requiresCustomPersistence(): boolean;
        isDiscrete(): boolean;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        biomancy$setJumpControl(arg0: Internal.JumpControl_): void;
        static bucketMobPickup<T extends Internal.LivingEntity & Internal.Bucketable>(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: T): Internal.Optional<Internal.InteractionResult>;
        getCombatTracker(): Internal.CombatTracker;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        canBreed(): boolean;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        isNoAi(): boolean;
        handler$daa000$mayInteract(pLevel: Internal.Level_, pPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: EquipmentSlot_, amount: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        biomancy$getDeathSound(): Internal.SoundEvent;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        indicateDamage(arg0: number, arg1: number): void;
        canBeSeenByAnyone(): boolean;
        setVariant(arg0: any): void;
        isFullyFrozen(): boolean;
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getScale(): number;
        isSuppressingSlidingDownLadder(): boolean;
        getBlockZ(): number;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(arg0: Internal.SoundEvent_): void;
        getPitch(): number;
        getPathfindingMalus(arg0: Internal.BlockPathTypes_): number;
        getRandom(): Internal.RandomSource;
        canReplaceEqualItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        rotate(arg0: Internal.Rotation_): number;
        shouldRiderFaceForward(arg0: Internal.Player_): boolean;
        getPassengersAndSelf(): Internal.Stream<any>;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        "getAttributeBaseValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        clearRestriction(): void;
        biomancy$getAmbientSound(): Internal.SoundEvent;
        "self()"(): Internal.LivingEntity;
        getModelRotationValues(): Internal.Map<string, Vec3f>;
        getAge(): number;
        rayTrace(): Internal.RayTraceResultJS;
        alwaysAccepts(): boolean;
        handler$daa000$thunderHit(pLevel: Internal.ServerLevel_, pLightning: Internal.LightningBolt_, ci: Internal.CallbackInfo_): void;
        "isHolding(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        handler$daa000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getNoActionTime(): number;
        isVisuallyCrawling(): boolean;
        isAggressive(): boolean;
        setYya(arg0: number): void;
        handler$dac000$brainProvider(cir: Internal.CallbackInfoReturnable_<any>): void;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        abstract sdl$shouldUpdateDynamicLight(): boolean;
        setDropChance(arg0: EquipmentSlot_, arg1: number): void;
        "broadcastBreakEvent(net.minecraft.world.InteractionHand)"(arg0: Internal.InteractionHand_): void;
        handler$daa000$setSprinting(pSprinting: boolean, ci: Internal.CallbackInfo_): void;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        isFood(arg0: Internal.ItemStack_): boolean;
        setBaby(arg0: boolean): void;
        getLastHurtByMob(): Internal.LivingEntity;
        pehkui_setScaleCache(scaleCache: Internal.ScaleData_[]): void;
        isInWaterOrBubble(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        getPortalCooldown(): number;
        setSyncedData(key: string, value: any): void;
        getItem(): Internal.ItemStack;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        releaseUsingItem(): void;
        getPosition(arg0: number): Vec3d;
        removeFreeWill(): void;
        removeWhenFarAway(arg0: number): boolean;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        setRecordPlayingNearby(arg0: BlockPos_, arg1: boolean): void;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        hasItemInSlot(arg0: EquipmentSlot_): boolean;
        canUpdate(arg0: boolean): void;
        getEyeInFluidType(): Internal.FluidType;
        distanceToSqr(arg0: Vec3d_): number;
        handler$ehh000$onEntityFall(fallDistance: number, multiplier: number, source: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$daa000$dampensVibrations(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSteppingCarefully(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        getBlockX(): number;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        handler$daa000$causeFallDamage(pFallDistance: number, pMultiplier: number, pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isFallFlying(): boolean;
        getEncodeId(): string;
        getY(arg0: number): number;
        redirect$bjn000$apoth_applyProtPen(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        getMaxHeadXRot(): number;
        getNbt(): Internal.CompoundTag;
        handler$dad000$removeWhenFarAway(pDistanceToClosestPlayer: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        setInvisible(arg0: boolean): void;
        getEffect(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        setTotalMovementSpeedMultiplier(speed: number): void;
        setHealth(arg0: number): void;
        handler$dlf002$onTick(ci: Internal.CallbackInfo_): void;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        setDiscardFriction(arg0: boolean): void;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        handler$daa000$isFreezing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getYaw(): number;
        swing(arg0: Internal.InteractionHand_, arg1: boolean): void;
        getUsedItemHand(): Internal.InteractionHand;
        setDefaultMovementSpeed(speed: number): void;
        canAttackType(arg0: Internal.EntityType_<any>): boolean;
        setPlayingDead(arg0: boolean): void;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        setCustomNameVisible(arg0: boolean): void;
        isAlliedTo(arg0: Internal.Team_): boolean;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        handler$dad002$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        getControllingPassenger(): Internal.LivingEntity;
        canFireProjectileWeapon(arg0: Internal.ProjectileWeaponItem_): boolean;
        getScriptType(): Internal.ScriptType;
        shouldDiscardFriction(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        serializeNBT(): Internal.Tag;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        pehkui_isFirstUpdate(): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        handler$daa000$canFreeze(cir: Internal.CallbackInfoReturnable_<any>): void;
        getEyeY(): number;
        skipDropExperience(): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        setItemSlot(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): void;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        abstract sodiumdynamiclights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        isAffectedByPotions(): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getCitadelEntityData(): Internal.CompoundTag;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        static getEquipmentForSlot(arg0: EquipmentSlot_, arg1: number): Internal.Item;
        isWithinRestriction(arg0: BlockPos_): boolean;
        handler$daa000$entityJs$tick(ci: Internal.CallbackInfo_): void;
        handler$daa001$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTeam(): Internal.Team;
        handler$daa000$stopRiding(ci: Internal.CallbackInfo_): void;
        setTicksFrozen(arg0: number): void;
        handler$dac000$makeBrain(pDynamic: Internal.Dynamic_<any>, cir: Internal.CallbackInfoReturnable_<any>): void;
        getUseItem(): Internal.ItemStack;
        getMyRidingOffset(): number;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        hasCustomName(): boolean;
        getSwimAmount(arg0: number): number;
        isLiving(): boolean;
        getX(): number;
        isVehicle(): boolean;
        /**
         * @deprecated
        */
        static loadDefaultDataFromBucketTag(arg0: Internal.Mob_, arg1: Internal.CompoundTag_): void;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        redirect$bjn000$apoth_sunderingApplyEffect(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        getTeamId(): string;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        setStingerCount(arg0: number): void;
        getMaxHeadYRot(): number;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        getLootTableSeed(): number;
        localvar$bjk000$apoth_checkFallDamageWithGravity(arg0: number): number;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        canBeLeashed(arg0: Internal.Player_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        sdl$dynamicLightTick(): void;
        bookshelf$getFallDamageSound(arg0: number): Internal.SoundEvent;
        handleInsidePortal(arg0: BlockPos_): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        biomancy$getVoicePitch(): number;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        isOnRails(): boolean;
        handler$daa000$canTrample(state: Internal.BlockState_, pos: BlockPos_, fallDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        getStingerCount(): number;
        getFallSounds(): Internal.LivingEntity$Fallsounds;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        getDimensionChangingDelay(): number;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        isPathFinding(): boolean;
        isRemoved(): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        spawnAnim(): void;
        getJumpBoostPower(): number;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        pehkui_writeScaleNbt(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        refreshDimensions(): void;
        handler$daa000$isAttackable(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$dac000$getMobType(cir: Internal.CallbackInfoReturnable_<any>): void;
        bookshelf$getAmbientSound(): Internal.SoundEvent;
        "getAttributeValue(net.minecraft.world.entity.ai.attributes.Attribute)"(arg0: Internal.Attribute_): number;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        "isHolding(net.minecraft.world.item.Item)"(arg0: Internal.Item_): boolean;
        setShiftKeyDown(arg0: boolean): void;
        getEyePosition(arg0: number): Vec3d;
        getPassengers(): Internal.EntityArrayList;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        handler$dad000$canTakeItem(pItemstack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getAttributeBaseValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        getServer(): Internal.MinecraftServer;
        getExperienceReward(): number;
        getFirstPassenger(): Internal.Entity;
        heal(arg0: number): void;
        getSpawnType(): Internal.MobSpawnType;
        setLastHurtMob(arg0: Internal.Entity_): void;
        setLastHurtByMob(arg0: Internal.LivingEntity_): void;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        abstract sdl$getDynamicLightLevel(): Internal.Level;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        canStandOnFluid(arg0: Internal.FluidState_): boolean;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getSleepingPos(): Internal.Optional<any>;
        touchingUnloadedChunk(): boolean;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        abstract sdl$getDynamicLightZ(): number;
        getLookAngle(): Vec3d;
        getAmbientSoundInterval(): number;
        setArrowCount(arg0: number): void;
        getMotionZ(): number;
        isPersistenceRequired(): boolean;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        handler$cme000$shouldDropExperience(arg0: Internal.CallbackInfoReturnable_<any>): void;
        getBedOrientation(): Internal.Direction;
        ejectPassengers(): void;
        removeEffect(arg0: Internal.MobEffect_): boolean;
        getProfile(): Internal.GameProfile;
        setInLove(arg0: Internal.Player_): void;
        getUranusEntityData(): Internal.CompoundTag;
        isDeadOrDying(): boolean;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        static setViewScale(arg0: number): void;
        take(arg0: Internal.Entity_, arg1: number): void;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        biomancy$getSoundVolume(): number;
        getLookControl(): Internal.LookControl;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        setFromBucket(arg0: boolean): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        canAttack(arg0: Internal.LivingEntity_): boolean;
        static getSpeedUpSecondsWhenFeeding(arg0: number): number;
        getOffHandItem(): Internal.ItemStack;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        handler$fdn000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isOnScoreboardTeam(teamId: string): boolean;
        redirect$bjn000$apoth_sunderingHasEffect(arg0: Internal.LivingEntity_, arg1: Internal.MobEffect_): boolean;
        startUsingItem(arg0: Internal.InteractionHand_): void;
        position(): Vec3d;
        biomancy$random(): Internal.RandomSource;
        handler$daa000$shouldRenderAtSqrDistance(pDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        static getEquipmentSlotForItem(arg0: Internal.ItemStack_): EquipmentSlot;
        getEquipment(slot: EquipmentSlot_): Internal.ItemStack;
        displayFireAnimation(): boolean;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        "getAttributeBaseValue(net.minecraft.world.entity.ai.attributes.Attribute)"(attribute: Internal.Attribute_): number;
        onLeaveCombat(): void;
        handler$daa000$move(pType: Internal.MoverType_, pPos: Vec3d_, ci: Internal.CallbackInfo_): void;
        setY(y: number): void;
        getAttributeValue(arg0: Internal.Attribute_): number;
        getFeetBlockState(): Internal.BlockState;
        handler$bjn000$apoth_onEffectUpdateRemoveAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        isWithinRestriction(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        setSharedFlag(arg0: number, arg1: boolean): void;
        entityJs$defineSynchedData(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        damageHeldItem(): void;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        handler$cme000$checkFallDamage(arg0: number, arg1: boolean, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.CallbackInfo_): void;
        getMaxAirSupply(): number;
        isVisuallySwimming(): boolean;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        entityJs$getTypeId(): string;
        setItemInHand(arg0: Internal.InteractionHand_, arg1: Internal.ItemStack_): void;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        setAge(arg0: number): void;
        getTarget(): Internal.LivingEntity;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        restrictTo(arg0: BlockPos_, arg1: number): void;
        isInLove(): boolean;
        handler$cme001$hurt(arg0: DamageSource_, arg1: number, arg2: Internal.CallbackInfoReturnable_<any>): void;
        handler$dae000$getWalkTargetValue(pPos: BlockPos_, pLevel: Internal.LevelReader_, cir: Internal.CallbackInfoReturnable_<any>): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        isInWater(): boolean;
        finalizeSpawn(arg0: Internal.ServerLevelAccessor_, arg1: Internal.DifficultyInstance_, arg2: Internal.MobSpawnType_, arg3: Internal.SpawnGroupData_, arg4: Internal.CompoundTag_): Internal.SpawnGroupData;
        pehkui_getScaleCache(): Internal.ScaleData[];
        swing(arg0: Internal.InteractionHand_): void;
        hasEffect(arg0: Internal.MobEffect_): boolean;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getRootVehicle(): Internal.Entity;
        onPathfindingDone(): void;
        save(arg0: Internal.CompoundTag_): boolean;
        handler$daa000$onRemovedFromWorld(ci: Internal.CallbackInfo_): void;
        getLocalBoundsForPose(arg0: Internal.Pose_): Internal.AABB;
        sdl$getLuminance(): number;
        isNoGravity(): boolean;
        curePotionEffects(arg0: Internal.ItemStack_): boolean;
        onItemPickup(arg0: Internal.ItemEntity_): void;
        setCitadelEntityData(arg0: Internal.CompoundTag_): void;
        handler$bjn000$apoth_onEffectUpdateAddAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        resetLove(): void;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        updateSwimming(): void;
        isHolding(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getSpeed(): number;
        abstract getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        wait(): void;
        addSyncedData(identifier: string, value: any): void;
        getUuid(): Internal.UUID;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        setNoAi(arg0: boolean): void;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        shouldShowName(): boolean;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        handler$daa000$lerpTo(x: number, y: number, z: number, yaw: number, pitch: number, posRotationIncrements: number, teleport: boolean, ci: Internal.CallbackInfo_): void;
        canPickUpLoot(): boolean;
        kill(): void;
        onEnterCombat(): void;
        updateNavigationRegistration(): void;
        animateHurt(arg0: number): void;
        static resetForwardDirectionOfRelativePortalPosition(arg0: Vec3d_): Vec3d;
        brainProvider(): Internal.Brain$Provider<any>;
        hasRestriction(): boolean;
        handler$dad000$canBeLeashed(pPlayer: Internal.Player_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getHeadArmorItem(): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        deserializeNBT(arg0: Internal.Tag_): void;
        setVariant(arg0: Internal.Axolotl$Variant_): void;
        revive(): void;
        getBbWidth(): number;
        handler$eig000$onEatGoldenCarrot(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.ItemStack_, arg3: Internal.CallbackInfo_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        addDeltaMovement(arg0: Vec3d_): void;
        pehkui_setOnGround(onGround: boolean): void;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        "getName()"(): net.minecraft.network.chat.Component;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        knockback(arg0: number, arg1: number, arg2: number): void;
        getTicksRequiredToFreeze(): number;
        getVisibilityPercent(arg0: Internal.Entity_): number;
        isPlayingDead(): boolean;
        getMaxSpawnClusterSize(): number;
        getUsername(): string;
        getInLoveTime(): number;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        "setVariant(java.lang.Object)"(arg0: any): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        onRemovedFromWorld(): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        setJumping(arg0: boolean): void;
        rehydrate(): void;
        getPickResult(): Internal.ItemStack;
        "getMainHandItem()"(): Internal.ItemStack;
        getAbsorptionAmount(): number;
        getRandomY(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        loadFromBucketTag(arg0: Internal.CompoundTag_): void;
        getMobType(): Internal.MobType;
        travel(arg0: Vec3d_): void;
        getItemInHand(arg0: Internal.InteractionHand_): Internal.ItemStack;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        shouldBeSaved(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        canSpawnSoulSpeedParticle(): boolean;
        getSyncedData(identifier: string): any;
        notifyAll(): void;
        aiStep(): void;
        getPassengersRidingOffset(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        isFrame(): boolean;
        broadcastBreakEvent(arg0: Internal.InteractionHand_): void;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        discard(): void;
        handler$daa000$showVehicleHealth(cir: Internal.CallbackInfoReturnable_<any>): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        setNoGravity(arg0: boolean): void;
        getUseItemRemainingTicks(): number;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        getBucketItemStack(): Internal.ItemStack;
        attackable(): boolean;
        createCommandSourceStack(): Internal.CommandSourceStack;
        getNavigation(): Internal.PathNavigation;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        pehkui_setShouldSyncScales(sync: boolean): void;
        getLoveCause(): Internal.ServerPlayer;
        getLastClimbablePos(): Internal.Optional<BlockPos>;
        getEatingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        getPerceivedTargetDistanceSquareForMeleeAttack(arg0: Internal.LivingEntity_): number;
        getHorizontalFacing(): Internal.Direction;
        setId(arg0: number): void;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        static checkAnimalSpawnRules(arg0: Internal.EntityType_<Internal.Animal>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        isDamageSourceBlocked(arg0: DamageSource_): boolean;
        getLightProbePosition(arg0: number): Vec3d;
        getActiveEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>;
        onEquipItem(arg0: EquipmentSlot_, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
        checkDespawn(): void;
        pehkui_shouldSyncScales(): boolean;
        getWalkTargetValue(arg0: BlockPos_, arg1: Internal.LevelReader_): number;
        lookAt(arg0: Internal.Entity_, arg1: number, arg2: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        equipItemIfPossible(arg0: Internal.ItemStack_): Internal.ItemStack;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        canDisableShield(): boolean;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        bookshelf$getDeathSound(): Internal.SoundEvent;
        wait(arg0: number, arg1: number): void;
        getTeamColor(): number;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listenForCachedBlockChanges: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        handler$dad000$doHurtTarget(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        checkSpawnObstruction(arg0: Internal.LevelReader_): boolean;
        extinguish(): void;
        getRestrictRadius(): number;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "swing(net.minecraft.world.InteractionHand)"(arg0: Internal.InteractionHand_): void;
        getRegisteredNavigation(): Internal.PathNavigation;
        isInvertedHealAndHarm(): boolean;
        canHoldItem(arg0: Internal.ItemStack_): boolean;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        handler$bjn000$apoth_ownedAttrMap(arg0: Internal.EntityType_<any>, arg1: Internal.Level_, arg2: Internal.CallbackInfo_): void;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        runCommand(command: string): number;
        setGuaranteedDrop(arg0: EquipmentSlot_): void;
        setSharedFlagOnFire(arg0: boolean): void;
        set defaultMovementSpeedMultiplier(speed: number)
        get suppressingBounce(): boolean
        set target(arg0: Internal.LivingEntity_)
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        set maxUpStep(arg0: number)
        get fallFlyingTicks(): number
        set xxa(arg0: number)
        set delayedLeashHolderId(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        set mainHandItem(item: Internal.ItemStack_)
        get persistentData(): Internal.CompoundTag
        get health(): number
        get maxHealth(): number
        get registeredToWorld(): boolean
        set aggressive(arg0: boolean)
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        set zza(arg0: number)
        get block(): Internal.BlockContainerJS
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get armorValue(): number
        set "variant(net.minecraft.world.entity.animal.axolotl.Axolotl$Variant)"(arg0: Internal.Axolotl$Variant_)
        get killCredit(): Internal.LivingEntity
        get autoSpinAttack(): boolean
        get remainingFireTicks(): number
        get maxFallDistance(): number
        get ticksFrozen(): number
        get voicePitch(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set sleepingPos(arg0: BlockPos_)
        get descending(): boolean
        get headRotSpeed(): number
        get YHeadRot(): number
        set absorptionAmount(arg0: number)
        set deltaMovement(arg0: Vec3d_)
        get baby(): boolean
        set fireType(arg0: ResourceLocation_)
        get glowing(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        get underWater(): boolean
        get leashHolder(): Internal.Entity
        get sensing(): Internal.Sensing
        get legsArmorItem(): Internal.ItemStack
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get lootTable(): ResourceLocation
        get ticksUsingItem(): number
        get arrowCount(): number
        get moveControl(): Internal.MoveControl
        get brain(): Internal.Brain<Internal.Axolotl>
        get defaultMovementSpeed(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        get firstTick(): boolean
        get lastHurtByMobTimestamp(): number
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        set spawnCancelled(arg0: boolean)
        get stringUuid(): string
        set swimming(arg0: boolean)
        get mainArm(): Internal.HumanoidArm
        get rotationVector(): Internal.Vec2
        get hurtDir(): number
        get sprinting(): boolean
        get motionY(): number
        get offhandItem(): Internal.ItemStack
        get lastHurtMob(): Internal.LivingEntity
        get addedToWorld(): boolean
        get lastDamageSource(): DamageSource
        get soundSource(): Internal.SoundSource
        set noActionTime(arg0: number)
        set movementSpeedAddition(speed: number)
        get pose(): Internal.Pose
        get restrictCenter(): BlockPos
        get leftHanded(): boolean
        set z(z: number)
        get y(): number
        get pickupSound(): Internal.SoundEvent
        get blocking(): boolean
        get pushedByFluid(): boolean
        get armorCoverPercentage(): number
        get airSupply(): number
        get animal(): boolean
        get player(): boolean
        get motionDirection(): Internal.Direction
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get totalMovementSpeed(): number
        get moving(): boolean
        get attributes(): Internal.AttributeMap
        get spawnCancelled(): boolean
        set inLoveTime(arg0: number)
        get swimming(): boolean
        set sprinting(arg0: boolean)
        set x(x: number)
        get portalWaitTime(): number
        get blockStateOn(): Internal.BlockState
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get undead(): boolean
        get stepHeight(): number
        set registeredToWorld(navigation: Internal.PathNavigation_)
        get sleeping(): boolean
        get dismountPoses(): Internal.ImmutableList<Internal.Pose>
        get lastHurtMobTimestamp(): number
        get mobSpawnType(): Internal.MobSpawnType
        set remainingFireTicks(arg0: number)
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        set canPickUpLoot(arg0: boolean)
        get mainHandItem(): Internal.ItemStack
        get fireType(): ResourceLocation
        set silent(arg0: boolean)
        set leftHanded(arg0: boolean)
        get activeEffects(): Internal.Collection<Internal.MobEffectInstance>
        get onPortalCooldown(): boolean
        set uranusEntityData(nbt: Internal.CompoundTag_)
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get usingItem(): boolean
        get alwaysTicking(): boolean
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get inFluidType(): boolean
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get tags(): Internal.Set<string>
        get lastAttacker(): Internal.LivingEntity
        get percentFrozen(): number
        set portalCooldown(arg0: number)
        set position(block: Internal.BlockContainerJS_)
        get leashed(): boolean
        get variant(): any
        set pose(arg0: Internal.Pose_)
        get reachDistance(): number
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        set lastHurtByPlayer(arg0: Internal.Player_)
        get "server()"(): Internal.MinecraftServer
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set chestArmorItem(item: Internal.ItemStack_)
        get passenger(): boolean
        get sensitiveToWater(): boolean
        get jumpControl(): Internal.JumpControl
        get feetArmorItem(): Internal.ItemStack
        get viewScale(): number
        get visualRotationYInDegrees(): number
        set speed(arg0: number)
        get discrete(): boolean
        get level(): Internal.Level
        get combatTracker(): Internal.CombatTracker
        get noAi(): boolean
        get chestArmorItem(): Internal.ItemStack
        set variant(arg0: any)
        get fullyFrozen(): boolean
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get scale(): number
        get suppressingSlidingDownLadder(): boolean
        get blockZ(): number
        get silent(): boolean
        get pitch(): number
        get random(): Internal.RandomSource
        get passengersAndSelf(): Internal.Stream<any>
        get modelRotationValues(): Internal.Map<string, Vec3f>
        get age(): number
        get noActionTime(): number
        get visuallyCrawling(): boolean
        get aggressive(): boolean
        set yya(arg0: number)
        set baby(arg0: boolean)
        get lastHurtByMob(): Internal.LivingEntity
        get inWaterOrBubble(): boolean
        get portalCooldown(): number
        get item(): Internal.ItemStack
        get ignoringBlockTriggers(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        get blockX(): number
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get fallFlying(): boolean
        get encodeId(): string
        get maxHeadXRot(): number
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        set health(arg0: number)
        get eyePosition(): Vec3d
        get eyeHeight(): number
        set discardFriction(arg0: boolean)
        get yaw(): number
        get usedItemHand(): Internal.InteractionHand
        set defaultMovementSpeed(speed: number)
        set playingDead(arg0: boolean)
        set customNameVisible(arg0: boolean)
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        set feetArmorItem(item: Internal.ItemStack_)
        get id(): number
        get eyeY(): number
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get affectedByPotions(): boolean
        get citadelEntityData(): Internal.CompoundTag
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get useItem(): Internal.ItemStack
        get myRidingOffset(): number
        get living(): boolean
        get x(): number
        get vehicle(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        set stingerCount(arg0: number)
        get maxHeadYRot(): number
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get lootTableSeed(): number
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        get potionEffects(): Internal.EntityPotionEffectsJS
        get onRails(): boolean
        get stingerCount(): number
        get fallSounds(): Internal.LivingEntity$Fallsounds
        get dimensionChangingDelay(): number
        set yaw(arg0: number)
        get pickRadius(): number
        get pathFinding(): boolean
        get removed(): boolean
        get jumpBoostPower(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get experienceReward(): number
        get firstPassenger(): Internal.Entity
        get spawnType(): Internal.MobSpawnType
        set lastHurtMob(arg0: Internal.Entity_)
        set lastHurtByMob(arg0: Internal.LivingEntity_)
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get sleepingPos(): Internal.Optional<any>
        get lookAngle(): Vec3d
        get ambientSoundInterval(): number
        set arrowCount(arg0: number)
        get motionZ(): number
        get persistenceRequired(): boolean
        get invisible(): boolean
        get bedOrientation(): Internal.Direction
        get profile(): Internal.GameProfile
        set inLove(arg0: Internal.Player_)
        get uranusEntityData(): Internal.CompoundTag
        get deadOrDying(): boolean
        set headArmorItem(item: Internal.ItemStack_)
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        get lookControl(): Internal.LookControl
        set fromBucket(arg0: boolean)
        get offHandItem(): Internal.ItemStack
        get crouching(): boolean
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get withinRestriction(): boolean
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get maxAirSupply(): number
        get visuallySwimming(): boolean
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get boundingBoxForCulling(): Internal.AABB
        set age(arg0: number)
        get target(): Internal.LivingEntity
        get inLove(): boolean
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get inWater(): boolean
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        set citadelEntityData(arg0: Internal.CompoundTag_)
        get speed(): number
        get cachedFeetBlockState(): Internal.BlockState
        get uuid(): Internal.UUID
        set offHandItem(item: Internal.ItemStack_)
        set noAi(arg0: boolean)
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        get headArmorItem(): Internal.ItemStack
        set variant(arg0: Internal.Axolotl$Variant_)
        get bbWidth(): number
        get "name()"(): net.minecraft.network.chat.Component
        get ticksRequiredToFreeze(): number
        get playingDead(): boolean
        get maxSpawnClusterSize(): number
        get username(): string
        get inLoveTime(): number
        set "variant(java.lang.Object)"(arg0: any)
        get pickable(): boolean
        set YHeadRot(arg0: number)
        set jumping(arg0: boolean)
        get pickResult(): Internal.ItemStack
        get "mainHandItem()"(): Internal.ItemStack
        get absorptionAmount(): number
        get randomY(): number
        get displayName(): net.minecraft.network.chat.Component
        get mobType(): Internal.MobType
        get passengersRidingOffset(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set noGravity(arg0: boolean)
        get useItemRemainingTicks(): number
        get indirectPassengers(): Internal.Iterable<any>
        get bucketItemStack(): Internal.ItemStack
        get navigation(): Internal.PathNavigation
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get loveCause(): Internal.ServerPlayer
        get lastClimbablePos(): Internal.Optional<BlockPos>
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get activeEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get restrictRadius(): number
        get registeredNavigation(): Internal.PathNavigation
        get invertedHealAndHarm(): boolean
        get freezing(): boolean
        set guaranteedDrop(arg0: EquipmentSlot_)
        set sharedFlagOnFire(arg0: boolean)
        static readonly TOTAL_PLAYDEAD_TIME: (200) & (number);
        static readonly PLAYER_REGEN_DETECTION_RANGE: (20.0) & (number);
        static readonly RARE_VARIANT_CHANCE: (1200) & (number);
        static readonly VARIANT_TAG: ("Variant") & (string);
    }
    type Axolotl_ = Axolotl;
    class NearestLivingEntitySensor <T extends Internal.LivingEntity> extends Internal.Sensor<T> {
        constructor()
        tick(arg0: Internal.ServerLevel_, arg1: T): void;
        getClass(): typeof any;
        toString(): string;
        static isEntityTargetable(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        notifyAll(): void;
        static isEntityAttackableIgnoringLineOfSight(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        static isEntityAttackable(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        requires(): Internal.Set<Internal.MemoryModuleType<any>>;
        get class(): typeof any
    }
    type NearestLivingEntitySensor_<T extends Internal.LivingEntity> = NearestLivingEntitySensor<T>;
    class BlockCompressedObsidian$EnumType extends Internal.Enum<Internal.BlockCompressedObsidian$EnumType> implements Internal.StringRepresentable {
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(arg0: string): Internal.BlockCompressedObsidian$EnumType;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        getMetadata(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.BlockCompressedObsidian$EnumType[];
        compareTo(arg0: Internal.BlockCompressedObsidian$EnumType_): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.BlockCompressedObsidian$EnumType>>;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        toString(): string;
        notifyAll(): void;
        name(): string;
        hashCode(): number;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        "compareTo(com.wuest.prefab.blocks.BlockCompressedObsidian$EnumType)"(arg0: Internal.BlockCompressedObsidian$EnumType_): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        getDeclaringClass(): typeof Internal.BlockCompressedObsidian$EnumType;
        get class(): typeof any
        get serializedName(): string
        get metadata(): number
        get declaringClass(): typeof Internal.BlockCompressedObsidian$EnumType
        static readonly DOUBLE_COMPRESSED_OBSIDIAN: (Internal.BlockCompressedObsidian$EnumType) & (Internal.BlockCompressedObsidian$EnumType);
        static readonly COMPRESSED_OBSIDIAN: (Internal.BlockCompressedObsidian$EnumType) & (Internal.BlockCompressedObsidian$EnumType);
    }
    type BlockCompressedObsidian$EnumType_ = "double_compressed_obsidian" | "compressed_obsidian" | BlockCompressedObsidian$EnumType;
    class PalettedContainer$Data <T> extends Internal.Record {
        getClass(): typeof any;
        configuration(): Internal.PalettedContainer$Configuration<T>;
        write(arg0: Internal.FriendlyByteBuf_): void;
        toString(): string;
        palette(): Internal.Palette<T>;
        getSerializedSize(): number;
        copy(): this;
        copyFrom(arg0: Internal.Palette_<T>, arg1: Internal.BitStorage_): void;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        storage(): Internal.BitStorage;
        equals(arg0: any): boolean;
        get class(): typeof any
        get serializedSize(): number
    }
    type PalettedContainer$Data_<T> = PalettedContainer$Data<T>;
    class BioForgeTab {
        constructor(arg0: number, arg1: Internal.Item_)
        constructor(arg0: Internal.Item_)
        getClass(): typeof any;
        toString(): string;
        static fromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.BioForgeTab;
        translationKey(): string;
        notifyAll(): void;
        toJson(arg0: Internal.JsonObject_): void;
        getIcon(): Internal.ItemStack;
        static enumIdFrom(arg0: ResourceLocation_): string;
        toNetwork(arg0: Internal.FriendlyByteBuf_): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        enumId(): string;
        hashCode(): number;
        wait(): void;
        static getTabId(arg0: Internal.JsonObject_): string;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        static fromJson(arg0: Internal.JsonObject_): Internal.BioForgeTab;
        sortPriority(): number;
        get class(): typeof any
        get icon(): Internal.ItemStack
    }
    type BioForgeTab_ = BioForgeTab;
    class EnigmaCrownBlock extends Internal.BushBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        getPlant(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        invokeMayPlaceOn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type EnigmaCrownBlock_ = EnigmaCrownBlock;
    class FTBQuestsKubeJSPlayerData extends Internal.FTBQuestsKubeJSTeamData {
        constructor(p: Internal.Player_)
        complete(id: any): void;
        canStartQuest(id: any): boolean;
        getClass(): typeof any;
        toString(): string;
        getFile(): Internal.BaseQuestFile;
        isCompleted(id: any): boolean;
        changeProgress(id: any, consumer: Internal.Consumer_<Internal.ProgressChange>): void;
        notifyAll(): void;
        getRelativeProgress(id: any): number;
        getOnlineMembers(): Internal.EntityArrayList;
        getTaskProgress(id: any): number;
        setLocked(v: boolean): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getLocked(): boolean;
        reset(id: any): void;
        isStarted(id: any): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getData(): Internal.TeamData;
        addProgress(id: any, progress: number): boolean;
        equals(arg0: any): boolean;
        get class(): typeof any
        get file(): Internal.BaseQuestFile
        get onlineMembers(): Internal.EntityArrayList
        set locked(v: boolean)
        get locked(): boolean
        get data(): Internal.TeamData
    }
    type FTBQuestsKubeJSPlayerData_ = FTBQuestsKubeJSPlayerData;
    class DreamharpOfWandererItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type DreamharpOfWandererItem_ = DreamharpOfWandererItem;
    class MobSpawnSettingsBuilder extends Internal.MobSpawnSettings$Builder {
        constructor(arg0: Internal.MobSpawnSettings_)
        getClass(): typeof any;
        toString(): string;
        getProbability(): number;
        notifyAll(): void;
        getEntityTypes(): Internal.Set<Internal.EntityType<any>>;
        creatureGenerationProbability(arg0: number): Internal.MobSpawnSettings$Builder;
        puzzleslib$getMobSpawnCosts(): Internal.Map<any, any>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        addSpawn(arg0: Internal.MobCategory_, arg1: Internal.MobSpawnSettings$SpawnerData_): Internal.MobSpawnSettings$Builder;
        disablePlayerSpawn(): this;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getSpawner(arg0: Internal.MobCategory_): Internal.List<Internal.MobSpawnSettings$SpawnerData>;
        build(): Internal.MobSpawnSettings;
        getCost(arg0: Internal.EntityType_<any>): Internal.MobSpawnSettings$MobSpawnCost;
        equals(arg0: any): boolean;
        getSpawnerTypes(): Internal.Set<Internal.MobCategory>;
        addMobCharge(arg0: Internal.EntityType_<any>, arg1: number, arg2: number): Internal.MobSpawnSettings$Builder;
        get class(): typeof any
        get probability(): number
        get entityTypes(): Internal.Set<Internal.EntityType<any>>
        get spawnerTypes(): Internal.Set<Internal.MobCategory>
    }
    type MobSpawnSettingsBuilder_ = MobSpawnSettingsBuilder;
    class ModularSingleHeadedItem extends Internal.ItemModularHandheld {
        constructor()
        getRepairRequiredTools(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): Internal.Collection<Internal.ToolAction>;
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getHoningLimit(arg0: Internal.ItemStack_): number;
        getAttributeModifiersCached(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        static "updateIdentifier(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        isFireResistant(): boolean;
        canGainHoneProgress(arg0: Internal.ItemStack_): boolean;
        getMajorModules(arg0: Internal.ItemStack_): Internal.ItemModuleMajor[];
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        hasModule(arg0: Internal.ItemStack_, arg1: Internal.ItemModule_): boolean;
        getToolLevel(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getImprovements(arg0: Internal.ItemStack_): Internal.ImprovementData[];
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getHonedCount(arg0: Internal.ItemStack_): number;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        static isHoneable(arg0: Internal.ItemStack_): boolean;
        hasModuleSynergy(arg0: Internal.ItemStack_, arg1: Internal.SynergyData_, arg2: Internal.ItemModule_[]): boolean;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setHoningProgress(arg0: Internal.ItemStack_, arg1: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getRepairCycle(arg0: Internal.ItemStack_): Internal.ItemModule[];
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getHarvestTier(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        getDisplayNamePrefixes(arg0: Internal.ItemStack_): string;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        getHoneIntegrityMultiplier(arg0: Internal.ItemStack_): number;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        hitEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number): Internal.AbilityUseResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        causeRiptideEffect(arg0: Internal.Player_, arg1: number): void;
        static updateIdentifier(arg0: Internal.CompoundTag_): void;
        getMinorModules(arg0: Internal.ItemStack_): Internal.ItemModule[];
        getTooltip(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        getImprovementTooltip(arg0: string, arg1: number, arg2: boolean): string;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        getEnchantability(arg0: Internal.ItemStack_): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getToolDataCache(): Internal.Cache<string, Internal.ToolData>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAttributeModifierCache(): Internal.Cache<string, Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getAllModules(arg0: Internal.ItemStack_): Internal.Collection<Internal.ItemModule>;
        getEffects(arg0: Internal.ItemStack_): Internal.Collection<ItemEffect>;
        static canDenail(arg0: Internal.BlockState_): boolean;
        getTransformVariant(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): string;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        applyPositiveUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        onActionConsume(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Player_, arg3: Internal.ToolAction_, arg4: number, arg5: boolean): Internal.ItemStack;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        canProvideTools(arg0: Internal.ItemStack_): boolean;
        getAbilityBaseDamage(arg0: Internal.ItemStack_): number;
        setAttackSpeed(attackSpeed: number): void;
        jabEntity(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Player_, arg3: Internal.LivingEntity_): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isThrowing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        applyDestabilizationEffects(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: number): void;
        onPlayerStoppedUsingSecondary(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        getMinorModuleNames(arg0: Internal.ItemStack_): string[];
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getRequiredModules(arg0: Internal.ItemStack_): string[];
        getBlockProgress(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): number;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        throwItem(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: number, arg3: number): void;
        getHoningIntegrityPenalty(arg0: Internal.ItemStack_): number;
        commonInit(arg0: Internal.PacketHandler_): void;
        static handleSecondaryAbility(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.LivingEntity_): void;
        isBroken(arg0: Internal.ItemStack_): boolean;
        getNumMinorModules(arg0: Internal.ItemStack_): number;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        assemble(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        getAttributeModifiers(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getEffectDataCached(arg0: Internal.ItemStack_): Internal.EffectData;
        getRepairModuleName(arg0: Internal.ItemStack_): string;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        getRepairSlot(arg0: Internal.ItemStack_): string;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        isBlocking(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getTags(arg0: Internal.ItemStack_): Internal.Set<Internal.TagKey<Internal.Item>>;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        updateConfig(arg0: number, arg1: number): void;
        getNumMajorModules(arg0: Internal.ItemStack_): number;
        tweak(arg0: Internal.ItemStack_, arg1: string, arg2: Internal.Map_<string, number>): void;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getEffectLevel(arg0: Internal.ItemStack_, arg1: ItemEffect_): number;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        denailBlock(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.InteractionHand_, arg4: Internal.Direction_): boolean;
        static removeHoneable(arg0: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        incrementRepairCount(arg0: Internal.ItemStack_): void;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getModuleAttributes(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEffectData(arg0: Internal.ItemStack_): Internal.EffectData;
        getToolLevels(arg0: Internal.ItemStack_): Internal.Map<Internal.ToolAction, number>;
        getRepairRequiredToolLevel(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.ToolAction_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        getToolEfficiency(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        clearCaches(): void;
        static handleChargedAbility(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.LivingEntity_, arg3: BlockPos_, arg4: Vec3d_, arg5: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        getHoneBase(arg0: Internal.ItemStack_): number;
        static getIntegrityGain(arg0: Internal.ItemStack_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        getHoningProgress(arg0: Internal.ItemStack_): number;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static getCounterWeightBonus(arg0: number, arg1: number): number;
        static putModuleInSlot(arg0: Internal.ItemStack_, arg1: string, arg2: string, arg3: string, arg4: string): void;
        onShieldDisabled(arg0: Internal.Player_, arg1: Internal.ItemStack_): void;
        equals(arg0: any): boolean;
        getEntityHitDamage(): number;
        getRepairCount(arg0: Internal.ItemStack_): number;
        applyNegativeUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        setRarity(arg0: Internal.Rarity_): void;
        getRepairDefinitions(arg0: Internal.ItemStack_): Internal.Collection<Internal.RepairDefinition>;
        getProperties(arg0: Internal.ItemStack_): Internal.ItemProperties;
        getPropertyCache(): Internal.Cache<string, Internal.ItemProperties>;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getToolData(arg0: Internal.ItemStack_): Internal.ToolData;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        getModuleFromSlot(arg0: Internal.ItemStack_, arg1: string): Internal.ItemModule;
        getRepairAmount(arg0: Internal.ItemStack_): number;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        static "updateIdentifier(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): void;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        static getAbilities_$md$c625c2$0(): Internal.ChargedAbilityEffect[];
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        getModelCacheKey(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): string;
        getCooldownBase(arg0: Internal.ItemStack_): number;
        static setAbilities(arg0: Internal.ChargedAbilityEffect_[]): void;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        static getEfficiencyEnchantmentBonus(arg0: number): number;
        getRepairRequiredExperience(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): number;
        applyUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        static getAbilities(): Internal.ChargedAbilityEffect[];
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        repair(arg0: Internal.ItemStack_): void;
        getBlockDestroyDamage(): number;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        static putModuleInSlot(arg0: Internal.ItemStack_, arg1: string, arg2: string, arg3: string): void;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        static getImprovementDescription(arg0: string): string;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getEffectAttributes(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getRepairModule(arg0: Internal.ItemStack_): Internal.Optional<Internal.ItemModule>;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getItemName(arg0: Internal.ItemStack_): string;
        getDefaultStack(): Internal.ItemStack;
        getEffectEfficiency(arg0: Internal.ItemStack_, arg1: ItemEffect_): number;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getMajorGuiOffsets(arg0: Internal.ItemStack_): Internal.GuiModuleOffsets;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        getSynergyData(arg0: Internal.ItemStack_): Internal.SynergyData[];
        getTools(arg0: Internal.ItemStack_): Internal.Set<Internal.ToolAction>;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getMinorGuiOffsets(arg0: Internal.ItemStack_): Internal.GuiModuleOffsets;
        setAttackDamage(attackDamage: number): void;
        triggerChargedAbility(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getMinorModuleKeys(arg0: Internal.ItemStack_): string[];
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        itemInteractionForEntitySecondary(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): boolean;
        getId(): string;
        getRepairRequiredToolLevels(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): Internal.Map<Internal.ToolAction, number>;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getModels(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.ImmutableList<Internal.ModuleModel>;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        applyBlockBreakEffects(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): void;
        tickProgression(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        onCraftConsume(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Player_, arg3: Internal.ToolAction_, arg4: number, arg5: boolean): Internal.ItemStack;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        static getImprovementName(arg0: string, arg1: number): string;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isModuleRequired(arg0: Internal.ItemStack_, arg1: string): boolean;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        hasImprovementSynergy(arg0: Internal.SynergyData_, arg1: string[]): boolean;
        getChargeableAbility(arg0: Internal.ItemStack_): Internal.ChargedAbilityEffect;
        clientInit(): void;
        getAttributeValue(arg0: Internal.ItemStack_, arg1: Internal.Attribute_, arg2: number): number;
        getEffectDataCache(): Internal.Cache<string, Internal.EffectData>;
        notify(): void;
        getMajorModuleNames(arg0: Internal.ItemStack_): string[];
        dowseBlock(arg0: Internal.Player_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_): boolean;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        "getItem()"(): Internal.Item;
        bashEntity(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Player_, arg3: Internal.LivingEntity_): void;
        hitEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number, arg6: number): Internal.AbilityUseResult;
        getMajorModuleKeys(arg0: Internal.ItemStack_): string[];
        hasVariantSynergy(arg0: Internal.SynergyData_, arg1: string[]): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        getReducedDamage(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        fixIdentifiers(arg0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static getHoningSeed(arg0: Internal.ItemStack_): number;
        isShield(arg0: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        acceptsEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_, arg2: boolean): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        applyDamage(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        isBroken(arg0: number, arg1: number): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getRepairMaterialCount(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): number;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        static getIntegrityCost(arg0: Internal.ItemStack_): number;
        static removeAllEnchantments(arg0: Internal.ItemStack_): Internal.ItemStack;
        tickHoningProgression(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        wait(arg0: number, arg1: number): void;
        getToolActions(arg0: Internal.ItemStack_): Internal.Set<Internal.ToolAction>;
        getIdentifier(arg0: Internal.ItemStack_): string;
        static updateIdentifier(arg0: Internal.ItemStack_): void;
        getAttributeValue(arg0: Internal.ItemStack_, arg1: Internal.Attribute_): number;
        getAttributeModifiersCollapsed(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        getStabilityModifier(arg0: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        static getAttackSpeedHarvestModifier(arg0: number): number;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        static setAbilities_$md$c625c2$1(arg0: Internal.ChargedAbilityEffect_[]): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getCounterWeightBonus(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getDataCacheKey(arg0: Internal.ItemStack_): string;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        getAllSynergyData(arg0: Internal.ItemStack_): Internal.SynergyData[];
        getPropertiesCached(arg0: Internal.ItemStack_): Internal.ItemProperties;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get toolDataCache(): Internal.Cache<string, Internal.ToolData>
        get attributeModifierCache(): Internal.Cache<string, Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        get entityHitDamage(): number
        set rarity(arg0: Internal.Rarity_)
        get propertyCache(): Internal.Cache<string, Internal.ItemProperties>
        get complex(): boolean
        get descriptionId(): string
        get abilities_$md$c625c2$0(): Internal.ChargedAbilityEffect[]
        get creativeTab(): string
        set abilities(arg0: Internal.ChargedAbilityEffect_[])
        get abilities(): Internal.ChargedAbilityEffect[]
        get blockDestroyDamage(): number
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get defaultStack(): Internal.ItemStack
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get effectDataCache(): Internal.Cache<string, Internal.EffectData>
        get "item()"(): Internal.Item
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        set abilities_$md$c625c2$1(arg0: Internal.ChargedAbilityEffect_[])
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static instance: (Internal.ModularSingleHeadedItem) & (Internal.ModularSingleHeadedItem);
        static readonly bindingKey: ("single/binding") & (string);
        static readonly identifier: ("modular_single") & (string);
        static readonly headKey: ("single/head") & (string);
        static readonly handleKey: ("single/handle") & (string);
        static readonly newBindingKey: ("single/new_binding") & (string);
    }
    type ModularSingleHeadedItem_ = ModularSingleHeadedItem;
    class Arrays {
        static "stream(double[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.DoubleStream;
        static "copyOf(double[],int)"(arg0: number[], arg1: number): number[];
        static mismatch(arg0: any[], arg1: number, arg2: number, arg3: any[], arg4: number, arg5: number): number;
        static copyOf(arg0: number[], arg1: number): number[];
        static sort<T>(arg0: T[], arg1: number, arg2: number, arg3: Internal.Comparator_<T>): void;
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        static "parallelSort(char[])"(arg0: string[]): void;
        static "binarySearch(float[],int,int,float)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static binarySearch<T>(arg0: T[], arg1: number, arg2: number, arg3: T, arg4: Internal.Comparator_<T>): number;
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "copyOfRange(char[],int,int)"(arg0: string[], arg1: number, arg2: number): string[];
        static "spliterator(int[])"(arg0: number[]): Internal.Spliterator$OfInt;
        static "fill(long[],int,int,long)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "compare(int[],int[])"(arg0: number[], arg1: number[]): number;
        static "hashCode(long[])"(arg0: number[]): number;
        static equals(arg0: any[], arg1: any[]): boolean;
        static stream(arg0: number[], arg1: number, arg2: number): Internal.IntStream;
        static hashCode(arg0: any[]): number;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static sort(arg0: string[], arg1: number, arg2: number): void;
        static "parallelPrefix(long[],int,int,java.util.function.LongBinaryOperator)"(arg0: number[], arg1: number, arg2: number, arg3: Internal.LongBinaryOperator_): void;
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static setAll(arg0: number[], arg1: Internal.IntUnaryOperator_): void;
        static "hashCode(boolean[])"(arg0: boolean[]): number;
        static "parallelSetAll(long[],java.util.function.IntToLongFunction)"(arg0: number[], arg1: Internal.IntToLongFunction_): void;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "sort(short[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static compare(arg0: number[], arg1: number[]): number;
        static fill(arg0: boolean[], arg1: boolean): void;
        static mismatch(arg0: number[], arg1: number[]): number;
        static copyOf(arg0: number[], arg1: number): number[];
        static parallelSort<T>(arg0: T[], arg1: Internal.Comparator_<T>): void;
        static "equals(boolean[],int,int,boolean[],int,int)"(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): boolean;
        static compare(arg0: number[], arg1: number[]): number;
        static "parallelSetAll(java.lang.Object[],java.util.function.IntFunction)"<T>(arg0: T[], arg1: Internal.IntFunction_<T>): void;
        static spliterator(arg0: number[]): Internal.Spliterator$OfLong;
        static "compare(double[],double[])"(arg0: number[], arg1: number[]): number;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static "stream(int[])"(arg0: number[]): Internal.IntStream;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static compare<T>(arg0: T[], arg1: number, arg2: number, arg3: T[], arg4: number, arg5: number, arg6: Internal.Comparator_<T>): number;
        static "spliterator(double[])"(arg0: number[]): Internal.Spliterator$OfDouble;
        wait(arg0: number): void;
        static setAll(arg0: number[], arg1: Internal.IntToDoubleFunction_): void;
        static setAll<T>(arg0: T[], arg1: Internal.IntFunction_<T>): void;
        static "copyOfRange(long[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static compare(arg0: number[], arg1: number[]): number;
        static binarySearch(arg0: string[], arg1: number, arg2: number, arg3: string): number;
        static "fill(double[],int,int,double)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static parallelSort(arg0: number[]): void;
        static "copyOf(int[],int)"(arg0: number[], arg1: number): number[];
        static binarySearch(arg0: string[], arg1: string): number;
        static "fill(boolean[],boolean)"(arg0: boolean[], arg1: boolean): void;
        static sort(arg0: any[]): void;
        static "stream(int[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.IntStream;
        static mismatch<T>(arg0: T[], arg1: T[], arg2: Internal.Comparator_<T>): number;
        static parallelSort(arg0: string[]): void;
        static "compareUnsigned(int[],int,int,int[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static copyOf(arg0: number[], arg1: number): number[];
        static parallelSort(arg0: number[]): void;
        static toString(arg0: number[]): string;
        static mismatch(arg0: string[], arg1: string[]): number;
        static "toString(int[])"(arg0: number[]): string;
        static equals(arg0: boolean[], arg1: boolean[]): boolean;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static "sort(float[])"(arg0: number[]): void;
        static compare(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): number;
        static "binarySearch(short[],int,int,short)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static binarySearch(arg0: number[], arg1: number): number;
        static "hashCode(double[])"(arg0: number[]): number;
        static compare<T>(arg0: T[], arg1: T[], arg2: Internal.Comparator_<T>): number;
        static "mismatch(long[],int,int,long[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "parallelSort(java.lang.Comparable[])"<T extends Internal.Comparable<any>>(arg0: T[]): void;
        static "copyOfRange(byte[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static "hashCode(float[])"(arg0: number[]): number;
        static copyOf(arg0: number[], arg1: number): number[];
        static "equals(float[],int,int,float[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static sort(arg0: number[]): void;
        static spliterator(arg0: number[]): Internal.Spliterator$OfDouble;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static parallelPrefix(arg0: number[], arg1: number, arg2: number, arg3: Internal.DoubleBinaryOperator_): void;
        static "mismatch(double[],int,int,double[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "mismatch(long[],long[])"(arg0: number[], arg1: number[]): number;
        static "parallelSort(float[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static spliterator(arg0: number[]): Internal.Spliterator$OfInt;
        static "compare(byte[],int,int,byte[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static copyOf(arg0: string[], arg1: number): string[];
        static "sort(short[])"(arg0: number[]): void;
        static "parallelPrefix(java.lang.Object[],java.util.function.BinaryOperator)"<T>(arg0: T[], arg1: Internal.BinaryOperator_<T>): void;
        static equals(arg0: number[], arg1: number[]): boolean;
        static toString(arg0: any[]): string;
        static "sort(byte[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        equals(arg0: any): boolean;
        static "sort(double[])"(arg0: number[]): void;
        static "mismatch(int[],int,int,int[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "binarySearch(double[],double)"(arg0: number[], arg1: number): number;
        static "setAll(java.lang.Object[],java.util.function.IntFunction)"<T>(arg0: T[], arg1: Internal.IntFunction_<T>): void;
        static "parallelSort(short[])"(arg0: number[]): void;
        static parallelSort(arg0: number[]): void;
        static copyOfRange<T, U>(arg0: U[], arg1: number, arg2: number, arg3: T[]): T[];
        static "binarySearch(java.lang.Object[],java.lang.Object)"(arg0: any[], arg1: any): number;
        static "mismatch(byte[],int,int,byte[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static hashCode(arg0: number[]): number;
        static "parallelSort(long[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static parallelPrefix<T>(arg0: T[], arg1: number, arg2: number, arg3: Internal.BinaryOperator_<T>): void;
        static mismatch(arg0: number[], arg1: number[]): number;
        static "parallelPrefix(double[],int,int,java.util.function.DoubleBinaryOperator)"(arg0: number[], arg1: number, arg2: number, arg3: Internal.DoubleBinaryOperator_): void;
        static "compareUnsigned(long[],int,int,long[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static fill(arg0: number[], arg1: number): void;
        static "spliterator(long[])"(arg0: number[]): Internal.Spliterator$OfLong;
        static "toString(double[])"(arg0: number[]): string;
        static "mismatch(java.lang.Object[],java.lang.Object[])"(arg0: any[], arg1: any[]): number;
        static "setAll(int[],java.util.function.IntUnaryOperator)"(arg0: number[], arg1: Internal.IntUnaryOperator_): void;
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "mismatch(short[],int,int,short[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "fill(char[],char)"(arg0: string[], arg1: string): void;
        static "spliterator(double[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfDouble;
        static "parallelPrefix(int[],java.util.function.IntBinaryOperator)"(arg0: number[], arg1: Internal.IntBinaryOperator_): void;
        static "equals(long[],int,int,long[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "equals(int[],int,int,int[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static sort(arg0: number[]): void;
        static "toString(short[])"(arg0: number[]): string;
        static "fill(float[],float)"(arg0: number[], arg1: number): void;
        static mismatch(arg0: any[], arg1: any[]): number;
        static fill(arg0: number[], arg1: number): void;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static "binarySearch(char[],char)"(arg0: string[], arg1: string): number;
        static "hashCode(int[])"(arg0: number[]): number;
        static "copyOf(long[],int)"(arg0: number[], arg1: number): number[];
        static "parallelSort(float[])"(arg0: number[]): void;
        static "fill(float[],int,int,float)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "compareUnsigned(long[],long[])"(arg0: number[], arg1: number[]): number;
        static toString(arg0: number[]): string;
        static "parallelSort(byte[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static "equals(double[],double[])"(arg0: number[], arg1: number[]): boolean;
        static "sort(int[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static "stream(long[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.LongStream;
        static "copyOf(char[],int)"(arg0: string[], arg1: number): string[];
        static copyOf(arg0: number[], arg1: number): number[];
        static hashCode(arg0: number[]): number;
        static "hashCode(char[])"(arg0: string[]): number;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static "equals(long[],long[])"(arg0: number[], arg1: number[]): boolean;
        static deepHashCode(arg0: any[]): number;
        static compare<T extends Internal.Comparable<any>>(arg0: T[], arg1: T[]): number;
        static parallelPrefix(arg0: number[], arg1: Internal.LongBinaryOperator_): void;
        static parallelSort(arg0: string[], arg1: number, arg2: number): void;
        static fill(arg0: any[], arg1: any): void;
        static "fill(byte[],int,int,byte)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static mismatch<T>(arg0: T[], arg1: number, arg2: number, arg3: T[], arg4: number, arg5: number, arg6: Internal.Comparator_<T>): number;
        notify(): void;
        static hashCode(arg0: string[]): number;
        static hashCode(arg0: number[]): number;
        static "binarySearch(short[],short)"(arg0: number[], arg1: number): number;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "parallelSort(int[])"(arg0: number[]): void;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static "spliterator(java.lang.Object[],int,int)"<T>(arg0: T[], arg1: number, arg2: number): Internal.Spliterator<T>;
        static compareUnsigned(arg0: number[], arg1: number[]): number;
        static equals(arg0: string[], arg1: string[]): boolean;
        static "mismatch(java.lang.Object[],int,int,java.lang.Object[],int,int)"(arg0: any[], arg1: number, arg2: number, arg3: any[], arg4: number, arg5: number): number;
        static parallelPrefix<T>(arg0: T[], arg1: Internal.BinaryOperator_<T>): void;
        static "fill(long[],long)"(arg0: number[], arg1: number): void;
        static fill(arg0: string[], arg1: string): void;
        static deepEquals(arg0: any[], arg1: any[]): boolean;
        static "fill(boolean[],int,int,boolean)"(arg0: boolean[], arg1: number, arg2: number, arg3: boolean): void;
        static equals<T>(arg0: T[], arg1: T[], arg2: Internal.Comparator_<T>): boolean;
        static copyOfRange(arg0: boolean[], arg1: number, arg2: number): boolean[];
        static "sort(byte[])"(arg0: number[]): void;
        static "binarySearch(char[],int,int,char)"(arg0: string[], arg1: number, arg2: number, arg3: string): number;
        static hashCode(arg0: number[]): number;
        static "parallelPrefix(int[],int,int,java.util.function.IntBinaryOperator)"(arg0: number[], arg1: number, arg2: number, arg3: Internal.IntBinaryOperator_): void;
        static "compareUnsigned(short[],short[])"(arg0: number[], arg1: number[]): number;
        static compare(arg0: number[], arg1: number[]): number;
        static compare<T extends Internal.Comparable<any>>(arg0: T[], arg1: number, arg2: number, arg3: T[], arg4: number, arg5: number): number;
        static compare(arg0: boolean[], arg1: boolean[]): number;
        static "parallelSetAll(double[],java.util.function.IntToDoubleFunction)"(arg0: number[], arg1: Internal.IntToDoubleFunction_): void;
        static "fill(int[],int)"(arg0: number[], arg1: number): void;
        static "copyOfRange(double[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static "mismatch(int[],int[])"(arg0: number[], arg1: number[]): number;
        static "copyOfRange(float[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static parallelPrefix(arg0: number[], arg1: number, arg2: number, arg3: Internal.LongBinaryOperator_): void;
        static "toString(float[])"(arg0: number[]): string;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static parallelPrefix(arg0: number[], arg1: Internal.IntBinaryOperator_): void;
        static "setAll(long[],java.util.function.IntToLongFunction)"(arg0: number[], arg1: Internal.IntToLongFunction_): void;
        static parallelPrefix(arg0: number[], arg1: number, arg2: number, arg3: Internal.IntBinaryOperator_): void;
        static mismatch(arg0: number[], arg1: number[]): number;
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        static binarySearch(arg0: number[], arg1: number): number;
        static "compare(char[],int,int,char[],int,int)"(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): number;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "toString(long[])"(arg0: number[]): string;
        static "setAll(double[],java.util.function.IntToDoubleFunction)"(arg0: number[], arg1: Internal.IntToDoubleFunction_): void;
        static fill(arg0: number[], arg1: number): void;
        hashCode(): number;
        static "equals(char[],int,int,char[],int,int)"(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): boolean;
        static equals(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): boolean;
        static equals(arg0: number[], arg1: number[]): boolean;
        static hashCode(arg0: boolean[]): number;
        static compareUnsigned(arg0: number[], arg1: number[]): number;
        static binarySearch(arg0: number[], arg1: number): number;
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "hashCode(java.lang.Object[])"(arg0: any[]): number;
        static toString(arg0: string[]): string;
        static "parallelSort(int[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static "compare(long[],int,int,long[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static parallelPrefix(arg0: number[], arg1: Internal.DoubleBinaryOperator_): void;
        static "stream(java.lang.Object[],int,int)"<T>(arg0: T[], arg1: number, arg2: number): Internal.Stream<T>;
        static stream<T>(arg0: T[]): Internal.Stream<T>;
        static "compare(boolean[],int,int,boolean[],int,int)"(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): number;
        static "binarySearch(java.lang.Object[],int,int,java.lang.Object)"(arg0: any[], arg1: number, arg2: number, arg3: any): number;
        static spliterator(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfInt;
        static "fill(int[],int,int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static asList<T>(...arg0: T[]): Internal.List<T>;
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static "compare(java.lang.Comparable[],int,int,java.lang.Comparable[],int,int)"<T extends Internal.Comparable<any>>(arg0: T[], arg1: number, arg2: number, arg3: T[], arg4: number, arg5: number): number;
        static "sort(long[])"(arg0: number[]): void;
        getClass(): typeof any;
        static stream<T>(arg0: T[], arg1: number, arg2: number): Internal.Stream<T>;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static binarySearch<T>(arg0: T[], arg1: T, arg2: Internal.Comparator_<T>): number;
        static sort(arg0: any[], arg1: number, arg2: number): void;
        static "mismatch(double[],double[])"(arg0: number[], arg1: number[]): number;
        static "stream(double[])"(arg0: number[]): Internal.DoubleStream;
        static binarySearch(arg0: number[], arg1: number): number;
        static stream(arg0: number[], arg1: number, arg2: number): Internal.DoubleStream;
        static equals(arg0: number[], arg1: number[]): boolean;
        static sort(arg0: number[], arg1: number, arg2: number): void;
        static compare(arg0: string[], arg1: string[]): number;
        static "parallelSort(java.lang.Comparable[],int,int)"<T extends Internal.Comparable<any>>(arg0: T[], arg1: number, arg2: number): void;
        static stream(arg0: number[]): Internal.LongStream;
        static binarySearch(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static copyOf(arg0: number[], arg1: number): number[];
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        static copyOf<T>(arg0: T[], arg1: number): T[];
        static compareUnsigned(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "compare(float[],int,int,float[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "compare(int[],int,int,int[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        static "copyOf(java.lang.Object[],int)"<T>(arg0: T[], arg1: number): T[];
        static binarySearch(arg0: any[], arg1: number, arg2: number, arg3: any): number;
        static "compare(short[],int,int,short[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "fill(short[],int,int,short)"(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "spliterator(java.lang.Object[])"<T>(arg0: T[]): Internal.Spliterator<T>;
        static toString(arg0: number[]): string;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "hashCode(byte[])"(arg0: number[]): number;
        static "compare(byte[],byte[])"(arg0: number[], arg1: number[]): number;
        static parallelSort(arg0: number[]): void;
        static "parallelSort(byte[])"(arg0: number[]): void;
        static "sort(int[])"(arg0: number[]): void;
        static binarySearch(arg0: number[], arg1: number): number;
        static fill(arg0: number[], arg1: number): void;
        static spliterator(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfDouble;
        static "binarySearch(int[],int)"(arg0: number[], arg1: number): number;
        static equals(arg0: number[], arg1: number[]): boolean;
        static sort(arg0: number[]): void;
        static "copyOfRange(short[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static stream(arg0: number[], arg1: number, arg2: number): Internal.LongStream;
        static "equals(java.lang.Object[],int,int,java.lang.Object[],int,int)"(arg0: any[], arg1: number, arg2: number, arg3: any[], arg4: number, arg5: number): boolean;
        static "compare(boolean[],boolean[])"(arg0: boolean[], arg1: boolean[]): number;
        static sort<T>(arg0: T[], arg1: Internal.Comparator_<T>): void;
        static "spliterator(int[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfInt;
        static "toString(java.lang.Object[])"(arg0: any[]): string;
        static "sort(long[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static "sort(java.lang.Object[],int,int)"(arg0: any[], arg1: number, arg2: number): void;
        static "compare(float[],float[])"(arg0: number[], arg1: number[]): number;
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "mismatch(boolean[],boolean[])"(arg0: boolean[], arg1: boolean[]): number;
        wait(): void;
        static toString(arg0: boolean[]): string;
        static parallelSetAll(arg0: number[], arg1: Internal.IntToLongFunction_): void;
        static equals<T>(arg0: T[], arg1: number, arg2: number, arg3: T[], arg4: number, arg5: number, arg6: Internal.Comparator_<T>): boolean;
        static "copyOf(float[],int)"(arg0: number[], arg1: number): number[];
        static equals(arg0: number[], arg1: number[]): boolean;
        static "equals(double[],int,int,double[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "fill(char[],int,int,char)"(arg0: string[], arg1: number, arg2: number, arg3: string): void;
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static stream(arg0: number[]): Internal.IntStream;
        static sort(arg0: number[]): void;
        static mismatch(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): number;
        static "mismatch(short[],short[])"(arg0: number[], arg1: number[]): number;
        static "toString(char[])"(arg0: string[]): string;
        static compareUnsigned(arg0: number[], arg1: number[]): number;
        static spliterator<T>(arg0: T[]): Internal.Spliterator<T>;
        static "copyOfRange(boolean[],int,int)"(arg0: boolean[], arg1: number, arg2: number): boolean[];
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "equals(char[],char[])"(arg0: string[], arg1: string[]): boolean;
        static "toString(boolean[])"(arg0: boolean[]): string;
        static copyOfRange<T>(arg0: T[], arg1: number, arg2: number): T[];
        static "compareUnsigned(byte[],int,int,byte[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static mismatch(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): number;
        static fill(arg0: number[], arg1: number): void;
        static compareUnsigned(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static binarySearch(arg0: number[], arg1: number): number;
        static "equals(byte[],int,int,byte[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "mismatch(boolean[],int,int,boolean[],int,int)"(arg0: boolean[], arg1: number, arg2: number, arg3: boolean[], arg4: number, arg5: number): number;
        static parallelSort<T>(arg0: T[], arg1: number, arg2: number, arg3: Internal.Comparator_<T>): void;
        static sort(arg0: string[]): void;
        static "mismatch(byte[],byte[])"(arg0: number[], arg1: number[]): number;
        static "stream(java.lang.Object[])"<T>(arg0: T[]): Internal.Stream<T>;
        static spliterator(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfLong;
        static hashCode(arg0: number[]): number;
        static mismatch(arg0: number[], arg1: number[]): number;
        static "binarySearch(long[],long)"(arg0: number[], arg1: number): number;
        static copyOfRange(arg0: string[], arg1: number, arg2: number): string[];
        static "fill(java.lang.Object[],int,int,java.lang.Object)"(arg0: any[], arg1: number, arg2: number, arg3: any): void;
        static "binarySearch(float[],float)"(arg0: number[], arg1: number): number;
        static compare(arg0: number[], arg1: number[]): number;
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "hashCode(short[])"(arg0: number[]): number;
        static equals(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): boolean;
        static compare(arg0: number[], arg1: number[]): number;
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static compareUnsigned(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static stream(arg0: number[]): Internal.DoubleStream;
        static "mismatch(char[],int,int,char[],int,int)"(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): number;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static parallelSort(arg0: number[]): void;
        static parallelSort<T extends Internal.Comparable<any>>(arg0: T[]): void;
        static "fill(double[],double)"(arg0: number[], arg1: number): void;
        static "binarySearch(byte[],byte)"(arg0: number[], arg1: number): number;
        static fill(arg0: any[], arg1: number, arg2: number, arg3: any): void;
        static "stream(long[])"(arg0: number[]): Internal.LongStream;
        static "parallelSort(double[])"(arg0: number[]): void;
        static equals(arg0: number[], arg1: number[]): boolean;
        static deepToString(arg0: any[]): string;
        static compareUnsigned(arg0: number[], arg1: number[]): number;
        static "parallelSort(short[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static "parallelPrefix(double[],java.util.function.DoubleBinaryOperator)"(arg0: number[], arg1: Internal.DoubleBinaryOperator_): void;
        static "copyOf(boolean[],int)"(arg0: boolean[], arg1: number): boolean[];
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "sort(char[])"(arg0: string[]): void;
        static "toString(byte[])"(arg0: number[]): string;
        static "equals(byte[],byte[])"(arg0: number[], arg1: number[]): boolean;
        static sort(arg0: number[]): void;
        static toString(arg0: number[]): string;
        static "mismatch(char[],char[])"(arg0: string[], arg1: string[]): number;
        static "compareUnsigned(int[],int[])"(arg0: number[], arg1: number[]): number;
        static "sort(java.lang.Object[])"(arg0: any[]): void;
        static "parallelSort(long[])"(arg0: number[]): void;
        static "binarySearch(double[],int,int,double)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static "binarySearch(int[],int,int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static "compare(double[],int,int,double[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static parallelSort<T extends Internal.Comparable<any>>(arg0: T[], arg1: number, arg2: number): void;
        static "parallelSort(char[],int,int)"(arg0: string[], arg1: number, arg2: number): void;
        static toString(arg0: number[]): string;
        static "sort(float[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        toString(): string;
        static compareUnsigned(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        notifyAll(): void;
        static compare(arg0: string[], arg1: number, arg2: number, arg3: string[], arg4: number, arg5: number): number;
        static copyOf<T, U>(arg0: U[], arg1: number, arg2: T[]): T[];
        static "equals(short[],short[])"(arg0: number[], arg1: number[]): boolean;
        static "fill(short[],short)"(arg0: number[], arg1: number): void;
        static "fill(byte[],byte)"(arg0: number[], arg1: number): void;
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "binarySearch(byte[],int,int,byte)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static "compare(long[],long[])"(arg0: number[], arg1: number[]): number;
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "spliterator(long[],int,int)"(arg0: number[], arg1: number, arg2: number): Internal.Spliterator$OfLong;
        static "compareUnsigned(byte[],byte[])"(arg0: number[], arg1: number[]): number;
        static "sort(double[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        static "equals(float[],float[])"(arg0: number[], arg1: number[]): boolean;
        static "copyOf(short[],int)"(arg0: number[], arg1: number): number[];
        static mismatch(arg0: boolean[], arg1: boolean[]): number;
        static fill(arg0: string[], arg1: number, arg2: number, arg3: string): void;
        static mismatch(arg0: number[], arg1: number[]): number;
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static copyOf(arg0: boolean[], arg1: number): boolean[];
        static fill(arg0: number[], arg1: number): void;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static parallelSort(arg0: number[]): void;
        static spliterator<T>(arg0: T[], arg1: number, arg2: number): Internal.Spliterator<T>;
        static fill(arg0: number[], arg1: number, arg2: number, arg3: number): void;
        static "sort(char[],int,int)"(arg0: string[], arg1: number, arg2: number): void;
        static "copyOf(byte[],int)"(arg0: number[], arg1: number): number[];
        static "mismatch(float[],int,int,float[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "equals(java.lang.Object[],java.lang.Object[])"(arg0: any[], arg1: any[]): boolean;
        static "binarySearch(long[],int,int,long)"(arg0: number[], arg1: number, arg2: number, arg3: number): number;
        static parallelSort(arg0: number[], arg1: number, arg2: number): void;
        wait(arg0: number, arg1: number): void;
        static mismatch(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static fill(arg0: boolean[], arg1: number, arg2: number, arg3: boolean): void;
        static "compare(short[],short[])"(arg0: number[], arg1: number[]): number;
        static "equals(boolean[],boolean[])"(arg0: boolean[], arg1: boolean[]): boolean;
        static parallelSetAll(arg0: number[], arg1: Internal.IntToDoubleFunction_): void;
        static parallelSetAll<T>(arg0: T[], arg1: Internal.IntFunction_<T>): void;
        static "equals(int[],int[])"(arg0: number[], arg1: number[]): boolean;
        static "equals(short[],int,int,short[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static setAll(arg0: number[], arg1: Internal.IntToLongFunction_): void;
        static sort(arg0: number[]): void;
        static "compare(char[],char[])"(arg0: string[], arg1: string[]): number;
        static copyOfRange(arg0: number[], arg1: number, arg2: number): number[];
        static compare(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static "copyOfRange(int[],int,int)"(arg0: number[], arg1: number, arg2: number): number[];
        static equals(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): boolean;
        static "compare(java.lang.Comparable[],java.lang.Comparable[])"<T extends Internal.Comparable<any>>(arg0: T[], arg1: T[]): number;
        static "compareUnsigned(short[],int,int,short[],int,int)"(arg0: number[], arg1: number, arg2: number, arg3: number[], arg4: number, arg5: number): number;
        static parallelSetAll(arg0: number[], arg1: Internal.IntUnaryOperator_): void;
        static hashCode(arg0: number[]): number;
        static toString(arg0: number[]): string;
        static "fill(java.lang.Object[],java.lang.Object)"(arg0: any[], arg1: any): void;
        static binarySearch(arg0: any[], arg1: any): number;
        static "parallelPrefix(java.lang.Object[],int,int,java.util.function.BinaryOperator)"<T>(arg0: T[], arg1: number, arg2: number, arg3: Internal.BinaryOperator_<T>): void;
        static "copyOfRange(java.lang.Object[],int,int)"<T>(arg0: T[], arg1: number, arg2: number): T[];
        static "mismatch(float[],float[])"(arg0: number[], arg1: number[]): number;
        static equals(arg0: any[], arg1: number, arg2: number, arg3: any[], arg4: number, arg5: number): boolean;
        static "parallelPrefix(long[],java.util.function.LongBinaryOperator)"(arg0: number[], arg1: Internal.LongBinaryOperator_): void;
        static "parallelSetAll(int[],java.util.function.IntUnaryOperator)"(arg0: number[], arg1: Internal.IntUnaryOperator_): void;
        static mismatch(arg0: number[], arg1: number[]): number;
        static "parallelSort(double[],int,int)"(arg0: number[], arg1: number, arg2: number): void;
        get class(): typeof any
    }
    type Arrays_ = Arrays;
    interface RewardType$GuiProvider {
        abstract openCreationGui(arg0: Internal.Panel_, arg1: Internal.Quest_, arg2: Internal.Consumer_<Internal.Reward>): void;
        (arg0: Internal.Panel, arg1: Internal.Quest, arg2: Internal.Consumer<Internal.Reward>): void;
    }
    type RewardType$GuiProvider_ = ((arg0: Internal.Panel, arg1: Internal.Quest, arg2: Internal.Consumer<Internal.Reward>)=> void) | RewardType$GuiProvider;
    interface CreativeModeTab$DisplayItemsGenerator {
        abstract accept(arg0: Internal.CreativeModeTab$ItemDisplayParameters_, arg1: Internal.CreativeModeTab$Output_): void;
        (arg0: Internal.CreativeModeTab$ItemDisplayParameters, arg1: Internal.CreativeModeTab$Output): void;
    }
    type CreativeModeTab$DisplayItemsGenerator_ = CreativeModeTab$DisplayItemsGenerator | ((arg0: Internal.CreativeModeTab$ItemDisplayParameters, arg1: Internal.CreativeModeTab$Output)=> void);
    class TwilightLanternDisplayItem extends Internal.BlockItem implements GeoItem {
        constructor(arg0: Internal.Block_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        static setBlockEntityData(arg0: Internal.ItemStack_, arg1: Internal.BlockEntityType_<any>, arg2: Internal.CompoundTag_): void;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getTick(arg0: any): number;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isPerspectiveAware(): boolean;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        setAnimData<D>(arg0: Internal.Entity_, arg1: number, arg2: Internal.SerializableDataTicket_<D>, arg3: D): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        "triggerAnim(net.minecraft.world.entity.Entity,long,java.lang.String,java.lang.String)"<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        static getBlockEntityData(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        removeFromBlockToItemMap(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        triggerAnim<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        triggerAnim<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        static updateCustomBlockEntityTag(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.ItemStack_): boolean;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getBlock(): Internal.Block;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static registerSyncedAnimatable(arg0: Internal.GeoAnimatable_): void;
        setFireResistant(arg0: boolean): void;
        registerBlocks(arg0: Internal.Map_<Internal.Block, Internal.Item>, arg1: Internal.Item_): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getBoneResetTime(): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        triggerArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string, arg4: Internal.PacketDistributor$PacketTarget_): void;
        static updateState<T extends Internal.Comparable<T>>(arg0: Internal.BlockState_, arg1: Internal.Property_<T>, arg2: string): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        syncAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>, arg2: D, arg3: Internal.PacketDistributor$PacketTarget_): void;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        static getOrAssignId(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_): number;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static "getId(net.minecraft.world.item.Item)"(arg0: Internal.Item_): number;
        registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        equals(arg0: any): boolean;
        "triggerAnim(long,java.lang.String,java.lang.String,net.minecraftforge.network.PacketDistributor$PacketTarget)"<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDescriptionId(): string;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>): D;
        shouldPlayAnimsWhileGamePaused(): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        static getId(arg0: Internal.ItemStack_): number;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        static "getId(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        stopTriggeredArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        notify(): void;
        quark$getPlacementState(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        place(arg0: Internal.BlockPlaceContext_): Internal.InteractionResult;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        updatePlacementContext(arg0: Internal.BlockPlaceContext_): Internal.BlockPlaceContext;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        puzzleslib$setBlock(arg0: Internal.Block_): void;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get perspectiveAware(): boolean
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get block(): Internal.Block
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get boneResetTime(): number
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type TwilightLanternDisplayItem_ = TwilightLanternDisplayItem;
    class NozzleBlockEntity extends Internal.SmartBlockEntity {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        requestModelDataUpdate(): void;
        destroy(): void;
        sodiumdynamiclights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        readClient(arg0: Internal.CompoundTag_): void;
        isVirtual(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        remove(): void;
        load(arg0: Internal.CompoundTag_): void;
        award(arg0: Internal.CreateAdvancement_): void;
        setChanged(): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        handler$dok000$setRemoved(arg0: Internal.CallbackInfo_): void;
        setRemoved(): void;
        sdl$isDynamicLightEnabled(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        writeSafe(arg0: Internal.CompoundTag_): void;
        getType(): Internal.BlockEntityType<any>;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        refreshBlockState(): void;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        setRange(arg0: number): void;
        sendToMenu(arg0: Internal.FriendlyByteBuf_): void;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        sdl$shouldUpdateDynamicLight(): boolean;
        addBehaviours(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        clearRemoved(): void;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        setLazyTickRate(arg0: number): void;
        awardIfNear(arg0: Internal.CreateAdvancement_, arg1: number): void;
        sdl$getDynamicLightX(): number;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        markVirtual(): void;
        triggerEvent(arg0: number, arg1: number): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        forEachBehaviour(arg0: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        sdl$dynamicLightTick(): void;
        invalidate(): void;
        wait(arg0: number): void;
        reviveCaps(): void;
        sendData(): void;
        getBehaviour<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BehaviourType_<T>): T;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        setLevel(arg0: Internal.Level_): void;
        sdl$getLuminance(): number;
        notify(): void;
        addBehavioursDeferred(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        handler$dok000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        getBlockPos(): BlockPos;
        sdl$resetDynamicLight(): void;
        isRemoved(): boolean;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        sdl$getDynamicLightY(): number;
        sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        initialize(): void;
        invalidateCaps(): void;
        getBlockState(): Internal.BlockState;
        tick(): void;
        canPlayerUse(arg0: Internal.Player_): boolean;
        lazyTick(): void;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        m_183515_(arg0: Internal.CompoundTag_): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        notifyUpdate(): void;
        sdl$getDynamicLightLevel(): Internal.Level;
        wait(arg0: number, arg1: number): void;
        isChunkUnloaded(): boolean;
        getLevel(): Internal.Level;
        getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        onlyOpCanSetNbt(): boolean;
        sdl$getDynamicLightZ(): number;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        serializeNBT(): Internal.CompoundTag;
        registerAwardables(arg0: Internal.List_<Internal.BlockEntityBehaviour>, ...arg1: Internal.CreateAdvancement_[]): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        getModelData(): Internal.ModelData;
        equals(arg0: any): boolean;
        get virtual(): boolean
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        get "updatePacket()"(): Internal.Packet<any>
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        set range(arg0: number)
        get updatePacket(): Internal.Packet<any>
        set lazyTickRate(arg0: number)
        get persistentData(): Internal.CompoundTag
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        get chunkUnloaded(): boolean
        get level(): Internal.Level
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get modelData(): Internal.ModelData
    }
    type NozzleBlockEntity_ = NozzleBlockEntity;
    class TelemetryEventInstance extends Internal.Record {
        constructor(arg0: Internal.TelemetryEventType_, arg1: Internal.TelemetryPropertyMap_)
        getClass(): typeof any;
        type(): Internal.TelemetryEventType;
        hashCode(): number;
        export(arg0: Internal.TelemetrySession_): Internal.TelemetryEvent;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        properties(): Internal.TelemetryPropertyMap;
        get class(): typeof any
        static readonly CODEC: Internal.Codec<Internal.TelemetryEventInstance>;
    }
    type TelemetryEventInstance_ = TelemetryEventInstance;
    class DyedreamPlanksBlock extends Internal.Block {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type DyedreamPlanksBlock_ = DyedreamPlanksBlock;
    interface IStatSorter {
        abstract compare<T>(arg0: Internal.Player_, arg1: Internal.Function_<T, Internal.ItemStack>): Internal.Comparator<T>;
        abstract getValue(arg0: Internal.Player_, arg1: Internal.ItemStack_): string;
        getPriority(): Internal.Priority;
        abstract shouldShow(arg0: Internal.Player_, arg1: Internal.ItemStack_): boolean;
        abstract getName(): string;
        get priority(): Internal.Priority
        get name(): string
    }
    type IStatSorter_ = IStatSorter;
    interface IGuiHelper {
        abstract drawableBuilder(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number): Internal.IDrawableBuilder;
        abstract createCraftingGridHelper(): Internal.ICraftingGridHelper;
        abstract createAnimatedRecipeArrow(arg0: number): Internal.IDrawableAnimated;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract getScrollBoxScrollbarExtraWidth(): number;
        abstract createAnimatedDrawable(arg0: Internal.IDrawableStatic_, arg1: Internal.ITickTimer_, arg2: Internal.IDrawableAnimated$StartDirection_): Internal.IDrawableAnimated;
        abstract getRecipePlusSign(): Internal.IDrawableStatic;
        abstract createTickTimer(arg0: number, arg1: number, arg2: boolean): Internal.ITickTimer;
        abstract "createScrollBoxWidget(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): Internal.IScrollBoxWidget;
        abstract getRecipeArrow(): Internal.IDrawableStatic;
        abstract createBlankDrawable(arg0: number, arg1: number): Internal.IDrawableStatic;
        abstract createDrawableIngredient<V>(arg0: Internal.IIngredientType_<V>, arg1: V): Internal.IDrawable;
        abstract getOutputSlot(): Internal.IDrawableStatic;
        abstract getRecipeArrowFilled(): Internal.IDrawableStatic;
        abstract createDrawableIngredient<V>(arg0: Internal.ITypedIngredient_<V>): Internal.IDrawable;
        abstract createAnimatedDrawable(arg0: Internal.IDrawableStatic_, arg1: number, arg2: Internal.IDrawableAnimated$StartDirection_, arg3: boolean): Internal.IDrawableAnimated;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract "createScrollBoxWidget(mezz.jei.api.gui.drawable.IDrawable,int,int,int)"(arg0: Internal.IDrawable_, arg1: number, arg2: number, arg3: number): Internal.IScrollBoxWidget;
        abstract getSlotDrawable(): Internal.IDrawableStatic;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract createScrollGridFactory(arg0: number, arg1: number): Internal.IScrollGridWidgetFactory<any>;
        abstract getRecipeFlameFilled(): Internal.IDrawableStatic;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        abstract createScrollBoxWidget(arg0: Internal.IDrawable_, arg1: number, arg2: number, arg3: number): Internal.IScrollBoxWidget;
        createDrawableItemLike(arg0: Internal.ItemLike_): Internal.IDrawable;
        abstract createScrollBoxWidget(arg0: number, arg1: number, arg2: number, arg3: number): Internal.IScrollBoxWidget;
        createDrawableItemStack(arg0: Internal.ItemStack_): Internal.IDrawable;
        abstract getRecipeFlameEmpty(): Internal.IDrawableStatic;
        createDrawable(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number): Internal.IDrawableStatic;
        abstract createAnimatedRecipeFlame(arg0: number): Internal.IDrawableAnimated;
        abstract createWidgetFromDrawable(arg0: Internal.IDrawable_, arg1: number, arg2: number): Internal.IRecipeWidget;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get scrollBoxScrollbarExtraWidth(): number
        get recipePlusSign(): Internal.IDrawableStatic
        get recipeArrow(): Internal.IDrawableStatic
        get outputSlot(): Internal.IDrawableStatic
        get recipeArrowFilled(): Internal.IDrawableStatic
        get slotDrawable(): Internal.IDrawableStatic
        get recipeFlameFilled(): Internal.IDrawableStatic
        get recipeFlameEmpty(): Internal.IDrawableStatic
    }
    type IGuiHelper_ = IGuiHelper;
    class MobType {
        constructor()
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        static readonly ILLAGER: (Internal.MobType) & (Internal.MobType);
        static readonly WATER: (Internal.MobType) & (Internal.MobType);
        static readonly UNDEFINED: (Internal.MobType) & (Internal.MobType);
        static readonly UNDEAD: (Internal.MobType) & (Internal.MobType);
        static readonly ARTHROPOD: (Internal.MobType) & (Internal.MobType);
    }
    type MobType_ = MobType;
    interface ConfigWriter {
        writeToString(arg0: Internal.UnmodifiableConfig_): string;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.nio.file.Path,com.electronwill.nightconfig.core.io.WritingMode)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.nio.file.Path,com.electronwill.nightconfig.core.io.WritingMode,java.nio.charset.Charset)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.io.OutputStream,java.nio.charset.Charset)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_, arg2: Internal.Charset_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.io.File,com.electronwill.nightconfig.core.io.WritingMode)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_): void;
        abstract "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.io.Writer)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Writer_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.io.OutputStream)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.URL_): void;
        abstract write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Writer_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_, arg2: Internal.Charset_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.io.File,com.electronwill.nightconfig.core.io.WritingMode,java.nio.charset.Charset)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        "write(com.electronwill.nightconfig.core.UnmodifiableConfig,java.net.URL)"(arg0: Internal.UnmodifiableConfig_, arg1: Internal.URL_): void;
    }
    type ConfigWriter_ = ConfigWriter;
    abstract class ChunkSource implements Internal.AutoCloseable, Internal.LightChunkGetter {
        constructor()
        getClass(): typeof any;
        abstract gatherStats(): string;
        abstract getLoadedChunksCount(): number;
        updateChunkForced(arg0: Internal.ChunkPos_, arg1: boolean): void;
        abstract getLevel(): Internal.BlockGetter;
        toString(): string;
        abstract tick(arg0: Internal.BooleanSupplier_, arg1: boolean): void;
        notifyAll(): void;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        hasChunk(arg0: number, arg1: number): boolean;
        setSpawnSettings(arg0: boolean, arg1: boolean): void;
        getChunk(arg0: number, arg1: number, arg2: boolean): Internal.LevelChunk;
        notify(): void;
        getChunkNow(arg0: number, arg1: number): Internal.LevelChunk;
        onLightUpdate(arg0: Internal.LightLayer_, arg1: Internal.SectionPos_): void;
        wait(arg0: number, arg1: number): void;
        getChunkForLighting(arg0: number, arg1: number): Internal.LightChunk;
        hashCode(): number;
        wait(): void;
        close(): void;
        wait(arg0: number): void;
        abstract getLightEngine(): Internal.LevelLightEngine;
        equals(arg0: any): boolean;
        get class(): typeof any
        get loadedChunksCount(): number
        get level(): Internal.BlockGetter
        get lightEngine(): Internal.LevelLightEngine
    }
    type ChunkSource_ = ChunkSource;
    class SwissRollItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type SwissRollItem_ = SwissRollItem;
    class OptionBoolean implements Internal.IOption<boolean> {
        constructor(arg0: Internal.CompoundTag_, arg1: string, arg2: boolean, arg3: boolean)
        constructor(arg0: Internal.CompoundTag_, arg1: string, arg2: boolean)
        getClass(): typeof any;
        getKeyTranslation(): string;
        get(): any;
        getKey(): string;
        toString(): string;
        set(arg0: any): void;
        getValueTranslation(): string;
        notifyAll(): void;
        getDescTranslation(): string;
        "set(java.lang.Boolean)"(arg0: boolean): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        isEnabled(): boolean;
        next(): boolean;
        "set(java.lang.Object)"(arg0: any): void;
        hashCode(): number;
        wait(): void;
        getValueString(): string;
        wait(arg0: number): void;
        set(arg0: boolean): void;
        next(arg0: boolean): boolean;
        equals(arg0: any): boolean;
        setValueString(arg0: string): void;
        get class(): typeof any
        get keyTranslation(): string
        get key(): string
        get valueTranslation(): string
        get descTranslation(): string
        set "(java.lang.Boolean)"(arg0: boolean)
        get enabled(): boolean
        set "(java.lang.Object)"(arg0: any)
        get valueString(): string
        set valueString(arg0: string)
    }
    type OptionBoolean_ = OptionBoolean;
    class RepairDefinition {
        constructor(arg0: Internal.OutcomeDefinition_)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        static validateOutcome(arg0: Internal.OutcomeDefinition_): boolean;
        get class(): typeof any
        replace: boolean;
        experienceCost: number;
        material: Internal.OutcomeMaterial;
        requiredTools: Internal.ToolData;
        moduleKey: string;
        moduleVariant: string;
    }
    type RepairDefinition_ = RepairDefinition;
    abstract class AbstractSkeleton extends Internal.Monster implements Internal.RangedAttackMob {
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        static checkMobSpawnRules(arg0: Internal.EntityType_<Internal.Mob>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isSuppressingBounce(): boolean;
        setTarget(arg0: Internal.LivingEntity_): void;
        isOnFire(): boolean;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        isShaking(): boolean;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        convertTo<T extends Internal.Mob>(arg0: Internal.EntityType_<T>, arg1: boolean): T;
        getFallFlyingTicks(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        dropLeash(arg0: boolean, arg1: boolean): void;
        gameEvent(arg0: Internal.GameEvent_): void;
        setXxa(arg0: number): void;
        setDelayedLeashHolderId(arg0: number): void;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        setMotionZ(z: number): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        getBlockY(): number;
        isSpectator(): boolean;
        setMainHandItem(item: Internal.ItemStack_): void;
        removeEffectNoUpdate(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getHealth(): number;
        getMaxHealth(): number;
        setPathfindingMalus(arg0: Internal.BlockPathTypes_, arg1: number): void;
        isRegisteredToWorld(): boolean;
        redirect$bjn000$apoth_sunderingGetAmplifier(arg0: Internal.MobEffectInstance_): number;
        getRandomZ(arg0: number): number;
        pehkui_getOnGround(): boolean;
        setAggressive(arg0: boolean): void;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        setZza(arg0: number): void;
        getBlock(): Internal.BlockContainerJS;
        redirect$bjn000$apoth_applyArmorPen(arg0: number, arg1: number, arg2: number, arg3: DamageSource_, arg4: number): number;
        setEquipment(slot: EquipmentSlot_, item: Internal.ItemStack_): void;
        randomTeleport(arg0: number, arg1: number, arg2: number, arg3: boolean): boolean;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        playAmbientSound(): void;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        getArmorValue(): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        getKillCredit(): Internal.LivingEntity;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        sinkInFluid(arg0: Internal.FluidType_): void;
        hasPermissions(arg0: number): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        pehkui_readScaleNbt(nbt: Internal.CompoundTag_): void;
        bo$refreshEntityData(data: number): void;
        static createMobAttributes(): Internal.AttributeSupplier$Builder;
        isAutoSpinAttack(): boolean;
        getRemainingFireTicks(): number;
        handler$daa000$onClientRemoval(ci: Internal.CallbackInfo_): void;
        onlyOpCanSetNbt(): boolean;
        handler$cme000$heal(arg0: number, arg1: Internal.CallbackInfo_): void;
        handler$dad000$getMainArm(cir: Internal.CallbackInfoReturnable_<any>): void;
        fireImmune(): boolean;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        getMaxFallDistance(): number;
        isHolding(arg0: Internal.Item_): boolean;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        static areAllEffectsAmbient(arg0: Internal.Collection_<Internal.MobEffectInstance>): boolean;
        doHurtTarget(arg0: Internal.Entity_): boolean;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        create$callSpawnItemParticles(arg0: Internal.ItemStack_, arg1: number): void;
        handler$daa000$playerTouch(pPlayer: Internal.Player_, ci: Internal.CallbackInfo_): void;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        handler$daa000$getMaxFallDistance(cir: Internal.CallbackInfoReturnable_<any>): void;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        getVoicePitch(): number;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        setSleepingPos(arg0: BlockPos_): void;
        localvar$dng000$fluidCollision(arg0: Vec3d_): Vec3d;
        isDescending(): boolean;
        getAttributeBaseValue(arg0: Internal.Attribute_): number;
        sendEffectToPassengers(arg0: Internal.MobEffectInstance_): void;
        getHeadRotSpeed(): number;
        getYHeadRot(): number;
        getProjectile(arg0: Internal.ItemStack_): Internal.ItemStack;
        damageEquipment(slot: EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        setAbsorptionAmount(arg0: number): void;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        removeAllGoals(arg0: Internal.Predicate_<Internal.Goal>): void;
        swing(): void;
        handler$dad000$canPickUpLoot(cir: Internal.CallbackInfoReturnable_<any>): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        handler$bnk000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        canStartSwimming(): boolean;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        isBaby(): boolean;
        damageEquipment(slot: EquipmentSlot_): void;
        setFireType(arg0: ResourceLocation_): void;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        getWalkTargetValue(arg0: BlockPos_): number;
        /**
         * @deprecated
        */
        canBreatheUnderwater(): boolean;
        die(arg0: DamageSource_): void;
        removeAllEffects(): boolean;
        handler$dnj000$CMcanAttack(arg0: Internal.LivingEntity_, arg1: Internal.CallbackInfoReturnable_<any>): void;
        getLeashOffset(): Vec3d;
        hasLineOfSight(arg0: Internal.Entity_): boolean;
        handler$dad000$ate(ci: Internal.CallbackInfo_): void;
        onClimbable(): boolean;
        isAttackable(): boolean;
        getSlot(arg0: number): Internal.SlotAccess;
        jerotes_$summon(arg0: Internal.VariantZsieinEntity_, arg1: Internal.ServerLevel_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        pehkui_constructScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        isUnderWater(): boolean;
        stopRiding(): void;
        getLeashHolder(): Internal.Entity;
        getX(arg0: number): number;
        getSensing(): Internal.Sensing;
        getLegsArmorItem(): Internal.ItemStack;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getDeltaMovement(): Vec3d;
        canTakeItem(arg0: Internal.ItemStack_): boolean;
        shouldDropExperience(): boolean;
        hasPassenger(arg0: Internal.Entity_): boolean;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        getLootTable(): ResourceLocation;
        getTicksUsingItem(): number;
        getArrowCount(): number;
        create$callSetLevel(arg0: Internal.Level_): void;
        getMoveControl(): Internal.MoveControl;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        handler$daa000$rideTick(ci: Internal.CallbackInfo_): void;
        getDefaultMovementSpeed(): number;
        restoreFrom(arg0: Internal.Entity_): void;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        addEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): boolean;
        ate(): void;
        setPos(arg0: number, arg1: number, arg2: number): void;
        notify(): void;
        getFirstTick(): boolean;
        setPersistenceRequired(): void;
        getLastHurtByMobTimestamp(): number;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        setSpawnCancelled(arg0: boolean): void;
        getStringUuid(): string;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getMainArm(): Internal.HumanoidArm;
        checkSpawnRules(arg0: Internal.LevelAccessor_, arg1: Internal.MobSpawnType_): boolean;
        getRotationVector(): Internal.Vec2;
        abstract sdl$getDynamicLightY(): number;
        getHurtDir(): number;
        isSprinting(): boolean;
        isMaxGroupSizeReached(arg0: number): boolean;
        handler$daa000$canChangeDimensions(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionY(): number;
        getOffhandItem(): Internal.ItemStack;
        canCollideWith(arg0: Internal.Entity_): boolean;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        clearSleepingPos(): void;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        getLastHurtMob(): Internal.LivingEntity;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        handler$daa000$getMyRidingOffset(cir: Internal.CallbackInfoReturnable_<any>): void;
        getSoundSource(): Internal.SoundSource;
        getLastDamageSource(): DamageSource;
        setNoActionTime(arg0: number): void;
        setMovementSpeedAddition(speed: number): void;
        equipmentHasChanged(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getPose(): Internal.Pose;
        getAttribute(arg0: Internal.Attribute_): Internal.AttributeInstance;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        canBeAffected(arg0: Internal.MobEffectInstance_): boolean;
        quark$lastHurtByPlayer(): Internal.Player;
        handler$daa000$isPickable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getRestrictCenter(): BlockPos;
        isLeftHanded(): boolean;
        removeVehicle(): void;
        setZ(z: number): void;
        getY(): number;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        eat(arg0: Internal.Level_, arg1: Internal.ItemStack_): Internal.ItemStack;
        bookshelf$makePoofParticles(): void;
        isWithinMeleeAttackRange(arg0: Internal.LivingEntity_): boolean;
        static checkMonsterSpawnRules(arg0: Internal.EntityType_<Internal.Monster>, arg1: Internal.ServerLevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        broadcastBreakEvent(arg0: EquipmentSlot_): void;
        handler$daa000$isInvulnerableTo(pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        isBlocking(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        getArmorCoverPercentage(): number;
        handleRelativeFrictionAndCalculateMovement(arg0: Vec3d_, arg1: number): Vec3d;
        turn(arg0: number, arg1: number): void;
        getAirSupply(): number;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isAnimal(): boolean;
        isPlayer(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        sdl$isDynamicLightEnabled(): boolean;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        jumpInFluid(arg0: Internal.FluidType_): void;
        getCommandSenderWorld(): Internal.Level;
        quark$lastHurtByPlayerTime(): number;
        getTotalMovementSpeed(): number;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3d_, arg2: number): boolean;
        pehkui_shouldIgnoreScaleNbt(): boolean;
        isMoving(): boolean;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getAttributes(): Internal.AttributeMap;
        isSpawnCancelled(): boolean;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        abstract sdl$getDynamicLightX(): number;
        isSwimming(): boolean;
        setSprinting(arg0: boolean): void;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        addSyncedData(type: Internal.EntitySerializerType_, key: string, value: any): void;
        setPortalCooldown(): void;
        getAttackAnim(arg0: number): number;
        setX(x: number): void;
        handler$dad000$getAmbientSoundInterval(cir: Internal.CallbackInfoReturnable_<any>): void;
        getPortalWaitTime(): number;
        getBlockStateOn(): Internal.BlockState;
        getItemBySlot(arg0: EquipmentSlot_): Internal.ItemStack;
        wantsToPickUp(arg0: Internal.ItemStack_): boolean;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(x: number, y: number, z: number, yaw: number, pitch: number): void;
        handler$bbl000$curio$canFreeze(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isInvisibleTo(arg0: Internal.Player_): boolean;
        handler$dad003$mobInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        stopSleeping(): void;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        isUndead(): boolean;
        static createLivingAttributes(): Internal.AttributeSupplier$Builder;
        pehkui_getScales(): Internal.Map<any, any>;
        getStepHeight(): number;
        setRegisteredToWorld(navigation: Internal.PathNavigation_): void;
        isSleeping(): boolean;
        stopUsingItem(): void;
        acceptsFailure(): boolean;
        pehkui_setShouldIgnoreScaleNbt(ignore: boolean): void;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        getFluidFallingAdjustedMovement(arg0: number, arg1: boolean, arg2: Vec3d_): Vec3d;
        setOldPosAndRot(): void;
        static createMonsterAttributes(): Internal.AttributeSupplier$Builder;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        getDismountPoses(): Internal.ImmutableList<Internal.Pose>;
        getLastHurtMobTimestamp(): number;
        getMobSpawnType(): Internal.MobSpawnType;
        lithiumOnEquipmentChanged(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        reassessWeaponGoal(): void;
        setCanPickUpLoot(arg0: boolean): void;
        getMainHandItem(): Internal.ItemStack;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        handler$dad000$setTarget(pTarget: Internal.LivingEntity_, ci: Internal.CallbackInfo_): void;
        getFireType(): ResourceLocation;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        canBeSeenAsEnemy(): boolean;
        handler$daa000$onAddedToWorld(ci: Internal.CallbackInfo_): void;
        setLeftHanded(arg0: boolean): void;
        getActiveEffects(): Internal.Collection<Internal.MobEffectInstance>;
        handler$cln000$setRemoved(arg0: Internal.Entity$RemovalReason_, arg1: Internal.CallbackInfo_): void;
        isOnPortalCooldown(): boolean;
        canAttack(arg0: Internal.LivingEntity_, arg1: Internal.TargetingConditions_): boolean;
        performRangedAttack(arg0: Internal.LivingEntity_, arg1: number): void;
        setUranusEntityData(nbt: Internal.CompoundTag_): void;
        getAttributeValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        handler$daa000$lavaHurt(ci: Internal.CallbackInfo_): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        getParts(): Internal.PartEntity<any>[];
        isUsingItem(): boolean;
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        handler$dgn000$increaseAirSupply(arg0: number, arg1: Internal.CallbackInfoReturnable_<any>): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getForgePersistentData(): Internal.CompoundTag;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        "broadcastBreakEvent(net.minecraft.world.entity.EquipmentSlot)"(arg0: EquipmentSlot_): void;
        setLeashedTo(arg0: Internal.Entity_, arg1: boolean): void;
        isAlive(): boolean;
        biomancy$setMoveControl(arg0: Internal.MoveControl_): void;
        startSleeping(arg0: BlockPos_): void;
        getBbHeight(): number;
        getMeleeAttackRangeSqr(arg0: Internal.LivingEntity_): number;
        handler$daa000$push(pEntity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        bookshelf$getDrinkingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        handler$dad000$isPersistenceRequired(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTags(): Internal.Set<string>;
        getViewVector(arg0: number): Vec3d;
        getLastAttacker(): Internal.LivingEntity;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        onPathfindingStart(): void;
        getPercentFrozen(): number;
        setPortalCooldown(arg0: number): void;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        isLeashed(): boolean;
        addEffect(arg0: Internal.MobEffectInstance_): boolean;
        handler$eoj001$canAttack(arg0: Internal.LivingEntity_, arg1: Internal.CallbackInfoReturnable_<any>): void;
        handler$daa000$canCollideWith(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        canRiderInteract(): boolean;
        getViewXRot(arg0: number): number;
        biomancy$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        setPose(arg0: Internal.Pose_): void;
        getReachDistance(): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        pehkui_getScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        setLastHurtByPlayer(arg0: Internal.Player_): void;
        "getServer()"(): Internal.MinecraftServer;
        wasExperienceConsumed(): boolean;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        foodEaten(is: Internal.ItemStack_): void;
        onClientRemoval(): void;
        self(): Internal.LivingEntity;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        handler$daa000$isCurrentlyGlowing(cir: Internal.CallbackInfoReturnable_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        handler$dad000$getMeleeAttackRangeSqr(pEntity: Internal.LivingEntity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        abstract sdl$resetDynamicLight(): void;
        calculateEntityAnimation(arg0: boolean): void;
        forceAddEffect(arg0: Internal.MobEffectInstance_, arg1: Internal.Entity_): void;
        handler$dlf000$onRemove(ci: Internal.CallbackInfo_): void;
        setChestArmorItem(item: Internal.ItemStack_): void;
        abstract sodiumdynamiclights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        bookshelf$getHurtSound(arg0: DamageSource_): Internal.SoundEvent;
        onAboveBubbleCol(arg0: boolean): void;
        handler$dad000$canHoldItem(pStack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        isSensitiveToWater(): boolean;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        "getAttributeValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        getJumpControl(): Internal.JumpControl;
        handler$daa000$onInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getFeetArmorItem(): Internal.ItemStack;
        static getViewScale(): number;
        getVisualRotationYInDegrees(): number;
        setSpeed(arg0: number): void;
        canAddPassengerJerotes(arg0: Internal.Entity_): boolean;
        requiresCustomPersistence(): boolean;
        isDiscrete(): boolean;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        biomancy$setJumpControl(arg0: Internal.JumpControl_): void;
        getCombatTracker(): Internal.CombatTracker;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        isNoAi(): boolean;
        handler$daa000$mayInteract(pLevel: Internal.Level_, pPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: EquipmentSlot_, amount: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        biomancy$getDeathSound(): Internal.SoundEvent;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        indicateDamage(arg0: number, arg1: number): void;
        canBeSeenByAnyone(): boolean;
        isFullyFrozen(): boolean;
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getScale(): number;
        isSuppressingSlidingDownLadder(): boolean;
        getBlockZ(): number;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(id: Internal.SoundEvent_): void;
        getPitch(): number;
        getPathfindingMalus(arg0: Internal.BlockPathTypes_): number;
        getRandom(): Internal.RandomSource;
        canReplaceEqualItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        rotate(arg0: Internal.Rotation_): number;
        shouldRiderFaceForward(arg0: Internal.Player_): boolean;
        getPassengersAndSelf(): Internal.Stream<any>;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        "getAttributeBaseValue(net.minecraft.core.Holder)"(arg0: Internal.Holder_<Internal.Attribute>): number;
        clearRestriction(): void;
        biomancy$getAmbientSound(): Internal.SoundEvent;
        "self()"(): Internal.LivingEntity;
        rayTrace(): Internal.RayTraceResultJS;
        alwaysAccepts(): boolean;
        handler$daa000$thunderHit(pLevel: Internal.ServerLevel_, pLightning: Internal.LightningBolt_, ci: Internal.CallbackInfo_): void;
        "isHolding(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        handler$daa000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getNoActionTime(): number;
        isVisuallyCrawling(): boolean;
        isAggressive(): boolean;
        setYya(arg0: number): void;
        handler$dac000$brainProvider(cir: Internal.CallbackInfoReturnable_<any>): void;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        abstract sdl$shouldUpdateDynamicLight(): boolean;
        setDropChance(arg0: EquipmentSlot_, arg1: number): void;
        "broadcastBreakEvent(net.minecraft.world.InteractionHand)"(arg0: Internal.InteractionHand_): void;
        handler$daa000$setSprinting(pSprinting: boolean, ci: Internal.CallbackInfo_): void;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        setBaby(arg0: boolean): void;
        getLastHurtByMob(): Internal.LivingEntity;
        pehkui_setScaleCache(scaleCache: Internal.ScaleData_[]): void;
        isInWaterOrBubble(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        getPortalCooldown(): number;
        setSyncedData(key: string, value: any): void;
        getItem(): Internal.ItemStack;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        releaseUsingItem(): void;
        getPosition(arg0: number): Vec3d;
        removeFreeWill(): void;
        removeWhenFarAway(arg0: number): boolean;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        setRecordPlayingNearby(arg0: BlockPos_, arg1: boolean): void;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        hasItemInSlot(arg0: EquipmentSlot_): boolean;
        canUpdate(arg0: boolean): void;
        getEyeInFluidType(): Internal.FluidType;
        distanceToSqr(arg0: Vec3d_): number;
        handler$ehh000$onEntityFall(fallDistance: number, multiplier: number, source: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$daa000$dampensVibrations(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSteppingCarefully(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        getBlockX(): number;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        handler$daa000$causeFallDamage(pFallDistance: number, pMultiplier: number, pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        isFallFlying(): boolean;
        getEncodeId(): string;
        getY(arg0: number): number;
        redirect$bjn000$apoth_applyProtPen(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        getMaxHeadXRot(): number;
        getNbt(): Internal.CompoundTag;
        handler$dad000$removeWhenFarAway(pDistanceToClosestPlayer: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        setInvisible(arg0: boolean): void;
        getEffect(arg0: Internal.MobEffect_): Internal.MobEffectInstance;
        setTotalMovementSpeedMultiplier(speed: number): void;
        setHealth(arg0: number): void;
        handler$dlf002$onTick(ci: Internal.CallbackInfo_): void;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        setDiscardFriction(arg0: boolean): void;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        handler$daa000$isFreezing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getYaw(): number;
        swing(arg0: Internal.InteractionHand_, arg1: boolean): void;
        getUsedItemHand(): Internal.InteractionHand;
        setDefaultMovementSpeed(speed: number): void;
        canAttackType(arg0: Internal.EntityType_<any>): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        getBrain(): Internal.Brain<any>;
        setCustomNameVisible(arg0: boolean): void;
        isAlliedTo(arg0: Internal.Team_): boolean;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        handler$dad002$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        canFireProjectileWeapon(arg0: Internal.ProjectileWeaponItem_): boolean;
        getControllingPassenger(): Internal.LivingEntity;
        getScriptType(): Internal.ScriptType;
        shouldDiscardFriction(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        serializeNBT(): Internal.Tag;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        pehkui_isFirstUpdate(): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        handler$daa000$canFreeze(cir: Internal.CallbackInfoReturnable_<any>): void;
        getEyeY(): number;
        skipDropExperience(): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        setItemSlot(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): void;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        abstract sodiumdynamiclights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        isAffectedByPotions(): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getCitadelEntityData(): Internal.CompoundTag;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        static getEquipmentForSlot(arg0: EquipmentSlot_, arg1: number): Internal.Item;
        isWithinRestriction(arg0: BlockPos_): boolean;
        handler$daa000$entityJs$tick(ci: Internal.CallbackInfo_): void;
        handler$daa001$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTeam(): Internal.Team;
        handler$daa000$stopRiding(ci: Internal.CallbackInfo_): void;
        setTicksFrozen(arg0: number): void;
        handler$dac000$makeBrain(pDynamic: Internal.Dynamic_<any>, cir: Internal.CallbackInfoReturnable_<any>): void;
        getUseItem(): Internal.ItemStack;
        getMyRidingOffset(): number;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        hasCustomName(): boolean;
        getSwimAmount(arg0: number): number;
        isLiving(): boolean;
        getX(): number;
        isVehicle(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        redirect$bjn000$apoth_sunderingApplyEffect(arg0: number, arg1: number, arg2: DamageSource_, arg3: number): number;
        getTeamId(): string;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        setStingerCount(arg0: number): void;
        getMaxHeadYRot(): number;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        getLootTableSeed(): number;
        localvar$bjk000$apoth_checkFallDamageWithGravity(arg0: number): number;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        canBeLeashed(arg0: Internal.Player_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        sdl$dynamicLightTick(): void;
        bookshelf$getFallDamageSound(arg0: number): Internal.SoundEvent;
        handleInsidePortal(arg0: BlockPos_): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        biomancy$getVoicePitch(): number;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        isOnRails(): boolean;
        handler$daa000$canTrample(state: Internal.BlockState_, pos: BlockPos_, fallDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        getStingerCount(): number;
        getFallSounds(): Internal.LivingEntity$Fallsounds;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        getDimensionChangingDelay(): number;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        isPathFinding(): boolean;
        isRemoved(): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        spawnAnim(): void;
        getJumpBoostPower(): number;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        pehkui_writeScaleNbt(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        refreshDimensions(): void;
        handler$daa000$isAttackable(cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$dac000$getMobType(cir: Internal.CallbackInfoReturnable_<any>): void;
        bookshelf$getAmbientSound(): Internal.SoundEvent;
        "getAttributeValue(net.minecraft.world.entity.ai.attributes.Attribute)"(arg0: Internal.Attribute_): number;
        "isHolding(net.minecraft.world.item.Item)"(arg0: Internal.Item_): boolean;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        setShiftKeyDown(arg0: boolean): void;
        getEyePosition(arg0: number): Vec3d;
        getPassengers(): Internal.EntityArrayList;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        handler$dad000$canTakeItem(pItemstack: Internal.ItemStack_, cir: Internal.CallbackInfoReturnable_<any>): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getAttributeBaseValue(arg0: Internal.Holder_<Internal.Attribute>): number;
        getServer(): Internal.MinecraftServer;
        getExperienceReward(): number;
        getFirstPassenger(): Internal.Entity;
        heal(arg0: number): void;
        getSpawnType(): Internal.MobSpawnType;
        setLastHurtMob(arg0: Internal.Entity_): void;
        setLastHurtByMob(arg0: Internal.LivingEntity_): void;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        abstract sdl$getDynamicLightLevel(): Internal.Level;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        canStandOnFluid(arg0: Internal.FluidState_): boolean;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getSleepingPos(): Internal.Optional<any>;
        touchingUnloadedChunk(): boolean;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        abstract sdl$getDynamicLightZ(): number;
        getLookAngle(): Vec3d;
        getAmbientSoundInterval(): number;
        setArrowCount(arg0: number): void;
        getMotionZ(): number;
        isPersistenceRequired(): boolean;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        handler$cme000$shouldDropExperience(arg0: Internal.CallbackInfoReturnable_<any>): void;
        getBedOrientation(): Internal.Direction;
        ejectPassengers(): void;
        removeEffect(arg0: Internal.MobEffect_): boolean;
        getProfile(): Internal.GameProfile;
        getUranusEntityData(): Internal.CompoundTag;
        isDeadOrDying(): boolean;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        static setViewScale(arg0: number): void;
        take(arg0: Internal.Entity_, arg1: number): void;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        biomancy$getSoundVolume(): number;
        getLookControl(): Internal.LookControl;
        isPreventingPlayerRest(arg0: Internal.Player_): boolean;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        canAttack(arg0: Internal.LivingEntity_): boolean;
        getOffHandItem(): Internal.ItemStack;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        handler$fdn000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isOnScoreboardTeam(teamId: string): boolean;
        redirect$bjn000$apoth_sunderingHasEffect(arg0: Internal.LivingEntity_, arg1: Internal.MobEffect_): boolean;
        startUsingItem(arg0: Internal.InteractionHand_): void;
        position(): Vec3d;
        biomancy$random(): Internal.RandomSource;
        handler$daa000$shouldRenderAtSqrDistance(pDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        static getEquipmentSlotForItem(arg0: Internal.ItemStack_): EquipmentSlot;
        getEquipment(slot: EquipmentSlot_): Internal.ItemStack;
        displayFireAnimation(): boolean;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        "getAttributeBaseValue(net.minecraft.world.entity.ai.attributes.Attribute)"(attribute: Internal.Attribute_): number;
        onLeaveCombat(): void;
        handler$daa000$move(pType: Internal.MoverType_, pPos: Vec3d_, ci: Internal.CallbackInfo_): void;
        setY(y: number): void;
        getAttributeValue(arg0: Internal.Attribute_): number;
        getFeetBlockState(): Internal.BlockState;
        handler$bjn000$apoth_onEffectUpdateRemoveAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        isWithinRestriction(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        setSharedFlag(arg0: number, arg1: boolean): void;
        entityJs$defineSynchedData(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        damageHeldItem(): void;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        handler$cme000$checkFallDamage(arg0: number, arg1: boolean, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.CallbackInfo_): void;
        isVisuallySwimming(): boolean;
        getMaxAirSupply(): number;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        entityJs$getTypeId(): string;
        setItemInHand(arg0: Internal.InteractionHand_, arg1: Internal.ItemStack_): void;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        getTarget(): Internal.LivingEntity;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        restrictTo(arg0: BlockPos_, arg1: number): void;
        handler$cme001$hurt(arg0: DamageSource_, arg1: number, arg2: Internal.CallbackInfoReturnable_<any>): void;
        handler$dae000$getWalkTargetValue(pPos: BlockPos_, pLevel: Internal.LevelReader_, cir: Internal.CallbackInfoReturnable_<any>): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        isInWater(): boolean;
        finalizeSpawn(arg0: Internal.ServerLevelAccessor_, arg1: Internal.DifficultyInstance_, arg2: Internal.MobSpawnType_, arg3: Internal.SpawnGroupData_, arg4: Internal.CompoundTag_): Internal.SpawnGroupData;
        pehkui_getScaleCache(): Internal.ScaleData[];
        swing(arg0: Internal.InteractionHand_): void;
        hasEffect(arg0: Internal.MobEffect_): boolean;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getRootVehicle(): Internal.Entity;
        onPathfindingDone(): void;
        save(arg0: Internal.CompoundTag_): boolean;
        handler$daa000$onRemovedFromWorld(ci: Internal.CallbackInfo_): void;
        getLocalBoundsForPose(arg0: Internal.Pose_): Internal.AABB;
        sdl$getLuminance(): number;
        isNoGravity(): boolean;
        curePotionEffects(arg0: Internal.ItemStack_): boolean;
        onItemPickup(arg0: Internal.ItemEntity_): void;
        setCitadelEntityData(arg0: Internal.CompoundTag_): void;
        handler$bjn000$apoth_onEffectUpdateAddAttribute(arg0: Internal.MobEffectInstance_, arg1: boolean, arg2: Internal.Entity_, arg3: Internal.CallbackInfo_): void;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        updateSwimming(): void;
        isHolding(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getSpeed(): number;
        abstract getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        wait(): void;
        addSyncedData(identifier: string, value: any): void;
        getUuid(): Internal.UUID;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        setNoAi(arg0: boolean): void;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        shouldShowName(): boolean;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        handler$daa000$lerpTo(x: number, y: number, z: number, yaw: number, pitch: number, posRotationIncrements: number, teleport: boolean, ci: Internal.CallbackInfo_): void;
        canPickUpLoot(): boolean;
        kill(): void;
        onEnterCombat(): void;
        updateNavigationRegistration(): void;
        animateHurt(arg0: number): void;
        static resetForwardDirectionOfRelativePortalPosition(arg0: Vec3d_): Vec3d;
        brainProvider(): Internal.Brain$Provider<any>;
        hasRestriction(): boolean;
        handler$dad000$canBeLeashed(pPlayer: Internal.Player_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getHeadArmorItem(): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        deserializeNBT(arg0: Internal.Tag_): void;
        revive(): void;
        getBbWidth(): number;
        static checkAnyLightMonsterSpawnRules(arg0: Internal.EntityType_<Internal.Monster>, arg1: Internal.LevelAccessor_, arg2: Internal.MobSpawnType_, arg3: BlockPos_, arg4: Internal.RandomSource_): boolean;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        addDeltaMovement(arg0: Vec3d_): void;
        pehkui_setOnGround(onGround: boolean): void;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        "getName()"(): net.minecraft.network.chat.Component;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        knockback(arg0: number, arg1: number, arg2: number): void;
        getTicksRequiredToFreeze(): number;
        getVisibilityPercent(arg0: Internal.Entity_): number;
        getMaxSpawnClusterSize(): number;
        getUsername(): string;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        onRemovedFromWorld(): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        setJumping(arg0: boolean): void;
        getPickResult(): Internal.ItemStack;
        "getMainHandItem()"(): Internal.ItemStack;
        getAbsorptionAmount(): number;
        getRandomY(): number;
        getDisplayName(): net.minecraft.network.chat.Component;
        getMobType(): Internal.MobType;
        travel(arg0: Vec3d_): void;
        getItemInHand(arg0: Internal.InteractionHand_): Internal.ItemStack;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        shouldBeSaved(): boolean;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        canSpawnSoulSpeedParticle(): boolean;
        getSyncedData(identifier: string): any;
        notifyAll(): void;
        aiStep(): void;
        getPassengersRidingOffset(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        isFrame(): boolean;
        broadcastBreakEvent(arg0: Internal.InteractionHand_): void;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        discard(): void;
        handler$daa000$showVehicleHealth(cir: Internal.CallbackInfoReturnable_<any>): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        setNoGravity(arg0: boolean): void;
        getUseItemRemainingTicks(): number;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        attackable(): boolean;
        createCommandSourceStack(): Internal.CommandSourceStack;
        getNavigation(): Internal.PathNavigation;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        pehkui_setShouldSyncScales(sync: boolean): void;
        getLastClimbablePos(): Internal.Optional<BlockPos>;
        getEatingSound(arg0: Internal.ItemStack_): Internal.SoundEvent;
        getPerceivedTargetDistanceSquareForMeleeAttack(arg0: Internal.LivingEntity_): number;
        getHorizontalFacing(): Internal.Direction;
        setId(arg0: number): void;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        isDamageSourceBlocked(arg0: DamageSource_): boolean;
        getLightProbePosition(arg0: number): Vec3d;
        getActiveEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>;
        onEquipItem(arg0: EquipmentSlot_, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_): void;
        static isDarkEnoughToSpawn(arg0: Internal.ServerLevelAccessor_, arg1: BlockPos_, arg2: Internal.RandomSource_): boolean;
        checkDespawn(): void;
        pehkui_shouldSyncScales(): boolean;
        getWalkTargetValue(arg0: BlockPos_, arg1: Internal.LevelReader_): number;
        lookAt(arg0: Internal.Entity_, arg1: number, arg2: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        equipItemIfPossible(arg0: Internal.ItemStack_): Internal.ItemStack;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        canDisableShield(): boolean;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        bookshelf$getDeathSound(): Internal.SoundEvent;
        wait(arg0: number, arg1: number): void;
        getTeamColor(): number;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listenForCachedBlockChanges: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        handler$dad000$doHurtTarget(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        checkSpawnObstruction(arg0: Internal.LevelReader_): boolean;
        extinguish(): void;
        getRestrictRadius(): number;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "swing(net.minecraft.world.InteractionHand)"(hand: Internal.InteractionHand_): void;
        getRegisteredNavigation(): Internal.PathNavigation;
        isInvertedHealAndHarm(): boolean;
        canHoldItem(arg0: Internal.ItemStack_): boolean;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        handler$bjn000$apoth_ownedAttrMap(arg0: Internal.EntityType_<any>, arg1: Internal.Level_, arg2: Internal.CallbackInfo_): void;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        runCommand(command: string): number;
        setGuaranteedDrop(arg0: EquipmentSlot_): void;
        setSharedFlagOnFire(arg0: boolean): void;
        set defaultMovementSpeedMultiplier(speed: number)
        get suppressingBounce(): boolean
        set target(arg0: Internal.LivingEntity_)
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get shaking(): boolean
        set maxUpStep(arg0: number)
        get fallFlyingTicks(): number
        set xxa(arg0: number)
        set delayedLeashHolderId(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        set mainHandItem(item: Internal.ItemStack_)
        get persistentData(): Internal.CompoundTag
        get health(): number
        get maxHealth(): number
        get registeredToWorld(): boolean
        set aggressive(arg0: boolean)
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        set zza(arg0: number)
        get block(): Internal.BlockContainerJS
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get armorValue(): number
        get killCredit(): Internal.LivingEntity
        get autoSpinAttack(): boolean
        get remainingFireTicks(): number
        get maxFallDistance(): number
        get ticksFrozen(): number
        get voicePitch(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        set sleepingPos(arg0: BlockPos_)
        get descending(): boolean
        get headRotSpeed(): number
        get YHeadRot(): number
        set absorptionAmount(arg0: number)
        set deltaMovement(arg0: Vec3d_)
        get baby(): boolean
        set fireType(arg0: ResourceLocation_)
        get glowing(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        get underWater(): boolean
        get leashHolder(): Internal.Entity
        get sensing(): Internal.Sensing
        get legsArmorItem(): Internal.ItemStack
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get lootTable(): ResourceLocation
        get ticksUsingItem(): number
        get arrowCount(): number
        get moveControl(): Internal.MoveControl
        get defaultMovementSpeed(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        get firstTick(): boolean
        get lastHurtByMobTimestamp(): number
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        set spawnCancelled(arg0: boolean)
        get stringUuid(): string
        set swimming(arg0: boolean)
        get mainArm(): Internal.HumanoidArm
        get rotationVector(): Internal.Vec2
        get hurtDir(): number
        get sprinting(): boolean
        get motionY(): number
        get offhandItem(): Internal.ItemStack
        get lastHurtMob(): Internal.LivingEntity
        get addedToWorld(): boolean
        get soundSource(): Internal.SoundSource
        get lastDamageSource(): DamageSource
        set noActionTime(arg0: number)
        set movementSpeedAddition(speed: number)
        get pose(): Internal.Pose
        get restrictCenter(): BlockPos
        get leftHanded(): boolean
        set z(z: number)
        get y(): number
        get blocking(): boolean
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get armorCoverPercentage(): number
        get airSupply(): number
        get animal(): boolean
        get player(): boolean
        get motionDirection(): Internal.Direction
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get totalMovementSpeed(): number
        get moving(): boolean
        get attributes(): Internal.AttributeMap
        get spawnCancelled(): boolean
        get swimming(): boolean
        set sprinting(arg0: boolean)
        set x(x: number)
        get portalWaitTime(): number
        get blockStateOn(): Internal.BlockState
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get undead(): boolean
        get stepHeight(): number
        set registeredToWorld(navigation: Internal.PathNavigation_)
        get sleeping(): boolean
        get dismountPoses(): Internal.ImmutableList<Internal.Pose>
        get lastHurtMobTimestamp(): number
        get mobSpawnType(): Internal.MobSpawnType
        set remainingFireTicks(arg0: number)
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        set canPickUpLoot(arg0: boolean)
        get mainHandItem(): Internal.ItemStack
        get fireType(): ResourceLocation
        set silent(arg0: boolean)
        set leftHanded(arg0: boolean)
        get activeEffects(): Internal.Collection<Internal.MobEffectInstance>
        get onPortalCooldown(): boolean
        set uranusEntityData(nbt: Internal.CompoundTag_)
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get usingItem(): boolean
        get alwaysTicking(): boolean
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get inFluidType(): boolean
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get tags(): Internal.Set<string>
        get lastAttacker(): Internal.LivingEntity
        get percentFrozen(): number
        set portalCooldown(arg0: number)
        set position(block: Internal.BlockContainerJS_)
        get leashed(): boolean
        set pose(arg0: Internal.Pose_)
        get reachDistance(): number
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        set lastHurtByPlayer(arg0: Internal.Player_)
        get "server()"(): Internal.MinecraftServer
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set chestArmorItem(item: Internal.ItemStack_)
        get passenger(): boolean
        get sensitiveToWater(): boolean
        get jumpControl(): Internal.JumpControl
        get feetArmorItem(): Internal.ItemStack
        get viewScale(): number
        get visualRotationYInDegrees(): number
        set speed(arg0: number)
        get discrete(): boolean
        get level(): Internal.Level
        get combatTracker(): Internal.CombatTracker
        get noAi(): boolean
        get chestArmorItem(): Internal.ItemStack
        get fullyFrozen(): boolean
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get scale(): number
        get suppressingSlidingDownLadder(): boolean
        get blockZ(): number
        get silent(): boolean
        get pitch(): number
        get random(): Internal.RandomSource
        get passengersAndSelf(): Internal.Stream<any>
        get noActionTime(): number
        get visuallyCrawling(): boolean
        get aggressive(): boolean
        set yya(arg0: number)
        set baby(arg0: boolean)
        get lastHurtByMob(): Internal.LivingEntity
        get inWaterOrBubble(): boolean
        get portalCooldown(): number
        get item(): Internal.ItemStack
        get ignoringBlockTriggers(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        get blockX(): number
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get fallFlying(): boolean
        get encodeId(): string
        get maxHeadXRot(): number
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        set totalMovementSpeedMultiplier(speed: number)
        set health(arg0: number)
        get eyePosition(): Vec3d
        get eyeHeight(): number
        set discardFriction(arg0: boolean)
        get yaw(): number
        get usedItemHand(): Internal.InteractionHand
        set defaultMovementSpeed(speed: number)
        get brain(): Internal.Brain<any>
        set customNameVisible(arg0: boolean)
        get controllingPassenger(): Internal.LivingEntity
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        set feetArmorItem(item: Internal.ItemStack_)
        get id(): number
        get eyeY(): number
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get affectedByPotions(): boolean
        get citadelEntityData(): Internal.CompoundTag
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get useItem(): Internal.ItemStack
        get myRidingOffset(): number
        get living(): boolean
        get x(): number
        get vehicle(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        set stingerCount(arg0: number)
        get maxHeadYRot(): number
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get lootTableSeed(): number
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        get potionEffects(): Internal.EntityPotionEffectsJS
        get onRails(): boolean
        get stingerCount(): number
        get fallSounds(): Internal.LivingEntity$Fallsounds
        get dimensionChangingDelay(): number
        set yaw(arg0: number)
        get pickRadius(): number
        get pathFinding(): boolean
        get removed(): boolean
        get jumpBoostPower(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get experienceReward(): number
        get firstPassenger(): Internal.Entity
        get spawnType(): Internal.MobSpawnType
        set lastHurtMob(arg0: Internal.Entity_)
        set lastHurtByMob(arg0: Internal.LivingEntity_)
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get sleepingPos(): Internal.Optional<any>
        get lookAngle(): Vec3d
        get ambientSoundInterval(): number
        set arrowCount(arg0: number)
        get motionZ(): number
        get persistenceRequired(): boolean
        get invisible(): boolean
        get bedOrientation(): Internal.Direction
        get profile(): Internal.GameProfile
        get uranusEntityData(): Internal.CompoundTag
        get deadOrDying(): boolean
        set headArmorItem(item: Internal.ItemStack_)
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        get lookControl(): Internal.LookControl
        get offHandItem(): Internal.ItemStack
        get crouching(): boolean
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get withinRestriction(): boolean
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get visuallySwimming(): boolean
        get maxAirSupply(): number
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get boundingBoxForCulling(): Internal.AABB
        get target(): Internal.LivingEntity
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get inWater(): boolean
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        set citadelEntityData(arg0: Internal.CompoundTag_)
        get speed(): number
        get cachedFeetBlockState(): Internal.BlockState
        get uuid(): Internal.UUID
        set offHandItem(item: Internal.ItemStack_)
        set noAi(arg0: boolean)
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        get headArmorItem(): Internal.ItemStack
        get bbWidth(): number
        get "name()"(): net.minecraft.network.chat.Component
        get ticksRequiredToFreeze(): number
        get maxSpawnClusterSize(): number
        get username(): string
        get pickable(): boolean
        set YHeadRot(arg0: number)
        set jumping(arg0: boolean)
        get pickResult(): Internal.ItemStack
        get "mainHandItem()"(): Internal.ItemStack
        get absorptionAmount(): number
        get randomY(): number
        get displayName(): net.minecraft.network.chat.Component
        get mobType(): Internal.MobType
        get passengersRidingOffset(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set noGravity(arg0: boolean)
        get useItemRemainingTicks(): number
        get indirectPassengers(): Internal.Iterable<any>
        get navigation(): Internal.PathNavigation
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get lastClimbablePos(): Internal.Optional<BlockPos>
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get activeEffectsMap(): Internal.Map<Internal.MobEffect, Internal.MobEffectInstance>
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get restrictRadius(): number
        get registeredNavigation(): Internal.PathNavigation
        get invertedHealAndHarm(): boolean
        get freezing(): boolean
        set guaranteedDrop(arg0: EquipmentSlot_)
        set sharedFlagOnFire(arg0: boolean)
    }
    type AbstractSkeleton_ = AbstractSkeleton;
    interface IJSONGenerator {
        abstract generate(): Internal.JsonObject;
        (): Internal.JsonObject_;
    }
    type IJSONGenerator_ = IJSONGenerator | (()=> Internal.JsonObject_);
    interface IMixinKeyBinding {
        abstract getKeyCode(): Internal.InputConstants$Key;
        abstract setPressed(arg0: boolean): void;
        abstract getPressed(): boolean;
        abstract setTimesPressed(arg0: number): void;
        abstract getTimesPressed(): number;
        get keyCode(): Internal.InputConstants$Key
        set pressed(arg0: boolean)
        get pressed(): boolean
        set timesPressed(arg0: number)
        get timesPressed(): number
    }
    type IMixinKeyBinding_ = IMixinKeyBinding;
    class GlazedTerracottaBlock extends Internal.HorizontalDirectionalBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type GlazedTerracottaBlock_ = GlazedTerracottaBlock;
    class BaseEntityBuilder$CustomInstructionKeyframeEventJS <E extends Internal.Entity & Internal.IAnimatableJSNL> extends Internal.BaseEntityBuilder$KeyFrameEventJS<E, Internal.CustomInstructionKeyframeData> {
        constructor(parent: Internal.CustomInstructionKeyframeEvent_<E>)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        /**
         * A list of all the custom instructions. In Blockbench, each line in the custom instruction box is a separate instruction.
        */
        readonly instructions: string;
    }
    type BaseEntityBuilder$CustomInstructionKeyframeEventJS_<E extends Internal.Entity & Internal.IAnimatableJSNL> = BaseEntityBuilder$CustomInstructionKeyframeEventJS<E>;
    class OminousBow extends Internal.ItemToolBaseBow {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        static getHeldProjectile(arg0: Internal.LivingEntity_, arg1: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        customBaseShootArrow(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_): Internal.AbstractArrow;
        getRangeWeaponKind(): Internal.RangedWeaponKind;
        /**
         * @deprecated
        */
        getMaxProjectileVelocity(): number;
        getDefaultProjectileRange(): number;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        customBaseShootArrowChance(): number;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        customArrow(arg0: Internal.AbstractArrow_): Internal.AbstractArrow;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        setProjectileDamage(value: number, mainHand: boolean, offHand: boolean): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        specialShootBullet(arg0: Internal.LivingEntity_, arg1: Internal.LivingEntity_, arg2: number, arg3: number, arg4: number): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        getDefaultAttributeModifiers(slot: EquipmentSlot_): Internal.Multimap<any, any>;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        attackUse(arg0: Internal.Entity_, arg1: Internal.Entity_): void;
        setProjectileDamage(value: number): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        static getPowerForTime(arg0: number): number;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setCustomLaunchVelocity(value: number): void;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        getAllSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        /**
         * @deprecated
        */
        setMaxProjectileVelocity(value: number): void;
        getSupportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        setRangedWeaponKind(kind: Internal.RangedWeaponKind_): void;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        blockUse(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: DamageSource_): void;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        useBaseShootArrow(): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        customBaseShootArrowChance(arg0: Internal.LivingEntity_): number;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        getCustomLaunchVelocity(): number;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getProjectileDamage(): number;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get rangeWeaponKind(): Internal.RangedWeaponKind
        /**
         * @deprecated
        */
        get maxProjectileVelocity(): number
        get defaultProjectileRange(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        set projectileDamage(value: number)
        get complex(): boolean
        get descriptionId(): string
        set customLaunchVelocity(value: number)
        get allSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>
        get creativeTab(): string
        /**
         * @deprecated
        */
        set maxProjectileVelocity(value: number)
        get supportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>
        set rangedWeaponKind(kind: Internal.RangedWeaponKind_)
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get customLaunchVelocity(): number
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        get projectileDamage(): number
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type OminousBow_ = OminousBow;
    interface LongToIntFunction {
        abstract applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type LongToIntFunction_ = LongToIntFunction | ((arg0: number)=> number);
    class AirCurrent$AirCurrentSegment {
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type AirCurrent$AirCurrentSegment_ = AirCurrent$AirCurrentSegment;
    class VoidStartPlatformFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        getClass(): typeof any;
        toString(): string;
        static checkNeighbors(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_, arg2: Internal.Predicate_<Internal.BlockState>): boolean;
        notifyAll(): void;
        place(arg0: Internal.NoneFeatureConfiguration_, arg1: Internal.WorldGenLevel_, arg2: Internal.ChunkGenerator_, arg3: Internal.RandomSource_, arg4: BlockPos_): boolean;
        notify(): void;
        static isAdjacentToAir(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_): boolean;
        wait(arg0: number, arg1: number): void;
        place(arg0: Internal.FeaturePlaceContext_<Internal.NoneFeatureConfiguration>): boolean;
        static isGrassOrDirt(arg0: Internal.LevelSimulatedReader_, arg1: BlockPos_): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        static isDirt(arg0: Internal.BlockState_): boolean;
        equals(arg0: any): boolean;
        static isReplaceable(arg0: Internal.TagKey_<Internal.Block>): Internal.Predicate<Internal.BlockState>;
        configuredCodec(): Internal.Codec<Internal.ConfiguredFeature<Internal.NoneFeatureConfiguration, Internal.Feature<Internal.NoneFeatureConfiguration>>>;
        get class(): typeof any
    }
    type VoidStartPlatformFeature_ = VoidStartPlatformFeature;
    class BiomeGenerationSettings {
        getClass(): typeof any;
        toString(): string;
        getCarvingStages(): Internal.Set<Internal.GenerationStep$Carving>;
        features(): Internal.List<Internal.HolderSet<Internal.PlacedFeature>>;
        getFlowerFeatures(): Internal.List<Internal.ConfiguredFeature<any, any>>;
        notifyAll(): void;
        hasFeature(arg0: Internal.PlacedFeature_): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getCarvers(arg0: Internal.GenerationStep$Carving_): Internal.Iterable<Internal.Holder<Internal.ConfiguredWorldCarver<any>>>;
        equals(arg0: any): boolean;
        get class(): typeof any
        get carvingStages(): Internal.Set<Internal.GenerationStep$Carving>
        get flowerFeatures(): Internal.List<Internal.ConfiguredFeature<any, any>>
        static readonly EMPTY: (Internal.BiomeGenerationSettings) & (Internal.BiomeGenerationSettings);
        static readonly CODEC: (Internal.RecordCodecBuilder$2) & (Internal.MapCodec<Internal.BiomeGenerationSettings>);
    }
    type BiomeGenerationSettings_ = BiomeGenerationSettings;
    class CarriageSounds {
        constructor(arg0: Internal.CarriageContraptionEntity_)
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        tick(arg0: Internal.Carriage$DimensionalCarriageEntity_): void;
        finalizeSharedVolume(arg0: number): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        stop(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        submitSharedSoundVolume(arg0: Vec3d_, arg1: number): void;
        get class(): typeof any
    }
    type CarriageSounds_ = CarriageSounds;
    interface Spliterator$OfPrimitive <T, T_CONS, T_SPLITR extends Internal.Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>> extends Internal.Spliterator<T> {
        forEachRemaining(arg0: T_CONS): void;
        abstract "tryAdvance(java.util.function.Consumer)"(arg0: Internal.Consumer_<T>): boolean;
        hasCharacteristics(arg0: number): boolean;
        abstract tryAdvance(arg0: T_CONS): boolean;
        getComparator(): Internal.Comparator<T>;
        "forEachRemaining(java.util.function.Consumer)"(arg0: Internal.Consumer_<T>): void;
        abstract estimateSize(): number;
        "forEachRemaining(java.lang.Object)"(arg0: T_CONS): void;
        abstract "tryAdvance(java.lang.Object)"(arg0: T_CONS): boolean;
        trySplit(): Internal.Spliterator<any>;
        getExactSizeIfKnown(): number;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
        abstract tryAdvance(arg0: Internal.Consumer_<T>): boolean;
        abstract characteristics(): number;
        get comparator(): Internal.Comparator<T>
        get exactSizeIfKnown(): number
    }
    type Spliterator$OfPrimitive_<T, T_CONS, T_SPLITR extends Internal.Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>> = Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>;
    class DecayableWartBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_, arg1: number, arg2: Internal.Block_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        maxSpots(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        setSpots(arg0: Internal.BlockState_): Internal.BlockState;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        set spots(arg0: Internal.BlockState_)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly SPOTS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
        static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    }
    type DecayableWartBlock_ = DecayableWartBlock;
    class ServerboundSeenAdvancementsPacket$Action extends Internal.Enum<Internal.ServerboundSeenAdvancementsPacket$Action> {
        static values(): Internal.ServerboundSeenAdvancementsPacket$Action[];
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        getDeclaringClass(): typeof Internal.ServerboundSeenAdvancementsPacket$Action;
        toString(): string;
        notifyAll(): void;
        "compareTo(net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket$Action)"(arg0: Internal.ServerboundSeenAdvancementsPacket$Action_): number;
        compareTo(arg0: Internal.ServerboundSeenAdvancementsPacket$Action_): number;
        static valueOf(arg0: string): Internal.ServerboundSeenAdvancementsPacket$Action;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.ServerboundSeenAdvancementsPacket$Action>>;
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get declaringClass(): typeof Internal.ServerboundSeenAdvancementsPacket$Action
        static readonly OPENED_TAB: (Internal.ServerboundSeenAdvancementsPacket$Action) & (Internal.ServerboundSeenAdvancementsPacket$Action);
        static readonly CLOSED_SCREEN: (Internal.ServerboundSeenAdvancementsPacket$Action) & (Internal.ServerboundSeenAdvancementsPacket$Action);
    }
    type ServerboundSeenAdvancementsPacket$Action_ = "closed_screen" | ServerboundSeenAdvancementsPacket$Action | "opened_tab";
    class BaseMobEffectAllTick extends Internal.MobEffect {
        constructor(arg0: Internal.MobEffectCategory_, arg1: number)
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        shouldApplyEffectTickThisTick(arg0: number, arg1: number): boolean;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type BaseMobEffectAllTick_ = BaseMobEffectAllTick;
    class ChatTypeDecoration extends Internal.Record {
        constructor(arg0: string, arg1: Internal.List_<Internal.ChatTypeDecoration$Parameter>, arg2: Internal.Style_)
        getClass(): typeof any;
        toString(): string;
        translationKey(): string;
        style(): Internal.Style;
        parameters(): Internal.List<Internal.ChatTypeDecoration$Parameter>;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        static outgoingDirectMessage(arg0: string): Internal.ChatTypeDecoration;
        wait(): void;
        wait(arg0: number): void;
        static withSender(arg0: string): Internal.ChatTypeDecoration;
        equals(arg0: any): boolean;
        decorate(arg0: net.minecraft.network.chat.Component_, arg1: Internal.ChatType$Bound_): net.minecraft.network.chat.Component;
        static teamMessage(arg0: string): Internal.ChatTypeDecoration;
        static incomingDirectMessage(arg0: string): Internal.ChatTypeDecoration;
        get class(): typeof any
        static readonly CODEC: Internal.Codec<Internal.ChatTypeDecoration>;
    }
    type ChatTypeDecoration_ = ChatTypeDecoration;
    interface OwnableEntityBlock extends Internal.EntityBlock {
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        appendUserListToTooltip(arg0: Internal.CompoundTag_, arg1: Internal.List_<net.minecraft.network.chat.Component>): void;
        setBlockEntityOwner(arg0: Internal.Level_, arg1: Internal.Ownable_, arg2: Internal.LivingEntity_, arg3: Internal.ItemStack_): void;
        abstract newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        "appendUserListToTooltip(net.minecraft.nbt.CompoundTag,java.util.List)"(arg0: Internal.CompoundTag_, arg1: Internal.List_<net.minecraft.network.chat.Component>): void;
        dropForCreativePlayer(arg0: Internal.Level_, arg1: Internal.Block_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        "appendUserListToTooltip(net.minecraft.world.item.ItemStack,java.util.List)"(arg0: Internal.ItemStack_, arg1: Internal.List_<net.minecraft.network.chat.Component>): void;
        appendUserListToTooltip(arg0: Internal.ItemStack_, arg1: Internal.List_<net.minecraft.network.chat.Component>): void;
        (arg0: BlockPos, arg1: Internal.BlockState): Internal.BlockEntity_;
        readonly NBT_KEY_USER: ("UserUUID") & (string);
        readonly NBT_KEY_USER_LIST: ("UserList") & (string);
        readonly NBT_KEY_OWNER: ("OwnerUUID") & (string);
    }
    type OwnableEntityBlock_ = ((arg0: BlockPos, arg1: Internal.BlockState)=> Internal.BlockEntity_) | OwnableEntityBlock;
    abstract class TraderBlockBase extends Internal.VillagerBlockBase implements Internal.IItemBlock, Internal.EntityBlock {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        abstract newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        static playVillagerSound(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.SoundEvent_): void;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        overrideClick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.Event$Result_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        static playRandomVillagerSound(arg0: Internal.Player_, arg1: Internal.SoundEvent_): void;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        abstract toItem(): Internal.Item;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        static playRandomVillagerSound(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.SoundEvent_): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type TraderBlockBase_ = TraderBlockBase;
    class AnimatedIronArmor$Chestplate extends Internal.AnimatedIronArmor {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getType(): Internal.ArmorItem$Type;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        getDefense(): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getEquipmentSlot(): EquipmentSlot;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        getEquipSound(): Internal.SoundEvent;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getToughness(): number;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get equipmentSlot(): EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type AnimatedIronArmor$Chestplate_ = AnimatedIronArmor$Chestplate;
    class InsulatedPlateItem extends Internal.TetraItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        clientInit(): void;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        commonInit(arg0: Internal.PacketHandler_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static readonly identifier: ("vent_plate") & (string);
        static instance: (Internal.InsulatedPlateItem) & (Internal.InsulatedPlateItem);
    }
    type InsulatedPlateItem_ = InsulatedPlateItem;
    class WallSide extends Internal.Enum<Internal.WallSide> implements Internal.StringRepresentable {
        static values(): Internal.WallSide[];
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        toString(): string;
        "compareTo(net.minecraft.world.level.block.state.properties.WallSide)"(arg0: Internal.WallSide_): number;
        getSerializedName(): string;
        notifyAll(): void;
        notify(): void;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.WallSide>>;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        compareTo(arg0: Internal.WallSide_): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static valueOf(arg0: string): Internal.WallSide;
        getDeclaringClass(): typeof Internal.WallSide;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get serializedName(): string
        get declaringClass(): typeof Internal.WallSide
        static readonly LOW: (Internal.WallSide) & (Internal.WallSide);
        static readonly TALL: (Internal.WallSide) & (Internal.WallSide);
        static readonly NONE: (Internal.WallSide) & (Internal.WallSide);
    }
    type WallSide_ = "low" | WallSide | "tall" | "none";
    class AngelWingItem extends Internal.ArmorItem implements GeoItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getTick(arg0: any): number;
        isFireResistant(): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isPerspectiveAware(): boolean;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        setAnimData<D>(arg0: Internal.Entity_, arg1: number, arg2: Internal.SerializableDataTicket_<D>, arg3: D): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        "triggerAnim(net.minecraft.world.entity.Entity,long,java.lang.String,java.lang.String)"<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        getDefense(): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        triggerAnim<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        triggerAnim<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        static registerSyncedAnimatable(arg0: Internal.GeoAnimatable_): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getBoneResetTime(): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        triggerArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getToughness(): number;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string, arg4: Internal.PacketDistributor$PacketTarget_): void;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        syncAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>, arg2: D, arg3: Internal.PacketDistributor$PacketTarget_): void;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        static getOrAssignId(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_): number;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static "getId(net.minecraft.world.item.Item)"(arg0: Internal.Item_): number;
        registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        equals(arg0: any): boolean;
        "triggerAnim(long,java.lang.String,java.lang.String,net.minecraftforge.network.PacketDistributor$PacketTarget)"<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
        setRarity(arg0: Internal.Rarity_): void;
        getType(): Internal.ArmorItem$Type;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>): D;
        shouldPlayAnimsWhileGamePaused(): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getEquipmentSlot(): EquipmentSlot;
        static getId(arg0: Internal.ItemStack_): number;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        static "getId(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): number;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        stopTriggeredArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        notify(): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEquipSound(): Internal.SoundEvent;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get perspectiveAware(): boolean
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get boneResetTime(): number
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set itemBuilder(b: Internal.ItemBuilder_)
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        get equipmentSlot(): EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        animationprocedure: string;
    }
    type AngelWingItem_ = AngelWingItem;
    class TierData <T> {
        constructor()
        getClass(): typeof any;
        toString(): string;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getEfficiency(arg0: T): number;
        contains(arg0: T): boolean;
        getLevel(arg0: T): number;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        getLevelMap(): Internal.Map<T, number>;
        equals(arg0: any): boolean;
        getValues(): Internal.Set<T>;
        get class(): typeof any
        get levelMap(): Internal.Map<T, number>
        get values(): Internal.Set<T>
        efficiencyMap: Internal.Map<T, number>;
        levelMap: Internal.Map<T, number>;
    }
    type TierData_<T> = TierData<T>;
    interface MessageSenderKJS {
        getDisplayName(): net.minecraft.network.chat.Component;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getName(): net.minecraft.network.chat.Component;
        runCommandSilent(command: string): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        runCommand(command: string): number;
        get displayName(): net.minecraft.network.chat.Component
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get name(): net.minecraft.network.chat.Component
    }
    type MessageSenderKJS_ = MessageSenderKJS;
    class BoneWingFireBallItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type BoneWingFireBallItem_ = BoneWingFireBallItem;
    class ZetaCeilingHangingSignBlock extends Internal.CeilingHangingSignBlock implements Internal.IZetaBlockExtensions, Internal.IForgeBlock, Internal.IZetaBlock {
        constructor(arg0: string, arg1: Internal.ZetaModule_, arg2: Internal.WoodType_, arg3: Internal.BlockBehaviour$Properties_)
        getSignHitboxCenterPosition(arg0: Internal.BlockState_): Vec3d;
        isScaffoldingZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static getWoodType(arg0: Internal.Block_): Internal.WoodType;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        getModule(): Internal.ZetaModule;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getLightEmissionZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        doesConditionApply(): boolean;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        isLadderZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        setCondition(arg0: Internal.BooleanSupplier_): this;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        needsDynamicNodeTypeCheck(): boolean;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        openTextEdit(arg0: Internal.Player_, arg1: Internal.SignBlockEntity_, arg2: boolean): void;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        canStickToZeta(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        getFireSpreadSpeedZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        getYRotationDegrees(arg0: Internal.BlockState_): number;
        isStickyBlockZeta(arg0: Internal.BlockState_): boolean;
        getFlammabilityZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        static isEnabled(arg0: Internal.Block_): boolean;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        static "isEnabled(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        getBlock(): Internal.Block;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        setIsRandomlyTicking(arg0: boolean): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        type(): Internal.WoodType;
        static "isEnabled(net.minecraft.world.item.Item)"(arg0: Internal.Item_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        setCreativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>, arg1: Internal.ItemLike_, arg2: boolean): Internal.Block;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getBeaconColorMultiplierZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundTypeZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        shouldDisplayFluidOverlayZeta(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getJumpFactor(): number;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getEnchantPowerBonusZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        collisionExtendsVerticallyZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        getToolModifiedStateZeta(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: string, arg3: boolean): Internal.BlockState;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        canSustainPlantZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: string): boolean;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        static isEnabled(arg0: Internal.Item_): boolean;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        "isEnabled(net.minecraft.world.flag.FeatureFlagSet)"(arg0: Internal.FeatureFlagSet_): boolean;
        setCreativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>): Internal.Block;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        isConduitFrameZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        isEnabled(): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        makesOpenTrapdoorAboveClimbableZeta(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        isFlammableZeta(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        get module(): Internal.ZetaModule
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        set condition(arg0: Internal.BooleanSupplier_)
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        get block(): Internal.Block
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set creativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>)
        set destroySpeed(v: number)
        get enabled(): boolean
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type ZetaCeilingHangingSignBlock_ = ZetaCeilingHangingSignBlock;
    interface KeyListener extends Internal.EventListener {
        abstract keyPressed(arg0: Internal.KeyEvent_): void;
        abstract keyReleased(arg0: Internal.KeyEvent_): void;
        abstract keyTyped(arg0: Internal.KeyEvent_): void;
    }
    type KeyListener_ = KeyListener;
    abstract class UndoOperation <DATA> implements Internal.Parcelable {
        constructor(owner: Internal.UndoOwner_)
        getClass(): typeof any;
        abstract writeToParcel(arg0: Internal.Parcel_, arg1: number): void;
        toString(): string;
        notifyAll(): void;
        getOwner(): Internal.UndoOwner;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        abstract undo(): void;
        getOwnerData(): DATA;
        abstract redo(): void;
        hashCode(): number;
        wait(): void;
        hasData(): boolean;
        wait(arg0: number): void;
        abstract commit(): void;
        matchOwner(owner: Internal.UndoOwner_): boolean;
        equals(arg0: any): boolean;
        allowMerge(): boolean;
        get class(): typeof any
        get owner(): Internal.UndoOwner
        get ownerData(): DATA
    }
    type UndoOperation_<DATA> = UndoOperation<DATA>;
    class ContextUtils$ScaleModelRenderContext <T extends Internal.LivingEntity> {
        constructor(widthScale: number, heightScale: number, poseStack: Internal.PoseStack_, entity: T, model: Internal.BakedGeoModel_, isReRender: boolean, partialTick: number, packedLight: number, packedOverlay: number)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        readonly packedLight: number;
        readonly widthScale: number;
        readonly poseStack: Internal.PoseStack;
        readonly partialTick: number;
        readonly heightScale: number;
        readonly model: Internal.BakedGeoModel;
        readonly isReRender: boolean;
        readonly packedOverlay: number;
        readonly entity: T;
    }
    type ContextUtils$ScaleModelRenderContext_<T extends Internal.LivingEntity> = ContextUtils$ScaleModelRenderContext<T>;
    class BoneFractureMobEffect extends Internal.MobEffect {
        constructor()
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type BoneFractureMobEffect_ = BoneFractureMobEffect;
    class BlockPileFeature extends Internal.Feature<Internal.BlockPileConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.BlockPileConfiguration>)
        getClass(): typeof any;
        toString(): string;
        place(arg0: Internal.BlockPileConfiguration_, arg1: Internal.WorldGenLevel_, arg2: Internal.ChunkGenerator_, arg3: Internal.RandomSource_, arg4: BlockPos_): boolean;
        static checkNeighbors(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_, arg2: Internal.Predicate_<Internal.BlockState>): boolean;
        notifyAll(): void;
        place(arg0: Internal.FeaturePlaceContext_<Internal.BlockPileConfiguration>): boolean;
        configuredCodec(): Internal.Codec<Internal.ConfiguredFeature<Internal.BlockPileConfiguration, Internal.Feature<Internal.BlockPileConfiguration>>>;
        notify(): void;
        static isAdjacentToAir(arg0: Internal.Function_<BlockPos, Internal.BlockState>, arg1: BlockPos_): boolean;
        wait(arg0: number, arg1: number): void;
        static isGrassOrDirt(arg0: Internal.LevelSimulatedReader_, arg1: BlockPos_): boolean;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        static isDirt(arg0: Internal.BlockState_): boolean;
        equals(arg0: any): boolean;
        static isReplaceable(arg0: Internal.TagKey_<Internal.Block>): Internal.Predicate<Internal.BlockState>;
        get class(): typeof any
    }
    type BlockPileFeature_ = BlockPileFeature;
    class ServerOpList extends Internal.StoredUserList<Internal.GameProfile, Internal.ServerOpListEntry> {
        constructor(arg0: Internal.File_)
        getClass(): typeof any;
        getEntries(): Internal.Collection<Internal.ServerOpListEntry>;
        "remove(com.mojang.authlib.GameProfile)"(arg0: Internal.GameProfile_): void;
        toString(): string;
        remove(arg0: Internal.GameProfile_): void;
        notifyAll(): void;
        remove(arg0: Internal.StoredUserEntry_<Internal.GameProfile>): void;
        isEmpty(): boolean;
        notify(): void;
        canBypassPlayerLimit(arg0: Internal.GameProfile_): boolean;
        save(): void;
        wait(arg0: number, arg1: number): void;
        getFile(): Internal.File;
        hashCode(): number;
        wait(): void;
        "remove(net.minecraft.server.players.StoredUserEntry)"(arg0: Internal.StoredUserEntry_<Internal.GameProfile>): void;
        getUserList(): string[];
        get(arg0: Internal.GameProfile_): Internal.ServerOpListEntry;
        wait(arg0: number): void;
        add(arg0: Internal.ServerOpListEntry_): void;
        load(): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get entries(): Internal.Collection<Internal.ServerOpListEntry>
        get empty(): boolean
        get file(): Internal.File
        get userList(): string[]
    }
    type ServerOpList_ = ServerOpList;
    abstract class ScreenEvent$MouseButtonPressed extends Internal.ScreenEvent$MouseInput {
        constructor()
        constructor(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        getButton(): number;
        setPhase(arg0: Internal.EventPriority_): void;
        getMouseX(): number;
        getScreen(): Internal.Screen;
        notifyAll(): void;
        getMouseY(): number;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        get button(): number
        set phase(arg0: Internal.EventPriority_)
        get mouseX(): number
        get screen(): Internal.Screen
        get mouseY(): number
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
    }
    type ScreenEvent$MouseButtonPressed_ = ScreenEvent$MouseButtonPressed;
    class ClassInfo {
        getFieldInfo(): Internal.List<Internal.FieldInfo>;
        getClass(): typeof any;
        getClazzRaw(): typeof any;
        getAnnotations(): Internal.List<Internal.Annotation>;
        isAbstract(): boolean;
        toString(): string;
        static getOrCache(clazz: typeof any): Internal.ClassInfo;
        notifyAll(): void;
        isInterface(): boolean;
        getInterfaceTypes(): Internal.List<Internal.ITypeInfo>;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getSuperClassType(): Internal.ITypeInfo;
        getInterfaces(): Internal.List<Internal.ClassInfo>;
        getSuperClass(): this;
        getParameters(): Internal.List<Internal.ITypeInfo>;
        hashCode(): number;
        wait(): void;
        getName(): string;
        isEnum(): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        getConstructorInfo(): Internal.List<Internal.ConstructorInfo>;
        getMethodInfo(): Internal.List<Internal.MethodInfo>;
        get fieldInfo(): Internal.List<Internal.FieldInfo>
        get class(): typeof any
        get clazzRaw(): typeof any
        get annotations(): Internal.List<Internal.Annotation>
        get "abstract"(): boolean
        get "interface"(): boolean
        get interfaceTypes(): Internal.List<Internal.ITypeInfo>
        get superClassType(): Internal.ITypeInfo
        get interfaces(): Internal.List<Internal.ClassInfo>
        get superClass(): Internal.ClassInfo
        get parameters(): Internal.List<Internal.ITypeInfo>
        get name(): string
        get enum(): boolean
        get constructorInfo(): Internal.List<Internal.ConstructorInfo>
        get methodInfo(): Internal.List<Internal.MethodInfo>
        static readonly CLASS_CACHE: ({[key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Inter