/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    interface CompositeContext {
        abstract compose(arg0: Internal.Raster_, arg1: Internal.Raster_, arg2: Internal.WritableRaster_): void;
        abstract dispose(): void;
    }
    type CompositeContext_ = CompositeContext;
    class CombustionChamberItem extends Internal.TetraItem {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        clientInit(): void;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        commonInit(arg0: Internal.PacketHandler_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static instance: Internal.RegistryObject<Internal.CombustionChamberItem>;
        static readonly identifier: ("combustion_chamber") & (string);
    }
    type CombustionChamberItem_ = CombustionChamberItem;
    interface RegistrySupplier <T> extends Internal.DeferredSupplier<T> {
        abstract getRegistrarManager(): Internal.RegistrarManager;
        getKey(): Internal.ResourceKey<T>;
        stream(): Internal.Stream<T>;
        ifPresent(action: Internal.Consumer_<T>): void;
        orElseGet(supplier: Internal.Supplier_<T>): T;
        ifPresentOrElse(action: Internal.Consumer_<T>, emptyAction: Internal.Runnable_): void;
        getRegistryKey(): Internal.ResourceKey<Internal.Registry<T>>;
        abstract getRegistrar(): dev.architectury.registry.registries.Registrar<T>;
        getOrNull(): T;
        orElse(other: T): T;
        abstract getId(): ResourceLocation;
        abstract isPresent(): boolean;
        abstract getRegistryId(): ResourceLocation;
        abstract get(): T;
        listen(callback: Internal.Consumer_<T>): void;
        toOptional(): Internal.Optional<T>;
        get registrarManager(): Internal.RegistrarManager
        get key(): Internal.ResourceKey<T>
        get registryKey(): Internal.ResourceKey<Internal.Registry<T>>
        get registrar(): dev.architectury.registry.registries.Registrar<T>
        get orNull(): T
        get id(): ResourceLocation
        get present(): boolean
        get registryId(): ResourceLocation
    }
    type RegistrySupplier_<T> = RegistrySupplier<T>;
    class MetricSampler$MetricSamplerBuilder <T> {
        constructor(arg0: string, arg1: Internal.MetricCategory_, arg2: Internal.ToDoubleFunction_<T>, arg3: T)
        getClass(): typeof any;
        withBeforeTick(arg0: Internal.Consumer_<T>): this;
        hashCode(): number;
        toString(): string;
        withThresholdAlert(arg0: Internal.MetricSampler$ThresholdTest_): this;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        build(): Internal.MetricSampler;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type MetricSampler$MetricSamplerBuilder_<T> = MetricSampler$MetricSamplerBuilder<T>;
    interface ResultConsumer <S> {
        abstract onCommandComplete(arg0: Internal.CommandContext_<S>, arg1: boolean, arg2: number): void;
        (arg0: Internal.CommandContext<S>, arg1: boolean, arg2: number): void;
    }
    type ResultConsumer_<S> = ((arg0: Internal.CommandContext<S>, arg1: boolean, arg2: number)=> void) | ResultConsumer<S>;
    class ImageCapabilities implements Internal.Cloneable {
        constructor(arg0: boolean)
        clone(): any;
        isAccelerated(): boolean;
        getClass(): typeof any;
        hashCode(): number;
        isTrueVolatile(): boolean;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get accelerated(): boolean
        get class(): typeof any
        get trueVolatile(): boolean
    }
    type ImageCapabilities_ = ImageCapabilities;
    class TripWireBlock extends Internal.Block {
        constructor(arg0: Internal.TripWireHookBlock_, arg1: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        shouldConnectTo(arg0: Internal.BlockState_, arg1: Internal.Direction_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type TripWireBlock_ = TripWireBlock;
    class DecoratedPotRecipe extends Internal.CustomRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.CraftingBookCategory_)
        getClass(): typeof any;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        "assemble(net.minecraft.world.Container,net.minecraft.core.RegistryAccess)"(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        "matches(net.minecraft.world.inventory.CraftingContainer,net.minecraft.world.level.Level)"(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        notify(): void;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        wait(arg0: number, arg1: number): void;
        assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        toString(): string;
        "assemble(net.minecraft.world.inventory.CraftingContainer,net.minecraft.core.RegistryAccess)"(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        notifyAll(): void;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        "matches(net.minecraft.world.Container,net.minecraft.world.level.Level)"(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        hashCode(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        wait(): void;
        isIncomplete(): boolean;
        wait(arg0: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        equals(arg0: any): boolean;
        static createDecoratedPotItem(arg0: Internal.DecoratedPotBlockEntity$Decorations_): Internal.ItemStack;
        get class(): typeof any
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type DecoratedPotRecipe_ = DecoratedPotRecipe;
    interface AccessibleSelection {
        abstract clearAccessibleSelection(): void;
        abstract getAccessibleSelection(arg0: number): Internal.Accessible;
        abstract addAccessibleSelection(arg0: number): void;
        abstract removeAccessibleSelection(arg0: number): void;
        abstract selectAllAccessibleSelection(): void;
        abstract isAccessibleChildSelected(arg0: number): boolean;
        abstract getAccessibleSelectionCount(): number;
        get accessibleSelectionCount(): number
    }
    type AccessibleSelection_ = AccessibleSelection;
    class ProjectileImpactEvent extends Internal.EntityEvent {
        constructor()
        constructor(arg0: Internal.Projectile_, arg1: Internal.HitResult_)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        setCanceled(arg0: boolean): void;
        getResult(): Internal.Event$Result;
        getClass(): typeof any;
        toString(): string;
        getImpactResult(): Internal.ProjectileImpactEvent$ImpactResult;
        setPhase(arg0: Internal.EventPriority_): void;
        notifyAll(): void;
        getProjectile(): Internal.Projectile;
        isCanceled(): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        hashCode(): number;
        isCancelable(): boolean;
        getEntity(): Internal.Entity;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        setImpactResult(arg0: Internal.ProjectileImpactEvent$ImpactResult_): void;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        getRayTraceResult(): Internal.HitResult;
        equals(arg0: any): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        set canceled(arg0: boolean)
        get result(): Internal.Event$Result
        get class(): typeof any
        get impactResult(): Internal.ProjectileImpactEvent$ImpactResult
        set phase(arg0: Internal.EventPriority_)
        get projectile(): Internal.Projectile
        get canceled(): boolean
        set result(arg0: Internal.Event$Result_)
        get cancelable(): boolean
        get entity(): Internal.Entity
        get listenerList(): Internal.ListenerList
        set impactResult(arg0: Internal.ProjectileImpactEvent$ImpactResult_)
        get phase(): Internal.EventPriority
        get rayTraceResult(): Internal.HitResult
    }
    type ProjectileImpactEvent_ = ProjectileImpactEvent;
    interface IStorage <T> {
        abstract getCacheDelta(arg0: number, arg1: number, arg2: T): number;
        abstract extract(arg0: T, arg1: number, arg2: number, arg3: Internal.Action_): T;
        abstract getStacks(): Internal.Collection<T>;
        abstract insert(arg0: T, arg1: number, arg2: Internal.Action_): T;
        abstract getStored(): number;
        abstract getPriority(): number;
        abstract getAccessType(): Internal.AccessType;
        get stacks(): Internal.Collection<T>
        get stored(): number
        get priority(): number
        get accessType(): Internal.AccessType
        readonly COMPARATOR: Internal.Comparator<Internal.IStorage<any>>;
    }
    type IStorage_<T> = IStorage<T>;
    class ModuleDescriptor$Exports$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Exports$Modifier> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getDeclaringClass(): typeof Internal.ModuleDescriptor$Exports$Modifier;
        getClass(): typeof any;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.ModuleDescriptor$Exports$Modifier>>;
        toString(): string;
        notifyAll(): void;
        compareTo(arg0: Internal.ModuleDescriptor$Exports$Modifier_): number;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        static valueOf(arg0: string): Internal.ModuleDescriptor$Exports$Modifier;
        static values(): Internal.ModuleDescriptor$Exports$Modifier[];
        name(): string;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        "compareTo(java.lang.module.ModuleDescriptor$Exports$Modifier)"(arg0: Internal.ModuleDescriptor$Exports$Modifier_): number;
        equals(arg0: any): boolean;
        get declaringClass(): typeof Internal.ModuleDescriptor$Exports$Modifier
        get class(): typeof any
        static readonly SYNTHETIC: (Internal.ModuleDescriptor$Exports$Modifier) & (Internal.ModuleDescriptor$Exports$Modifier);
        static readonly MANDATED: (Internal.ModuleDescriptor$Exports$Modifier) & (Internal.ModuleDescriptor$Exports$Modifier);
    }
    type ModuleDescriptor$Exports$Modifier_ = "mandated" | "synthetic" | ModuleDescriptor$Exports$Modifier;
    class SecurityCardItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        static hasPermission(arg0: Internal.ItemStack_, arg1: com.refinedmods.refinedstorage.api.network.security.Permission_): boolean;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        static setPermission(arg0: Internal.ItemStack_, arg1: com.refinedmods.refinedstorage.api.network.security.Permission_, arg2: boolean): void;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        static getOwner(arg0: Internal.ItemStack_): Internal.UUID;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static isValid(arg0: Internal.ItemStack_): boolean;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type SecurityCardItem_ = SecurityCardItem;
    class Item implements Internal.FeatureElement, Internal.ItemFTBL, Internal.ItemLike, Internal.IForgeItem, Internal.ItemKJS, Internal.IrisItemLightProvider, Internal.IZetaForgeItemStuff, Internal.AccessorItem, Internal.DelegateHolder<any>, Internal.IItem, Internal.ItemForgeAccessor, Internal.InjectedItemExtension {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): this;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): this;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): Special.Item&`${string}:${string}`;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): this;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): Special.Item&`${string}:${string}`
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static readonly BY_BLOCK: ({[key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ChainGearshiftBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.BeltTunnelBlock]: Internal.BeltTunnelItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.ChristmasLightsBlock]: Internal.BlockItem, [key: Internal.DeepslateTitaniumOreBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IgneousReeds]: Internal.BlockItem, [key: Internal.TrueShadowBedBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.CalciteTilesBlock]: Internal.BlockItem, [key: Internal.SpawnerBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.SmoothDreamAlloyBlockBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.TransmogrificationTableBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WindrunnerCrystalBlockBlock]: Internal.BlockItem, [key: Internal.ShadowShroomlightBlock]: Internal.BlockItem, [key: Internal.MelonBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CampfireBlock]: Internal.BlockItem, [key: Internal.TransferUnitBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ItemVaultBlock]: Internal.ItemVaultItem, [key: Internal.CreepyNutcrackerBlock]: Internal.BlockItem, [key: Internal.AAStrongDirt]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.GreenStainedGlassPanelBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.GearboxBlock]: Internal.BlockItem, [key: Internal.DyedreamGlasspaneBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowWartBlockBlock]: Internal.BlockItem, [key: Internal.Flower12Block]: Internal.DoubleHighBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.CartographyTableBlock]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlabCanFire]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.CarvedLodestone]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: Internal.CogWheelBlock]: Internal.CogwheelBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Tombstone2DlingBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StructureBlock0Block]: Internal.BlockItem, [key: Internal.StructureBlock8Block]: Internal.BlockItem, [key: Internal.ClayPot0Block]: Internal.BlockItem, [key: Internal.ScorchedPlanksFenceBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.DarkIceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.FiredBlackArgilliteNBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.PortableGridBlock]: Internal.PortableGridBlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BigBubbleBlock]: Internal.BlockItem, [key: Internal.BoneBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.DarkMetalDepositBlock]: Internal.BlockItem, [key: Internal.ZetaFlammablePillarBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerMetalDoor]: Internal.DoubleHighBlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.PolishedCalciteStairsBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.PredationToothedFlowerBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SnowyDirtBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FluidStorageBlock]: Internal.FluidStorageBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.TitaniumBlockBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RepeaterBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WorkshopAnvilBlock]: Internal.BlockItem, [key: Internal.DyedreamDirtBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.EndRodBlock]: Internal.BlockItem, [key: Internal.ScorchedLogBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.SimpleBlockItem, [key: Internal.BlackArgilliteBrickNBlock]: Internal.BlockItem, [key: Internal.AzaleaBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.Flower13Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Crop4aBlock]: Internal.BlockItem, [key: Internal.BlockDirtStairs]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.FramedDrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.WindmoorLeaves0Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.VialHolderBlock]: Internal.SimpleBlockItem, [key: Internal.BlockGrassStairs]: Internal.BlockItem, [key: Internal.CraftingTableBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.H9Block]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteButtonBlock]: Internal.BlockItem, [key: Internal.MetalLadderBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.SkullPileBlock]: Internal.BlockItem, [key: Internal.WeaponTableBlock]: Internal.WeaponTableDisplayItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ChorusVegetationBlock]: Internal.ZetaBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MimicChestBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CageofcalamityBlock]: Internal.BlockItem, [key: Internal.BoneFenceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.SporeBlossomBlock]: Internal.BlockItem, [key: Internal.TripWireBlock]: Internal.ItemNameBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.SporeshroomBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.ZetaPressurePlateBlock]: Internal.ZetaBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.PlayerWallHeadBlock]: Internal.PlayerHeadItem, [key: Internal.GeyserBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.NyliumPathBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StainedBlackArgilliteBrickNBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FelSoilDestructibleBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaFenceBlock]: Internal.ZetaBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.StructureVoidBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.EncasedFanBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.PistonBaseBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FramedDrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ShaftBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.AAStrongGrassBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseTrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SecondRoundWorldBlock]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.StructureBlock19Block]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.GantryShaftBlock]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.BloomBlock]: Internal.SimpleBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.InfectedDeepslateDiamondOreBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TntBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.ControlsBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ElevatorPulleyBlock]: Internal.BlockItem, [key: Internal.StarcallBlockBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.PinkslimeBlockBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DyedreamquartzBlockWallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MyalitePillarBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EjectorBlock]: Internal.EjectorItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.MushroomColonyBlock]: Internal.MushroomColonyItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CuttingBoardBlock]: Internal.FuelBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BitterColdSapling]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlywheelBlock]: Internal.BlockItem, [key: Internal.Crop2aBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaFenceGateBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DirectionalPillarSlabBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RoastChickenBlock]: Internal.BlockItem, [key: Internal.InfernalEvilPumpkinSBlock]: Internal.BlockItem, [key: Internal.EncasedShaftBlock]: Internal.BlockItem, [key: Internal.MushroomBlock]: Internal.BlockItem, [key: Internal.RedstoneWallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.PortstoneBlock]: Internal.BlockItem, [key: Internal.RadialChassisBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamPlanksStairsBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StorageBlock]: Internal.StorageBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowStoneTilesBlock]: Internal.BlockItem, [key: Internal.FarmBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.GreenStainedGlassBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.UuzDoll0Block]: Internal.UuzDoll0DisplayItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.DeployerBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.BellBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LecternBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.PinkCactus]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamCrackBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SerponConnectionPoint]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.DoubleHighBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.SedimentLordEmptyCoffin]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceCanFire]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLeavesBlock]: Internal.BlockItem, [key: Internal.SedimentUrn]: Internal.BlockItem, [key: Internal.ChestBlock]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.TatamiBlock]: Internal.FuelBlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.BlossomLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.PinkSlimeBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.LightningRodBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.SequencedGearshiftBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.TurntableBlock]: Internal.BlockItem, [key: Internal.RiceBlock]: Internal.RiceItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.LanternBlock]: Internal.BlockItem, [key: Internal.PrimordialCradleBlock]: Internal.BEWLBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SoulPermafrostBlock]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.TwistingVinesBlock]: Internal.BlockItem, [key: Internal.FleshVeinsBlock]: Internal.SimpleBlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.DyedreamLotusBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaCeilingHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DyedreamPlanksFencegateBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.BlackIceBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Pinkagaric2Block]: Internal.BlockItem, [key: Internal.DepotBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamPlanksSlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WindrunnerCrystalOreBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ConverterBlock]: Internal.ConverterBlock$1, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.PlayerHeadBlock]: Internal.PlayerHeadItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FluidTankBlock]: Internal.FluidTankItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SculkGrinderBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DyedreamLeavesBlock]: Internal.BlockItem, [key: Internal.ShadowDungeonBlock1Block]: Internal.BlockItem, [key: Internal.BricksDyedreamquartzBlockBlock]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.GaugeBlock]: Internal.BlockItem, [key: Internal.RedstoneLampBlock]: Internal.BlockItem, [key: Internal.ShadowFissure3Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BlackYellowSapling]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PurpleStainedGlassBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteBrickWallBlock]: Internal.BlockItem, [key: Internal.ToggleLatchBlock]: Internal.BlockItem, [key: Internal.SkilletBlock]: Internal.SkilletItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamquartzBlockBlock]: Internal.BlockItem, [key: Internal.SteamEngineBlock]: Internal.BlockItem, [key: Internal.LootrInventoryBlock]: Internal.LootrChestBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.TheEndlessBookOfDreamSeekersBlock]: Internal.TheEndlessBookOfDreamSeekersDisplayItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.TombstoneEuthymiaBlock]: Internal.BlockItem, [key: Internal.FullFleshDoorBlock]: Internal.SimpleBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.PolishedCalciteBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Wall_Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: Internal.FireflyNestBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SpoutBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.BrightLandDrum]: Internal.BlockItem, [key: Internal.SoulGlassBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.AxisStructureGelBlock]: Internal.StructureGelItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerMetalPressurePlate]: Internal.DoubleHighBlockItem, [key: Internal.CalciteTilesSlabBlock]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.RedStoneWireBlock]: Internal.ItemNameBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ScaleFungusBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CarvedBlackArgilliteNBlock]: Internal.BlockItem, [key: Internal.InfectedDiamondOreBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.BlockCompressedObsidian]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.TombstoneCarrionBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WindIronBlockBlock]: Internal.BlockItem, [key: Internal.BrassFunnelBlock]: Internal.FunnelItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DarkGridBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.GantryCarriageBlock]: Internal.BlockItem, [key: Internal.FiredBlackArgilliteBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.ArmorWreckBlock4Block]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.StructureBlock2Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceCanFire]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CherryLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.PinkSlimeBlockOn]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.PaperLanternBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Grass3Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.FeedingTroughBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.SkullCandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.BracketBlock]: Internal.BracketBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.VirtualCaveFishingNetBlock]: Internal.VirtualCaveFishingNetBlockItem, [key: Internal.MudBrickLatticeBlock]: Internal.ZetaBlockItem, [key: Internal.Flower15Block]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VariantFurnaceBlock]: Internal.ZetaBlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.CongealWindOreBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.WorkshopGrindBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.PaperWallBlock]: Internal.ZetaBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.ChorusPlantBlock]: Internal.BlockItem, [key: Internal.ConstructorBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Shadowdungeondoor2Block]: Internal.BlockItem, [key: Internal.FleshkinChestBlock]: Internal.FleshkinChestBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WindmoorLogBlock]: Internal.BlockItem, [key: Internal.ShadowStoneTilesStairsBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.SkullCandleBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.LifestealerSkullBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.ShadowStoneBrickStairsBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CryingObsidianBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.BuddingAmethystBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ZetaDoorBlock]: Internal.ZetaDoubleHighBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlossomLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.EtherstoneBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ScaffoldingBlock]: Internal.ScaffoldingBlockItem, [key: Internal.AaroncosHandChestBlock]: Internal.AaroncosHandChestDisplayItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.FluidPipeBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.FramedDrawerControllerBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.H5Block]: Internal.BlockItem, [key: Internal.WindKnightSpawnblock0Block]: Internal.WindKnightSpawnblock0DisplayItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WonderlandGiantFrogFrogspawnBlock]: Internal.PlaceOnWaterBlockItem, [key: org.violetmoon.quark.content.automation.block.ChuteBlock]: Internal.ZetaBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.CrackedUnbreakableBricksBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.CarveClarityGlassBlock]: Internal.BlockItem, [key: Internal.ForgedPlatformBlock]: Internal.BlockItem, [key: Internal.SturdyStoneBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FleshChainBlock]: Internal.FleshChainBlockItem, [key: Internal.ZetaStandingSignBlock]: Internal.ZetaSignItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.AgspawnerBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.H7Block]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.StructureGelBlock]: Internal.StructureGelItem, [key: Internal.MudBlock]: Internal.BlockItem, [key: Internal.Flower5Block]: Internal.BlockItem, [key: Internal.Flower3Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.ZetaDoorBlock]: Internal.ZetaDoubleHighBlockItem, [key: Internal.BlackArgillitepressureplateBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.SugarCaneBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.CyanStoneBrickWallBlock]: Internal.BlockItem, [key: Internal.ControllerExtensionBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.FletchingTableBlock]: Internal.BlockItem, [key: Internal.QuestBarrierBlock]: Internal.QuestBarrierBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.BrazierChestBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.CarvedBlackArgilliteBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.DisplayLinkBlock]: Internal.DisplayLinkBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.NyliumBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.StructureBlock21Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CropBlock]: Internal.ItemNameBlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.Pinkagaric1Block]: Internal.BlockItem, [key: Internal.ChainDriveBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: net.pasterdream.block.CloudBlock]: Internal.BlockItem, [key: Internal.ShadowPlanksSlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Pebble0Block]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamBudStairsBlock]: Internal.BlockItem, [key: Internal.SweetBerryBushBlock]: Internal.ItemNameBlockItem, [key: Internal.ABaseBlock$ABaseFallingBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ABaseBlock$ABaseCeilingHangingSign]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TwilightLanternBlock]: Internal.TwilightLanternDisplayItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.UnbreakableBrickWallBlock]: Internal.BlockItem, [key: Internal.RiverMintBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowDungeonBlock2Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowDungeonPortalBlock]: Internal.ShadowDungeonPortalDisplayItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TinyPotatoBlock]: Internal.TinyPotatoBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.EquipableCarvedPumpkinBlock]: Internal.BlockItem, [key: Internal.MushroomColonyBlock]: Internal.MushroomColonyItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.LinearChassisBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.AaroncoshandspawnblockBlock]: Internal.AaroncoshandspawnblockDisplayItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.BeehiveBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RailBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteSlabNBlock]: Internal.BlockItem, [key: Internal.ChiseledUnbreakableBrickSlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.PileOfSkullsBlock]: Internal.BlockItem, [key: Internal.IceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CaveVinesBlock]: Internal.ItemNameBlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.ScorchedWoodBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFallingBlock]: Internal.BlockItem, [key: Internal.HagsCauldron]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.InfusedpolishedGrimstoneBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CarvedSorrowsquashBlock]: Internal.BlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.MoistureProofPaste]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.OwnablePressurePlateBlock]: Internal.SimpleBlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.LightFireflyGlassJarBlock]: Internal.LightFireflyGlassJarDisplayItem, [key: Internal.ArmorloadplatformBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.IcestoneBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ChippedBlackArgilliteBrickBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WetSpongeBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.PumpBlock]: Internal.BlockItem, [key: Internal.DataHandlerBlock]: Internal.GameMasterBlockItem, [key: Internal.AzaleaBlock]: Internal.BlockItem, [key: Internal.UnbreakableBrickStairsBlock]: Internal.BlockItem, [key: Internal.SmartChuteBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ShadowPlanksPressurePlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LightAbleBlock]: Internal.BlockItem, [key: Internal.StructureBlock5Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLeavesBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.DiscernmentGlassBlock]: Internal.BlockItem, [key: Internal.CarpetBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.UnbreakableBricksBlock]: Internal.BlockItem, [key: Internal.ComparatorBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStandingSign]: Internal.SignItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaPressurePlateBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Sandstone_Poison_Dart_Trap]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.ObserverBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.ABaseBlock$ABaseWallSign]: Internal.SignItem, [key: Internal.JNEOreBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CarrotBlock]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.ShadowPlanksPaneBlock]: Internal.BlockItem, [key: Internal.InterfaceBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.Crop3bBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.WeightedPressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Crop0bBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.PulleyBlock]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteBrickWallNBlock]: Internal.BlockItem, [key: Internal.CakeBlock]: Internal.BlockItem, [key: Internal.ZetaFenceGateBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ScarletStainedGlassPanelBlock]: Internal.BlockItem, [key: Internal.EsotericIdolBlock]: Internal.BlockItem, [key: Internal.ScorchedPlanksPressurePlatesBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BambooMatCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.SkullCandleBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrassDiodeBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ChainBlock]: Internal.BlockItem, [key: Internal.WonderlandSapling]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABasePlankCanFire]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AmberCandyOreBlock]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.TallGrassBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.FramedControllerExtensionBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.DyedreamPackedIceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StageBarrierBlock]: Internal.StageBarrierBlockItem, [key: Internal.TallBrightGrass]: Internal.DoubleHighBlockItem, [key: Internal.NightmareStalkerSkullBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.PetrifiedWoodBlock]: Internal.BlockItem, [key: Internal.LargeWaterWheelBlock]: Internal.LargeWaterWheelBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.TreacherousCandleBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.BigDripleafBlock]: Internal.Items$1, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.HoneyBlock]: Internal.BlockItem, [key: Internal.DropperBlock]: Internal.BlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.DyedreamBudSlabBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.TombstoneTEM187Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ChargedAmethystBlockBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.SmallStoneSpiritBlockBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.SoulSoilLayerBlock]: Internal.BlockItem, [key: Internal.GrateBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.ZetaPressurePlateBlock]: Internal.ZetaBlockItem, [key: Internal.LadderBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.NetherrackBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.MagnetBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.TintedGlassBlock]: Internal.BlockItem, [key: Internal.TitaniumOreBlock]: Internal.BlockItem, [key: Internal.EndStoneTeleportTrapBricks]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.SlimeBlock]: Internal.BlockItem, [key: Internal.WarpPlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ScorchedPlanksFenceGateBlock]: Internal.BlockItem, [key: Internal.Shadowshelf0Block]: Internal.BlockItem, [key: Internal.BrassDiodeBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MagmaBlock]: Internal.BlockItem, [key: Internal.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.GravelBlock]: Internal.BlockItem, [key: Internal.ChaosVeinBlock]: Internal.BlockItem, [key: Internal.SwirlsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.JerotesVillageBlocks$FlavorlessMelonBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.MembranePaneBlock]: Internal.SimpleBlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaCeilingHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.DoublePlantBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.MossyBlackArgilliteBrickNBlock]: Internal.BlockItem, [key: Internal.WindmoorLeaves2Block]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.BlockCustomStairs]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WindKnightSpawnblock4Block]: Internal.WindKnightSpawnblock4DisplayItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ArmorWreckBlock3Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseWallHangingSign]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.BlossomLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.MagmaCreamBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ThresholdSwitchBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FrogmistBlock]: Internal.BlockItem, [key: Internal.BasicWorkbenchBlock]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.BlossomLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.FcspawnerBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ForcedTowerBlock]: Internal.ForcedTowerDisplayItem, [key: Internal.ABaseBlock$ABaseButtonBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.BoneBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.RespawnAnchorBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.PaperLanternBlock]: Internal.ZetaBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.MechanicalPistonBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.PoweredRailBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SedimentLordCoffin]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VineBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.RopeBlock]: Internal.RopeItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.SmolderingScorchedLogBlock]: Internal.BlockItem, [key: Internal.JNEWallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.ChthonicExtractorBlock]: Internal.BlockItem, [key: Internal.SkeletosaurusEggBlock]: Internal.BlockItem, [key: Internal.BeardBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.UnbreakablePillarBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.LeverBlock]: Internal.BlockItem, [key: Internal.SmithingTableBlock]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.SmoothDyedreamquartzBlockBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowStoneTilesWallBlock]: Internal.BlockItem, [key: Internal.ShadowVortexBlock]: Internal.ShadowVortexDisplayItem, [key: Internal.WaterlilyBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.CableBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ForgedContainerBlock]: Internal.BlockItem, [key: Internal.LooseShadowDungeonBlockBlock]: Internal.BlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.GlowLichenGrowthBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamquartzBlockStairsBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.MachineCasingBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FurnaceBlock]: Internal.BlockItem, [key: Internal.MembranePaneBlock]: Internal.SimpleBlockItem, [key: Internal.ToxicMagmaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Crop4bBlock]: Internal.BlockItem, [key: Internal.ShadowBrazierBlock]: Internal.ShadowBrazierDisplayItem, [key: Internal.FacingBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.SeagrassBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DrillBlock]: Internal.BlockItem, [key: Internal.FramedSimpleCompactingDrawerBlock]: Internal.CompactingDrawerBlock$CompactingDrawerItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.ClockworkBearingBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SpookySnowmanHeadBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.LostSwordBlockBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CongealWindBlockBlock]: Internal.BlockItem, [key: Internal.HoundTrapBlock]: Internal.BlockItem, [key: Internal.AutoTraderBlock]: Internal.AutoTraderBlock$1, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.DirtyGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowPlanksStairsBlock]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.MerorMetalOres$DeepslateMerorMetalOre]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedStoneOreBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.SandBlock]: Internal.BlockItem, [key: Internal.JigsawBlock]: Internal.GameMasterBlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.BlockBoundary]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.MetalLadderBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.DoubleHighBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.RiceRollMedleyBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.TallGrassBlock]: Internal.BlockItem, [key: Internal.TorchflowerCropBlock]: Internal.ItemNameBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.MoltengoldBlockBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteColumnBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CalamityGrowthBlock]: Internal.BlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.MembraneBlock]: Internal.SimpleBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RedstoneRandomizerBlock]: Internal.ZetaBlockItem, [key: Internal.WebBlock]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StructureGelBlock]: Internal.StructureGelItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DyedreamLarternBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.EncasedShaftBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.NetherSproutsBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.FungusBlock]: Internal.BlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Grass13Block]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.PrimaryMultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.BracketBlock]: Internal.BracketBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteStairsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PitcherCropBlock]: Internal.ItemNameBlockItem, [key: Internal.ShadowDungeonBlock0Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WindmoorFenceBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.PaperWallBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowBedBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DyedreamPlanksBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.LightballBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Mechanical_fusion_Anvil]: Internal.BlockItemCMRender, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TomatoVineBlock]: Internal.ModItems$1, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWoodenButtonBlock]: Internal.ZetaBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ClarityGlasspaneBlock]: Internal.BlockItem, [key: Internal.CarveClarityGlasspaneBlock]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.ChorusVegetationBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.CarveDyedreamGlasspaneBlock]: Internal.BlockItem, [key: Internal.ShadowTrap0Block]: Internal.ShadowTrap0DisplayItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamPlanksDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.BlackYellowDoor]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.SmokestalkBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.GearshiftBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.ZetaWoodenButtonBlock]: Internal.ZetaBlockItem, [key: Internal.ComposterBlock]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FungusBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.CreativeCrateBlock]: Internal.BlockItem, [key: Internal.Flower9Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.LinearChassisBlock]: Internal.BlockItem, [key: Internal.IncubatorBlock]: Internal.IncubatorBlock$1, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CalleCardBlockBlock]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnderDrawerBlock]: Internal.BlockItem, [key: Internal.LoomBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.WildernessThorns]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CactusBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.KelpBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.GeyserBlock]: Internal.BlockItem, [key: Internal.RedstoneLinkBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FrameClarityGlassBlock]: Internal.BlockItem, [key: Internal.StemBlock]: Internal.ItemNameBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.UnbreakableTilesBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.WindKnightSpawnblock1Block]: Internal.WindKnightSpawnblock1DisplayItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.ArmBlock]: Internal.ArmItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SliderMarkBlock]: Internal.BlockItem, [key: Internal.PloughBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamquartzBlockSlabBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.DreamAlloyPillarBlock]: Internal.BlockItem, [key: Internal.WorkshopBlastBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.H1Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ForgedPlatformSlabBlock]: Internal.BlockItem, [key: Internal.ShadowStoneBricksWallBlock]: Internal.BlockItem, [key: Internal.Grass9Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CocoaBlock]: Internal.ItemNameBlockItem, [key: Internal.BeltBlock]: Internal.BeltConnectorItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.TrainTrapdoorBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.BasketBlock]: Internal.FuelBlockItem, [key: Internal.BrightGrass]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindmoorLeaves1Block]: Internal.BlockItem, [key: Internal.NetherFlowerBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.PolishedCalciteSlabBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.FlamingEvilPumpkinBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlabCanFire]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SpongeBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WindKnightSpawnblock2Block]: Internal.WindKnightSpawnblock2DisplayItem, [key: Internal.SculkVeinBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StructureBlock23Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowDungeonDoor0Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Grass11Block]: Internal.BlockItem, [key: Internal.DreamAccumulatorBlock]: Internal.DreamAccumulatorDisplayItem, [key: Internal.MembranePaneBlock]: Internal.SimpleBlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.VillagerLetterBox]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StructureGelBlock]: Internal.StructureGelItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ClarityGlassBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.QuartzEnrichedIronBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ExternalStorageBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.MushroomBlock]: Internal.BlockItem, [key: Internal.CobwebCoverBlock]: Internal.BlockItem, [key: Internal.GlowShroomBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.MeltdreamChestBlock]: Internal.MeltdreamChestDisplayItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CookingPotBlock]: Internal.CookingPotItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaWallHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DesertHeroTombBlock]: Internal.DesertHeroTombDisplayItem, [key: Internal.Flower18Block]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BrewingStandBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.TongueBlock]: Internal.SimpleBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.HewnScorchedLogBlock]: Internal.BlockItem, [key: Internal.RollerBlock]: Internal.RollerBlockItem, [key: Internal.CyanStoneBrickStairsBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.AncientCampfireBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ScorchedPlanksButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.DragonEggBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.InscribedPanelBlock]: Internal.BlockItem, [key: Internal.CarvedPumpkinBlock]: Internal.BlockItem, [key: Internal.PrimaryMultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.Flower2Block]: Internal.BlockItem, [key: Internal.RottenSoilBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceCanFire]: Internal.BlockItem, [key: Internal.WeepingVinesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowPlanksButtonBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockPhasing]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Claypan2Block]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.EjectionPressureBlockBlock]: Internal.BlockItem, [key: Internal.PistonBaseBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ShadowPlanksBlock]: Internal.BlockItem, [key: Internal.ZetaTrapdoorBlock]: Internal.ZetaBlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.MysteriousCrownBlock]: Internal.BlockItem, [key: Internal.RichSoilFarmlandBlock]: Internal.BlockItem, [key: Internal.CyanStoneButtonBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.EndPortalFrameBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.CyanMossStoneBlock]: Internal.BlockItem, [key: Internal.GoldCarveDyedreamGlassBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PurpleStainedGlassPanelBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlackArgilliteColumnNBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.AnalogLeverBlock]: Internal.BlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.LootrChestBlock]: Internal.LootrChestBlockItem, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.ChiseledDyedreamquartzBlockBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.NetherSproutsBlock]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamDeskBlock]: Internal.BlockItem, [key: Internal.ArmorhangerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaTrapdoorBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.PetrifiedBranchBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Crop2bBlock]: Internal.BlockItem, [key: Internal.ShadowChestBlock]: Internal.ShadowChestDisplayItem, [key: Internal.LanternBlock]: Internal.BlockItem, [key: org.violetmoon.quark.content.automation.block.CrafterBlock]: Internal.ZetaBlockItem, [key: Internal.IronRodBlock]: Internal.ZetaBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.LargeStoneLeavesFern]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.Grass6Block]: Internal.BlockItem, [key: Internal.MeltdreamChestOpenBlock]: Internal.MeltdreamChestOpenDisplayItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.BrokenShadowDungeonProtalBlock]: Internal.BrokenShadowDungeonProtalDisplayItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.StoneLeavesFern]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.MossyCyanStoneBrickStairsBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.GoldenrodBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ABaseBlock$ABaseTrapDoorBlock]: Internal.BlockItem, [key: Internal.ZetaWallHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.ZetaWallHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DigesterBlock]: Internal.SimpleBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.SaltBlockBlock]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamdustOreBlock]: Internal.BlockItem, [key: Internal.MossBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.StrangeEnigmaFleshBlock]: Internal.BlockItem, [key: Internal.ControllerRailBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.RedstoneTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.FoldedsteamectoskeletonBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StructureBlock16Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ForgedWallBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SpinyShellTrapBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.AbyssalGrowthBlock]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.CyanStoneBrickSlabBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.WallTorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.HagsCauldron]: Internal.BlockItem, [key: Internal.TargetBlock]: Internal.BlockItem, [key: Internal.WindmoorFenceGateBlock]: Internal.BlockItem, [key: Internal.LadderBlock]: Internal.SimpleBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.CoreExtractorPipeBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: com.jerotes.jerotesvillage.block.Other.OminousTorch]: Internal.OminousTorch, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.OpenGiantDoorBlock]: Internal.OpenGiantDoorDisplayItem, [key: Internal.WeatheringCopperVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Flower7Block]: Internal.DoubleHighBlockItem, [key: Internal.ShadowFissure4Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.SecondRoundWorldPortalBlock]: Internal.BlockItem, [key: Internal.TraderBlock]: Internal.TraderBlock$1, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.FleshFenceGateBlock]: Internal.SimpleBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.RustBlackMetalBlockWallBlock]: Internal.BlockItem, [key: Internal.CuckooClockBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.HugeGlowShroomBlock]: Internal.ZetaBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.SawBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Shadowshelf3Block]: Internal.BlockItem, [key: Internal.StrippedWindmoorLogBlock]: Internal.BlockItem, [key: Internal.AltarBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SandyShrubBlock]: Internal.BlockItem, [key: Internal.SoulPathBlock]: Internal.BlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RolledScrollBlock]: Internal.ScrollItem, [key: Internal.FleshDoorBlock]: Internal.SimpleBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.GoldenFoxSculptureBlock]: Internal.GoldenFoxSculptureDisplayItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.ShadowStoneBrickWallBlock]: Internal.BlockItem, [key: Internal.RoseQuartzLampBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ResurrecterEmptyCoffin]: Internal.BlockItem, [key: Internal.FramedDrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ShadowNyliumBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ChrysalisBlock]: Internal.ChrysalisBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Pinkagaric0Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.Abyssal_Egg_Block]: Internal.BlockItemCMRender, [key: Internal.CopycatPanelBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ChiseledCyanStoneBricksBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamGrassBlock]: Internal.BlockItem, [key: Internal.ChiseledDreamAlloyBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.LogBlock]: Internal.BlockItem, [key: Internal.CarveDyedreamGlassBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.MetalButtonBlock]: Internal.ZetaBlockItem, [key: Internal.FleshLanternBlock]: Internal.SimpleBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteBlock]: Internal.BlockItem, [key: Internal.HalfTransparentBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TombstoneMemesusBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.DyedreamBud2Block]: Internal.BlockItem, [key: Internal.Flower6Block]: Internal.BlockItem, [key: Internal.StainedBlackArgilliteBrickBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFallingBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.QymDoll0Block]: Internal.QymDoll0DisplayItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.MossyCyanStoneBrickWallBlock]: Internal.BlockItem, [key: Internal.DarkBricksBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CasingBlock]: Internal.BlockItem, [key: Internal.DiskDriveBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.TabletPressMachine]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StructureBlock4Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.StructureBlock]: Internal.GameMasterBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.TatamiHalfMatBlock]: Internal.FuelBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.WebbedCobblestoneBlock]: Internal.BlockItem, [key: Internal.NetherPizzaBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DyedreamSandBlock]: Internal.BlockItem, [key: Internal.Grass15Block]: Internal.DoubleHighBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WindmoorPlanksBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceGateCanFire]: Internal.BlockItem, [key: Internal.FluidStorageBlock]: Internal.FluidStorageBlockItem, [key: Internal.DestructorBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.DyedreamSeagrassBlock]: Internal.BlockItem, [key: Internal.PoweredLatchBlock]: Internal.BlockItem, [key: Internal.RestrainmoveBlockBlock]: Internal.BlockItem, [key: Internal.StructureGelBlock]: Internal.StructureGelItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockGrassSlab]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.AndesiteFunnelBlock]: Internal.FunnelItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.BlockCustomStairs]: Internal.BlockItem, [key: Internal.SculkCatalystBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.TombstoneOrionBlock]: Internal.BlockItem, [key: Internal.ChiseledBookShelfBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DreamSpawner1Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.GlowLichenBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Flower14Block]: Internal.BlockItem, [key: Internal.ScaleFungusBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteWallNBlock]: Internal.BlockItem, [key: Internal.SmartObserverBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlackArgilliteNBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.OrganicCompostBlock]: Internal.BlockItem, [key: Internal.Grass2Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.Crop0aBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BundleOfBonesBlock]: Internal.BlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.ZetaFlammablePillarBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.DirtPathBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.ConduitBlock]: Internal.BlockItem, [key: Internal.Grass14Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowDungeonBlock6Block]: Internal.BlockItem, [key: Internal.PuddleofintoxicationBlock]: Internal.BlockItem, [key: Internal.Vine0Block]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.SmolderingScorchedWoodBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowStoneBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.SaplingBlock]: Internal.BlockItem, [key: Internal.OminousWallTorch]: Internal.OminousTorch, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.SeaPickleBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.GrindstoneBlock]: Internal.BlockItem, [key: Internal.Crop1bBlock]: Internal.BlockItem, [key: Internal.WindmoorWoodBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.DyedreamLilyPadBlock]: Internal.BlockItem, [key: Internal.ResurrecterCoffin]: Internal.BlockItem, [key: Internal.TrophyBlock]: Internal.BlockItem, [key: Internal.BlackmetalBlockBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.IceBud0Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DreamSpawner0Block]: Internal.BlockItem, [key: Internal.LootrBarrelBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.JungleSporePlantBlock]: Internal.BlockItem, [key: Internal.ZetaTrapdoorBlock]: Internal.ZetaBlockItem, [key: Internal.StorageMonitorBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.DyedreamPlanksTrapdoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ScorchedPlanksTrapdoorBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StrippedShadowHyphaeBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.ABaseBlock$ABaseStairCanFire]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.LayeredCauldronBlock]: Internal.Items$1, [key: Internal.MetalLadderBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.CogWheelBlock]: Internal.CogwheelBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.Wall_Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.DyedreamSaplingBlock]: Internal.BlockItem, [key: Internal.BrassTunnelBlock]: Internal.BeltTunnelItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowBlastFurnaceBlock]: Internal.ShadowBlastFurnaceDisplayItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.FleshLanternBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StorageBlock]: Internal.StorageBlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.RottenInfernalPumpkinBlock]: Internal.BlockItem, [key: Internal.UnbreakableBrickSlabBlock]: Internal.BlockItem, [key: Internal.FleshSpikeBlock]: Internal.SimpleBlockItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindmoorTrapdoorBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.DecomposerBlock]: Internal.SimpleBlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ChiseledUnbreakableBrickStairsBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BigDripleafStemBlock]: Internal.Items$1, [key: Internal.DarkStainedGlassBlock]: Internal.BlockItem, [key: Internal.EnchantedStone]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WartBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ChorusFlowerBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FluidDrawerBlock]: Internal.FluidDrawerBlock$FluidDrawerItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.AnvilBlock]: Internal.BlockItem, [key: Internal.CalibratedSculkSensorBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamWoodBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamPlanksPaneBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.BioForgeBlock]: Internal.SimpleBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.GaugeBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.UnbreakableTileWallBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.ShadowArenaBlock0Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowDungeonDoor1Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ClosedHoundTrapBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WindKnightSpawnblock3Block]: Internal.WindKnightSpawnblock3DisplayItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.DyedreamquartzOreBlock]: Internal.BlockItem, [key: Internal.CyanStonePillarBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.ImporterBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.RedstoneContactBlock]: Internal.RedstoneContactItem, [key: Internal.Flower8Block]: Internal.BlockItem, [key: Internal.ShadowLight0Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ABaseBlock$ABaseButtonBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.MyaliteBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EnderChestBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.CarvedVillagerConcertinaWire]: Internal.BlockItem, [key: Internal.DetectorBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StructureBlock18Block]: Internal.BlockItem, [key: Internal.H4Block]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StrippedWindmoorWoodBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.MyaliteBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ABaseBlock$ABasePlankCanFire]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.AncientCandleBlock]: Internal.BlockItem, [key: Internal.BlockDarkLamp]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CBlackArgilliteBrickNBlock]: Internal.BlockItem, [key: Internal.ZetaFenceBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.GnawedBonesBlock]: Internal.BlockItem, [key: Internal.Tombstone2003wiseBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseCeilingHangingSign]: Internal.HangingSignItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.ContraptionControlsBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.PuddleofStimulationBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.SafetyNetBlock]: Internal.FuelBlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.CoreExtractorBaseBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Flower16Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.BlackArgilliteColumnSlabNBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.CalciteTilesStairsBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.MagicMirrorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.SoulMagmaBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SimpleCompactingDrawerBlock]: Internal.CompactingDrawerBlock$CompactingDrawerItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowDungeonBlock5Block]: Internal.BlockItem, [key: Internal.H2Block]: Internal.BlockItem, [key: Internal.WindmoorStairsBlock]: Internal.BlockItem, [key: Internal.FrogmistBlock]: Internal.BlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.ShadowFissure5Block]: Internal.BlockItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.FrogmistBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MonsterBoxBlock]: Internal.ZetaBlockItem, [key: Internal.StationBlock]: Internal.TrackTargetingBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CyanStonePressurePlateBlock]: Internal.BlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.EjectionPressurePlateBlock]: Internal.BlockItem, [key: Internal.StructureBlock14Block]: Internal.BlockItem, [key: Internal.SculkShriekerBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BlockPaperLantern]: Internal.BlockItem, [key: Internal.EnigmaCrownBlock]: Internal.BlockItem, [key: Internal.MechanicalPistonBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.PointedDripstoneBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.MysterestFlower]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.CopperPipeBlock]: Internal.ZetaBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.TombstonePetasiBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WildRiceBlock]: Internal.DoubleHighBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.PointedIcicleBlock]: Internal.BlockItem, [key: Internal.FluidInterfaceBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ArmoryCabinetBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.BrightMelons]: Internal.ItemNameBlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.Claypan0Block]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BeaconBlock]: Internal.BlockItem, [key: Internal.LifeCrystalBlock]: Internal.LifeCrystalDisplayItem, [key: Internal.BirdsNestBlock]: Internal.BirdsNestDisplayItem, [key: Internal.SignalBlock]: Internal.TrackTargetingBlockItem, [key: Internal.VirtualCaveEvilBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ScorchedPlanksStairsBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.PieBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowDeskBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.HangingRootsBlock]: Internal.BlockItem, [key: Internal.SchematicannonBlock]: Internal.BlockItem, [key: Internal.Shadowshelf1Block]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LiquidloggedGrateBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SorrowsquashBlock]: Internal.BlockItem, [key: Internal.Door_of_Seal_Block]: Internal.BlockItemCMRender, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.SculkSensorBlock]: Internal.BlockItem, [key: Internal.BeardBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.StructureBlock22Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.SpreadingMembraneBlock]: Internal.SimpleBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.StorageBlock]: Internal.StorageBlockItem, [key: Internal.TombstoneFeralBlock]: Internal.BlockItem, [key: Internal.PinkPetalsBlock]: Internal.BlockItem, [key: Internal.LightAbleBlock]: Internal.BlockItem, [key: Internal.BlazeBurnerBlock]: Internal.BlazeBurnerBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.Claypan1Block]: Internal.BlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.GlowShroomRingBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WartBlock]: Internal.BlockItem, [key: Internal.DaylightDetectorBlock]: Internal.BlockItem, [key: Internal.Wall_Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ABaseBlock$ABasePressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.EnderWatcherBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SecondRoundAloeCrop]: Internal.ItemNameBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.RiceBaleBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.MyaliteBlock]: Internal.ZetaBlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.Sandstone_Ignite_Trap]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.CompactingDrawerBlock]: Internal.CompactingDrawerBlock$CompactingDrawerItem, [key: Internal.GrassBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.FourleafCloverBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WindmoorDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.LootCrateOpenerBlock]: Internal.BlockItem, [key: Internal.EncasedCogwheelBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.PolishedCalciteWallBlock]: Internal.BlockItem, [key: Internal.BacktankBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.PistonExtensionPoleBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.CalamityLampBlock]: Internal.BlockItem, [key: Internal.BoneRodBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WitherRoseBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.BeetrootBlock]: Internal.ItemNameBlockItem, [key: Internal.ZetaFlammablePillarBlock]: Internal.ZetaBlockItem, [key: Internal.StructureBlock15Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStandingSign]: Internal.SignItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.ABaseBlock$ABaseWallHangingSign]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ShadowStoneBrickSlabBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.CauldronBlock]: Internal.Items$1, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockCompressedObsidian]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.JukeboxBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.DreamAlloyBricksBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.LogBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.DyedreamBlockBlock]: Internal.BlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.StructureBlock1Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GuardCrystalBlock]: Internal.GuardCrystalDisplayItem, [key: Internal.StrippedShadowStemBlock]: Internal.BlockItem, [key: Internal.HopperBlock]: Internal.BlockItem, [key: Internal.TombstoneDarkTitan066Block]: Internal.BlockItem, [key: Internal.PortableStorageInterfaceBlock]: Internal.BlockItem, [key: Internal.ThinBlackIceBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.MyaliteBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlossomLeavesBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.SimpleBlockItem, [key: Internal.DynamicSpawnerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.SimpleBlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.ItemDrainBlock]: Internal.BlockItem, [key: Internal.ArmorWreckBlock1Block]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.TrappedChestBlock]: Internal.BlockItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.ExporterBlock]: com.refinedmods.refinedstorage.item.blockitem.BaseBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StorageBlock]: Internal.StorageBlockItem, [key: Internal.GlassPaneBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CelebratoryLampBlock]: Internal.ZetaBlockItem, [key: Internal.WallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.IronFarmBlock]: Internal.IronFarmBlock$1, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.HugeGlowShroomBlock]: Internal.ZetaBlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BreederBlock]: Internal.BreederBlock$1, [key: Internal.JNEDirectionalBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ForgedVentBlock]: Internal.BlockItem, [key: Internal.ScorchedPlanksBlock]: Internal.BlockItem, [key: Internal.SmokerBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CubeSensorBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.FluidValveBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Altar_Of_Void_Block]: Internal.BlockItemCMRender, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.MembranePaneBlock]: Internal.SimpleBlockItem, [key: Internal.ShadowHyphaeBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.ShepherdsPieBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.UnbreakableTileSlabBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.EnchantmentTableBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamBud0Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DyedreamWorldtreeLeavesBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.PortableGridBlock]: Internal.PortableGridBlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.OminousSkullBlock]: Internal.BlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.MembranePaneBlock]: Internal.SimpleBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.MerorProjectionTable]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.HarvesterBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.PlacardBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaSaplingBlock]: Internal.ZetaBlockItem, [key: Internal.MembraneBlock]: Internal.SimpleBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.FireflyGlassJarBlock]: Internal.FireflyGlassJarDisplayItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaFenceGateBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.GravisandBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamBudWallBlock]: Internal.BlockItem, [key: Internal.ClipboardBlock]: Internal.ClipboardBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.CreativeMotorBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DyedreamPlanksFenceBlock]: Internal.BlockItem, [key: Internal.StructureBlock3Block]: Internal.BlockItem, [key: Internal.BlackArgilliteBrickSlabNBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStandingSign]: Internal.SignItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.BlockGlassSlab]: Internal.BlockItem, [key: Internal.EctoSoulSandBlock]: Internal.BlockItem, [key: Internal.WeaponWorkshopBlock]: Internal.WeaponWorkshopDisplayItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.HayBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.ShadowPlanksFenceBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ToxicLanternBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.IrisDoorBlock]: Internal.SimpleBlockItem, [key: Internal.LightAbleBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.EvilCarvedPumpkinBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Statue_Block]: Internal.BlockItemCMRender, [key: Internal.ChiseledUnbreakableBrickWallBlock]: Internal.BlockItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.Boss_Respawn_Spawner_Block]: Internal.BlockItemCMRender, [key: Internal.SnifferEggBlock]: Internal.BlockItem, [key: Internal.FleshFenceBlock]: Internal.SimpleBlockItem, [key: Internal.FluidDrawerBlock]: Internal.FluidDrawerBlock$FluidDrawerItem, [key: Internal.GlowShine]: Internal.BlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowStemBlock]: Internal.BlockItem, [key: Internal.DispenserBlock]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStandingSignBlock]: Internal.ZetaSignItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.Altar_Of_Abyss_Block]: Internal.BlockItemCMRender, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.ExperienceBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FluidStorageBlock]: Internal.FluidStorageBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemBundleOfTimber, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.StructureGelBlock]: Internal.StructureGelItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.ShadowcandleBlock]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ScorchedPlanksDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.IronBarsBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.CanvasRugBlock]: Internal.FuelBlockItem, [key: Internal.WorkshopCauldeonBlock]: Internal.BlockItem, [key: Internal.MechanicalMixerBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FrameClarityGlasspaneBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.FacingPillarBlock]: Internal.BlockItem, [key: Internal.CommandBlock]: Internal.GameMasterBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MetalButtonBlock]: Internal.ZetaBlockItem, [key: Internal.SnowLayerBlock]: Internal.BlockItem, [key: Internal.GoldCarveDyedreamGlasspaneBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.HandCrankBlock]: Internal.BlockItem, [key: Internal.MetalScaffoldingBlock]: Internal.MetalScaffoldingBlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.BarrelBlock]: Internal.BlockItem, [key: Internal.SpeedControllerBlock]: Internal.BlockItem, [key: Internal.HelixIvyBlock]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.DyedreamPlanksButtonBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.RichSoilBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowStoneBricksBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.RootsBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.HoneyGlazedHamBlock]: Internal.BlockItem, [key: Internal.StructureBlock7Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.H6Block]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABasePressurePlateBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.GargoyleStatueBlock]: Internal.GargoyleStatueItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.FigVineBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABasePlankCanFire]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.LogBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.FleshLanternBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.FlapDisplayBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.TatamiMatBlock]: Internal.FuelBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.GirderBlock]: Internal.BlockItem, [key: Internal.BlockCustomWall]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.AmethystClusterBlock]: Internal.BlockItem, [key: Internal.CelestialCoilvineCarpet]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.DeadBushBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.RootsBlock]: Internal.BlockItem, [key: Internal.OnionBlock]: Internal.ItemNameBlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LanternBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.LiquidloggedGrateBlock]: Internal.BlockItem, [key: Internal.MillstoneBlock]: Internal.BlockItem, [key: Internal.WarpedWartBlock]: Internal.BlockItem, [key: Internal.StructureBlock12Block]: Internal.BlockItem, [key: Internal.NyliumBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.H8Block]: Internal.BlockItem, [key: Internal.WitherWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowFungusBlock]: Internal.BlockItem, [key: Internal.CartAssemblerBlock]: Internal.CartAssemblerBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.CabinetBlock]: Internal.FuelBlockItem, [key: Internal.ABaseBlock$ABaseTorch]: Internal.StandingAndWallBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.StructureBlock20Block]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamIceBlock]: Internal.BlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseBrushableBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MangrovePropaguleBlock]: Internal.BlockItem, [key: Internal.BiometricMembraneBlock]: Internal.BiometricMembraneBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PeculiarBellBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CyanStoneBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BotanizeAltar]: Internal.BlockItem, [key: Internal.ShadowStoneBricksStairsBlock]: Internal.BlockItem, [key: Internal.OrangeStainedGlassBlock]: Internal.BlockItem, [key: Internal.StoveBlock]: Internal.BlockItem, [key: Internal.Shadowshelf2Block]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.CoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.PillarDyedreamquartzBlockBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.MechanicalCrafterBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.WindmoorPressurePlateBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.DarkStainedGlassPanelBlock]: Internal.BlockItem, [key: Internal.ArgilliteLampBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Crop3aBlock]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ToolboxBlock]: Internal.UncontainableBlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.CorundumClusterBlock]: Internal.ZetaBlockItem, [key: Internal.DoublePlantBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MyceliumBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlockLightSwitch]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.PieBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.CeilingHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.ScorchedPlanksSlabBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SoulCandleBlock]: Internal.BlockItem, [key: Internal.Grass12Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DetectorRailBlock]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.InfestedRotatedPillarBlock]: Internal.BlockItem, [key: Internal.PolishedBasaltBrickBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteStairsNBlock]: Internal.BlockItem, [key: Internal.Cursed_Tombstone_Block]: Internal.BlockItemCMRender, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ThornyTortoiseEggBlock]: Internal.BlockItem, [key: Internal.LootrShulkerBlock]: Internal.LootrShulkerBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.StorageBlock]: Internal.StorageBlockItem, [key: Internal.EMP_Block]: Internal.BlockItemCMRender, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.HelixIvyBlock]: Internal.BlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.HosePulleyBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaFenceBlock]: Internal.ZetaBlockItem, [key: Internal.MementoItem11Block]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemPalletOfBricks, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ObsidianPressurePlateBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.LootrTrappedChestBlock]: Internal.LootrChestBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ShadowStoneBricksSlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.ResearchTableBlock]: Internal.ResearchTableDisplayItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallSign]: Internal.SignItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.NewHagsCauldron]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.FenceGateBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.TyrantOfTheMountainRealmStatue]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.SporeshroomBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.ZetaDoorBlock]: Internal.ZetaDoubleHighBlockItem, [key: Internal.MossyBlackArgilliteBrickBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StorageSacBlock]: Internal.StorageSacBlockItem, [key: Internal.ThickShadowBlockBlock]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: com.refinedmods.refinedstorage.block.DetectorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.SimpleBlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.TrainTrapdoorBlock]: Internal.BlockItem, [key: Internal.FelSoilBlock]: Internal.BlockItem, [key: Internal.WhistleBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.TerribleTensummonBlock]: Internal.BlockItem, [key: Internal.ChiseledUnbreakableBricksBlock]: Internal.BlockItem, [key: Internal.FragileScorchedBoardsBlock]: Internal.BlockItem, [key: Internal.RawTitaniumBlockBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DreamCauldronBlock]: Internal.DreamCauldronDisplayItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.CultivatedPumpkinBlock]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.WindmoorSlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MembraneBlock]: Internal.SimpleBlockItem, [key: Internal.RackBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ForgedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.RustBlackMetalBlockBlock]: Internal.BlockItem, [key: Internal.CelebratoryLampBlock]: Internal.ZetaBlockItem, [key: Internal.BlockRotatable]: Internal.ItemBlockWoodenCrate, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PicnicBasketBlock]: Internal.PicnicBasketDisplayItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PolishedGrimstoneBlock]: Internal.BlockItem, [key: Internal.ThatchBlock]: Internal.ZetaBlockItem, [key: Internal.CopycatStepBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaFlammablePillarBlock]: Internal.ZetaBlockItem, [key: Internal.VariantChestBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.ShadowPlanksDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.WaystoneBlock]: Internal.BlockItem, [key: Internal.ObsidianExplosionTrapBricks]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.MerorMetalOres$MerorMetalOre]: Internal.BlockItem, [key: Internal.ShotgunBarrelBlock]: Internal.BlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.CloudBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.PurpurVoidRuneTrapBlock]: Internal.BlockItem, [key: Internal.Sandstone_Falling_Trap]: Internal.BlockItem, [key: Internal.Shadowdungeondoor3Block]: Internal.BlockItem, [key: Internal.MudBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WickedVineBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FossilOreBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.TrackBlock]: Internal.TrackBlockItem, [key: Internal.ABaseBlock$ABaseSlab]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.LightAbleBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.Flower1Block]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.StructureBlock9Block]: Internal.BlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.ABaseBlock$ABaseLeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MovingMagnetizedBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerMetalAnvil]: Internal.BlockItem, [key: Internal.FluidTankBlock]: Internal.FluidTankItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.WirelessTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.AltarBlock]: Internal.BlockItem, [key: Internal.RustBlackMetalBlockBarsBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowBlastFurnaceCoreBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CabinetBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ABaseBlock$ABaseWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WindmoorCrateBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DoublePlantBlock]: Internal.DoubleHighBlockItem, [key: Internal.CabbageBlock]: Internal.ItemNameBlockItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DyedreamBudBlockBlock]: Internal.BlockItem, [key: Internal.HauntedBellBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.FeastBlock]: Internal.BlockItem, [key: Internal.ArmorWreckBlock2Block]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PoweredRailBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.BasinBlock]: Internal.BlockItem, [key: Internal.InfernalEvilPumpkinBlock]: Internal.BlockItem, [key: Internal.WallGrowingWartBlock]: Internal.BlockItem, [key: Internal.TrackObserverBlock]: Internal.TrackTargetingBlockItem, [key: Internal.RedStoneOreBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.BarrierBlock]: Internal.BlockItem, [key: Internal.CampfireBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.Cataclysm_Skull_Block]: Internal.CataclysmSkullItem, [key: Internal.ElevatorContactBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.EcologyGlassJarBlock]: Internal.EcologyGlassJarDisplayItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WhiteSandBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlidingDoorBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteBrickStairsBlock]: Internal.BlockItem, [key: Internal.TurtleEggBlock]: Internal.BlockItem, [key: Internal.ZetaWallSignBlock]: Internal.ZetaSignItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MawHopperBlock]: Internal.SimpleBlockItem, [key: Internal.HayBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.NyliumPathBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaFenceGateBlock]: Internal.ZetaBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteBrickSlabBlock]: Internal.BlockItem, [key: Internal.CrushingWheelBlock]: Internal.BlockItem, [key: Internal.Grass5Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.Flower17Block]: Internal.BlockItem, [key: Internal.SecondRoundNigrums]: Internal.ItemNameBlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.StructureBlock11Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PowderSnowBlock]: Internal.SolidBucketItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.MyaliteCrystalBlock]: Internal.ZetaBlockItem, [key: Internal.H3Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.BlockGlassStairs]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.MangroveLeavesBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Grass7Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceGateCanFire]: Internal.BlockItem, [key: Internal.ShadowPlanksTrapdoorBlock]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.PiglinSecondRoundWorldPortalBlock]: Internal.BlockItem, [key: Internal.ShadowBlockBlock]: Internal.BlockItem, [key: Internal.ChuteBlock]: Internal.ChuteItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.CrackedShadowStoneBrickBlock]: Internal.BlockItem, [key: Internal.ForgedCrateBlock]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.UnbreakableTileStairsBlock]: Internal.BlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.LightBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.BlockCompressedStone]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.BambooStalkBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.Altar_Of_Amethyst_Block]: Internal.BlockItemCMRender, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StructureBlock6Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.SeepingBedrockBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StructureBlock13Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.FluidStorageBlock]: Internal.FluidStorageBlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallTorch]: Internal.StandingAndWallBlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.NoteBlock]: Internal.BlockItem, [key: Internal.JNETorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.SoulFurnaceBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.BlackIcicleBlock]: Internal.BlockItem, [key: Internal.ShadowFissure2Block]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Ink_Mural_Block]: Internal.BlockItem, [key: Internal.SerponClassicalBomb]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.WildCropBlock]: Internal.BlockItem, [key: Internal.ValveHandleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.StarcallCrackBlock]: Internal.BlockItem, [key: Internal.MoltengoldOreBlock]: Internal.BlockItem, [key: Internal.FluidDrawerBlock]: Internal.FluidDrawerBlock$FluidDrawerItem, [key: Internal.ZetaWallSignBlock]: Internal.ZetaSignItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.NetherWartBlock]: Internal.ItemNameBlockItem, [key: Internal.WoodPostBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.ZetaFlammableBlock]: Internal.ZetaBlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.WallHangingSignBlock]: Internal.HangingSignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PortableStorageInterfaceBlock]: Internal.BlockItem, [key: Internal.BlockCustomWall]: Internal.BlockItem, [key: Internal.CarvedSorrowsquashBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.CrafterManagerBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABasePressurePlateBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.SmartFluidPipeBlock]: Internal.BlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.DreamAlloyBlockBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ShadowFissure1Block]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.AngelBlockBlock]: Internal.BlockItem, [key: Internal.PrimaryMultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ForgedWorkbenchBlock]: Internal.BlockItem, [key: Internal.InfestedBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.Pinkagaric3Block]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.TallFlowerBlock]: Internal.DoubleHighBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.WallHangingCanvasSignBlock]: Internal.HangingSignItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.PaperWallBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseTrapDoorBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ShadowFissure0Block]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.LootrVariantChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.GrimstoneBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SoulSandBlock]: Internal.BlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.Grass8Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.RootedDirtBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.NixieTubeBlock]: Internal.BlockItem, [key: Internal.WitherSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.DrawerControllerBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BaseCoralPlantBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallSign]: Internal.SignItem, [key: Internal.BacktankBlock]: Internal.BacktankItem$BacktankBlockItem, [key: Internal.StrawBaleBlock]: Internal.BlockItem, [key: Internal.BrushableBlock]: Internal.BlockItem, [key: Internal.MembraneBlock]: Internal.SimpleBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteBrickStairsNBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ActiveCubeSensorBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.CandleBlock]: Internal.BlockItem, [key: Internal.CutVineBlock]: Internal.ZetaBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FluidStorageBlock]: Internal.FluidStorageBlockItem, [key: Internal.ShadowStoneBrickBlock]: Internal.BlockItem, [key: Internal.FacingBlock]: Internal.BlockItem, [key: Internal.JNEBrushableBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ShulkerBoxBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.MultiblockSchematicBlock]: Internal.StackedMultiblockSchematicItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.CursedScarletOrnateGlassPaneBlock]: Internal.BlockItem, [key: Internal.StickerBlock]: Internal.BlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.Crop1aBlock]: Internal.BlockItem, [key: Internal.GrassBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowDungeonKey0Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MossyCyanStoneBrickSlabBlock]: Internal.BlockItem, [key: Internal.CalciteTilesWallBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteWallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.DarkCloudBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.TaskScreenBlock]: Internal.ScreenBlockItem, [key: Internal.ShadowPlanksFencegateBlock]: Internal.BlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.ZetaPillarBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ButtonBlock]: Internal.BlockItem, [key: Internal.NozzleBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerPotBlock]: Internal.BlockItem, [key: Internal.BreakwindCurtainBlock]: Internal.BlockItem, [key: Internal.UnstableHagsCauldron]: Internal.BlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.TripWireHookBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaCeilingHangingSignBlock]: Internal.ZetaHangingSignItem, [key: Internal.FrogspawnBlock]: Internal.PlaceOnWaterBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ClutchBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.ConcretePowderBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.LeavesBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BlockRotatableHorizontalShaped]: Internal.ItemPileOfBricks, [key: Internal.ZetaWoodenButtonBlock]: Internal.ZetaBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.ABaseBlock$ABaseSlabCanFire]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.BambooMatBlock]: Internal.ZetaBlockItem, [key: Internal.BaseCoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ShadowDungeonBlock4Block]: Internal.BlockItem, [key: Internal.StainedGlassPaneBlock]: Internal.BlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.Mural_Block]: Internal.BlockItem, [key: Internal.DiskManipulatorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CrafterBlock]: Internal.ColoredBlockItem, [key: Internal.Altar_Of_Fire_Block]: Internal.BlockItemCMRender, [key: Internal.DarkMetalBlockBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WindmoorButtonBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.HugeMushroomBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.RelayBlock]: Internal.ColoredBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.CorundumBlock]: Internal.ZetaBlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.WaterWheelBlock]: Internal.BlockItem, [key: Internal.BlastFurnaceBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ModularLarynxBlock]: Internal.SimpleBlockItem, [key: Internal.StructureBlock10Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.GiantDoorBlock]: Internal.GiantDoorDisplayItem, [key: Internal.ChiseledShadowStoneBrickBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.HewnScorchedWoodBlock]: Internal.BlockItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.ClayPillarBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABasePlankCanFire]: Internal.BlockItem, [key: Internal.ZetaStandingSignBlock]: Internal.ZetaSignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.StoolBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.SimpleBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.WallBannerBlock]: Internal.BannerItem, [key: Internal.DyedreamLogBlock]: Internal.BlockItem, [key: Internal.DropExperienceBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ShadowStoneTilesSlabBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStair]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.ChunkLoaderBlock]: Internal.BaseBlockItem, [key: Internal.DyedreamPlanksPressurePlateBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.HammerBaseBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperStairBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.VariantLadderBlock]: Internal.ZetaBlockItem, [key: Internal.MechanicalBearingBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStairCanFire]: Internal.BlockItem, [key: Internal.CrateBlock]: Internal.ZetaBlockItem, [key: Internal.BlackArgilliteColumnSlabBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.GuardBlockBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.StonecutterBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseWallHangingSign]: Internal.HangingSignItem, [key: Internal.TorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.VariantBookshelfBlock]: Internal.ZetaBlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.DyedreamGlassBlock]: Internal.BlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.BioLabBlock]: Internal.SimpleBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseLogCanUseAxe]: Internal.BlockItem, [key: Internal.BlockDirtSlab]: Internal.BlockItem, [key: Internal.StandingSignBlock]: Internal.SignItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.SimpleBlockItem, [key: Internal.WeightedPressurePlateBlock]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.FleshBlock]: Internal.SimpleBlockItem, [key: Internal.StemBlock]: Internal.ItemNameBlockItem, [key: Internal.TombstoneSomfunambulistBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteSlabBlock]: Internal.BlockItem, [key: Internal.CuckooClockBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.ScarletStainedGlassBlock]: Internal.BlockItem, [key: Internal.TombstoneFubukiBanzaiBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DeepDustBlock]: Internal.BlockItem, [key: Internal.CoralPlantBlock]: Internal.BlockItem, [key: Internal.ThickCloudBlock]: Internal.BlockItem, [key: Internal.LavaCauldronBlock]: Internal.Items$1, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.ZetaInheritedPaneBlock]: Internal.ZetaBlockItem, [key: Internal.OrangeStainedGlassPanelBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.TorchBlock]: Internal.StandingAndWallBlockItem, [key: Internal.PressurePlateBlock]: Internal.BlockItem, [key: Internal.BuddingTomatoBlock]: Internal.ModItems$1, [key: Internal.ABaseBlock$ABaseCeilingHangingSign]: Internal.HangingSignItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SailBlock]: Internal.BlankSailBlockItem, [key: Internal.StainedGlassBlock]: Internal.BlockItem, [key: Internal.StructureBlock17Block]: Internal.BlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.WeatheringCopperSlabBlock]: Internal.BlockItem, [key: Internal.DecoratedPotBlock]: Internal.BlockItem, [key: Internal.GlazedTerracottaBlock]: Internal.BlockItem, [key: Internal.MarigoldsBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.RainbowLampBlock]: Internal.ZetaBlockItem, [key: Internal.TrapDoorBlock]: Internal.BlockItem, [key: Internal.TombstoneDerivasBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.MechanicalPressBlock]: Internal.AssemblyOperatorBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.PotatoBlock]: Internal.ItemNameBlockItem, [key: Internal.CraftingMonitorBlock]: Internal.ColoredBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.VillagerBlock]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.LeafCarpetBlock]: Internal.ZetaBlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.WeatheringCopperFullBlock]: Internal.BlockItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: org.violetmoon.quark.content.building.block.RopeBlock]: Internal.RopeBlock$1, [key: Internal.WindironBarsBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.BrushableBlock]: Internal.BlockItem, [key: Internal.SculkBlock]: Internal.BlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallSignBlock]: Internal.ZetaSignItem, [key: Internal.ABaseBlock$ABaseLogCanFire]: Internal.BlockItem, [key: Internal.Grass4Block]: Internal.DoubleHighBlockItem, [key: Internal.ABaseBlock$ABaseFallingBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ShadowDungeonKey1Block]: Internal.BlockItem, [key: Internal.RuinedMultiblockSchematicBlock]: Internal.RuinedMultiblockSchematicItem, [key: Internal.MeshDoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.CompactingFramedDrawerBlock]: Internal.CompactingDrawerBlock$CompactingDrawerItem, [key: Internal.SecurityManagerBlock]: Internal.ColoredBlockItem, [key: Internal.DirectionalSlabBlock]: Internal.SimpleBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.WraithingLesionBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseFenceGateCanFire]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.JNEStairBlock]: Internal.BlockItem, [key: Internal.PiglinWallSkullBlock]: Internal.StandingAndWallBlockItem, [key: Internal.MossyCyanStoneBricksBlock]: Internal.BlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.ZetaSlabBlock]: Internal.ZetaBlockItem, [key: Internal.HedgeBlock]: Internal.ZetaBlockItem, [key: Internal.MatrixEnchantingTableBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaPaneBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.JNEHorizontalDirectionalBlock]: Internal.BlockItem, [key: Internal.FarmerBlock]: Internal.FarmerBlock$1, [key: Internal.BannerBlock]: Internal.BannerItem, [key: Internal.SoulOreBlock]: Internal.BlockItem, [key: Internal.FlowerBlock]: Internal.BlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.NetworkReceiverBlock]: Internal.ColoredBlockItem, [key: Internal.ABaseBlock$ABaseWallBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Grass10Block]: Internal.DoubleHighBlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.MangroveRootsBlock]: Internal.BlockItem, [key: Internal.SharestoneBlock]: Internal.BlockItem, [key: Internal.BedBlock]: Internal.BedItem, [key: Internal.WallSignBlock]: Internal.SignItem, [key: Internal.SeatBlock]: Internal.BlockItem, [key: Internal.PoweredBlock]: Internal.BlockItem, [key: Internal.QuarkVerticalSlabBlock]: Internal.ZetaBlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.StemBlock]: Internal.ItemNameBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.DoorBlock]: Internal.DoubleHighBlockItem, [key: Internal.SmallDripleafBlock]: Internal.DoubleHighBlockItem, [key: Internal.GridBlock]: Internal.ColoredBlockItem, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.VariantTrappedChestBlock]: Internal.ZetaBlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.DreamTrainStructureBlock]: Internal.BlockItem, [key: Internal.PumpkinBlock]: Internal.BlockItem, [key: Internal.NetworkTransmitterBlock]: Internal.ColoredBlockItem, [key: Internal.ABaseBlock$ABaseTrapDoorBlock]: Internal.BlockItem, [key: Internal.CoralWallFanBlock]: Internal.StandingAndWallBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.Flower11Block]: Internal.DoubleHighBlockItem, [key: Internal.TombstoneMikeRoryBlock]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.Grass1Block]: Internal.BlockItem, [key: Internal.EncasedPipeBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaGlassBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedGlassBlock]: Internal.BlockItem, [key: Internal.FenceBlock]: Internal.BlockItem, [key: Internal.DyedreamBud1Block]: Internal.BlockItem, [key: Internal.WindmillBearingBlock]: Internal.BlockItem, [key: Internal.ZetaWallBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ZetaBlock]: Internal.ZetaBlockItem, [key: Internal.OrificeBlock]: Internal.SimpleBlockItem, [key: Internal.AaroncosArenaPortalsBlock]: Internal.BlockItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.ShadowDungeonBlock3Block]: Internal.BlockItem, [key: Internal.RotatedPillarBlock]: Internal.BlockItem, [key: Internal.WoolCarpetBlock]: Internal.BlockItem, [key: Internal.PowderSnowCauldronBlock]: Internal.Items$1, [key: Internal.SlabBlock]: Internal.BlockItem, [key: Internal.BlackArgilliteBrickBlock]: Internal.BlockItem, [key: Internal.AmethystBlock]: Internal.BlockItem, [key: Internal.GildgrassBlock]: Internal.BlockItem, [key: Internal.ConnectedPillarBlock]: Internal.BlockItem, [key: Internal.GlassBlock]: Internal.BlockItem, [key: Internal.WallCanvasSignBlock]: Internal.SignItem, [key: Internal.DrawerBlock]: Internal.DrawerBlock$DrawerItem, [key: Internal.WallBlock]: Internal.BlockItem, [key: Internal.WindowBlock]: Internal.BlockItem, [key: Internal.Flower10Block]: Internal.DoubleHighBlockItem, [key: Internal.SchematicTableBlock]: Internal.BlockItem, [key: Internal.PieBlock]: Internal.BlockItem, [key: Internal.ABaseBlock$ABaseStairCanFire]: Internal.BlockItem, [key: Internal.StandingCanvasSignBlock]: Internal.SignItem, [key: Internal.ControllerBlock]: Internal.ControllerBlockItem, [key: Internal.ZetaStairsBlock]: Internal.ZetaBlockItem, [key: Internal.ConnectedGlassPaneBlock]: Internal.BlockItem, [key: Internal.CyanStoneBricksBlock]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.Block]: Internal.BlockItem, [key: Internal.CoralBlock]: Internal.BlockItem, [key: Internal.CeilingHangingSignBlock]: Internal.HangingSignItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.LootrVariantTrappedChestBlock]: Internal.LootrVariantChestBlock$Item, [key: Internal.Block]: Internal.BlockItem, [key: Internal.ArmorWreckBlock0Block]: Internal.BlockItem, [key: Internal.HollowLogBlock]: Internal.ZetaBlockItem, [key: Internal.StairBlock]: Internal.BlockItem, [key: Internal.Mural_Block]: Internal.BlockItem}) & (Internal.Map<Internal.Block, Internal.Item>);
        static readonly EAT_DURATION: (32) & (number);
        static readonly BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
        static readonly MAX_STACK_SIZE: (64) & (number);
        static readonly MAX_BAR_WIDTH: (13) & (number);
        descriptionId: string;
        renderProperties: any;
        craftingRemainingItem: Internal.Item;
    }
    type Item_ = Item | Special.Item;
    class Unknownnotes0Item extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type Unknownnotes0Item_ = Unknownnotes0Item;
    class DynamicRecipeComponent extends Internal.Record {
        constructor(desc: Internal.TypeDescJS_, factory: Internal.DynamicRecipeComponent$Factory_)
        desc(): Internal.TypeDescJS;
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        factory(): Internal.DynamicRecipeComponent$Factory;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(o: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
    }
    type DynamicRecipeComponent_ = DynamicRecipeComponent;
    interface ScoreboardNameProvider {
        abstract getReferencedContextParams(): Internal.Set<Internal.LootContextParam<any>>;
        abstract getType(): Internal.LootScoreProviderType;
        abstract getScoreboardName(arg0: Internal.LootContext_): string;
        get referencedContextParams(): Internal.Set<Internal.LootContextParam<any>>
        get type(): Internal.LootScoreProviderType
    }
    type ScoreboardNameProvider_ = ScoreboardNameProvider;
    class RedstoneLinkBlockEntity extends Internal.SmartBlockEntity {
        constructor(arg0: Internal.BlockEntityType_<any>, arg1: BlockPos_, arg2: Internal.BlockState_)
        requestModelDataUpdate(): void;
        destroy(): void;
        sodiumdynamiclights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        write(arg0: Internal.CompoundTag_, arg1: boolean): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        readClient(arg0: Internal.CompoundTag_): void;
        isVirtual(): boolean;
        /**
         * @deprecated
        */
        setBlockState(arg0: Internal.BlockState_): void;
        remove(): void;
        load(arg0: Internal.CompoundTag_): void;
        award(arg0: Internal.CreateAdvancement_): void;
        setChanged(): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        "getUpdatePacket()"(): Internal.Packet<any>;
        packetTarget(): Internal.PacketDistributor$PacketTarget;
        handler$dok000$setRemoved(arg0: Internal.CallbackInfo_): void;
        setRemoved(): void;
        sdl$isDynamicLightEnabled(): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        writeSafe(arg0: Internal.CompoundTag_): void;
        transmit(arg0: number): void;
        getType(): Internal.BlockEntityType<any>;
        writeClient(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        "getUpdatePacket()"(): Internal.ClientboundBlockEntityDataPacket;
        refreshBlockState(): void;
        getRenderBoundingBox(): Internal.AABB;
        getClass(): typeof any;
        sendToMenu(arg0: Internal.FriendlyByteBuf_): void;
        static getPosFromTag(arg0: Internal.CompoundTag_): BlockPos;
        sdl$shouldUpdateDynamicLight(): boolean;
        addBehaviours(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        hasAnyComparatorNearby(): boolean;
        onChunkUnloaded(): void;
        saveToItem(arg0: Internal.ItemStack_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        static addEntityType(arg0: Internal.CompoundTag_, arg1: Internal.BlockEntityType_<any>): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        clearRemoved(): void;
        getUpdatePacket(): Internal.Packet<any>;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        setLazyTickRate(arg0: number): void;
        awardIfNear(arg0: Internal.CreateAdvancement_, arg1: number): void;
        sdl$getDynamicLightX(): number;
        containedChunk(): Internal.LevelChunk;
        getPersistentData(): Internal.CompoundTag;
        toString(): string;
        markVirtual(): void;
        triggerEvent(arg0: number, arg1: number): boolean;
        hasLevel(): boolean;
        notifyAll(): void;
        forEachBehaviour(arg0: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        sdl$dynamicLightTick(): void;
        invalidate(): void;
        wait(arg0: number): void;
        reviveCaps(): void;
        sendData(): void;
        getBehaviour<T extends Internal.BlockEntityBehaviour>(arg0: Internal.BehaviourType_<T>): T;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        getUpdateTag(): Internal.CompoundTag;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        setLevel(arg0: Internal.Level_): void;
        sdl$getLuminance(): number;
        notify(): void;
        addBehavioursDeferred(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        handler$dok000$setLevel(arg0: Internal.Level_, arg1: Internal.CallbackInfo_): void;
        getBlockPos(): BlockPos;
        sdl$resetDynamicLight(): void;
        isRemoved(): boolean;
        onLoad(): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        sdl$getDynamicLightY(): number;
        sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        initialize(): void;
        invalidateCaps(): void;
        getBlockState(): Internal.BlockState;
        tick(): void;
        canPlayerUse(arg0: Internal.Player_): boolean;
        lazyTick(): void;
        static loadStatic(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.CompoundTag_): Internal.BlockEntity;
        wait(): void;
        m_183515_(arg0: Internal.CompoundTag_): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        saveWithId(): Internal.CompoundTag;
        notifyUpdate(): void;
        sdl$getDynamicLightLevel(): Internal.Level;
        wait(arg0: number, arg1: number): void;
        isChunkUnloaded(): boolean;
        getLevel(): Internal.Level;
        getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        onlyOpCanSetNbt(): boolean;
        getSignal(): number;
        sdl$getDynamicLightZ(): number;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        saveWithFullMetadata(): Internal.CompoundTag;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        setSignal(arg0: number): void;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.BlockEntity>): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        blockHolderGetter(): Internal.HolderGetter<Internal.Block>;
        getReceivedSignal(): number;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        serializeNBT(): Internal.CompoundTag;
        registerAwardables(arg0: Internal.List_<Internal.BlockEntityBehaviour>, ...arg1: Internal.CreateAdvancement_[]): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        hashCode(): number;
        getModelData(): Internal.ModelData;
        equals(arg0: any): boolean;
        get virtual(): boolean
        /**
         * @deprecated
        */
        set blockState(arg0: Internal.BlockState_)
        get "updatePacket()"(): Internal.Packet<any>
        get type(): Internal.BlockEntityType<any>
        get "updatePacket()"(): Internal.ClientboundBlockEntityDataPacket
        get renderBoundingBox(): Internal.AABB
        get class(): typeof any
        get updatePacket(): Internal.Packet<any>
        set lazyTickRate(arg0: number)
        get persistentData(): Internal.CompoundTag
        get updateTag(): Internal.CompoundTag
        set level(arg0: Internal.Level_)
        get blockPos(): BlockPos
        get removed(): boolean
        get blockState(): Internal.BlockState
        get chunkUnloaded(): boolean
        get level(): Internal.Level
        get signal(): number
        set signal(arg0: number)
        get receivedSignal(): number
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        get modelData(): Internal.ModelData
    }
    type RedstoneLinkBlockEntity_ = RedstoneLinkBlockEntity;
    interface ITrackedContentsItemHandler extends Internal.IItemHandlerSimpleInserter {
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        "insertItem(net.minecraft.world.item.ItemStack,boolean)"(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract setStackInSlot(arg0: number, arg1: Internal.ItemStack_): void;
        isEmpty(): boolean;
        abstract unregisterStackKeyListeners(): void;
        clear(ingredient: Internal.Ingredient_): void;
        abstract "extractItem(int,int,boolean)"(arg0: number, arg1: number, arg2: boolean): Internal.ItemStack;
        find(): number;
        abstract getSlots(): number;
        abstract extractItem(arg0: number, arg1: number, arg2: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        setChanged(): void;
        abstract "getSlots()"(): number;
        kjs$self(): Internal.IItemHandler;
        abstract registerTrackingListeners(arg0: Internal.Consumer_<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>, arg1: Internal.Consumer_<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>, arg2: Internal.Runnable_, arg3: Internal.Runnable_): void;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        abstract hasEmptySlots(): boolean;
        getHeight(): number;
        countNonEmpty(): number;
        abstract "insertItem(int,net.minecraft.world.item.ItemStack,boolean)"(arg0: number, arg1: Internal.ItemStack_, arg2: boolean): Internal.ItemStack;
        abstract "getStackInSlot(int)"(arg0: number): Internal.ItemStack;
        asContainer(): net.minecraft.world.Container;
        "getSlotLimit(int)"(i: number): number;
        getWidth(): number;
        getSlotLimit(i: number): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract getTrackedStacks(): Internal.Set<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>;
        abstract getInternalSlotLimit(arg0: number): number;
        abstract insertItem(arg0: Internal.ItemStack_, arg1: boolean): Internal.ItemStack;
        abstract insertItem(arg0: number, arg1: Internal.ItemStack_, arg2: boolean): Internal.ItemStack;
        "isItemValid(int,net.minecraft.world.item.ItemStack)"(i: number, itemStack: Internal.ItemStack_): boolean;
        abstract "setStackInSlot(int,net.minecraft.world.item.ItemStack)"(arg0: number, arg1: Internal.ItemStack_): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        abstract isItemValid(arg0: number, arg1: Internal.ItemStack_): boolean;
        get empty(): boolean
        get slots(): number
        get "slots()"(): number
        get height(): number
        get width(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get trackedStacks(): Internal.Set<net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey>
        get mutable(): boolean
    }
    type ITrackedContentsItemHandler_ = ITrackedContentsItemHandler;
    class UnbreakableBrickStairsBlock extends Internal.StairBlock {
        constructor()
        static isStairs(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type UnbreakableBrickStairsBlock_ = UnbreakableBrickStairsBlock;
    interface ItemSupplier {
        abstract getItem(): Internal.ItemStack;
        get item(): Internal.ItemStack
        (): Internal.ItemStack_;
    }
    type ItemSupplier_ = ItemSupplier | (()=> Internal.ItemStack_);
    class BufferViewInfo {
        constructor()
        getClass(): typeof any;
        isValid(): boolean;
        toString(): string;
        equals(o: Internal.BufferViewInfo_): boolean;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        wait(): void;
        wait(arg0: number): void;
        "equals(icyllis.arc3d.engine.BufferViewInfo)"(o: Internal.BufferViewInfo_): boolean;
        "equals(java.lang.Object)"(arg0: any): boolean;
        equals(arg0: any): boolean;
        set(o: Internal.BufferViewInfo_): void;
        get class(): typeof any
        get valid(): boolean
        mSize: number;
        mBuffer: icyllis.arc3d.engine.Buffer;
        mOffset: number;
    }
    type BufferViewInfo_ = BufferViewInfo;
    interface ChestMenuInventoryClickEvent$Callback {
        abstract onClick(arg0: Internal.ChestMenuInventoryClickEvent_): void;
        (arg0: Internal.ChestMenuInventoryClickEvent): void;
    }
    type ChestMenuInventoryClickEvent$Callback_ = ChestMenuInventoryClickEvent$Callback | ((arg0: Internal.ChestMenuInventoryClickEvent)=> void);
    interface Boolean2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<boolean, V> {
        put(arg0: boolean, arg1: V): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Boolean2ShortFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Boolean2ObjectFunction<T>;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2ObjectFunction<V>;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        "getOrDefault(java.lang.Object,java.lang.Object)"(arg0: any, arg1: V): V;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        /**
         * @deprecated
        */
        "put(java.lang.Object,java.lang.Object)"(arg0: any, arg1: any): any;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Boolean2DoubleFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Boolean2FloatFunction;
        "remove(boolean)"(arg0: boolean): V;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Boolean2IntFunction;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: V): V;
        /**
         * @deprecated
        */
        "get(java.lang.Object)"(arg0: any): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        "put(java.lang.Boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Boolean2LongFunction;
        "containsKey(boolean)"(arg0: boolean): boolean;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, V>;
        apply(arg0: boolean): V;
        "getOrDefault(boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        abstract get(arg0: boolean): V;
        abstract "get(boolean)"(arg0: boolean): V;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Boolean2ByteFunction;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<boolean, V>;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2ObjectFunction<V>;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2ObjectFunction<V>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2ObjectFunction<V>;
        "put(boolean,java.lang.Object)"(arg0: boolean, arg1: V): V;
        containsKey(arg0: boolean): boolean;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Boolean2ReferenceFunction<T>;
        remove(arg0: boolean): V;
        size(): number;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2ObjectFunction<V>;
        clear(): void;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2ObjectFunction<V>;
        defaultReturnValue(): V;
        getOrDefault(arg0: boolean, arg1: V): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        /**
         * @deprecated
        */
        "remove(java.lang.Object)"(arg0: any): V;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Boolean2CharFunction;
        /**
         * @deprecated
        */
        "containsKey(java.lang.Object)"(arg0: any): boolean;
    }
    type Boolean2ObjectFunction_<V> = Boolean2ObjectFunction<V>;
    class ExperienceNuggetItem extends Internal.Item {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type ExperienceNuggetItem_ = ExperienceNuggetItem;
    class HoeItemBuilder extends Internal.HandheldItemBuilder {
        constructor(i: ResourceLocation_)
        static toToolTier(o: any): Internal.Tier;
        /**
         * Adds subtypes to the item. The function should return a collection of item stacks, each with a different subtype.
         * 
         * Each subtype will appear as a separate item in JEI and the creative inventory.
        */
        subtypes(fn: Internal.Function_<Internal.ItemStack, Internal.Collection<Internal.ItemStack>>): Internal.ItemBuilder;
        createAdditionalObjects(): void;
        /**
         * Gets called when the item is used to hurt an entity.
         * 
         * For example, when using a sword to hit a mob, this is called.
        */
        hurtEnemy(context: Internal.Predicate_<Internal.ItemBuilder$HurtEnemyContext>): Internal.ItemBuilder;
        getTranslationKeyGroup(): string;
        notify(): void;
        get(): Internal.Item;
        /**
         * Makes the item not stackable, equivalent to setting the item's max stack size to 1.
        */
        unstackable(): Internal.ItemBuilder;
        /**
         * Colorizes item's texture of the given index. Index is used when you have multiple layers, e.g. a crushed ore (of rock + ore).
        */
        color(index: number, color: Internal.ItemTintFunction_): Internal.ItemBuilder;
        /**
         * When players finish using the item.
         * 
         * This is called only when `useDuration` ticks have passed.
         * 
         * For example, when eating food, this is called when the player has finished eating the food, so hunger is restored.
        */
        finishUsing(finishUsing: Internal.ItemBuilder$FinishUsingCallback_): Internal.ItemBuilder;
        getRegistryType(): Internal.RegistryInfo<any>;
        /**
         * Modifies the tool tier.
        */
        modifyTier(callback: Internal.Consumer_<Internal.MutableToolTier>): Internal.HandheldItemBuilder;
        /**
         * Adds an attribute modifier to the item.
         * 
         * An attribute modifier is something like a damage boost or a speed boost.
         * On tools, they're applied when the item is held, on armor, they're
         * applied when the item is worn.
         * @param attribute The resource location of the attribute, e.g. 'generic.attack_damage'
         * @param identifier A unique identifier for the modifier. Modifiers are considered the same if they have the same identifier.
         * @param d The amount of the modifier.
         * @param operation The operation to apply the modifier with. Can be ADDITION, MULTIPLY_BASE, or MULTIPLY_TOTAL.
        */
        modifyAttribute(attribute: ResourceLocation_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): Internal.ItemBuilder;
        /**
         * Sets the item's model (parent).
        */
        parentModel(m: string): Internal.ItemBuilder;
        /**
         * Colorizes item's texture of the given index. Useful for coloring items, like GT ores ore dusts.
        */
        color(callback: Internal.ItemTintFunction_): Internal.ItemBuilder;
        /**
         * Sets the item's max stack size. Default is 64.
        */
        maxStackSize(v: number): Internal.ItemBuilder;
        /**
         * Adds a tooltip to the item.
        */
        tooltip(text: net.minecraft.network.chat.Component_): Internal.ItemBuilder;
        "transformObject(net.minecraft.world.item.Item)"(obj: Internal.Item_): Internal.Item;
        /**
         * Determines the width of the item's durability bar. Defaulted to vanilla behavior.
         * 
         * The function should return a value between 0 and 13 (max width of the bar).
        */
        barWidth(barWidth: Internal.ToIntFunction_<Internal.ItemStack>): Internal.ItemBuilder;
        /**
         * Combined method of formattedDisplayName().displayName(name).
        */
        formattedDisplayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the base attack speed of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of -2.4, while an axe has a baseline of -3.1.
         * 
         * The actual speed is the sum of the baseline and the speed from tier + 4 (bare hand).
        */
        speedBaseline(f: number): Internal.HandheldItemBuilder;
        /**
         * Sets the item's rarity.
        */
        rarity(v: Internal.Rarity_): Internal.ItemBuilder;
        /**
         * Makes the item fire resistant like netherite tools.
        */
        fireResistant(): Internal.ItemBuilder;
        /**
         * Sets the display name for this object, e.g. `Stone`.
         * 
         * This will be overridden by a lang file if it exists.
        */
        displayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.Item>;
        /**
         * Determines the animation of the item when used, e.g. eating food.
        */
        useAnimation(animation: Internal.UseAnim_): Internal.ItemBuilder;
        tier(t: Internal.Tier_): Internal.HandheldItemBuilder;
        getBuilderTranslationKey(): string;
        /**
         * Determines if player will start using the item.
         * 
         * For example, when eating food, returning true will make the player start eating the food.
        */
        use(use: Internal.ItemBuilder$UseCallback_): Internal.ItemBuilder;
        /**
         * When players did not finish using the item but released the right mouse button halfway through.
         * 
         * An example is the bow, where the arrow is shot when the player releases the right mouse button.
         * 
         * To ensure the bow won't finish using, Minecraft sets the `useDuration` to a very high number (1h).
        */
        releaseUsing(releaseUsing: Internal.ItemBuilder$ReleaseUsingCallback_): Internal.ItemBuilder;
        /**
         * Sets the item's container item, e.g. a bucket for a milk bucket.
        */
        containerItem(id: ResourceLocation_): Internal.ItemBuilder;
        wait(): void;
        /**
         * Sets the item's burn time. Default is 0 (Not a fuel).
        */
        burnTime(v: number): Internal.ItemBuilder;
        /**
         * Directlys set the item's texture json.
        */
        textureJson(json: Internal.JsonObject_): Internal.ItemBuilder;
        static toArmorMaterial(o: any): Internal.ArmorMaterial;
        generateLang(lang: Internal.LangEventJS_): void;
        /**
         * The duration when the item is used.
         * 
         * For example, when eating food, this is the time it takes to eat the food.
         * This can change the eating speed, or be used for other things (like making a custom bow).
        */
        useDuration(useDuration: Internal.ToIntFunction_<Internal.ItemStack>): Internal.ItemBuilder;
        /**
         * Sets the attack speed of the tool.
        */
        speed(f: number): Internal.HandheldItemBuilder;
        getClass(): typeof any;
        /**
         * Makes the item fire resistant like netherite tools (or not).
        */
        fireResistant(isFireResistant: boolean): Internal.ItemBuilder;
        /**
         * Sets the item's texture by given key.
        */
        texture(key: string, tex: string): Internal.ItemBuilder;
        /**
         * Sets the item's max damage. Default is 0 (No durability).
        */
        maxDamage(v: number): Internal.ItemBuilder;
        "transformObject(java.lang.Object)"(arg0: any): any;
        wait(arg0: number, arg1: number): void;
        /**
         * Sets the item's name dynamically.
        */
        name(name: Internal.ItemBuilder$NameCallback_): Internal.ItemBuilder;
        createItemProperties(): Internal.Item$Properties;
        generateDataJsons(generator: Internal.DataJsonGenerator_): void;
        createObject(): Internal.Item;
        /**
         * Sets the base attack damage of the tool. Different tools have different baselines.
         * 
         * For example, a sword has a baseline of 3, while an axe has a baseline of 6.
         * 
         * The actual damage is the sum of the baseline and the attackDamageBonus from tier.
        */
        attackDamageBaseline(f: number): Internal.HandheldItemBuilder;
        /**
         * Makes the item glow like enchanted, even if it's not enchanted.
        */
        glow(v: boolean): Internal.ItemBuilder;
        transformObject(arg0: any): any;
        /**
         * Directly set the item's model json.
        */
        modelJson(json: Internal.JsonObject_): Internal.ItemBuilder;
        toString(): string;
        /**
         * Set the food properties of the item.
        */
        food(b: Internal.Consumer_<Internal.FoodBuilder>): Internal.ItemBuilder;
        notifyAll(): void;
        /**
         * Makes displayName() override language files.
        */
        formattedDisplayName(): Internal.BuilderBase<Internal.Item>;
        hashCode(): number;
        /**
         * Sets the item's texture (layer0).
        */
        texture(tex: string): Internal.ItemBuilder;
        transformObject(obj: Internal.Item_): Internal.Item;
        wait(arg0: number): void;
        /**
         * Determines the color of the item's durability bar. Defaulted to vanilla behavior.
        */
        barColor(barColor: Internal.Function_<Internal.ItemStack, dev.latvian.mods.rhino.mod.util.color.Color>): Internal.ItemBuilder;
        /**
         * Adds a tag to this object, e.g. `minecraft:stone`.
        */
        tag(tag: ResourceLocation_): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the translation key for this object, e.g. `block.minecraft.stone`.
        */
        translationKey(key: string): Internal.BuilderBase<Internal.Item>;
        /**
         * Sets the attack damage bonus of the tool.
        */
        attackDamageBonus(f: number): Internal.HandheldItemBuilder;
        equals(arg0: any): boolean;
        newID(pre: string, post: string): ResourceLocation;
        /**
         * @deprecated
        */
        group(g: string): Internal.ItemBuilder;
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        get translationKeyGroup(): string
        get registryType(): Internal.RegistryInfo<any>
        get builderTranslationKey(): string
        get class(): typeof any
    }
    type HoeItemBuilder_ = HoeItemBuilder;
    class CustomTask extends Internal.Task {
        constructor(id: number, quest: Internal.Quest_)
        getRelativeProgressFromChildren(data: Internal.TeamData_): number;
        isCompletedRaw(data: Internal.TeamData_): boolean;
        submitTask(teamData: Internal.TeamData_, player: Internal.ServerPlayer_, craftedItem: Internal.ItemStack_): void;
        writeData(nbt: Internal.CompoundTag_): void;
        getMutableTitle(): Internal.MutableComponent;
        readData(nbt: Internal.CompoundTag_): void;
        getType(): Internal.TaskType;
        getMaxProgress(): number;
        editedFromGUI(): void;
        consumesResources(): boolean;
        formatMaxProgress(): string;
        getQuest(): Internal.Quest;
        notify(): void;
        compareTo(arg0: any): number;
        clearCachedData(): void;
        canInsertItem(): boolean;
        setCheckTimer(checkTimer: number): void;
        getRawTitle(): string;
        getProgressColor(data: Internal.TeamData_): Internal.Color4I;
        static isNull(object: Internal.QuestObjectBase_): boolean;
        hideProgressNumbers(): boolean;
        cacheProgress(): boolean;
        deleteSelf(): void;
        componentsToRefresh(): Internal.Set<Internal.RecipeModHelper$Components>;
        static getID(object: Internal.QuestObjectBase_): number;
        hasUnclaimedRewardsRaw(teamData: Internal.TeamData_, player: Internal.UUID_): boolean;
        isValid(): boolean;
        onCompleted(data: Internal.QuestProgressEventData_<any>): void;
        static parseCodeString(id: string): number;
        getButtonText(): Internal.MutableComponent;
        onButtonClicked(button: dev.ftb.mods.ftblibrary.ui.Button_, canClick: boolean): void;
        deleteChildren(): void;
        addTitleInMouseOverText(): boolean;
        static getRelativeProgressFromChildren(progressSum: number, count: number): number;
        getTags(): Internal.Set<string>;
        forceProgress(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        getChildren(): Internal.Collection<Internal.QuestObject>;
        static "getCodeString(dev.ftb.mods.ftbquests.quest.QuestObjectBase)"(object: Internal.QuestObjectBase_): string;
        autoSubmitOnPlayerTick(): number;
        wait(): void;
        isSearchable(data: Internal.TeamData_): boolean;
        setRawIcon(rawIcon: Internal.ItemStack_): void;
        getTitle(): net.minecraft.network.chat.Component;
        static shouldSendNotifications(): boolean;
        "compareTo(java.lang.Object)"(arg0: any): number;
        drawGUI(teamData: Internal.TeamData_, graphics: Internal.GuiGraphics_, x: number, y: number, w: number, h: number): void;
        getAltIcon(): Internal.Icon;
        static titleToID(s: string): Internal.Optional<string>;
        onEditButtonClicked(gui: Internal.Runnable_): void;
        getClass(): typeof any;
        getProgressColor(data: Internal.TeamData_, dim: boolean): Internal.Color4I;
        static getCodeString(object: Internal.QuestObjectBase_): string;
        static copy<T extends Internal.QuestObjectBase>(orig: T, factory: Internal.Supplier_<T>): T;
        getCodeString(): string;
        static getCodeString(id: number): string;
        setEnableButton(enableButton: boolean): void;
        createSubGroup(group: Internal.ConfigGroup_): Internal.ConfigGroup;
        isOptionalForProgression(): boolean;
        getParentID(): number;
        wait(arg0: number, arg1: number): void;
        fillConfigGroup(config: Internal.ConfigGroup_): void;
        getIcon(): Internal.Icon;
        addMouseOverText(list: Internal.TooltipList_, teamData: Internal.TeamData_): void;
        setMaxProgress(maxProgress: number): void;
        addMouseOverHeader(list: Internal.TooltipList_, teamData: Internal.TeamData_, advanced: boolean): void;
        getId(): number;
        getAltTitle(): net.minecraft.network.chat.Component;
        static "getCodeString(long)"(id: number): string;
        "compareTo(dev.ftb.mods.ftbquests.quest.QuestObjectBase)"(other: Internal.QuestObjectBase_): number;
        readNetData(buffer: Internal.FriendlyByteBuf_): void;
        hasTag(tag: string): boolean;
        compareTo(other: Internal.QuestObjectBase_): number;
        setRawTitle(rawTitle: string): void;
        toString(): string;
        onStarted(data: Internal.QuestProgressEventData_<any>): void;
        getIngredient(widget: Internal.Widget_): Internal.Optional<Internal.PositionedIngredient>;
        setCheck(check: Internal.CustomTask$Check_): void;
        getQuestChapter(): Internal.Chapter;
        notifyAll(): void;
        submitItemsOnInventoryChange(): boolean;
        getObjectType(): Internal.QuestObjectType;
        submitTask(teamData: Internal.TeamData_, player: Internal.ServerPlayer_): void;
        getQuestFile(): Internal.BaseQuestFile;
        forceProgressRaw(teamData: Internal.TeamData_, progressChange: Internal.ProgressChange_): void;
        static parseHexId(id: string): Internal.Optional<number>;
        hashCode(): number;
        checkOnLogin(): boolean;
        getPath(): Internal.Optional<string>;
        writeNetData(buffer: Internal.FriendlyByteBuf_): void;
        isVisible(data: Internal.TeamData_): boolean;
        editedFromGUIOnServer(): void;
        onCreated(): void;
        wait(arg0: number): void;
        formatProgress(teamData: Internal.TeamData_, progress: number): string;
        equals(object: any): boolean;
        get mutableTitle(): Internal.MutableComponent
        get type(): Internal.TaskType
        get maxProgress(): number
        get quest(): Internal.Quest
        set checkTimer(checkTimer: number)
        get rawTitle(): string
        get valid(): boolean
        get buttonText(): Internal.MutableComponent
        get tags(): Internal.Set<string>
        get children(): Internal.Collection<Internal.QuestObject>
        set rawIcon(rawIcon: Internal.ItemStack_)
        get title(): net.minecraft.network.chat.Component
        get altIcon(): Internal.Icon
        get class(): typeof any
        get codeString(): string
        set enableButton(enableButton: boolean)
        get optionalForProgression(): boolean
        get parentID(): number
        get icon(): Internal.Icon
        set maxProgress(maxProgress: number)
        get id(): number
        get altTitle(): net.minecraft.network.chat.Component
        set rawTitle(rawTitle: string)
        set check(check: Internal.CustomTask$Check_)
        get questChapter(): Internal.Chapter
        get objectType(): Internal.QuestObjectType
        get questFile(): Internal.BaseQuestFile
        get path(): Internal.Optional<string>
        static readonly PREDICATE: Internal.Predicate<Internal.QuestObjectBase>;
    }
    type CustomTask_ = CustomTask;
    class Liquidlogged extends Internal.Enum<Internal.Liquidlogged> implements Internal.StringRepresentable {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        getDeclaringClass(): typeof Internal.Liquidlogged;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        toString(): string;
        static values(): Internal.Liquidlogged[];
        getSerializedName(): string;
        notifyAll(): void;
        "compareTo(net.jadenxgamer.netherexp.registry.block.custom.enums.Liquidlogged)"(arg0: Internal.Liquidlogged_): number;
        static valueOf(arg0: string): Internal.Liquidlogged;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        hashCode(): number;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.Liquidlogged>>;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        compareTo(arg0: Internal.Liquidlogged_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.Liquidlogged
        get serializedName(): string
        static readonly AIR: (Internal.Liquidlogged) & (Internal.Liquidlogged);
        static readonly ECTOPLASM: (Internal.Liquidlogged) & (Internal.Liquidlogged);
        static readonly LAVA: (Internal.Liquidlogged) & (Internal.Liquidlogged);
        static readonly WATER: (Internal.Liquidlogged) & (Internal.Liquidlogged);
    }
    type Liquidlogged_ = Liquidlogged | "lava" | "ectoplasm" | "air" | "water";
    class SoulTorchflowerCropBlock extends Internal.TorchflowerCropBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        performBonemeal(arg0: Internal.ServerLevel_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): void;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        isMaxAge(arg0: Internal.BlockState_): boolean;
        getPlant(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        isBonemealSuccess(arg0: Internal.Level_, arg1: Internal.RandomSource_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        invokeMayPlaceOn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        getMaxAge(): number;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        isValidBonemealTarget(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): boolean;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        growCrops(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getAge(arg0: Internal.BlockState_): number;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getStateForAge(arg0: number): Internal.BlockState;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        handler$zij000$mayPlaceOn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CallbackInfoReturnable_<any>): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        get maxAge(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type SoulTorchflowerCropBlock_ = SoulTorchflowerCropBlock;
    class GoalSelectorDebugRenderer$DebugGoal {
        constructor(arg0: BlockPos_, arg1: number, arg2: string, arg3: boolean)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        readonly name: string;
        readonly priority: number;
        readonly isRunning: boolean;
        readonly pos: BlockPos;
    }
    type GoalSelectorDebugRenderer$DebugGoal_ = GoalSelectorDebugRenderer$DebugGoal;
    abstract class HangingEntity extends Internal.Entity implements Internal.DynamicLightSource {
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getBlockZ(): number;
        isSuppressingBounce(): boolean;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(id: Internal.SoundEvent_): void;
        getPitch(): number;
        isOnFire(): boolean;
        rotate(arg0: Internal.Rotation_): number;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPassengersAndSelf(): Internal.Stream<any>;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        gameEvent(arg0: Internal.GameEvent_): void;
        alwaysAccepts(): boolean;
        handler$daa000$thunderHit(pLevel: Internal.ServerLevel_, pLightning: Internal.LightningBolt_, ci: Internal.CallbackInfo_): void;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        handler$daa000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        isVisuallyCrawling(): boolean;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setMotionZ(z: number): void;
        abstract sdl$shouldUpdateDynamicLight(): boolean;
        handler$daa000$setSprinting(pSprinting: boolean, ci: Internal.CallbackInfo_): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        getBlockY(): number;
        isSpectator(): boolean;
        pehkui_setScaleCache(scaleCache: Internal.ScaleData_[]): void;
        isInWaterOrBubble(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getPortalCooldown(): number;
        getItem(): Internal.ItemStack;
        getRandomZ(arg0: number): number;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        pehkui_getOnGround(): boolean;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        getPosition(arg0: number): Vec3d;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        wait(arg0: number): void;
        isIgnoringBlockTriggers(): boolean;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        canUpdate(arg0: boolean): void;
        getEyeInFluidType(): Internal.FluidType;
        distanceToSqr(arg0: Vec3d_): number;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        handler$daa000$dampensVibrations(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSteppingCarefully(): boolean;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        getPos(): BlockPos;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        getBlockX(): number;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        handler$daa000$causeFallDamage(pFallDistance: number, pMultiplier: number, pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getEncodeId(): string;
        getY(arg0: number): number;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setInvisible(arg0: boolean): void;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        abstract dropItem(arg0: Internal.Entity_): void;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        handler$dlf002$onTick(ci: Internal.CallbackInfo_): void;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        handler$daa000$isFreezing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getYaw(): number;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        hasPermissions(arg0: number): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        pehkui_readScaleNbt(nbt: Internal.CompoundTag_): void;
        setCustomNameVisible(arg0: boolean): void;
        isAlliedTo(arg0: Internal.Team_): boolean;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        bo$refreshEntityData(data: number): void;
        getControllingPassenger(): Internal.LivingEntity;
        getRemainingFireTicks(): number;
        handler$daa000$onClientRemoval(ci: Internal.CallbackInfo_): void;
        getScriptType(): Internal.ScriptType;
        onlyOpCanSetNbt(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        serializeNBT(): Internal.Tag;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        fireImmune(): boolean;
        getMaxFallDistance(): number;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        pehkui_isFirstUpdate(): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        handler$daa000$canFreeze(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        getEyeY(): number;
        handler$daa000$playerTouch(pPlayer: Internal.Player_, ci: Internal.CallbackInfo_): void;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        handler$daa000$getMaxFallDistance(cir: Internal.CallbackInfoReturnable_<any>): void;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        localvar$dng000$fluidCollision(arg0: Vec3d_): Vec3d;
        isDescending(): boolean;
        setItemSlot(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): void;
        getYHeadRot(): number;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        abstract sodiumdynamiclights$updateDynamicLight(arg0: Internal.LevelRenderer_): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getEyeHeight(arg0: Internal.Pose_): number;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        handler$daa000$entityJs$tick(ci: Internal.CallbackInfo_): void;
        handler$daa001$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTeam(): Internal.Team;
        handler$daa000$stopRiding(ci: Internal.CallbackInfo_): void;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        setTicksFrozen(arg0: number): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        handler$bnk000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        abstract getWidth(): number;
        getMyRidingOffset(): number;
        canStartSwimming(): boolean;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        hasCustomName(): boolean;
        setFireType(arg0: ResourceLocation_): void;
        isLiving(): boolean;
        getX(): number;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        isVehicle(): boolean;
        getLeashOffset(): Vec3d;
        isAttackable(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        getSlot(arg0: number): Internal.SlotAccess;
        jerotes_$summon(arg0: Internal.VariantZsieinEntity_, arg1: Internal.ServerLevel_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        pehkui_constructScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getTeamId(): string;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        isUnderWater(): boolean;
        stopRiding(): void;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        getX(arg0: number): number;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        localvar$bjk000$apoth_checkFallDamageWithGravity(arg0: number): number;
        getDeltaMovement(): Vec3d;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        hasPassenger(arg0: Internal.Entity_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        abstract sdl$dynamicLightTick(): void;
        setSecondsOnFire(arg0: number): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        handleInsidePortal(arg0: BlockPos_): void;
        create$callSetLevel(arg0: Internal.Level_): void;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        handler$daa000$rideTick(ci: Internal.CallbackInfo_): void;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        isOnRails(): boolean;
        handler$daa000$canTrample(state: Internal.BlockState_, pos: BlockPos_, fallDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        restoreFrom(arg0: Internal.Entity_): void;
        getDimensionChangingDelay(): number;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        setPos(arg0: number, arg1: number, arg2: number): void;
        setYaw(arg0: number): void;
        getPickRadius(): number;
        notify(): void;
        getFirstTick(): boolean;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        getStringUuid(): string;
        isRemoved(): boolean;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        getRotationVector(): Internal.Vec2;
        refreshDimensions(): void;
        pehkui_writeScaleNbt(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        self(): Internal.Entity;
        abstract sdl$getDynamicLightY(): number;
        handler$daa000$isAttackable(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSprinting(): boolean;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        handler$daa000$canChangeDimensions(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionY(): number;
        canCollideWith(arg0: Internal.Entity_): boolean;
        setShiftKeyDown(arg0: boolean): void;
        getEyePosition(arg0: number): Vec3d;
        getPassengers(): Internal.EntityArrayList;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        getServer(): Internal.MinecraftServer;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        getFirstPassenger(): Internal.Entity;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        handler$daa000$getMyRidingOffset(cir: Internal.CallbackInfoReturnable_<any>): void;
        abstract sdl$getDynamicLightLevel(): Internal.Level;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        getSoundSource(): Internal.SoundSource;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getPose(): Internal.Pose;
        touchingUnloadedChunk(): boolean;
        abstract sdl$getDynamicLightZ(): number;
        getLookAngle(): Vec3d;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        handler$daa000$isPickable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionZ(): number;
        removeVehicle(): void;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        setZ(z: number): void;
        getY(): number;
        ejectPassengers(): void;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getProfile(): Internal.GameProfile;
        static setViewScale(arg0: number): void;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        handler$daa000$isInvulnerableTo(pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        handler$fdn000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        position(): Vec3d;
        biomancy$random(): Internal.RandomSource;
        handler$daa000$shouldRenderAtSqrDistance(pDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        displayFireAnimation(): boolean;
        turn(arg0: number, arg1: number): void;
        getAirSupply(): number;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isAnimal(): boolean;
        isPlayer(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        survives(): boolean;
        handler$daa000$move(pType: Internal.MoverType_, pPos: Vec3d_, ci: Internal.CallbackInfo_): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        setY(y: number): void;
        sdl$isDynamicLightEnabled(): boolean;
        getFeetBlockState(): Internal.BlockState;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        getCommandSenderWorld(): Internal.Level;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        setSharedFlag(arg0: number, arg1: boolean): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        pehkui_shouldIgnoreScaleNbt(): boolean;
        getMaxAirSupply(): number;
        isMoving(): boolean;
        isVisuallySwimming(): boolean;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        entityJs$getTypeId(): string;
        getFacing(): Internal.Direction;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        abstract getHeight(): number;
        abstract sdl$getDynamicLightX(): number;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        isSwimming(): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        setSprinting(arg0: boolean): void;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        setPortalCooldown(): void;
        setX(x: number): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        getPortalWaitTime(): number;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        getBlockStateOn(): Internal.BlockState;
        isInWater(): boolean;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        pehkui_getScaleCache(): Internal.ScaleData[];
        isInvisibleTo(arg0: Internal.Player_): boolean;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        getRootVehicle(): Internal.Entity;
        save(arg0: Internal.CompoundTag_): boolean;
        pehkui_getScales(): Internal.Map<any, any>;
        handler$daa000$onRemovedFromWorld(ci: Internal.CallbackInfo_): void;
        abstract sdl$getLuminance(): number;
        isNoGravity(): boolean;
        getStepHeight(): number;
        acceptsFailure(): boolean;
        pehkui_setShouldIgnoreScaleNbt(ignore: boolean): void;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        setOldPosAndRot(): void;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        updateSwimming(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        wait(): void;
        getUuid(): Internal.UUID;
        spawn(): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        shouldShowName(): boolean;
        getFireType(): ResourceLocation;
        handler$daa000$lerpTo(x: number, y: number, z: number, yaw: number, pitch: number, posRotationIncrements: number, teleport: boolean, ci: Internal.CallbackInfo_): void;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        kill(): void;
        handler$daa000$onAddedToWorld(ci: Internal.CallbackInfo_): void;
        handler$cln000$setRemoved(arg0: Internal.Entity$RemovalReason_, arg1: Internal.CallbackInfo_): void;
        isOnPortalCooldown(): boolean;
        animateHurt(arg0: number): void;
        handler$daa000$lavaHurt(ci: Internal.CallbackInfo_): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        getParts(): Internal.PartEntity<any>[];
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        deserializeNBT(arg0: Internal.Tag_): void;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        revive(): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getBbWidth(): number;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        getForgePersistentData(): Internal.CompoundTag;
        addDeltaMovement(arg0: Vec3d_): void;
        pehkui_setOnGround(onGround: boolean): void;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        "getName()"(): net.minecraft.network.chat.Component;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        getTicksRequiredToFreeze(): number;
        /**
         * @deprecated
        */
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        isAlive(): boolean;
        getBbHeight(): number;
        handler$daa000$push(pEntity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        getUsername(): string;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        getTags(): Internal.Set<string>;
        getViewVector(arg0: number): Vec3d;
        onRemovedFromWorld(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getPercentFrozen(): number;
        getPickResult(): Internal.ItemStack;
        getRandomY(): number;
        setPortalCooldown(arg0: number): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        shouldBeSaved(): boolean;
        handler$daa000$canCollideWith(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        canRiderInteract(): boolean;
        getViewXRot(arg0: number): number;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        setPose(arg0: Internal.Pose_): void;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        pehkui_getScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        notifyAll(): void;
        getPassengersRidingOffset(): number;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        "getServer()"(): Internal.MinecraftServer;
        isFrame(): boolean;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        discard(): void;
        onClientRemoval(): void;
        handler$daa000$showVehicleHealth(cir: Internal.CallbackInfoReturnable_<any>): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        setNoGravity(arg0: boolean): void;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        handler$daa000$isCurrentlyGlowing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        setRotation(yaw: number, pitch: number): void;
        createCommandSourceStack(): Internal.CommandSourceStack;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        pehkui_setShouldSyncScales(sync: boolean): void;
        abstract sdl$resetDynamicLight(): void;
        getHorizontalFacing(): Internal.Direction;
        setId(arg0: number): void;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        handler$dlf000$onRemove(ci: Internal.CallbackInfo_): void;
        getLightProbePosition(arg0: number): Vec3d;
        abstract sodiumdynamiclights$scheduleTrackedChunksRebuild(arg0: Internal.LevelRenderer_): void;
        onAboveBubbleCol(arg0: boolean): void;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        pehkui_shouldSyncScales(): boolean;
        checkDespawn(): void;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        handler$daa000$onInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        static getViewScale(): number;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        getVisualRotationYInDegrees(): number;
        abstract playPlacementSound(): void;
        wait(arg0: number, arg1: number): void;
        isDiscrete(): boolean;
        getTeamColor(): number;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        extinguish(): void;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        handler$daa000$mayInteract(pLevel: Internal.Level_, pPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        isFullyFrozen(): boolean;
        runCommand(command: string): number;
        setSharedFlagOnFire(arg0: boolean): void;
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get blockZ(): number
        get suppressingBounce(): boolean
        get silent(): boolean
        get pitch(): number
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get passengersAndSelf(): Internal.Stream<any>
        set maxUpStep(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        get visuallyCrawling(): boolean
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        get inWaterOrBubble(): boolean
        get persistentData(): Internal.CompoundTag
        get portalCooldown(): number
        get item(): Internal.ItemStack
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        get ignoringBlockTriggers(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        get pos(): BlockPos
        get blockX(): number
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get encodeId(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get eyePosition(): Vec3d
        get eyeHeight(): number
        get yaw(): number
        set customNameVisible(arg0: boolean)
        get controllingPassenger(): Internal.LivingEntity
        get remainingFireTicks(): number
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        get maxFallDistance(): number
        get id(): number
        get ticksFrozen(): number
        get eyeY(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get descending(): boolean
        get YHeadRot(): number
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get width(): number
        get myRidingOffset(): number
        set deltaMovement(arg0: Vec3d_)
        set fireType(arg0: ResourceLocation_)
        get living(): boolean
        get x(): number
        get glowing(): boolean
        get vehicle(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        get underWater(): boolean
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get onRails(): boolean
        get dimensionChangingDelay(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        set yaw(arg0: number)
        get pickRadius(): number
        get firstTick(): boolean
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        get stringUuid(): string
        get removed(): boolean
        set swimming(arg0: boolean)
        get rotationVector(): Internal.Vec2
        get sprinting(): boolean
        get motionY(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get addedToWorld(): boolean
        get firstPassenger(): Internal.Entity
        get soundSource(): Internal.SoundSource
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get pose(): Internal.Pose
        get lookAngle(): Vec3d
        get motionZ(): number
        get invisible(): boolean
        set z(z: number)
        get y(): number
        get profile(): Internal.GameProfile
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get airSupply(): number
        get crouching(): boolean
        get animal(): boolean
        get player(): boolean
        get motionDirection(): Internal.Direction
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get maxAirSupply(): number
        get moving(): boolean
        get visuallySwimming(): boolean
        get facing(): Internal.Direction
        get height(): number
        get swimming(): boolean
        get boundingBoxForCulling(): Internal.AABB
        set sprinting(arg0: boolean)
        set x(x: number)
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get portalWaitTime(): number
        get blockStateOn(): Internal.BlockState
        get inWater(): boolean
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        get stepHeight(): number
        set remainingFireTicks(arg0: number)
        get cachedFeetBlockState(): Internal.BlockState
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        get uuid(): Internal.UUID
        get fireType(): ResourceLocation
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        set silent(arg0: boolean)
        get onPortalCooldown(): boolean
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get alwaysTicking(): boolean
        get bbWidth(): number
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get "name()"(): net.minecraft.network.chat.Component
        get inFluidType(): boolean
        get ticksRequiredToFreeze(): number
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get username(): string
        get tags(): Internal.Set<string>
        get pickable(): boolean
        set YHeadRot(arg0: number)
        get percentFrozen(): number
        get pickResult(): Internal.ItemStack
        get randomY(): number
        set portalCooldown(arg0: number)
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set pose(arg0: Internal.Pose_)
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        get passengersRidingOffset(): number
        get "server()"(): Internal.MinecraftServer
        get frame(): boolean
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set noGravity(arg0: boolean)
        get indirectPassengers(): Internal.Iterable<any>
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get passenger(): boolean
        get viewScale(): number
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get visualRotationYInDegrees(): number
        get discrete(): boolean
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get freezing(): boolean
        get fullyFrozen(): boolean
        set sharedFlagOnFire(arg0: boolean)
    }
    type HangingEntity_ = HangingEntity;
    class Statue_Block extends Internal.BaseEntityBlock {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
        static readonly HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    }
    type Statue_Block_ = Statue_Block;
    class BundleDelimiterPacket <T extends Internal.PacketListener> implements Internal.Packet<T> {
        constructor()
        getClass(): typeof any;
        write(arg0: Internal.FriendlyByteBuf_): void;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        isSkippable(): boolean;
        wait(arg0: number, arg1: number): void;
        handle(arg0: T): void;
        get class(): typeof any
        get skippable(): boolean
    }
    type BundleDelimiterPacket_<T extends Internal.PacketListener> = BundleDelimiterPacket<T>;
    class ModularBladedItem extends Internal.ItemModularHandheld {
        constructor()
        getRepairRequiredTools(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): Internal.Collection<Internal.ToolAction>;
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getHoningLimit(arg0: Internal.ItemStack_): number;
        getAttributeModifiersCached(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        static "updateIdentifier(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        isFireResistant(): boolean;
        canGainHoneProgress(arg0: Internal.ItemStack_): boolean;
        getMajorModules(arg0: Internal.ItemStack_): Internal.ItemModuleMajor[];
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        hasModule(arg0: Internal.ItemStack_, arg1: Internal.ItemModule_): boolean;
        getToolLevel(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getImprovements(arg0: Internal.ItemStack_): Internal.ImprovementData[];
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getHonedCount(arg0: Internal.ItemStack_): number;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        static isHoneable(arg0: Internal.ItemStack_): boolean;
        hasModuleSynergy(arg0: Internal.ItemStack_, arg1: Internal.SynergyData_, arg2: Internal.ItemModule_[]): boolean;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        setHoningProgress(arg0: Internal.ItemStack_, arg1: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getRepairCycle(arg0: Internal.ItemStack_): Internal.ItemModule[];
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getHarvestTier(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        getDisplayNamePrefixes(arg0: Internal.ItemStack_): string;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        getHoneIntegrityMultiplier(arg0: Internal.ItemStack_): number;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        hitEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number): Internal.AbilityUseResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        causeRiptideEffect(arg0: Internal.Player_, arg1: number): void;
        static updateIdentifier(arg0: Internal.CompoundTag_): void;
        getMinorModules(arg0: Internal.ItemStack_): Internal.ItemModule[];
        getTooltip(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        getImprovementTooltip(arg0: string, arg1: number, arg2: boolean): string;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        getEnchantability(arg0: Internal.ItemStack_): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getToolDataCache(): Internal.Cache<string, Internal.ToolData>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getAttributeModifierCache(): Internal.Cache<string, Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getAllModules(arg0: Internal.ItemStack_): Internal.Collection<Internal.ItemModule>;
        getEffects(arg0: Internal.ItemStack_): Internal.Collection<ItemEffect>;
        static canDenail(arg0: Internal.BlockState_): boolean;
        getTransformVariant(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): string;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        applyPositiveUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        onActionConsume(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Player_, arg3: Internal.ToolAction_, arg4: number, arg5: boolean): Internal.ItemStack;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        canProvideTools(arg0: Internal.ItemStack_): boolean;
        getAbilityBaseDamage(arg0: Internal.ItemStack_): number;
        setAttackSpeed(attackSpeed: number): void;
        jabEntity(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Player_, arg3: Internal.LivingEntity_): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isThrowing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        applyDestabilizationEffects(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: number): void;
        onPlayerStoppedUsingSecondary(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        getMinorModuleNames(arg0: Internal.ItemStack_): string[];
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getRequiredModules(arg0: Internal.ItemStack_): string[];
        getBlockProgress(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): number;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        throwItem(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: number, arg3: number): void;
        getHoningIntegrityPenalty(arg0: Internal.ItemStack_): number;
        commonInit(arg0: Internal.PacketHandler_): void;
        static handleSecondaryAbility(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.LivingEntity_): void;
        isBroken(arg0: Internal.ItemStack_): boolean;
        getNumMinorModules(arg0: Internal.ItemStack_): number;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        assemble(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        getAttributeModifiers(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getEffectDataCached(arg0: Internal.ItemStack_): Internal.EffectData;
        getRepairModuleName(arg0: Internal.ItemStack_): string;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        getRepairSlot(arg0: Internal.ItemStack_): string;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        isBlocking(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getTags(arg0: Internal.ItemStack_): Internal.Set<Internal.TagKey<Internal.Item>>;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        updateConfig(arg0: number, arg1: number): void;
        getNumMajorModules(arg0: Internal.ItemStack_): number;
        tweak(arg0: Internal.ItemStack_, arg1: string, arg2: Internal.Map_<string, number>): void;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getEffectLevel(arg0: Internal.ItemStack_, arg1: ItemEffect_): number;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        denailBlock(arg0: Internal.Player_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.InteractionHand_, arg4: Internal.Direction_): boolean;
        static removeHoneable(arg0: Internal.ItemStack_): void;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        incrementRepairCount(arg0: Internal.ItemStack_): void;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getModuleAttributes(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEffectData(arg0: Internal.ItemStack_): Internal.EffectData;
        getToolLevels(arg0: Internal.ItemStack_): Internal.Map<Internal.ToolAction, number>;
        getRepairRequiredToolLevel(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.ToolAction_): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        getToolEfficiency(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        clearCaches(): void;
        static handleChargedAbility(arg0: Internal.Player_, arg1: Internal.InteractionHand_, arg2: Internal.LivingEntity_, arg3: BlockPos_, arg4: Vec3d_, arg5: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        getHoneBase(arg0: Internal.ItemStack_): number;
        static getIntegrityGain(arg0: Internal.ItemStack_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        getHoningProgress(arg0: Internal.ItemStack_): number;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static getCounterWeightBonus(arg0: number, arg1: number): number;
        static putModuleInSlot(arg0: Internal.ItemStack_, arg1: string, arg2: string, arg3: string, arg4: string): void;
        onShieldDisabled(arg0: Internal.Player_, arg1: Internal.ItemStack_): void;
        equals(arg0: any): boolean;
        getEntityHitDamage(): number;
        getRepairCount(arg0: Internal.ItemStack_): number;
        applyNegativeUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        setRarity(arg0: Internal.Rarity_): void;
        getRepairDefinitions(arg0: Internal.ItemStack_): Internal.Collection<Internal.RepairDefinition>;
        getProperties(arg0: Internal.ItemStack_): Internal.ItemProperties;
        getPropertyCache(): Internal.Cache<string, Internal.ItemProperties>;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        getToolData(arg0: Internal.ItemStack_): Internal.ToolData;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isComplex(): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        getModuleFromSlot(arg0: Internal.ItemStack_, arg1: string): Internal.ItemModule;
        getRepairAmount(arg0: Internal.ItemStack_): number;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        static "updateIdentifier(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): void;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        static getAbilities_$md$c625c2$0(): Internal.ChargedAbilityEffect[];
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        getModelCacheKey(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): string;
        getCooldownBase(arg0: Internal.ItemStack_): number;
        static setAbilities(arg0: Internal.ChargedAbilityEffect_[]): void;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        static getEfficiencyEnchantmentBonus(arg0: number): number;
        getRepairRequiredExperience(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): number;
        applyUsageEffects(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        static getAbilities(): Internal.ChargedAbilityEffect[];
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        repair(arg0: Internal.ItemStack_): void;
        getBlockDestroyDamage(): number;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        static putModuleInSlot(arg0: Internal.ItemStack_, arg1: string, arg2: string, arg3: string): void;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        static getImprovementDescription(arg0: string): string;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getEffectAttributes(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getRepairModule(arg0: Internal.ItemStack_): Internal.Optional<Internal.ItemModule>;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getItemName(arg0: Internal.ItemStack_): string;
        getDefaultStack(): Internal.ItemStack;
        getEffectEfficiency(arg0: Internal.ItemStack_, arg1: ItemEffect_): number;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        getSynergyData(arg0: Internal.ItemStack_): Internal.SynergyData[];
        getMajorGuiOffsets(arg0: Internal.ItemStack_): Internal.GuiModuleOffsets;
        getTools(arg0: Internal.ItemStack_): Internal.Set<Internal.ToolAction>;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getMinorGuiOffsets(arg0: Internal.ItemStack_): Internal.GuiModuleOffsets;
        setAttackDamage(attackDamage: number): void;
        triggerChargedAbility(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getMinorModuleKeys(arg0: Internal.ItemStack_): string[];
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        itemInteractionForEntitySecondary(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): boolean;
        getId(): string;
        getRepairRequiredToolLevels(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): Internal.Map<Internal.ToolAction, number>;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getModels(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.ImmutableList<Internal.ModuleModel>;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        applyBlockBreakEffects(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): void;
        tickProgression(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        onCraftConsume(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Player_, arg3: Internal.ToolAction_, arg4: number, arg5: boolean): Internal.ItemStack;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        static getImprovementName(arg0: string, arg1: number): string;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isModuleRequired(arg0: Internal.ItemStack_, arg1: string): boolean;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        hasImprovementSynergy(arg0: Internal.SynergyData_, arg1: string[]): boolean;
        getChargeableAbility(arg0: Internal.ItemStack_): Internal.ChargedAbilityEffect;
        clientInit(): void;
        getAttributeValue(arg0: Internal.ItemStack_, arg1: Internal.Attribute_, arg2: number): number;
        getEffectDataCache(): Internal.Cache<string, Internal.EffectData>;
        notify(): void;
        getMajorModuleNames(arg0: Internal.ItemStack_): string[];
        dowseBlock(arg0: Internal.Player_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_): boolean;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        "getItem()"(): Internal.Item;
        bashEntity(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.Player_, arg3: Internal.LivingEntity_): void;
        hitEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: number, arg4: number, arg5: number, arg6: number): Internal.AbilityUseResult;
        static createItemStack(arg0: string, arg1: string, arg2: string): Internal.ItemStack;
        getMajorModuleKeys(arg0: Internal.ItemStack_): string[];
        hasVariantSynergy(arg0: Internal.SynergyData_, arg1: string[]): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        getReducedDamage(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        fixIdentifiers(arg0: Internal.Multimap_<Internal.Attribute, Internal.AttributeModifier>): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static getHoningSeed(arg0: Internal.ItemStack_): number;
        isShield(arg0: Internal.ItemStack_): boolean;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        acceptsEnchantment(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_, arg2: boolean): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        applyDamage(arg0: number, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        isBroken(arg0: number, arg1: number): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getRepairMaterialCount(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): number;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        static getIntegrityCost(arg0: Internal.ItemStack_): number;
        static removeAllEnchantments(arg0: Internal.ItemStack_): Internal.ItemStack;
        tickHoningProgression(arg0: Internal.LivingEntity_, arg1: Internal.ItemStack_, arg2: number): void;
        wait(arg0: number, arg1: number): void;
        getToolActions(arg0: Internal.ItemStack_): Internal.Set<Internal.ToolAction>;
        getIdentifier(arg0: Internal.ItemStack_): string;
        static updateIdentifier(arg0: Internal.ItemStack_): void;
        getAttributeValue(arg0: Internal.ItemStack_, arg1: Internal.Attribute_): number;
        getAttributeModifiersCollapsed(arg0: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        getStabilityModifier(arg0: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        static getAttackSpeedHarvestModifier(arg0: number): number;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        static setAbilities_$md$c625c2$1(arg0: Internal.ChargedAbilityEffect_[]): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        static getCreativeTabItemStacks(): Internal.Collection<Internal.ItemStack>;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        getCounterWeightBonus(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getDataCacheKey(arg0: Internal.ItemStack_): string;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        getAllSynergyData(arg0: Internal.ItemStack_): Internal.SynergyData[];
        getPropertiesCached(arg0: Internal.ItemStack_): Internal.ItemProperties;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        get toolDataCache(): Internal.Cache<string, Internal.ToolData>
        get attributeModifierCache(): Internal.Cache<string, Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        get entityHitDamage(): number
        set rarity(arg0: Internal.Rarity_)
        get propertyCache(): Internal.Cache<string, Internal.ItemProperties>
        get complex(): boolean
        get descriptionId(): string
        get abilities_$md$c625c2$0(): Internal.ChargedAbilityEffect[]
        get creativeTab(): string
        set abilities(arg0: Internal.ChargedAbilityEffect_[])
        get abilities(): Internal.ChargedAbilityEffect[]
        get blockDestroyDamage(): number
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get defaultStack(): Internal.ItemStack
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get effectDataCache(): Internal.Cache<string, Internal.EffectData>
        get "item()"(): Internal.Item
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get mod(): string
        set armorProtection(armorProtection: number)
        set abilities_$md$c625c2$1(arg0: Internal.ChargedAbilityEffect_[])
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        get creativeTabItemStacks(): Internal.Collection<Internal.ItemStack>
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static readonly guardKey: ("sword/guard") & (string);
        static readonly hiltKey: ("sword/hilt") & (string);
        static readonly identifier: ("modular_sword") & (string);
        static readonly fullerKey: ("sword/fuller") & (string);
        static instance: (Internal.ModularBladedItem) & (Internal.ModularBladedItem);
        static readonly bladeKey: ("sword/blade") & (string);
        static readonly pommelKey: ("sword/pommel") & (string);
    }
    type ModularBladedItem_ = ModularBladedItem;
    class ItemFishedEvent extends Internal.PlayerEvent {
        constructor()
        constructor(arg0: Internal.List_<Internal.ItemStack>, arg1: number, arg2: Internal.FishingHook_)
        getResult(): Internal.Event$Result;
        setCanceled(arg0: boolean): void;
        getClass(): typeof any;
        toString(): string;
        setPhase(arg0: Internal.EventPriority_): void;
        getEntity(): Internal.LivingEntity;
        notifyAll(): void;
        isCanceled(): boolean;
        notify(): void;
        getDrops(): Internal.NonNullList<Internal.ItemStack>;
        wait(arg0: number, arg1: number): void;
        hasResult(): boolean;
        setResult(arg0: Internal.Event$Result_): void;
        getHookEntity(): Internal.FishingHook;
        damageRodBy(arg0: number): void;
        hashCode(): number;
        isCancelable(): boolean;
        wait(): void;
        getListenerList(): Internal.ListenerList;
        wait(arg0: number): void;
        getPhase(): Internal.EventPriority;
        getRodDamage(): number;
        equals(arg0: any): boolean;
        get result(): Internal.Event$Result
        set canceled(arg0: boolean)
        get class(): typeof any
        set phase(arg0: Internal.EventPriority_)
        get entity(): Internal.LivingEntity
        get canceled(): boolean
        get drops(): Internal.NonNullList<Internal.ItemStack>
        set result(arg0: Internal.Event$Result_)
        get hookEntity(): Internal.FishingHook
        get cancelable(): boolean
        get listenerList(): Internal.ListenerList
        get phase(): Internal.EventPriority
        get rodDamage(): number
    }
    type ItemFishedEvent_ = ItemFishedEvent;
    class JerotesVillageBlocks$FlavorlessMelonBlock extends Internal.StemGrownBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        getAttachedStem(): Internal.AttachedStemBlock;
        getStem(): Internal.StemBlock;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        getPlant(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.BlockState;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        get attachedStem(): Internal.AttachedStemBlock
        get stem(): Internal.StemBlock
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type JerotesVillageBlocks$FlavorlessMelonBlock_ = JerotesVillageBlocks$FlavorlessMelonBlock;
    interface IChunkTimeSave {
        abstract smoothchunk$setSaveTimePoint(arg0: number): void;
        abstract smoothchunk$getNextSaveTime(): number;
    }
    type IChunkTimeSave_ = IChunkTimeSave;
    class AbacusItem extends Internal.ZetaItem {
        constructor(arg0: Internal.ZetaModule_)
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        shouldCauseReequipAnimationZeta(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        isFireResistant(): boolean;
        getModule(): Internal.ZetaModule;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        doesConditionApply(): boolean;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        asItem(): Internal.Item;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getItem(): Internal.Item;
        getBarColor(arg0: Internal.ItemStack_): number;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        static getBlockPos(arg0: Internal.ItemStack_): BlockPos;
        setCreativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>): Internal.Item;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getEnchantmentLevelZeta(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        damageItem(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.LivingEntity_, arg3: Internal.Consumer_<any>): number;
        wait(arg0: number): void;
        doesSneakBypassUseZeta(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        getMaxDamageZeta(arg0: Internal.ItemStack_): number;
        setAttackSpeed(attackSpeed: number): void;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        static isEnabled(arg0: Internal.Block_): boolean;
        static "isEnabled(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getAllEnchantmentsZeta(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        isEnderMaskZeta(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        static setBlockPos(arg0: Internal.ItemStack_, arg1: BlockPos_): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        setNameKey(arg0: string): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getBurnTimeZeta(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        static "isEnabled(net.minecraft.world.item.Item)"(arg0: Internal.Item_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        isRepairableZeta(arg0: Internal.ItemStack_): boolean;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isBookEnchantableZeta(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        onItemUseFirstZeta(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        static getCount(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Level_): number;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        canApplyAtEnchantingTableZeta(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        setCondition(arg0: Internal.BooleanSupplier_): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        damageItemZeta<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        canShearZeta(arg0: Internal.ItemStack_): boolean;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        static isEnabled(arg0: Internal.Item_): boolean;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        getArmorTextureZeta(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        "getItem()"(): Internal.Item;
        canElytraFlyZeta(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        onEntityItemUpdateZeta(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        "isEnabled(net.minecraft.world.flag.FeatureFlagSet)"(arg0: Internal.FeatureFlagSet_): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<any, any>;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        isEnabled(): boolean;
        canEquipZeta(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        getMod(): string;
        setCreativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>, arg1: Internal.ItemLike_, arg2: boolean): Internal.Item;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getEnchantmentValueZeta(arg0: Internal.ItemStack_): number;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        getDefaultTooltipHideFlagsZeta(arg0: Internal.ItemStack_): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        get module(): Internal.ZetaModule
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderPropertiesInternal(): any
        set creativeTab(arg0: Internal.ResourceKey_<Internal.CreativeModeTab>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        get edible(): boolean
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set rarity(arg0: Internal.Rarity_)
        get complex(): boolean
        get descriptionId(): string
        get creativeTab(): string
        set burnTime(i: number)
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        set condition(arg0: Internal.BooleanSupplier_)
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set attackDamage(attackDamage: number)
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get "item()"(): Internal.Item
        /**
         * @deprecated
        */
        get maxStackSize(): number
        get eatingSound(): Internal.SoundEvent
        get enabled(): boolean
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static readonly TAG_POS_X: ("boundPosX") & (string);
        static readonly TAG_POS_Y: ("boundPosY") & (string);
        static readonly TAG_POS_Z: ("boundPosZ") & (string);
        static MAX_COUNT: (48) & (number);
    }
    type AbacusItem_ = AbacusItem;
    class EssenceAnemiaEffect extends Internal.StatusEffect {
        constructor(arg0: Internal.MobEffectCategory_, arg1: number)
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        addModifier<E extends Internal.StatusEffect>(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): E;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type EssenceAnemiaEffect_ = EssenceAnemiaEffect;
    interface XplatModContainer {
        abstract getPath(arg0: string): Internal.Path;
        abstract getName(): string;
        abstract getRootPaths(): Internal.List<Internal.Path>;
        abstract getId(): string;
        get name(): string
        get rootPaths(): Internal.List<Internal.Path>
        get id(): string
    }
    type XplatModContainer_ = XplatModContainer;
    class GiftLootEventJS extends Internal.LootEventJS {
        constructor(c: Internal.Map_<ResourceLocation, Internal.JsonElement>)
        removeAll(): void;
        getClass(): typeof any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        modify(id: ResourceLocation_, b: Internal.Consumer_<Internal.LootBuilder>): void;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        toString(): string;
        notifyAll(): void;
        addGift(id: ResourceLocation_, b: Internal.Consumer_<Internal.LootBuilder>): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        hashCode(): number;
        addJson(id: ResourceLocation_, json: Internal.JsonObject_): void;
        wait(): void;
        getType(): string;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        wait(arg0: number): void;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
        equals(arg0: any): boolean;
        getDirectory(): string;
        get class(): typeof any
        get type(): string
        get directory(): string
    }
    type GiftLootEventJS_ = GiftLootEventJS;
    interface SignedMessageChain$Decoder {
        unsigned(arg0: Internal.UUID_): this;
        abstract unpack(arg0: Internal.MessageSignature_, arg1: Internal.SignedMessageBody_): Internal.PlayerChatMessage;
        (arg0: Internal.MessageSignature, arg1: Internal.SignedMessageBody): Internal.PlayerChatMessage_;
        readonly REJECT_ALL: Internal.SignedMessageChain$Decoder;
    }
    type SignedMessageChain$Decoder_ = ((arg0: Internal.MessageSignature, arg1: Internal.SignedMessageBody)=> Internal.PlayerChatMessage_) | SignedMessageChain$Decoder;
    class RottenFishItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type RottenFishItem_ = RottenFishItem;
    class ServerEventJS extends Internal.EventJS {
        constructor(s: Internal.MinecraftServer_)
        getClass(): typeof any;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(): any;
        /**
         * Cancels the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(value: any): any;
        toString(): string;
        notifyAll(): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `exit` denotes a `default` outcome.
        */
        exit(value: any): any;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        /**
         * Stops the event with the given exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(value: any): any;
        hashCode(): number;
        wait(): void;
        /**
         * Cancels the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `cancel` denotes a `false` outcome.
        */
        cancel(): any;
        wait(arg0: number): void;
        /**
         * Stops the event with default exit value. Execution will be stopped **immediately**.
         * 
         * `success` denotes a `true` outcome.
        */
        success(): any;
        equals(arg0: any): boolean;
        getServer(): Internal.MinecraftServer;
        get class(): typeof any
        get server(): Internal.MinecraftServer
        readonly server: Internal.MinecraftServer;
    }
    type ServerEventJS_ = ServerEventJS;
    class PotatoCannonItem extends Internal.ProjectileWeaponItem implements Internal.CustomArmPoseItem {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        getArmPose(arg0: Internal.ItemStack_, arg1: Internal.AbstractClientPlayer_, arg2: Internal.InteractionHand_): Internal.HumanoidModel$ArmPose;
        setProjectileDamage(value: number): void;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        setCustomLaunchVelocity(value: number): void;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        getAllSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        static getHeldProjectile(arg0: Internal.LivingEntity_, arg1: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        /**
         * @deprecated
        */
        setMaxProjectileVelocity(value: number): void;
        getSupportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        setRangedWeaponKind(kind: Internal.RangedWeaponKind_): void;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getRangeWeaponKind(): Internal.RangedWeaponKind;
        /**
         * @deprecated
        */
        getMaxProjectileVelocity(): number;
        getDefaultProjectileRange(): number;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        isCannon(arg0: Internal.ItemStack_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        static getAmmoforPreview(arg0: Internal.ItemStack_): Internal.Optional<Internal.ItemStack>;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        getCustomLaunchVelocity(): number;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        setProjectileDamage(value: number, mainHand: boolean, offHand: boolean): void;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        getDefaultAttributeModifiers(slot: EquipmentSlot_): Internal.Multimap<any, any>;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getProjectileDamage(): number;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        set projectileDamage(value: number)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        set customLaunchVelocity(value: number)
        get allSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        /**
         * @deprecated
        */
        set maxProjectileVelocity(value: number)
        get supportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>
        set rangedWeaponKind(kind: Internal.RangedWeaponKind_)
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        get rangeWeaponKind(): Internal.RangedWeaponKind
        /**
         * @deprecated
        */
        get maxProjectileVelocity(): number
        get defaultProjectileRange(): number
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        get customLaunchVelocity(): number
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        get projectileDamage(): number
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
        static readonly MAX_DAMAGE: (100) & (number);
        static CLIENT_CURRENT_AMMO: (Internal.ItemStack) & (Internal.ItemStack);
    }
    type PotatoCannonItem_ = PotatoCannonItem;
    interface ILootAction extends Internal.ILootHandler {
        abstract applyLootHandler(arg0: Internal.LootContext_, arg1: Internal.List_<Internal.ItemStack>): boolean;
        (arg0: Internal.LootContext, arg1: Internal.List<Internal.ItemStack>): boolean;
    }
    type ILootAction_ = ILootAction | ((arg0: Internal.LootContext, arg1: Internal.List<Internal.ItemStack>)=> boolean);
    class LightningItemItem extends Internal.Item {
        constructor()
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type LightningItemItem_ = LightningItemItem;
    class FishingHook extends Internal.Projectile {
        constructor(arg0: Internal.Player_, arg1: Internal.Level_, arg2: number, arg3: number)
        constructor(arg0: Internal.EntityType_<Internal.FishingHook>, arg1: Internal.Level_)
        isInWall(): boolean;
        getAllSlots(): Internal.Iterable<Internal.ItemStack>;
        getUpVector(arg0: number): Vec3d;
        gameEvent(arg0: Internal.GameEvent_, arg1: Internal.Entity_): void;
        remove(arg0: Internal.Entity$RemovalReason_): void;
        getBlockZ(): number;
        isSuppressingBounce(): boolean;
        dampensVibrations(): boolean;
        isSilent(): boolean;
        "playSound(net.minecraft.sounds.SoundEvent)"(id: Internal.SoundEvent_): void;
        getPitch(): number;
        isOnFire(): boolean;
        rotate(arg0: Internal.Rotation_): number;
        getPositionCodec(): Internal.VecDeltaCodec;
        getPassengersAndSelf(): Internal.Stream<any>;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        setMaxUpStep(arg0: number): void;
        /**
         * @deprecated
        */
        updateFluidHeightAndDoFluidPushing(arg0: Internal.TagKey_<Internal.Fluid>, arg1: number): boolean;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        chunkPosition(): Internal.ChunkPos;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        gameEvent(arg0: Internal.GameEvent_): void;
        alwaysAccepts(): boolean;
        handler$daa000$thunderHit(pLevel: Internal.ServerLevel_, pLightning: Internal.LightningBolt_, ci: Internal.CallbackInfo_): void;
        isShiftKeyDown(): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        handler$daa000$isPushable(cir: Internal.CallbackInfoReturnable_<any>): void;
        setUUID(arg0: Internal.UUID_): void;
        checkBelowWorld(): void;
        isVisuallyCrawling(): boolean;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setMotionZ(z: number): void;
        sdl$shouldUpdateDynamicLight(): boolean;
        handler$daa000$setSprinting(pSprinting: boolean, ci: Internal.CallbackInfo_): void;
        "deserializeNBT(net.minecraft.nbt.Tag)"(arg0: Internal.Tag_): void;
        canFreeze(): boolean;
        ignoreExplosion(): boolean;
        teleportRelative(arg0: number, arg1: number, arg2: number): void;
        getBlockY(): number;
        isSpectator(): boolean;
        pehkui_setScaleCache(scaleCache: Internal.ScaleData_[]): void;
        isInWaterOrBubble(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        updateFluidHeightAndDoFluidPushing(): void;
        spawnAtLocation(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        getPersistentData(): Internal.CompoundTag;
        getPortalCooldown(): number;
        setSyncedData(key: string, value: any): void;
        getItem(): Internal.ItemStack;
        getRandomZ(arg0: number): number;
        causeFallDamage(arg0: number, arg1: number, arg2: DamageSource_): boolean;
        pehkui_getOnGround(): boolean;
        setRemoved(arg0: Internal.Entity$RemovalReason_): void;
        getPosition(arg0: number): Vec3d;
        getDistanceSq(arg0: number, arg1: number, arg2: number): number;
        isInWaterRainOrBubble(): boolean;
        getRemovalReason(): Internal.Entity$RemovalReason;
        wait(arg0: number): void;
        isOpenWaterFishing(): boolean;
        isIgnoringBlockTriggers(): boolean;
        getHandHoldingItemAngle(arg0: Internal.Item_): Vec3d;
        canUpdate(arg0: boolean): void;
        getEyeInFluidType(): Internal.FluidType;
        distanceToSqr(arg0: Vec3d_): number;
        resetFallDistance(): void;
        canSprint(): boolean;
        blockPosition(): BlockPos;
        handler$daa000$dampensVibrations(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSteppingCarefully(): boolean;
        setBoundingBox(arg0: Internal.AABB_): void;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        "spawnAtLocation(net.minecraft.world.item.ItemStack,float)"(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        addAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        getBlockX(): number;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue(): number;
        handler$daa000$causeFallDamage(pFallDistance: number, pMultiplier: number, pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        getEncodeId(): string;
        getY(arg0: number): number;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setInvisible(arg0: boolean): void;
        invalidateCaps(): void;
        getName(): net.minecraft.network.chat.Component;
        onGround(): boolean;
        getControlledVehicle(): Internal.Entity;
        handler$dlf002$onTick(ci: Internal.CallbackInfo_): void;
        isOnSameTeam(arg0: Internal.Entity_): boolean;
        attack(arg0: DamageSource_, arg1: number): boolean;
        onInsideBubbleColumn(arg0: boolean): void;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        tick(): void;
        getEyePosition(): Vec3d;
        getEyeHeight(): number;
        hasPassenger(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        handler$daa000$isFreezing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getYaw(): number;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        hasPermissions(arg0: number): boolean;
        getCapability<T>(arg0: Internal.Capability_<T>, arg1: Internal.Direction_): Internal.LazyOptional<T>;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        pehkui_readScaleNbt(nbt: Internal.CompoundTag_): void;
        setCustomNameVisible(arg0: boolean): void;
        isAlliedTo(arg0: Internal.Team_): boolean;
        bo$getRenderer(): Internal.EntityRenderer<any>;
        bo$refreshEntityData(data: number): void;
        getControllingPassenger(): Internal.LivingEntity;
        getRemainingFireTicks(): number;
        handler$daa000$onClientRemoval(ci: Internal.CallbackInfo_): void;
        getScriptType(): Internal.ScriptType;
        onlyOpCanSetNbt(): boolean;
        startRiding(arg0: Internal.Entity_): boolean;
        saveWithoutId(arg0: Internal.CompoundTag_): Internal.CompoundTag;
        getForward(): Vec3d;
        serializeNBT(): Internal.Tag;
        fireImmune(): boolean;
        addMotion(arg0: number, arg1: number, arg2: number): void;
        getMaxFallDistance(): number;
        getZ(arg0: number): number;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        pehkui_isFirstUpdate(): boolean;
        getId(): number;
        canBeHitByProjectile(): boolean;
        handler$daa000$canFreeze(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTicksFrozen(): number;
        getRandomX(arg0: number): number;
        getEyeY(): number;
        handler$daa000$playerTouch(pPlayer: Internal.Player_, ci: Internal.CallbackInfo_): void;
        spawnAtLocation(arg0: Internal.ItemStack_, arg1: number): Internal.ItemEntity;
        handler$daa000$getMaxFallDistance(cir: Internal.CallbackInfoReturnable_<any>): void;
        pick(arg0: number, arg1: number, arg2: boolean): Internal.HitResult;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getBoundingBox(): Internal.AABB;
        isInWaterOrRain(): boolean;
        localvar$dng000$fluidCollision(arg0: Vec3d_): Vec3d;
        isDescending(): boolean;
        setItemSlot(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): void;
        getYHeadRot(): number;
        equals(arg0: any): boolean;
        getViewYRot(arg0: number): number;
        dismountsUnderwater(): boolean;
        sodiumdynamiclights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        addTag(arg0: string): boolean;
        playerTouch(arg0: Internal.Player_): void;
        getAddEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        getEyeHeight(arg0: Internal.Pose_): number;
        syncPacketPositionCodec(arg0: number, arg1: number, arg2: number): void;
        setOwner(arg0: Internal.Entity_): void;
        handler$daa000$entityJs$tick(ci: Internal.CallbackInfo_): void;
        handler$daa001$getControllingPassenger(cir: Internal.CallbackInfoReturnable_<any>): void;
        getTeam(): Internal.Team;
        handler$daa000$stopRiding(ci: Internal.CallbackInfo_): void;
        shouldRenderAtSqrDistance(arg0: number): boolean;
        damageSources(): Internal.DamageSources;
        setTicksFrozen(arg0: number): void;
        recreateFromPacket(arg0: Internal.ClientboundAddEntityPacket_): void;
        handler$bnk000$tryShortcutFluidPushing(ci: Internal.CallbackInfo_, box: Internal.AABB_, x1: number, x2: number, y1: number, y2: number, z1: number, z2: number, zero: number): void;
        getMyRidingOffset(): number;
        canStartSwimming(): boolean;
        dismountTo(arg0: number, arg1: number, arg2: number): void;
        setDeltaMovement(arg0: Vec3d_): void;
        getLeashOffset(arg0: number): Vec3d;
        hasCustomName(): boolean;
        setFireType(arg0: ResourceLocation_): void;
        isLiving(): boolean;
        getX(): number;
        isGlowing(): boolean;
        "isInFluidType(net.minecraft.world.level.material.FluidState)"(arg0: Internal.FluidState_): boolean;
        isVehicle(): boolean;
        getLeashOffset(): Vec3d;
        isAttackable(): boolean;
        spawnAtLocation(arg0: Internal.ItemStack_): Internal.ItemEntity;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        thunderHit(arg0: Internal.ServerLevel_, arg1: Internal.LightningBolt_): void;
        setIsInPowderSnow(arg0: boolean): void;
        doEnchantDamageEffects(arg0: Internal.LivingEntity_, arg1: Internal.Entity_): void;
        setCustomName(arg0: net.minecraft.network.chat.Component_): void;
        getSlot(arg0: number): Internal.SlotAccess;
        jerotes_$summon(arg0: Internal.VariantZsieinEntity_, arg1: Internal.ServerLevel_): void;
        "deserializeNBT(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): void;
        pehkui_constructScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getTeamId(): string;
        stopSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        isUnderWater(): boolean;
        stopRiding(): void;
        isCustomNameVisible(): boolean;
        isSupportedBy(arg0: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        getX(arg0: number): number;
        shouldRiderSit(): boolean;
        lookAt(arg0: Internal.EntityAnchorArgument$Anchor_, arg1: Vec3d_): void;
        captureDrops(arg0: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        getSelfAndPassengers(): Internal.Stream<any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        localvar$bjk000$apoth_checkFallDamageWithGravity(arg0: number): number;
        getDeltaMovement(): Vec3d;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        "onSyncedDataUpdated(java.util.List)"(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        shoot(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        hasPassenger(arg0: Internal.Entity_): boolean;
        hasIndirectPassenger(arg0: Internal.Entity_): boolean;
        getEntityData(): Internal.SynchedEntityData;
        setSecondsOnFire(arg0: number): void;
        sdl$dynamicLightTick(): void;
        moveTo(arg0: number, arg1: number, arg2: number): void;
        "getDisplayName()"(): net.minecraft.network.chat.Component;
        handleInsidePortal(arg0: BlockPos_): void;
        create$callSetLevel(arg0: Internal.Level_): void;
        setMotion(arg0: number, arg1: number, arg2: number): void;
        playSound(arg0: Internal.SoundEvent_): void;
        handler$daa000$rideTick(ci: Internal.CallbackInfo_): void;
        updateFluidHeightAndDoFluidPushing(arg0: Internal.Predicate_<Internal.FluidState>): void;
        absMoveTo(arg0: number, arg1: number, arg2: number): void;
        isOnRails(): boolean;
        handler$daa000$canTrample(state: Internal.BlockState_, pos: BlockPos_, fallDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        restoreFrom(arg0: Internal.Entity_): void;
        getDimensionChangingDelay(): number;
        isPeacefulCreature(): boolean;
        setOnGround(arg0: boolean): void;
        setPos(arg0: number, arg1: number, arg2: number): void;
        setYaw(arg0: number): void;
        getHookedIn(): Internal.Entity;
        getPickRadius(): number;
        notify(): void;
        getFirstTick(): boolean;
        getVehicle(): Internal.Entity;
        isEffectiveAi(): boolean;
        startRiding(arg0: Internal.Entity_, arg1: boolean): boolean;
        getStringUuid(): string;
        isRemoved(): boolean;
        setSwimming(arg0: boolean): void;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        teleportToWithTicket(arg0: number, arg1: number, arg2: number): void;
        fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        getRotationVector(): Internal.Vec2;
        pehkui_writeScaleNbt(nbt: Internal.CompoundTag_): Internal.CompoundTag;
        refreshDimensions(): void;
        self(): Internal.Entity;
        sdl$getDynamicLightY(): number;
        handler$daa000$isAttackable(cir: Internal.CallbackInfoReturnable_<any>): void;
        isSprinting(): boolean;
        "spawnAtLocation(net.minecraft.world.level.ItemLike)"(arg0: Internal.ItemLike_): Internal.ItemEntity;
        handler$daa000$canChangeDimensions(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionY(): number;
        canCollideWith(arg0: Internal.Entity_): boolean;
        setShiftKeyDown(arg0: boolean): void;
        getEyePosition(arg0: number): Vec3d;
        getPassengers(): Internal.EntityArrayList;
        getBlockExplosionResistance(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.FluidState_, arg5: number): number;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        getMaxHeightFluidType(): Internal.FluidType;
        getZ(): number;
        canSpawnSprintParticle(): boolean;
        "moveTo(net.minecraft.core.BlockPos,float,float)"(arg0: BlockPos_, arg1: number, arg2: number): void;
        teleportTo(arg0: number, arg1: number, arg2: number): void;
        shootFromRotation(arg0: Internal.Entity_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): void;
        getServer(): Internal.MinecraftServer;
        moveRelative(arg0: number, arg1: Vec3d_): void;
        isAddedToWorld(): boolean;
        getFirstPassenger(): Internal.Entity;
        saveAsPassenger(arg0: Internal.CompoundTag_): boolean;
        interact(arg0: Internal.Player_, arg1: Internal.InteractionHand_): Internal.InteractionResult;
        handler$daa000$getMyRidingOffset(cir: Internal.CallbackInfoReturnable_<any>): void;
        sdl$getDynamicLightLevel(): Internal.Level;
        getDismountLocationForPassenger(arg0: Internal.LivingEntity_): Vec3d;
        checkSlowFallDistance(): void;
        getSoundSource(): Internal.SoundSource;
        setFabricBalmData(arg0: Internal.CompoundTag_): void;
        getPose(): Internal.Pose;
        touchingUnloadedChunk(): boolean;
        sdl$getDynamicLightZ(): number;
        getLookAngle(): Vec3d;
        setPositionAndRotation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        handler$daa000$isPickable(cir: Internal.CallbackInfoReturnable_<any>): void;
        getMotionZ(): number;
        removeVehicle(): void;
        isInvisible(): boolean;
        is(arg0: Internal.Entity_): boolean;
        setZ(z: number): void;
        getY(): number;
        ejectPassengers(): void;
        hashCode(): number;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getProfile(): Internal.GameProfile;
        static setViewScale(arg0: number): void;
        setLevelCallback(arg0: Internal.EntityInLevelCallback_): void;
        handler$daa000$isInvulnerableTo(pSource: DamageSource_, cir: Internal.CallbackInfoReturnable_<any>): void;
        showVehicleHealth(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityDispatcher)"(arg0: Internal.CapabilityDispatcher_): boolean;
        startSeenByPlayer(arg0: Internal.ServerPlayer_): void;
        handler$fdn000$create$onFireImmune(arg0: Internal.CallbackInfoReturnable_<any>): void;
        isOnScoreboardTeam(teamId: string): boolean;
        /**
         * @deprecated
        */
        isPushedByFluid(): boolean;
        position(): Vec3d;
        biomancy$random(): Internal.RandomSource;
        handler$daa000$shouldRenderAtSqrDistance(pDistance: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        displayFireAnimation(): boolean;
        turn(arg0: number, arg1: number): void;
        getAirSupply(): number;
        getRopeHoldPosition(arg0: number): Vec3d;
        copyPosition(arg0: Internal.Entity_): void;
        onAddedToWorld(): void;
        "hasPassenger(net.minecraft.world.entity.Entity)"(arg0: Internal.Entity_): boolean;
        isCrouching(): boolean;
        moveTo(arg0: BlockPos_, arg1: number, arg2: number): void;
        isAnimal(): boolean;
        isPlayer(): boolean;
        readAdditionalSaveData(arg0: Internal.CompoundTag_): void;
        handler$daa000$move(pType: Internal.MoverType_, pPos: Vec3d_, ci: Internal.CallbackInfo_): void;
        canBeCollidedWith(): boolean;
        getMotionDirection(): Internal.Direction;
        setY(y: number): void;
        sdl$isDynamicLightEnabled(): boolean;
        getFeetBlockState(): Internal.BlockState;
        lavaHurt(): void;
        handleDamageEvent(arg0: DamageSource_): void;
        getFabricBalmData(): Internal.CompoundTag;
        canChangeDimensions(): boolean;
        changeDimension(arg0: Internal.ServerLevel_, arg1: Internal.ITeleporter_): Internal.Entity;
        getCommandSenderWorld(): Internal.Level;
        positionRider(arg0: Internal.Entity_): void;
        baseTick(): void;
        broadcastToPlayer(arg0: Internal.ServerPlayer_): boolean;
        changeDimension(arg0: Internal.ServerLevel_): Internal.Entity;
        setSharedFlag(arg0: number, arg1: boolean): void;
        entityJs$defineSynchedData(): void;
        getOwner(): Internal.Entity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightAccess(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getCustomName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        pehkui_shouldIgnoreScaleNbt(): boolean;
        getMaxAirSupply(): number;
        isMoving(): boolean;
        isVisuallySwimming(): boolean;
        canTrample(arg0: Internal.BlockState_, arg1: BlockPos_, arg2: number): boolean;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        entityJs$getTypeId(): string;
        getFacing(): Internal.Direction;
        "hasPassenger(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.Entity>): boolean;
        getDimensions(arg0: Internal.Pose_): Internal.EntityDimensions;
        sdl$getDynamicLightX(): number;
        isPassengerOfSameVehicle(arg0: Internal.Entity_): boolean;
        isSwimming(): boolean;
        getBoundingBoxForCulling(): Internal.AABB;
        mayInteract(arg0: Internal.Level_, arg1: BlockPos_): boolean;
        setSprinting(arg0: boolean): void;
        static collideBoundingBox(entity: Internal.Entity_, movement: Vec3d_, entityBoundingBox: Internal.AABB_, world: Internal.Level_, collisions: Internal.List_<any>): Vec3d;
        addSyncedData(type: Internal.EntitySerializerType_, key: string, value: any): void;
        setPortalCooldown(): void;
        setX(x: number): void;
        trackingPosition(): Vec3d;
        getNameTagOffsetY(): number;
        isInvulnerable(): boolean;
        isInLava(): boolean;
        getPortalWaitTime(): number;
        awardKillScore(arg0: Internal.Entity_, arg1: number, arg2: DamageSource_): void;
        getBlockStateOn(): Internal.BlockState;
        isInWater(): boolean;
        getFluidJumpThreshold(): number;
        "setPositionAndRotation(double,double,double,float,float)"(x: number, y: number, z: number, yaw: number, pitch: number): void;
        pehkui_getScaleCache(): Internal.ScaleData[];
        isInvisibleTo(arg0: Internal.Player_): boolean;
        setAirSupply(arg0: number): void;
        getOnPos(): BlockPos;
        getRootVehicle(): Internal.Entity;
        save(arg0: Internal.CompoundTag_): boolean;
        pehkui_getScales(): Internal.Map<any, any>;
        handler$daa000$onRemovedFromWorld(ci: Internal.CallbackInfo_): void;
        isNoGravity(): boolean;
        sdl$getLuminance(): number;
        getStepHeight(): number;
        acceptsFailure(): boolean;
        pehkui_setShouldIgnoreScaleNbt(ignore: boolean): void;
        setOnGroundWithKnownMovement(arg0: boolean, arg1: Vec3d_): void;
        setOldPosAndRot(): void;
        bookshelf$createHoverEvent(): Internal.HoverEvent;
        isFree(arg0: number, arg1: number, arg2: number): boolean;
        getPlayerOwner(): Internal.Player;
        updateSwimming(): void;
        "moveTo(double,double,double)"(arg0: number, arg1: number, arg2: number): void;
        setRemainingFireTicks(arg0: number): void;
        getCachedFeetBlockState(): Internal.BlockState;
        shouldInformAdmins(): boolean;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        rideTick(): void;
        /**
         * @deprecated
        */
        getOnPosLegacy(): BlockPos;
        setPos(arg0: Vec3d_): void;
        wait(): void;
        addSyncedData(identifier: string, value: any): void;
        getUuid(): Internal.UUID;
        spawn(): void;
        areCapsCompatible(arg0: Internal.CapabilityDispatcher_): boolean;
        teleportTo(arg0: Internal.ServerLevel_, arg1: number, arg2: number, arg3: number, arg4: Internal.Set_<Internal.RelativeMovement>, arg5: number, arg6: number): boolean;
        shouldShowName(): boolean;
        getFireType(): ResourceLocation;
        handler$daa000$lerpTo(x: number, y: number, z: number, yaw: number, pitch: number, posRotationIncrements: number, teleport: boolean, ci: Internal.CallbackInfo_): void;
        getArmorSlots(): Internal.Iterable<Internal.ItemStack>;
        setSilent(arg0: boolean): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        hasExactlyOnePlayerPassenger(): boolean;
        kill(): void;
        handler$daa000$onAddedToWorld(ci: Internal.CallbackInfo_): void;
        handler$cln000$setRemoved(arg0: Internal.Entity$RemovalReason_, arg1: Internal.CallbackInfo_): void;
        isOnPortalCooldown(): boolean;
        retrieve(arg0: Internal.ItemStack_): number;
        animateHurt(arg0: number): void;
        handler$daa000$lavaHurt(ci: Internal.CallbackInfo_): void;
        setPitch(arg0: number): void;
        isMultipartEntity(): boolean;
        setPosRaw(arg0: number, arg1: number, arg2: number): void;
        handleEntityEvent(arg0: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getDimensionsForge(arg0: Internal.Pose_): Internal.EntityDimensions;
        getParts(): Internal.PartEntity<any>[];
        isAlwaysTicking(): boolean;
        interactAt(arg0: Internal.Player_, arg1: Vec3d_, arg2: Internal.InteractionHand_): Internal.InteractionResult;
        deserializeNBT(arg0: Internal.Tag_): void;
        lerpTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): void;
        onPassengerTurned(arg0: Internal.Entity_): void;
        revive(): void;
        spawnAtLocation(arg0: Internal.ItemLike_): Internal.ItemEntity;
        getBbWidth(): number;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        getForgePersistentData(): Internal.CompoundTag;
        addDeltaMovement(arg0: Vec3d_): void;
        pehkui_setOnGround(onGround: boolean): void;
        lithiumOnBlockCacheDeleted(): void;
        "spawnAtLocation(net.minecraft.world.level.ItemLike,int)"(arg0: Internal.ItemLike_, arg1: number): Internal.ItemEntity;
        setInvulnerable(arg0: boolean): void;
        "getName()"(): net.minecraft.network.chat.Component;
        push(arg0: Internal.Entity_): void;
        isInFluidType(): boolean;
        mirror(arg0: Internal.Mirror_): number;
        canUpdate(): boolean;
        getTicksRequiredToFreeze(): number;
        /**
         * @deprecated
        */
        maxUpStep(): number;
        setGlowing(arg0: boolean): void;
        load(arg0: Internal.CompoundTag_): void;
        isAlive(): boolean;
        getBbHeight(): number;
        handler$daa000$push(pEntity: Internal.Entity_, ci: Internal.CallbackInfo_): void;
        getUsername(): string;
        move(arg0: Internal.MoverType_, arg1: Vec3d_): void;
        getTags(): Internal.Set<string>;
        getViewVector(arg0: number): Vec3d;
        onRemovedFromWorld(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        isPickable(): boolean;
        isInFluidType(predicate: Internal.BiPredicate_<any, any>, forAllTypes: boolean): boolean;
        setYHeadRot(arg0: number): void;
        hasControllingPassenger(): boolean;
        closerThan(arg0: Internal.Entity_, arg1: number, arg2: number): boolean;
        absMoveTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
        getPercentFrozen(): number;
        getPickResult(): Internal.ItemStack;
        getRandomY(): number;
        setPortalCooldown(arg0: number): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasGlowingTag(): boolean;
        shouldBlockExplode(arg0: Internal.Explosion_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: number): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        getFluidTypeHeight(arg0: Internal.FluidType_): number;
        shouldBeSaved(): boolean;
        handler$daa000$canCollideWith(pEntity: Internal.Entity_, cir: Internal.CallbackInfoReturnable_<any>): void;
        canRiderInteract(): boolean;
        getViewXRot(arg0: number): number;
        "areCapsCompatible(net.minecraftforge.common.capabilities.CapabilityProvider)"(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        removeTag(arg0: string): boolean;
        setPose(arg0: Internal.Pose_): void;
        /**
         * @deprecated
        */
        getFluidHeight(arg0: Internal.TagKey_<Internal.Fluid>): number;
        getEntityType(): Internal.EntityType<any>;
        isWaterCreature(): boolean;
        toString(): string;
        pehkui_getScaleData(type: Internal.ScaleType_): Internal.ScaleData;
        getSyncedData(identifier: string): any;
        notifyAll(): void;
        getPassengersRidingOffset(): number;
        "isInFluidType(java.util.function.BiPredicate)"(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        distanceToEntitySqr(arg0: Internal.Entity_): number;
        "getServer()"(): Internal.MinecraftServer;
        isFrame(): boolean;
        isPushable(): boolean;
        setYBodyRot(arg0: number): void;
        discard(): void;
        onClientRemoval(): void;
        handler$daa000$showVehicleHealth(cir: Internal.CallbackInfoReturnable_<any>): void;
        sendSystemMessage(arg0: net.minecraft.network.chat.Component_): void;
        acceptsSuccess(): boolean;
        reviveCaps(): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        setNoGravity(arg0: boolean): void;
        getEffectSource(): Internal.Entity;
        sdl$setDynamicLightEnabled(enabled: boolean): void;
        handler$daa000$isCurrentlyGlowing(cir: Internal.CallbackInfoReturnable_<any>): void;
        getIndirectPassengers(): Internal.Iterable<any>;
        setRotation(yaw: number, pitch: number): void;
        createCommandSourceStack(): Internal.CommandSourceStack;
        isControlledByLocalInstance(): boolean;
        isMonster(): boolean;
        pehkui_setShouldSyncScales(sync: boolean): void;
        sdl$resetDynamicLight(): void;
        getHorizontalFacing(): Internal.Direction;
        setId(arg0: number): void;
        onSyncedDataUpdated(arg0: Internal.List_<Internal.SynchedEntityData$DataValue<any>>): void;
        getType(): string;
        handler$dlf000$onRemove(ci: Internal.CallbackInfo_): void;
        getLightProbePosition(arg0: number): Vec3d;
        sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        onAboveBubbleCol(arg0: boolean): void;
        "playSound(net.minecraft.sounds.SoundEvent,float,float)"(arg0: Internal.SoundEvent_, arg1: number, arg2: number): void;
        isPassenger(): boolean;
        hasPose(arg0: Internal.Pose_): boolean;
        pehkui_shouldSyncScales(): boolean;
        checkDespawn(): void;
        /**
         * @deprecated
        */
        isEyeInFluid(arg0: Internal.TagKey_<Internal.Fluid>): boolean;
        isInvulnerableTo(arg0: DamageSource_): boolean;
        makeStuckInBlock(arg0: Internal.BlockState_, arg1: Vec3d_): void;
        skipAttackInteraction(arg0: Internal.Entity_): boolean;
        lerpMotion(arg0: number, arg1: number, arg2: number): void;
        shouldRender(arg0: number, arg1: number, arg2: number): boolean;
        onSyncedDataUpdated(arg0: Internal.EntityDataAccessor_<any>): void;
        handler$daa000$onInteract(pPlayer: Internal.Player_, pHand: Internal.InteractionHand_, cir: Internal.CallbackInfoReturnable_<any>): void;
        lerpHeadTo(arg0: number, arg1: number): void;
        static getViewScale(): number;
        setMotionX(x: number): void;
        getHandSlots(): Internal.Iterable<Internal.ItemStack>;
        distanceToEntity(arg0: Internal.Entity_): number;
        getVisualRotationYInDegrees(): number;
        wait(arg0: number, arg1: number): void;
        isDiscrete(): boolean;
        getTeamColor(): number;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        unRide(): void;
        getLevel(): Internal.Level;
        "spawnAtLocation(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): Internal.ItemEntity;
        "isInFluidType(net.minecraftforge.fluids.FluidType)"(arg0: Internal.FluidType_): boolean;
        extinguish(): void;
        updateDynamicGameEventListener(arg0: Internal.BiConsumer_<Internal.DynamicGameEventListener<any>, Internal.ServerLevel>): void;
        moveTo(arg0: Vec3d_): void;
        isColliding(arg0: BlockPos_, arg1: Internal.BlockState_): boolean;
        "onSyncedDataUpdated(net.minecraft.network.syncher.EntityDataAccessor)"(arg0: Internal.EntityDataAccessor_<any>): void;
        handler$daa000$mayInteract(pLevel: Internal.Level_, pPos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        areCapsCompatible(arg0: Internal.CapabilityProvider_<Internal.Entity>): boolean;
        extinguishFire(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        static lerpRotation(arg0: number, arg1: number): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        closerThan(arg0: Internal.Entity_, arg1: number): boolean;
        getDistanceSq(pos: BlockPos_): number;
        killedEntity(arg0: Internal.ServerLevel_, arg1: Internal.LivingEntity_): boolean;
        getClassification(arg0: boolean): Internal.MobCategory;
        isFreezing(): boolean;
        isFullyFrozen(): boolean;
        runCommand(command: string): number;
        setSharedFlagOnFire(arg0: boolean): void;
        get inWall(): boolean
        get allSlots(): Internal.Iterable<Internal.ItemStack>
        get blockZ(): number
        get suppressingBounce(): boolean
        get silent(): boolean
        get pitch(): number
        get onFire(): boolean
        get positionCodec(): Internal.VecDeltaCodec
        get passengersAndSelf(): Internal.Stream<any>
        set maxUpStep(arg0: number)
        get shiftKeyDown(): boolean
        set UUID(arg0: Internal.UUID_)
        get visuallyCrawling(): boolean
        set motionZ(z: number)
        get blockY(): number
        get spectator(): boolean
        get inWaterOrBubble(): boolean
        get persistentData(): Internal.CompoundTag
        get portalCooldown(): number
        get item(): Internal.ItemStack
        set removed(arg0: Internal.Entity$RemovalReason_)
        get inWaterRainOrBubble(): boolean
        get removalReason(): Internal.Entity$RemovalReason
        get openWaterFishing(): boolean
        get ignoringBlockTriggers(): boolean
        get eyeInFluidType(): Internal.FluidType
        get steppingCarefully(): boolean
        set boundingBox(arg0: Internal.AABB_)
        get ambientCreature(): boolean
        get blockX(): number
        /**
         * @deprecated
        */
        get lightLevelDependentMagicValue(): number
        get encodeId(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        set invisible(arg0: boolean)
        get name(): net.minecraft.network.chat.Component
        get controlledVehicle(): Internal.Entity
        get eyePosition(): Vec3d
        get eyeHeight(): number
        get yaw(): number
        set customNameVisible(arg0: boolean)
        get controllingPassenger(): Internal.LivingEntity
        get remainingFireTicks(): number
        get scriptType(): Internal.ScriptType
        get forward(): Vec3d
        get maxFallDistance(): number
        get id(): number
        get ticksFrozen(): number
        get eyeY(): number
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get boundingBox(): Internal.AABB
        get inWaterOrRain(): boolean
        get descending(): boolean
        get YHeadRot(): number
        get addEntityPacket(): Internal.Packet<Internal.ClientGamePacketListener>
        set owner(arg0: Internal.Entity_)
        get team(): Internal.Team
        set ticksFrozen(arg0: number)
        get myRidingOffset(): number
        set deltaMovement(arg0: Vec3d_)
        set fireType(arg0: ResourceLocation_)
        get living(): boolean
        get x(): number
        get glowing(): boolean
        get vehicle(): boolean
        get leashOffset(): Vec3d
        get attackable(): boolean
        set isInPowderSnow(arg0: boolean)
        set customName(arg0: net.minecraft.network.chat.Component_)
        get teamId(): string
        get underWater(): boolean
        get customNameVisible(): boolean
        get pistonPushReaction(): Internal.PushReaction
        get selfAndPassengers(): Internal.Stream<any>
        get deltaMovement(): Vec3d
        get motionX(): number
        get entityData(): Internal.SynchedEntityData
        set secondsOnFire(arg0: number)
        get "displayName()"(): net.minecraft.network.chat.Component
        get onRails(): boolean
        get dimensionChangingDelay(): number
        get peacefulCreature(): boolean
        set onGround(arg0: boolean)
        set yaw(arg0: number)
        get hookedIn(): Internal.Entity
        get pickRadius(): number
        get firstTick(): boolean
        get vehicle(): Internal.Entity
        get effectiveAi(): boolean
        get stringUuid(): string
        get removed(): boolean
        set swimming(arg0: boolean)
        get rotationVector(): Internal.Vec2
        get sprinting(): boolean
        get motionY(): number
        set shiftKeyDown(arg0: boolean)
        get passengers(): Internal.EntityArrayList
        get maxHeightFluidType(): Internal.FluidType
        get z(): number
        get server(): Internal.MinecraftServer
        get addedToWorld(): boolean
        get firstPassenger(): Internal.Entity
        get soundSource(): Internal.SoundSource
        set fabricBalmData(arg0: Internal.CompoundTag_)
        get pose(): Internal.Pose
        get lookAngle(): Vec3d
        get motionZ(): number
        get invisible(): boolean
        set z(z: number)
        get y(): number
        get profile(): Internal.GameProfile
        set viewScale(arg0: number)
        set levelCallback(arg0: Internal.EntityInLevelCallback_)
        /**
         * @deprecated
        */
        get pushedByFluid(): boolean
        get airSupply(): number
        get crouching(): boolean
        get animal(): boolean
        get player(): boolean
        get motionDirection(): Internal.Direction
        set y(y: number)
        get feetBlockState(): Internal.BlockState
        get fabricBalmData(): Internal.CompoundTag
        get commandSenderWorld(): Internal.Level
        get owner(): Internal.Entity
        get customName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get maxAirSupply(): number
        get moving(): boolean
        get visuallySwimming(): boolean
        get facing(): Internal.Direction
        get swimming(): boolean
        get boundingBoxForCulling(): Internal.AABB
        set sprinting(arg0: boolean)
        set x(x: number)
        get nameTagOffsetY(): number
        get invulnerable(): boolean
        get inLava(): boolean
        get portalWaitTime(): number
        get blockStateOn(): Internal.BlockState
        get inWater(): boolean
        get fluidJumpThreshold(): number
        set airSupply(arg0: number)
        get onPos(): BlockPos
        get rootVehicle(): Internal.Entity
        get noGravity(): boolean
        get stepHeight(): number
        get playerOwner(): Internal.Player
        set remainingFireTicks(arg0: number)
        get cachedFeetBlockState(): Internal.BlockState
        /**
         * @deprecated
        */
        get onPosLegacy(): BlockPos
        set pos(arg0: Vec3d_)
        get uuid(): Internal.UUID
        get fireType(): ResourceLocation
        get armorSlots(): Internal.Iterable<Internal.ItemStack>
        set silent(arg0: boolean)
        get onPortalCooldown(): boolean
        set pitch(arg0: number)
        get multipartEntity(): boolean
        get parts(): Internal.PartEntity<any>[]
        get alwaysTicking(): boolean
        get bbWidth(): number
        get forgePersistentData(): Internal.CompoundTag
        set invulnerable(arg0: boolean)
        get "name()"(): net.minecraft.network.chat.Component
        get inFluidType(): boolean
        get ticksRequiredToFreeze(): number
        set glowing(arg0: boolean)
        get alive(): boolean
        get bbHeight(): number
        get username(): string
        get tags(): Internal.Set<string>
        get pickable(): boolean
        set YHeadRot(arg0: number)
        get percentFrozen(): number
        get pickResult(): Internal.ItemStack
        get randomY(): number
        set portalCooldown(arg0: number)
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set pose(arg0: Internal.Pose_)
        get entityType(): Internal.EntityType<any>
        get waterCreature(): boolean
        get passengersRidingOffset(): number
        get "server()"(): Internal.MinecraftServer
        get frame(): boolean
        get pushable(): boolean
        set YBodyRot(arg0: number)
        set motionY(y: number)
        set noGravity(arg0: boolean)
        get effectSource(): Internal.Entity
        get indirectPassengers(): Internal.Iterable<any>
        get controlledByLocalInstance(): boolean
        get monster(): boolean
        get horizontalFacing(): Internal.Direction
        set id(arg0: number)
        get type(): string
        get passenger(): boolean
        get viewScale(): number
        set motionX(x: number)
        get handSlots(): Internal.Iterable<Internal.ItemStack>
        get visualRotationYInDegrees(): number
        get discrete(): boolean
        get teamColor(): number
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get freezing(): boolean
        get fullyFrozen(): boolean
        set sharedFlagOnFire(arg0: boolean)
        biting: boolean;
    }
    type FishingHook_ = FishingHook;
    class DoubleFaceAttachedBlock extends Internal.HorizontalDirectionalBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly FACE: Internal.EnumProperty<Internal.DoubleFaceAttachedBlock$DoubleAttachFace>;
    }
    type DoubleFaceAttachedBlock_ = DoubleFaceAttachedBlock;
    class BlackArgilliteStairsNBlock extends Internal.StairBlock {
        constructor()
        static isStairs(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type BlackArgilliteStairsNBlock_ = BlackArgilliteStairsNBlock;
    class Calendar$WeekData {
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        getClass(): typeof any;
        hashCode(): number;
        toString(): string;
        wait(): void;
        notifyAll(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        get class(): typeof any
        readonly weekendCeaseMillis: number;
        readonly weekendOnsetMillis: number;
        readonly firstDayOfWeek: number;
        readonly minimalDaysInFirstWeek: number;
        readonly weekendCease: number;
        readonly weekendOnset: number;
    }
    type Calendar$WeekData_ = Calendar$WeekData;
    class SupportOPACServer {
        constructor()
        getClass(): typeof any;
        toString(): string;
        getReceiveLocationsFromPartyConfigValue(arg0: Internal.ServerPlayer_): boolean;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        hashCode(): number;
        updateShareLocationConfigValues(arg0: Internal.ServerPlayer_, arg1: xaero.common.server.player.ServerPlayerData_): void;
        wait(): void;
        getReceiveLocationsFromMutualAlliesConfigValue(arg0: Internal.ServerPlayer_): boolean;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isPositionSyncAllowed(arg0: number, arg1: xaero.common.server.player.ServerPlayerData_, arg2: boolean): boolean;
        get class(): typeof any
    }
    type SupportOPACServer_ = SupportOPACServer;
    class PolishedCalciteBlock extends Internal.Block {
        constructor()
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type PolishedCalciteBlock_ = PolishedCalciteBlock;
    class EmptyMapItem extends Internal.ComplexItem {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getUpdatePacket(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): Internal.Packet<any>;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type EmptyMapItem_ = EmptyMapItem;
    class LootTableEntry implements Internal.FunctionContainer, Internal.ConditionContainer {
        constructor(o: Internal.JsonObject_)
        getClass(): typeof any;
        randomChanceWithLooting(chance: number, multiplier: number): Internal.ConditionContainer;
        name(name: net.minecraft.network.chat.Component_, entity: Internal.LootContext$EntityTarget_): Internal.FunctionContainer;
        notify(): void;
        damage(damage: Internal.NumberProvider_): Internal.FunctionContainer;
        wait(arg0: number, arg1: number): void;
        count(count: Internal.NumberProvider_): Internal.FunctionContainer;
        survivesExplosion(): Internal.ConditionContainer;
        copyName(source: Internal.CopyNameFunction$NameSource_): Internal.FunctionContainer;
        lootTable(table: ResourceLocation_, seed: number): Internal.FunctionContainer;
        enchantWithLevels(levels: Internal.NumberProvider_, treasure: boolean): Internal.FunctionContainer;
        weight(weight: number): this;
        toString(): string;
        enchantRandomly(enchantments: ResourceLocation_[]): Internal.FunctionContainer;
        furnaceSmelt(): Internal.FunctionContainer;
        entityProperties(entity: Internal.LootContext$EntityTarget_, properties: Internal.JsonObject_): Internal.ConditionContainer;
        lootingEnchant(count: Internal.NumberProvider_, limit: number): Internal.FunctionContainer;
        notifyAll(): void;
        addCondition(o: Internal.JsonObject_): this;
        addConditionalFunction(func: Internal.Consumer_<Internal.ConditionalFunction>): Internal.FunctionContainer;
        randomChance(chance: number): Internal.ConditionContainer;
        addFunction(o: Internal.JsonObject_): this;
        killedByPlayer(): Internal.ConditionContainer;
        nbt(tag: Internal.CompoundTag_): Internal.FunctionContainer;
        entityScores(entity: Internal.LootContext$EntityTarget_, scores: Internal.Map_<string, any>): Internal.ConditionContainer;
        hashCode(): number;
        quality(quality: number): this;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        name(name: net.minecraft.network.chat.Component_): Internal.FunctionContainer;
        get class(): typeof any
        readonly json: Internal.JsonObject;
    }
    type LootTableEntry_ = LootTableEntry;
    class MapLayer {
        constructor(arg0: Internal.MapDimension_, arg1: Internal.RegionHighlightExistenceTracker_)
        getClass(): typeof any;
        toString(): string;
        tryAddingToCompleteRegionDetection(arg0: Internal.RegionDetection_): void;
        notifyAll(): void;
        getRegionDetection(arg0: number, arg1: number): Internal.RegionDetection;
        getCaveStart(): number;
        preDetection(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        getDetectedRegions(): Internal.Hashtable<number, Internal.Hashtable<number, Internal.RegionDetection>>;
        getCompleteRegionDetection(arg0: number, arg1: number): Internal.RegionDetection;
        regionDetectionExists(arg0: number, arg1: number): boolean;
        getMapRegions(): Internal.LeveledRegionManager;
        addRegionDetection(arg0: Internal.RegionDetection_): void;
        hashCode(): number;
        getLinkedCompleteWorldSaveDetectedRegions(): Internal.Iterable<Internal.RegionDetection>;
        setCaveStart(arg0: number): void;
        wait(): void;
        getRegionHighlightExistenceTracker(): Internal.RegionHighlightExistenceTracker;
        wait(arg0: number): void;
        removeRegionDetection(arg0: number, arg1: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
        get caveStart(): number
        get detectedRegions(): Internal.Hashtable<number, Internal.Hashtable<number, Internal.RegionDetection>>
        get mapRegions(): Internal.LeveledRegionManager
        get linkedCompleteWorldSaveDetectedRegions(): Internal.Iterable<Internal.RegionDetection>
        set caveStart(arg0: number)
        get regionHighlightExistenceTracker(): Internal.RegionHighlightExistenceTracker
    }
    type MapLayer_ = MapLayer;
    class WandOptions$MATCH extends Internal.Enum<Internal.WandOptions$MATCH> {
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        getClass(): typeof any;
        toString(): string;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.WandOptions$MATCH>>;
        notifyAll(): void;
        notify(): void;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        name(): string;
        getDeclaringClass(): typeof Internal.WandOptions$MATCH;
        static valueOf(arg0: string): Internal.WandOptions$MATCH;
        hashCode(): number;
        ordinal(): number;
        wait(): void;
        static values(): Internal.WandOptions$MATCH[];
        compareTo(arg0: Internal.WandOptions$MATCH_): number;
        wait(arg0: number): void;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        "compareTo(thetadev.constructionwand.basics.option.WandOptions$MATCH)"(arg0: Internal.WandOptions$MATCH_): number;
        get class(): typeof any
        get declaringClass(): typeof Internal.WandOptions$MATCH
        static readonly ANY: (Internal.WandOptions$MATCH) & (Internal.WandOptions$MATCH);
        static readonly EXACT: (Internal.WandOptions$MATCH) & (Internal.WandOptions$MATCH);
        static readonly SIMILAR: (Internal.WandOptions$MATCH) & (Internal.WandOptions$MATCH);
    }
    type WandOptions$MATCH_ = "exact" | "any" | WandOptions$MATCH | "similar";
    interface IMixinGui {
        abstract get_subtitle_FancyMenu(): net.minecraft.network.chat.Component;
        abstract get_title_FancyMenu(): net.minecraft.network.chat.Component;
        get _subtitle_FancyMenu(): net.minecraft.network.chat.Component
        get _title_FancyMenu(): net.minecraft.network.chat.Component
    }
    type IMixinGui_ = IMixinGui;
    class LivingToolState extends Internal.Enum<Internal.LivingToolState> {
        getClass(): typeof any;
        notify(): void;
        static "deserialize(net.minecraft.nbt.CompoundTag)"(arg0: Internal.CompoundTag_): Internal.LivingToolState;
        wait(arg0: number, arg1: number): void;
        compareTo(arg0: any): number;
        "compareTo(com.github.elenterius.biomancy.api.livingtool.LivingToolState)"(arg0: Internal.LivingToolState_): number;
        serialize(arg0: Internal.CompoundTag_): void;
        describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<Internal.LivingToolState>>;
        getTooltip(): Internal.MutableComponent;
        getDeclaringClass(): typeof Internal.LivingToolState;
        static valueOf(arg0: string): Internal.LivingToolState;
        static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
        compareTo(arg0: Internal.LivingToolState_): number;
        toString(): string;
        notifyAll(): void;
        getTranslationKey(): string;
        static deserialize(arg0: Internal.CompoundTag_): Internal.LivingToolState;
        getDisplayName(): Internal.MutableComponent;
        static "deserialize(byte)"(arg0: number): Internal.LivingToolState;
        static values(): Internal.LivingToolState[];
        name(): string;
        hashCode(): number;
        static deserialize(arg0: number): Internal.LivingToolState;
        ordinal(): number;
        wait(): void;
        wait(arg0: number): void;
        static getTooltipTranslationKey(): string;
        "compareTo(java.lang.Object)"(arg0: any): number;
        equals(arg0: any): boolean;
        get class(): typeof any
        get tooltip(): Internal.MutableComponent
        get declaringClass(): typeof Internal.LivingToolState
        get translationKey(): string
        get displayName(): Internal.MutableComponent
        get tooltipTranslationKey(): string
        static readonly STATE_TAG_KEY: ("LivingToolState") & (string);
        static readonly BROKEN: (Internal.LivingToolState) & (Internal.LivingToolState);
        static readonly AWAKENED: (Internal.LivingToolState) & (Internal.LivingToolState);
        static readonly DORMANT: (Internal.LivingToolState) & (Internal.LivingToolState);
    }
    type LivingToolState_ = "dormant" | "awakened" | "broken" | LivingToolState;
    interface IStackList <T> {
        abstract remove(arg0: T, arg1: number): Internal.StackListResult<T>;
        abstract remove(arg0: T): Internal.StackListResult<T>;
        abstract get(arg0: T, arg1: number): T;
        abstract "get(java.util.UUID)"(arg0: Internal.UUID_): T;
        abstract add(arg0: T): Internal.StackListResult<T>;
        abstract isEmpty(): boolean;
        get(arg0: T): T;
        abstract getStacks(arg0: T): Internal.Collection<Internal.StackListEntry<T>>;
        "get(java.lang.Object)"(arg0: T): T;
        abstract getCount(arg0: T, arg1: number): number;
        abstract getEntry(arg0: T, arg1: number): Internal.StackListEntry<T>;
        abstract size(): number;
        getCount(arg0: T): number;
        abstract clear(): void;
        abstract copy(): this;
        abstract add(arg0: T, arg1: number): Internal.StackListResult<T>;
        abstract getStacks(): Internal.Collection<Internal.StackListEntry<T>>;
        abstract get(arg0: Internal.UUID_): T;
        get empty(): boolean
        get stacks(): Internal.Collection<Internal.StackListEntry<T>>
    }
    type IStackList_<T> = IStackList<T>;
    class KubeJSEntityRenderer <T extends Internal.LivingEntity & Internal.IAnimatableJS> extends Internal.GeoEntityRenderer<T> {
        constructor(renderManager: Internal.EntityRendererProvider$Context_, builder: Internal.BaseLivingEntityBuilder_<T>)
        getScaleHeight(): number;
        renderFinal(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
        "preRender(com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        "getRenderType(java.lang.Object,net.minecraft.resources.ResourceLocation,net.minecraft.client.renderer.MultiBufferSource,float)"(animatable: T, texture: ResourceLocation_, bufferSource: Internal.MultiBufferSource_, partialTick: number): Internal.RenderType;
        render(animatable: T, entityYaw: number, partialTick: number, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, packedLight: number): void;
        applyRenderLayers(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        getTextureLocation(entity: Internal.Entity_): ResourceLocation;
        defaultRender(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.MultiBufferSource_, arg3: Internal.RenderType_, arg4: Internal.VertexConsumer_, arg5: number, arg6: number, arg7: number): void;
        notify(): void;
        "getPackedOverlay(java.lang.Object,float,float)"(arg0: T, arg1: number, arg2: number): number;
        getGeoModel(): Internal.GeoModel<T>;
        getRenderType(animatable: T, texture: ResourceLocation_, bufferSource: Internal.MultiBufferSource_, partialTick: number): Internal.RenderType;
        addRenderLayer(arg0: Internal.GeoRenderLayer_<T>): Internal.GeoEntityRenderer<T>;
        fireCompileRenderLayersEvent(): void;
        isShaking(arg0: T): boolean;
        getRenderColor(arg0: T, arg1: number, arg2: number): software.bernie.geckolib.core.object.Color;
        "getTextureLocation(net.minecraft.world.entity.Entity)"(entity: Internal.Entity_): ResourceLocation;
        getRenderLayers(): Internal.List<Internal.GeoRenderLayer<T>>;
        m_6512_(arg0: T): boolean;
        "applyRenderLayers(com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,float,int,int)"(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        getPackedOverlay(arg0: Internal.GeoAnimatable_, arg1: number, arg2: number): number;
        scaleModelForRender(widthScale: number, heightScale: number, poseStack: Internal.PoseStack_, animatable: Internal.GeoAnimatable_, model: Internal.BakedGeoModel_, isReRender: boolean, partialTick: number, packedLight: number, packedOverlay: number): void;
        preRender(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        getPackedOverlay(arg0: T, arg1: number, arg2: number): number;
        postRender(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        "render(java.lang.Object,float,float,com.mojang.blaze3d.vertex.PoseStack,net.minecraft.client.renderer.MultiBufferSource,int)"(animatable: T, entityYaw: number, partialTick: number, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, packedLight: number): void;
        getScaleWidth(): number;
        getTextureLocation(entity: T): ResourceLocation;
        preApplyRenderLayers(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        "applyRenderLayers(com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,float,int,int)"(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        actuallyRender(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        renderLeash<E extends Internal.Entity, M extends Internal.Mob>(arg0: M, arg1: number, arg2: Internal.PoseStack_, arg3: Internal.MultiBufferSource_, arg4: E): void;
        updateAnimatedTextureFrame(arg0: T): void;
        "getTextureLocation(java.lang.Object)"(entity: T): ResourceLocation;
        getPackedOverlay(arg0: Internal.GeoAnimatable_, arg1: number): number;
        "renderFinal(com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
        wait(): void;
        "actuallyRender(com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        "renderFinal(com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
        renderRecursively(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        getMotionAnimThreshold(arg0: T): number;
        render(animatable: Internal.Entity_, entityYaw: number, partialTick: number, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, packedLight: number): void;
        "getPackedOverlay(software.bernie.geckolib.core.animatable.GeoAnimatable,float,float)"(arg0: Internal.GeoAnimatable_, arg1: number, arg2: number): number;
        "render(net.minecraft.world.entity.Entity,float,float,com.mojang.blaze3d.vertex.PoseStack,net.minecraft.client.renderer.MultiBufferSource,int)"(animatable: Internal.Entity_, entityYaw: number, partialTick: number, poseStack: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, packedLight: number): void;
        renderFinal(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number): void;
        renderChildBones(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        "actuallyRender(com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        getClass(): typeof any;
        updateAnimatedTextureFrame(arg0: Internal.GeoAnimatable_): void;
        getRenderOffset(arg0: T, arg1: number): Vec3d;
        preRender(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        getAnimatable(): Internal.GeoAnimatable;
        getInstanceId(arg0: T): number;
        getTextureLocation(entity: Internal.GeoAnimatable_): ResourceLocation;
        "renderRecursively(com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.GeoBone,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        withScale(arg0: number, arg1: number): Internal.GeoEntityRenderer<T>;
        reRender(arg0: Internal.BakedGeoModel_, arg1: Internal.PoseStack_, arg2: Internal.MultiBufferSource_, arg3: T, arg4: Internal.RenderType_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        "scaleModelForRender(float,float,com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.BakedGeoModel,boolean,float,int,int)"(widthScale: number, heightScale: number, poseStack: Internal.PoseStack_, animatable: Internal.GeoAnimatable_, model: Internal.BakedGeoModel_, isReRender: boolean, partialTick: number, packedLight: number, packedOverlay: number): void;
        wait(arg0: number, arg1: number): void;
        "getPackedOverlay(java.lang.Object,float)"(arg0: T, arg1: number): number;
        getNameRenderCutoffDistance(arg0: T): number;
        "getPackedOverlay(software.bernie.geckolib.core.animatable.GeoAnimatable,float)"(arg0: Internal.GeoAnimatable_, arg1: number): number;
        createVerticesOfQuad(arg0: Internal.GeoQuad_, arg1: Matrix4f_, arg2: Vec3f_, arg3: Internal.VertexConsumer_, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): void;
        getPackedOverlay(arg0: T, arg1: number): number;
        actuallyRender(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        getPackedLightCoords(arg0: T, arg1: number): number;
        "getInstanceId(java.lang.Object)"(arg0: T): number;
        entityName(): string;
        "getTextureLocation(software.bernie.geckolib.core.animatable.GeoAnimatable)"(entity: Internal.GeoAnimatable_): ResourceLocation;
        "updateAnimatedTextureFrame(software.bernie.geckolib.core.animatable.GeoAnimatable)"(arg0: Internal.GeoAnimatable_): void;
        getRenderType(animatable: Internal.GeoAnimatable_, texture: ResourceLocation_, bufferSource: Internal.MultiBufferSource_, partialTick: number): Internal.RenderType;
        "getRenderType(software.bernie.geckolib.core.animatable.GeoAnimatable,net.minecraft.resources.ResourceLocation,net.minecraft.client.renderer.MultiBufferSource,float)"(animatable: Internal.GeoAnimatable_, texture: ResourceLocation_, bufferSource: Internal.MultiBufferSource_, partialTick: number): Internal.RenderType;
        getInstanceId(arg0: Internal.GeoAnimatable_): number;
        applyRenderLayers(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.BakedGeoModel_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        firePreRenderEvent(arg0: Internal.PoseStack_, arg1: Internal.BakedGeoModel_, arg2: Internal.MultiBufferSource_, arg3: number, arg4: number): boolean;
        toString(): string;
        "getInstanceId(software.bernie.geckolib.core.animatable.GeoAnimatable)"(arg0: Internal.GeoAnimatable_): number;
        firePostRenderEvent(arg0: Internal.PoseStack_, arg1: Internal.BakedGeoModel_, arg2: Internal.MultiBufferSource_, arg3: number, arg4: number): void;
        notifyAll(): void;
        applyRenderLayersForBone(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: number, arg7: number, arg8: number): void;
        "updateAnimatedTextureFrame(java.lang.Object)"(arg0: T): void;
        doPostRenderCleanup(): void;
        shouldRender(arg0: T, arg1: Internal.Frustum_, arg2: number, arg3: number, arg4: number): boolean;
        "preRender(com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.BakedGeoModel,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: T, arg2: Internal.BakedGeoModel_, arg3: Internal.MultiBufferSource_, arg4: Internal.VertexConsumer_, arg5: boolean, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number): void;
        renderRecursively(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        getFont(): net.minecraft.client.gui.Font;
        hashCode(): number;
        renderCube(arg0: Internal.PoseStack_, arg1: Internal.GeoCube_, arg2: Internal.VertexConsumer_, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): void;
        scaleModelForRender(widthScale: number, heightScale: number, poseStack: Internal.PoseStack_, animatable: T, model: Internal.BakedGeoModel_, isReRender: boolean, partialTick: number, packedLight: number, packedOverlay: number): void;
        wait(arg0: number): void;
        "renderRecursively(com.mojang.blaze3d.vertex.PoseStack,software.bernie.geckolib.core.animatable.GeoAnimatable,software.bernie.geckolib.cache.object.GeoBone,net.minecraft.client.renderer.RenderType,net.minecraft.client.renderer.MultiBufferSource,com.mojang.blaze3d.vertex.VertexConsumer,boolean,float,int,int,float,float,float,float)"(arg0: Internal.PoseStack_, arg1: Internal.GeoAnimatable_, arg2: Internal.GeoBone_, arg3: Internal.RenderType_, arg4: Internal.MultiBufferSource_, arg5: Internal.VertexConsumer_, arg6: boolean, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number): void;
        "scaleModelForRender(float,float,com.mojang.blaze3d.vertex.PoseStack,java.lang.Object,software.bernie.geckolib.cache.object.BakedGeoModel,boolean,float,int,int)"(widthScale: number, heightScale: number, poseStack: Internal.PoseStack_, animatable: T, model: Internal.BakedGeoModel_, isReRender: boolean, partialTick: number, packedLight: number, packedOverlay: number): void;
        withScale(arg0: number): Internal.GeoEntityRenderer<T>;
        equals(arg0: any): boolean;
        renderCubesOfBone(arg0: Internal.PoseStack_, arg1: Internal.GeoBone_, arg2: Internal.VertexConsumer_, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): void;
        get scaleHeight(): number
        get geoModel(): Internal.GeoModel<T>
        get renderLayers(): Internal.List<Internal.GeoRenderLayer<T>>
        get scaleWidth(): number
        get class(): typeof any
        get animatable(): Internal.GeoAnimatable
        get font(): net.minecraft.client.gui.Font
    }
    type KubeJSEntityRenderer_<T extends Internal.LivingEntity & Internal.IAnimatableJS> = KubeJSEntityRenderer<T>;
    class CherryLeavesBlock extends Internal.LeavesBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isShearable(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        onSheared(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: BlockPos_, arg4: number): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getOptionalDistanceAt(arg0: Internal.BlockState_): Internal.OptionalInt;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        /**
         * @deprecated
        */
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type CherryLeavesBlock_ = CherryLeavesBlock;
    class Gauntlet_of_Bulwark extends Internal.Item implements Internal.More_Tool_Attribute {
        constructor(arg0: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type Gauntlet_of_Bulwark_ = Gauntlet_of_Bulwark;
    interface LootItemCondition$Builder {
        and(arg0: Internal.LootItemCondition$Builder_): Internal.AllOfCondition$Builder;
        abstract build(): Internal.LootItemCondition;
        invert(): this;
        or(arg0: Internal.LootItemCondition$Builder_): Internal.AnyOfCondition$Builder;
        (): Internal.LootItemCondition_;
    }
    type LootItemCondition$Builder_ = LootItemCondition$Builder | (()=> Internal.LootItemCondition_);
    class VineBlock extends Internal.Block implements Internal.IForgeShearable {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isShearable(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: BlockPos_): boolean;
        canSupportAtFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        /**
         * @deprecated
        */
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        /**
         * @deprecated
        */
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        static getPropertyForFace(arg0: Internal.Direction_): Internal.BooleanProperty;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static isAcceptableNeighbour(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        onSheared(arg0: Internal.Player_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: BlockPos_, arg4: number): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
        static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly PROPERTY_BY_DIRECTION: ({[key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty, [key: Internal.Direction]: Internal.BooleanProperty}) & (Internal.Map<Internal.Direction, Internal.BooleanProperty>);
        static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
        static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    }
    type VineBlock_ = VineBlock;
    class MinionSummonMobEffect extends Internal.MobEffect {
        constructor()
        getDisplayName(): net.minecraft.network.chat.Component;
        getClass(): typeof any;
        addAttributeModifier(arg0: Internal.Attribute_, arg1: string, arg2: number, arg3: Internal.AttributeModifier$Operation_): Internal.MobEffect;
        addAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        isInstantenous(): boolean;
        applyInstantenousEffect(arg0: Internal.Entity_, arg1: Internal.Entity_, arg2: Internal.LivingEntity_, arg3: number, arg4: number): void;
        notify(): void;
        isBeneficial(): boolean;
        wait(arg0: number, arg1: number): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientMobEffectExtensions>): void;
        getEffectRendererInternal(): any;
        getColor(): number;
        removeAttributeModifiers(arg0: Internal.LivingEntity_, arg1: Internal.AttributeMap_, arg2: number): void;
        applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        getAttributeModifierValue(arg0: number, arg1: Internal.AttributeModifier_): number;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        static getIdFromNullable(arg0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        toString(): string;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        notifyAll(): void;
        setFactorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): Internal.MobEffect;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId(arg0: number): Internal.MobEffect;
        hashCode(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        wait(): void;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        isDurationEffectTick(arg0: number, arg1: number): boolean;
        static getId(arg0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get class(): typeof any
        get instantenous(): boolean
        get beneficial(): boolean
        get effectRendererInternal(): any
        get color(): number
        get descriptionId(): string
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        set factorDataFactory(arg0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
    }
    type MinionSummonMobEffect_ = MinionSummonMobEffect;
    interface Byte2CharFunction extends Internal.IntUnaryOperator, it.unimi.dsi.fastutil.Function<number, string> {
        getOrDefault(arg0: number, arg1: string): string;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2CharFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        /**
         * @deprecated
        */
        "put(java.lang.Byte,java.lang.Character)"(arg0: number, arg1: string): string;
        "remove(byte)"(arg0: number): string;
        /**
         * @deprecated
        */
        "getOrDefault(java.lang.Object,java.lang.Character)"(arg0: any, arg1: string): string;
        "compose(java.util.function.IntUnaryOperator)"(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        "put(java.lang.Object,java.lang.Object)"(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        "get(java.lang.Object)"(arg0: any): string;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Byte2ByteFunction;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Byte2IntFunction;
        /**
         * @deprecated
        */
        "andThen(java.util.function.Function)"<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<number, T>;
        remove(arg0: number): string;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2CharFunction;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2CharFunction;
        "put(byte,char)"(arg0: number, arg1: string): string;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2CharFunction;
        abstract "get(byte)"(arg0: number): string;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        "containsKey(java.lang.Object)"(arg0: any): boolean;
        /**
         * @deprecated
        */
        "remove(java.lang.Object)"(arg0: any): any;
        abstract get(arg0: number): string;
        "containsKey(byte)"(arg0: number): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        "getOrDefault(byte,char)"(arg0: number, arg1: string): string;
        defaultReturnValue(): string;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Byte2LongFunction;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        "andThen(java.util.function.IntUnaryOperator)"(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2CharFunction;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Byte2FloatFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        "getOrDefault(java.lang.Object,java.lang.Object)"(arg0: any, arg1: any): any;
        defaultReturnValue(arg0: string): void;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        get(arg0: any): string;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        "compose(java.util.function.Function)"<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, string>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2CharFunction;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Byte2DoubleFunction;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Byte2ReferenceFunction<T>;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Byte2ObjectFunction<T>;
        size(): number;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2CharFunction<T>;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: string): string;
        apply(arg0: number): string;
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2CharFunction;
        put(arg0: number, arg1: string): string;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Byte2ShortFunction;
    }
    type Byte2CharFunction_ = Byte2CharFunction;
    class LootrTrappedChestBlock extends Internal.ChestBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        getExplosionResistance(): number;
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        blockEntityType(): Internal.BlockEntityType<Internal.ChestBlockEntity>;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        static getContainer(arg0: Internal.ChestBlock_, arg1: Internal.BlockState_, arg2: Internal.Level_, arg3: BlockPos_, arg4: boolean): net.minecraft.world.Container;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        setIsRandomlyTicking(arg0: boolean): void;
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        /**
         * @deprecated
        */
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        combine(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: boolean): Internal.DoubleBlockCombiner$NeighborCombineResult<Internal.ChestBlockEntity>;
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        static isChestBlockedAt(arg0: Internal.LevelAccessor_, arg1: BlockPos_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        static getConnectedDirection(arg0: Internal.BlockState_): Internal.Direction;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static getBlockType(arg0: Internal.BlockState_): Internal.DoubleBlockCombiner$BlockType;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        static opennessCombiner(arg0: Internal.LidBlockEntity_): Internal.DoubleBlockCombiner$Combiner<Internal.ChestBlockEntity, Internal.Float2FloatFunction>;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type LootrTrappedChestBlock_ = LootrTrappedChestBlock;
    class Dreamnotes4Item extends Internal.Item {
        constructor()
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        hasCraftingRemainingItem(): boolean;
        getDescription(): net.minecraft.network.chat.Component;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        setNameKey(arg0: string): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type Dreamnotes4Item_ = Dreamnotes4Item;
    class ItemFrameItem extends Internal.HangingEntityItem {
        constructor(arg0: Internal.EntityType_<Internal.HangingEntity>, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getEntityType(): Internal.EntityType<any>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get entityType(): Internal.EntityType<any>
        /**
         * @deprecated
        */
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type ItemFrameItem_ = ItemFrameItem;
    abstract class NightmareMantleoftheNightItem extends Internal.ArmorItem {
        constructor(arg0: Internal.ArmorItem$Type_, arg1: Internal.Item$Properties_)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        setRarity(arg0: Internal.Rarity_): void;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        getType(): Internal.ArmorItem$Type;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        isFireResistant(): boolean;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setBurnTime(i: number): void;
        setMaxStackSize(arg0: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getDescription(): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        kjs$getAttributeMap(): Internal.Multimap<any, any>;
        getDefense(): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        setAttackDamage(attackDamage: number): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getEquipmentSlot(): EquipmentSlot;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        toString(): string;
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        isFoil(arg0: Internal.ItemStack_): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        static dispenseArmor(arg0: Internal.BlockSource_, arg1: Internal.ItemStack_): boolean;
        getMaterial(): Internal.ArmorMaterial;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        notify(): void;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        getEquipSound(): Internal.SoundEvent;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        getDamage(arg0: Internal.ItemStack_): number;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        wait(arg0: number, arg1: number): void;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getToughness(): number;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        kjs$setAttributeMap(arg0: Internal.Multimap_<any, any>): void;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        get drinkingSound(): Internal.SoundEvent
        set rarity(arg0: Internal.Rarity_)
        get type(): Internal.ArmorItem$Type
        get fireResistant(): boolean
        get complex(): boolean
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get descriptionId(): string
        get creativeTab(): string
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set burnTime(i: number)
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get itemBuilder(): Internal.ItemBuilder
        /**
         * @deprecated
        */
        get maxDamage(): number
        get description(): net.minecraft.network.chat.Component
        get class(): typeof any
        get renderPropertiesInternal(): any
        get defense(): number
        set itemBuilder(b: Internal.ItemBuilder_)
        set realGetEnchantmentValueFn(arg0: Internal.Function_<any, any>)
        set craftingRemainingItemFTBL(arg0: Internal.Item_)
        set attackDamage(attackDamage: number)
        get edible(): boolean
        get equipmentSlot(): EquipmentSlot
        get enchantmentValue(): number
        set armorToughness(armorToughness: number)
        get id(): string
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get digSpeed(): number
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set "foodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_)
        get material(): Internal.ArmorMaterial
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get equipSound(): Internal.SoundEvent
        /**
         * @deprecated
        */
        get maxStackSize(): number
        set "foodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        set fireResistant(arg0: boolean)
        get eatingSound(): Internal.SoundEvent
        set nameKey(arg0: string)
        get toughness(): number
        get idLocation(): ResourceLocation
        get mod(): string
        set armorProtection(armorProtection: number)
        /**
         * @deprecated
        */
        get craftingRemainingItem(): Internal.Item
        get typeItemStackKey(): Internal.ItemStackKey
        set foodProperties(arg0: Internal.FoodProperties_)
        set craftingRemainder(arg0: Internal.Item_)
        set realIsEnchantable(arg0: Internal.Predicate_<any>)
    }
    type NightmareMantleoftheNightItem_ = NightmareMantleoftheNightItem;
    abstract class RaytracingUtil {
        constructor()
        getClass(): typeof any;
        getEntityParams(arg0: Internal.Entity_): org.apache.commons.lang3.tuple.Pair<Vec3d, Vec3d>;
        rayTrace(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.ClipContext$Block_, arg4: Internal.ClipContext$Fluid_): Internal.HitResult;
        toString(): string;
        abstract getEntityRange(arg0: Internal.LivingEntity_): number;
        notifyAll(): void;
        "rayTrace(net.minecraft.world.entity.Entity,net.minecraft.world.level.Level,net.minecraft.world.phys.Vec3,net.minecraft.world.phys.Vec3,net.minecraft.world.level.ClipContext$Block,net.minecraft.world.level.ClipContext$Fluid)"(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Vec3d_, arg3: Vec3d_, arg4: Internal.ClipContext$Block_, arg5: Internal.ClipContext$Fluid_): Internal.HitResult;
        notify(): void;
        "rayTrace(net.minecraft.world.entity.Entity,net.minecraft.world.level.Level,net.minecraft.world.entity.Entity,net.minecraft.world.level.ClipContext$Block,net.minecraft.world.level.ClipContext$Fluid,double)"(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: Internal.ClipContext$Block_, arg4: Internal.ClipContext$Fluid_, arg5: number): Internal.HitResult;
        wait(arg0: number, arg1: number): void;
        rayTrace(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Vec3d_, arg3: Vec3d_, arg4: Internal.ClipContext$Block_, arg5: Internal.ClipContext$Fluid_, arg6: number): Internal.HitResult;
        hashCode(): number;
        rayTrace(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Vec3d_, arg3: Vec3d_, arg4: Internal.ClipContext$Block_, arg5: Internal.ClipContext$Fluid_): Internal.HitResult;
        wait(): void;
        rayTrace(arg0: Internal.Entity_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: Internal.ClipContext$Block_, arg4: Internal.ClipContext$Fluid_, arg5: number): Internal.HitResult;
        wait(arg0: number): void;
        equals(arg0: any): boolean;
        get class(): typeof any
    }
    type RaytracingUtil_ = RaytracingUtil;
    class FakeTrackBlock extends Internal.Block implements Internal.ProperWaterloggedBlock, Internal.EntityBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        /**
         * @deprecated
        */
        getSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        /**
         * @deprecated
        */
        getVisualShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number, arg5: number): void;
        static popResource(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.ItemStack_): void;
        setRandomTickCallback(callback: Internal.Consumer_<any>): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        stepOn(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Entity_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        /**
         * @deprecated
        */
        getExplosionResistance(): number;
        asItem(): Internal.Item;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        triggerEvent(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: number, arg4: number): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_, arg6: boolean): void;
        setFriction(arg0: number): void;
        getTypeData(): Internal.CompoundTag;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        getRenderShape(arg0: Internal.BlockState_): Internal.RenderShape;
        getSpeedFactor(): number;
        /**
         * @deprecated
        */
        getLightBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        playerDestroy(arg0: Internal.Level_, arg1: Internal.Player_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BlockEntity_, arg5: Internal.ItemStack_): void;
        isPossibleToRespawnInThis(arg0: Internal.BlockState_): boolean;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        playerWillDestroy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Player_): void;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        getClass(): typeof any;
        getMaxVerticalOffset(): number;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        getRenderPropertiesInternal(): any;
        needsDynamicNodeTypeCheck(): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        /**
         * @deprecated
        */
        getDrops(arg0: Internal.BlockState_, arg1: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        getStateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        /**
         * @deprecated
        */
        entityInside(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): void;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientBlockExtensions>): void;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        withWater(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): Internal.BlockState;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        puzzleslib$setItem(arg0: Internal.Item_): void;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Block>;
        static popResourceFromFace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.ItemStack_): void;
        handlePrecipitation(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Biome$Precipitation_): void;
        wait(arg0: number): void;
        getFluidState(arg0: Internal.BlockState_): Internal.FluidState;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        /**
         * @deprecated
        */
        tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Block_, arg4: BlockPos_, arg5: boolean): void;
        /**
         * @deprecated
        */
        getBlockSupportShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        isCollisionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        /**
         * @deprecated
        */
        getMenuProvider(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): Internal.MenuProvider;
        static byItem(arg0: Internal.Item_): Internal.Block;
        static updateFromNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_): Internal.BlockState;
        /**
         * @deprecated
        */
        updateIndirectNeighbourShapes(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: number, arg4: number): void;
        destroy(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): void;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        /**
         * @deprecated
        */
        use(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        setLightEmission(v: number): void;
        setJumpFactor(arg0: number): void;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        getShadeBrightness(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        /**
         * @deprecated
        */
        getCollisionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        defaultBlockState(): Internal.BlockState;
        getStateForPlacement(arg0: Internal.BlockPlaceContext_): Internal.BlockState;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        wait(): void;
        getMaxHorizontalOffset(): number;
        /**
         * @deprecated
        */
        getDestroyProgress(arg0: Internal.BlockState_, arg1: Internal.Player_, arg2: Internal.BlockGetter_, arg3: BlockPos_): number;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        updateShape(arg0: Internal.BlockState_, arg1: Internal.Direction_, arg2: Internal.BlockState_, arg3: Internal.LevelAccessor_, arg4: BlockPos_, arg5: BlockPos_): Internal.BlockState;
        isRandomlyTicking(arg0: Internal.BlockState_): boolean;
        static isShapeFullBlock(shape: Internal.VoxelShape_): boolean;
        withPropertiesOf(arg0: Internal.BlockState_): Internal.BlockState;
        setIsRandomlyTicking(arg0: boolean): void;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.BlockState_, arg1: Internal.Rotation_): Internal.BlockState;
        defaultMapColor(): Internal.MapColor;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        setNameKey(arg0: string): void;
        static box(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.VoxelShape;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        static withWater(arg0: Internal.LevelAccessor_, arg1: Internal.BlockState_, arg2: BlockPos_): Internal.BlockState;
        updateEntityAfterFallOn(arg0: Internal.BlockGetter_, arg1: Internal.Entity_): void;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        arch$registryName(): ResourceLocation;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        isSignalSource(arg0: Internal.BlockState_): boolean;
        /**
         * @deprecated
        */
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_, arg4: Internal.Entity_, arg5: Internal.ItemStack_): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        isOcclusionShapeFullBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        static getId(arg0: Internal.BlockState_): number;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.level.material.Fluid)"(arg0: Internal.BlockState_, arg1: Internal.Fluid_): boolean;
        canSustainPlant(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.IPlantable_): boolean;
        /**
         * @deprecated
        */
        isPathfindable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.PathComputationType_): boolean;
        setSoundType(arg0: SoundType_): void;
        /**
         * @deprecated
        */
        onRemove(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        equals(arg0: any): boolean;
        /**
         * @deprecated
        */
        getOcclusionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        /**
         * @deprecated
        */
        getSoundType(arg0: Internal.BlockState_): SoundType;
        randomTick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.BlockEntity_): void;
        static canSupportRigidBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        static keepAlive(arg0: Internal.LevelAccessor_, arg1: BlockPos_): void;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        getDescriptionId(): string;
        needsDynamicBurningCheck(): boolean;
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        fallOn(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.Entity_, arg4: number): void;
        handler$bkp000$postConstruct(p_i241196_1_: Internal.BlockBehaviour$Properties_, ci: Internal.CallbackInfo_): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getJumpFactor(): number;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        static canSupportCenter(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        getDirectSignal(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        /**
         * @deprecated
        */
        "canBeReplaced(net.minecraft.world.level.block.state.BlockState,net.minecraft.world.item.context.BlockPlaceContext)"(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        updateWater(arg0: Internal.LevelAccessor_, arg1: Internal.BlockState_, arg2: BlockPos_): void;
        /**
         * @deprecated
        */
        useShapeForLightOcclusion(arg0: Internal.BlockState_): boolean;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setSpeedFactor(arg0: number): void;
        handler$eip000$quark$tick(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.RandomSource_, arg4: Internal.CallbackInfo_): void;
        setExplosionResistance(arg0: number): void;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        toString(): string;
        notifyAll(): void;
        getId(): string;
        getLootTable(): ResourceLocation;
        /**
         * @deprecated
        */
        getInteractionShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): Internal.VoxelShape;
        propagatesSkylightDown(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setPlacedBy(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.LivingEntity_, arg4: Internal.ItemStack_): void;
        /**
         * @deprecated
        */
        onPlace(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: boolean): void;
        getFriction(): number;
        /**
         * @deprecated
        */
        hasAnalogOutputSignal(arg0: Internal.BlockState_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        /**
         * @deprecated
        */
        getAnalogOutputSignal(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): number;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        notify(): void;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        static isFaceFull(arg0: Internal.VoxelShape_, arg1: Internal.Direction_): boolean;
        fluidState(arg0: Internal.BlockState_): Internal.FluidState;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        /**
         * @deprecated
        */
        canSurvive(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        static dropResources(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_): void;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        /**
         * @deprecated
        */
        getCloneItemStack(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        hasDynamicShape(): boolean;
        /**
         * @deprecated
        */
        getSeed(arg0: Internal.BlockState_, arg1: BlockPos_): number;
        defaultDestroyTime(): number;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        dropFromExplosion(arg0: Internal.Explosion_): boolean;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        static isExceptionForConnection(arg0: Internal.BlockState_): boolean;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        wait(arg0: number, arg1: number): void;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.BlockGetter_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        mirror(arg0: Internal.BlockState_, arg1: Internal.Mirror_): Internal.BlockState;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        wasExploded(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Explosion_): void;
        getName(): Internal.MutableComponent;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        animateTick(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.RandomSource_): void;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        /**
         * @deprecated
        */
        canBeReplaced(arg0: Internal.BlockState_, arg1: Internal.BlockPlaceContext_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        static updateOrDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: number): void;
        /**
         * @deprecated
        */
        attack(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): void;
        getShape(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.CollisionContext_): Internal.VoxelShape;
        static stateById(arg0: number): Internal.BlockState;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        popExperience(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: number): void;
        static pushEntitiesUp(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_): Internal.BlockState;
        static getDrops(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.List<Internal.ItemStack>;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        setHasCollision(arg0: boolean): void;
        static shouldRenderFace(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: BlockPos_): boolean;
        /**
         * @deprecated
        */
        spawnAfterBreak(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.ItemStack_, arg4: boolean): void;
        set randomTickCallback(callback: Internal.Consumer_<any>)
        /**
         * @deprecated
        */
        get explosionResistance(): number
        set friction(arg0: number)
        get typeData(): Internal.CompoundTag
        get speedFactor(): number
        get class(): typeof any
        get maxVerticalOffset(): number
        get renderPropertiesInternal(): any
        get stateDefinition(): Internal.StateDefinition<Internal.Block, Internal.BlockState>
        set blockBuilder(b: Internal.BlockBuilder_)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        set jumpFactor(arg0: number)
        get maxHorizontalOffset(): number
        set isRandomlyTicking(arg0: boolean)
        set nameKey(arg0: string)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set soundType(arg0: SoundType_)
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get descriptionId(): string
        get jumpFactor(): number
        set speedFactor(arg0: number)
        set explosionResistance(arg0: number)
        get id(): string
        get lootTable(): ResourceLocation
        get friction(): number
        set destroySpeed(v: number)
        get name(): Internal.MutableComponent
        get mod(): string
        set hasCollision(arg0: boolean)
    }
    type FakeTrackBlock_ = FakeTrackBlock;
    class RefillUpgradeItem extends Internal.UpgradeItemBase<Internal.RefillUpgradeWrapper> {
        constructor(arg0: Internal.IntSupplier_, arg1: boolean, arg2: boolean)
        getDrinkingSound(): Internal.SoundEvent;
        modifyReturnValue$eki000$overrideOtherStackedOnMe(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.ItemStack_, arg3: Internal.Slot_, arg4: Internal.ClickAction_, arg5: Internal.Player_, arg6: Internal.SlotAccess_): boolean;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        getDestroySpeed(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): number;
        isFireResistant(): boolean;
        getUpgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(arg0: Internal.IStorageWrapper_, arg1: boolean, arg2: Internal.Player_): Internal.UpgradeSlotChangeResult;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        appendHoverText(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_): void;
        /**
         * @deprecated
        */
        getFoodProperties(): Internal.FoodProperties;
        getInventoryColumnsTaken(): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        asItem(): Internal.Item;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        getDefaultInstance(): Internal.ItemStack;
        getTypeData(): Internal.CompoundTag;
        canAddUpgradeTo(arg0: Internal.IStorageWrapper_, arg1: Internal.ItemStack_, arg2: boolean, arg3: boolean): Internal.UpgradeSlotChangeResult;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setMaxStackSize(arg0: number): void;
        getBarWidth(arg0: Internal.ItemStack_): number;
        setMaxDamage(arg0: number): void;
        getBarColor(arg0: Internal.ItemStack_): number;
        getItem(): Internal.Item;
        mfix$setDelegate(registryKey: Internal.ResourceKey_<any>, holder: Internal.Holder$Reference_<any>): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        /**
         * @deprecated
        */
        hasCraftingRemainingItem(): boolean;
        asIngredient(): Internal.Ingredient;
        getClass(): typeof any;
        mfix$getDelegate(registryKey: Internal.ResourceKey_<any>): Internal.Holder$Reference<any>;
        static byId(arg0: number): Internal.Item;
        getRenderPropertiesInternal(): any;
        interactLivingEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.LivingEntity_, arg3: Internal.InteractionHand_): Internal.InteractionResult;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        setCraftingRemainingItemFTBL(arg0: Internal.Item_): void;
        getTooltipImage(arg0: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isEdible(): boolean;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        modifyReturnValue$eki000$overrideStackedOnOther(arg0: boolean, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_): boolean;
        getUpgradeGroup(): Internal.UpgradeGroup;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        wait(arg0: number): void;
        checkExtraInsertConditions(arg0: Internal.ItemStack_, arg1: Internal.IStorageWrapper_, arg2: boolean, arg3: number, arg4: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        isFoil(arg0: Internal.ItemStack_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        useOnRelease(arg0: Internal.ItemStack_): boolean;
        canAttackBlock(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        getDescriptionId(arg0: Internal.ItemStack_): string;
        releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        setAttackSpeed(attackSpeed: number): void;
        getUseDuration(arg0: Internal.ItemStack_): number;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getName(): net.minecraft.network.chat.Component;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        canFitInsideContainerItems(): boolean;
        wait(): void;
        "setFoodProperties(java.util.function.Consumer)"(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        setFireResistant(arg0: boolean): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        initializeClient(arg0: Internal.Consumer_<Internal.IClientItemExtensions>): void;
        mineBlock(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.BlockState_, arg3: BlockPos_, arg4: Internal.LivingEntity_): boolean;
        setNameKey(arg0: string): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): EquipmentSlot;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getName(arg0: Internal.ItemStack_): net.minecraft.network.chat.Component;
        /**
         * @deprecated
        */
        getDefaultAttributeModifiers(arg0: EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$registryName(): ResourceLocation;
        getIdLocation(): ResourceLocation;
        getAttributeModifiers(arg0: EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getUpgradesPerStorage(arg0: string): number;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        canSwapUpgradeFor(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.IStorageWrapper_, arg3: boolean): Internal.UpgradeSlotChangeResult;
        inventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Entity_, arg3: number, arg4: boolean): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        shouldOverrideMultiplayerNbt(): boolean;
        static getId(arg0: Internal.Item_): number;
        overrideOtherStackedOnMe(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.Slot_, arg3: Internal.ClickAction_, arg4: Internal.Player_, arg5: Internal.SlotAccess_): boolean;
        setFoodProperties(arg0: Internal.FoodProperties_): void;
        setCraftingRemainder(arg0: Internal.Item_): void;
        canRemoveUpgradeFrom(arg0: Internal.IStorageWrapper_, arg1: boolean): Internal.UpgradeSlotChangeResult;
        static getPlayerPOVHitResult(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        equals(arg0: any): boolean;
        setRarity(arg0: Internal.Rarity_): void;
        allowsTargetSlotSelection(): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        /**
         * @deprecated
        */
        onDestroyed(arg0: Internal.ItemEntity_): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): Internal.InteractionResult;
        isComplex(): boolean;
        onCraftedBy(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        checkThisForConflictsWithExistingUpgrades(arg0: Internal.ItemStack_, arg1: Internal.IStorageWrapper_, arg2: number): Internal.UpgradeSlotChangeResult;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        onUseTick(arg0: Internal.Level_, arg1: Internal.LivingEntity_, arg2: Internal.ItemStack_, arg3: number): void;
        canBeHurtBy(arg0: DamageSource_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        getUseAnimation(arg0: Internal.ItemStack_): Internal.UseAnim;
        getDescriptionId(): string;
        isValidRepairItem(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        zeta$setHumanoidArmorModel(arg0: Internal.HumanoidArmorModelGetter_): void;
        getCreativeTab(): string;
        getType(): Internal.UpgradeType<Internal.RefillUpgradeWrapper>;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        setBurnTime(i: number): void;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        getItemBuilder(): Internal.ItemBuilder;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxDamage(): number;
        getDescription(): net.minecraft.network.chat.Component;
        addCreativeTabItems(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        useOn(arg0: Internal.UseOnContext_): Internal.InteractionResult;
        getRarity(arg0: Internal.ItemStack_): Internal.Rarity;
        setItemBuilder(b: Internal.ItemBuilder_): void;
        setRealGetEnchantmentValueFn(arg0: Internal.Function_<any, any>): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        setAttackDamage(attackDamage: number): void;
        arch$holder(): Internal.Holder<Internal.Item>;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: EquipmentSlot_, arg3: string): string;
        toString(): string;
        /**
         * @deprecated
        */
        getEnchantmentValue(): number;
        setArmorToughness(armorToughness: number): void;
        notifyAll(): void;
        getId(): string;
        checkExtraInsertConditions(arg0: Internal.ItemStack_, arg1: Internal.IStorageWrapper_, arg2: boolean, arg3: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        isEnchantable(arg0: Internal.ItemStack_): boolean;
        getSweepHitBox(stack: Internal.ItemStack_, player: Internal.Player_, target: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getDigSpeed(): number;
        overrideStackedOnOther(arg0: Internal.ItemStack_, arg1: Internal.Slot_, arg2: Internal.ClickAction_, arg3: Internal.Player_): boolean;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        "setFoodProperties(net.minecraft.world.food.FoodProperties)"(arg0: Internal.FoodProperties_): void;
        isRepairable(arg0: Internal.ItemStack_): boolean;
        puzzleslib$setRenderProperties(arg0: any): void;
        notify(): void;
        getCleanedUpgradeStack(arg0: Internal.ItemStack_): Internal.ItemStack;
        isBarVisible(arg0: Internal.ItemStack_): boolean;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        static byBlock(arg0: Internal.Block_): Internal.Item;
        zeta$setBlockEntityWithoutLevelRenderer(arg0: Internal.BlockEntityWithoutLevelRenderer_): void;
        bookshelf$setCraftingRemainder(arg0: Internal.Item_): void;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        isCorrectToolForDrops(arg0: Internal.BlockState_): boolean;
        verifyTagAfterLoad(arg0: Internal.CompoundTag_): void;
        canEquip(arg0: Internal.ItemStack_, arg1: EquipmentSlot_, arg2: Internal.Entity_): boolean;
        finishUsingItem(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): Internal.ItemStack;
        supportsBlockPick(): boolean;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        getEatingSound(): Internal.SoundEvent;
        puzzleslib$getRenderProperties(): any;
        canBeDepleted(): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        wait(arg0: number, arg1: number): void;
        getUpgradesInGroupPerStorage(arg0: string): number;
        getMod(): string;
        /**
         * @deprecated
        */
        builtInRegistryHolder(): Internal.Holder$Reference<Internal.Item>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        hurtEnemy(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: Internal.LivingEntity_): boolean;
        /**
         * @deprecated
        */
        getCraftingRemainingItem(): Internal.Item;
        realIsEnchantable(arg0: Internal.ItemStack_): boolean;
        getTypeItemStackKey(): Internal.ItemStackKey;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        requiredFeatures(): Internal.FeatureFlagSet;
        hashCode(): number;
        setRealIsEnchantable(arg0: Internal.Predicate_<any>): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        get drinkingSound(): Internal.SoundEvent
        get fireResistant(): boolean
        get upgradeConflicts(): Internal.List<Internal.IUpgradeItem$UpgradeConflictDefinition>
        get filterSlotCount(): number
        /**
         * @deprecated
        */
        get foodProperties(): Internal.FoodProperties
        get inventoryColumnsTaken(): number
        get defaultInstance(): Internal.ItemStack
        get typeData(): Internal.CompoundTag
        set maxStackSize(arg0: number)
        set maxDamage(arg0: number)
        get item(): Internal.Item
        get class(): typeof any
        get renderProperties