/// <reference path="./internals/internal_*.d.ts" />
declare class SummoningOutput {
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    static item(o: any): Internal.RecipeOutputs$ItemOutputBuilder;
    wait(arg0: number): void;
    static mob(o: any): Internal.RecipeOutputs$MobOutputBuilder;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type SummoningOutput_ = SummoningOutput;
declare class DataTickets {
    constructor()
    getClass(): typeof any;
    static byName(arg0: string): Internal.SerializableDataTicket<any>;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    static registerSerializable<D>(arg0: Internal.SerializableDataTicket_<D>): Internal.SerializableDataTicket<D>;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly USE_TICKS: Internal.SerializableDataTicket<number>;
    static readonly DIRECTION: Internal.SerializableDataTicket<Internal.Direction>;
    static readonly ENTITY: Internal.DataTicket<Internal.Entity>;
    static readonly ANIM: Internal.SerializableDataTicket<string>;
    static readonly ITEMSTACK: Internal.DataTicket<Internal.ItemStack>;
    static readonly CLOSED: Internal.SerializableDataTicket<boolean>;
    static readonly ACTIVE: Internal.SerializableDataTicket<boolean>;
    static readonly TICK: Internal.DataTicket<number>;
    static readonly ITEM_RENDER_PERSPECTIVE: Internal.DataTicket<Internal.ItemDisplayContext>;
    static readonly EQUIPMENT_SLOT: Internal.DataTicket<EquipmentSlot>;
    static readonly ENTITY_MODEL_DATA: Internal.DataTicket<Internal.EntityModelData>;
    static readonly ANIM_STATE: Internal.SerializableDataTicket<number>;
    static readonly BLOCK_ENTITY: Internal.DataTicket<Internal.BlockEntity>;
    static readonly OPEN: Internal.SerializableDataTicket<boolean>;
}
type DataTickets_ = DataTickets;
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    mutable(): Internal.BlockPos$MutableBlockPos;
    above(): this;
    offset(arg0: Vec3i_): this;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    asLong(): number;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    multiply(arg0: number): Vec3i;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    west(distance: number): this;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): Vec3i;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): Vec3i;
    west(): Vec3i;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    relative(arg0: Internal.Direction_): this;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    east(distance: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    above(distance: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): Vec3i;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    south(arg0: number): Vec3i;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    atY(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): Vec3i;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    relative(arg0: Internal.Direction_, arg1: number): this;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    offset(arg0: number, arg1: number, arg2: number): Vec3i;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    below(): Vec3i;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    cross(arg0: Vec3i_): Vec3i;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    south(): Vec3i;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    lengthSqr(): number;
    distanceToSqr(arg0: Vec3d_): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    x(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    scale(arg0: number): this;
    reverse(): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    subtract(arg0: number, arg1: number, arg2: number): this;
    zRot(arg0: number): this;
    normalize(): this;
    horizontalDistance(): number;
    get(arg0: Internal.Direction$Axis_): number;
    lerp(arg0: Vec3d_, arg1: number): this;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    cross(arg0: Vec3d_): this;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    notify(): void;
    compareTo(arg0: any): number;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    static isAllowedInResourceLocation(arg0: string): boolean;
    withPath(arg0: string): this;
    static tryParse(arg0: string): ResourceLocation;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static of(arg0: string, arg1: string): ResourceLocation;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    static bySeparator(arg0: string, arg1: string): ResourceLocation;
    static parse(arg0: string): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    wait(): void;
    static fromNamespaceAndPath(arg0: string, arg1: string): ResourceLocation;
    "compareTo(java.lang.Object)"(arg0: any): number;
    getClass(): typeof any;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    static isValidPath(arg0: string): boolean;
    static withDefaultNamespace(arg0: string): ResourceLocation;
    wait(arg0: number, arg1: number): void;
    setPath(arg0: string): void;
    "withPath(java.lang.String)"(arg0: string): this;
    getPath(): string;
    getNamespace(): string;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    static tryBySeparator(arg0: string, arg1: string): ResourceLocation;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare interface EntityJSUtils {
    /**
     * Creates a custom Move Control builder and returns it.
    */
    createMoveControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.MoveControlJSBuilder>): Internal.MoveControlJS;
    /**
     * Wall climbing entity path navigation
    */
    createWallClimberNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.WallClimberNavigation;
    /**
     * Creates a custom Jump Control builder and returns it.
    */
    createJumpControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.JumpControlJSBuilder>): Internal.JumpControlJS;
    /**
     * Flying entity path navigation
    */
    createFlyingPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.FlyingPathNavigation;
    /**
     * Creates a custom Look Control builder and returns it.
    */
    createLookControl(pMob: Internal.Mob_, consumer: Internal.Consumer_<Internal.LookControlJSBuilder>): Internal.LookControlJS;
    /**
     * Ground entity path navigation
    */
    createGroundPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.GroundPathNavigation;
    /**
     * Water bound entity path navigation
    */
    createWaterBoundPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.WaterBoundPathNavigation;
    /**
     * Amphibious entity path navigation
    */
    createAmphibiousPathNavigation(pMob: Internal.Mob_, pLevel: Internal.Level_): Internal.AmphibiousPathNavigation;
}
type EntityJSUtils_ = EntityJSUtils;
declare const EntityJSUtils: EntityJSUtils;
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    toJson(): Internal.JsonElement;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    validForMatching(): boolean;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({"create:andesite_alloy": InputItem, "minecraft:blaze_powder": InputItem, "create:mechanical_pump": InputItem, "minecraft:redstone": InputItem, "born_in_chaos_v1:holiday_candy": InputItem, "minecraft:bone": InputItem, "create:rotation_speed_controller": InputItem, "minecraft:creeper_head": InputItem, "minecraft:smithing_table": InputItem, "create:large_cogwheel": InputItem, "create:sturdy_sheet": InputItem, "minecraft:iron_ingot": InputItem, "minecraft:emerald": InputItem, "minecraft:ender_eye": InputItem, "create:minecart_coupling": InputItem, "16x minecraft:shroomlight": InputItem, "pasterdream:nightmare_fuel": InputItem, "pasterdream:titanium_ingot": InputItem, "create:propeller": InputItem, "minecraft:redstone_lamp": InputItem, "minecraft:ender_pearl": InputItem, "kubejs:space_gem": InputItem, "art_of_forging:forged_steel_ingot": InputItem, "sophisticatedbackpacks:stack_upgrade_tier_3": InputItem, "minecraft:wither_skeleton_skull": InputItem, "sophisticatedbackpacks:stack_upgrade_tier_2": InputItem, "faded_conquest_2:abyssal_device": InputItem, "sophisticatedbackpacks:stack_upgrade_tier_1": InputItem, "minecraft:blaze_rod": InputItem, "pasterdream:allkinds_ring": InputItem, "create:precision_mechanism": InputItem, "jerotesvillage:second_rounder_map": InputItem, "minecraft:cobblestone": InputItem, "minecraft:dragon_egg": InputItem, "create:railway_casing": InputItem, "create:extendo_grip": InputItem, "minecraft:dragon_head": InputItem, "diamond_sword": InputItem, "minecraft:glowstone_dust": InputItem, "minecraft:yellow_dye": InputItem, "minecraft:redstone_block": InputItem, "create:incomplete_precision_mechanism": InputItem, "create:encased_fan": InputItem, "faded_conquest_2:stormclasher_katana": InputItem, "born_in_chaos_v1:gummy_vampire_teeth": InputItem, "pasterdream:meltdream_crystal_0": InputItem, "minecraft:string": InputItem, "born_in_chaos_v1:mint_candy": InputItem, "minecraft:diamond_block": InputItem, "minecraft:netherite_scrap": InputItem, "minecraft:iron_block": InputItem, "pasterdream:blackmetal_ingot": InputItem, "create:brass_casing": InputItem, "minecraft:diamond": InputItem, "minecraft:water_bucket": InputItem, "pasterdream:pure_horror": InputItem, "create:empty_blaze_burner": InputItem, "quark:dragon_scale": InputItem, "create:chute": InputItem, "minecraft:phantom_membrane": InputItem, "quark:forgotten_hat": InputItem, "pasterdream:dyedream_ingot": InputItem, "minecraft:anvil": InputItem, "minecraft:quartz": InputItem, "born_in_chaos_v1:caramel_pepper": InputItem, "tetra:chthonic_extractor": InputItem, "create:cogwheel": InputItem, "minecraft:red_wool": InputItem, "minecraft:gold_block": InputItem, "pasterdream:sculk_heart": InputItem, "create:mechanical_saw": InputItem, "minecraft:zombie_head": InputItem, "create:golden_sheet": InputItem, "minecraft:skeleton_skull": InputItem, "pasterdream:charged_amethyst": InputItem, "create:fluid_tank": InputItem, "minecraft:white_wool": InputItem, "create:large_water_wheel": InputItem, "16x minecraft:glowstone": InputItem, "pasterdream:white_crystal": InputItem, "minecraft:fire_charge": InputItem, "minecraft:gold_ingot": InputItem, "faded_conquest_2:eye_of_the_storm": InputItem, "kubejs:jing_jin": InputItem, "kubejs:jing_tie": InputItem, "faded_conquest_2:war_claymore": InputItem, "pasterdream:pulse_windrunner_crystal": InputItem, "born_in_chaos_v1:intoxicating_decoction": InputItem, "16x minecraft:chorus_fruit": InputItem, "minecraft:netherite_sword": InputItem, "born_in_chaos_v1:seedof_chaos": InputItem}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly NONE: (Internal.NoColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly GOLD: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, dev.latvian.mods.rhino.mod.util.color.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly AQUA: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO implements Internal.IJsonIO {
    constructor()
    static findJsonInDirectory(path: Internal.Path_): Internal.Path[];
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static read(pPath: Internal.Path_, reader: Internal.IJsonIO$JsonReader_): void;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static jsjs$write(path: Internal.Path_, json: Internal.JsonElement_): void;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    static writeAndCreateDirectories(path: Internal.Path_, json: Internal.JsonObject_): void;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
declare abstract class KeyModifier extends Internal.Enum<KeyModifier> {
    getClass(): typeof any;
    abstract matches(arg0: Internal.InputConstants$Key_): boolean;
    abstract isActive(arg0: Internal.IKeyConflictContext_): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    "compareTo(net.minecraftforge.client.settings.KeyModifier)"(arg0: KeyModifier_): number;
    compareTo(arg0: any): number;
    static getValues(arg0: boolean): Internal.List<KeyModifier>;
    compareTo(arg0: KeyModifier_): number;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<KeyModifier>>;
    static getModifier(arg0: Internal.InputConstants$Key_): KeyModifier;
    abstract getCombinedName(arg0: Internal.InputConstants$Key_, arg1: Internal.Supplier_<net.minecraft.network.chat.Component>): net.minecraft.network.chat.Component;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    toString(): string;
    static valueOf(arg0: string): KeyModifier;
    notifyAll(): void;
    static valueFromString(arg0: string): KeyModifier;
    static values(): KeyModifier[];
    name(): string;
    hashCode(): number;
    static isKeyCodeModifier(arg0: Internal.InputConstants$Key_): boolean;
    ordinal(): number;
    wait(): void;
    getDeclaringClass(): typeof KeyModifier;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    static getActiveModifier(): KeyModifier;
    get class(): typeof any
    get declaringClass(): typeof KeyModifier
    /**
     * @deprecated
     * This method is marked to be removed in future!
    */
    get activeModifier(): KeyModifier
    static readonly NONE: KeyModifier;
    static readonly ALT: KeyModifier;
    static readonly SHIFT: KeyModifier;
    /**
     * @deprecated
     * This field is marked to be removed in future!
    */
    static readonly MODIFIER_VALUES: KeyModifier[];
    static readonly CONTROL: KeyModifier;
}
type KeyModifier_ = "alt" | KeyModifier | "control" | "shift" | "none";
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (dev.latvian.mods.rhino.mod.util.color.Color);
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalize(arg0: Quaternionf_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    lengthSquared(): number;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    get(arg0: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class GLFW {
    static glfwInitHint(arg0: number, arg1: number): void;
    static glfwGetWindowSize(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static nglfwGetGamepadState(arg0: number, arg1: number): number;
    static nglfwGetError(arg0: number): number;
    static "glfwGetProcAddress(java.lang.CharSequence)"(arg0: Internal.CharSequence_): number;
    static glfwGetJoystickButtons(arg0: number): Internal.ByteBuffer;
    static glfwGetCursorPos(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwSetWindowPos(arg0: number, arg1: number, arg2: number): void;
    static nglfwGetProcAddress(arg0: number): number;
    static glfwGetPlatform(): number;
    static glfwSetInputMode(arg0: number, arg1: number, arg2: number): void;
    static glfwGetMonitorContentScale(arg0: number, arg1: Internal.FloatBuffer_, arg2: Internal.FloatBuffer_): void;
    static glfwWaitEventsTimeout(arg0: number): void;
    static nglfwGetKeyName(arg0: number, arg1: number): number;
    static nglfwSetWindowTitle(arg0: number, arg1: number): void;
    static "glfwGetProcAddress(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): number;
    static nglfwGetMonitorName(arg0: number): number;
    static glfwTerminate(): void;
    static nglfwGetJoystickAxes(arg0: number, arg1: number): number;
    static glfwGetTimerFrequency(): number;
    static "glfwSetWindowTitle(long,java.lang.CharSequence)"(arg0: number, arg1: Internal.CharSequence_): void;
    static glfwGetVideoMode(arg0: number): Internal.GLFWVidMode;
    static getLibrary(): Internal.SharedLibrary;
    static nglfwSetKeyCallback(arg0: number, arg1: number): number;
    static glfwSetWindowOpacity(arg0: number, arg1: number): void;
    static glfwSetCharModsCallback(arg0: number, arg1: Internal.GLFWCharModsCallbackI_): Internal.GLFWCharModsCallback;
    static glfwGetWindowAttrib(arg0: number, arg1: number): number;
    static glfwMaximizeWindow(arg0: number): void;
    static "glfwWindowHintString(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): void;
    static nglfwGetWindowContentScale(arg0: number, arg1: number, arg2: number): void;
    static "glfwGetCursorPos(long,double[],double[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static nglfwSetGammaRamp(arg0: number, arg1: number): void;
    static glfwSetJoystickCallback(arg0: Internal.GLFWJoystickCallbackI_): Internal.GLFWJoystickCallback;
    static nglfwSetWindowPosCallback(arg0: number, arg1: number): number;
    static glfwSetFramebufferSizeCallback(arg0: number, arg1: Internal.GLFWFramebufferSizeCallbackI_): Internal.GLFWFramebufferSizeCallback;
    static nglfwGetFramebufferSize(arg0: number, arg1: number, arg2: number): void;
    static glfwInit(): boolean;
    static glfwSetWindowAttrib(arg0: number, arg1: number, arg2: number): void;
    static glfwSetDropCallback(arg0: number, arg1: Internal.GLFWDropCallbackI_): Internal.GLFWDropCallback;
    getClass(): typeof any;
    static glfwGetMonitorContentScale(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwSetWindowAspectRatio(arg0: number, arg1: number, arg2: number): void;
    static nglfwGetMonitorPhysicalSize(arg0: number, arg1: number, arg2: number): void;
    static glfwGetGamepadName(arg0: number): string;
    static glfwCreateCursor(arg0: Internal.GLFWImage_, arg1: number, arg2: number): number;
    static glfwWaitEvents(): void;
    static nglfwGetWindowPos(arg0: number, arg1: number, arg2: number): void;
    static "glfwGetFramebufferSize(long,int[],int[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static "glfwGetVersion(int[],int[],int[])"(arg0: number[], arg1: number[], arg2: number[]): void;
    static glfwGetCursorPos(arg0: number, arg1: Internal.DoubleBuffer_, arg2: Internal.DoubleBuffer_): void;
    static glfwSetWindowTitle(arg0: number, arg1: Internal.ByteBuffer_): void;
    static glfwDestroyWindow(arg0: number): void;
    static glfwInitAllocator(arg0: Internal.GLFWAllocator_): void;
    static nglfwCreateCursor(arg0: number, arg1: number, arg2: number): number;
    static nglfwGetClipboardString(arg0: number): number;
    wait(arg0: number): void;
    static nglfwSetCursorPosCallback(arg0: number, arg1: number): number;
    static nglfwGetWindowFrameSize(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
    static glfwSetCharCallback(arg0: number, arg1: Internal.GLFWCharCallbackI_): Internal.GLFWCharCallback;
    static "glfwGetMonitorPos(long,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static nglfwGetVideoMode(arg0: number): number;
    static nglfwSetErrorCallback(arg0: number): number;
    static glfwGetMonitorPos(arg0: number, arg1: number[], arg2: number[]): void;
    static "glfwGetMonitorContentScale(long,java.nio.FloatBuffer,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_, arg2: Internal.FloatBuffer_): void;
    static "glfwGetMonitorContentScale(long,float[],float[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwGetVideoModes(arg0: number): Internal.GLFWVidMode$Buffer;
    static glfwPostEmptyEvent(): void;
    static nglfwGetCursorPos(arg0: number, arg1: number, arg2: number): void;
    static nglfwGetJoystickGUID(arg0: number): number;
    static nglfwSetWindowIcon(arg0: number, arg1: number, arg2: number): void;
    static nglfwGetJoystickName(arg0: number): number;
    static glfwRawMouseMotionSupported(): boolean;
    static nglfwGetWindowSize(arg0: number, arg1: number, arg2: number): void;
    static glfwSetTime(arg0: number): void;
    static nglfwGetGammaRamp(arg0: number): number;
    static glfwGetKey(arg0: number, arg1: number): number;
    static "glfwGetFramebufferSize(long,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwWindowHintString(arg0: number, arg1: Internal.ByteBuffer_): void;
    static glfwGetProcAddress(arg0: Internal.ByteBuffer_): number;
    static glfwGetWindowPos(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwDestroyCursor(arg0: number): void;
    static glfwSetWindowContentScaleCallback(arg0: number, arg1: Internal.GLFWWindowContentScaleCallbackI_): Internal.GLFWWindowContentScaleCallback;
    static glfwSwapInterval(arg0: number): void;
    static nglfwSetDropCallback(arg0: number, arg1: number): number;
    static nglfwSetMonitorCallback(arg0: number): number;
    static nglfwGetVersion(arg0: number, arg1: number, arg2: number): void;
    static glfwGetKeyScancode(arg0: number): number;
    static nglfwSetCursorEnterCallback(arg0: number, arg1: number): number;
    wait(): void;
    static glfwSetWindowPosCallback(arg0: number, arg1: Internal.GLFWWindowPosCallbackI_): Internal.GLFWWindowPosCallback;
    static glfwGetJoystickUserPointer(arg0: number): number;
    static nglfwSetWindowCloseCallback(arg0: number, arg1: number): number;
    static nglfwGetJoystickHats(arg0: number, arg1: number): number;
    static glfwSetCursor(arg0: number, arg1: number): void;
    static "glfwExtensionSupported(java.lang.CharSequence)"(arg0: Internal.CharSequence_): boolean;
    static glfwSetWindowSizeCallback(arg0: number, arg1: Internal.GLFWWindowSizeCallbackI_): Internal.GLFWWindowSizeCallback;
    static nglfwExtensionSupported(arg0: number): number;
    static nglfwSetFramebufferSizeCallback(arg0: number, arg1: number): number;
    static nglfwSetWindowFocusCallback(arg0: number, arg1: number): number;
    static glfwGetMonitorPos(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static nglfwSetScrollCallback(arg0: number, arg1: number): number;
    static glfwExtensionSupported(arg0: Internal.CharSequence_): boolean;
    static glfwWindowHint(arg0: number, arg1: number): void;
    static glfwGetFramebufferSize(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwWindowShouldClose(arg0: number): boolean;
    static nglfwSetClipboardString(arg0: number, arg1: number): void;
    static "glfwCreateWindow(int,int,java.lang.CharSequence,long,long)"(arg0: number, arg1: number, arg2: Internal.CharSequence_, arg3: number, arg4: number): number;
    static glfwGetError(arg0: Internal.PointerBuffer_): number;
    static "glfwGetMonitorPos(long,int[],int[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwSetJoystickUserPointer(arg0: number, arg1: number): void;
    static "glfwGetMonitorWorkarea(long,java.nio.IntBuffer,java.nio.IntBuffer,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_, arg3: Internal.IntBuffer_, arg4: Internal.IntBuffer_): void;
    static nglfwSetCharModsCallback(arg0: number, arg1: number): number;
    static glfwGetMouseButton(arg0: number, arg1: number): number;
    equals(arg0: any): boolean;
    static nglfwGetMonitorContentScale(arg0: number, arg1: number, arg2: number): void;
    static "glfwGetWindowSize(long,int[],int[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwGetWindowPos(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwGetWindowUserPointer(arg0: number): number;
    static nglfwGetMonitorWorkarea(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
    static glfwWindowHintString(arg0: number, arg1: Internal.CharSequence_): void;
    static nglfwSetWindowIconifyCallback(arg0: number, arg1: number): number;
    static glfwGetProcAddress(arg0: Internal.CharSequence_): number;
    static glfwGetMonitors(): Internal.PointerBuffer;
    static glfwGetWindowFrameSize(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_, arg3: Internal.IntBuffer_, arg4: Internal.IntBuffer_): void;
    static glfwGetVersion(arg0: number[], arg1: number[], arg2: number[]): void;
    static nglfwGetJoystickButtons(arg0: number, arg1: number): number;
    static glfwSetCursorPos(arg0: number, arg1: number, arg2: number): void;
    static "glfwSetWindowTitle(long,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): void;
    static glfwSwapBuffers(arg0: number): void;
    static glfwSetWindowTitle(arg0: number, arg1: Internal.CharSequence_): void;
    static "glfwGetWindowContentScale(long,java.nio.FloatBuffer,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_, arg2: Internal.FloatBuffer_): void;
    static "glfwGetMonitorPhysicalSize(long,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwSetClipboardString(arg0: number, arg1: Internal.CharSequence_): void;
    static glfwSetGammaRamp(arg0: number, arg1: Internal.GLFWGammaRamp_): void;
    static "glfwGetVersion(java.nio.IntBuffer,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: Internal.IntBuffer_, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwSetWindowCloseCallback(arg0: number, arg1: Internal.GLFWWindowCloseCallbackI_): Internal.GLFWWindowCloseCallback;
    static glfwGetFramebufferSize(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwGetMonitorPhysicalSize(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwGetJoystickAxes(arg0: number): Internal.FloatBuffer;
    static glfwCreateWindow(arg0: number, arg1: number, arg2: Internal.ByteBuffer_, arg3: number, arg4: number): number;
    static glfwGetInputMode(arg0: number, arg1: number): number;
    static glfwGetWindowFrameSize(arg0: number, arg1: number[], arg2: number[], arg3: number[], arg4: number[]): void;
    static glfwJoystickPresent(arg0: number): boolean;
    static glfwGetGammaRamp(arg0: number): Internal.GLFWGammaRamp;
    static glfwGetClipboardString(arg0: number): string;
    static glfwGetTime(): number;
    static glfwGetCurrentContext(): number;
    static glfwSetCursorEnterCallback(arg0: number, arg1: Internal.GLFWCursorEnterCallbackI_): Internal.GLFWCursorEnterCallback;
    static "glfwGetWindowContentScale(long,float[],float[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwSetWindowSize(arg0: number, arg1: number, arg2: number): void;
    static glfwExtensionSupported(arg0: Internal.ByteBuffer_): boolean;
    static glfwGetTimerValue(): number;
    static glfwSetWindowIconifyCallback(arg0: number, arg1: Internal.GLFWWindowIconifyCallbackI_): Internal.GLFWWindowIconifyCallback;
    static glfwCreateStandardCursor(arg0: number): number;
    static nglfwSetWindowMaximizeCallback(arg0: number, arg1: number): number;
    static "glfwWindowHintString(int,java.lang.CharSequence)"(arg0: number, arg1: Internal.CharSequence_): void;
    static glfwGetWindowContentScale(arg0: number, arg1: Internal.FloatBuffer_, arg2: Internal.FloatBuffer_): void;
    static glfwGetVersion(arg0: Internal.IntBuffer_, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwGetWindowSize(arg0: number, arg1: number[], arg2: number[]): void;
    toString(): string;
    static nglfwSetJoystickCallback(arg0: number): number;
    notifyAll(): void;
    static "glfwGetWindowSize(long,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwGetMonitorWorkarea(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_, arg3: Internal.IntBuffer_, arg4: Internal.IntBuffer_): void;
    static glfwGetPrimaryMonitor(): number;
    static "glfwGetWindowPos(long,int[],int[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static "glfwExtensionSupported(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): boolean;
    static "glfwSetClipboardString(long,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): void;
    static glfwGetMonitorName(arg0: number): string;
    static nglfwGetMonitors(arg0: number): number;
    static glfwSetKeyCallback(arg0: number, arg1: Internal.GLFWKeyCallbackI_): Internal.GLFWKeyCallback;
    static glfwSetGamma(arg0: number, arg1: number): void;
    static "glfwGetMonitorWorkarea(long,int[],int[],int[],int[])"(arg0: number, arg1: number[], arg2: number[], arg3: number[], arg4: number[]): void;
    static nglfwGetGamepadName(arg0: number): number;
    static glfwSetWindowIcon(arg0: number, arg1: Internal.GLFWImage$Buffer_): void;
    static glfwGetJoystickHats(arg0: number): Internal.ByteBuffer;
    static "glfwGetWindowPos(long,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static glfwGetWindowMonitor(arg0: number): number;
    notify(): void;
    static nglfwSetMouseButtonCallback(arg0: number, arg1: number): number;
    static glfwSetWindowUserPointer(arg0: number, arg1: number): void;
    static "glfwSetClipboardString(long,java.lang.CharSequence)"(arg0: number, arg1: Internal.CharSequence_): void;
    static glfwSetWindowMonitor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
    static glfwShowWindow(arg0: number): void;
    static glfwUpdateGamepadMappings(arg0: Internal.ByteBuffer_): boolean;
    static glfwGetGamepadState(arg0: number, arg1: Internal.GLFWGamepadState_): boolean;
    static glfwGetMonitorPhysicalSize(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_): void;
    static nglfwGetMonitorPos(arg0: number, arg1: number, arg2: number): void;
    static glfwGetKeyName(arg0: number, arg1: number): string;
    static glfwSetCursorPosCallback(arg0: number, arg1: Internal.GLFWCursorPosCallbackI_): Internal.GLFWCursorPosCallback;
    static nglfwCreateWindow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): number;
    static glfwSetMonitorCallback(arg0: Internal.GLFWMonitorCallbackI_): Internal.GLFWMonitorCallback;
    static glfwSetMouseButtonCallback(arg0: number, arg1: Internal.GLFWMouseButtonCallbackI_): Internal.GLFWMouseButtonCallback;
    static glfwGetJoystickName(arg0: number): string;
    static glfwRequestWindowAttention(arg0: number): void;
    static glfwDefaultWindowHints(): void;
    static nglfwGetVideoModes(arg0: number, arg1: number): number;
    static glfwPlatformSupported(arg0: number): boolean;
    static nglfwInitAllocator(arg0: number): void;
    static glfwGetVersionString(): string;
    static glfwSetClipboardString(arg0: number, arg1: Internal.ByteBuffer_): void;
    static "glfwGetWindowFrameSize(long,java.nio.IntBuffer,java.nio.IntBuffer,java.nio.IntBuffer,java.nio.IntBuffer)"(arg0: number, arg1: Internal.IntBuffer_, arg2: Internal.IntBuffer_, arg3: Internal.IntBuffer_, arg4: Internal.IntBuffer_): void;
    static glfwIconifyWindow(arg0: number): void;
    static glfwSetWindowSizeLimits(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): void;
    static glfwSetScrollCallback(arg0: number, arg1: Internal.GLFWScrollCallbackI_): Internal.GLFWScrollCallback;
    static "glfwGetWindowFrameSize(long,int[],int[],int[],int[])"(arg0: number, arg1: number[], arg2: number[], arg3: number[], arg4: number[]): void;
    static glfwSetWindowRefreshCallback(arg0: number, arg1: Internal.GLFWWindowRefreshCallbackI_): Internal.GLFWWindowRefreshCallback;
    static glfwPollEvents(): void;
    static glfwGetMonitorUserPointer(arg0: number): number;
    static glfwJoystickIsGamepad(arg0: number): boolean;
    static nglfwUpdateGamepadMappings(arg0: number): number;
    wait(arg0: number, arg1: number): void;
    static glfwGetMonitorWorkarea(arg0: number, arg1: number[], arg2: number[], arg3: number[], arg4: number[]): void;
    static nglfwSetWindowRefreshCallback(arg0: number, arg1: number): number;
    static glfwSetWindowMaximizeCallback(arg0: number, arg1: Internal.GLFWWindowMaximizeCallbackI_): Internal.GLFWWindowMaximizeCallback;
    static glfwSetMonitorUserPointer(arg0: number, arg1: number): void;
    static glfwFocusWindow(arg0: number): void;
    static glfwCreateWindow(arg0: number, arg1: number, arg2: Internal.CharSequence_, arg3: number, arg4: number): number;
    static glfwGetWindowOpacity(arg0: number): number;
    static glfwSetErrorCallback(arg0: Internal.GLFWErrorCallbackI_): Internal.GLFWErrorCallback;
    static nglfwWindowHintString(arg0: number, arg1: number): void;
    static nglfwSetWindowSizeCallback(arg0: number, arg1: number): number;
    static nglfwSetCharCallback(arg0: number, arg1: number): number;
    static "glfwGetMonitorPhysicalSize(long,int[],int[])"(arg0: number, arg1: number[], arg2: number[]): void;
    static nglfwGetVersionString(): number;
    static glfwSetWindowFocusCallback(arg0: number, arg1: Internal.GLFWWindowFocusCallbackI_): Internal.GLFWWindowFocusCallback;
    static glfwGetWindowContentScale(arg0: number, arg1: number[], arg2: number[]): void;
    static glfwRestoreWindow(arg0: number): void;
    hashCode(): number;
    static "glfwCreateWindow(int,int,java.nio.ByteBuffer,long,long)"(arg0: number, arg1: number, arg2: Internal.ByteBuffer_, arg3: number, arg4: number): number;
    static glfwGetJoystickGUID(arg0: number): string;
    static "glfwGetCursorPos(long,java.nio.DoubleBuffer,java.nio.DoubleBuffer)"(arg0: number, arg1: Internal.DoubleBuffer_, arg2: Internal.DoubleBuffer_): void;
    static nglfwSetWindowContentScaleCallback(arg0: number, arg1: number): number;
    static glfwHideWindow(arg0: number): void;
    static glfwSetWindowShouldClose(arg0: number, arg1: boolean): void;
    static glfwMakeContextCurrent(arg0: number): void;
    get library(): Internal.SharedLibrary
    get class(): typeof any
    static readonly GLFW_KEY_F6: (295) & (number);
    static readonly GLFW_LOSE_CONTEXT_ON_RESET: (200706) & (number);
    static readonly GLFW_KEY_KP_8: (328) & (number);
    static readonly GLFW_JOYSTICK_10: (9) & (number);
    static readonly GLFW_CROSSHAIR_CURSOR: (221187) & (number);
    static readonly GLFW_STEREO: (135180) & (number);
    static readonly GLFW_GAMEPAD_AXIS_RIGHT_Y: (3) & (number);
    static readonly GLFW_NO_CURRENT_CONTEXT: (65538) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_OPENGL: (225282) & (number);
    static readonly GLFW_KEY_F18: (307) & (number);
    static readonly GLFW_MOUSE_BUTTON_5: (4) & (number);
    static readonly GLFW_HAND_CURSOR: (221188) & (number);
    static readonly GLFW_KEY_K: (75) & (number);
    static readonly GLFW_DISCONNECTED: (262146) & (number);
    static readonly GLFW_KEY_NUM_LOCK: (282) & (number);
    static readonly GLFW_EGL_CONTEXT_API: (221186) & (number);
    static readonly GLFW_COCOA_CHDIR_RESOURCES: (331777) & (number);
    static readonly GLFW_OPENGL_DEBUG_CONTEXT: (139271) & (number);
    static readonly GLFW_KEY_F7: (296) & (number);
    static readonly GLFW_KEY_END: (269) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE: (327682) & (number);
    static readonly GLFW_KEY_LEFT_SHIFT: (340) & (number);
    static readonly GLFW_KEY_KP_7: (327) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_DPAD_LEFT: (14) & (number);
    static readonly GLFW_RED_BITS: (135169) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_START: (7) & (number);
    static readonly GLFW_NATIVE_CONTEXT_API: (221185) & (number);
    static readonly GLFW_HAT_RIGHT: (2) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_TRIANGLE: (3) & (number);
    static readonly GLFW_KEY_DELETE: (261) & (number);
    static readonly GLFW_KEY_F17: (306) & (number);
    static readonly GLFW_MOUSE_BUTTON_4: (3) & (number);
    static readonly GLFW_MOD_CONTROL: (2) & (number);
    static readonly GLFW_ICONIFIED: (131074) & (number);
    static readonly GLFW_KEY_L: (76) & (number);
    static readonly GLFW_KEY_RIGHT: (262) & (number);
    static readonly GLFW_HAT_CENTERED: (0) & (number);
    static readonly GLFW_JOYSTICK_2: (1) & (number);
    static readonly GLFW_LOCK_KEY_MODS: (208900) & (number);
    static readonly GLFW_KEY_9: (57) & (number);
    static readonly GLFW_KEY_Z: (90) & (number);
    static readonly GLFW_KEY_KP_MULTIPLY: (332) & (number);
    static readonly GLFW_AUTO_ICONIFY: (131078) & (number);
    static readonly GLFW_CONTEXT_ROBUSTNESS: (139269) & (number);
    static readonly GLFW_KEY_F4: (293) & (number);
    static readonly GLFW_JOYSTICK_12: (11) & (number);
    static readonly GLFW_PLATFORM_COCOA: (393218) & (number);
    static readonly GLFW_COCOA_MENUBAR: (331778) & (number);
    static readonly GLFW_KEY_I: (73) & (number);
    static readonly GLFW_MOUSE_BUTTON_3: (2) & (number);
    static readonly GLFW_FEATURE_UNIMPLEMENTED: (65549) & (number);
    static readonly GLFW_JOYSTICK_HAT_BUTTONS: (327681) & (number);
    static readonly GLFW_KEY_LAST: (348) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_A: (0) & (number);
    static readonly GLFW_KEY_8: (56) & (number);
    static readonly GLFW_KEY_DOWN: (264) & (number);
    static readonly GLFW_GAMEPAD_AXIS_LEFT_Y: (1) & (number);
    static readonly GLFW_KEY_F5: (294) & (number);
    static readonly GLFW_KEY_COMMA: (44) & (number);
    static readonly GLFW_KEY_KP_9: (329) & (number);
    static readonly GLFW_KEY_APOSTROPHE: (39) & (number);
    static readonly GLFW_NO_API: (0) & (number);
    static readonly GLFW_KEY_EQUAL: (61) & (number);
    static readonly GLFW_JOYSTICK_1: (0) & (number);
    static readonly GLFW_VISIBLE: (131076) & (number);
    static readonly GLFW_DONT_CARE: (-1) & (number);
    static readonly GLFW_KEY_GRAVE_ACCENT: (96) & (number);
    static readonly GLFW_JOYSTICK_11: (10) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_DPAD_UP: (11) & (number);
    static readonly GLFW_RESIZE_NS_CURSOR: (221190) & (number);
    static readonly GLFW_KEY_ESCAPE: (256) & (number);
    static readonly GLFW_KEY_F19: (308) & (number);
    static readonly GLFW_KEY_J: (74) & (number);
    static readonly GLFW_BLUE_BITS: (135171) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_OPENGLES: (225283) & (number);
    static readonly GLFW_RAW_MOUSE_MOTION: (208901) & (number);
    static readonly GLFW_OPENGL_API: (196609) & (number);
    static readonly GLFW_MOUSE_BUTTON_2: (1) & (number);
    static readonly GLFW_CURSOR: (208897) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_B: (1) & (number);
    static readonly GLFW_JOYSTICK_4: (3) & (number);
    static readonly GLFW_AUX_BUFFERS: (135179) & (number);
    static readonly GLFW_HAT_RIGHT_UP: (3) & (number);
    static readonly GLFW_JOYSTICK_14: (13) & (number);
    static readonly GLFW_KEY_G: (71) & (number);
    static readonly GLFW_PLATFORM_ERROR: (65544) & (number);
    static readonly GLFW_HAT_UP: (1) & (number);
    static readonly GLFW_FOCUS_ON_SHOW: (131084) & (number);
    static readonly GLFW_PLATFORM_WIN32: (393217) & (number);
    static readonly GLFW_MOUSE_BUTTON_LAST: (7) & (number);
    static readonly GLFW_KEY_PAUSE: (284) & (number);
    static readonly GLFW_CURSOR_DISABLED: (212995) & (number);
    static readonly GLFW_KEY_KP_ADD: (334) & (number);
    static readonly GLFW_CURSOR_HIDDEN: (212994) & (number);
    static readonly GLFW_KEY_6: (54) & (number);
    static readonly GLFW_KEY_W: (87) & (number);
    static readonly GLFW_MAXIMIZED: (131080) & (number);
    static readonly GLFW_RESIZABLE: (131075) & (number);
    static readonly GLFW_JOYSTICK_3: (2) & (number);
    static readonly GLFW_KEY_Y: (89) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_DPAD_DOWN: (13) & (number);
    static readonly GLFW_VERSION_MINOR: (4) & (number);
    static readonly GLFW_KEY_INSERT: (260) & (number);
    static readonly GLFW_CLIENT_API: (139265) & (number);
    static readonly GLFW_KEY_RIGHT_BRACKET: (93) & (number);
    static readonly GLFW_KEY_KP_EQUAL: (336) & (number);
    static readonly GLFW_JOYSTICK_13: (12) & (number);
    static readonly GLFW_KEY_H: (72) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_RIGHT_BUMPER: (5) & (number);
    static readonly GLFW_PLATFORM_WAYLAND: (393219) & (number);
    static readonly GLFW_KEY_HOME: (268) & (number);
    static readonly GLFW_MOUSE_BUTTON_8: (7) & (number);
    static readonly GLFW_GAMEPAD_AXIS_LEFT_X: (0) & (number);
    static readonly GLFW_COCOA_GRAPHICS_SWITCHING: (143363) & (number);
    static readonly GLFW_KEY_LEFT_SUPER: (343) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_RIGHT_THUMB: (10) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_D3D11: (225285) & (number);
    static readonly GLFW_RESIZE_NWSE_CURSOR: (221191) & (number);
    static readonly GLFW_KEY_7: (55) & (number);
    static readonly GLFW_NO_ERROR: (0) & (number);
    static readonly GLFW_KEY_X: (88) & (number);
    static readonly GLFW_NOT_ALLOWED_CURSOR: (221194) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_SQUARE: (2) & (number);
    static readonly GLFW_VERSION_MAJOR: (3) & (number);
    static readonly GLFW_KEY_LEFT_CONTROL: (341) & (number);
    static readonly GLFW_FOCUSED: (131073) & (number);
    static readonly GLFW_KEY_F8: (297) & (number);
    static readonly GLFW_COCOA_FRAME_NAME: (143362) & (number);
    static readonly GLFW_CONTEXT_VERSION_MINOR: (139267) & (number);
    static readonly GLFW_PLATFORM_NULL: (393221) & (number);
    static readonly GLFW_JOYSTICK_6: (5) & (number);
    static readonly GLFW_KEY_E: (69) & (number);
    static readonly GLFW_HRESIZE_CURSOR: (221189) & (number);
    static readonly GLFW_JOYSTICK_16: (15) & (number);
    static readonly GLFW_KEY_F20: (309) & (number);
    static readonly GLFW_MOD_CAPS_LOCK: (16) & (number);
    static readonly GLFW_NO_RESET_NOTIFICATION: (200705) & (number);
    static readonly GLFW_NOT_INITIALIZED: (65537) & (number);
    static readonly GLFW_MOUSE_BUTTON_7: (6) & (number);
    static readonly GLFW_OPENGL_COMPAT_PROFILE: (204802) & (number);
    static readonly GLFW_ANY_PLATFORM: (393216) & (number);
    static readonly GLFW_STENCIL_BITS: (135174) & (number);
    static readonly GLFW_KEY_U: (85) & (number);
    static readonly GLFW_OPENGL_ANY_PROFILE: (0) & (number);
    static readonly GLFW_OPENGL_CORE_PROFILE: (204801) & (number);
    static readonly GLFW_REPEAT: (2) & (number);
    static readonly GLFW_KEY_KP_SUBTRACT: (333) & (number);
    static readonly GLFW_HAT_LEFT_UP: (9) & (number);
    static readonly GLFW_KEY_4: (52) & (number);
    static readonly GLFW_X11_INSTANCE_NAME: (147458) & (number);
    static readonly GLFW_JOYSTICK_5: (4) & (number);
    static readonly GLFW_REFRESH_RATE: (135183) & (number);
    static readonly GLFW_KEY_TAB: (258) & (number);
    static readonly GLFW_KEY_F9: (298) & (number);
    static readonly GLFW_MOD_SHIFT: (1) & (number);
    static readonly GLFW_STICKY_KEYS: (208898) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_METAL: (225288) & (number);
    static readonly GLFW_KEY_F: (70) & (number);
    static readonly GLFW_KEY_RIGHT_SHIFT: (344) & (number);
    static readonly GLFW_KEY_MINUS: (45) & (number);
    static readonly GLFW_JOYSTICK_15: (14) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_D3D9: (225284) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_DPAD_RIGHT: (12) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_BACK: (6) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_VULKAN: (225287) & (number);
    static readonly GLFW_SAMPLES: (135181) & (number);
    static readonly GLFW_CENTER_CURSOR: (131081) & (number);
    static readonly GLFW_CONTEXT_VERSION_MAJOR: (139266) & (number);
    static readonly GLFW_MOUSE_BUTTON_6: (5) & (number);
    static readonly GLFW_PLATFORM_UNAVAILABLE: (65550) & (number);
    static readonly GLFW_KEY_PAGE_UP: (266) & (number);
    static readonly GLFW_KEY_5: (53) & (number);
    static readonly GLFW_KEY_V: (86) & (number);
    static readonly GLFW_WIN32_KEYBOARD_MENU: (151553) & (number);
    static readonly GLFW_KEY_RIGHT_CONTROL: (345) & (number);
    static readonly GLFW_CURSOR_UNAVAILABLE: (65547) & (number);
    static readonly GLFW_ANY_RELEASE_BEHAVIOR: (0) & (number);
    static readonly GLFW_KEY_MENU: (348) & (number);
    static readonly GLFW_FALSE: (0) & (number);
    static readonly GLFW_HAT_LEFT: (8) & (number);
    static readonly GLFW_KEY_WORLD_1: (161) & (number);
    static readonly GLFW_JOYSTICK_8: (7) & (number);
    static readonly GLFW_COCOA_RETINA_FRAMEBUFFER: (143361) & (number);
    static readonly GLFW_SCALE_TO_MONITOR: (139276) & (number);
    static readonly GLFW_ANGLE_PLATFORM_TYPE_NONE: (225281) & (number);
    static readonly GLFW_RESIZE_ALL_CURSOR: (221193) & (number);
    static readonly GLFW_KEY_F10: (299) & (number);
    static readonly GLFW_KEY_F22: (311) & (number);
    static readonly GLFW_KEY_C: (67) & (number);
    static readonly GLFW_HOVERED: (131083) & (number);
    static readonly GLFW_KEY_KP_0: (320) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_X: (2) & (number);
    static readonly GLFW_KEY_SLASH: (47) & (number);
    static readonly GLFW_OPENGL_FORWARD_COMPAT: (139270) & (number);
    static readonly GLFW_INVALID_VALUE: (65540) & (number);
    static readonly GLFW_OPENGL_PROFILE: (139272) & (number);
    static readonly GLFW_MOUSE_BUTTON_MIDDLE: (2) & (number);
    static readonly GLFW_CONNECTED: (262145) & (number);
    static readonly GLFW_DOUBLEBUFFER: (135184) & (number);
    static readonly GLFW_KEY_2: (50) & (number);
    static readonly GLFW_DECORATED: (131077) & (number);
    static readonly GLFW_KEY_S: (83) & (number);
    static readonly GLFW_MOUSE_BUTTON_LEFT: (0) & (number);
    static readonly GLFW_NO_ROBUSTNESS: (0) & (number);
    static readonly GLFW_KEY_PRINT_SCREEN: (283) & (number);
    static readonly GLFW_KEY_SEMICOLON: (59) & (number);
    static readonly GLFW_KEY_ENTER: (257) & (number);
    static readonly GLFW_INVALID_ENUM: (65539) & (number);
    static readonly GLFW_KEY_WORLD_2: (162) & (number);
    static readonly GLFW_KEY_LEFT_BRACKET: (91) & (number);
    static readonly GLFW_JOYSTICK_7: (6) & (number);
    static readonly GLFW_KEY_F21: (310) & (number);
    static readonly GLFW_RELEASE_BEHAVIOR_NONE: (217090) & (number);
    static readonly GLFW_MOUSE_BUTTON_RIGHT: (1) & (number);
    static readonly GLFW_CONTEXT_NO_ERROR: (139274) & (number);
    static readonly GLFW_KEY_D: (68) & (number);
    static readonly GLFW_KEY_BACKSLASH: (92) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_Y: (3) & (number);
    static readonly GLFW_GAMEPAD_AXIS_LAST: (5) & (number);
    static readonly GLFW_KEY_LEFT: (263) & (number);
    static readonly GLFW_GREEN_BITS: (135170) & (number);
    static readonly GLFW_SRGB_CAPABLE: (135182) & (number);
    static readonly GLFW_KEY_3: (51) & (number);
    static readonly GLFW_KEY_T: (84) & (number);
    static readonly GLFW_FLOATING: (131079) & (number);
    static readonly GLFW_X11_XCB_VULKAN_SURFACE: (335873) & (number);
    static readonly GLFW_KEY_F12: (301) & (number);
    static readonly GLFW_NO_WINDOW_CONTEXT: (65546) & (number);
    static readonly GLFW_KEY_F24: (313) & (number);
    static readonly GLFW_GAMEPAD_AXIS_RIGHT_TRIGGER: (5) & (number);
    static readonly GLFW_HAT_LEFT_DOWN: (12) & (number);
    static readonly GLFW_KEY_A: (65) & (number);
    static readonly GLFW_KEY_KP_2: (322) & (number);
    static readonly GLFW_OUT_OF_MEMORY: (65541) & (number);
    static readonly GLFW_VERSION_UNAVAILABLE: (65543) & (number);
    static readonly GLFW_KEY_UNKNOWN: (-1) & (number);
    static readonly GLFW_KEY_0: (48) & (number);
    static readonly GLFW_ACCUM_ALPHA_BITS: (135178) & (number);
    static readonly GLFW_KEY_Q: (81) & (number);
    static readonly GLFW_ARROW_CURSOR: (221185) & (number);
    static readonly GLFW_OSMESA_CONTEXT_API: (221187) & (number);
    static readonly GLFW_IBEAM_CURSOR: (221186) & (number);
    static readonly GLFW_VRESIZE_CURSOR: (221190) & (number);
    static readonly GLFW_OPENGL_ES_API: (196610) & (number);
    static readonly GLFW_ALPHA_BITS: (135172) & (number);
    static readonly GLFW_JOYSTICK_9: (8) & (number);
    static readonly GLFW_KEY_PAGE_DOWN: (267) & (number);
    static readonly GLFW_KEY_F23: (312) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_LEFT_BUMPER: (4) & (number);
    static readonly GLFW_KEY_F11: (300) & (number);
    static readonly GLFW_KEY_B: (66) & (number);
    static readonly GLFW_KEY_KP_1: (321) & (number);
    static readonly GLFW_MOD_ALT: (4) & (number);
    static readonly GLFW_CONTEXT_RELEASE_BEHAVIOR: (139273) & (number);
    static readonly GLFW_KEY_RIGHT_ALT: (346) & (number);
    static readonly GLFW_KEY_KP_DIVIDE: (331) & (number);
    static readonly GLFW_KEY_1: (49) & (number);
    static readonly GLFW_KEY_R: (82) & (number);
    static readonly GLFW_DEPTH_BITS: (135173) & (number);
    static readonly GLFW_ACCUM_GREEN_BITS: (135176) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_CIRCLE: (1) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_CROSS: (0) & (number);
    static readonly GLFW_RESIZE_NESW_CURSOR: (221192) & (number);
    static readonly GLFW_KEY_SPACE: (32) & (number);
    static readonly GLFW_KEY_KP_4: (324) & (number);
    static readonly GLFW_KEY_F2: (291) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_LAST: (14) & (number);
    static readonly GLFW_KEY_KP_ENTER: (335) & (number);
    static readonly GLFW_POINTING_HAND_CURSOR: (221188) & (number);
    static readonly GLFW_KEY_O: (79) & (number);
    static readonly GLFW_MOD_SUPER: (8) & (number);
    static readonly GLFW_KEY_F14: (303) & (number);
    static readonly GLFW_CURSOR_NORMAL: (212993) & (number);
    static readonly GLFW_MOUSE_BUTTON_1: (0) & (number);
    static readonly GLFW_TRUE: (1) & (number);
    static readonly GLFW_CONTEXT_CREATION_API: (139275) & (number);
    static readonly GLFW_KEY_UP: (265) & (number);
    static readonly GLFW_ACCUM_RED_BITS: (135175) & (number);
    static readonly GLFW_PLATFORM_X11: (393220) & (number);
    static readonly GLFW_ACCUM_BLUE_BITS: (135177) & (number);
    static readonly GLFW_X11_CLASS_NAME: (147457) & (number);
    static readonly GLFW_RELEASE_BEHAVIOR_FLUSH: (217089) & (number);
    static readonly GLFW_KEY_F13: (302) & (number);
    static readonly GLFW_FEATURE_UNAVAILABLE: (65548) & (number);
    static readonly GLFW_KEY_F3: (292) & (number);
    static readonly GLFW_KEY_KP_3: (323) & (number);
    static readonly GLFW_VERSION_REVISION: (0) & (number);
    static readonly GLFW_RELEASE: (0) & (number);
    static readonly GLFW_KEY_P: (80) & (number);
    static readonly GLFW_KEY_F25: (314) & (number);
    static readonly GLFW_KEY_SCROLL_LOCK: (281) & (number);
    static readonly GLFW_KEY_LEFT_ALT: (342) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_GUIDE: (8) & (number);
    static readonly GLFW_RESIZE_EW_CURSOR: (221189) & (number);
    static readonly GLFW_API_UNAVAILABLE: (65542) & (number);
    static readonly GLFW_TRANSPARENT_FRAMEBUFFER: (131082) & (number);
    static readonly GLFW_KEY_KP_6: (326) & (number);
    static readonly GLFW_KEY_PERIOD: (46) & (number);
    static readonly GLFW_PLATFORM: (327683) & (number);
    static readonly GLFW_HAT_DOWN: (4) & (number);
    static readonly GLFW_KEY_M: (77) & (number);
    static readonly GLFW_MOUSE_PASSTHROUGH: (131085) & (number);
    static readonly GLFW_KEY_F16: (305) & (number);
    static readonly GLFW_FORMAT_UNAVAILABLE: (65545) & (number);
    static readonly GLFW_CONTEXT_REVISION: (139268) & (number);
    static readonly GLFW_CONTEXT_DEBUG: (139271) & (number);
    static readonly GLFW_STICKY_MOUSE_BUTTONS: (208899) & (number);
    static readonly GLFW_PRESS: (1) & (number);
    static readonly GLFW_KEY_KP_5: (325) & (number);
    static readonly GLFW_HAT_RIGHT_DOWN: (6) & (number);
    static readonly GLFW_KEY_RIGHT_SUPER: (347) & (number);
    static readonly GLFW_KEY_F1: (290) & (number);
    static readonly GLFW_GAMEPAD_AXIS_RIGHT_X: (2) & (number);
    static readonly GLFW_KEY_N: (78) & (number);
    static readonly GLFW_KEY_BACKSPACE: (259) & (number);
    static readonly GLFW_GAMEPAD_BUTTON_LEFT_THUMB: (9) & (number);
    static readonly GLFW_KEY_CAPS_LOCK: (280) & (number);
    static readonly GLFW_MOD_NUM_LOCK: (32) & (number);
    static readonly GLFW_KEY_F15: (304) & (number);
    static readonly GLFW_KEY_KP_DECIMAL: (330) & (number);
    static readonly GLFW_JOYSTICK_LAST: (15) & (number);
    static readonly GLFW_GAMEPAD_AXIS_LEFT_TRIGGER: (4) & (number);
}
type GLFW_ = GLFW;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    above(): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): this;
    north(arg0: number): this;
    below(): this;
    notifyAll(): void;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare interface GeoItem extends Internal.SingletonGeoAnimatable {
    registerSyncedAnimatable(arg0: Internal.GeoAnimatable_): void;
    triggerAnim<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
    "triggerAnim(long,java.lang.String,java.lang.String,net.minecraftforge.network.PacketDistributor$PacketTarget)"<D>(arg0: number, arg1: string, arg2: string, arg3: Internal.PacketDistributor$PacketTarget_): void;
    getId(arg0: Internal.ItemStack_): number;
    animatableCacheOverride(): Internal.AnimatableInstanceCache;
    stopTriggeredArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
    syncAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>, arg2: D, arg3: Internal.PacketDistributor$PacketTarget_): void;
    getBoneResetTime(): number;
    triggerArmorAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
    getTick(arg0: any): number;
    getOrAssignId(arg0: Internal.ItemStack_, arg1: Internal.ServerLevel_): number;
    abstract getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
    getAnimData<D>(arg0: number, arg1: Internal.SerializableDataTicket_<D>): D;
    isPerspectiveAware(): boolean;
    triggerAnim<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
    stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string, arg4: Internal.PacketDistributor$PacketTarget_): void;
    setAnimData<D>(arg0: Internal.Entity_, arg1: number, arg2: Internal.SerializableDataTicket_<D>, arg3: D): void;
    stopTriggeredAnim(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
    abstract registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
    shouldPlayAnimsWhileGamePaused(): boolean;
    "triggerAnim(net.minecraft.world.entity.Entity,long,java.lang.String,java.lang.String)"<D>(arg0: Internal.Entity_, arg1: number, arg2: string, arg3: string): void;
    get boneResetTime(): number
    get animatableInstanceCache(): Internal.AnimatableInstanceCache
    get perspectiveAware(): boolean
    readonly ID_NBT_KEY: ("GeckoLibID") & (string);
}
type GeoItem_ = GeoItem;
declare const GeoItem: GeoItem;
declare interface ForgeItemFilter extends ItemFilter {
    hasEnchantment(filter: Internal.ResourceLocationFilter_, min: number, max: number): ItemFilter;
    abstract "test(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): boolean;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    "not(com.almostreliable.lootjs.filters.ItemFilter)"(itemFilter: ItemFilter_): ItemFilter;
    and(...itemFilters: ItemFilter_[]): ItemFilter;
    test(arg0: any): boolean;
    and(other: ItemFilter_): ItemFilter;
    not(itemFilter: ItemFilter_): ItemFilter;
    or(...itemFilters: ItemFilter_[]): ItemFilter;
    or(other: ItemFilter_): ItemFilter;
    "test(java.lang.Object)"(arg0: any): boolean;
    "and(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "or(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): ItemFilter;
    negate(): Internal.Predicate<any>;
    hasEnchantment(filter: Internal.ResourceLocationFilter_): ItemFilter;
    "and(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): ItemFilter;
    "not(java.util.function.Predicate)"<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    canPerformAnyAction(...actions: string[]): ItemFilter;
    equipmentSlot(slot: EquipmentSlot_): ItemFilter;
    "or(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): ItemFilter;
    or(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    "or(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    abstract test(arg0: Internal.ItemStack_): boolean;
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): ItemFilter;
    canPerformAction(...actions: string[]): ItemFilter;
    "and(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): ItemFilter;
    and(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
}
type ForgeItemFilter_ = ForgeItemFilter;
declare const ForgeItemFilter: ForgeItemFilter;
declare class Blocks {
    constructor()
    getClass(): typeof any;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    static rebuildCache(): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.WartBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.BoneBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.WartBlock) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    asRuleTest(): Internal.RuleTest;
    ruleTestOf(o: any): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static clampedLerp(value: number, min: number, max: number): number;
    static approachDegrees(current: number, target: number, speed: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class $WorkbenchTileCraftEvent extends net.minecraftforge.eventbus.api.Event {
    constructor()
    constructor(targetStack: Internal.ItemStack_, upgradedStack: Internal.ItemStack_, player: Internal.Player_, workbenchTile: Internal.WorkbenchTile_, materials: Internal.ItemStack_[], materialsAltered: Internal.ItemStack_[], currentSchematic: Internal.UpgradeSchematic_, currentSlot: string)
    getResult(): Internal.Event$Result;
    setCanceled(arg0: boolean): void;
    getClass(): typeof any;
    toString(): string;
    setPhase(arg0: Internal.EventPriority_): void;
    notifyAll(): void;
    isCanceled(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hasResult(): boolean;
    setResult(arg0: Internal.Event$Result_): void;
    hashCode(): number;
    isCancelable(): boolean;
    wait(): void;
    getListenerList(): Internal.ListenerList;
    wait(arg0: number): void;
    getPhase(): Internal.EventPriority;
    equals(arg0: any): boolean;
    get result(): Internal.Event$Result
    set canceled(arg0: boolean)
    get class(): typeof any
    set phase(arg0: Internal.EventPriority_)
    get canceled(): boolean
    set result(arg0: Internal.Event$Result_)
    get cancelable(): boolean
    get listenerList(): Internal.ListenerList
    get phase(): Internal.EventPriority
    currentSchematic: Internal.UpgradeSchematic;
    currentSlot: string;
    targetStack: Internal.ItemStack;
    upgradedStack: Internal.ItemStack;
    player: Internal.Player;
    workbenchTile: Internal.WorkbenchTile;
    level: Internal.Level;
    materials: Internal.ItemStack[];
    materialsAltered: Internal.ItemStack[];
}
type $WorkbenchTileCraftEvent_ = $WorkbenchTileCraftEvent;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class EquipmentSlot extends Internal.Enum<EquipmentSlot> {
    getClass(): typeof any;
    static values(): EquipmentSlot[];
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<EquipmentSlot>>;
    getIndex(): number;
    getDeclaringClass(): typeof EquipmentSlot;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    compareTo(arg0: EquipmentSlot_): number;
    getName(): string;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getType(): Internal.EquipmentSlot$Type;
    "compareTo(net.minecraft.world.entity.EquipmentSlot)"(arg0: EquipmentSlot_): number;
    toString(): string;
    static byName(arg0: string): EquipmentSlot;
    notifyAll(): void;
    static valueOf(arg0: string): EquipmentSlot;
    static byTypeAndIndex(arg0: Internal.EquipmentSlot$Type_, arg1: number): EquipmentSlot;
    getIndex(arg0: number): number;
    name(): string;
    getFilterFlag(): number;
    hashCode(): number;
    ordinal(): number;
    wait(): void;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    isArmor(): boolean;
    equals(arg0: any): boolean;
    get class(): typeof any
    get index(): number
    get declaringClass(): typeof EquipmentSlot
    get name(): string
    get type(): Internal.EquipmentSlot$Type
    get filterFlag(): number
    get armor(): boolean
    static readonly HEAD: (EquipmentSlot) & (EquipmentSlot);
    static readonly FEET: (EquipmentSlot) & (EquipmentSlot);
    static readonly LEGS: (EquipmentSlot) & (EquipmentSlot);
    static readonly OFFHAND: (EquipmentSlot) & (EquipmentSlot);
    static readonly MAINHAND: (EquipmentSlot) & (EquipmentSlot);
    static readonly CHEST: (EquipmentSlot) & (EquipmentSlot);
}
type EquipmentSlot_ = "feet" | EquipmentSlot | "mainhand" | "offhand" | "head" | "legs" | "chest";
declare class RawAnimation {
    then(arg0: string, arg1: Internal.Animation$LoopType_): this;
    getClass(): typeof any;
    thenLoop(arg0: string): this;
    toString(): string;
    thenWait(arg0: number): this;
    notifyAll(): void;
    thenPlayXTimes(arg0: string, arg1: number): this;
    notify(): void;
    thenPlay(arg0: string): this;
    wait(arg0: number, arg1: number): void;
    static begin(): RawAnimation;
    hashCode(): number;
    static copyOf(arg0: RawAnimation_): RawAnimation;
    wait(): void;
    wait(arg0: number): void;
    thenPlayAndHold(arg0: string): this;
    equals(arg0: any): boolean;
    getAnimationStages(): Internal.List<Internal.RawAnimation$Stage>;
    get class(): typeof any
    get animationStages(): Internal.List<Internal.RawAnimation$Stage>
}
type RawAnimation_ = RawAnimation;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    minus(arg0: Duration_): this;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class DamageSource implements Internal.DamageSourceAccessor, Internal.DamageSourceEC {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    tetraClip$setEsoteric(arg0: boolean): void;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    biomancy$setDamageType(arg0: Internal.Holder_<any>): void;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    tetraClip$isEsoteric(): boolean;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class LootEntry {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.LootEntry;
    static withChance(o: any, chance: number): Internal.LootEntry;
    notify(): void;
    static of(in_: Internal.ItemStack_, count: number): Internal.LootEntry;
    wait(arg0: number, arg1: number): void;
    static "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.LootEntry;
    hashCode(): number;
    wait(): void;
    static "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.LootEntry;
    static of(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.LootEntry;
    wait(arg0: number): void;
    static ofJson(json: Internal.JsonObject_): Internal.LootEntry;
    equals(arg0: any): boolean;
    static of(o: any): Internal.LootEntry;
    get class(): typeof any
}
type LootEntry_ = LootEntry;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare interface ItemFilter extends Internal.Predicate<Internal.ItemStack> {
    hasEnchantment(filter: Internal.ResourceLocationFilter_, min: number, max: number): this;
    abstract "test(net.minecraft.world.item.ItemStack)"(arg0: Internal.ItemStack_): boolean;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    "not(com.almostreliable.lootjs.filters.ItemFilter)"(itemFilter: ItemFilter_): this;
    and(...itemFilters: ItemFilter_[]): this;
    test(arg0: any): boolean;
    and(other: ItemFilter_): this;
    not(itemFilter: ItemFilter_): this;
    or(...itemFilters: ItemFilter_[]): this;
    or(other: ItemFilter_): this;
    "test(java.lang.Object)"(arg0: any): boolean;
    "and(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "or(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): this;
    negate(): Internal.Predicate<any>;
    hasEnchantment(filter: Internal.ResourceLocationFilter_): this;
    "not(java.util.function.Predicate)"<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    "and(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): this;
    equipmentSlot(slot: EquipmentSlot_): this;
    "or(com.almostreliable.lootjs.filters.ItemFilter[])"(...itemFilters: ItemFilter_[]): this;
    or(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    "or(java.util.function.Predicate)"(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    abstract test(arg0: Internal.ItemStack_): boolean;
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): this;
    "and(com.almostreliable.lootjs.filters.ItemFilter)"(other: ItemFilter_): this;
    and(arg0: Internal.Predicate_<Internal.ItemStack>): Internal.Predicate<Internal.ItemStack>;
    readonly FEET_ARMOR: ItemFilter;
    readonly ENCHANTABLE: ItemFilter;
    readonly POTION: ItemFilter;
    readonly HAS_TIER: ItemFilter;
    readonly PROJECTILE_WEAPON: ItemFilter;
    readonly TOOL: ItemFilter;
    readonly LEGS_ARMOR: ItemFilter;
    readonly DAMAGED: ItemFilter;
    readonly DAMAGEABLE: ItemFilter;
    readonly WEAPON: ItemFilter;
    readonly BLOCK: ItemFilter;
    readonly FOOD: ItemFilter;
    readonly HOE: ItemFilter;
    readonly SHOVEL: ItemFilter;
    readonly ALWAYS_TRUE: ItemFilter;
    readonly PICKAXE: ItemFilter;
    readonly ENCHANTED: ItemFilter;
    readonly HEAD_ARMOR: ItemFilter;
    readonly CHEST_ARMOR: ItemFilter;
    readonly AXE: ItemFilter;
    readonly ALWAYS_FALSE: ItemFilter;
    readonly SWORD: ItemFilter;
    readonly ARMOR: ItemFilter;
}
type ItemFilter_ = ItemFilter;
declare const ItemFilter: ItemFilter;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(float)"(arg0: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "set(double)"(arg0: number): this;
    "normalize(float)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    "get(int)"(arg0: number): number;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    "set(float[])"(arg0: number[]): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare class ItemEffect {
    getClass(): typeof any;
    hashCode(): number;
    getKey(): string;
    toString(): string;
    static get(arg0: string): ItemEffect;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    get key(): string
    static readonly bleeding: (ItemEffect) & (ItemEffect);
    static readonly abilitySpeed: (ItemEffect) & (ItemEffect);
    static readonly extractionAxialAmplify: (ItemEffect) & (ItemEffect);
    static readonly focusEcho: (ItemEffect) & (ItemEffect);
    static readonly sweepingStrike: (ItemEffect) & (ItemEffect);
    static readonly percussionScanner: (ItemEffect) & (ItemEffect);
    static readonly sweepingFocus: (ItemEffect) & (ItemEffect);
    static readonly stun: (ItemEffect) & (ItemEffect);
    static readonly releaseLatch: (ItemEffect) & (ItemEffect);
    static readonly abilityExhilaration: (ItemEffect) & (ItemEffect);
    static readonly fierySelf: (ItemEffect) & (ItemEffect);
    static readonly unstable: (ItemEffect) & (ItemEffect);
    static readonly puncture: (ItemEffect) & (ItemEffect);
    static readonly pry: (ItemEffect) & (ItemEffect);
    static readonly enderReverb: (ItemEffect) & (ItemEffect);
    static readonly truesweep: (ItemEffect) & (ItemEffect);
    static readonly unboundExtraction: (ItemEffect) & (ItemEffect);
    static readonly reap: (ItemEffect) & (ItemEffect);
    static readonly planarSweep: (ItemEffect) & (ItemEffect);
    static readonly unbreaking: (ItemEffect) & (ItemEffect);
    static readonly severing: (ItemEffect) & (ItemEffect);
    static readonly criticalStrike: (ItemEffect) & (ItemEffect);
    static readonly jab: (ItemEffect) & (ItemEffect);
    static readonly workable: (ItemEffect) & (ItemEffect);
    static readonly blocking: (ItemEffect) & (ItemEffect);
    static readonly quickStrike: (ItemEffect) & (ItemEffect);
    static readonly booster: (ItemEffect) & (ItemEffect);
    static readonly execute: (ItemEffect) & (ItemEffect);
    static readonly extractionMedialLimit: (ItemEffect) & (ItemEffect);
    static readonly abilityEcho: (ItemEffect) & (ItemEffect);
    static readonly spread: (ItemEffect) & (ItemEffect);
    static readonly howling: (ItemEffect) & (ItemEffect);
    static readonly ammoCapacity: (ItemEffect) & (ItemEffect);
    static readonly denailing: (ItemEffect) & (ItemEffect);
    static readonly hauntedKey: ("destabilized/haunted") & (string);
    static readonly softStrike: (ItemEffect) & (ItemEffect);
    static readonly throwable: (ItemEffect) & (ItemEffect);
    static readonly strikingAxe: (ItemEffect) & (ItemEffect);
    static readonly zoom: (ItemEffect) & (ItemEffect);
    static readonly focus: (ItemEffect) & (ItemEffect);
    static readonly counterweight: (ItemEffect) & (ItemEffect);
    static readonly abilityCombo: (ItemEffect) & (ItemEffect);
    static readonly potionSlot: (ItemEffect) & (ItemEffect);
    static readonly backstab: (ItemEffect) & (ItemEffect);
    static readonly extraction: (ItemEffect) & (ItemEffect);
    static readonly abilityMomentum: (ItemEffect) & (ItemEffect);
    static readonly sweeperVerticalSpread: (ItemEffect) & (ItemEffect);
    static readonly piercing: (ItemEffect) & (ItemEffect);
    static readonly earthbind: (ItemEffect) & (ItemEffect);
    static readonly janking: (ItemEffect) & (ItemEffect);
    static readonly rangeCritical: (ItemEffect) & (ItemEffect);
    static readonly strikingHoe: (ItemEffect) & (ItemEffect);
    static readonly intuit: (ItemEffect) & (ItemEffect);
    static readonly armorPenetration: (ItemEffect) & (ItemEffect);
    static readonly strikingCut: (ItemEffect) & (ItemEffect);
    static readonly lunge: (ItemEffect) & (ItemEffect);
    static readonly extractionLateralLimit: (ItemEffect) & (ItemEffect);
    static readonly abilityDefensive: (ItemEffect) & (ItemEffect);
    static readonly overbowed: (ItemEffect) & (ItemEffect);
    static readonly ricochet: (ItemEffect) & (ItemEffect);
    static readonly piercingHarvest: (ItemEffect) & (ItemEffect);
    static readonly storageSlot: (ItemEffect) & (ItemEffect);
    static readonly sculkTaint: (ItemEffect) & (ItemEffect);
    static readonly flow: (ItemEffect) & (ItemEffect);
    static readonly skewering: (ItemEffect) & (ItemEffect);
    static readonly quickAccess: (ItemEffect) & (ItemEffect);
    static readonly abilityRevenge: (ItemEffect) & (ItemEffect);
    static readonly slam: (ItemEffect) & (ItemEffect);
    static readonly overpower: (ItemEffect) & (ItemEffect);
    static readonly extractionPlanarAmplify: (ItemEffect) & (ItemEffect);
    static readonly abilityOverextend: (ItemEffect) & (ItemEffect);
    static readonly reaching: (ItemEffect) & (ItemEffect);
    static readonly quickSlot: (ItemEffect) & (ItemEffect);
    static readonly suspendSelf: (ItemEffect) & (ItemEffect);
    static readonly quiverSlot: (ItemEffect) & (ItemEffect);
    static readonly cellSocket: (ItemEffect) & (ItemEffect);
    static readonly velocity: (ItemEffect) & (ItemEffect);
    static readonly abilityOvercharge: (ItemEffect) & (ItemEffect);
    static readonly sweeperHorizontalSpread: (ItemEffect) & (ItemEffect);
    static readonly bashing: (ItemEffect) & (ItemEffect);
    static readonly shieldbreaker: (ItemEffect) & (ItemEffect);
    static readonly strikingPickaxe: (ItemEffect) & (ItemEffect);
    static readonly crushing: (ItemEffect) & (ItemEffect);
    static readonly extractionAxialLimit: (ItemEffect) & (ItemEffect);
    static readonly sweeperRange: (ItemEffect) & (ItemEffect);
    static readonly strikingShovel: (ItemEffect) & (ItemEffect);
    static readonly blockingReflect: (ItemEffect) & (ItemEffect);
    static readonly stabilizing: (ItemEffect) & (ItemEffect);
    static readonly suspend: (ItemEffect) & (ItemEffect);
    static readonly haunted: (ItemEffect) & (ItemEffect);
    static readonly multishot: (ItemEffect) & (ItemEffect);
    static readonly sweeping: (ItemEffect) & (ItemEffect);
}
type ItemEffect_ = ItemEffect;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "abs(float)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface EasingType {
    elastic(arg0: number): Internal.Double2DoubleFunction;
    sine(arg0: number): number;
    exp(arg0: number): number;
    linear(arg0: number): number;
    easeOut(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    quadratic(arg0: number): number;
    register(arg0: string, arg1: EasingType_): this;
    step(arg0: number): Internal.Double2DoubleFunction;
    circle(arg0: number): number;
    catmullRom(arg0: number): number;
    pow(arg0: number): Internal.Double2DoubleFunction;
    stepPositive(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    fromString(arg0: string): this;
    fromJson(arg0: Internal.JsonElement_): this;
    cubic(arg0: number): number;
    easeIn(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    "linear(double)"(arg0: number): number;
    linear(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    apply(arg0: Internal.AnimationPoint_): number;
    back(arg0: number): Internal.Double2DoubleFunction;
    lerpWithOverride(arg0: Internal.AnimationPoint_, arg1: EasingType_): number;
    easeInOut(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    abstract buildTransformer(arg0: number): Internal.Double2DoubleFunction;
    stepNonNegative(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    bounce(arg0: number): Internal.Double2DoubleFunction;
    "linear(it.unimi.dsi.fastutil.doubles.Double2DoubleFunction)"(arg0: Internal.Double2DoubleFunction_): Internal.Double2DoubleFunction;
    apply(arg0: Internal.AnimationPoint_, arg1: number, arg2: number): number;
    (arg0: number): Internal.Double2DoubleFunction_;
    readonly EASE_IN_OUT_QUAD: EasingType;
    readonly EASE_OUT_QUAD: EasingType;
    readonly EASE_OUT_ELASTIC: EasingType;
    readonly EASE_IN_BOUNCE: EasingType;
    readonly CATMULLROM: (Internal.EasingType$CatmullRomEasing) & (EasingType);
    readonly EASE_IN_SINE: EasingType;
    readonly EASE_IN_OUT_CIRC: EasingType;
    readonly EASE_IN_OUT_BACK: EasingType;
    readonly EASE_IN_CIRC: EasingType;
    readonly EASE_OUT_BOUNCE: EasingType;
    readonly EASE_IN_OUT_CUBIC: EasingType;
    readonly EASE_IN_QUART: EasingType;
    readonly STEP: EasingType;
    readonly EASE_IN_OUT_ELASTIC: EasingType;
    readonly EASE_OUT_BACK: EasingType;
    readonly LINEAR: EasingType;
    readonly EASE_IN_CUBIC: EasingType;
    readonly EASE_IN_OUT_QUINT: EasingType;
    readonly EASE_OUT_EXPO: EasingType;
    readonly EASE_OUT_QUINT: EasingType;
    readonly EASE_IN_OUT_BOUNCE: EasingType;
    readonly EASE_IN_QUINT: EasingType;
    readonly EASE_OUT_SINE: EasingType;
    readonly EASE_IN_OUT_QUART: EasingType;
    readonly EASE_IN_EXPO: EasingType;
    readonly EASE_OUT_CUBIC: EasingType;
    readonly EASING_TYPES: ({"easeoutbounce": any, "none": any, "easeinquad": any, "easeoutcubic": any, "easeoutcirc": any, "easeoutsine": any, "easeinoutquint": any, "easeoutexpo": any, "catmullrom": Internal.EasingType$CatmullRomEasing, "easeoutback": any, "easeinquint": any, "easeinoutquart": any, "easeinback": any, "easeoutelastic": any, "easeinquart": any, "easeinoutquad": any, "easeinbounce": any, "easeinexpo": any, "easeoutquad": any, "easeoutquint": any, "easeinelastic": any, "easeinoutback": any, "easeinoutexpo": any, "linear": any, "easeinoutcubic": any, "easeinoutelastic": any, "easeincubic": any, "easeoutquart": any, "easeincirc": any, "easeinoutcirc": any, "easeinsine": any, "easeinoutsine": any, "step": any, "easeinoutbounce": any}) & (Internal.Map<string, EasingType>);
    readonly EASE_IN_ELASTIC: EasingType;
    readonly EASE_IN_QUAD: EasingType;
    readonly EASE_IN_OUT_EXPO: EasingType;
    readonly EASE_OUT_QUART: EasingType;
    readonly EASE_OUT_CIRC: EasingType;
    readonly EASE_IN_OUT_SINE: EasingType;
    readonly EASE_IN_BACK: EasingType;
}
type EasingType_ = EasingType | ((arg0: number)=> Internal.Double2DoubleFunction_);
declare const EasingType: EasingType;
declare class LootType extends Internal.Enum<LootType> {
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    static values(): LootType[];
    toString(): string;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    "compareTo(com.almostreliable.lootjs.core.LootContextType)"(arg0: LootType_): number;
    name(): string;
    getDeclaringClass(): typeof LootType;
    hashCode(): number;
    ordinal(): number;
    wait(): void;
    describeConstable(): Internal.Optional<Internal.Enum$EnumDesc<LootType>>;
    compareTo(arg0: LootType_): number;
    wait(arg0: number): void;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    static valueOf(name: string): LootType;
    get class(): typeof any
    get declaringClass(): typeof LootType
    static readonly ADVANCEMENT_ENTITY: (LootType) & (LootType);
    static readonly ENTITY: (LootType) & (LootType);
    static readonly CHEST: (LootType) & (LootType);
    static readonly FISHING: (LootType) & (LootType);
    static readonly GIFT: (LootType) & (LootType);
    static readonly ADVANCEMENT_REWARD: (LootType) & (LootType);
    static readonly UNKNOWN: (LootType) & (LootType);
    static readonly BLOCK: (LootType) & (LootType);
    static readonly PIGLIN_BARTER: (LootType) & (LootType);
}
type LootType_ = "advancement_reward" | "gift" | "piglin_barter" | LootType | "block" | "advancement_entity" | "entity" | "unknown" | "chest" | "fishing";
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    l(v: number): Internal.Tag;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    listTag(): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    intTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTag(v: any): Internal.Tag;
    toTagCompound(v: any): Internal.CompoundTag;
    toTagList(list: any): Internal.ListTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    negateX(): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    invert(arg0: Matrix3f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "set(float[])"(arg0: number[]): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    rotateY(arg0: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "get(float[])"(arg0: number[]): number[];
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapZXY(): this;
    mapnYXZ(arg0: Matrix3f_): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotationY(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    m23(arg0: number): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    invert(): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapYXZ(): this;
    mapXnZnY(arg0: Matrix4f_): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
declare class ArmorEffectLevelMath {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    static registerMath(effect: ItemEffect_, function_: Internal.BiFunction_<number, number, number>): void;
    toString(): string;
    static getMath(effect: ItemEffect_): Internal.BiFunction<number, number, number>;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static DEFAULT: Internal.BiFunction<number, number, number>;
    static MATHS: ({}) & (Internal.Map<ItemEffect, Internal.BiFunction<number, number, number>>);
}
type ArmorEffectLevelMath_ = ArmorEffectLevelMath;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "smsn" | "meed" | "supermartijn642configlib" | "netherexp" | "playeranimator" | "prefab" | "jeitetra" | "modernfix" | "yungsapi" | "balm" | "projectile_damage" | "jeresources" | "structure_layout_optimizer" | "cloth_config" | "ctov" | "embeddium" | "rubidium" | "structure_gel" | "corpse" | "w2w2" | "jerotes" | "repurposed_structures" | "loot_journal" | "jupiter" | "tooltips_reforged" | "supermartijn642corelib" | "yungsbridges" | "resourcefulconfig" | "curiouslanterns" | "curios" | "armorpointspp" | "oculus" | "searchables" | "fastspawner" | "attributeslib" | "dzzl" | "constructionwand" | "fastleafdecay" | "powerful_dummy" | "radium" | "lithostitched" | "attributefix" | "pehkui" | "flerovium" | "caelus" | "pasterdream" | "integrated_api" | "naturescompass" | "jerotesvillage" | "enchantjs" | "cloudgolem_edited" | "puzzlesaccessapi" | "forge" | "skullskinless" | "dungeons_arise" | "drippyloadingscreen" | "biofactory" | "minecraft" | "create_pillagers_arise" | "smoothchunk" | "terrablender" | "fabric_api_base" | "mousetweaks" | "javascriptjs" | "spectrelib" | "geckojs" | "kotlinforforge" | "jeiintegration" | "entityjs" | "flywheel" | "xaerominimap" | "polymorph" | "fix_attack_lag" | "zeta" | "wits" | "immediatelyfast" | "structory_towers" | "appleskin" | "lootr" | "modernui" | "puzzleslib" | "liolib" | "opack2reload" | "tetra_view" | "tetra" | "tetraclip" | "kuma_api" | "transmog" | "incontrol" | "tipsmod" | "incendium" | "sophisticatedcore" | "nanhealthfixer" | "keybindjs" | "xaeroworldmap" | "controlling" | "placebo" | "citadel" | "mixinextras" | "cobweb" | "soul_fire_d" | "bookshelf" | "sophisticatedbackpacks" | "takesapillage" | "jeed" | "melody" | "faded_conquest_2" | "no_nv_flash" | "sodiumdynamiclights" | "konkrete" | "rsinfinitybooster" | "refinedstorage" | "farmersdelight" | "mcreator_mem_fix" | "extraholopage" | "born_in_chaos_v1" | "lionfishapi" | "protection_pixel" | "cataclysm" | "patchouli" | "underground_village" | "collective" | "morerequirement" | "lootjs" | "inventoryprofilesnext" | "architectury" | "ftblibrary" | "ftbfiltersystem" | "ftbteams" | "wireless_workbench" | "cupboard" | "ageingspawners" | "lanserverproperties" | "chunkloaders" | "biomancy" | "jei" | "geckolib" | "probejs" | "polylib" | "yeetusexperimentus" | "rhino" | "kubejs" | "eventjs" | "trashslot" | "treasuredistance" | "kleiders_custom_renderer" | "elysium_api" | "itemfilters" | "ftbquests" | "ftbxmodcompat" | "xlpackets" | "summoningrituals" | "create" | "kubejs_create" | "waystones" | "taxfreelevels" | "ali" | "sponsor_core" | "ftbbackups2" | "explorerscompass" | "tetra_addition" | "uranus" | "tetra_attribute_rebalancing" | "ati_structuresv" | "libipn" | "enchdesc" | "damage_number" | "radiantgear" | "titanium" | "jade" | "mr_reds_morestructures" | "lendersdelight" | "easy_villagers" | "quark" | "mutil" | "art_of_forging" | "legendary_monsters" | "jecharacters" | "inventoryhud" | "fancymenu" | "lios_overhauled_villages" | "coroutil" | "grindstone_honing" | "ferritecore" | "functionalstorage" | "refinedstorageaddons" | "packetfixer" | "badoptimizations" | "moblassos" | "yiranversioncheck"
    type Ingredient = "tetra:scroll" | "tetra:tool_action" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "zeta:flag" | "quark:flag" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "farmersdelight:tool_action" | "biomancy:food_nutrition" | "biomancy:essence" | "create:block_tag_ingredient" | "functionalstorage:woodless";
    type Advancement = "tetra:spelunking/find_scroll" | "born_in_chaos_v1:guidetothenextworld" | "create:red_signal" | "incendium:withered_forest/kill_spirit" | "minecraft:nether/obtain_crying_obsidian" | "born_in_chaos_v1:soul_eater" | "legendary_monsters:defeat_dune_sentinel" | "tetra:scrolls/find_scroll_mace" | "minecraft:husbandry/allay_deliver_item_to_player" | "farmersdelight:main/place_cooking_pot" | "dungeons_arise:find_plague_asylum" | "minecraft:husbandry/froglights" | "netherexp:nether/ghost_mucus" | "create:train_portal" | "tetra:spelunking/root" | "refinedstorage:wireless_items" | "tetra:art_of_forging/crucible_upgrade" | "minecraft:nether/distract_piglin" | "lootr:1chest" | "biomancy:biomancy/genetic_compounds" | "cataclysm:find_ruined_citadel" | "biomancy:biomancy/decomposer" | "legendary_monsters:defeat_the_ancient_guardian" | "pasterdream:achievement_treasure_dyedream" | "jerotesvillage:damaged_ruins" | "tetra:spelunking/find_canister" | "quark:throw_parrot_egg" | "dungeons_arise:find_small_prairie_house" | "create:ejector_maxed" | "create:mechanical_pump_0" | "create:brass" | "biomancy:biomancy/cooked_meat_sacrifice" | "repurposed_structures:bastion_underground" | "faded_conquest_2:so_below" | "pasterdream:achievement_treasure_a_1" | "pasterdream:achievement_treasure_a_0" | "lootr:1shulker" | "tetra:scrolls/get_scroll_crucible" | "pasterdream:achievement_treasure_a_8" | "pasterdream:achievement_treasure_a_7" | "pasterdream:achievement_treasure_a_6" | "faded_conquest_2:providence" | "pasterdream:achievement_treasure_a_5" | "pasterdream:achievement_treasure_a_4" | "pasterdream:achievement_treasure_a_3" | "pasterdream:achievement_treasure_a_2" | "jerotesvillage:liberty_leading_the_villager" | "refinedstorage:viewing_fluids" | "netherexp:nether/the_nether_is_full" | "dungeons_arise:find_foundry" | "art_of_forging:materials/root" | "takesapillage:root" | "incendium:technical/scroll_of_returning" | "minecraft:story/obtain_armor" | "netherexp:nether/black_ice_black_everything_black" | "create:diving_suit" | "jerotesvillage:serpon" | "pasterdream:achievement_shadow_start" | "born_in_chaos_v1:charm_collector" | "born_in_chaos_v1:bonk" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "dungeons_arise:find_undead_pirate_ship" | "tetra:art_of_forging/rending_scissor_purple_upgrade" | "tetra:spelunking/find_scroll_sturdy" | "minecraft:adventure/very_very_frightening" | "netherexp:nether/rodeo_stampede" | "born_in_chaos_v1:heart_thief" | "minecraft:story/lava_bucket" | "create:hose_pulley_lava" | "dungeons_arise:find_thornborn_towers" | "tetra:art_of_forging/rapier_upgrade" | "create:train_crash" | "farmersdelight:main/get_rich_soil" | "art_of_forging:materials/find_all_demonic_items" | "jerotesvillage:gift_for_you" | "incendium:quartz_flats/sanctum/vault_hunter" | "tetra:spelunking/find_scroll_expertise" | "legendary_monsters:defeat_endersent" | "create:long_travel" | "legendary_monsters:locate_shulker_tower" | "dungeons_arise:find_infested_temple" | "born_in_chaos_v1:hat_for_dark_deeds" | "tetra:recipes/earthpiercer" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "lootr:social" | "biomancy:biomancy/healing_activator_sacrifice" | "minecraft:end/kill_dragon" | "tetra:scrolls/root" | "biomancy:biomancy/raw_meat_sacrifice" | "create:clockwork_bearing" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "incendium:technical/sentrys_wrath" | "dungeons_arise:find_mushroom_village" | "faded_conquest_2:as_above" | "incendium:ash_barrens/conquer_castle" | "farmersdelight:main/place_skillet" | "born_in_chaos_v1:waste_recycler" | "create:encased_fan" | "dungeons_arise:find_aviary" | "minecraft:nether/all_potions" | "jerotesvillage:ocean_gemstone" | "incendium:infernal_dunes/inferno/root" | "dungeons_arise:find_giant_mushroom" | "jerotesvillage:purple_desert" | "born_in_chaos_v1:yoursatietywillbe_eternal" | "legendary_monsters:locate_ancient_tower_remains" | "incendium:infernal_dunes/inferno/run" | "minecraft:husbandry/tame_an_animal" | "tetra:spelunking/shockwave_hammer" | "repurposed_structures:shipwrecks" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "incendium:toxic_heap/root" | "biomancy:biomancy/poacher" | "repurposed_structures:villages" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "tetra:scrolls/find_scroll_tonal_blade" | "cataclysm:kill_ender_golem" | "cataclysm:find_soul_black_smith" | "create:water_wheel" | "incendium:quartz_flats/floor_is_tears" | "create:mechanical_arm" | "minecraft:nether/create_beacon" | "biomancy:biomancy/primal_vision" | "incendium:technical/inventory/sentrys_wrath" | "dungeons_arise:find_illager_corsair_or_illager_galley" | "create:windmill_maxed" | "minecraft:story/deflect_arrow" | "dungeons_arise:find_lighthouse" | "tetra:upgrades/sword_improvement_hone" | "create:sturdy_sheet" | "legendary_monsters:locate_ruined_pyramid" | "cataclysm:kill_harbinger" | "minecraft:husbandry/leash_all_frog_variants" | "tetra:upgrades/sword_upgrade" | "born_in_chaos_v1:excessive_fly_swatter" | "minecraft:story/iron_tools" | "tetra:spelunking/loot_ruins" | "jerotesvillage:three_saints" | "create:track_0" | "tetra:scrolls/get_scroll_murasama" | "tetra:spelunking/pristine_socket" | "dungeons_arise:find_mechanical_nest" | "tetra:recipes/string" | "cataclysm:kill_scylla" | "tetra:upgrades/shield_upgrade" | "born_in_chaos_v1:lifeturnedouttobeacomedy" | "farmersdelight:main/get_mushroom_colony" | "pasterdream:achievement_talent_shadow" | "explorerscompass:explorers_compass_cracked_stone_bricks" | "create:honey_drain" | "dungeons_arise:find_wishing_well" | "born_in_chaos_v1:pumpkin_sir" | "incendium:technical/multiplex_crossbow" | "tetra:upgrades/bow_upgrade" | "refinedstorage:crafting_on_demand" | "faded_conquest_2:pbslain" | "tetra:spelunking/suspend_bow" | "incendium:technical/using/ragnarok" | "netherexp:nether/exorcism" | "minecraft:nether/brew_potion" | "refinedstorage:destruction" | "jerotesvillage:golden_armor_tyrant" | "tetra:spelunking/craft_shockwave_chamber" | "tetra:spelunking/suspend_belt" | "dungeons_arise:find_coliseum" | "legendary_monsters:defeat_posessed_paladin" | "incendium:toxic_heap/nuclear_fusion" | "minecraft:end/dragon_egg" | "tetra:recipes/forged_mesh" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "jerotesvillage:mental_strength" | "minecraft:husbandry/fishy_business" | "tetra:art_of_forging/flamberge_upgrade" | "tetra:spelunking/find_scroll_warforge" | "dungeons_arise:wda_root" | "tetra:recipes/planks" | "incendium:withered_forest/chain_armor" | "tetra:spelunking/schematic_shatter" | "incendium:toxic_heap/slime_poison" | "farmersdelight:main/obtain_netherite_knife" | "refinedstorage:wireless_fluids" | "lootr:50loot" | "pasterdream:achievement_shadow_e_0" | "create:pulley_maxed" | "refinedstorage:no_cables_required" | "minecraft:nether/explore_nether" | "jerotesvillage:magic_resistance" | "dungeons_arise:find_mushroom_mines" | "refinedstorage:wireless" | "tetra:upgrades/tool_upgrade" | "quark:wear_full_rainbow" | "incendium:root" | "born_in_chaos_v1:good_demoman" | "tetra:upgrades/toolbelt_upgraded" | "refinedstorage:interface_to_the_world" | "tetra:spelunking/schematic_pry" | "netherexp:nether/back_with_a_vengeance" | "tetra:spelunking/ancient_ruins" | "create:chocolate_bucket" | "tetra:art_of_forging/remembrance_upgrade" | "minecraft:adventure/fall_from_world_height" | "create:fist_bump" | "netherexp:nether/the_caduceus" | "repurposed_structures:pyramids" | "cataclysm:kill_remnant" | "minecraft:nether/ride_strider" | "minecraft:adventure/sniper_duel" | "create:track_signal" | "born_in_chaos_v1:infernal_hatman" | "tetra:spelunking/schematic_empower" | "minecraft:nether/root" | "pasterdream:achievement_shadow_b_0" | "tetra:upgrades/sword_integrity" | "incendium:infernal_dunes/pipeline/pipeline_treasure" | "tetra:upgrades/place_holosphere" | "jerotesvillage:tribal_leader" | "create:extendo_grip" | "quark:throw_pickarang" | "pasterdream:achievement_start" | "tetra:art_of_forging/eerie_fuller" | "minecraft:end/levitate" | "tetra:spelunking/find_bolt" | "dungeons_arise:find_bandit_village" | "quark:retreive_flamerang" | "create:glass_pipe" | "netherexp:nether/big_brain_time" | "create:self_deploying" | "quark:poison_baby" | "dungeons_arise:find_heavenly_conqueror" | "pasterdream:achievement_talent_light" | "born_in_chaos_v1:dark_forging" | "cataclysm:kill_revenant" | "create:musical_arm" | "repurposed_structures:city_overworld" | "incendium:infernal_dunes/inferno/lunatic_mode" | "dungeons_arise:find_abandoned_temple" | "incendium:misc/root" | "art_of_forging:materials/vobrivium_ingot" | "refinedstorage:upgrading" | "incendium:volcanic_deltas/hidden_debris" | "tetra:spelunking/geode" | "farmersdelight:main/plant_rice" | "create:display_link" | "born_in_chaos_v1:rampage" | "netherexp:nether/gravedigger" | "farmersdelight:main/get_ham" | "legendary_monsters:defeat_warped_fungussus" | "tetra:spelunking/stonecutter" | "minecraft:nether/all_effects" | "minecraft:adventure/bullseye" | "tetra:spelunking/use_bolt" | "jerotesvillage:deportation" | "legendary_monsters:locate_cloudy_temple" | "incendium:infernal_dunes/inferno/kill" | "quark:instamine_deepslate" | "minecraft:nether/get_wither_skull" | "legendary_monsters:locate_frostbitten_temple" | "minecraft:husbandry/bred_all_animals" | "refinedstorage:conditional_connecting" | "netherexp:nether/plague_doctor" | "dungeons_arise:find_bathhouse" | "minecraft:story/mine_stone" | "jerotesvillage:jerotes_villager_trade" | "tetra:spelunking/chthonic_hammer" | "jerotesvillage:plague_zone" | "quark:mine_toretoise" | "dungeons_arise:find_illager_campsite" | "create:saw_processing" | "create:andesite_casing" | "netherexp:nether/non_renewable_yeah_right" | "incendium:toxic_heap/mystic_wisdom" | "lootr:10loot" | "refinedstorage:upgrading_your_grid" | "dungeons_arise:find_keep_kayra" | "jerotesvillage:bitter_cold" | "legendary_monsters:end_root" | "create:steam_engine_maxed" | "farmersdelight:main/root" | "born_in_chaos_v1:big_boy" | "netherexp:nether/brain_food" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:story/enter_the_nether" | "minecraft:adventure/whos_the_pillager_now" | "dungeons_arise:find_merchant_campsite" | "jerotesvillage:borrowing_place" | "tetra:spelunking/chthonic_automation" | "create:root" | "naturescompass:natures_compass_log" | "lootr:25loot" | "incendium:technical/feed_ghastling" | "jerotesvillage:stupid_but_brave" | "minecraft:story/upgrade_tools" | "incendium:quartz_flats/root" | "create:train_crash_backwards" | "repurposed_structures:monuments" | "jerotesvillage:copper_head_iron_arms" | "incendium:quartz_flats/torte/kitchen_treasure" | "incendium:infernal_dunes/border_of_life" | "lootr:1barrel" | "tetra:spelunking/percussion_scanner" | "incendium:technical/on_inventory_change" | "netherexp:nether/frightening_rush" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "jerotesvillage:a_million_times_hotter_than_tnt" | "born_in_chaos_v1:freshen_your_breath" | "create:deployer" | "farmersdelight:main/master_chef" | "create:diving_suit_lava" | "art_of_forging:materials/sigil_of_eden" | "farmersdelight:main/use_cutting_board" | "create:arm_blaze_burner" | "create:cuckoo_clock" | "netherexp:nether/rattling_remnants" | "dungeons_arise:find_small_blimp" | "quark:ancient_apple_overlevel" | "tetra:spelunking/devils_soul_gem" | "minecraft:husbandry/tactical_fishing" | "jerotesvillage:second_round_world_come" | "create:copper" | "netherexp:nether/sanctum_of_wax" | "legendary_monsters:defeat_cloud_golem" | "born_in_chaos_v1:one_explosion_is_good_two_is_better" | "create:anvil_plough" | "minecraft:adventure/salvage_sherd" | "incendium:infernal_dunes/inferno/armored_wings" | "netherexp:nether/eldritch_manipulation" | "create:stressometer" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "create:potato_cannon" | "jerotesvillage:qoaiku" | "minecraft:story/cure_zombie_villager" | "quark:get_all_corundum" | "biomancy:biomancy/bio_injector" | "pasterdream:achievement_c_4" | "faded_conquest_2:dlslain" | "farmersdelight:main/get_fd_seed" | "art_of_forging:materials/vobrite_crystal" | "pasterdream:achievement_treasure_wind_journey" | "pasterdream:achievement_c_1" | "jerotesvillage:chivalrous" | "pasterdream:achievement_c_0" | "pasterdream:achievement_c_3" | "pasterdream:achievement_c_2" | "faded_conquest_2:rgslainadv" | "quark:crawl_in_hollow_log" | "repurposed_structures:temples" | "pasterdream:achievement_hide_5" | "pasterdream:achievement_hide_6" | "art_of_forging:materials/endsteel_ingot" | "tetra:recipes/root" | "pasterdream:achievement_hide_7" | "pasterdream:achievement_hide_8" | "pasterdream:achievement_hide_1" | "pasterdream:achievement_hide_2" | "pasterdream:achievement_hide_3" | "pasterdream:achievement_hide_4" | "create:chute" | "jerotesvillage:drug_allergy" | "born_in_chaos_v1:squireofthe_dark_lord" | "pasterdream:achievement_hide_9" | "born_in_chaos_v1:exorcism" | "netherexp:recipes/sanctum/gargoyle_statue" | "born_in_chaos_v1:scarecrow" | "dungeons_arise:find_mining_system" | "biomancy:biomancy/nether_star_sacrifice" | "create:train" | "pasterdream:achievement_hide_0" | "dungeons_arise:find_greenwood_pub" | "minecraft:husbandry/feed_snifflet" | "tetra:upgrades/rack" | "create:chained_drain" | "quark:use_viaduct" | "create:drain" | "quark:get_bottled_cloud" | "minecraft:story/form_obsidian" | "minecraft:end/find_end_city" | "cataclysm:kill_clawdian" | "dungeons_arise:find_typhon" | "cataclysm:find_acropolis" | "create:haunted_bell" | "jerotesvillage:how_did_they_get_here" | "minecraft:end/enter_end_gateway" | "born_in_chaos_v1:chaos_knight" | "born_in_chaos_v1:double_trouble" | "netherexp:nether/hp_minecraftian" | "dungeons_arise:find_illager_fort" | "jerotesvillage:harmonious_wonderland" | "born_in_chaos_v1:shakeand_mix" | "refinedstorage:managing_patterns" | "born_in_chaos_v1:sweet_battle" | "tetra:spelunking/hammer_power" | "born_in_chaos_v1:unlucky_hunter" | "minecraft:nether/obtain_blaze_rod" | "create:crushing_wheel" | "incendium:technical/on_hit" | "tetra:spelunking/hammer_craft" | "incendium:withered_forest/root" | "repurposed_structures:outposts" | "legendary_monsters:locate_ancient_stronghold" | "tetra:art_of_forging/dreadnought_upgrade" | "biomancy:biomancy/exotic_compounds" | "minecraft:nether/loot_bastion" | "legendary_monsters:defeat_shulker_mimic" | "netherexp:nether/overkill" | "faded_conquest_2:faded_2" | "minecraft:adventure/shoot_arrow" | "legendary_monsters:locate_abandoned_crypt" | "legendary_monsters:defeat_spiky_bug" | "born_in_chaos_v1:bury_them_all" | "minecraft:husbandry/silk_touch_nest" | "netherexp:nether/add_spores_to_block" | "incendium:technical/on_player_hurt" | "quark:pathfinder_map_center" | "farmersdelight:main/place_organic_compost" | "farmersdelight:main/use_skillet" | "create:train_roadkill" | "refinedstorage:wireless_monitoring" | "refinedstorage:portable_storage" | "tetra:upgrades/sword_hone_peak" | "born_in_chaos_v1:trickor_treat" | "farmersdelight:main/eat_nourishing_food" | "farmersdelight:main/place_campfire" | "born_in_chaos_v1:naughty_child" | "tetra:spelunking/hammer_unjam" | "biomancy:biomancy/organic_compounds" | "tetra:upgrades/toolbelt" | "minecraft:adventure/arbalistic" | "minecraft:end/respawn_dragon" | "jerotesvillage:a_bolt_from_the_purple" | "minecraft:story/smelt_iron" | "create:brass_casing" | "jerotesvillage:plot" | "jerotesvillage:drought_fire" | "repurposed_structures:strongholds" | "repurposed_structures:root" | "born_in_chaos_v1:food_fight" | "born_in_chaos_v1:horror_underthe_mantle" | "born_in_chaos_v1:dark_blacksmith" | "cataclysm:find_sunken_city" | "create:hand_crank_000" | "create:wrench_goggles" | "repurposed_structures:igloos" | "jerotesvillage:magic_world" | "minecraft:nether/charge_respawn_anchor" | "dungeons_arise:find_heavenly_challenger" | "farmersdelight:main/harvest_straw" | "naturescompass:natures_compass" | "refinedstorage:drives" | "tetra:upgrades/bastard_upgrade" | "tetra:art_of_forging/murasama_blade" | "create:mechanical_mixer" | "quark:watcher_center" | "create:super_glue" | "create:mechanical_press" | "tetra:art_of_forging/tomahawk_upgrade" | "create:cross_streams" | "netherexp:nether/pizza_hunt" | "minecraft:story/shiny_gear" | "biomancy:biomancy/bio_forge" | "minecraft:end/elytra" | "born_in_chaos_v1:pumpkin_lord" | "minecraft:husbandry/tadpole_in_a_bucket" | "biomancy:biomancy/cradle" | "jerotesvillage:jerotes_adventure" | "jerotesvillage:endless_ocean" | "minecraft:husbandry/wax_off" | "lootr:1cart" | "create:funnel" | "biomancy:biomancy/bio_lab" | "born_in_chaos_v1:insect_repellent" | "jerotesvillage:crisp_teeth" | "tetra:spelunking/chthonic_module" | "born_in_chaos_v1:spruce_cowboyinthe_moonlight" | "born_in_chaos_v1:protectedby_darkness" | "incendium:quartz_flats/rescue_mission" | "born_in_chaos_v1:transmutalogy" | "cataclysm:kill_leviathan" | "legendary_monsters:defeat_chorusling" | "refinedstorage:storing_fluids" | "biomancy:biomancy/empty_after_cradle" | "quark:overlevel_enchant" | "faded_conquest_2:agslain" | "born_in_chaos_v1:shell_warrior" | "incendium:infernal_dunes/root" | "tetra:spelunking/find_latch" | "biomancy:biomancy/living_flesh" | "legendary_monsters:defeat_skeletosaurus" | "minecraft:adventure/summon_iron_golem" | "naturescompass:natures_compass_sapling" | "minecraft:adventure/avoid_vibration" | "create:contraption_actors" | "create:windmill" | "create:rose_quartz" | "repurposed_structures:city_nether" | "tetra:spelunking/hammer_jam" | "jerotesvillage:wilderness_woodland" | "tetra:art_of_forging/rending_scissor_red_upgrade" | "incendium:technical/using/trailblazer" | "quark:make_stoneling" | "jerotesvillage:virtual_cave" | "art_of_forging:materials/forged_ingot" | "jerotes:a_brand_new_world" | "minecraft:nether/return_to_sender" | "minecraft:adventure/sleep_in_bed" | "jerotesvillage:villager_warrior" | "dungeons_arise:find_shiraz_palace" | "tetra:spelunking/refill_cell" | "tetra:spelunking/earthpiercer" | "pasterdream:achievement_treasure_b_0" | "farmersdelight:main/place_feast" | "jerotesvillage:anesthesia_therapy" | "minecraft:end/dragon_breath" | "minecraft:adventure/root" | "repurposed_structures:mineshafts" | "netherexp:nether/no_skin" | "tetra:spelunking/sweeper" | "dungeons_arise:find_bandit_towers" | "cataclysm:find_ancient_factory" | "minecraft:adventure/kill_all_mobs" | "refinedstorage:storing_externally" | "tetra:spelunking/find_scroll_howling" | "minecraft:story/enchant_item" | "tetra:spelunking/find_scroll_throwing" | "jerotesvillage:lepidosauria" | "minecraft:husbandry/obtain_sniffer_egg" | "incendium:infernal_dunes/pipeline/unlimited_power" | "faded_conquest_2:fcislain" | "minecraft:adventure/voluntary_exile" | "born_in_chaos_v1:fighting_nightmares" | "refinedstorage:pattern_creation" | "create:stressometer_maxed" | "biomancy:biomancy/raw_meat_collection" | "refinedstorage:exporting" | "jerotesvillage:it_wont_be_toxic_right" | "art_of_forging:materials/find_demonic_item" | "born_in_chaos_v1:arachnophobes_nightmare" | "legendary_monsters:locate_lava_eater" | "tetra:upgrades/workbench" | "jerotesvillage:villager_craftsmanship" | "minecraft:story/follow_ender_eye" | "pasterdream:achievement_a_1" | "tetra:spelunking/find_cell" | "pasterdream:achievement_a_0" | "tetra:recipes/workbench" | "create:display_board_0" | "pasterdream:achievement_hide_10" | "pasterdream:achievement_hide_11" | "pasterdream:achievement_hide_12" | "create:steam_whistle" | "pasterdream:achievement_hide_13" | "pasterdream:achievement_hide_14" | "tetra:upgrades/root" | "pasterdream:achievement_hide_15" | "pasterdream:achievement_hide_16" | "incendium:quartz_flats/sanctum/root" | "jerotesvillage:omniscient" | "minecraft:end/root" | "tetra:scrolls/get_scroll_quarry_hammer" | "tetra:scrolls/get_scroll_rending_scissors" | "quark:mine_fed_toretoise" | "tetra:scrolls/find_scroll_compound_string" | "create:steam_engine" | "create:extendo_grip_dual" | "create:crafter_lazy_000" | "minecraft:adventure/spyglass_at_parrot" | "create:copper_casing" | "dungeons_arise:find_fishing_hut" | "jerotesvillage:prohibit_rip_of" | "create:mechanical_crafter" | "cataclysm:find_burning_arena" | "jerotesvillage:meror_metal" | "born_in_chaos_v1:dismantledto_bones" | "minecraft:husbandry/obtain_netherite_hoe" | "create:foods" | "quark:tame_foxhound" | "legendary_monsters:defeat_haunted_guard" | "refinedstorage:viewing_items" | "born_in_chaos_v1:spider_warlord" | "quark:get_own_head" | "cataclysm:kill_ender_guardian" | "biomancy:biomancy/root" | "create:speed_controller" | "cataclysm:find_frosted_prison" | "tetra:scrolls/get_scroll_katana" | "tetra:spelunking/chthonic_extractor" | "tetra:scrolls/find_scroll_halberd" | "born_in_chaos_v1:wrong_santa" | "minecraft:adventure/totem_of_undying" | "cataclysm:kill_ignis" | "cataclysm:kill_maledictus" | "repurposed_structures:mansions" | "legendary_monsters:defeat_ambusher" | "jerotesvillage:jerotesvillage_craft_use" | "tetra:spelunking/find_scroll_gild" | "create:spout" | "lootr:root" | "minecraft:adventure/kill_a_mob" | "jerotesvillage:caught" | "create:millstone" | "create:pipe_organ" | "minecraft:husbandry/plant_any_sniffer_seed" | "incendium:infernal_dunes/pipeline/root" | "refinedstorage:security" | "incendium:technical/firestorm" | "jerotesvillage:additional_professions" | "tetra:art_of_forging/root" | "quark:get_forgotten_hat" | "jerotesvillage:rambler_skin" | "pasterdream:achievement_shadow_d_0" | "create:train_whistle" | "minecraft:adventure/adventuring_time" | "jerotesvillage:copper_carved_armor" | "jerotesvillage:watchman_of_flames" | "tetra:spelunking/geode_open" | "quark:apply_color_rune" | "jerotesvillage:crisp" | "incendium:technical/holy_wrath" | "dungeons_arise:find_ceryneian_hind" | "netherexp:nether/enter_soul_glass" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "minecraft:husbandry/axolotl_in_a_bucket" | "refinedstorage:autocrafting" | "netherexp:nether/lorekeeper" | "born_in_chaos_v1:horrorofthe_depths" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "minecraft:adventure/spyglass_at_dragon" | "born_in_chaos_v1:symphonyof_chaos" | "farmersdelight:main/craft_knife" | "netherexp:nether/ultra_overkill" | "biomancy:biomancy/cat_killer" | "minecraft:nether/ride_strider_in_overworld_lava" | "born_in_chaos_v1:explosive_temper" | "create:crusher_maxed_0000" | "minecraft:adventure/trade_at_world_height" | "pasterdream:achievement_special_0" | "lootr:100loot" | "dungeons_arise:find_infested_temple_map" | "create:fan_processing" | "tetra:spelunking/chthonic_cooldown" | "create:water_supply" | "netherexp:nether/stayin_frosty" | "tetra:upgrades/executioner_upgrade" | "tetra:scrolls/get_scroll_architects_crucible" | "quark:foxhound_speed_up_furnace" | "born_in_chaos_v1:grave_ravager" | "incendium:technical/on_block" | "minecraft:husbandry/wax_on" | "jerotesvillage:never_end" | "tetra:recipes/stonecutter" | "jerotesvillage:want_to_escape" | "netherexp:nether/soul_sand_valley" | "jerotesvillage:scaly_bear_hunter" | "biomancy:biomancy/organ_trader" | "jerotesvillage:deadly_dont_change" | "incendium:ash_barrens/enter_castle" | "minecraft:adventure/play_jukebox_in_meadows" | "tetra:upgrades/hammer_3" | "tetra:upgrades/hammer_4" | "tetra:upgrades/hammer_5" | "tetra:upgrades/hammer_6" | "dungeons_arise:find_heavenly_rider" | "quark:get_all_blossom_saplings" | "jerotesvillage:bright_grassland" | "tetra:upgrades/repairs" | "minecraft:adventure/hero_of_the_village" | "incendium:misc/soul_searcher" | "jerotesvillage:snowstorm" | "jerotesvillage:sand_beach" | "tetra:scrolls/find_scroll_key_guard" | "born_in_chaos_v1:dark_metallurgy" | "minecraft:nether/obtain_ancient_debris" | "repurposed_structures:witch_huts" | "tetra:spelunking/chthonic_crossbow" | "incendium:technical/on_effect_change" | "create:portable_storage_interface" | "tetra:upgrades/hammer_2" | "create:conductor" | "incendium:infernal_dunes/pipeline/kill_sentry" | "biomancy:biomancy/malignant_growth" | "explorerscompass:explorers_compass_cobweb" | "born_in_chaos_v1:dark_creator" | "minecraft:nether/create_full_beacon" | "takesapillage:bastille" | "minecraft:nether/summon_wither" | "cataclysm:kill_monstrosity" | "create:compacting" | "jerotesvillage:overlord" | "incendium:infernal_dunes/dune_blaze" | "legendary_monsters:legendary_monsters_root" | "tetra:spelunking/eerie_shard" | "tetra:spelunking/containers" | "minecraft:husbandry/balanced_diet" | "netherexp:nether/emf_raider" | "pasterdream:achievement_shadow_c_0" | "legendary_monsters:defeat_haunted_knight" | "refinedstorage:detecting" | "cataclysm:kill_all_bosses" | "takesapillage:pillager_camp" | "minecraft:nether/fast_travel" | "born_in_chaos_v1:mr_decoction" | "jerotesvillage:legacy_of_the_old_era" | "create:cart_pickup" | "born_in_chaos_v1:disgusting_lootbox" | "create:potato_cannon_collide" | "refinedstorage:connecting" | "tetra:art_of_forging/katana_upgrade" | "create:burner" | "create:precision_mechanism" | "tetra:spelunking/hammer_fix" | "netherexp:nether/ssv_sub_biomes" | "quark:crab_in_a_bucket" | "create:hose_pulley" | "incendium:technical/using/shield" | "dungeons_arise:find_mushroom_house" | "refinedstorage:storing_items" | "tetra:scrolls/find_scroll_dreadnought_stave" | "dungeons_arise:find_illager_windmill" | "refinedstorage:root" | "legendary_monsters:locate_soul_fortress_remains" | "refinedstorage:better_than_a_barrel" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "netherexp:nether/froghorn" | "repurposed_structures:ancient_cities" | "minecraft:husbandry/root" | "netherexp:nether/occult_manor" | "create:shifting_gears" | "tetra:scrolls/get_scroll_flamberge" | "legendary_monsters:defeat_bomber" | "incendium:technical/inventory/firestorm" | "create:train_casing_00" | "tetra:art_of_forging/echo_fuller" | "netherexp:nether/angel_with_a_shotgun" | "tetra:spelunking/schematic_complete" | "faded_conquest_2:ttslain" | "born_in_chaos_v1:bornin_chaos" | "biomancy:biomancy/craft_primal_core" | "legendary_monsters:nether_root" | "minecraft:nether/use_lodestone" | "incendium:quartz_flats/feed_ghastling" | "pasterdream:achievement_shadow_npc_2" | "pasterdream:achievement_shadow_npc_1" | "minecraft:husbandry/safely_harvest_honey" | "pasterdream:achievement_shadow_npc_4" | "pasterdream:achievement_shadow_npc_3" | "minecraft:adventure/trade" | "pasterdream:achievement_shadow_npc_5" | "pasterdream:achievement_shadow_a_1" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "incendium:ash_barrens/root" | "refinedstorage:manipulating_disks" | "pasterdream:achievement_shadow_a_0" | "incendium:quartz_flats/torte/root" | "biomancy:biomancy/primal_orifice" | "incendium:ash_barrens/duel_of_the_fates" | "legendary_monsters:defeat_frostbitten_golem" | "minecraft:story/mine_diamond" | "pasterdream:achievement_shadow_npc_0" | "incendium:quartz_flats/ghast_buster" | "farmersdelight:main/eat_comfort_food" | "create:track_crafting_factory" | "create:belt" | "repurposed_structures:ruined_portal_end" | "pasterdream:achievement_nether_0" | "pasterdream:achievement_b_2" | "create:long_train" | "pasterdream:achievement_b_1" | "pasterdream:achievement_b_3" | "farmersdelight:main/plant_all_crops" | "jerotesvillage:supersonic_speed" | "born_in_chaos_v1:cultural_attribute" | "tetra:spelunking/find_planar" | "pasterdream:achievement_treasure_start" | "tetra:spelunking/find_ruins_map" | "create:backtank" | "born_in_chaos_v1:the_wind_darkening" | "quark:get_diamond_heart" | "cataclysm:find_cursed_pyramid" | "tetra:upgrades/sword_hone" | "minecraft:husbandry/kill_axolotl_target" | "faded_conquest_2:godslayer" | "minecraft:nether/find_fortress" | "netherexp:nether/ayo_the_pizza_here" | "jerotesvillage:elemental_materials" | "born_in_chaos_v1:unitywith_darknessachievement" | "incendium:infernal_dunes/inferno/summon" | "tetra:spelunking/find_nano_insectoid" | "refinedstorage:monitoring" | "pasterdream:achievement_b_0" | "minecraft:adventure/throw_trident" | "tetra:art_of_forging/rending_scissor_complete_upgrade" | "tetra:upgrades/double_headed" | "jerotesvillage:round_trip_freely" | "legendary_monsters:locate_skeletosaurus_nest" | "born_in_chaos_v1:hatman" | "cataclysm:root" | "jerotesvillage:be_careful_of_vibrations" | "create:lava_wheel_00000" | "jerotesvillage:why_is_there_grass_growing_on_your_head" | "jerotesvillage:keep_sneaking" | "jerotesvillage:second_round_world_key" | "incendium:technical/on_sword_get" | "born_in_chaos_v1:compact_necromancy" | "tetra:spelunking/hammer_remove" | "dungeons_arise:find_monasteries" | "legendary_monsters:defeat_withered_abomination" | "biomancy:biomancy/greedy_butcher" | "born_in_chaos_v1:bypassingthe_expiration_date" | "minecraft:story/root" | "born_in_chaos_v1:deceived_hopes" | "quark:redirect_beacon" | "biomancy:biomancy/predator_killer" | "minecraft:recipes/root" | "born_in_chaos_v1:infernal_medicine" | "legendary_monsters:defeat_overgrown_colossus" | "pasterdream:achievement_d_0" | "create:belt_funnel_kiss" | "minecraft:adventure/honey_block_slide" | "minecraft:adventure/ol_betsy" | "born_in_chaos_v1:my_size" | "tetra:spelunking/craft_architects_mark" | "incendium:misc/ruined_lab" | "pasterdream:achievement_end_0" | "incendium:volcanic_deltas/root" | "jerotesvillage:coven" | "incendium:technical/new_player" | "repurposed_structures:ruins" | "refinedstorage:importing" | "netherexp:nether/blind_shot" | "netherexp:nether/rekindled_betrayal" | "explorerscompass:explorers_compass" | "quark:shiba_help" | "incendium:technical/give_ghastling" | "minecraft:nether/netherite_armor" | "create:linked_controller" | "create:arm_many_targets" | "tetra:spelunking/find_scroll_efficiency" | "tetra:spelunking/stonecutter_enchant" | "incendium:technical/on_kill" | "tetra:spelunking/find_codex" | "jerotesvillage:monument" | "legendary_monsters:defeat_lava_eater" | "tetra:art_of_forging/euclidean_dagger_upgrade" | "farmersdelight:main/harvest_ropelogged_tomato" | "minecraft:story/enter_the_end" | "pasterdream:achievement_adventure_0" | "tetra:art_of_forging/architects_crucible" | "minecraft:husbandry/breed_an_animal" | "tetra:story/more_upgrades" | "incendium:technical/root" | "minecraft:husbandry/complete_catalogue" | "jerotesvillage:constructed_nature" | "dungeons_arise:find_scorched_mines" | "biomancy:biomancy/digester" | "refinedstorage:construction" | "repurposed_structures:fortress_jungle" | "jerotesvillage:unknown_deep" | "incendium:misc/loot_piglin_village" | "born_in_chaos_v1:junior_summoner" | "legendary_monsters:locate_mossy_temple";
    type RecipeId = "farmersdelight:cutting/brown_mushroom_colony" | "prefab:phasic_block" | "create:polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "create:milling/compat/byg/violet_leather_flower" | "create:cutting/compat/nethers_exoticism/jabuticaba_log" | "create:milling/charcoal" | "biomancy:decomposing/golden_apple" | "quark:building/crafting/vertslabs/myalite_bricks_vertical_slab" | "jerotesvillage:meror_metal_sword_craft" | "refinedstorage:coloring_recipes/red_detector" | "create:milling/compat/environmental/violet" | "biomancy:decomposing/ferrouslime_ball" | "minecraft:stonecutter" | "refinedstorage:coloring_recipes/pink_security_manager" | "quark:building/stonecutting/vertslabs/weathered_cut_copper_vertical_slab_from_weathered_copper" | "create:pressing/compat/betterendforge/amber_moss_path" | "quark:world/crafting/stairs/granite_bricks_stairs" | "minecraft:bone_block" | "refinedstorage:coloring_recipes/red_pattern_grid" | "minecraft:melon" | "create:cut_andesite_slab" | "born_in_chaos_v1:black_argillite_brick_wall_k" | "quark:building/crafting/glass/pink_framed_glass" | "create:cut_granite_wall" | "meed:born_in_chaos_v1/living_bomb" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "create:smelting/glass_from_vertical_framed_glass" | "create:cutting/compat/goodending/stripped_cypress_log" | "minecraft:gold_nugget_from_blasting" | "create:oak_window" | "cataclysm:obsidian_brick_wall" | "born_in_chaos_v1:black_argillite_sk_2" | "farmersdelight:cutting/bamboo_trapdoor" | "quark:building/crafting/stonevariants/calcite_pillar" | "cataclysm:end_stone_teleport_trap_bricks" | "quark:building/crafting/vertplanks/vertical_oak_planks" | "quark:building/stonecutting/stonevariants/granite_bricks_wall_rough_stonecutting" | "quark:oddities/crafting/pipe" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:void_upgrade" | "create:brass_ladder_from_ingots_brass_stonecutting" | "create:crushing/copper_ore" | "quark:tools/smithing/rune_smithing_light_gray" | "minecraft:cobblestone_wall" | "quark:building/stonecutting/stonevariants/tuff_bricks_stairs_polished_stonecutting" | "quark:world/crafting/woodsets/blossom/trapdoor" | "farmersdelight:cutting/ink_sac" | "minecraft:lime_stained_glass_pane" | "jerotesvillage:malignasaur_bait_fishgig_craft" | "create:deploying/waxed_exposed_copper_tile_stairs_from_adding_wax" | "minecraft:raw_copper" | "create:cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "farmersdelight:cutting/acacia_sign" | "create:cut_scorchia_slab_recycling" | "quark:building/crafting/acacia_ladder" | "create:splashing/endergetic/petrified_end_corrock_block" | "quark:building/crafting/vertslabs/dark_oak_vertical_slab" | "create:cutting/compat/regions_unexplored/stripped_socotra_wood" | "quark:building/crafting/stonevariants/vanilla/polished_calcite" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "create:crushing/compat/elementaryores/ore_lapis_end" | "farmersdelight:sweet_berry_cheesecake" | "minecraft:map_extending" | "minecraft:spruce_sign" | "create:cutting/compat/regions_unexplored/joshua_wood" | "quark:building/crafting/vertslabs/light_gray_shingles_vertical_slab_revert" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "jerotesvillage:meror_metal_pickaxe_craft" | "create:crafting/logistics/brass_tunnel" | "quark:building/stonecutting/stairs/yellow_shingles_stairs_stonecutter" | "create:crushing/raw_silver" | "quark:world/stonecutting/stairs/polished_myalite_stairs_stonecutter" | "sophisticatedbackpacks:advanced_refill_upgrade" | "refinedstorage:crafting_grid/brown_crafting_grid" | "minecraft:glow_item_frame" | "refinedstorage:pattern" | "cataclysm:chorus_trapdoor" | "create:crafting/materials/sand_paper" | "minecraft:chiseled_nether_bricks" | "meed:corrosion" | "quark:world/crafting/woodsets/blossom/pressure_plate" | "minecraft:copper_block" | "create:cutting/spruce_wood" | "jerotesvillage:dye_from_cyan_root" | "create:blasting/silver_ingot_compat_thermal" | "quark:tweaks/crafting/slab_to_block" | "minecraft:green_stained_glass" | "create:cutting/crimson_hyphae" | "quark:building/crafting/compressed/potato_crate" | "quark:building/crafting/vertslabs/cyan_shingles_vertical_slab" | "create:cutting/compat/botania/stripped_dreamwood" | "jerotesvillage:gemstone_throwing_knife_craft" | "quark:building/crafting/vertslabs/nether_brick_vertical_slab" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "farmersdelight:integration/create/milling/wild_beetroots" | "quark:building/crafting/lamps/red_crystal_lamp" | "create:milling/compat/regions_unexplored/wilting_trillium" | "quark:world/crafting/slabs/myalite_slab" | "create:cutting/compat/regions_unexplored/yellow_bioshroom_hyphae" | "pasterdream:crafying_314" | "refinedstorage:coloring_recipes/blue_crafting_grid" | "biomancy:decomposing/porous_primal_flesh_stairs" | "quark:building/stonecutting/vertslabs/shale_bricks_vertical_slab_stonecutter" | "quark:building/stonecutting/vertslabs/blue_shingles_vertical_slab_stonecutter2" | "minecraft:cut_sandstone_slab" | "quark:world/crafting/woodsets/ancient/chest" | "refinedstorage:coloring_recipes/fluid_grid" | "minecraft:cherry_door" | "netherexp:inscribed_panel" | "jerotesvillage:villager_metal_mortar_and_pestle_craft" | "biomancy:bio_brewing/shrinking_serum" | "meed:born_in_chaos_v1/magic_depletion" | "quark:mobs/campfire/cooked_crab_leg" | "minecraft:acacia_door" | "refinedstorage:coloring_recipes/white_grid" | "create:cutting/compat/blue_skies/dusk_log" | "minecraft:mangrove_wood" | "quark:building/stonecutting/slabs/red_sandstone_bricks_slab_stonecutter" | "quark:world/stonecutting/slabs/myalite_bricks_slab_stonecutter" | "minecraft:cyan_concrete_powder" | "minecraft:mojang_banner_pattern" | "create:cutting/compat/regions_unexplored/cobalt_wood" | "minecraft:dye_pink_wool" | "quark:building/stonecutting/slabs/gray_shingles_slab_stonecutter" | "minecraft:fire_charge" | "minecraft:golden_hoe" | "create:cutting/stripped_warped_stem" | "create:cutting/compat/biomesoplenty/stripped_hellbark_wood" | "quark:building/stonecutting/vertslabs/smooth_sandstone_vertical_slab_stonecutter" | "minecraft:dye_green_bed" | "biomancy:decomposing/flesh_pillar" | "create:pressing/compat/environmental/mycelium_path" | "farmersdelight:rice_roll_medley_block" | "refinedstorage:fluid_grid/light_gray_fluid_grid" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "create:cutting/compat/biomesoplenty/stripped_umbran_log" | "biomancy:decomposing/totem_of_undying" | "cataclysm:stonecutting/stone_tiles_from_stonecutting" | "minecraft:stone_button" | "jerotesvillage:bitter_cold_door_craft" | "prefab:double_compressed_obsidian" | "minecraft:sandstone" | "quark:building/stonecutting/stonevariants/chiseled_jasper_bricks_stonecutter" | "create:polished_cut_scoria_slab" | "lendersdelight:cook/cooked_leviathan_from_smoking" | "create:milling/compat/byg/winter_rose" | "minecraft:purpur_block" | "farmersdelight:cutting/smoked_ham" | "minecraft:polished_blackstone_slab" | "quark:building/crafting/vertslabs/red_sandstone_vertical_slab_revert" | "protection_pixel:breakerasloot" | "farmersdelight:blue_canvas_sign" | "create:cutting/compat/botania/dreamwood_log" | "refinedstorage:coloring_recipes/brown_pattern_grid" | "refinedstorage:coloring_recipes/yellow_fluid_grid" | "protection_pixel:tosakichestloot" | "minecraft:gray_concrete_powder" | "farmersdelight:cyan_hanging_canvas_sign" | "cataclysm:weapon_infusion/wrath_of_the_desert" | "quark:building/crafting/slabs/purple_shingles_slab" | "jerotesvillage:hag_replacement/jerotesvillage_cooked_meganose_snow_lizard_meat" | "quark:building/crafting/vertslabs/exposed_cut_copper_vertical_slab_revert" | "quark:building/stonecutting/stairs/red_shingles_stairs_stonecutter" | "create:crafting/kinetics/mechanical_roller" | "minecraft:redstone_from_blasting_redstone_ore" | "quark:building/crafting/furnaces/deepslate_furnace" | "jerotesvillage:wonderland_trapdoor_craft" | "refinedstorage:coloring_recipes/white_detector" | "quark:building/stonecutting/vertslabs/polished_dripstone_vertical_slab_stonecutter" | "prefab:eggs_from_clutch" | "jerotesvillage:sun_sandstone_craft" | "quark:building/stonecutting/stonevariants/tuff_bricks_vertical_slab_rough_stonecutting" | "born_in_chaos_v1:pileof_skulls_k_2" | "biomancy:bio_brewing/organic_compound" | "born_in_chaos_v1:scorched_planks_fence_k" | "jerotesvillage:sun_sand_tnt_craft" | "quark:world/crafting/slabs/diorite_bricks_slab" | "refinedstorage:coloring_recipes/red_grid" | "minecraft:lime_candle" | "minecraft:red_dye_from_beetroot" | "create:cutting/compat/twilightforest/stripped_mangrove_wood" | "quark:building/crafting/vertslabs/smooth_soul_sandstone_vertical_slab_revert" | "quark:building/crafting/vertslabs/polished_limestone_vertical_slab_revert" | "lendersdelight:coral_chunk_sandwich" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "quark:building/stonecutting/stonevariants/andesite_bricks_vertical_slab_rough_stonecutting" | "quark:building/stonecutting/vertslabs/purple_shingles_vertical_slab_stonecutter" | "create:small_asurine_bricks_from_stone_types_asurine_stonecutting" | "create:cutting/compat/byg/green_enchanted_log" | "jerotesvillage:second_round_nigrum_craft" | "biomancy:crafting/fibrous_flesh_stairs" | "quark:building/crafting/bamboo_mat_carpet" | "refinedstorage:coloring_recipes/orange_wireless_transmitter" | "quark:building/stonecutting/vertslabs/polished_diorite_vertical_slab2_stonecutter" | "quark:building/stonecutting/stonevariants/shale_bricks_slab_rough_stonecutting" | "biomancy:decomposing/relicheirus_egg" | "refinedstorage:pattern_grid/gray_pattern_grid" | "minecraft:birch_stairs" | "minecraft:exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "create:item_application/brass_casing_from_log" | "create:splashing/light_gray_concrete_powder" | "create:cutting/compat/tconstruct/greenheart_log" | "create:polished_cut_tuff_slab" | "biomancy:decomposing/warped_roots" | "refinedstorage:coloring_recipes/magenta_network_receiver" | "jerotesvillage:villager_block_dye_merchant_craft" | "quark:building/stonecutting/walls/dripstone_block_wall_stonecutter" | "biomancy:decomposing/cockroach_wing_fragment" | "quark:building/crafting/red_stool" | "quark:world/crafting/slabs/jasper_slab" | "refinedstorage:coloring_recipes/brown_network_receiver" | "quark:world/crafting/woodsets/ancient/planks" | "create:cutting/compat/regions_unexplored/blue_bioshroom_stem" | "biomancy:decomposing/primal_bloom" | "create:milling/compat/byg/angelica" | "create:smelting/ingot_silver_compat_ic2" | "refinedstorage:coloring_recipes/light_gray_fluid_grid" | "create:crafting/kinetics/chute" | "refinedstorage:coloring_recipes/purple_crafter_manager" | "minecraft:cyan_glazed_terracotta" | "quark:building/crafting/yellow_blossom_hedge" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "quark:building/stonecutting/vertslabs/cobbled_deepslate_vertical_slab_from_cobbled_deepslate" | "minecraft:stone_sword" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "create:crafting/materials/small_rose_quartz_tilesfrom_conversion" | "quark:building/crafting/vertslabs/blossom_planks_vertical_slab_revert" | "prefab:quartz_crete_stairs_smooth_up_right" | "quark:building/crafting/glass/purple_framed_glass" | "biomancy:crafting/nutrient_bar" | "create:cut_ochrum_brick_stairs" | "farmersdelight:milk_bottle" | "jerotesvillage:mysterest_perfume_from_campfire_cooking" | "jerotesvillage:serpon_torch_craft" | "quark:building/crafting/vertslabs/granite_vertical_slab" | "refinedstorage:coloring_recipes/yellow_crafter" | "farmersdelight:cutting/mangrove_trapdoor" | "minecraft:iron_ingot_from_iron_block" | "create:polished_cut_asurine_stairs" | "quark:building/stonecutting/stonevariants/granite_bricks_stairs_rough_stonecutting" | "create:crafting/kinetics/fluid_tank" | "create:cutting/compat/blue_skies/stripped_maple_log" | "create:smoking/bread" | "biomancy:digesting/nutrient_paste_from_vine" | "quark:building/crafting/glass/gray_framed_glass" | "create:cutting/stripped_jungle_log" | "biomancy:stonecutting/malignant_flesh_wall_from_malignant_flesh" | "quark:tweaks/crafting/utility/wool/white_wool" | "create:cutting/compat/blue_skies/starlit_log" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "quark:building/stonecutting/slabs/blackstone_bricks_slab_stonecutter" | "prefab:defense_bunker" | "jerotesvillage:hag_replacement/minecraft_gravel" | "jerotesvillage:qoaiku_shovel_craft" | "minecraft:banner_duplicate" | "create:cutting/compat/blue_skies/maple_log" | "minecraft:granite_stairs_from_granite_stonecutting" | "create:small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "quark:building/crafting/walls/calcite_wall" | "quark:building/stonecutting/yellow_shingles_stonecutter2" | "jerotesvillage:sun_sandstone_slab_from_sun_sandstone_stonecutting" | "minecraft:iron_ingot_from_nuggets" | "minecraft:golden_pickaxe" | "legendary_monsters:ancient_dripstone_brick_wall_stonecutter_adbr" | "quark:building/crafting/vertslabs/mossy_stone_brick_vertical_slab" | "cataclysm:frosted_stone_brick_wall" | "create:cutting/compat/byg/stripped_lament_log" | "minecraft:chiseled_bookshelf" | "netherexp:stonecutting/from_netherrack_bricks/netherrack_brick_slab" | "create:filling/compat/regions_unexplored/silt_grass_block" | "jerotesvillage:glistering_flavorless_melon_slice_craft" | "minecraft:ladder" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "quark:building/stonecutting/cyan_shingles_stonecutter2" | "create:filling/builders_tea" | "cataclysm:stonecutting/purpur_tiles_from_stonecutting" | "biomancy:decomposing/tarantula_hawk_wing" | "create:milling/compat/botania/yellow_petal" | "minecraft:redstone_torch" | "farmersdelight:pumpkin_from_slices" | "create:small_tuff_brick_stairs" | "quark:tweaks/crafting/utility/chest_boat/direct_ancient_chest_boat" | "create:crafting/kinetics/deployer" | "biomancy:decomposing/forge_eggs" | "minecraft:gray_bed" | "jerotes:iron_nugget_from_other_blast" | "farmersdelight:basket" | "refinedstorage:detector" | "refinedstorage:pattern_grid/brown_pattern_grid" | "jerotesvillage:meror_standard_upgrade_smithing_template_craft" | "create:crafting/materials/andesite_alloy" | "create:cutting/compat/regions_unexplored/socotra_log" | "tetra:hammer/granite" | "minecraft:white_terracotta" | "quark:building/crafting/vertslabs/shale_vertical_slab_revert" | "meed:soulsweapons/bleed" | "minecraft:diamond_from_blasting_deepslate_diamond_ore" | "minecraft:armor_stand" | "jerotesvillage:malignasaur_fishgig_craft" | "create:milling/compat/regions_unexplored/white_trillium" | "meed:enlightened_end/burdened" | "minecraft:pink_stained_glass_pane" | "minecraft:blue_dye_from_cornflower" | "quark:building/crafting/vertslabs/granite_bricks_vertical_slab_revert" | "minecraft:stripped_cherry_wood" | "protection_pixel:chestplatelingingloot" | "sophisticatedbackpacks:chipped/alchemy_bench_upgrade" | "prefab:compressed_glowstone_to_glowstone" | "minecraft:quartz_slab_from_stonecutting" | "quark:building/crafting/glass/blue_framed_glass" | "minecraft:brown_banner" | "farmersdelight:tomato_crate" | "netherexp:chiseled_soul_slate_bricks" | "quark:tweaks/crafting/utility/chest_boat/direct_acacia_chest_boat" | "minecraft:warped_hyphae" | "biomancy:decomposing/ornate_flesh" | "biomancy:crafting/clay_ball_from_stone_powder" | "create:cutting/compat/biomesoplenty/redwood_wood" | "create:cutting/compat/regions_unexplored/stripped_mauve_log" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "create:cut_calcite_slab_from_stone_types_calcite_stonecutting" | "pasterdream:smelting_9" | "pasterdream:smelting_8" | "quark:building/stonecutting/stonevariants/dripstone_bricks_slab_rough_stonecutting" | "pasterdream:smelting_5" | "pasterdream:smelting_4" | "biomancy:digesting/nutrient_paste_from_digesting_dynamic_food" | "pasterdream:smelting_7" | "jerotesvillage:celestial_coilvine_carpet_craft" | "pasterdream:smelting_6" | "cataclysm:storm_eye" | "meed:born_in_chaos_v1/detonation" | "protection_pixel:platformloot" | "quark:building/stonecutting/vertslabs/red_shingles_vertical_slab_stonecutter2" | "prefab:bunch_of_beets_from_crate" | "quark:world/crafting/woodsets/azalea/pressure_plate" | "quark:building/stonecutting/vertslabs/polished_jasper_vertical_slab_stonecutter2" | "minecraft:green_bed" | "create:layered_ochrum_from_stone_types_ochrum_stonecutting" | "jerotesvillage:meror_metal_giant_beast_armor_craft" | "quark:building/crafting/vertslabs/myalite_vertical_slab" | "quark:world/stonecutting/permafrost_bricks_stonecutter" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "netherexp:soul_skeleton_skull_candle" | "netherexp:soul_slate_brick_pillar" | "farmersdelight:painting_from_canvas" | "create:small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "quark:building/stonecutting/vertslabs/light_gray_shingles_vertical_slab_stonecutter" | "art_of_forging:demonic_flail" | "prefab:nether_gate" | "create:crushing/raw_platinum" | "meed:enlightened_end/enderstride" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "jerotesvillage:iron_nugget_from_ancient_second_rounder_blast" | "create:crushing/silver_ore" | "quark:building/stonecutting/slabs/cyan_shingles_slab_stonecutter2" | "create:small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "jerotesvillage:dye_from_harmonious_dream_bell" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "create:cutting/stripped_acacia_log" | "minecraft:gray_banner" | "pasterdream:smelting_1" | "create:small_crimsite_brick_wall" | "minecraft:warped_stairs" | "pasterdream:smelting_3" | "pasterdream:smelting_2" | "prefab:watch_tower" | "quark:building/crafting/vertslabs/smooth_red_sandstone_vertical_slab" | "create:deploying/waxed_weathered_cut_copper_stairs_from_adding_wax" | "refinedstorage:coloring_recipes/magenta_controller" | "create:splashing/orange_concrete_powder" | "refinedstorage:coloring_recipes/red_relay" | "create:crushing/compat/elementaryores/ore_copper_end" | "quark:building/stonecutting/stonevariants/andesite_bricks_stairs_rough_stonecutting" | "create:small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "create:crushing/compat/silentgems/peridot_ore" | "quark:world/stonecutting/stairs/shale_bricks_stairs_stonecutter" | "prefab:triple_compressed_stone_from_double_compressed_stone" | "create:crushing/compat/simplefarming/rice" | "create:cutting/compat/quark/stripped_azalea_wood" | "jerotesvillage:magicka_scale_helmet_smith" | "minecraft:smooth_sandstone_slab" | "prefab:lanterns_to_string_of_lanterns" | "netherexp:stonecutting/nether_brick_pillar_from_nether_bricks" | "refinedstorage:coloring_recipes/red_crafter" | "biomancy:decomposing/void_worm_mandible" | "minecraft:rail" | "create:milling/compat/environmental/pink_hibiscus" | "jerotesvillage:refine_meror_metal_block_craft" | "create:crushing/compat/exnihilosequentia/andesite" | "minecraft:diamond_sword" | "netherexp:smooth_silica_sandstone_slab" | "create:cutting/compat/ars_nouveau/red_archwood_wood" | "quark:building/crafting/vertslabs/raw_copper_bricks_vertical_slab_revert" | "refinedstorage:coloring_recipes/magenta_crafting_grid" | "farmersdelight:cutting/oak_trapdoor" | "quark:building/crafting/vertslabs/cut_red_sandstone_vertical_slab_revert" | "farmersdelight:cooking/dumplings" | "quark:building/crafting/vertslabs/waxed_weathered_cut_copper_vertical_slab" | "jerotesvillage:therapeutic_tablet_craft" | "create:milling/compat/biomesoplenty/rose" | "create:cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "biomancy:decomposing/forge_feathers" | "netherexp:stonecutting/from_soul_slate/soul_slate_brick_stairs" | "refinedstorage:pattern_grid/blue_pattern_grid" | "quark:building/crafting/flowering_azalea_hedge" | "protection_pixel:hammerasloot" | "quark:world/crafting/panes/red_corundum" | "quark:building/crafting/stonevariants/diorite_pillar" | "quark:building/crafting/vertslabs/sandstone_bricks_vertical_slab" | "quark:building/crafting/azalea_hedge" | "quark:building/crafting/slabs/dripstone_bricks_slab" | "born_in_chaos_v1:fired_black_argillite_k" | "biomancy:decomposing/impermeable_membrane_pane" | "lendersdelight:coral_and_void" | "quark:building/stonecutting/slabs/black_shingles_slab_stonecutter2" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "biomancy:decomposing/crimson_roots" | "protection_pixel:hammerloot" | "create:oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "jerotesvillage:bright_land_drum_craft" | "cataclysm:obsidian_brick_stairs" | "create:cutting/compat/tconstruct/stripped_skyroot_log" | "create:cut_limestone_brick_slab" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "farmersdelight:book_from_canvas" | "quark:building/stonecutting/vertslabs/blue_shingles_vertical_slab_stonecutter" | "lendersdelight:cook/cooked_netherite_monstrosity_meat_from_campfire_cooking" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "legendary_monsters:ancient_dripstone_tile_slab_stonecutter_adp" | "born_in_chaos_v1:minticecream_k" | "meed:marked" | "sophisticatedbackpacks:advanced_pickup_upgrade" | "biomancy:digesting/nutrient_paste_from_cake" | "jerotesvillage:hag_replacement/jerotesvillage_drought_fire_mud" | "create:crushing/asurine_recycling" | "jerotesvillage:gold_nugget_from_bright_golden_melon_hammer_blast" | "create:cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "jerotesvillage:glitter_sandstone_slab_craft" | "jerotesvillage:meror_metal_ingotin_craft" | "minecraft:mangrove_planks" | "biomancy:decomposing/radgill" | "waystones:sandy_waystone" | "minecraft:iron_nugget_from_blasting" | "quark:building/crafting/warped_bookshelf" | "refinedstorage:coloring_recipes/pink_fluid_grid" | "jerotesvillage:meror_scythe_craft" | "refinedstorage:256k_fluid_storage_disk" | "create:cutting/mangrove_wood" | "jerotesvillage:second_round_nigrum_soup_craft" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_hyphae" | "jerotesvillage:purple_sandstone_wall_from_purple_sandstone_stonecutting" | "create:milling/azure_bluet" | "farmersdelight:integration/immersiveengineering/cloche/onion" | "quark:building/stonecutting/stairs/pink_shingles_stairs_stonecutter" | "create:cutting/warped_hyphae" | "quark:world/crafting/permafrost_bricks" | "minecraft:green_stained_glass_pane" | "minecraft:magenta_dye_from_blue_red_pink" | "farmersdelight:red_hanging_canvas_sign" | "quark:building/stonecutting/vertslabs/dark_prismarine_vertical_slab_stonecutter" | "netherexp:stonecutting/from_pale_soul_slate/stairs" | "minecraft:black_concrete_powder" | "functionalstorage:framed_simple_compacting_drawer" | "biomancy:decomposing/packed_flesh" | "minecraft:lime_carpet" | "minecraft:sugar_from_sugar_cane" | "create:polished_cut_diorite_slab_recycling" | "cataclysm:stone_pillar" | "biomancy:decomposing/serrated_shark_tooth" | "quark:building/crafting/walls/raw_copper_bricks_wall" | "quark:building/crafting/stairs/soul_sandstone_stairs" | "quark:world/crafting/woodsets/azalea/chest_boat" | "minecraft:cooked_beef_from_campfire_cooking" | "minecraft:quartz_pillar" | "farmersdelight:cutting/leather_leggings" | "create:deploying/waxed_copper_shingles_from_adding_wax" | "sophisticatedbackpacks:jukebox_upgrade" | "legendary_monsters:ancient_dripstone_brick_wall_stonecutter_adp" | "minecraft:dye_red_wool" | "functionalstorage:framed_controller_extension" | "refinedstorage:construction_core" | "minecraft:waxed_cut_copper_from_honeycomb" | "refinedstorage:coloring_recipes/yellow_network_receiver" | "born_in_chaos_v1:houndtrapk" | "cataclysm:stonecutting/azure_seastone_slab_from_stonecutting" | "functionalstorage:birch_2" | "create:crushing/iron_ore" | "functionalstorage:birch_1" | "jerotesvillage:black_yellow_fence_craft" | "functionalstorage:birch_4" | "quark:building/stonecutting/stairs/red_shingles_stairs_stonecutter2" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_brick_slab" | "quark:building/crafting/compressed/charcoal_block_uncompress" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "jerotesvillage:carved_leather_helmet_smith" | "refinedstorage:pattern_grid/pink_pattern_grid" | "quark:building/crafting/blossom_post" | "quark:building/crafting/blackstone_bricks" | "farmersdelight:organic_compost_from_rotten_flesh" | "minecraft:muddy_mangrove_roots" | "quark:building/crafting/vertslabs/oak_vertical_slab" | "create:cutting/compat/regions_unexplored/blackwood_wood" | "create:splashing/supplementaries/blackboard" | "create:small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "quark:building/crafting/vertslabs/shingles_vertical_slab" | "netherexp:gargoyle_statues/trample" | "jerotesvillage:serpon_war_beast_armor_craft" | "waystones:white_sharestone" | "create:weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "born_in_chaos_v1:black_argillite_sl_k" | "create:cutting/compat/regions_unexplored/magnolia_wood" | "quark:building/stonecutting/stonevariants/chiseled_limestone_bricks_stonecutter" | "minecraft:light_gray_banner" | "cataclysm:chiseled_azure_seastone_pillar" | "quark:building/crafting/vertslabs/purple_shingles_vertical_slab_revert" | "farmersdelight:cutting/mangrove_sign" | "minecraft:wooden_axe" | "refinedstorage:coloring_recipes/magenta_crafting_monitor" | "biomancy:decomposing/mob_gland" | "create:cutting/compat/byg/ether_wood" | "protection_pixel:falconnestloot" | "create:smelting/glass_from_tiled_glass" | "jerotesvillage:meror_metal_leggings_craft" | "meed:biomancy/drowsy" | "jerotesvillage:bright_cobblestone_slab_craft" | "create:pressing/brass_ingot" | "create:small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:smelting/ingot_silver_compat_immersiveengineering" | "minecraft:trapped_chest" | "biomancy:crafting/gunpowder_from_unstable_compound" | "biomancy:decomposing/clay" | "create:oak_window_pane" | "quark:world/crafting/stairs/azalea_planks_stairs" | "quark:building/stonecutting/stonevariants/myalite_bricks_vertical_slab_polished_stonecutting" | "jerotesvillage:wilderness_giant_hunter_camp_map_craft" | "create:cutting/compat/goodending/stripped_muddy_oak_log" | "minecraft:stone_stairs_from_stone_stonecutting" | "create:polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "jerotesvillage:virtual_cave_fishing_net_craft" | "biomancy:crafting/primal_permeable_membrane_from_primal_permeable_membrane_pane" | "minecraft:dried_kelp" | "tetra:toolbelt_modular" | "create:andesite_from_stone_types_andesite_stonecutting" | "minecraft:polished_andesite_stairs_from_andesite_stonecutting" | "create:cut_asurine_stairs" | "tetra:gild_scroll_3" | "minecraft:iron_bars" | "tetra:gild_scroll_4" | "tetra:gild_scroll_5" | "quark:world/stonecutting/slabs/polished_jasper_slab_stonecutter" | "biomancy:crafting/fibrous_flesh_wall" | "art_of_forging:forged_platform" | "tetra:gild_scroll_2" | "create:crafting/appliances/clipboard" | "minecraft:diamond_axe" | "biomancy:digesting/nutrient_paste_from_crocodile_egg" | "create:smelting/nickel_ingot_compat_thermal" | "tetra:flamberge_scroll" | "create:cutting/compat/byg/stripped_skyris_log" | "born_in_chaos_v1:black_argillite_column_slab_k_2" | "create:crushing/compat/elementaryores/ore_diamond_nether" | "born_in_chaos_v1:black_argillite_sl_k_2" | "refinedstorage:coloring_recipes/brown_crafting_monitor" | "biomancy:decomposing/netherite_ingot" | "biomancy:crafting/packed_flesh_stairs" | "quark:world/stonecutting/slabs/polished_limestone_slab_stonecutter" | "quark:building/crafting/mud_brick_lattice" | "minecraft:dark_oak_pressure_plate" | "minecraft:dye_blue_wool" | "prefab:bundle_of_timber_to_logs" | "quark:building/crafting/brown_stool" | "quark:world/crafting/woodsets/ancient/trapdoor" | "quark:building/crafting/vertslabs/wax/waxed_oxidized_cut_copper_vertical_slab_hc" | "refinedstorage:coloring_recipes/lime_detector" | "create:splashing/purple_concrete_powder" | "cataclysm:stonecutting/chiseled_azure_seastone_from_stonecutting" | "pasterdream:stonecutting_25" | "create:cut_deepslate_slab" | "pasterdream:stonecutting_24" | "pasterdream:stonecutting_23" | "pasterdream:stonecutting_22" | "pasterdream:stonecutting_29" | "quark:building/stonecutting/vertslabs/polished_calcite_vertical_slab_stonecutter" | "pasterdream:stonecutting_28" | "pasterdream:stonecutting_27" | "pasterdream:stonecutting_26" | "minecraft:waxed_cut_copper" | "quark:building/stonecutting/stonevariants/shale_pillar_stonecutter" | "pasterdream:stonecutting_21" | "jerotesvillage:iron_nugget_from_other_blast" | "pasterdream:stonecutting_20" | "create:polished_cut_dripstone_wall" | "lendersdelight:red_coral_stew" | "create:cutting/compat/hexcasting/stripped_edified_wood" | "minecraft:chiseled_polished_blackstone" | "create:crafting/curiosities/minecart_coupling" | "create:cut_deepslate_brick_slab" | "create:cutting/compat/ars_nouveau/stripped_purple_archwood_log" | "quark:building/crafting/stonevariants/dripstone_pillar" | "quark:building/crafting/slabs/tuff_slab" | "pasterdream:stonecutting_19" | "biofactory:special_crafting/acolyte_armor_helmet" | "create:cut_granite_stairs_from_stone_types_granite_stonecutting" | "prefab:compressed_obsidian_from_double_compressed_obsidian" | "pasterdream:stonecutting_14" | "meed:ars_nouveau/glide" | "pasterdream:stonecutting_13" | "quark:building/crafting/vertslabs/bamboo_vertical_slab" | "create:cutting/stripped_spruce_wood" | "pasterdream:stonecutting_12" | "pasterdream:stonecutting_11" | "pasterdream:stonecutting_18" | "create:crushing/compat/byg/emeraldite_ore" | "jerotesvillage:explorer_iron_helmet_smith" | "pasterdream:stonecutting_17" | "pasterdream:stonecutting_16" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "pasterdream:stonecutting_15" | "biomancy:bio_brewing/unstable_compound" | "create:milling/wheat" | "quark:tools/smithing/rune_smithing_magenta" | "create:polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "pasterdream:stonecutting_10" | "quark:building/crafting/sturdy_stone_decompress" | "create:compacting/honey" | "minecraft:food_serving" | "create:milling/compat/botania/light_gray_petal" | "quark:building/stonecutting/vertslabs/cobblestone_bricks_vertical_slab_stonecutter" | "biomancy:decomposing/smooth_primal_flesh" | "minecraft:red_banner" | "netherexp:stonecutting/from_basalt/basalt_slab" | "prefab:mineshaft_entrance" | "create:cutting/compat/blue_skies/stripped_starlit_wood" | "create:cutting/compat/biomesoplenty/stripped_umbran_wood" | "create:milling/grass" | "create:splashing/ic2/crushed_raw_uranium" | "quark:building/stonecutting/slabs/white_shingles_slab_stonecutter2" | "quark:building/crafting/vertslabs/polished_tuff_vertical_slab" | "farmersdelight:cutting/cherry_trapdoor" | "jerotesvillage:explorer_upgrade_smithing_template_craft" | "pasterdream:stonecutting_42" | "pasterdream:stonecutting_41" | "refinedstorage:hollow_cover" | "pasterdream:stonecutting_40" | "farmersdelight:cutting/apple_pie" | "meed:mobs_of_sins/bane_of_dead" | "biomancy:decomposing/emerald" | "minecraft:black_carpet" | "quark:building/stonecutting/vertslabs/jasper_bricks_vertical_slab_stonecutter" | "quark:automation/crafting/gold_button" | "biomancy:decomposing/pufferfish" | "cataclysm:polished_azure_seastone" | "jerotesvillage:qoaiku_metal_block_craft" | "quark:building/crafting/vertslabs/polished_myalite_vertical_slab_revert" | "quark:world/stonecutting/stairs/polished_shale_stairs_stonecutter" | "minecraft:dye_magenta_wool" | "pasterdream:stonecutting_36" | "pasterdream:stonecutting_35" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "pasterdream:stonecutting_34" | "pasterdream:stonecutting_33" | "jerotesvillage:carved_brick_stairs_craft" | "pasterdream:stonecutting_39" | "pasterdream:stonecutting_38" | "pasterdream:stonecutting_37" | "jerotesvillage:chiseled_purple_sandstone_craft" | "create:crushing/compat/exnihilosequentia/crushed_netherrack" | "jerotesvillage:cut_glitter_sandstone_from_glitter_sandstone_stonecutting" | "pasterdream:stonecutting_32" | "minecraft:waxed_oxidized_cut_copper_slab_from_honeycomb" | "quark:world/stonecutting/stairs/permafrost_bricks_stairs_stonecutter" | "farmersdelight:bacon_and_eggs" | "pasterdream:stonecutting_31" | "create:crafting/palettes/scorchia" | "pasterdream:stonecutting_30" | "jeed:hunger" | "meed:soulsweapons/calculated_fall" | "meed:calcified" | "jerotesvillage:second_round_aloe_bundle_craft" | "netherexp:soul_candle" | "create:blasting/ingot_aluminium_compat_ic2" | "minecraft:torch" | "minecraft:polished_granite_stairs" | "legendary_monsters:ancient_dripstone_block" | "quark:tools/crafting/torch_arrow" | "refinedstorage:coloring_recipes/blue_wireless_transmitter" | "refinedstorage:coloring_recipes/wireless_transmitter" | "create:crafting/kinetics/black_seat" | "create:crushing/compat/elementaryores/ore_redstone_end" | "create:cutting/compat/twilightforest/stripped_dark_log" | "create:cutting/compat/biomesoplenty/stripped_jacaranda_log" | "create:milling/allium" | "biomancy:decomposing/froststalker_horn" | "prefab:grass_slab_reverse" | "quark:building/stonecutting/vertslabs/yellow_shingles_vertical_slab_stonecutter" | "farmersdelight:cutting/acacia_hanging_sign" | "legendary_monsters:eye_of_bones" | "biomancy:decomposing/podzol" | "functionalstorage:crimson_1" | "functionalstorage:crimson_2" | "functionalstorage:crimson_4" | "born_in_chaos_v1:blackargillitebrickslk" | "cataclysm:chiseled_azure_seastone_pillar_wall" | "create:cutting/compat/twilightforest/mining_wood" | "biomancy:bio_forging/player_head" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:cutting/compat/byg/palo_verde_log" | "create:cutting/compat/twilightforest/canopy_wood" | "create:crafting/kinetics/copper_valve_handle_from_others" | "quark:building/stonecutting/stairs/mossy_cobblestone_bricks_stairs_stonecutter" | "quark:building/crafting/walls/blackstone_bricks_wall" | "quark:building/crafting/vertslabs/azalea_planks_vertical_slab_revert" | "minecraft:sandstone_wall" | "born_in_chaos_v1:scarlet_stained_glass_panel_k" | "minecraft:cut_copper_slab" | "biomancy:decomposing/chorus_fruit" | "create:mechanical_crafting/wand_of_symmetry" | "create:cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "legendary_monsters:ancient_dripstone_brick_stairs_stonecutter" | "netherexp:souled_geyser" | "jerotesvillage:hag_replacement/minecraft_iron_ingot" | "minecraft:light_blue_wool" | "quark:world/crafting/polished_myalite" | "jerotesvillage:rambler_leather_war_beast_armor_craft" | "jerotes:leather_war_beast_armor_craft" | "create:milling/cactus" | "quark:building/crafting/chests/spruce_trapped_chest" | "jerotesvillage:meror_fire_spear_craft" | "legendary_monsters:eye_of_frost" | "minecraft:cherry_slab" | "create:cutting/stripped_warped_hyphae" | "jerotesvillage:ancient_second_rounder_noble_leggings_smith" | "tetra:lapis" | "create:milling/clay" | "minecraft:stripped_acacia_wood" | "cataclysm:cursium_block" | "create:cutting/stripped_spruce_log" | "jerotesvillage:scrap_villager_metal_from_smelting" | "born_in_chaos_v1:black_argillite_brick_k" | "biomancy:decomposing/pine_nuts" | "refinedstorage:coloring_recipes/green_crafting_monitor" | "farmersdelight:cutting/mangrove_log" | "born_in_chaos_v1:dark_metal_nugget_craft_2" | "born_in_chaos_v1:dark_metal_nugget_craft_4" | "jerotesvillage:cut_glitter_sandstone_slab_from_glitter_sandstone_stonecutting" | "lendersdelight:cook/cooked_leviathan_from_campfire_cooking" | "minecraft:orange_bed" | "cataclysm:abyssal_sacrifice2" | "cataclysm:blasting/black_steel_nugget_from_blasting" | "quark:building/stonecutting/stonevariants/limestone_bricks_vertical_slab_polished_stonecutting" | "quark:tweaks/smelting/bone_meal_utility" | "cataclysm:black_steel_sword" | "create:milling/compat/atmospheric/hot_monkey_brush" | "create:filling/glowstone" | "biomancy:decomposing/popped_chorus_fruit" | "quark:building/stonecutting/slabs/cut_soul_sandstone_slab_stonecutter2" | "prefab:sickle_iron" | "jerotesvillage:meror_metal_helmet_craft" | "create:cutting/compat/atmospheric/stripped_morado_wood" | "create:crafting/tree_fertilizer" | "quark:building/crafting/vertslabs/stone_brick_vertical_slab" | "minecraft:red_stained_glass_pane" | "create:cutting/compat/byg/stripped_green_enchanted_wood" | "biomancy:digesting/nutrient_paste_from_grottoceratops_egg" | "create:splashing/gravel" | "create:cutting/compat/autumnity/stripped_maple_log" | "born_in_chaos_v1:sweet_axe_craft" | "biomancy:bio_forging/impermeable_membrane_pane" | "create:crafting/kinetics/andesite_door" | "minecraft:brick_wall" | "born_in_chaos_v1:stormcallers_horn_craft" | "create:cutting/compat/biomesoplenty/stripped_fir_log" | "quark:building/stonecutting/slabs/polished_tuff_slab_stonecutter" | "jerotesvillage:cooked_starbrite_from_smoking" | "jerotesvillage:dye_from_black_pretty_bush" | "quark:building/stonecutting/slabs/red_shingles_slab_stonecutter2" | "born_in_chaos_v1:infernal_evil_pumpkink" | "quark:building/crafting/vertslabs/yellow_shingles_vertical_slab_revert" | "quark:building/stonecutting/vertslabs/black_shingles_vertical_slab_stonecutter" | "quark:tweaks/crafting/white_glass" | "cataclysm:ignitium_ingot" | "create:milling/compat/byg/silver_vase_flower" | "minecraft:dark_oak_planks" | "minecraft:granite_wall" | "quark:tools/crafting/pickarang_heart" | "jerotesvillage:hero_soup_craft" | "create:crushing/raw_lead_block" | "create:cutting/compat/regions_unexplored/willow_wood" | "create:polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "biomancy:bio_forging/tall_flesh_door" | "jerotesvillage:rambler_skin_leather_craft" | "create:pressing/peat_dirt_path_from_grass" | "quark:building/crafting/chests/jungle_chest" | "minecraft:exposed_cut_copper_from_exposed_copper_stonecutting" | "quark:building/crafting/vertslabs/deepslate_brick_vertical_slab" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:diamond_helmet" | "art_of_forging:enigmatic_construct" | "minecraft:warped_fence" | "quark:world/crafting/walls/granite_bricks_wall" | "minecraft:dark_oak_fence_gate" | "jerotesvillage:ocean_gemstone_block_craft" | "farmersdelight:cutting/oak_door" | "jerotesvillage:scaly_bear_boots_smith" | "cataclysm:chorus_fence" | "create:crushing/zinc_ore" | "minecraft:compass" | "legendary_monsters:ender_hammer" | "refinedstorage:pattern_grid/purple_pattern_grid" | "create:cutting/compat/byg/stripped_willow_log" | "netherexp:cooking/netherite_plated_block" | "create:cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "quark:building/stonecutting/vertslabs/pink_shingles_vertical_slab_stonecutter2" | "minecraft:loom" | "netherexp:cut_netherite_pillar" | "farmersdelight:cutting/cake" | "born_in_chaos_v1:solsoil_k" | "create:smelting/copper_ingot_from_crushed" | "quark:building/crafting/azalea_leaf_carpet" | "netherexp:netherrack_brick_slab" | "prefab:machinery_tower" | "quark:building/crafting/stonevariants/limestone_bricks" | "prefab:upgrade" | "create:small_calcite_brick_stairs" | "quark:building/stonecutting/stonevariants/calcite_bricks_vertical_slab_polished_stonecutting" | "sophisticatedbackpacks:smoking_upgrade_from_smelting_upgrade" | "jerotesvillage:violent_tablet_use_mortar_and_pestle_craft" | "create:cutting/cherry_wood" | "create:milling/compat/regions_unexplored/lime_snowbelle" | "quark:building/crafting/vertslabs/thatch_vertical_slab_revert" | "create:cutting/compat/byg/stripped_witch_hazel_log" | "biomancy:decomposing/dragon_head" | "quark:building/stonecutting/vertslabs/magenta_shingles_vertical_slab_stonecutter2" | "jerotesvillage:chiseled_purple_sandstone_from_purple_sandstone_stonecutting" | "create:filling/compat/byg/lush_grass_block" | "quark:building/crafting/compressed/sugar_cane_block" | "biomancy:decomposing/maggot" | "quark:building/crafting/panes/framed_glass_pane" | "quark:world/crafting/slabs/polished_myalite_slab" | "sophisticatedbackpacks:everlasting_upgrade" | "farmersdelight:cutting/sweet_berry_cheesecake" | "legendary_monsters:fiery_jaw" | "cataclysm:azure_seastone" | "quark:oddities/crafting/bonded_ravager_hide" | "biomancy:bio_forging/flesh_ladder" | "cataclysm:bloom_stone_pauldrons" | "quark:building/crafting/vertslabs/polished_andesite_vertical_slab" | "netherexp:stonecutting/polished_blackstone_pillar_from_blackstone" | "quark:building/crafting/hollowlogs/hollow_cherry_log" | "minecraft:gray_stained_glass_pane" | "quark:world/stonecutting/stairs/polished_calcite_stairs_stonecutter2" | "refinedstorage:coloring_recipes/black_crafting_grid" | "quark:world/stonecutting/walls/andesite_bricks_wall_stonecutter" | "quark:building/crafting/vertslabs/cut_soul_sandstone_vertical_slab_revert" | "quark:building/stonecutting/stonevariants/granite_bricks_stairs_polished_stonecutting" | "minecraft:polished_blackstone" | "quark:building/stonecutting/vertslabs/dripstone_bricks_vertical_slab_stonecutter" | "refinedstorage:coloring_recipes/blue_relay" | "legendary_monsters:ancient_dripstone_tile_wall" | "born_in_chaos_v1:creepy_cookies_with_milk_craft" | "jerotesvillage:dye_from_mysterest_flower" | "quark:building/stonecutting/vertslabs/end_stone_brick_vertical_slab2_stonecutter" | "minecraft:bamboo_mosaic_slab" | "create:cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "transmog:void_fragment" | "prefab:crate_of_potatoes" | "netherexp:gargoyle_statues/phase" | "quark:building/stonecutting/stairs/white_shingles_stairs_stonecutter2" | "quark:building/crafting/stonevariants/chiseled_jasper_bricks" | "cataclysm:wither_assault_shoulder_weapon" | "minecraft:spire_armor_trim_smithing_template" | "biomancy:crafting/smooth_primal_flesh" | "create:cut_dripstone_brick_stairs" | "biomancy:decomposing/undead_permeable_membrane" | "minecraft:stone_axe" | "biomancy:bio_forging/injector" | "legendary_monsters:knights_sword" | "biomancy:digesting/nutrient_paste_from_shroomlight" | "minecraft:dye_purple_carpet" | "create:crafting/kinetics/controls" | "meed:born_in_chaos_v1/undead_summonun" | "jerotesvillage:cut_sun_sandstone_craft" | "refinedstorage:destructor" | "refinedstorage:silicon" | "minecraft:light_blue_stained_glass" | "quark:world/crafting/stairs/myalite_bricks_stairs" | "jerotesvillage:serpon_dart_craft" | "biomancy:crafting/primordial_cradle" | "functionalstorage:warped_4" | "functionalstorage:warped_2" | "functionalstorage:warped_1" | "create:polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "create:polished_cut_tuff_from_stone_types_tuff_stonecutting" | "netherexp:soul_slate_brick_wall" | "minecraft:deepslate_brick_slab" | "quark:building/crafting/oak_leaf_carpet" | "quark:building/crafting/glass/light_blue_framed_glass" | "jerotesvillage:spear_machine_craft" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "quark:building/crafting/dirt_bricks" | "quark:building/stonecutting/stonevariants/chiseled_dripstone_bricks_stonecutter" | "create:cut_tuff_wall_from_stone_types_tuff_stonecutting" | "quark:building/crafting/mangrove_leaf_carpet" | "create:crushing/compat/galosphere/lumiere" | "create:crushing/lapis_ore" | "refinedstorage:coloring_recipes/red_crafter_manager" | "biomancy:digesting/nutrient_paste_from_warped_roots" | "refinedstorage:coloring_recipes/crafter" | "born_in_chaos_v1:blackargillitebrickstk_2" | "refinedstorage:coloring_recipes/crafter_manager" | "create:small_dripstone_brick_wall" | "create:milling/compat/byg/cyan_rose" | "farmersdelight:cutting/spruce_hanging_sign" | "create:cut_scoria_slab_from_stone_types_scoria_stonecutting" | "refinedstorage:coloring_recipes/green_fluid_grid" | "create:milling/compat/biomesoplenty/wildflower" | "sophisticatedbackpacks:compacting_upgrade" | "create:cut_dripstone_brick_slab_recycling" | "create:milling/compat/byg/fairy_slipper" | "farmersdelight:kelp_roll" | "create:cutting/compat/byg/mahogany_wood" | "quark:building/crafting/vertslabs/andesite_bricks_vertical_slab_revert" | "minecraft:iron_axe" | "quark:building/crafting/panes/magenta_framed_glass_pane" | "create:cut_crimsite_from_stone_types_crimsite_stonecutting" | "jerotesvillage:hag_replacement/minecraft_potion" | "netherexp:smooth_silica_sandstone_stairs" | "quark:building/stonecutting/vertslabs/cut_copper_vertical_slab_from_copper_block" | "quark:building/stonecutting/vertslabs/sandstone_vertical_slab_stonecutter" | "create:cutting/compat/regions_unexplored/mauve_log" | "minecraft:jukebox" | "refinedstorage:fluid_grid/yellow_fluid_grid" | "create:layered_granite_from_stone_types_granite_stonecutting" | "jerotesvillage:hag_replacement/jerotesvillage_serpon_alloy_ingot" | "quark:building/crafting/glass/cyan_framed_glass" | "quark:building/stonecutting/vertslabs/nether_brick_vertical_slab_stonecutter" | "quark:building/stonecutting/slabs/yellow_shingles_slab_stonecutter2" | "farmersdelight:carrot_from_crate" | "minecraft:acacia_sign" | "minecraft:chest_minecart" | "quark:building/crafting/vertslabs/purpur_vertical_slab" | "quark:building/stonecutting/vertslabs/polished_shale_vertical_slab_stonecutter2" | "create:crafting/logistics/brass_funnel" | "create:weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:decorated_pot" | "legendary_monsters:spiky_shield" | "minecraft:magenta_terracotta" | "minecraft:baked_potato_from_campfire_cooking" | "jeed:wither" | "biomancy:digesting/nutrient_paste_from_bamboo" | "jerotesvillage:meror_metal_boots_craft" | "biomancy:decomposing/living_flesh" | "create:compacting/ice" | "prefab:house_improved" | "create:milling/blue_orchid" | "quark:building/crafting/vertplanks/vertical_azalea_planks_revert" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "quark:tweaks/crafting/utility/chests/mixed_chest_wood_but_without_exclusions" | "jerotesvillage:anesthetized_throwing_ball_craft" | "minecraft:tide_armor_trim_smithing_template" | "quark:world/crafting/woodsets/azalea/boat" | "protection_pixel:cannonshellloot" | "create:cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:milling/compat/byg/magenta_tulip" | "create:milling/granite" | "create:crushing/amethyst_block" | "meed:lupus_sanguinem" | "biomancy:decomposing/heavy_bone" | "cataclysm:end_stone_pillar" | "create:small_veridium_brick_stairs" | "biomancy:decomposing/primal_permeable_membrane_pane" | "create:blasting/ingot_lead_compat_mekanism" | "minecraft:cobblestone_stairs_from_cobblestone_stonecutting" | "minecraft:crimson_door" | "refinedstorage:crafting_upgrade" | "netherexp:chiseled_silica_sandstone" | "create:cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "refinedstorage:crafting_grid/gray_crafting_grid" | "quark:building/crafting/panes/yellow_framed_glass_pane" | "create:cutting/compat/biomesoplenty/magic_wood" | "quark:tweaks/crafting/cyan_glass" | "minecraft:pink_wool" | "quark:world/crafting/stairs/polished_shale_stairs" | "create:crafting/logistics/display_link" | "cataclysm:azure_seastone_slab" | "create:deploying/waxed_copper_shingle_stairs_from_adding_wax" | "minecraft:end_stone_bricks" | "minecraft:red_stained_glass_pane_from_glass_pane" | "jerotesvillage:black_yellow_hanging_sign_craft" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "quark:building/stonecutting/stairs/brown_shingles_stairs_stonecutter2" | "minecraft:black_candle" | "farmersdelight:cutting/nether_bricks" | "create:cutting/compat/byg/blue_enchanted_log" | "quark:building/crafting/orange_blossom_hedge" | "create:crushing/iron_horse_armor" | "jerotesvillage:glitter_sandstone_wall_from_glitter_sandstone_stonecutting" | "create:splashing/thermal/crushed_raw_nickel" | "cataclysm:soul_render" | "create:crushing/osmium_ore" | "farmersdelight:cutting/cherry_sign" | "quark:tweaks/crafting/yellow_glass" | "quark:building/stonecutting/stairs/sandstone_bricks_stairs_stonecutter" | "jerotesvillage:rambler_leather_planks_craft" | "refinedstorage:coloring_recipes/black_network_transmitter" | "biomancy:decomposing/primal_permeable_membrane" | "create:milling/compat/regions_unexplored/hibiscus" | "netherexp:netherite_grate" | "create:splashing/atmospheric/red_arid_sand" | "biomancy:bio_forging/creator_mix" | "minecraft:dye_brown_wool" | "quark:building/crafting/stairs/red_sandstone_bricks_stairs" | "quark:building/stonecutting/vertslabs/sandstone_bricks_vertical_slab_stonecutter" | "create:cut_veridium_wall_from_stone_types_veridium_stonecutting" | "quark:world/crafting/woodsets/azalea/planks" | "biomancy:bio_brewing/insomnia_cure" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "jerotesvillage:cooked_solish_meat_from_smoking" | "farmersdelight:cutting/crimson_stem" | "sophisticatedbackpacks:advanced_restock_upgrade" | "create:polished_cut_scorchia_slab" | "quark:building/stonecutting/stonevariants/andesite_bricks_wall_rough_stonecutting" | "biomancy:bio_forging/leather" | "quark:building/crafting/vertplanks/vertical_azalea_planks" | "create:framed_glass_from_glass_colorless_stonecutting" | "minecraft:warped_sign" | "lendersdelight:knife/abyssal_knife" | "protection_pixel:equipmentkitloot" | "jerotesvillage:hag_replacement/minecraft_ice" | "quark:world/stonecutting/walls/limestone_wall_stonecutter" | "jerotesvillage:villager_metal_bow_craft" | "quark:building/crafting/vertslabs/polished_tuff_vertical_slab_revert" | "refinedstorage:coloring_recipes/orange_crafter_manager" | "prefab:double_compressed_stone_to_compressed_stone" | "biomancy:decomposing/dried_kelp" | "jerotes:iron_giant_beast_armor_craft" | "quark:world/stonecutting/slabs/shale_bricks_slab_stonecutter" | "minecraft:bamboo_sign" | "refinedstorage:coloring_recipes/pink_relay" | "refinedstorage:wireless_fluid_grid" | "legendary_monsters:atmospheric_boots" | "quark:world/crafting/woodsets/ancient/door" | "quark:building/crafting/panes/green_framed_glass_pane" | "refinedstorage:coloring_recipes/black_wireless_transmitter" | "create:crafting/kinetics/spout" | "minecraft:host_armor_trim_smithing_template_smithing_trim" | "create:polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "lendersdelight:cook/cooked_ender_golem_meat" | "sophisticatedbackpacks:netherite_backpack" | "minecraft:orange_terracotta" | "protection_pixel:sockloot" | "quark:building/crafting/lamps/orange_crystal_lamp" | "create:haunting/soul_torch" | "farmersdelight:integration/create/milling/wild_tomatoes" | "quark:tweaks/crafting/utility/misc/dispenser_no_bow" | "biomancy:decomposing/forge_bones" | "create:splashing/blue_concrete_powder" | "jerotesvillage:cooked_bright_grass_carp" | "create:blasting/ingot_uranium_compat_ic2" | "create:copper_scaffolding_from_ingots_copper_stonecutting" | "minecraft:paper" | "minecraft:lime_glazed_terracotta" | "quark:building/crafting/stairs/polished_tuff_stairs" | "create:cut_scoria_brick_slab_recycling" | "prefab:quartz_crete" | "refinedstorage:coloring_recipes/orange_disk_manipulator" | "cataclysm:black_steel_wall" | "lendersdelight:cook/cooked_ender_golem_meat_from_smoking" | "quark:building/crafting/panes/red_framed_glass_pane" | "create:cutting/compat/byg/fir_log" | "minecraft:cherry_fence_gate" | "quark:tweaks/crafting/utility/misc/easy_sticks_bamboo" | "refinedstorage:coloring_recipes/red_fluid_grid" | "create:cut_calcite_brick_wall" | "jerotesvillage:wonderland_fence_craft" | "quark:building/stonecutting/stonevariants/shale_bricks_slab_polished_stonecutting" | "quark:building/crafting/panes/cyan_framed_glass_pane" | "quark:building/stonecutting/stonevariants/jasper_pillar_stonecutter" | "biomancy:decomposing/phantom_membrane" | "sophisticatedbackpacks:advanced_magnet_upgrade" | "create:crushing/compat/silentgems/citrine_ore" | "quark:building/crafting/vertslabs/wax/waxed_weathered_cut_copper_vertical_slab_hc" | "cataclysm:stonecutting/azure_seastone_pillar_from_stonecutting" | "minecraft:dark_oak_button" | "create:milling/compat/regions_unexplored/blue_lupine" | "create:crafting/kinetics/framed_glass_trapdoor" | "biomancy:decomposing/sugar_cane" | "prefab:aqua_base" | "netherexp:stonecutting/from_netherrack_bricks/netherrack_tiles" | "create:cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "functionalstorage:oak_4" | "easy_villagers:breeder" | "functionalstorage:oak_2" | "refinedstorage:coloring_recipes/pink_crafter" | "functionalstorage:oak_1" | "jerotesvillage:meror_metal_ingot_by_stick_craft" | "jeed:absorption" | "biomancy:decomposing/gravel" | "meed:nethers_exoticism/wither_cure" | "create:crushing/compat/druidcraft/amber_ore" | "biomancy:digesting/nutrient_paste_from_hay_block" | "minecraft:cracked_deepslate_tiles" | "jerotes:netherite_war_beast_armor_smith" | "netherexp:gargoyle_statues/occult" | "jerotesvillage:purple_sandstone_wall_craft" | "quark:building/crafting/blaze_lantern" | "minecraft:cooked_rabbit" | "create:milling/compat/byg/allium_flower_bush" | "create:crushing/compat/silentgems/turquoise_ore" | "quark:building/crafting/shingles/brown_shingles" | "born_in_chaos_v1:armor_plate_from_dark_metal_k" | "legendary_monsters:eye_of_magma" | "minecraft:magenta_banner" | "refinedstorage:coloring_recipes/yellow_crafting_monitor" | "jerotes:iron_spear_craft" | "minecraft:mangrove_fence_gate" | "create:cutting/compat/blue_skies/stripped_lunar_wood" | "quark:tweaks/crafting/utility/misc/furnace_minecart" | "create:milling/lilac" | "netherexp:cut_netherite_slab" | "quark:building/crafting/stonevariants/tuff_pillar" | "quark:building/stonecutting/mossy_cobblestone_bricks_stonecutter" | "quark:building/crafting/vertslabs/red_nether_brick_vertical_slab" | "minecraft:iron_block" | "create:cut_granite_brick_wall" | "minecraft:dark_oak_door" | "cataclysm:azure_seastone_bricks" | "create:cutting/compat/the_vault/stripped_chromatic_log" | "refinedstorage:network_transmitter" | "jerotesvillage:smooth_glitter_sandstone_stairs_craft" | "minecraft:flower_pot" | "create:crafting/schematics/empty_schematic" | "create:cutting/compat/regions_unexplored/stripped_maple_log" | "jerotesvillage:wonderland_stairs_craft" | "jerotesvillage:villager_metal_syringe_craft" | "jerotesvillage:cooked_abyssaler_from_smoking" | "biomancy:digesting/nutrient_paste_from_sea_pickle" | "jerotesvillage:cooked_sun_crab_from_campfire_cooking" | "tetra:pestilence_armor" | "minecraft:polished_blackstone_bricks_from_blackstone_stonecutting" | "quark:building/stonecutting/vertslabs/polished_tuff_vertical_slab_stonecutter" | "quark:world/stonecutting/walls/myalite_wall_stonecutter" | "quark:world/stonecutting/slabs/calcite_bricks_slab_stonecutter" | "quark:world/crafting/woodsets/azalea/fence" | "netherexp:stonecutting/from_bone_block/skull_block" | "quark:building/crafting/vertslabs/mossy_stone_brick_vertical_slab_revert" | "biomancy:decomposing/fibrous_flesh_wall" | "born_in_chaos_v1:death_totem_k" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "refinedstorage:64k_storage_block" | "quark:building/stonecutting/vertslabs/limestone_bricks_vertical_slab_stonecutter" | "biomancy:decomposing/vallumraptor_egg" | "refinedstorage:crafting_grid/purple_crafting_grid" | "jerotesvillage:bright_cobblestone_wall_from_bright_cobblestone_stonecutting" | "farmersdelight:red_canvas_sign" | "create:smelting/gold_ingot_from_crushed" | "quark:building/crafting/blue_blossom_leaf_carpet" | "minecraft:pink_glazed_terracotta" | "create:cutting/compat/twilightforest/transformation_wood" | "create:small_crimsite_brick_slab_recycling" | "quark:building/crafting/vertslabs/end_stone_brick_vertical_slab" | "farmersdelight:golden_knife" | "lendersdelight:cook/cooked_leviathan" | "create:milling/compat/byg/amaranth" | "cataclysm:witherite_ingot" | "minecraft:orange_stained_glass" | "create:small_andesite_brick_slab_recycling" | "create:cutting/compat/environmental/cherry_log" | "minecraft:exposed_cut_copper_slab" | "quark:world/stonecutting/stairs/polished_calcite_stairs_stonecutter" | "farmersdelight:cutting/cabbage" | "create:crafting/materials/rose_quartz" | "create:crushing/compat/neapolitan/ice" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "farmersdelight:integration/immersiveengineering/crusher/wild_carrots" | "cataclysm:black_steel_hoe" | "create:crafting/kinetics/controller_rail" | "jerotesvillage:sediment_mud_brick_slab_from_sediment_mud_bricks_stonecutting" | "meed:brachi_protection" | "quark:world/crafting/panes/yellow_corundum" | "born_in_chaos_v1:fried_maggot_k_3" | "born_in_chaos_v1:fried_maggot_k_2" | "minecraft:golden_boots" | "waystones:mossy_waystone" | "create:milling/compat/upgrade_aquatic/white_searocket" | "minecraft:pink_dye_from_red_white_dye" | "minecraft:netherite_shovel_smithing" | "biomancy:decomposing/void_worm_eye" | "create:cutting/compat/regions_unexplored/stripped_joshua_wood" | "biomancy:bio_forging/biometric_membrane" | "biomancy:decomposing/mob_fang" | "itemfilters:not" | "born_in_chaos_v1:cultivated_pumpkink_2" | "quark:building/stonecutting/slabs/dripstone_block_slab_stonecutter" | "create:crafting/kinetics/clockwork_bearing" | "born_in_chaos_v1:cultivated_pumpkink_3" | "minecraft:polished_granite_slab" | "biomancy:decomposing/raw_copper" | "farmersdelight:cutting/jungle_door" | "minecraft:emerald" | "create:pressing/compat/betterendforge/jungle_moss_path" | "biomancy:decomposing/shed_snake_skin" | "farmersdelight:cutting/oxeye_daisy" | "cataclysm:stonecutting/purpur_tile_stairs_from_stonecutting" | "waystones:waystone" | "quark:building/crafting/vertslabs/gray_shingles_vertical_slab_revert" | "minecraft:cherry_planks" | "create:cutting/compat/regions_unexplored/cypress_log" | "refinedstorage:coloring_recipes/black_crafter" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "minecraft:oak_stairs" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "create:crushing/nether_gold_ore" | "quark:building/crafting/stonevariants/granite_pillar" | "refinedstorage:storage_monitor" | "minecraft:polished_blackstone_brick_stairs" | "quark:world/crafting/stairs/ancient_planks_stairs" | "create:crafting/kinetics/mechanical_saw" | "create:milling/compat/regions_unexplored/cyan_snowbelle" | "create:crafting/logistics/andesite_funnel" | "quark:building/stonecutting/stonevariants/andesite_bricks_stonecutter" | "biomancy:decomposing/primal_flesh_wall" | "farmersdelight:cutting/bamboo_hanging_sign" | "create:cutting/compat/environmental/stripped_willow_wood" | "prefab:sickle_gold" | "biomancy:bio_forging/caustic_gunblade" | "refinedstorage:coloring_recipes/gray_wireless_transmitter" | "quark:tweaks/crafting/utility/bent/bread" | "biomancy:crafting/granite_from_mineral_fragment" | "minecraft:glass" | "create:filling/honeyed_apple" | "create:crushing/deepslate_zinc_ore" | "meed:tombstone/lightning_resistance" | "netherexp:smokestalk_sign" | "biomancy:decomposing/red_sand" | "prefab:swift_blade_obsidian" | "quark:building/crafting/stairs/thatch_stairs" | "jerotesvillage:wonderland_pressure_plate_craft" | "quark:building/crafting/vertslabs/raw_iron_bricks_vertical_slab" | "create:crafting/kinetics/nixie_tube" | "minecraft:light_blue_concrete_powder" | "netherexp:ancient_wax_block" | "quark:building/crafting/panes/light_gray_framed_glass_pane" | "minecraft:granite_stairs" | "cataclysm:obsidian_pillar" | "prefab:compressed_obsidian_to_obsidian" | "quark:building/crafting/spruce_hedge" | "create:cutting/compat/environmental/stripped_wisteria_wood" | "create:small_deepslate_brick_slab" | "refinedstorage:coloring_recipes/cyan_crafting_monitor" | "create:haunting/infested_chiseled_stone_bricks" | "quark:building/crafting/lamps/red_corundum_lamp" | "farmersdelight:cutting/cherry_door" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "legendary_monsters:eye_of_ghost" | "cataclysm:the_incinerator" | "quark:building/crafting/furnaces/deepslate_smoker" | "meed:ars_nouveau/scrying" | "create:warped_window" | "meed:prevent_click" | "quark:tweaks/crafting/utility/chests/mixed_chest_wood" | "biomancy:decomposing/gold_ingot" | "create:small_dripstone_brick_slab_recycling" | "jerotesvillage:black_yellow_fence_gate_craft" | "farmersdelight:integration/create/milling/wild_rice" | "netherexp:claret_pressure_plate" | "quark:building/stonecutting/vertslabs/netherrack_bricks_vertical_slab_stonecutter" | "minecraft:prismarine_bricks" | "netherexp:stacked_bones" | "quark:building/stonecutting/stairs/blackstone_bricks_stairs_stonecutter" | "jerotesvillage:bright_grass_umbrella_craft" | "quark:building/crafting/furnaces/blackstone_smoker" | "create:cutting/compat/tconstruct/skyroot_wood" | "lendersdelight:lionfish_roll" | "minecraft:stone_bricks" | "quark:tweaks/crafting/utility/chests/birch_chest_wood" | "cataclysm:ancient_spear" | "biomancy:bio_forging/ravenous_claws" | "create:cut_crimsite_brick_wall" | "jerotesvillage:hag_replacement/jerotesvillage_celestial_coilvine_carpet" | "born_in_chaos_v1:sweet_sword_craft" | "netherexp:smithing/rift_armor_trim" | "netherexp:stonecutting/from_soul_slate_bricks/wall" | "jerotesvillage:villager_metal_door_craft" | "biomancy:decomposing/bubble_coral_fan" | "minecraft:dye_orange_wool" | "create:cutting/compat/biomesoplenty/stripped_magic_wood" | "netherexp:claret_door" | "create:crushing/raw_uranium_block" | "refinedstorage:4k_storage_part" | "create:haunting/blackstone" | "jerotesvillage:meror_metal_block_craft" | "create:cutting/compat/biomesoplenty/magic_log" | "biomancy:stonecutting/flesh_stairs_from_flesh" | "minecraft:cyan_stained_glass" | "prefab:ender_gateway" | "minecraft:acacia_fence" | "quark:building/stonecutting/slabs/magenta_shingles_slab_stonecutter" | "jerotesvillage:serpon_alloy_nugget_craft" | "meed:biomemakeover/possesed" | "quark:world/stonecutting/polished_myalite_stonecutter" | "born_in_chaos_v1:carved_black_argillite_k" | "create:crushing/compat/byg/lignite_ore" | "create:cutting/compat/atmospheric/yucca_log" | "refinedstorage:coloring_recipes/orange_crafting_grid" | "minecraft:cyan_banner" | "create:veridium_from_stone_types_veridium_stonecutting" | "quark:building/crafting/flowering_azalea_leaf_carpet" | "create:milling/lapis_lazuli" | "quark:building/stonecutting/vertslabs/yellow_shingles_vertical_slab_stonecutter2" | "create:crafting/materials/copper_nugget" | "minecraft:glistering_melon_slice" | "minecraft:warped_door" | "protection_pixel:linkplatebootloot" | "farmersdelight:cooking/pumpkin_soup" | "minecraft:acacia_fence_gate" | "quark:building/stonecutting/stonevariants/tuff_bricks_wall_polished_stonecutting" | "create:crafting/kinetics/gray_seat" | "quark:building/crafting/vertslabs/cut_soul_sandstone_vertical_slab" | "create:cut_ochrum_slab" | "jerotesvillage:villager_metal_ingot_craft" | "netherexp:rift_armor_trim_smithing_template" | "refinedstorage:coloring_recipes/green_network_receiver" | "create:crafting/materials/zinc_ingot_from_decompacting" | "minecraft:dye_yellow_wool" | "quark:building/crafting/walls/raw_gold_bricks_wall" | "minecraft:magenta_carpet" | "netherexp:smooth_netherrack_stairs" | "create:crafting/kinetics/contraption_controls" | "create:milling/compat/byg/orange_amaranth" | "cataclysm:polished_azure_seastone_wall" | "biomancy:decomposing/dead_bubble_coral_fan" | "create:cutting/compat/regions_unexplored/stripped_baobab_log" | "protection_pixel:closedasloot" | "refinedstorage:pattern_grid/light_gray_pattern_grid" | "quark:building/crafting/slabs/duskbound_block_slab" | "quark:building/stonecutting/white_shingles_stonecutter2" | "create:small_diorite_brick_wall" | "create:cutting/compat/botania/livingwood_log" | "farmersdelight:cutting/spruce_sign" | "create:polished_cut_granite_from_stone_types_granite_stonecutting" | "farmersdelight:tatami_block_from_full" | "farmersdelight:chocolate_pie_from_slices" | "farmersdelight:cooking/vegetable_noodles" | "prefab:swift_blade_steel" | "jeed:glowing" | "minecraft:lectern" | "create:cutting/compat/byg/redwood_log" | "prefab:saloon" | "quark:world/crafting/stairs/shale_bricks_stairs" | "create:cut_andesite_brick_wall" | "protection_pixel:typhoonasloot" | "prefab:compressed_stone_to_stone" | "create:cutting/compat/ecologics/stripped_walnut_log" | "quark:building/crafting/chests/acacia_trapped_chest" | "minecraft:magenta_dye_from_allium" | "minecraft:smooth_stone_slab" | "biomancy:decomposing/prismarine_crystals" | "jerotesvillage:serpon_classical_bomb_craft" | "quark:building/stonecutting/slabs/polished_dripstone_slab_stonecutter" | "create:milling/beetroot" | "quark:tweaks/crafting/utility/wool/blue_wool" | "minecraft:dye_lime_wool" | "quark:world/crafting/woodsets/blossom/chest_boat" | "create:crushing/raw_aluminum_block" | "quark:building/crafting/vertslabs/oxidized_cut_copper_vertical_slab" | "quark:building/stonecutting/red_shingles_stonecutter2" | "minecraft:mossy_cobblestone_from_vine" | "netherexp:stonecutting/from_soul_slate/soul_slate_brick_pillar" | "netherexp:basaltic_geyser" | "netherexp:ancient_candle" | "create:cutting/compat/tconstruct/bloodshroom_wood" | "create:cutting/compat/quark/stripped_ancient_wood" | "create:small_andesite_brick_wall" | "quark:building/crafting/stonevariants/shale_bricks" | "quark:building/stonecutting/vertslabs/polished_granite_vertical_slab_stonecutter" | "create:crafting/kinetics/adjustable_chain_gearshift" | "farmersdelight:cutting/acacia_door" | "legendary_monsters:totem_of_moss" | "quark:building/crafting/jungle_ladder" | "create:smelting/glass_from_framed_glass" | "farmersdelight:nether_salad" | "create:crafting/kinetics/steam_engine" | "create:crushing/raw_zinc" | "biomancy:decomposing/frogspawn" | "biomancy:digesting/nutrient_paste_from_nether_wart" | "netherexp:netherrack_pillar" | "create:milling/compat/byg/osiria_rose" | "minecraft:polished_blackstone_slab_from_blackstone_stonecutting" | "quark:building/crafting/chests/birch_trapped_chest" | "create:cutting/dark_oak_log" | "create:cutting/compat/byg/stripped_redwood_log" | "create:cutting/compat/ecologics/stripped_azalea_wood" | "refinedstorage:coloring_recipes/white_controller" | "minecraft:jungle_chest_boat" | "quark:building/crafting/shingles/magenta_shingles_dye" | "jerotes:diamond_giant_beast_armor_craft" | "quark:world/crafting/stairs/jasper_bricks_stairs" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "netherexp:soul_slate_tile_slab" | "quark:building/crafting/shingles/purple_shingles" | "create:cutting/compat/twilightforest/stripped_time_log" | "create:oxidized_copper_shingle_stairs" | "create:pressing/compat/betterendforge/pink_moss_path" | "prefab:jail" | "create:cutting/compat/tconstruct/stripped_skyroot_wood" | "jerotesvillage:rotten_bright_melon_craft" | "farmersdelight:canvas_from_canvas_rug" | "quark:world/stonecutting/stairs/permafrost_bricks_stairs_stonecutter2" | "farmersdelight:cooked_bacon_from_smoking" | "biomancy:stonecutting/smooth_primal_flesh_stairs_from_smooth_primal_flesh" | "minecraft:end_stone_brick_slab" | "biomancy:bio_forging/scute" | "jerotesvillage:glitter_sandstone_stairs_from_glitter_sandstone_stonecutting" | "quark:building/stonecutting/vertslabs/purpur_vertical_slab_stonecutter" | "cataclysm:chiseled_purpur_block" | "biomancy:decomposing/rabbit_hide" | "netherexp:stonecutting/from_basalt/polished_basalt_stairs" | "quark:building/crafting/vertslabs/blackstone_bricks_vertical_slab" | "minecraft:pink_concrete_powder" | "farmersdelight:green_canvas_sign" | "quark:building/crafting/slabs/pink_shingles_slab" | "biomancy:crafting/smooth_primal_flesh_wall" | "create:layered_scorchia_from_stone_types_scorchia_stonecutting" | "jerotesvillage:corrosiver_bugle_craft" | "create:cutting/compat/biomesoplenty/stripped_jacaranda_wood" | "farmersdelight:light_gray_hanging_canvas_sign" | "quark:building/crafting/ancient_hedge" | "minecraft:diamond_shovel" | "minecraft:andesite_wall" | "protection_pixel:hookcannonloot" | "quark:building/crafting/stairs/rusty_iron_plate_stairs" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/acacia_trapdoor" | "jerotesvillage:glitter_sand_tnt_craft" | "quark:building/crafting/compressed/cactus_block_uncompress" | "art_of_forging:mark_of_the_architect" | "create:crushing/platinum_ore" | "ftbfiltersystem:smart_filter" | "biomancy:digesting/nutrient_paste_from_hanging_roots" | "quark:building/crafting/light_blue_stool" | "create:cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "quark:tweaks/crafting/utility/chest_boat/direct_birch_chest_boat" | "prefab:compressed_quartz_crete_to_quartz_crete" | "minecraft:minecart" | "jerotes:war_beast_armor_base_craft" | "jerotesvillage:bitter_cold_bell_craft" | "create:cutting/compat/autumnity/maple_wood" | "create:cutting/compat/regions_unexplored/stripped_pink_bioshroom_stem" | "jerotesvillage:qoaiku_axe_craft" | "waystones:portstone" | "quark:building/crafting/vertslabs/bamboo_mosaic_vertical_slab" | "refinedstorage:coloring_recipes/gray_crafting_grid" | "jerotesvillage:villager_metal_throwing_ball_craft" | "create:milling/compat/environmental/red_hibiscus" | "farmersdelight:cooked_bacon_from_campfire_cooking" | "create:cutting/compat/regions_unexplored/alpha_log" | "jerotesvillage:rambler_leather_giant_beast_armor_craft" | "born_in_chaos_v1:dark_grid_k" | "create:weathered_copper_tile_stairs" | "biomancy:crafting/bio_forge" | "biomancy:crafting/impermeable_membrane_pane_from_impermeable_membrane" | "farmersdelight:cooking/mushroom_rice" | "prefab:dirt_wall_reverse" | "jerotesvillage:cooked_solish_meat" | "minecraft:golden_shovel" | "biomancy:bio_forging/acolyte_armor_leggings" | "create:crafting/kinetics/smart_fluid_pipe" | "jerotesvillage:ancient_second_rounder_noble_upgrade_smithing_template_craft" | "quark:building/stonecutting/vertslabs/midori_block_vertical_slab_stonecutter" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "biomancy:bio_forging/vial_holder" | "minecraft:brick_wall_from_bricks_stonecutting" | "rsinfinitybooster:dimension_card" | "create:filling/compat/vampirism/cursed_grass" | "jerotesvillage:glitter_sandstone_wall_craft" | "biomancy:digesting/nutrient_paste_from_archaic_vine" | "create:milling/dripstone_block" | "refinedstorage:coloring_recipes/gray_network_transmitter" | "quark:building/stonecutting/vertslabs/stone_vertical_slab_stonecutter" | "refinedstorage:coloring_recipes/magenta_pattern_grid" | "minecraft:brown_glazed_terracotta" | "quark:building/crafting/vertslabs/black_shingles_vertical_slab" | "biomancy:decomposing/packed_flesh_stairs" | "create:cutting/compat/regions_unexplored/pink_bioshroom_stem" | "biomancy:decomposing/ender_pearl" | "jerotesvillage:villager_metal_pickaxe_craft" | "create:cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "quark:building/crafting/stripped_mangrove_post" | "quark:building/crafting/vertslabs/waxed_oxidized_cut_copper_vertical_slab" | "refinedstorage:coloring_recipes/yellow_crafting_grid" | "create:cut_scoria_wall" | "biomancy:digesting/nutrient_paste_from_cocoa_beans" | "meed:netheroverhaul/paralyzie" | "minecraft:warped_trapdoor" | "quark:building/stonecutting/vertslabs/mossy_cobblestone_vertical_slab_stonecutter" | "moblassos:diamond_lasso" | "create:crafting/kinetics/fluid_pipe_vertical" | "netherexp:stonecutting/from_soul_slate_tiles/stairs" | "minecraft:diamond_chestplate" | "create:milling/compat/regions_unexplored/purple_coneflower" | "biomancy:decomposing/roadrunner_feather" | "create:crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "quark:building/crafting/compressed/bonded_rabbit_hide_uncompress" | "create:crafting/kinetics/mechanical_arm" | "create:cutting/compat/byg/fir_wood" | "quark:building/crafting/compressed/apple_crate" | "netherexp:stonecutting/from_soul_slate_bricks/pillar" | "jerotesvillage:cooked_starbrite_from_campfire_cooking" | "born_in_chaos_v1:bone_heart_k" | "jerotesvillage:smooth_sun_sandstone_slab_craft" | "create:milling/compat/byg/peach_leather_flower" | "minecraft:birch_sign" | "netherexp:basalt_wall" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "biomancy:digesting/nutrient_paste_from_brown_mushroom_block" | "create:pressing/path" | "create:cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:polished_cut_diorite_stairs" | "create:crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "minecraft:orange_dye_from_red_yellow" | "quark:building/stonecutting/vertslabs/brick_vertical_slab_stonecutter" | "meed:soulsweapons/decay" | "create:milling/compat/biomesoplenty/lavender" | "refinedstorage:coloring_recipes/lime_grid" | "create:cut_diorite_stairs" | "farmersdelight:cooked_cod_slice" | "create:crafting/appliances/netherite_diving_boots" | "cataclysm:black_steel_pickaxe" | "create:splashing/immersiveengineering/crushed_raw_nickel" | "create:crushing/deepslate_lapis_ore" | "create:cutting/compat/ecologics/azalea_wood" | "quark:building/crafting/shingles/yellow_shingles_dye" | "minecraft:light_gray_dye_from_azure_bluet" | "quark:building/crafting/rope" | "jerotesvillage:meror_metal_nugget_craft" | "biomancy:decomposing/kangaroo_meat" | "art_of_forging:forged_container" | "netherexp:claret_fence" | "farmersdelight:integration/create/milling/rice_panicle" | "create:small_scoria_brick_slab" | "refinedstorage:coloring_recipes/magenta_wireless_transmitter" | "create:cut_asurine_slab" | "minecraft:magenta_candle" | "create:milling/compat/byg/crocus" | "create:pressing/compat/betterendforge/end_myclium_path" | "create:small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "biomancy:decomposing/copper_ingot" | "born_in_chaos_v1:mint_candy_k" | "create:crafting/kinetics/weighted_ejector" | "quark:building/crafting/furnaces/mixed_furnace" | "farmersdelight:integration/immersiveengineering/crusher/wild_cabbages" | "quark:world/crafting/panes/black_corundum_pane" | "quark:building/stonecutting/slabs/magenta_shingles_slab_stonecutter2" | "netherexp:polished_basalt_slab" | "jerotesvillage:cooked_flowminnow" | "create:crushing/compat/silentgems/moldavite_ore" | "meed:sculk" | "biomancy:decomposing/undead_permeable_membrane_pane" | "quark:oddities/crafting/crate" | "quark:building/crafting/red_sandstone_bricks" | "create:crushing/compat/galosphere/amethyst" | "minecraft:tnt_minecart" | "jerotesvillage:hag_replacement/jerotesvillage_holy_water" | "minecraft:acacia_planks" | "meed:sculk_infected" | "create:item_application/copper_casing_from_wood" | "create:cutting/compat/byg/stripped_redwood_wood" | "create:blasting/lead_ingot_compat_oreganized" | "quark:world/stonecutting/slabs/polished_shale_slab_stonecutter2" | "create:splashing/stained_glass" | "quark:building/crafting/vertslabs/magenta_shingles_vertical_slab_revert" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "create:cutting/compat/biomesoplenty/umbran_log" | "minecraft:cherry_button" | "netherexp:weeping_polished_blackstone_bricks" | "create:crafting/kinetics/large_water_wheel" | "jerotesvillage:dye_from_wonderland_flower" | "jerotesvillage:bitter_cold_trapdoor_craft" | "quark:building/crafting/vertslabs/brick_vertical_slab_revert" | "refinedstorage:64k_storage_disk_from_storage_housing" | "minecraft:brown_terracotta" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "farmersdelight:cutting_board" | "minecraft:blue_wool" | "create:milling/compat/regions_unexplored/light_gray_snowbelle" | "netherexp:netherrack_brick_stairs" | "create:smelting/lead_ingot_compat_oreganized" | "netherexp:smokestalk_button" | "minecraft:note_block" | "create:smelting/scoria" | "quark:building/crafting/vertslabs/brown_shingles_vertical_slab_revert" | "meed:ars_additions/marked" | "quark:building/stonecutting/stonevariants/dripstone_bricks_slab_polished_stonecutting" | "biomancy:decomposing/beef" | "create:crushing/prismarine_crystals" | "create:layered_limestone_from_stone_types_limestone_stonecutting" | "waystones:warp_scroll" | "create:cutting/compat/regions_unexplored/stripped_blackwood_log" | "biomancy:decomposing/amethyst_shard" | "quark:building/crafting/hollowlogs/hollow_oak_log" | "born_in_chaos_v1:flaming_evil_pumpkin_k" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "biofactory:compacting/primal_flesh_block_from_malignant_flesh_block" | "quark:building/crafting/jungle_hedge" | "prefab:bundle_of_timber" | "create:deploying/waxed_copper_tile_slab_from_adding_wax" | "create:pressing/compat/infernalexp/soul_soil_path" | "minecraft:shulker_box" | "jerotesvillage:explorer_iron_boots_smith" | "refinedstorage:pattern_grid/cyan_pattern_grid" | "netherexp:stonecutting/from_wither_bone_block/stacked_bone_stairs" | "create:birch_window_pane" | "quark:building/stonecutting/stonevariants/limestone_bricks_vertical_slab_rough_stonecutting" | "meed:soulsweapons/hallowed_dragon_mist" | "minecraft:white_carpet" | "jerotesvillage:serpon_powerhouse_helmet_smith" | "quark:building/crafting/stairs/duskbound_block_stairs" | "quark:building/crafting/dark_oak_hedge" | "create:milling/compat/regions_unexplored/black_snowbelle" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "biomancy:decomposing/magma_cream" | "cataclysm:weapon_infusion/void_assault_shoulder_weapon" | "create:cutting/compat/regions_unexplored/green_bioshroom_hyphae" | "quark:building/crafting/thatch_revert" | "minecraft:cracked_stone_bricks" | "create:blasting/nickel_ingot_compat_thermal" | "quark:building/stonecutting/carved_mud_bricks_stonecutter" | "biomancy:crafting/undead_permeable_membrane_pane_from_undead_permeable_membrane" | "jerotesvillage:second_round_nigrum_crate_craft" | "minecraft:ender_chest" | "minecraft:magenta_stained_glass" | "refinedstorage:coloring_recipes/lime_crafter_manager" | "prefab:warehouse" | "jerotesvillage:serpon_leggings_craft" | "quark:tweaks/crafting/lime_glass" | "minecraft:iron_trapdoor" | "minecraft:brown_candle" | "quark:building/stonecutting/slabs/orange_shingles_slab_stonecutter" | "meed:too_many_bows/cursed_flame" | "jerotesvillage:explorer_iron_leggings_smith" | "quark:building/stonecutting/stonevariants/polished_dripstone_stonecutter" | "quark:building/stonecutting/slabs/shingles_slab_stonecutter2" | "quark:building/stonecutting/vertslabs/calcite_vertical_slab_stonecutter" | "create:cutting/compat/regions_unexplored/stripped_dead_log" | "quark:world/crafting/panes/white_corundum_pane" | "create:milling/compat/byg/orchid" | "quark:world/stonecutting/walls/calcite_bricks_wall_stonecutter" | "quark:building/crafting/vertslabs/dark_oak_vertical_slab_revert" | "create:crafting/kinetics/track_observer" | "meed:ars_elemental/repel" | "quark:building/crafting/lamps/blue_crystal_lamp" | "minecraft:acacia_pressure_plate" | "create:cutting/compat/blue_skies/stripped_maple_wood" | "farmersdelight:integration/create/mixing/tomato_sauce_from_mixing" | "create:cutting/compat/byg/stripped_maple_wood" | "create:cutting/compat/atmospheric/stripped_yucca_wood" | "quark:building/stonecutting/vertslabs/smooth_quartz_vertical_slab_stonecutter" | "jerotesvillage:villager_metal_giant_beast_armor_craft" | "meed:ars_nouveau/soaked" | "refinedstorage:crafting_grid/light_gray_crafting_grid" | "create:crafting/materials/brass_block_from_compacting" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "quark:world/crafting/woodsets/blossom/hanging_sign" | "create:filling/compat/farmersdelight/milk_bottle" | "minecraft:lime_wool" | "minecraft:light_gray_wool" | "farmersdelight:cake_from_slices" | "biomancy:decomposing/flesh_stairs" | "jerotesvillage:flavorless_melon_craft" | "create:cut_asurine_brick_stairs" | "quark:world/crafting/waxed_black_corundum" | "quark:building/crafting/compressed/cocoa_beans_sack" | "create:cut_granite_from_stone_types_granite_stonecutting" | "create:cutting/compat/quark/ancient_log" | "meed:enlightened_end/dazed" | "minecraft:firework_rocket" | "create:cutting/warped_stem" | "quark:building/crafting/furnaces/deepslate_minecart_tweaked" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "refinedstorage:coloring_recipes/cyan_fluid_grid" | "jerotesvillage:unicycle_craft" | "create:crushing/compat/simplefarming/oat" | "jerotesvillage:black_yellow_planks_craft" | "legendary_monsters:eye_of_shulker" | "cataclysm:purpur_tile_wall" | "create:crafting/kinetics/gearshift" | "netherexp:soul_magma_block" | "minecraft:light_gray_dye_from_gray_white_dye" | "create:crushing/crimsite" | "create:crushing/tuff_recycling" | "protection_pixel:smallnetheritesheetloot" | "quark:building/crafting/vertslabs/permafrost_vertical_slab_revert" | "jerotesvillage:wonderland_slab_craft" | "functionalstorage:custom_compacting/packed_ice" | "netherexp:cut_netherite_stairs" | "biomancy:decomposing/biomesoplenty_porous_flesh" | "netherexp:silica_sandstone_wall" | "quark:building/stonecutting/vertslabs/rusty_iron_plate_vertical_slab_stonecutter" | "create:cutting/compat/ars_nouveau/green_archwood_log" | "sophisticatedbackpacks:advanced_filter_upgrade" | "cataclysm:cursed_bow" | "minecraft:stripped_birch_wood" | "farmersdelight:roasted_mutton_chops" | "jerotesvillage:dye_from_magenta_mums" | "jerotesvillage:hag_replacement/jerotesvillage_meganose_snow_lizard_meat" | "minecraft:lime_banner" | "refinedstorage:coloring_recipes/green_crafter_manager" | "refinedstorage:coloring_recipes/light_gray_pattern_grid" | "itemfilters:mod" | "refinedstorage:coloring_recipes/yellow_pattern_grid" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "jerotesvillage:cooked_sun_crab" | "pasterdream:crafting_3" | "create:polished_cut_andesite_wall" | "pasterdream:crafting_4" | "minecraft:cut_copper_from_copper_block_stonecutting" | "pasterdream:crafting_1" | "pasterdream:crafting_2" | "pasterdream:crafting_7" | "pasterdream:crafting_8" | "minecraft:polished_andesite_stairs_from_polished_andesite_stonecutting" | "pasterdream:crafting_5" | "jerotesvillage:key_second_round_world_block_craft" | "pasterdream:crafting_6" | "create:cutting/compat/biomesoplenty/fir_log" | "create:cutting/compat/biomesoplenty/stripped_hellbark_log" | "pasterdream:crafting_9" | "create:cutting/compat/regions_unexplored/baobab_log" | "cataclysm:azure_seastone_mural_empty" | "create:polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "quark:building/crafting/vertslabs/tuff_vertical_slab_revert" | "create:crushing/compat/byg/red_rock" | "quark:building/crafting/vertslabs/lime_shingles_vertical_slab_revert" | "farmersdelight:cabbage_crate" | "quark:building/crafting/panes/pink_framed_glass_pane" | "create:cut_scoria_from_stone_types_scoria_stonecutting" | "create:polished_cut_asurine_wall" | "meed:cataclysm/stun" | "create:cutting/compat/ecologics/azalea_log" | "quark:world/stonecutting/walls/shale_bricks_wall_stonecutter" | "quark:building/stonecutting/slabs/blue_shingles_slab_stonecutter" | "create:cutting/compat/upgrade_aquatic/stripped_river_wood" | "meed:enlightened_end/bubbling" | "biomancy:decomposing/cachalot_whale_tooth" | "jerotesvillage:smooth_glitter_sandstone_slab_from_smooth_glitter_sandstone_stonecutting" | "cataclysm:stonecutting/azure_seastone_pillar_wall_from_stonecutting" | "biomancy:bio_brewing/absorption_boost" | "farmersdelight:half_tatami_mat" | "quark:world/crafting/slabs/azalea_planks_slab" | "functionalstorage:custom_compacting/melon" | "biomancy:decomposing/bloomberry" | "quark:building/crafting/hollowlogs/hollow_birch_log" | "biomancy:decomposing/bone_serpent_tooth" | "create:crafting/schematics/schematic_and_quill" | "jerotesvillage:ominous_giant_beast_armor_craft" | "netherexp:ancient_burning_skull_block" | "netherexp:cooking/netherite_grate" | "netherexp:stonecutting/from_soul_slate/soul_slate_bricks" | "create:small_ochrum_brick_stairs" | "minecraft:crimson_sign" | "jeed:mining_fatigue" | "jerotesvillage:villager_block_witch_craft" | "quark:building/crafting/vertslabs/mangrove_vertical_slab" | "create:crafting/copper/waxed_copper_shingles_from_honeycomb" | "jerotesvillage:chiseled_sun_sandstone_craft" | "biomancy:bio_forging/chrysalis" | "quark:building/stonecutting/stairs/polished_tuff_stairs_stonecutter" | "quark:building/crafting/vertslabs/red_shingles_vertical_slab" | "minecraft:stone_brick_slab" | "create:cutting/compat/byg/palo_verde_wood" | "quark:building/crafting/soul_sandstone" | "quark:building/stonecutting/vertslabs/cut_red_sandstone_vertical_slab_stonecutter" | "jerotesvillage:hag_replacement/jerotesvillage_pink_cactus" | "minecraft:polished_blackstone_pressure_plate" | "quark:building/crafting/shingles/white_shingles_dye" | "create:milling/compat/byg/pink_daffodil" | "quark:building/stonecutting/vertslabs/orange_shingles_vertical_slab_stonecutter" | "create:small_andesite_brick_stairs" | "biomancy:decomposing/rattlesnake_rattle" | "quark:building/crafting/vertslabs/rusty_iron_plate_vertical_slab" | "quark:building/crafting/vertslabs/andesite_bricks_vertical_slab" | "quark:building/crafting/stonevariants/chiseled_andesite_bricks" | "create:cutting/compat/regions_unexplored/baobab_wood" | "quark:building/crafting/chests/nether_brick_chest" | "create:milling/compat/ae2/sky_stone_block" | "minecraft:stone_slab_from_stone_stonecutting" | "farmersdelight:cooking/cabbage_rolls" | "minecraft:gray_glazed_terracotta" | "prefab:swift_blade_netherite" | "protection_pixel:nightdemonloot" | "create:cut_calcite_wall" | "minecraft:gold_ingot_from_nuggets" | "jerotesvillage:hag_replacement/minecraft_wither_rose" | "biomancy:bio_forging/flesh_fence_gate" | "moblassos:contract" | "protection_pixel:grenadeloot" | "quark:building/stonecutting/slabs/cut_soul_sandstone_slab_stonecutter" | "netherexp:cooking/cut_netherite_pillar" | "jerotesvillage:serpon_glaive_craft" | "minecraft:netherite_leggings_smithing" | "refinedstorage:crafting_grid/crafting_grid" | "biomancy:decomposing/biomesoplenty_pus_bubble" | "farmersdelight:mutton_wrap" | "netherexp:twisting_ivy" | "create:crimson_window_pane" | "create:cutting/compat/byg/imparius_stem" | "quark:building/stonecutting/vertslabs/light_blue_shingles_vertical_slab_stonecutter2" | "create:cutting/birch_log" | "create:crafting/kinetics/sticky_mechanical_piston" | "legendary_monsters:withered_ripcage" | "minecraft:stone_brick_stairs_from_stone_stonecutting" | "create:cutting/compat/biomesoplenty/stripped_mahogany_log" | "create:cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "minecraft:honey_bottle" | "biomancy:decomposing/pearl" | "functionalstorage:custom_compacting/ice" | "create:milling/compat/byg/orange_daisy" | "create:milling/compat/botania/gray_petal" | "create:cutting/compat/twilightforest/mangrove_log" | "quark:building/crafting/lime_stool" | "quark:building/stonecutting/stairs/magenta_shingles_stairs_stonecutter" | "prefab:quartz_crete_smooth_slab" | "netherexp:glowcheese" | "jerotesvillage:hag_replacement/minecraft_scute" | "jerotesvillage:serpon_giant_beast_armor_craft" | "quark:building/crafting/stonevariants/tuff_bricks" | "biomancy:digesting/nutrient_paste_from_saplings" | "quark:building/crafting/lamps/white_corundum_lamp" | "minecraft:raw_copper_block" | "quark:building/stonecutting/walls/tuff_wall_stonecutter" | "minecraft:polished_diorite_from_diorite_stonecutting" | "quark:building/stonecutting/stonevariants/andesite_bricks_stairs_polished_stonecutting" | "create:crafting/kinetics/light_blue_seat_from_other_seat" | "create:crafting/kinetics/gantry_shaft" | "biomancy:decomposing/carmine_froglight" | "cataclysm:stonecutting/stone_tile_wall_from_stonecutting" | "create:splashing/magma_block" | "jerotesvillage:meror_metal_crossbow_craft" | "meed:ars_nouveau/hex" | "quark:building/crafting/shingles/light_gray_shingles" | "quark:building/crafting/vertslabs/cut_red_sandstone_vertical_slab" | "netherexp:stonecutting/from_netherrack_bricks/netherrack_brick_stairs" | "refinedstorage:coloring_recipes/purple_relay" | "create:haunting/infested_deepslate" | "quark:world/crafting/slabs/jasper_bricks_slab" | "minecraft:lapis_lazuli" | "quark:building/crafting/slabs/brown_shingles_slab" | "prefab:farm_improved" | "jerotesvillage:sun_sandstone_wall_from_sun_sandstone_stonecutting" | "quark:building/crafting/cyan_stool" | "art_of_forging:fire_charge_alt" | "minecraft:quartz_block" | "create:cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "netherexp:smithing/valor_armor_trim" | "create:cutting/compat/ars_nouveau/purple_archwood_log" | "farmersdelight:safety_net" | "born_in_chaos_v1:black_argillite_button_k" | "biomancy:decomposing/tripodfish" | "prefab:pallet_of_bricks_to_pile_of_bricks" | "quark:building/crafting/panes/lime_framed_glass_pane" | "refinedstorage:coloring_recipes/cyan_network_receiver" | "jerotes:gold_nugget_from_other_blast" | "netherexp:rusty_cut_netherite_block" | "netherexp:warphopper_fur_paper" | "create:milling/compat/byg/green_tulip" | "create:cut_andesite_stairs" | "create:cutting/crimson_stem" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "biomancy:stonecutting/flesh_wall_from_flesh" | "quark:world/crafting/slabs/polished_shale_slab" | "quark:building/crafting/vertslabs/cherry_vertical_slab" | "quark:building/crafting/vertslabs/lime_shingles_vertical_slab" | "create:splashing/crushed_raw_gold" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "farmersdelight:cutting/orange_tulip" | "create:cut_veridium_stairs" | "born_in_chaos_v1:smoked_monster_flesh_k_2" | "farmersdelight:cutting/mangrove_door" | "prefab:double_compressed_stone_from_compressed_stone" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "meed:feywild/fey_flying" | "quark:world/crafting/panes/black_corundum" | "refinedstorage:coloring_recipes/gray_disk_manipulator" | "biomancy:decomposing/triops_eggs" | "meed:born_in_chaos_v1/strong_rampage" | "lendersdelight:cook/fried_abyssal_egg_from_smoking" | "quark:building/crafting/hollowlogs/hollow_mangrove_log" | "create:milling/compat/byg/daffodil" | "biomancy:decomposing/emu_feather" | "jerotesvillage:carved_lodestone_craft" | "jerotesvillage:qoaiku_metal_ingotin_craft" | "protection_pixel:slingshotasloot" | "refinedstorage:coloring_recipes/purple_security_manager" | "minecraft:deepslate_tile_wall" | "minecraft:polished_deepslate_stairs" | "cataclysm:stonecutting/stone_pillar_from_stonecutting" | "quark:tweaks/smelting/raw_iron_bricks_smelt" | "create:cut_scorchia_slab" | "quark:building/crafting/lamps/green_corundum_lamp" | "quark:building/crafting/vertslabs/blue_shingles_vertical_slab_revert" | "minecraft:waxed_exposed_cut_copper_slab_from_honeycomb" | "born_in_chaos_v1:scorched_planks_slab_k" | "create:cutting/compat/ars_nouveau/purple_archwood_wood" | "create:pressing/compat/betterendforge/end_moss_path" | "create:crafting/kinetics/orange_seat_from_other_seat" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "quark:world/stonecutting/walls/permafrost_bricks_wall_stonecutter" | "quark:building/crafting/vertslabs/red_shingles_vertical_slab_revert" | "create:cutting/compat/byg/aspen_wood" | "create:crushing/gold_ore" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:milling/compat/environmental/purple_hibiscus" | "create:small_asurine_brick_stairs" | "born_in_chaos_v1:smoked_monster_flesh_k" | "quark:building/stonecutting/vertslabs/polished_dripstone_vertical_slab2" | "create:smelting/zinc_ingot_from_ore" | "prefab:sickle_netherite" | "netherexp:stonecutting/from_pale_soul_slate/tiles" | "create:crafting/kinetics/mechanical_bearing" | "minecraft:golden_carrot" | "farmersdelight:cutting/stone" | "quark:building/crafting/chests/bamboo_chest" | "create:polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "cataclysm:stonecutting/azure_seastone_brick_stair_from_stonecutting" | "minecraft:prismarine_wall" | "biomancy:bio_forging/tubular_flesh" | "constructionwand:dynamic/wand_upgrade" | "refinedstorage:coloring_recipes/light_gray_security_manager" | "quark:building/stonecutting/stairs/tuff_stairs_stonecutter" | "quark:building/crafting/stairs/dripstone_block_stairs" | "create:crafting/kinetics/elevator_pulley" | "jerotesvillage:sediment_mud_brick_stairs_from_sediment_mud_bricks_stonecutting" | "quark:world/crafting/panes/red_corundum_pane" | "netherexp:bone_cortical" | "create:cutting/compat/biomesoplenty/stripped_dead_wood" | "quark:building/crafting/vertslabs/cobblestone_bricks_vertical_slab" | "farmersdelight:cooking/beetroot_soup" | "create:milling/compat/regions_unexplored/pink_lupine" | "minecraft:magma_cream" | "biomancy:decomposing/packed_flesh_wall" | "create:crafting/kinetics/attribute_filter" | "farmersdelight:cutting/bamboo_block" | "minecraft:blackstone_wall" | "create:cutting/compat/blue_skies/frostbright_log" | "quark:building/crafting/red_blossom_hedge" | "biomancy:decomposing/volatile_gland" | "born_in_chaos_v1:nut_hammer_craft" | "create:pressing/silt_dirt_path_from_grass" | "quark:tweaks/crafting/green_glass" | "quark:building/crafting/vertslabs/mossy_cobblestone_bricks_vertical_slab_revert" | "protection_pixel:blooddialysisdeviceloot" | "refinedstorage:coloring_recipes/light_gray_detector" | "minecraft:dried_kelp_from_smelting" | "biomancy:bio_forging/undead_permeable_membrane" | "jerotesvillage:black_yellow_slab_craft" | "quark:building/stonecutting/vertslabs/limestone_vertical_slab_stonecutter" | "minecraft:cherry_sign" | "create:crushing/deepslate_gold_ore" | "meed:degus_grace" | "functionalstorage:compacting_drawer" | "refinedstorage:coloring_recipes/purple_detector" | "create:crafting/kinetics/purple_seat" | "farmersdelight:onion_crate" | "quark:building/stonecutting/slabs/red_shingles_slab_stonecutter" | "quark:building/crafting/stairs/dripstone_bricks_stairs" | "legendary_monsters:fiery_boots" | "netherexp:polished_basalt_brick_slab" | "quark:building/stonecutting/vertslabs/soul_sandstone_bricks_vertical_slab_stonecutter" | "create:crushing/compat/elementaryores/ore_coal_end" | "netherexp:stonecutting/from_wither_bone_block/stacked_bone_slab" | "jerotesvillage:carved_leader_chestplate_smith" | "jerotesvillage:serpon_alloy_nugget_from_blast" | "jerotesvillage:serpon_boots_craft" | "protection_pixel:grende" | "create:crafting/materials/brass_ingot_from_compacting" | "jerotesvillage:villager_block_hawker_craft" | "quark:building/stonecutting/stairs/light_gray_shingles_stairs_stonecutter" | "quark:building/stonecutting/vertslabs/shingles_vertical_slab_stonecutter" | "farmersdelight:cutting/saddle" | "minecraft:dye_blue_carpet" | "quark:building/crafting/furnaces/deepslate_minecart" | "farmersdelight:cutting/cherry_hanging_sign" | "netherexp:stonecutting/from_soul_slate_tiles/slab" | "minecraft:exposed_cut_copper_stairs" | "create:crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "create:polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "create:pressing/compat/betterendforge/cave_moss_path" | "quark:building/crafting/vertplanks/vertical_crimson_planks_revert" | "jerotesvillage:flavorless_melon_seeds_craft" | "minecraft:jungle_boat" | "cataclysm:ignitium_upgrade_smithing_template" | "minecraft:stripped_mangrove_wood" | "sophisticatedbackpacks:advanced_feeding_upgrade" | "biomancy:digesting/nutrient_paste_from_moss_carpet" | "quark:world/crafting/woodsets/ancient/chest_boat" | "minecraft:light_weighted_pressure_plate" | "quark:building/crafting/yellow_blossom_leaf_carpet" | "quark:building/stonecutting/slabs/black_shingles_slab_stonecutter" | "easy_villagers:farmer" | "refinedstorage:coloring_recipes/network_transmitter" | "minecraft:dye_green_wool" | "born_in_chaos_v1:infernal_evil_pumpkin_k_2" | "create:crafting/appliances/netherite_diving_helmet" | "meed:self_destructing" | "jerotesvillage:drought_fire_brick_stairs_from_drought_fire_bricks_stonecutting" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "create:cutting/compat/regions_unexplored/brimwood_log" | "sophisticatedbackpacks:diamond_backpack" | "minecraft:black_stained_glass_pane_from_glass_pane" | "minecraft:pink_banner" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "minecraft:bamboo_button" | "quark:building/crafting/vertslabs/crimson_vertical_slab" | "create:cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "minecraft:copper_ingot_from_waxed_copper_block" | "refinedstorage:1k_storage_disk" | "art_of_forging:tnt_alt" | "netherexp:gargoyle_statues/treacherous" | "create:cut_deepslate_slab_recycling" | "quark:building/stonecutting/vertslabs/green_shingles_vertical_slab_stonecutter" | "minecraft:cherry_trapdoor" | "create:cutting/compat/twilightforest/canopy_log" | "meed:bloodandmadness/trapped" | "netherexp:claret_sign" | "quark:building/stonecutting/stonevariants/tuff_bricks_wall_rough_stonecutting" | "refinedstorage:4096k_fluid_storage_disk" | "jerotesvillage:meror_metal_mixture_craft" | "create:splashing/ice" | "minecraft:acacia_trapdoor" | "biomancy:decomposing/ornate_flesh_slab" | "lendersdelight:amethyst_crab_meat_stick" | "create:splashing/endergetic/petrified_nether_corrock" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "biomancy:decomposing/dragon_egg" | "create:crafting/kinetics/empty_blaze_burner" | "netherexp:weeping_ivy" | "quark:building/crafting/vertslabs/waxed_cut_copper_vertical_slab" | "legendary_monsters:eye_of_chorus" | "born_in_chaos_v1:monster_skin_k" | "minecraft:cracked_nether_bricks" | "create:crafting/kinetics/secondary_linear_chassisfrom_conversion" | "meed:soulsweapons/life_leach" | "farmersdelight:cutting/bamboo_sign" | "cataclysm:amethyst_bless/blessed_amethyst_crab_meat" | "minecraft:purpur_pillar_from_purpur_block_stonecutting" | "biomancy:bio_forging/flesh_spike" | "refinedstorage:cable" | "refinedstorage:coloring_recipes/brown_crafting_grid" | "art_of_forging:sigil_of_eden" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "born_in_chaos_v1:dark_metal_nugget_craft" | "cataclysm:purpur_bricks" | "create:copper_shingle_stairs" | "create:milling/compat/regions_unexplored/white_snowbelle" | "minecraft:copper_ingot_from_smelting_copper_ore" | "refinedstorage:crafting_grid/blue_crafting_grid" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_brick_stairs" | "quark:building/crafting/vertslabs/dripstone_block_vertical_slab_revert" | "jerotesvillage:iron_nugget_from_ancient_second_rounder_smelt" | "create:haunting/glow_berries" | "jerotesvillage:meror_metal_stick_craft" | "quark:building/crafting/vertslabs/polished_blackstone_brick_vertical_slab_revert" | "create:small_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:iron_pickaxe" | "refinedstorage:coloring_recipes/light_gray_wireless_transmitter" | "minecraft:spruce_button" | "create:cut_andesite_from_stone_types_andesite_stonecutting" | "quark:building/stonecutting/vertslabs/smooth_stone_vertical_slab_stonecutter" | "quark:building/stonecutting/stairs/polished_dripstone_stairs_stonecutter" | "create:crushing/asurine" | "quark:building/stonecutting/vertslabs/light_gray_shingles_vertical_slab_stonecutter2" | "minecraft:deepslate_tiles" | "meed:aether/inebriation" | "quark:world/stonecutting/stairs/andesite_bricks_stairs_stonecutter" | "jerotesvillage:gold_nugget_from_other_smelt" | "minecraft:polished_diorite_stairs" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "jerotesvillage:bitter_cold_chest_boat_craft" | "quark:building/stonecutting/chiseled_soul_sandstone_stonecutter" | "create:cutting/compat/byg/cypress_wood" | "netherexp:stonecutting/from_soul_slate_bricks/chiseled" | "create:cutting/oak_wood" | "tetra:hammer/spruce" | "minecraft:dark_oak_slab" | "prefab:grass_wall" | "quark:building/crafting/vertslabs/exposed_cut_copper_vertical_slab" | "quark:tweaks/crafting/utility/chest_boat/direct_bamboo_chest_raft" | "born_in_chaos_v1:diamond_thermite_shard_k" | "protection_pixel:linkplatelegloot" | "sophisticatedbackpacks:inception_upgrade" | "refinedstorage:fluid_grid/brown_fluid_grid" | "jerotesvillage:virtual_cave_evil_crystal_craft" | "minecraft:lime_stained_glass" | "jerotes:simple_spear_craft" | "create:cutting/compat/atmospheric/grimwood_log" | "refinedstorage:coloring_recipes/brown_wireless_transmitter" | "quark:building/crafting/compressed/berry_sack_uncompress" | "quark:building/crafting/vertslabs/light_blue_shingles_vertical_slab_revert" | "quark:building/crafting/glass/lime_framed_glass" | "minecraft:stone_brick_walls_from_stone_stonecutting" | "quark:building/stonecutting/vertslabs/stone_brick_vertical_slab2_stonecutter" | "create:crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "cataclysm:stonecutting/purpur_tile_wall_from_stonecutting" | "create:cutting/compat/blue_skies/lunar_log" | "quark:tweaks/crafting/utility/chests/cherry_chest_wood" | "quark:building/stonecutting/stonevariants/chiseled_shale_bricks_stonecutter" | "create:splashing/sand" | "minecraft:yellow_dye_from_dandelion" | "quark:building/crafting/vertslabs/diorite_vertical_slab" | "refinedstorage:grid" | "jerotesvillage:rambler_leather_stick_craft" | "biomancy:bio_forging/flesh_fence" | "quark:world/crafting/polished_shale" | "quark:world/crafting/stairs/diorite_bricks_stairs" | "meed:carry" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "create:splashing/endergetic/petrified_nether_corrock_block" | "farmersdelight:cutting/spruce_trapdoor" | "create:mixing/lava_from_cobble" | "create:splashing/wheat_flour" | "create:crafting/kinetics/item_drain" | "create:deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:eye_armor_trim_smithing_template" | "waystones:attuned_shard" | "quark:building/crafting/stairs/tuff_stairs" | "biomancy:decomposing/cockroach_ootheca" | "netherexp:soul_slate_tiles_from_etched" | "create:cut_tuff_brick_wall" | "create:crushing/compat/byg/cryptic_redstone_ore" | "farmersdelight:cutting/warped_door" | "create:crafting/appliances/crafting_blueprint" | "quark:building/crafting/vertplanks/vertical_acacia_planks_revert" | "create:crushing/veridium" | "quark:building/stonecutting/stonevariants/jasper_bricks_vertical_slab_polished_stonecutting" | "create:cutting/compat/regions_unexplored/stripped_cypress_log" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "quark:building/crafting/chests/nether_brick_trapped_chest" | "create:cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "create:deploying/cogwheel" | "quark:building/crafting/cherry_hedge" | "jerotesvillage:arc_arrow_craft" | "create:horizontal_framed_glass_pane" | "refinedstorage:range_upgrade" | "cataclysm:chorus_planks" | "quark:building/stonecutting/stairs/lime_shingles_stairs_stonecutter" | "jerotesvillage:purple_sand_dye_craft" | "quark:building/crafting/stonevariants/andesite_pillar" | "quark:building/stonecutting/vertslabs/waxed_cut_copper_vertical_slab_from_waxed_copper_block" | "meed:divine_weaponry/wither_resistance" | "minecraft:mangrove_button" | "jeed:poison" | "functionalstorage:fluid_4" | "functionalstorage:fluid_1" | "functionalstorage:fluid_2" | "minecraft:yellow_bed" | "quark:world/crafting/woodsets/blossom/sign" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "born_in_chaos_v1:shattered_skull_k_1" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:filling/grass_block" | "minecraft:cooked_salmon_from_smoking" | "create:cutting/compat/regions_unexplored/ashen_wood" | "netherexp:stonecutting/from_wither_bone_block/skull_block" | "quark:world/crafting/stairs/shale_stairs" | "meed:soulsweapons/shadow_step" | "quark:building/crafting/vertplanks/vertical_warped_planks_revert" | "minecraft:bamboo_mosaic" | "meed:cataclysm/curse_of_desert" | "lendersdelight:grilled_lionfish" | "born_in_chaos_v1:phantom_powder_k" | "netherexp:cooking/cut_netherite_block" | "create:cutting/compat/atmospheric/stripped_morado_log" | "create:cutting/compat/blue_skies/crystallized_wood" | "tetra:hammer/stone" | "constructionwand:core_angel" | "create:polished_cut_dripstone_slab_recycling" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "farmersdelight:cutting/jungle_trapdoor" | "quark:building/crafting/birch_leaf_carpet" | "create:cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "minecraft:purple_candle" | "functionalstorage:netherite_upgrade" | "create:asurine_from_stone_types_asurine_stonecutting" | "biomancy:bio_brewing/genetic_compound" | "born_in_chaos_v1:transmuting_elixirkraft" | "create:milling/compat/regions_unexplored/waratah" | "create:cutting/compat/byg/stripped_ether_log" | "biomancy:crafting/adult_permeable_membrane_from_adult_permeable_membrane_pane" | "minecraft:mossy_stone_brick_slab" | "quark:building/crafting/slabs/cut_soul_sandstone_slab" | "minecraft:polished_blackstone_wall_from_polished_blackstone_stonecutting" | "protection_pixel:workerloot" | "quark:building/crafting/vertslabs/white_shingles_vertical_slab" | "sophisticatedbackpacks:crafting_upgrade" | "create:crushing/raw_tin_block" | "quark:building/stonecutting/stairs/pink_shingles_stairs_stonecutter2" | "cataclysm:sticky_gloves" | "create:cutting/compat/quark/stripped_ancient_log" | "create:small_tuff_brick_slab" | "netherexp:stonecutting/from_blue_nether_bricks/blue_nether_brick_slab" | "biomancy:decomposing/blaze_powder" | "cataclysm:ancient_metal_nugget_from_smelting" | "quark:building/crafting/vertslabs/dripstone_block_vertical_slab" | "minecraft:cobblestone_stairs" | "refinedstorage:coloring_recipes/purple_fluid_grid" | "functionalstorage:configuration_tool" | "netherexp:brown_dye_from_fossil_fuel" | "create:milling/compat/buzzier_bees/pink_clover" | "create:cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:cutting/stripped_oak_log" | "quark:building/crafting/vertslabs/raw_iron_bricks_vertical_slab_revert" | "create:cut_scorchia_brick_wall" | "refinedstorage:coloring_recipes/red_crafting_monitor" | "functionalstorage:void_upgrade" | "create:crafting/curiosities/toolbox_dyeing" | "jerotesvillage:anesthetized_arrow_craft" | "farmersdelight:cutting/warped_hyphae" | "born_in_chaos_v1:orange_stained_glass_panel_k" | "quark:building/crafting/shingles/purple_shingles_dye" | "create:cutting/compat/atmospheric/stripped_kousa_wood" | "netherexp:bone_fence" | "create:polished_cut_scoria_slab_recycling" | "jerotesvillage:purple_sandstone_slab_from_purple_sandstone_stonecutting" | "quark:building/stonecutting/stonevariants/tuff_bricks_stairs_rough_stonecutting" | "minecraft:polished_basalt" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "quark:building/stonecutting/stonevariants/tuff_bricks_slab_polished_stonecutting" | "create:mechanical_crafting/crushing_wheel" | "refinedstorage:fluid_grid/black_fluid_grid" | "create:cutting/compat/ecologics/stripped_coconut_wood" | "create:small_andesite_brick_slab" | "quark:building/crafting/vertslabs/yellow_shingles_vertical_slab" | "create:cutting/compat/biomesoplenty/redwood_log" | "biofactory:compacting/packed_flesh_block_from_flesh_blocks" | "minecraft:sentry_armor_trim_smithing_template" | "biomancy:decomposing/slime_ball" | "create:crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "meed:epicfight/instability" | "quark:building/crafting/walls/sandstone_bricks_wall" | "create:cut_andesite_slab_recycling" | "minecraft:polished_andesite_slab" | "create:splashing/magenta_concrete_powder" | "refinedstorage:quartz_enriched_iron" | "meed:enlightened_end/suffocation" | "create:milling/compat/environmental/red_lotus_flower" | "waystones:warp_dust" | "quark:building/stonecutting/stonevariants/chiseled_tuff_bricks_stonecutter" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "create:deploying/waxed_oxidized_cut_copper_from_adding_wax" | "biomancy:digesting/nutrient_paste_from_kelp" | "quark:building/crafting/walls/dripstone_block_wall" | "jerotesvillage:hag_replacement/minecraft_golden_apple" | "quark:tweaks/smelting/raw_gold_block_smelt" | "biomancy:digesting/nutrient_paste_from_cycad" | "minecraft:yellow_candle" | "quark:building/stonecutting/stairs/red_sandstone_bricks_stairs_stonecutter" | "netherexp:netherrack_tiles" | "quark:building/crafting/ancient_leaf_carpet" | "biomancy:decomposing/grass_block" | "create:deploying/waxed_exposed_copper_shingle_slab_from_adding_wax" | "quark:tweaks/crafting/utility/coral/bubble_to_magenta" | "quark:building/crafting/magenta_stool" | "create:crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "create:cutting/compat/twilightforest/sorting_log" | "minecraft:repeater" | "minecraft:red_concrete_powder" | "quark:building/crafting/hollowlogs/hollow_spruce_log" | "jerotesvillage:hoglin_farm_map_craft" | "quark:tweaks/crafting/utility/wool/orange_wool" | "quark:building/stonecutting/vertslabs/waxed_weathered_cut_copper_vertical_slab_from_waxed_weathered_copper" | "create:polished_cut_limestone_slab" | "born_in_chaos_v1:intoxicatind_bomb_k" | "create:weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "jerotesvillage:cut_purple_sandstone_slab_craft" | "biomancy:digesting/nutrient_paste_from_mushrooms" | "minecraft:iron_leggings" | "create:emptying/compat/alexsmobs/lava_bottle" | "create:rose_quartz_block_from_rose_quartz_stonecutting" | "biomancy:crafting/undead_permeable_membrane_from_undead_permeable_membrane_pane" | "jerotesvillage:bitter_cold_button_craft" | "quark:tools/smithing/rune_smithing_white" | "minecraft:book_cloning" | "quark:building/crafting/shingles/red_shingles" | "cataclysm:cursed_eye" | "netherexp:soul_slate_slab" | "biomancy:decomposing/banana_slug_slime" | "biomancy:decomposing/dirt" | "netherexp:lightspores" | "create:cutting/compat/twilightforest/transformation_log" | "quark:building/crafting/vertslabs/prismarine_vertical_slab" | "create:cut_andesite_wall_from_stone_types_andesite_stonecutting" | "minecraft:mushroom_stew" | "farmersdelight:cooked_mutton_chops_from_smoking" | "create:crafting/kinetics/analog_lever" | "create:andesite_scaffolding_from_andesite_alloy_stonecutting" | "create:deploying/waxed_exposed_cut_copper_slab_from_adding_wax" | "protection_pixel:nightdemonasloot" | "create:smelting/zinc_ingot_from_crushed" | "born_in_chaos_v1:spiritual_divider_k" | "prefab:pallet_of_bricks_from_pile_of_bricks" | "quark:building/crafting/stonevariants/chiseled_tuff_bricks" | "minecraft:dye_white_carpet" | "netherexp:gargoyle_statues/wretched" | "quark:world/crafting/woodsets/azalea/wood" | "quark:automation/crafting/nether_brick_fence_gate" | "quark:building/stonecutting/stonevariants/tuff_pillar_stonecutter" | "born_in_chaos_v1:lordpumpkinheadslampk" | "create:crafting/logistics/content_observer" | "create:cutting/compat/regions_unexplored/dead_wood" | "quark:building/crafting/vertslabs/smooth_stone_vertical_slab" | "meed:biomemakeover/shocked" | "refinedstorage:coloring_recipes/gray_network_receiver" | "quark:building/stonecutting/stonevariants/limestone_bricks_wall_rough_stonecutting" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "create:cutting/compat/integrateddynamics/menril_wood_stripped" | "lendersdelight:cook/cooked_coboleton_meat_from_smoking" | "minecraft:jungle_door" | "create:cutting/compat/regions_unexplored/stripped_yellow_bioshroom_stem" | "jerotesvillage:carved_bricks_from_villager_metal_block_stonecutting" | "minecraft:prismarine_brick_slab" | "farmersdelight:full_tatami_mat" | "biomancy:bio_forging/nautilus_shell" | "minecraft:nether_bricks" | "refinedstorage:coloring_recipes/white_network_receiver" | "minecraft:iron_chestplate" | "create:cutting/compat/byg/fungal_imparius_hyphae" | "quark:tweaks/crafting/utility/chest_boat/direct_dark_oak_chest_boat" | "create:cut_veridium_slab" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "prefab:double_compressed_quartz_crete_from_compressed_quartz_crete" | "quark:building/crafting/netherrack_bricks" | "create:cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "cataclysm:purpur_tile_stairs" | "farmersdelight:rope" | "minecraft:vex_armor_trim_smithing_template" | "create:splashing/immersiveengineering/crushed_raw_aluminum" | "prefab:ton_of_timber" | "minecraft:polished_andesite_from_andesite_stonecutting" | "minecraft:crimson_stairs" | "create:cut_granite_slab_recycling" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "quark:oddities/crafting/encased_pipe_revert" | "create:crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "jerotes:netherite_giant_beast_armor_smith" | "minecraft:stone_brick_stairs" | "refinedstorage:coloring_recipes/red_network_transmitter" | "create:smelting/ingot_uranium_compat_ic2" | "create:cutting/compat/blue_skies/stripped_lunar_log" | "biomancy:decomposing/torchflower_seeds" | "netherexp:stonecutting/soul_slate_bricks_from_etched_soul_slate_bricks" | "minecraft:polished_blackstone_wall_from_blackstone_stonecutting" | "quark:world/stonecutting/stairs/limestone_bricks_stairs_stonecutter" | "quark:tweaks/crafting/utility/wool/yellow_wool" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "create:cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:crafting/kinetics/light_blue_seat" | "jerotesvillage:hag_replacement/minecraft_dirt" | "create:cutting/compat/byg/cika_wood" | "quark:oddities/crafting/magnet_pre_end" | "quark:building/crafting/vertslabs/warped_vertical_slab" | "refinedstorage:coloring_recipes/magenta_crafter" | "minecraft:clock" | "create:splashing/endergetic/petrified_end_corrock" | "create:crafting/appliances/netherite_diving_helmet_from_netherite" | "biomancy:decomposing/tube_coral_fan" | "meed:ars_nouveau/snared" | "quark:building/crafting/vertplanks/vertical_blossom_planks_revert" | "born_in_chaos_v1:rotten_soil_k" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_wood" | "quark:building/crafting/vertslabs/polished_deepslate_vertical_slab" | "quark:building/stonecutting/vertslabs/black_shingles_vertical_slab_stonecutter2" | "netherexp:cooking/cut_netherite_slab" | "quark:building/crafting/stonevariants/chiseled_myalite_bricks" | "biomancy:digesting/nutrient_paste_from_sniffer_egg" | "create:milling/compat/byg/protea_flower" | "cataclysm:stonecutting/frosted_stone_brick_stairs_from_stonecutting" | "quark:building/crafting/warped_post" | "create:cutting/compat/ecologics/coconut_wood" | "create:filling/compat/neapolitan/milk_bottle" | "minecraft:blue_ice" | "lendersdelight:cook/cooked_coral_golem_meat" | "netherexp:stonecutting/from_soul_slate/soul_slate_brick_slab" | "quark:building/stonecutting/slabs/raw_copper_bricks_slab_stonecutter" | "biomancy:decomposing/bone_meal" | "minecraft:diamond_leggings" | "jerotesvillage:bitter_cold_hammer_craft" | "quark:world/crafting/slabs/limestone_bricks_slab" | "born_in_chaos_v1:darkupgradek" | "quark:building/crafting/jungle_bookshelf" | "minecraft:purple_stained_glass" | "create:crushing/diamond_ore" | "quark:building/crafting/vertslabs/dirt_bricks_vertical_slab" | "minecraft:cut_copper_stairs" | "quark:building/stonecutting/stonevariants/calcite_bricks_polished_stonecutting" | "farmersdelight:integration/immersiveengineering/fermenter/tomato" | "jerotesvillage:hag_replacement/jerotesvillage_purple_sand" | "quark:building/crafting/slabs/thatch_slab" | "create:polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "jerotesvillage:villager_metal_base_block_craft" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "jerotesvillage:hag_replacement/jerotesvillage_ruin_stone_bricks" | "cataclysm:cursium_ingot" | "refinedstorage:4096k_fluid_storage_disk_from_storage_housing" | "create:cut_asurine_brick_slab" | "create:cutting/compat/byg/stripped_baobab_wood" | "born_in_chaos_v1:smokedfish_k" | "prefab:carrots_from_bunch" | "create:milling/sunflower" | "minecraft:mossy_stone_bricks_from_moss_block" | "quark:building/crafting/compressed/chorus_fruit_block_uncompress" | "minecraft:orange_banner" | "quark:building/crafting/stonevariants/granite_bricks" | "farmersdelight:cutting/birch_trapdoor" | "minecraft:dark_oak_sign" | "jerotesvillage:serpent_dominater_armor_trim" | "create:cutting/compat/upgrade_aquatic/stripped_river_log" | "farmersdelight:iron_nugget_from_smelting_knife" | "minecraft:oak_hanging_sign" | "create:cutting/compat/twilightforest/twilight_oak_wood" | "protection_pixel:fiberloot" | "quark:building/crafting/glass/white_framed_glass" | "create:cutting/compat/twilightforest/time_wood" | "biomancy:decomposing/adult_permeable_membrane_pane" | "jerotesvillage:stripped_bitter_cold_wood_craft" | "quark:building/crafting/vertslabs/smooth_stone_vertical_slab_revert" | "quark:world/stonecutting/slabs/polished_jasper_slab_stonecutter2" | "minecraft:brick_slab_from_bricks_stonecutting" | "quark:building/stonecutting/vertslabs/gray_shingles_vertical_slab_stonecutter2" | "refinedstorage:crafting_grid/magenta_crafting_grid" | "refinedstorage:16k_storage_block" | "quark:world/crafting/panes/violet_corundum" | "minecraft:polished_blackstone_button" | "create:milling/compat/regions_unexplored/tsubaki" | "farmersdelight:cutting/quartz_block" | "jerotesvillage:debilitated_tablet_use_mortar_and_pestle_craft" | "create:crafting/kinetics/mechanical_piston" | "create:splashing/oreganized/crushed_raw_silver" | "biomancy:crafting/primordial_bio_lantern" | "biomancy:decomposing/elastic_tendon" | "create:limestone_from_stone_types_limestone_stonecutting" | "create:milling/compat/ae2/fluix_crystal" | "minecraft:lime_stained_glass_pane_from_glass_pane" | "jerotesvillage:cooked_lake_loach" | "minecraft:magenta_glazed_terracotta" | "farmersdelight:cutting/leather_chestplate" | "quark:building/crafting/spruce_leaf_carpet" | "biomancy:digesting/nutrient_paste_from_crimson_fungus" | "prefab:lanterns_from_string_of_lanterns" | "farmersdelight:bacon_sandwich" | "quark:building/stonecutting/vertslabs/blue_nether_bricks_vertical_slab_stonecutter" | "minecraft:wooden_shovel" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_stairs" | "biomancy:bio_forging/bio_lab" | "biomancy:decomposing/prismarine_shard" | "quark:world/crafting/woodsets/blossom/trapped_chest" | "create:crafting/kinetics/fluid_pipe" | "jerotesvillage:qoaiku_helmet_craft" | "jerotesvillage:scaly_bear_leggings_smith" | "art_of_forging:vobrivium_ingot" | "minecraft:bamboo_trapdoor" | "create:cutting/compat/biomesoplenty/dead_log" | "biomancy:decomposing/ancient_sapling" | "create:deploying/waxed_copper_block_from_adding_wax" | "create:item_application/railway_casing" | "farmersdelight:lead_from_straw" | "minecraft:waxed_copper_block_from_honeycomb" | "born_in_chaos_v1:frostbitten_blade_craft" | "prefab:compressed_glowstone_from_glowstone" | "create:copper_bars_from_ingots_copper_stonecutting" | "minecraft:warped_fungus_on_a_stick" | "create:cutting/compat/byg/zelkova_wood" | "constructionwand:iron_wand" | "jerotesvillage:black_yellow_pressure_plate_craft" | "meed:blue_skies/deadly_venom" | "ftbquests:book" | "create:pressing/aether_dirt_path_from_grass" | "quark:building/crafting/compressed/bonded_rabbit_hide" | "create:cutting/compat/atmospheric/aspen_log" | "minecraft:gold_ingot_from_smelting_raw_gold" | "sophisticatedbackpacks:smithing_upgrade" | "quark:building/stonecutting/stairs/light_gray_shingles_stairs_stonecutter2" | "minecraft:spruce_hanging_sign" | "quark:building/crafting/vertslabs/stone_vertical_slab_revert" | "jerotesvillage:hag_replacement/minecraft_rabbit_foot" | "quark:building/stonecutting/cobblestone_bricks_stonecutter" | "cataclysm:stonecutting/blackstone_pillar_from_stonecutting" | "create:small_dripstone_brick_stairs" | "create:cutting/compat/regions_unexplored/pine_wood" | "farmersdelight:cyan_canvas_sign" | "minecraft:cooked_cod_from_smoking" | "quark:tweaks/crafting/utility/misc/repeater" | "jerotesvillage:villager_block_beekeeper_craft" | "farmersdelight:gold_nugget_from_blasting_knife" | "quark:oddities/crafting/tiny_potato_no_heart" | "quark:building/stonecutting/stonevariants/shale_bricks_stairs_rough_stonecutting" | "biomancy:decomposing/horn_coral" | "sophisticatedbackpacks:anvil_upgrade" | "legendary_monsters:ancient_dripstone_bricks" | "refinedstorage:coloring_recipes/gray_security_manager" | "quark:building/crafting/birch_bookshelf" | "farmersdelight:cutting/mangrove_wood" | "biomancy:decomposing/baby_permeable_membrane_pane" | "create:crafting/kinetics/basin" | "create:crushing/compat/byg/blue_nether_quartz_ore" | "quark:tweaks/crafting/utility/chest_boat/direct_blossom_chest_boat" | "create:cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "create:polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "quark:building/crafting/stone_brick_lamp" | "minecraft:copper_ingot" | "create:cut_veridium_brick_stairs" | "cataclysm:polished_obsidian_slab" | "minecraft:waxed_weathered_cut_copper_slab" | "minecraft:white_dye_from_lily_of_the_valley" | "quark:tools/crafting/seed_pouch" | "create:crushing/compat/byg/brimstone_nether_quartz_ore" | "minecraft:pink_dye_from_pink_petals" | "refinedstorage:coloring_recipes/orange_pattern_grid" | "create:haunting/glow_ink_sac" | "minecraft:end_stone_brick_wall" | "biomancy:special_crafting/primordial_cradle" | "jerotesvillage:meror_metal_ore_blast" | "quark:building/stonecutting/magenta_shingles_stonecutter2" | "cataclysm:purpur_tile_slab" | "biomancy:decomposing/tetra_dragon_sinew" | "quark:world/crafting/woodsets/blossom/ladder" | "jerotesvillage:cooked_second_round_nigrum_from_campfire_cooking" | "pasterdream:smithing_6" | "create:cut_tuff_slab_from_stone_types_tuff_stonecutting" | "pasterdream:smithing_7" | "pasterdream:smithing_4" | "pasterdream:smithing_5" | "create:milling/compat/regions_unexplored/aster" | "pasterdream:smithing_8" | "quark:building/crafting/vertslabs/smooth_red_sandstone_vertical_slab_revert" | "pasterdream:smithing_9" | "netherexp:stonecutting/from_basalt/polished_basalt_brick_stairs" | "pasterdream:smithing_2" | "create:cutting/compat/byg/rainbow_eucalyptus_wood" | "pasterdream:smithing_3" | "pasterdream:smithing_1" | "meed:soulsweapons/ghostly" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "minecraft:netherite_chestplate_smithing" | "create:polished_cut_calcite_wall" | "cataclysm:netherite_effigy" | "create:milling/compat/byg/guzmania" | "minecraft:oak_sign" | "create:milling/compat/botania/black_petal" | "create:milling/compat/byg/blue_sage" | "quark:building/stonecutting/vertslabs/polished_limestone_vertical_slab_stonecutter2" | "jerotesvillage:vine_throwing_ball_craft" | "biomancy:decomposing/chicken" | "legendary_monsters:ancient_dripstone_brick_stairs_left" | "meed:born_in_chaos_v1/rampant_rampage" | "biomancy:bio_forging/acolyte_armor_chestplate" | "legendary_monsters:wand_of_clouds" | "quark:building/crafting/raw_gold_bricks_revert" | "create:polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "refinedstorage:coloring_recipes/white_crafter" | "create:crafting/kinetics/track_station" | "minecraft:red_sandstone_stairs_from_red_sandstone_stonecutting" | "create:crushing/redstone_ore" | "quark:tools/smithing/rune_smithing_green" | "farmersdelight:cutting/wild_beetroots" | "minecraft:smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "biomancy:decomposing/beetroot" | "create:cutting/compat/botania/livingwood" | "quark:building/crafting/blue_stool" | "quark:world/stonecutting/walls/diorite_bricks_wall_stonecutter" | "minecraft:diamond_from_smelting_diamond_ore" | "create:crushing/aluminum_ore" | "create:crushing/raw_iron" | "jerotesvillage:villager_block_messenger_craft" | "minecraft:shield_decoration" | "create:cutting/compat/tconstruct/stripped_bloodshroom_log" | "minecraft:deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "create:cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "netherexp:smithing/pump_charge_shotgun" | "jerotes:leather_giant_beast_armor_craft" | "create:small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "cataclysm:stonecutting/azure_seastone_brick_wall_from_stonecutting" | "quark:building/crafting/panes/white_framed_glass_pane" | "create:cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "biomancy:digesting/nutrient_paste_from_leaves" | "biomancy:decomposing/nether_wart" | "farmersdelight:cooking/hot_cocoa" | "quark:building/crafting/vertslabs/blue_nether_bricks_vertical_slab_revert" | "create:cutting/compat/biomesoplenty/willow_wood" | "quark:tweaks/smelting/raw_copper_block_smelt" | "refinedstorage:wrench" | "refinedstorage:coloring_recipes/black_security_manager" | "create:small_tuff_bricks_from_stone_types_tuff_stonecutting" | "quark:building/crafting/panes/light_blue_framed_glass_pane" | "waystones:crumbling_attuned_shard" | "minecraft:birch_planks" | "minecraft:polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "create:small_calcite_brick_slab" | "create:cutting/compat/regions_unexplored/stripped_baobab_wood" | "born_in_chaos_v1:smoked_flesh_k" | "cataclysm:azure_seastone_brick_slab" | "minecraft:light_gray_stained_glass_pane" | "prefab:dirt_stairs" | "create:polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "refinedstorage:coloring_recipes/purple_pattern_grid" | "biomancy:crafting/glow_item_frame" | "prefab:glass_slabs" | "create:diorite_pillar_from_stone_types_diorite_stonecutting" | "create:emptying/compat/neapolitan/milk_bottle" | "create:small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "jerotesvillage:carved_brick_slab_from_carved_bricks_stonecutting" | "minecraft:dye_magenta_carpet" | "create:cutting/bamboo_planks" | "quark:building/stonecutting/stonevariants/granite_bricks_wall_polished_stonecutting" | "sophisticatedbackpacks:xp_pump_upgrade" | "create:dripstone_block_from_stone_types_dripstone_stonecutting" | "create:milling/compat/tconstruct/nercotic_bone" | "create:polished_cut_andesite_from_stone_types_andesite_stonecutting" | "prefab:sickle_wood" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "create:scorchia_pillar_from_stone_types_scorchia_stonecutting" | "farmersdelight:cooking/noodle_soup" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "create:cutting/compat/autumnity/stripped_maple_wood" | "lendersdelight:knife/ignitium_knife" | "born_in_chaos_v1:staffofthe_summoner_k" | "refinedstorage:64k_storage_part" | "sophisticatedbackpacks:tank_upgrade" | "create:crushing/compat/silentgems/iolite_ore" | "minecraft:brown_bed" | "refinedstorage:coloring_recipes/lime_wireless_transmitter" | "create:crushing/ochrum_recycling" | "create:cutting/compat/regions_unexplored/stripped_joshua_log" | "refinedstorage:coloring_recipes/relay" | "jerotesvillage:magicka_scale_boots_smith" | "functionalstorage:acacia_1" | "meed:relics/bleeding" | "functionalstorage:acacia_2" | "cataclysm:black_steel_block" | "create:milling/compat/regions_unexplored/orange_snowbelle" | "quark:world/crafting/walls/myalite_bricks_wall" | "functionalstorage:puller_upgrade" | "functionalstorage:acacia_4" | "netherexp:torch_from_fossil_fuel" | "create:crafting/kinetics/hand_crank" | "create:milling/compat/biomesoplenty/burning_blossom" | "create:milling/large_fern" | "create:smelting/ingot_nickel_compat_immersiveengineering" | "jerotesvillage:bright_golden_melon_hammer_craft" | "minecraft:jack_o_lantern" | "quark:building/crafting/slabs/cobblestone_bricks_slab" | "minecraft:tripwire_hook" | "refinedstorage:interface" | "biomancy:stonecutting/primal_flesh_wall_from_primal_flesh" | "create:splashing/brown_concrete_powder" | "minecraft:cut_sandstone_from_sandstone_stonecutting" | "create:cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "cataclysm:stonecutting/polished_obsidian_stairs_from_stonecutting" | "create:mixing/brass_ingot" | "create:cutting/compat/byg/stripped_cypress_wood" | "jerotesvillage:villager_metal_shield_craft" | "quark:world/crafting/waxed_red_corundum" | "quark:building/crafting/duskbound_lantern" | "farmersdelight:cutting/tag_dough" | "cataclysm:ancient_metal_ingot" | "create:crafting/appliances/copper_backtank" | "born_in_chaos_v1:blackargillitecolumnslabk_3" | "jerotesvillage:serpon_alloy_block_craft" | "quark:tools/smithing/rune_smithing_black" | "quark:building/crafting/dark_oak_leaf_carpet" | "create:crafting/kinetics/portable_storage_interface" | "refinedstorage:fluid_grid/gray_fluid_grid" | "create:cutting/compat/atmospheric/rosewood_log" | "jerotesvillage:ablepsia_tablet_use_mortar_and_pestle_craft" | "quark:world/stonecutting/stairs/polished_jasper_stairs_stonecutter" | "create:crafting/materials/andesite_alloy_from_zinc" | "biomancy:decomposing/toxin_gland" | "jerotesvillage:virtual_cave_crystal_throwing_ball_craft" | "biomancy:crafting/porous_primal_flesh_wall" | "quark:building/crafting/vertslabs/dripstone_bricks_vertical_slab_revert" | "quark:building/stonecutting/vertslabs/mossy_cobblestone_bricks_vertical_slab_stonecutter" | "biomancy:digesting/nutrient_paste_from_fern" | "quark:building/crafting/vertslabs/gray_shingles_vertical_slab" | "netherexp:polished_blackstone_fence" | "create:crafting/appliances/netherite_backtank_from_netherite" | "refinedstorage:coloring_recipes/cyan_security_manager" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "sophisticatedbackpacks:auto_smelting_upgrade" | "refinedstorage:coloring_recipes/cyan_relay" | "quark:building/stonecutting/vertslabs/green_shingles_vertical_slab_stonecutter2" | "create:cutting/compat/twilightforest/stripped_mangrove_log" | "biomancy:decomposing/bubble_coral" | "jerotesvillage:villager_block_bartender_craft" | "netherexp:twisting_polished_blackstone_bricks" | "create:copper_shingles_from_ingots_copper_stonecutting" | "prefab:quartz_crete_stairs_smooth_up_left" | "minecraft:turtle_helmet" | "biomancy:decomposing/verdant_froglight" | "farmersdelight:cutting/mutton" | "biomancy:bio_forging/tendon_chain" | "meed:born_in_chaos_v1/lifesteal" | "legendary_monsters:ancient_dripstone_tiles_stonecutter" | "refinedstorage:coloring_recipes/lime_network_transmitter" | "born_in_chaos_v1:nightmare_scythe_k" | "biomancy:decomposing/rainbow_jelly" | "quark:building/stonecutting/stonevariants/myalite_bricks_polished_stonecutting" | "jerotesvillage:hag_replacement/jerotesvillage_qoaiku_metal_block" | "quark:building/crafting/vertslabs/red_sandstone_bricks_vertical_slab_revert" | "born_in_chaos_v1:creepy_nutcracker_craft" | "create:mixing/compat/regions_unexplored/peat_mud" | "cataclysm:smithing/cursium_leggings" | "quark:building/crafting/vertslabs/light_gray_shingles_vertical_slab" | "minecraft:waxed_oxidized_cut_copper_slab" | "cataclysm:obsidian_bricks" | "jerotesvillage:violent_tablet_craft" | "netherexp:soul_burning_wither_skull_block" | "create:splashing/soul_sand" | "jerotesvillage:smooth_glitter_sandstone_slab_craft" | "quark:building/stonecutting/stonevariants/shale_bricks_wall_polished_stonecutting" | "minecraft:dropper" | "farmersdelight:onion" | "create:crafting/kinetics/piston_extension_pole" | "biomancy:decomposing/warped_fungus" | "create:milling/compat/byg/compat/byg/winter_cyclamen" | "jerotesvillage:bright_melon_seeds_craft" | "farmersdelight:cooking/stuffed_pumpkin_block" | "create:cut_crimsite_wall" | "minecraft:lime_dye_from_smelting" | "create:small_granite_brick_wall" | "create:cut_granite_slab_from_stone_types_granite_stonecutting" | "create:cut_limestone_slab" | "create:crafting/kinetics/brass_hand" | "create:crafting/kinetics/lime_seat" | "minecraft:weathered_cut_copper_stairs" | "biomancy:bio_forging/mob_claw" | "quark:building/crafting/shingles/pink_shingles_dye" | "netherexp:stonecutting/from_stacked_bones/skull_block" | "jerotes:gold_nugget_from_other_smelt" | "farmersdelight:cutting/spruce_door" | "meed:bloodandmadness/chikage" | "quark:building/crafting/acacia_bookshelf" | "create:cutting/compat/upgrade_aquatic/river_log" | "quark:building/stonecutting/stonevariants/shale_bricks_stonecutter" | "create:layered_dripstone_from_stone_types_dripstone_stonecutting" | "create:crafting/kinetics/green_seat" | "jerotesvillage:serpon_powerhouse_leggings_smith" | "create:milling/sugar_cane" | "refinedstorage:coloring_recipes/green_network_transmitter" | "biomancy:decomposing/raw_catfish" | "refinedstorage:coloring_recipes/orange_network_receiver" | "create:cutting/compat/regions_unexplored/stripped_pine_wood" | "quark:building/stonecutting/stonevariants/granite_bricks_stonecutter" | "farmersdelight:cooking/mushroom_stew" | "biomancy:decomposing/mimicream" | "create:smelting/tin_ingot_compat_thermal" | "minecraft:pink_bed" | "minecraft:shield" | "quark:building/stonecutting/slabs/pink_shingles_slab_stonecutter" | "minecraft:blackstone_slab" | "minecraft:dye_light_blue_carpet" | "quark:tools/smithing/rune_smithing_blank" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "biomancy:stonecutting/porous_primal_flesh_stairs_from_porous_primal_flesh" | "prefab:triple_compressed_stone_to_double_compressed_stone" | "born_in_chaos_v1:creepy_snowman_head_craft" | "jerotesvillage:bitter_cold_fence_gate_craft" | "create:small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "minecraft:cooked_rabbit_from_smoking" | "biomancy:decomposing/rocky_shell" | "jerotesvillage:wonderland_chest_boat_craft" | "quark:building/crafting/shingles/yellow_shingles" | "create:cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:quartz_bricks" | "quark:building/crafting/vertslabs/rusty_iron_plate_vertical_slab_revert" | "minecraft:map_cloning" | "quark:world/crafting/woodsets/azalea/button" | "minecraft:red_sandstone_wall" | "refinedstorage:upgrade" | "cataclysm:stonecutting/chiseled_azure_seastone_pillar_from_stonecutting" | "refinedstorage:coloring_recipes/yellow_disk_manipulator" | "refinedstorage:4k_storage_disk_from_storage_housing" | "create:crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "quark:building/crafting/vertslabs/smooth_quartz_vertical_slab_revert" | "lendersdelight:slice/cooked_amethyst_crab_meat_slice" | "create:cut_deepslate_brick_slab_recycling" | "quark:world/stonecutting/slabs/polished_calcite_slab_stonecutter" | "minecraft:acacia_stairs" | "farmersdelight:cutting/bamboo_door" | "waystones:warp_plate" | "easy_villagers:iron_farm" | "minecraft:iron_nugget_from_smelting" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "quark:building/crafting/lamps/violet_crystal_lamp" | "quark:world/crafting/slabs/polished_jasper_slab" | "tetra:architects_crucible_scroll" | "quark:building/crafting/stairs/iron_plate_stairs" | "quark:building/stonecutting/purple_shingles_stonecutter2" | "jerotesvillage:cooked_greyscale_from_campfire_cooking" | "create:polished_cut_granite_stairs" | "art_of_forging:resonant_alloy" | "quark:world/crafting/walls/diorite_bricks_wall" | "farmersdelight:white_hanging_canvas_sign" | "netherexp:stacked_wither_bone_slab" | "create:cutting/compat/nethers_exoticism/ramboutan_wood" | "itemfilters:xor" | "waystones:blackstone_waystone" | "legendary_monsters:ancient_dripstone_brick_slab_stonecutter_adp" | "minecraft:chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "quark:building/crafting/green_stool" | "prefab:dirt_wall" | "jerotesvillage:bitter_cold_fat_candle_craft" | "quark:building/stonecutting/vertslabs/granite_vertical_slab_stonecutter" | "sophisticatedbackpacks:pickup_upgrade" | "quark:building/stonecutting/stairs/midori_block_stairs_stonecutter" | "refinedstorage:coloring_recipes/red_security_manager" | "jerotesvillage:explorer_iron_chestplate_smith" | "minecraft:birch_fence_gate" | "minecraft:bone_meal" | "quark:building/stonecutting/stairs/soul_sandstone_stairs_stonecutter" | "jerotesvillage:second_round_aloe_leaf_by_bundle_craft" | "jerotesvillage:ocean_gemstonein_craft" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "create:mixing/andesite_alloy_from_zinc" | "prefab:quartz_crete_bricks" | "quark:building/crafting/vertslabs/permafrost_vertical_slab" | "create:pressing/compat/vampirism/cursed_earth_path" | "biomancy:bio_forging/fibrous_flesh" | "jerotesvillage:cut_purple_sandstone_from_purple_sandstone_stonecutting" | "meed:block_factorys_bosses/poison" | "create:small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "sophisticatedbackpacks:auto_smoking_upgrade" | "prefab:boundary_block" | "create:cutting/compat/twilightforest/mangrove_wood" | "create:cutting/compat/byg/nightshade_wood" | "create:cut_andesite_brick_slab" | "minecraft:mud_brick_wall" | "create:cut_deepslate_from_stone_types_deepslate_stonecutting" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "netherexp:claret_button" | "create:cutting/compat/forbidden_arcanus/aurum_wood" | "farmersdelight:integration/create/milling/wild_cabbages" | "quark:building/stonecutting/slabs/blue_nether_bricks_slab_stonecutter" | "create:cutting/stripped_crimson_stem" | "biofactory:compacting/malignant_flesh_block_from_veins" | "create:crafting/kinetics/purple_seat_from_other_seat" | "quark:building/crafting/sandstone_bricks" | "quark:building/crafting/vertslabs/cut_copper_vertical_slab_revert" | "create:cutting/compat/botania/glimmering_stripped_livingwood" | "jerotesvillage:qoaiku_giant_beast_armor_craft" | "create:cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "create:cutting/compat/byg/stripped_jacaranda_log" | "netherexp:ancient_torch" | "minecraft:redstone_block" | "born_in_chaos_v1:dark_metalngot_k" | "jerotesvillage:ancient_second_rounder_noble_chestplate_smith" | "netherexp:stonecutting/from_soul_slate/soul_slate_wall" | "refinedstorage:fortune_3_upgrade" | "jerotesvillage:hag_replacement/jerotesvillage_hag_eye" | "quark:world/stonecutting/stairs/diorite_bricks_stairs_stonecutter" | "minecraft:honeycomb_block" | "create:crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "biomancy:bio_forging/baby_permeable_membrane" | "biomancy:digesting/nutrient_paste_from_mushroom_stem" | "jerotesvillage:glass_throwing_ball_craft" | "minecraft:andesite_stairs_from_andesite_stonecutting" | "quark:building/crafting/slabs/orange_shingles_slab" | "create:blasting/gold_ingot_from_crushed" | "farmersdelight:cake_from_milk_bottle" | "biomancy:decomposing/turtle_helmet" | "create:vertical_framed_glass_from_glass_colorless_stonecutting" | "create:cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "minecraft:dye_pink_bed" | "biomancy:bio_forging/flesh_iris_door" | "create:crafting/kinetics/goggles" | "create:mixing/chocolate" | "create:crafting/materials/electron_tube" | "farmersdelight:wheat_dough_from_water" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "protection_pixel:hunterasloot" | "create:milling/compat/regions_unexplored/alpha_rose" | "lendersdelight:knife/witherite_knife" | "biomancy:digesting/nutrient_paste_from_pewen_pines" | "create:filling/compat/regions_unexplored/peat_grass_block" | "legendary_monsters:chiseled_ancient_dripstone_bricks" | "jerotesvillage:glitter_sandstone_craft" | "quark:building/crafting/vertslabs/duskbound_block_vertical_slab_revert" | "born_in_chaos_v1:argillite_lamp_k" | "cataclysm:stonecutting/purpur_wall_from_stonecutting" | "biomancy:decomposing/carrot" | "quark:tweaks/crafting/pink_glass" | "biomancy:decomposing/spider_eye" | "quark:building/stonecutting/stonevariants/diorite_bricks_stonecutter" | "create:cutting/compat/regions_unexplored/silver_birch_wood" | "prefab:farm_advanced" | "quark:building/crafting/duskbound_block_without_myalite" | "quark:building/crafting/shingles/gray_shingles_dye" | "create:splashing/wool" | "quark:building/crafting/vertslabs/cobblestone_vertical_slab_revert" | "create:cutting/compat/ars_nouveau/blue_archwood_wood" | "jerotesvillage:bitter_cold_slab_craft" | "waystones:deepslate_waystone" | "create:cut_granite_stairs" | "minecraft:dye_cyan_carpet" | "quark:building/crafting/furnaces/blackstone_blast_furnace" | "create:cut_scoria_brick_slab" | "create:smelting/glass_pane_from_horizontal_framed_glass_pane" | "create:cutting/compat/biomesoplenty/stripped_dead_log" | "quark:tweaks/crafting/purple_glass" | "quark:tweaks/crafting/utility/wool/pink_wool" | "create:blasting/ingot_uranium_compat_immersiveengineering" | "quark:tweaks/crafting/utility/chests/mangrove_chest_wood" | "create:filling/redstone" | "biomancy:decomposing/centipede_leg" | "biomancy:digesting/nutrient_paste_from_flytrap" | "create:cutting/compat/environmental/wisteria_wood" | "minecraft:oxidized_cut_copper_stairs" | "create:cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "jeed:compat/overencumbering" | "biomancy:decomposing/dinosaur_chop" | "minecraft:mangrove_trapdoor" | "biomancy:crafting/baby_permeable_membrane_from_baby_permeable_membrane_pane" | "create:cutting/compat/integrateddynamics/menril_log_stripped" | "minecraft:diamond_boots" | "quark:building/crafting/furnaces/blackstone_furnace" | "sophisticatedbackpacks:stack_upgrade_tier_4" | "refinedstorage:fluid_grid/purple_fluid_grid" | "minecraft:mangrove_hanging_sign" | "refinedstorage:coloring_recipes/white_security_manager" | "refinedstorage:raw_advanced_processor" | "minecraft:stick" | "jerotesvillage:villager_block_coachman_craft" | "quark:world/crafting/stairs/limestone_stairs" | "netherexp:stacked_bone_stairs" | "create:cut_limestone_slab_recycling" | "biomancy:digesting/nutrient_paste_from_thornwood_branch" | "farmersdelight:cooking/glow_berry_custard" | "create:crafting/kinetics/red_seat" | "create:deploying/waxed_copper_shingle_slab_from_adding_wax" | "minecraft:emerald_from_blasting_emerald_ore" | "minecraft:polished_blackstone_brick_wall" | "lendersdelight:crystallized_coral_roll" | "quark:building/stonecutting/vertslabs/myalite_bricks_vertical_slab_stonecutter" | "quark:tools/smithing/rune_smithing_blue" | "create:crafting/kinetics/track_observer_from_other_plates" | "create:cutting/compat/regions_unexplored/joshua_log" | "minecraft:dried_kelp_from_campfire_cooking" | "quark:building/crafting/vertslabs/calcite_bricks_vertical_slab_revert" | "jerotesvillage:villager_block_magician_craft" | "quark:building/stonecutting/vertslabs/deepslate_tile_vertical_slab_from_deepslate_bricks" | "create:cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "jerotesvillage:carved_leader_leggings_smith" | "quark:building/stonecutting/stonevariants/calcite_bricks_wall_polished_stonecutting" | "jerotesvillage:bright_cobblestone_stairs_from_bright_cobblestone_stonecutting" | "create:cutting/stripped_mangrove_log" | "quark:building/crafting/lamps/yellow_corundum_lamp" | "create:polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "create:pressing/gold_ingot" | "quark:building/stonecutting/vertslabs/raw_iron_bricks_vertical_slab_stonecutter" | "create:milling/compat/ae2/ender_pearl" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:crafting/kinetics/light_gray_seat_from_other_seat" | "jerotesvillage:villager_metal_hoe_craft" | "refinedstorage:coloring_recipes/gray_relay" | "jerotesvillage:cooked_meganose_snow_lizard_meat" | "jerotesvillage:meror_metal_ingot_craft" | "sophisticatedbackpacks:stack_upgrade_tier_2" | "sophisticatedbackpacks:stack_upgrade_tier_3" | "farmersdelight:cutting/chocolate_pie" | "sophisticatedbackpacks:stack_upgrade_tier_1" | "create:cutting/compat/regions_unexplored/palm_wood" | "farmersdelight:green_hanging_canvas_sign" | "biomancy:decomposing/redstone" | "meed:spore" | "jerotesvillage:purple_sandstone_craft" | "lendersdelight:knife/ancient_knife" | "farmersdelight:horse_feed" | "quark:building/crafting/shingles/red_shingles_dye" | "prefab:pile_of_bricks_from_bricks" | "create:pressing/peat_dirt_path" | "biomancy:digesting/nutrient_paste_from_subterranodon_egg" | "quark:world/crafting/panes/indigo_corundum" | "biomancy:bio_forging/baby_permeable_membrane_pane" | "refinedstorage:raw_improved_processor" | "quark:building/crafting/shingles/orange_shingles_dye" | "refinedstorage:coloring_recipes/brown_fluid_grid" | "quark:building/crafting/vertslabs/magenta_shingles_vertical_slab" | "minecraft:brown_stained_glass_pane" | "minecraft:black_terracotta" | "prefab:beets_from_bunch" | "quark:building/crafting/shingles/orange_shingles" | "jerotesvillage:gold_nugget_from_bright_golden_melon_hammer_smelt" | "farmersdelight:cutting/pink_tulip" | "create:splashing/endergetic/petrified_overworld_corrock" | "minecraft:white_bed" | "quark:building/stonecutting/slabs/mossy_cobblestone_bricks_slab_stonecutter" | "create:crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:spruce_slab" | "biomancy:decomposing/glow_ink_sac" | "jerotesvillage:villager_block_physician_craft" | "refinedstorage:coloring_recipes/pattern_grid" | "minecraft:cobblestone_slab_from_cobblestone_stonecutting" | "minecraft:mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "minecraft:yellow_carpet" | "create:compacting/andesite_from_flint" | "quark:building/stonecutting/stonevariants/limestone_bricks_polished_stonecutting" | "quark:building/crafting/stairs/soul_sandstone_bricks_stairs" | "art_of_forging:rending_scissor_complete" | "quark:building/crafting/lamps/green_crystal_lamp" | "quark:building/crafting/slabs/magenta_shingles_slab" | "quark:tools/smithing/rune_smithing_lime" | "quark:world/crafting/walls/limestone_bricks_wall" | "create:cut_dripstone_from_stone_types_dripstone_stonecutting" | "tetra:chainmail_helmet" | "minecraft:pumpkin_pie" | "create:crushing/compat/exnihilosequentia/dust" | "jerotesvillage:drought_fire_brick_slab_craft" | "create:cutting/stripped_cherry_wood" | "tetra:earthpiercer" | "netherexp:smooth_netherrack_slab" | "create:cut_ochrum_stairs" | "jerotesvillage:villager_metal_war_beast_armor_craft" | "quark:building/crafting/chests/trapped_chest_revert" | "quark:building/smelting/smooth_soul_sandstone" | "minecraft:deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "jeed:darkness" | "minecraft:polished_granite" | "jerotesvillage:purple_sandstone_stairs_from_purple_sandstone_stonecutting" | "refinedstorage:coloring_recipes/black_network_receiver" | "quark:tweaks/crafting/utility/misc/dispenser_bow" | "waystones:blue_sharestone" | "sophisticatedbackpacks:chipped/tinkering_table_upgrade" | "quark:building/stonecutting/red_sandstone_bricks_cut_stonecutter" | "minecraft:soul_campfire" | "create:crushing/deepslate_diamond_ore" | "legendary_monsters:dinosaur_bone_meal" | "lendersdelight:crystallized_coral_potato" | "prefab:sickle_stone" | "netherexp:blue_nether_brick_slab" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "create:cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "farmersdelight:cutting/acacia_wood" | "jerotesvillage:glaive_of_serpent_dominater_smith" | "jerotesvillage:bright_melon_craft" | "netherexp:wither_skull_block" | "quark:building/stonecutting/soul_sandstone_bricks_stonecutter" | "netherexp:magma_cream_block" | "farmersdelight:cooking/beef_stew" | "biomancy:bio_forging/bio_forge" | "meed:soulsweapons/bloodthirsty" | "quark:building/crafting/slabs/calcite_bricks_slab" | "refinedstorage:coloring_recipes/gray_pattern_grid" | "quark:building/crafting/compressed/nether_wart_sack_uncompress" | "netherexp:valor_armor_trim_smithing_template" | "refinedstorage:coloring_recipes/pink_detector" | "create:small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "jerotesvillage:wonderland_planks_craft" | "biomancy:bio_forging/ornate_flesh_slab" | "minecraft:crimson_fence_gate" | "jerotesvillage:qoaiku_boots_craft" | "create:polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "create:polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "refinedstorage:1024k_fluid_storage_block" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "quark:building/crafting/vertslabs/birch_vertical_slab_revert" | "create:crafting/kinetics/minecart_from_contraption_cart" | "jerotesvillage:rambler_leather_chestplate_craft" | "minecraft:rib_armor_trim_smithing_template" | "quark:building/crafting/panes/brown_framed_glass_pane" | "minecraft:cooked_chicken_from_campfire_cooking" | "create:emptying/compat/farmersdelight/milk_bottle" | "quark:building/crafting/chests/jungle_trapped_chest" | "create:crafting/kinetics/radial_chassis" | "create:small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "prefab:potatoes_from_bunch" | "create:brass_bars_from_ingots_brass_stonecutting" | "biomancy:decomposing/glistering_melon_slice" | "biomancy:special_crafting/biometric_membrane" | "jerotesvillage:dye_from_brown_mud_thorn" | "netherexp:soul_slate_tiles" | "biomancy:bio_forging/fertilizer" | "legendary_monsters:ancient_dripstone_bricks_stonecutter" | "quark:building/stonecutting/vertslabs/polished_shale_vertical_slab_stonecutter" | "create:cutting/compat/quark/blossom_log" | "quark:building/crafting/light_gray_stool" | "quark:building/stonecutting/vertslabs/quartz_vertical_slab_stonecutter" | "quark:world/crafting/waxed_blue_corundum" | "quark:building/crafting/black_stool" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "sophisticatedbackpacks:stack_upgrade_omega_tier" | "itemfilters:or" | "protection_pixel:oxyloot" | "create:cutting/compat/forbidden_arcanus/aurum_log" | "lendersdelight:knife/black_steel_knife" | "minecraft:deepslate_tiles_from_cobbled_deepslate_stonecutting" | "quark:building/stonecutting/slabs/tuff_bricks_slab_stonecutter" | "jerotesvillage:rambler_leather_leggings_craft" | "farmersdelight:cutting/dandelion" | "create:cutting/compat/biomesoplenty/stripped_willow_log" | "quark:automation/crafting/redstone_randomizer" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:observer" | "born_in_chaos_v1:scorched_wood_k" | "minecraft:polished_deepslate_wall" | "quark:tweaks/crafting/utility/wool/cyan_wool" | "minecraft:cooked_cod_from_campfire_cooking" | "create:cutting/compat/byg/stripped_baobab_log" | "itemfilters:id_regex" | "create:cutting/compat/blue_skies/bluebright_wood" | "biomancy:decomposing/chorus_flower" | "biomancy:decomposing/tarantula_hawk_wing_fragment" | "minecraft:dye_purple_bed" | "quark:building/crafting/vertslabs/dirt_bricks_vertical_slab_revert" | "quark:building/stonecutting/stonevariants/diorite_bricks_wall_rough_stonecutting" | "cataclysm:ancient_metal_nugget" | "create:cutting/compat/endergetic/poise_stem" | "create:milling/bone_meal" | "quark:building/stonecutting/midori_pillar_stonecutter" | "create:mixing/andesite_alloy" | "minecraft:stripped_jungle_wood" | "minecraft:pink_dye_from_peony" | "quark:building/stonecutting/stonevariants/calcite_bricks_wall_rough_stonecutting" | "create:cutting/compat/byg/holly_wood" | "netherexp:cooking/iron_nugget_from_iron_scrap_blasting" | "create:cutting/compat/regions_unexplored/blue_bioshroom_hyphae" | "sophisticatedbackpacks:chipped/botanist_workbench_upgrade" | "create:compacting/chocolate" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_slab" | "minecraft:chiseled_red_sandstone_from_red_sandstone_stonecutting" | "jeed:dolphins_grace" | "quark:building/crafting/slabs/rusty_iron_plate_slab" | "prefab:warehouse_improved" | "create:pressing/compat/infernalexp/crimson_nylium_path" | "quark:world/crafting/slabs/myalite_bricks_slab" | "jerotesvillage:iron_nugget_from_animated_blast" | "create:cutting/compat/regions_unexplored/stripped_kapok_wood" | "minecraft:chiseled_deepslate" | "quark:tweaks/crafting/red_glass" | "biomancy:decomposing/porous_primal_flesh" | "minecraft:soul_torch" | "create:crushing/gilded_blackstone" | "jerotesvillage:dye_from_gemstone_anemone" | "quark:tweaks/crafting/black_glass" | "art_of_forging:firework_rocket_simple_alt" | "functionalstorage:framed" | "create:milling/compat/byg/iris" | "quark:building/crafting/vertslabs/mossy_cobblestone_vertical_slab_revert" | "jerotesvillage:bright_cobblestone_wall_craft" | "create:cut_dripstone_brick_wall" | "quark:building/crafting/walls/netherrack_bricks_wall" | "farmersdelight:rope_from_safety_net" | "netherexp:stonecutting/from_bone_block/stacked_bones" | "biomancy:decomposing/flesh" | "protection_pixel:armorhangerloot" | "minecraft:warped_fence_gate" | "create:crushing/compat/elementaryores/ore_ghast_nether" | "jerotesvillage:villager_metal_ingot_smith" | "create:cut_tuff_wall" | "quark:tools/crafting/rune_duplication" | "create:crafting/kinetics/super_glue" | "create:cutting/compat/architects_palette/twisted_wood" | "create:cutting/compat/goodending/cypress_log" | "born_in_chaos_v1:scarlet_stained_glass_k" | "quark:world/crafting/woodsets/ancient/boat" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "quark:building/stonecutting/vertslabs/mud_brick_vertical_slab_stonecutter" | "biomancy:decomposing/rooted_dirt" | "quark:building/crafting/gray_stool" | "minecraft:gray_dye" | "farmersdelight:cooked_mutton_chops_from_campfire_cooking" | "quark:building/stonecutting/stonevariants/limestone_bricks_stairs_polished_stonecutting" | "create:milling/compat/regions_unexplored/poppy_bush" | "quark:world/crafting/woodsets/azalea/hanging_sign" | "jerotesvillage:hag_replacement/jerotesvillage_ocean_gemstone" | "quark:building/crafting/red_nether_bricks_util" | "minecraft:coal_block" | "farmersdelight:orange_canvas_sign" | "create:cutting/compat/botania/glimmering_dreamwood" | "minecraft:slime_ball" | "create:crafting/kinetics/black_seat_from_other_seat" | "quark:building/crafting/vertslabs/polished_jasper_vertical_slab_revert" | "create:cutting/compat/the_vault/wooden_log" | "refinedstorage:coloring_recipes/lime_network_receiver" | "create:item_application/brass_casing_from_wood" | "refinedstorage:silk_touch_upgrade" | "create:splashing/atmospheric/arid_sand" | "create:cutting/compat/atmospheric/morado_wood" | "create:cutting/compat/byg/stripped_rainbow_eucalyptus_wood" | "farmersdelight:cutting/dark_oak_wood" | "quark:building/crafting/panes/gray_framed_glass_pane" | "jerotesvillage:magicka_scale_chestplate_smith" | "minecraft:emerald_block" | "protection_pixel:slingshotloot" | "biomancy:crafting/primal_flesh_stairs" | "biomancy:decomposing/smooth_primal_flesh_wall" | "create:calcite_from_stone_types_calcite_stonecutting" | "create:cutting/compat/regions_unexplored/larch_wood" | "create:cut_limestone_brick_slab_recycling" | "netherexp:stonecutting/from_soul_slate_tiles/wall" | "farmersdelight:cooking/cooked_rice" | "quark:building/crafting/stairs/blue_nether_bricks_stairs" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:iron_sword" | "jerotesvillage:villager_block_conscription_craft" | "refinedstorage:coloring_recipes/purple_network_receiver" | "create:milling/saddle" | "quark:building/stonecutting/vertslabs/myalite_vertical_slab_stonecutter" | "biomancy:crafting/primal_permeable_membrane_pane_from_primal_permeable_membrane" | "create:splashing/thermal/crushed_raw_tin" | "quark:world/crafting/woodsets/azalea/fence_gate" | "create:splashing/oreganized/crushed_raw_lead" | "born_in_chaos_v1:pumpkin_bullet_k" | "create:small_granite_brick_slab_recycling" | "create:small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "jerotesvillage:slavery_supervisor_helmet_smith" | "jerotesvillage:meror_dagger_craft" | "quark:building/stonecutting/stonevariants/polished_dripstone_stairs_stonecutter2" | "create:cutting/compat/silentgear/netherwood_wood" | "prefab:compressed_dirt_to_dirt" | "create:milling/compat/environmental/magenta_hibiscus" | "farmersdelight:cutting/leather_helmet" | "minecraft:smooth_red_sandstone_slab" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "create:cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "jerotesvillage:deep_dust_block_craft" | "minecraft:bamboo_pressure_plate" | "minecraft:birch_trapdoor" | "quark:building/crafting/vertslabs/soul_sandstone_bricks_vertical_slab" | "minecraft:prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "prefab:pile_of_bricks_to_bricks" | "biomancy:blasting/glass_pane" | "quark:world/crafting/slabs/andesite_bricks_slab" | "quark:building/crafting/glowing_glass_item_frame" | "quark:building/stonecutting/vertslabs/polished_blackstone_vertical_slab_stonecutter2" | "quark:building/crafting/hollowlogs/hollow_azalea_log" | "born_in_chaos_v1:smoldering_scorched_wood_k" | "jerotesvillage:hag_replacement/minecraft_diamond" | "create:crafting/appliances/netherite_backtank" | "create:crafting/kinetics/metal_girder" | "refinedstorage:64k_fluid_storage_part" | "biomancy:crafting/adult_permeable_membrane_pane_from_adult_permeable_membrane" | "cataclysm:void_eye" | "create:crafting/kinetics/millstone" | "create:exposed_copper_shingle_stairs" | "minecraft:conduit" | "functionalstorage:jungle_1" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_brick_wall" | "minecraft:sticky_piston" | "quark:building/stonecutting/vertslabs/deepslate_tile_vertical_slab_from_deepslate_tiles" | "minecraft:blue_glazed_terracotta" | "functionalstorage:jungle_4" | "functionalstorage:jungle_2" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "born_in_chaos_v1:chipped_black_argillite_brick_k_2" | "born_in_chaos_v1:chipped_black_argillite_brick_k_3" | "netherexp:gargoyle_statues/sealed" | "create:milling/compat/botania/magenta_petal" | "create:cut_diorite_brick_stairs" | "create:milling/wool" | "netherexp:wraithing_flesh" | "jerotesvillage:meror_metal_hoe_craft" | "legendary_monsters:ancient_dripstone_tiles" | "refinedstorage:1k_storage_part" | "jerotesvillage:wonderlin_cave_map_craft" | "create:cutting/compat/atmospheric/grimwood" | "quark:building/stonecutting/stonevariants/tuff_bricks_stonecutter" | "minecraft:stripped_oak_wood" | "create:mixing/dough_by_mixing" | "biomancy:decomposing/vesper_wing" | "farmersdelight:beef_patty_from_smoking" | "jerotesvillage:serpon_dagger_craft" | "quark:world/crafting/stairs/jasper_stairs" | "quark:building/stonecutting/vertslabs/smooth_red_sandstone_vertical_slab_stonecutter" | "minecraft:comparator" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "quark:building/stonecutting/vertslabs/polished_blackstone_brick_vertical_slab_stonecutter2" | "quark:building/stonecutting/vertslabs/polished_blackstone_brick_vertical_slab_stonecutter3" | "biomancy:digesting/nutrient_paste_from_seagrass" | "ftbquests:loot_crate_opener" | "quark:building/crafting/vertslabs/polished_calcite_vertical_slab_revert" | "create:exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "quark:oddities/crafting/tiny_potato_heart" | "meed:born_in_chaos_v1/soul_stratification" | "quark:world/crafting/woodsets/ancient/fence" | "jerotesvillage:chiseled_sun_sandstone_from_sun_sandstone_stonecutting" | "quark:building/crafting/compressed/glowberry_sack_uncompress" | "create:cutting/compat/regions_unexplored/stripped_green_bioshroom_hyphae" | "protection_pixel:watertankloot_2" | "quark:building/crafting/panes/orange_framed_glass_pane" | "create:cut_dripstone_wall" | "biomancy:stonecutting/fibrous_flesh_stairs_from_fibrous_flesh" | "quark:building/crafting/mangrove_bookshelf" | "netherexp:stonecutting/polished_blackstone_pillar_from_polished_blackstone" | "minecraft:granite_wall_from_granite_stonecutting" | "refinedstorage:coloring_recipes/blue_crafting_monitor" | "quark:tweaks/crafting/utility/misc/easy_hopper" | "meed:biomancy/libido" | "biomancy:bio_brewing/ageing_serum" | "jerotesvillage:smooth_purple_sandstone_slab_craft" | "create:cutting/compat/byg/mahogany_log" | "prefab:paper_lantern" | "minecraft:cut_red_sandstone" | "jerotesvillage:smooth_sun_sandstone_craft" | "biomancy:digesting/nutrient_paste_from_egg" | "create:crushing/raw_copper" | "create:polished_cut_veridium_slab" | "legendary_monsters:entity_warper" | "quark:building/crafting/vertslabs/limestone_vertical_slab_revert" | "create:small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:crafting/kinetics/vertical_gearbox" | "minecraft:andesite_slab_from_andesite_stonecutting" | "jerotesvillage:serpon_alloy_nugget_from_smelt" | "create:cut_calcite_brick_slab" | "create:smelting/bread" | "biomancy:digesting/nutrient_paste_from_melon" | "farmersdelight:canvas_sign" | "meed:tombstone/prayer" | "jerotesvillage:sediment_moisture_proof_paste_craft" | "create:crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "create:milling/compat/botania/brown_petal" | "create:cut_limestone_brick_stairs" | "quark:building/crafting/vertplanks/vertical_warped_planks" | "create:cutting/compat/regions_unexplored/dead_log" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:bamboo_door" | "quark:building/crafting/vertslabs/cobblestone_vertical_slab" | "tetra:hammer/oak" | "create:item_application/copper_casing_from_log" | "create:crushing/raw_quicksilver_block" | "jerotesvillage:cut_purple_sandstone_slab_from_purple_sandstone_stonecutting" | "create:crushing/raw_quicksilver" | "farmersdelight:integration/create/milling/wild_onions" | "farmersdelight:oak_cabinet" | "quark:tools/smithing/rune_smithing_red" | "farmersdelight:integration/immersiveengineering/crusher/wild_rice" | "minecraft:white_wool_from_string" | "quark:world/stonecutting/slabs/shale_slab_stonecutter" | "netherexp:nether_brick_pillar" | "jerotesvillage:villager_block_builder_craft" | "create:cutting/compat/biomesoplenty/stripped_willow_wood" | "biomancy:bio_forging/fleshkin_chest" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "biomancy:decomposing/pewen_sap" | "quark:world/stonecutting/polished_shale_stonecutter" | "minecraft:white_stained_glass_pane" | "lendersdelight:cook/cooked_berserker" | "create:crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:yellow_dye_from_sunflower" | "quark:building/stonecutting/stonevariants/calcite_bricks_stairs_polished_stonecutting" | "create:milling/compat/byg/purple_amaranth" | "create:crafting/kinetics/windmill_bearing" | "create:small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "refinedstorage:coloring_recipes/light_gray_disk_manipulator" | "farmersdelight:cutting/torchflower" | "quark:world/crafting/panes/yellow_corundum_pane" | "create:cutting/compat/regions_unexplored/socotra_wood" | "minecraft:oak_slab" | "biomancy:crafting/bloomlight" | "biomancy:decomposing/ambergris" | "born_in_chaos_v1:scorched_planks_button_k" | "create:milling/compat/atmospheric/scalding_monkey_brush" | "quark:building/stonecutting/sandstone_bricks_stonecutter" | "jerotesvillage:dye_from_bitter_cold_snow_flower" | "meed:soulsweapons/retribution" | "create:tiled_glass_from_glass_colorless_stonecutting" | "biomancy:bio_forging/full_flesh_door" | "create:milling/sea_pickle" | "minecraft:mangrove_sign" | "farmersdelight:cutting/wild_carrots" | "create:smelting/silver_ingot_compat_thermal" | "quark:building/stonecutting/stairs/brown_shingles_stairs_stonecutter" | "quark:building/crafting/compressed/apple_crate_uncompress" | "quark:building/stonecutting/slabs/light_gray_shingles_slab_stonecutter" | "create:cutting/compat/twilightforest/dark_log" | "create:pressing/iron_ingot" | "create:cut_deepslate_stairs" | "minecraft:yellow_wool" | "quark:building/crafting/vertslabs/soul_sandstone_vertical_slab" | "netherexp:chiseled_quartz_pillar" | "create:cut_ochrum_brick_slab" | "jerotesvillage:hag_replacement/minecraft_milk_bucket" | "jerotesvillage:villager_metal_trapdoor_craft" | "minecraft:dye_brown_carpet" | "minecraft:glass_pane" | "jerotesvillage:scaly_bear_upgrade_smithing_template_craft" | "farmersdelight:netherite_knife_smithing" | "minecraft:clay" | "lendersdelight:cook/cooked_coboleton_meat_from_campfire_cooking" | "farmersdelight:rice_panicle" | "create:crafting/kinetics/mechanical_plough" | "biomancy:crafting/impermeable_membrane_from_impermeable_membrane_pane" | "create:milling/compat/biomesoplenty/violet" | "create:framed_glass_pane" | "chunkloaders:single_to_basic_chunk_loader" | "powerful_dummy:dummy_stand" | "farmersdelight:tatami" | "biomancy:bio_forging/flesh_wall" | "create:crushing/compat/silentgems/ruby_ore" | "create:milling/compat/regions_unexplored/purple_snowbelle" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "quark:building/crafting/midori_pillar" | "refinedstorage:coloring_recipes/brown_controller" | "cataclysm:azure_seastone_brick_stairs" | "cataclysm:stonecutting/polished_obsidian_wall_from_stonecutting" | "biomancy:bio_brewing/cleansing_serum" | "create:crushing/compat/thermal/apatite_ore" | "netherexp:stonecutting/from_stacked_bones/stacked_bone_slab" | "quark:building/crafting/vertslabs/stone_vertical_slab" | "protection_pixel:plagueloot" | "meed:soulsweapons/blight" | "biomancy:decomposing/dead_brain_coral_fan" | "quark:building/crafting/vertslabs/calcite_vertical_slab" | "biomancy:decomposing/rabbit_foot" | "quark:building/stonecutting/stairs/raw_iron_bricks_stairs_stonecutter" | "minecraft:leather_boots" | "create:milling/dandelion" | "quark:building/crafting/stairs/light_gray_shingles_stairs" | "tetra:hammer/diorite" | "farmersdelight:cutting/crimson_door" | "jerotes:diamond_spear_craft" | "netherexp:red_mixed_nether_bricks" | "jerotesvillage:serpon_sword_craft" | "quark:building/stonecutting/stonevariants/chiseled_andesite_bricks_stonecutter" | "jerotesvillage:hag_replacement/jerotesvillage_sun_sand" | "refinedstorage:coloring_recipes/gray_fluid_grid" | "create:crushing/raw_aluminum" | "create:crafting/logistics/andesite_tunnel" | "refinedstorage:1k_storage_disk_from_storage_housing" | "create:splashing/crushed_raw_iron" | "quark:building/crafting/panes/black_framed_glass_pane" | "netherexp:rusty_netherite_grate" | "cataclysm:purpur_void_rune_trap_block" | "biomancy:decomposing/primal_flesh" | "meed:echo" | "quark:building/stonecutting/vertslabs/waxed_oxidized_cut_copper_vertical_slab_from_waxed_oxidized_cut_copper" | "prefab:sickle_diamond" | "legendary_monsters:ancient_dripstone_brick_slab" | "create:milling/compat/upgrade_aquatic/flowering_rush" | "minecraft:baked_potato_from_smoking" | "create:polished_cut_granite_wall" | "biomancy:decomposing/tremorsaurus_egg" | "refinedstorage:fortune_2_upgrade" | "minecraft:dye_black_carpet" | "legendary_monsters:frostbitten_shield" | "quark:building/crafting/glass/yellow_framed_glass" | "netherexp:soul_burning_skull_block" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "farmersdelight:cutting/red_mushroom_colony" | "create:cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "netherexp:cooking/cracked_soul_slate_bricks" | "jerotesvillage:meror_metal_shield_craft" | "farmersdelight:cutting/acacia_log" | "create:cut_asurine_slab_recycling" | "minecraft:magma_block" | "create:cut_limestone_wall_from_stone_types_limestone_stonecutting" | "netherexp:stonecutting/from_stacked_bones/bone_fence" | "quark:tweaks/crafting/utility/wool/magenta_wool" | "create:small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "quark:building/crafting/orange_blossom_leaf_carpet" | "create:cutting/compat/regions_unexplored/stripped_yellow_bioshroom_hyphae" | "minecraft:brush" | "farmersdelight:fried_egg_from_smoking" | "quark:building/crafting/chests/oak_trapped_chest" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "protection_pixel:flarerodloot" | "create:crafting/materials/experience_block" | "jerotesvillage:smooth_purple_sandstone_craft" | "quark:tweaks/crafting/utility/wool/red_wool" | "netherexp:smithing/spirit_armor_trim" | "jerotesvillage:cooked_jewelroamer" | "jerotesvillage:hag_replacement/minecraft_chest" | "biomancy:decomposing/leafcutter_ant_pupa" | "jerotesvillage:glitter_sandstone_stairs_craft" | "create:vertical_framed_glass_pane" | "quark:building/crafting/soul_sandstone_bricks" | "quark:building/stonecutting/slabs/netherrack_bricks_slab_stonecutter" | "minecraft:end_stone_bricks_from_end_stone_stonecutting" | "waystones:light_blue_sharestone" | "biomancy:bio_forging/vial" | "create:milling/ink_sac" | "create:limestone_pillar_from_stone_types_limestone_stonecutting" | "cataclysm:smithing/monstrous_helm" | "refinedstorage:fluid_grid/red_fluid_grid" | "create:haunting/warped_fungus" | "netherexp:banshee_powder" | "create:cutting/compat/byg/blue_enchanted_wood" | "wireless_workbench:wireless_item" | "quark:automation/crafting/crafter" | "protection_pixel:boosterloot" | "create:deploying/waxed_exposed_cut_copper_from_adding_wax" | "create:small_tuff_brick_slab_recycling" | "create:polished_cut_andesite_slab_recycling" | "create:sequenced_assembly/track" | "create:polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "farmersdelight:cooking/bone_broth" | "create:mixing/tea" | "born_in_chaos_v1:nightmare_pantsk" | "legendary_monsters:ancient_dripstone_tile_wall_stonecutter" | "biomancy:crafting/malignant_flesh" | "born_in_chaos_v1:great_dark_crusher_k" | "minecraft:waxed_exposed_cut_copper_slab" | "quark:building/stonecutting/stonevariants/diorite_bricks_polished_stonecutting" | "jerotesvillage:sediment_mud_brick_stairs_craft" | "quark:world/crafting/woodsets/blossom/stripped_wood" | "minecraft:dark_oak_fence" | "create:cut_deepslate_wall" | "biomancy:decomposing/flytrap" | "create:milling/compat/buzzier_bees/white_clover" | "biomancy:decomposing/blood_sac" | "quark:building/crafting/vertslabs/sandstone_vertical_slab_revert" | "farmersdelight:cutting/melon" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "create:polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "biomancy:digesting/nutrient_paste_from_large_fern" | "create:cutting/compat/regions_unexplored/cypress_wood" | "create:cutting/compat/twilightforest/stripped_dark_wood" | "quark:building/stonecutting/vertslabs/orange_shingles_vertical_slab_stonecutter2" | "create:blasting/ingot_tin_compat_mekanism" | "quark:tweaks/blasting/raw_iron_bricks_blast" | "netherexp:polished_basalt_stairs" | "netherexp:discernment_glass" | "born_in_chaos_v1:permafrost_shard_craft" | "jerotesvillage:hag_replacement/jerotesvillage_bright_melon" | "minecraft:blaze_powder" | "minecraft:chain" | "quark:building/stonecutting/stonevariants/granite_bricks_vertical_slab_rough_stonecutting" | "create:cutting/compat/byg/imparius_hyphae" | "quark:building/crafting/stairs/pink_shingles_stairs" | "netherexp:phasmo_arrow" | "minecraft:oak_fence" | "create:polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "create:blasting/lead_ingot_compat_thermal" | "refinedstorage:coloring_recipes/black_relay" | "waystones:brown_sharestone" | "quark:world/stonecutting/stairs/polished_limestone_stairs_stonecutter2" | "quark:building/stonecutting/slabs/rusty_iron_plate_slab_stonecutter" | "create:small_veridium_bricks_from_stone_types_veridium_stonecutting" | "netherexp:stonecutting/from_pale_soul_slate/wall" | "meed:cataclysm/monstrous" | "create:cutting/compat/atmospheric/kousa_wood" | "art_of_forging:forged_pillar" | "legendary_monsters:ancient_dripstone_tile_slab_stonecutter" | "quark:building/stonecutting/walls/blackstone_bricks_wall_stonecutter" | "constructionwand:diamond_wand" | "quark:building/crafting/cherry_post" | "legendary_monsters:chiseled_ancient_dripstone_bricks_dripstone_stonecutter" | "create:cutting/compat/endergetic/stripped_poise_stem" | "legendary_monsters:skeletosaurus_egg" | "create:cut_andesite_brick_slab_recycling" | "create:cut_tuff_stairs" | "create:cutting/compat/regions_unexplored/stripped_cobalt_wood" | "create:cutting/compat/regions_unexplored/brimwood_wood" | "quark:building/stonecutting/vertslabs/cyan_shingles_vertical_slab_stonecutter" | "refinedstorage:fluid_grid/magenta_fluid_grid" | "biomancy:decomposing/crimson_fungus" | "minecraft:deepslate" | "lendersdelight:slice/coral_chunk_red_slice" | "create:haunting/crimson_fungus" | "quark:building/stonecutting/vertslabs/brown_shingles_vertical_slab_stonecutter2" | "protection_pixel:hunterloot" | "quark:building/crafting/glass/brown_framed_glass" | "jerotesvillage:bulge_powder_craft" | "create:cutting/compat/upgrade_aquatic/stripped_driftwood_log" | "functionalstorage:custom_compacting/glowstone" | "biomancy:decomposing/curly_fern" | "biomancy:digesting/nutrient_paste_from_cooked_dinosaur_chop" | "quark:building/crafting/vertslabs/jasper_bricks_vertical_slab" | "biomancy:bio_forging/bone" | "ftbquests:task_screen_configurator" | "create:crafting/logistics/redstone_contact" | "quark:building/stonecutting/walls/sandstone_bricks_wall_stonecutter" | "create:milling/compat/environmental/blue_delphinium" | "minecraft:calibrated_sculk_sensor" | "jerotesvillage:hag_replacement/minecraft_rotten_flesh" | "refinedstorage:coloring_recipes/white_pattern_grid" | "create:cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "quark:building/crafting/iron_plate" | "jerotesvillage:snow_frozen_soil_craft" | "quark:building/crafting/compressed/stick_block_uncompress" | "farmersdelight:skillet" | "jerotesvillage:villager_block_craft" | "chunkloaders:advanced_chunk_loader" | "quark:building/crafting/panes/purple_framed_glass_pane" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "jerotesvillage:bagged_mysterest_petals_craft_leather" | "create:crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "biomancy:decomposing/komodo_spit" | "quark:building/crafting/vertslabs/andesite_vertical_slab" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "minecraft:green_terracotta" | "jerotesvillage:explorer_camp_map_craft" | "create:filling/honey_bottle" | "minecraft:white_stained_glass" | "biomancy:decomposing/grottoceratops_egg" | "biomancy:bio_forging/tongue" | "quark:building/crafting/red_blossom_leaf_carpet" | "create:layered_asurine_from_stone_types_asurine_stonecutting" | "refinedstorage:pattern_grid/white_pattern_grid" | "biomancy:bio_forging/shroomlight" | "refinedstorage:coloring_recipes/crafting_monitor" | "create:cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "quark:tweaks/crafting/utility/chests/spruce_chest_wood" | "quark:tweaks/crafting/utility/chest_boat/direct_jungle_chest_boat" | "meed:born_in_chaos_v1/gaze_of_terror" | "quark:building/stonecutting/walls/raw_iron_bricks_wall_stonecutter" | "minecraft:purpur_stairs" | "biomancy:bio_forging/skeleton_skull" | "quark:building/stonecutting/stonevariants/myalite_bricks_vertical_slab_rough_stonecutting" | "quark:building/smelting/moss_paste" | "quark:building/crafting/warped_ladder" | "functionalstorage:compacting_framed_drawer" | "biomancy:stonecutting/packed_flesh_stairs_from_packed_flesh" | "quark:building/stonecutting/vertslabs/blackstone_vertical_slab_stonecutter" | "functionalstorage:custom_compacting/quartz" | "tetra:hammer/dark_oak" | "itemfilters:always_true_from_others" | "biomancy:decomposing/biometric_membrane" | "create:cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "create:crafting/kinetics/large_cogwheel_from_little" | "create:splashing/immersiveengineering/crushed_raw_lead" | "create:polished_cut_crimsite_slab_recycling" | "biomancy:decomposing/tubular_flesh" | "create:cutting/compat/atmospheric/stripped_aspen_log" | "create:sandpaper_polishing/rose_quartz" | "minecraft:ward_armor_trim_smithing_template" | "biomancy:decomposing/dead_tube_coral_fan" | "sophisticatedbackpacks:auto_blasting_upgrade" | "quark:building/crafting/vertslabs/smooth_sandstone_vertical_slab_revert" | "refinedstorage:coloring_recipes/yellow_security_manager" | "create:crushing/compat/exnihilosequentia/netherrack" | "create:blasting/ingot_nickel_compat_immersiveengineering" | "netherexp:soul_slate_tile_wall" | "jerotesvillage:hag_replacement/minecraft_phantom_membrane" | "netherexp:soul_torch_from_fossil_fuel" | "create:cut_veridium_slab_from_stone_types_veridium_stonecutting" | "minecraft:quartz_from_blasting" | "netherexp:ancient_skeleton_skull_candle" | "create:cutting/compat/biomesoplenty/stripped_redwood_log" | "minecraft:purpur_slab" | "farmersdelight:light_gray_canvas_sign" | "netherexp:stonecutting/from_soul_slate_bricks/stairs" | "biomancy:crafting/smooth_primal_flesh_from_slabs" | "quark:building/stonecutting/stairs/raw_copper_bricks_stairs_stonecutter" | "quark:building/stonecutting/slabs/smooth_soul_sandstone_slab_stonecutter" | "minecraft:chiseled_polished_blackstone_from_blackstone_stonecutting" | "biomancy:bio_forging/acolyte_armor_helmet" | "netherexp:stonecutting/from_blue_nether_bricks/blue_nether_brick_stairs" | "quark:building/crafting/vertslabs/cut_sandstone_vertical_slab" | "minecraft:gold_nugget" | "create:cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "create:small_dripstone_brick_slab" | "refinedstorage:filter" | "quark:building/crafting/stonevariants/myalite_pillar" | "refinedstorage:fluid_grid/white_fluid_grid" | "quark:building/stonecutting/walls/raw_gold_bricks_wall_stonecutter" | "create:crafting/kinetics/stressometerfrom_conversion" | "quark:building/crafting/vertslabs/quartz_vertical_slab_revert" | "minecraft:waxed_oxidized_cut_copper" | "biomancy:decomposing/turtle_egg" | "jerotesvillage:second_round_aloe_leaf_craft" | "sophisticatedbackpacks:stack_upgrade_tier_1_from_starter" | "quark:building/crafting/lamps/indigo_crystal_lamp" | "create:copper_shingle_slab_from_copper_shingles_stonecutting" | "quark:building/crafting/chests/dark_oak_chest" | "create:small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "create:milling/compat/regions_unexplored/yellow_lupine" | "prefab:quartz_crete_smooth" | "quark:tweaks/crafting/utility/chest_boat/direct_cherry_chest_boat" | "quark:building/crafting/walls/mossy_cobblestone_bricks_wall" | "refinedstorage:coloring_recipes/blue_disk_manipulator" | "minecraft:blast_furnace" | "create:cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "minecraft:polished_andesite_stairs" | "netherexp:igneous_reeds_orange_dye" | "refinedstorage:coloring_recipes/black_crafter_manager" | "farmersdelight:cutting/crimson_sign" | "functionalstorage:simple_compacting_drawer" | "quark:tweaks/crafting/utility/misc/chest_minecart" | "biomancy:decomposing/porous_primal_flesh_slab" | "biomancy:decomposing/sea_pickle" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "minecraft:dye_red_bed" | "quark:building/crafting/vertslabs/ancient_planks_vertical_slab_revert" | "create:cutting/compat/regions_unexplored/maple_log" | "born_in_chaos_v1:dark_stained_glass_k" | "farmersdelight:canvas_rug" | "quark:building/stonecutting/vertslabs/raw_copper_bricks_vertical_slab_stonecutter" | "refinedstorage:network_card" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "quark:building/stonecutting/stonevariants/granite_bricks_slab_rough_stonecutting" | "quark:building/crafting/stairs/yellow_shingles_stairs" | "quark:building/crafting/stripped_ancient_post" | "refinedstorage:coloring_recipes/green_crafter" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "create:weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "create:acacia_window" | "quark:building/crafting/vertslabs/crimson_vertical_slab_revert" | "refinedstorage:coloring_recipes/crafting_grid" | "create:cut_veridium_brick_slab" | "create:cut_crimsite_brick_stairs" | "create:cutting/compat/atmospheric/stripped_grimwood" | "legendary_monsters:golden_halbert" | "netherexp:nether_quartz_from_quartz_block" | "create:cutting/compat/byg/stripped_mahogany_log" | "create:cutting/compat/regions_unexplored/stripped_dead_wood" | "minecraft:fletching_table" | "minecraft:dye_lime_bed" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "netherexp:rusty_cut_netherite_slab" | "quark:world/crafting/woodsets/blossom/chest_wood" | "farmersdelight:acacia_cabinet" | "minecraft:mossy_cobblestone_wall" | "biomancy:crafting/diorite_from_stone_powder" | "minecraft:spyglass" | "quark:building/crafting/vertplanks/vertical_blossom_planks" | "create:smelting/glass_from_horizontal_framed_glass" | "minecraft:pink_stained_glass" | "quark:tweaks/crafting/utility/misc/hopper_minecart" | "quark:building/crafting/vertslabs/orange_shingles_vertical_slab" | "jerotesvillage:meror_drill_craft" | "create:milling/compat/byg/delphinium" | "minecraft:oak_chest_boat" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "jerotesvillage:high_strength_string_craft" | "quark:world/crafting/woodsets/ancient/chest_wood" | "create:cut_dripstone_slab_recycling" | "legendary_monsters:chorus_mask" | "create:oxidized_copper_tile_stairs" | "create:cutting/jungle_wood" | "functionalstorage:armory_cabinet" | "netherexp:stonecutting/from_blue_nether_bricks/nether_bricks" | "minecraft:yellow_stained_glass_pane" | "jerotesvillage:villager_block_observer_craft" | "minecraft:diorite_slab_from_diorite_stonecutting" | "quark:tools/smithing/rune_smithing_rainbow" | "jerotesvillage:rambler_leather_boots_craft" | "minecraft:raiser_armor_trim_smithing_template" | "biomancy:stonecutting/ornate_flesh_slab_from_ornate_flesh" | "farmersdelight:white_canvas_sign" | "jerotes:wooden_spear_craft" | "minecraft:bamboo_mosaic_stairs" | "create:deploying/waxed_oxidized_copper_tile_stairs_from_adding_wax" | "netherexp:cut_silica_sandstone_slab" | "create:cutting/compat/twilightforest/sorting_wood" | "quark:world/stonecutting/walls/myalite_bricks_wall_stonecutter" | "netherexp:blue_nether_bricks" | "quark:building/stonecutting/stonevariants/dripstone_bricks_vertical_slab_rough_stonecutting" | "create:crushing/amethyst_cluster" | "tetra:rending_scissor_scroll" | "refinedstorage:16k_storage_part" | "create:polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "minecraft:oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:bread" | "quark:building/crafting/vertplanks/vertical_crimson_planks" | "quark:building/stonecutting/walls/raw_copper_bricks_wall_stonecutter" | "cataclysm:prismarine_brick_fence" | "create:crafting/appliances/copper_diving_helmet" | "jerotesvillage:bitter_cold_pressure_plate_craft" | "born_in_chaos_v1:black_argilite_craft" | "create:cutting/compat/atmospheric/morado_log" | "jerotes:iron_nugget_from_other_smelt" | "minecraft:lever" | "quark:tweaks/crafting/utility/chest_boat/direct_mangrove_chest_boat" | "born_in_chaos_v1:chipped_black_argillite_brick_k" | "create:crushing/deepslate_copper_ore" | "create:blasting/silver_ingot_compat_oreganized" | "minecraft:end_stone_brick_wall_from_end_stone_stonecutting" | "quark:building/crafting/glass/green_framed_glass" | "refinedstorage:coloring_recipes/light_gray_grid" | "protection_pixel:closedloot" | "create:cutting/compat/quark/stripped_blossom_log" | "cataclysm:bone_meal" | "jerotesvillage:meror_standard_leggings_smith" | "cataclysm:smithing/cursium_boots" | "meed:born_in_chaos_v1/intoxication" | "jerotesvillage:villager_metal_base_craft" | "minecraft:bamboo_slab" | "minecraft:dark_oak_chest_boat" | "refinedstorage:raw_basic_processor" | "cataclysm:azure_seastone_wall" | "create:cutting/compat/tconstruct/stripped_greenheart_wood" | "create:filling/compat/alexsmobs/lava_bottle" | "prefab:double_compressed_dirt_to_compressed_dirt" | "minecraft:black_banner" | "refinedstorage:coloring_recipes/yellow_crafter_manager" | "create:cutting/compat/byg/stripped_zelkova_wood" | "minecraft:iron_shovel" | "create:cut_scoria_slab" | "jerotesvillage:villager_metal_base_from_scrap_villager_metal_craft" | "quark:world/stonecutting/slabs/permafrost_bricks_slab_stonecutter" | "minecraft:birch_hanging_sign" | "create:splashing/red_sand" | "quark:tools/smithing/rune_smithing_orange" | "tetra:crucible_scroll" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_brick_stairs" | "farmersdelight:cutting/jungle_log" | "quark:world/crafting/panes/blue_corundum_pane" | "quark:tweaks/crafting/utility/coral/fire_to_red" | "legendary_monsters:chorus_blade" | "quark:tweaks/crafting/clear_glass" | "create:cutting/compat/atmospheric/stripped_kousa_log" | "create:cutting/compat/environmental/willow_wood" | "cataclysm:chorus_stem" | "quark:building/crafting/carved_mud_bricks" | "create:emptying/builders_tea" | "quark:tweaks/crafting/utility/bent/cookie" | "jerotesvillage:wonderland_challenge_craft" | "tetra:holosphere" | "create:calcite_pillar_from_stone_types_calcite_stonecutting" | "create:crushing/deepslate_emerald_ore" | "biomancy:decomposing/flesh_wall" | "minecraft:cooked_chicken" | "jerotesvillage:serpon_watchtower_map" | "cataclysm:void_purpur_tiles" | "minecraft:oak_door" | "quark:building/crafting/vertslabs/sandstone_bricks_vertical_slab_revert" | "create:cutting/compat/byg/ebony_log" | "meed:alexscaves/bubbled" | "quark:building/stonecutting/vertslabs/red_nether_brick_vertical_slab_stonecutter" | "jerotesvillage:high_strength_string_string_craft" | "lendersdelight:cook/deepling_meat_from_campfire_cooking" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "create:cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:cutting/compat/ecologics/walnut_log" | "farmersdelight:beetroot_from_crate" | "meed:biomancy/corrosive" | "jerotesvillage:hag_replacement/minecraft_lingering_potion" | "waystones:return_scroll" | "minecraft:spruce_door" | "create:cutting/stripped_cherry_log" | "jerotesvillage:villager_metal_helmet_craft" | "sophisticatedbackpacks:smelting_upgrade" | "quark:building/crafting/vertslabs/warped_vertical_slab_revert" | "create:crafting/kinetics/propeller" | "create:cutting/compat/biomesoplenty/stripped_palm_wood" | "farmersdelight:cooked_salmon_slice_from_smoking" | "quark:building/crafting/vertslabs/weathered_cut_copper_vertical_slab" | "cataclysm:stonecutting/purpur_tile_slab_from_stonecutting" | "biomancy:decomposing/pitcher_pod" | "quark:building/crafting/shingles/blue_shingles_dye" | "create:milling/compat/byg/black_rose" | "netherexp:blue_nether_brick_stairs" | "cataclysm:chiseled_end_stone_bricks" | "quark:automation/crafting/chute" | "quark:building/stonecutting/walls/tuff_bricks_wall_stonecutter" | "farmersdelight:straw" | "create:cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "minecraft:dark_prismarine" | "meed:mobs_of_sins/paralyzing_sting" | "quark:building/crafting/bamboo_ladder" | "quark:building/stonecutting/vertslabs/red_sandstone_bricks_vertical_slab_stonecutter" | "minecraft:leather_horse_armor" | "quark:building/stonecutting/slabs/sandstone_bricks_slab_stonecutter" | "jerotesvillage:dexterous_tablet_craft" | "netherexp:roasted_bone" | "minecraft:candle" | "quark:world/crafting/slabs/shale_slab" | "quark:building/stonecutting/stairs/blue_nether_bricks_stairs_stonecutter" | "tetra:hammer/birch" | "quark:building/crafting/vertslabs/polished_andesite_vertical_slab_revert" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "farmersdelight:integration/immersiveengineering/crusher/wild_tomatoes" | "biomancy:decomposing/dead_horn_coral" | "minecraft:deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "jerotesvillage:serpent_dominater_armor_trim_smithing_template_craft" | "create:cut_calcite_slab_recycling" | "quark:building/crafting/vertslabs/tuff_bricks_vertical_slab_revert" | "create:cutting/compat/regions_unexplored/stripped_larch_log" | "refinedstorage:coloring_recipes/brown_relay" | "farmersdelight:cutting/cornflower" | "quark:building/crafting/mossy_cobblestone_bricks" | "biomancy:stonecutting/porous_primal_flesh_slab_from_porous_primal_flesh" | "create:cutting/compat/twilightforest/mining_log" | "create:cut_ochrum_slab_recycling" | "cataclysm:azure_seastone_tiles" | "refinedstorage:coloring_recipes/blue_fluid_grid" | "quark:building/crafting/iron_pillar" | "netherexp:ancient_lantern" | "tetra:scythe" | "farmersdelight:cutting/deepslate" | "create:milling/compat/byg/compat/byg/white_sage" | "create:milling/compat/regions_unexplored/magenta_snowbelle" | "netherexp:soul_slate_brick_stairs" | "tetra:kobole" | "quark:building/crafting/vertslabs/granite_vertical_slab_revert" | "cataclysm:purpur_tile_pillar" | "create:cutting/compat/nethers_exoticism/stripped_ramboutan_wood" | "minecraft:jungle_slab" | "quark:building/smelting/cobblestone_to_stone_bricks" | "farmersdelight:cutting/birch_wood" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_pillar" | "create:milling/compat/botania/lime_petal" | "minecraft:skull_banner_pattern" | "quark:building/crafting/chests/birch_chest" | "biomancy:bio_forging/adult_permeable_membrane_pane" | "farmersdelight:shepherds_pie_block" | "quark:building/crafting/compressed/chorus_fruit_block" | "create:blasting/ingot_aluminum_compat_immersiveengineering" | "legendary_monsters:shulker_helmet" | "chunkloaders:basic_chunk_loader" | "quark:tweaks/crafting/brown_glass" | "farmersdelight:cutting/warped_sign" | "create:milling/compat/regions_unexplored/felicia_daisy" | "jerotesvillage:meror_charging_bow_craft" | "quark:building/crafting/cut_soul_sandstone" | "refinedstorage:fluid_grid/blue_fluid_grid" | "quark:building/stonecutting/walls/soul_sandstone_bricks_wall_stonecutter" | "quark:tweaks/crafting/utility/chests/jungle_chest_wood" | "minecraft:granite" | "minecraft:melon_seeds" | "biomancy:decomposing/malignant_flesh_stairs" | "netherexp:warped_wart_block" | "quark:building/stonecutting/vertslabs/gray_shingles_vertical_slab_stonecutter" | "create:cutting/stripped_acacia_wood" | "minecraft:black_dye_from_wither_rose" | "quark:building/stonecutting/stonevariants/dripstone_bricks_wall_rough_stonecutting" | "quark:building/crafting/stairs/polished_dripstone_stairs" | "quark:world/crafting/woodsets/azalea/bookshelf" | "jerotesvillage:drought_fire_brick_slab_from_drought_fire_bricks_stonecutting" | "biomancy:decomposing/glowstone" | "create:haunting/soul_campfire" | "quark:tweaks/crafting/utility/chests/oak_chest_wood" | "refinedstorage:network_receiver" | "farmersdelight:cutting/kelp_roll" | "quark:building/crafting/vertslabs/iron_plate_vertical_slab_revert" | "cataclysm:chiseled_obsidian_bricks" | "quark:building/stonecutting/stonevariants/diorite_bricks_stairs_rough_stonecutting" | "jerotesvillage:hag_replacement/minecraft_fermented_spider_eye" | "minecraft:dye_yellow_carpet" | "quark:world/crafting/woodsets/blossom/door" | "create:cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "minecraft:dye_white_wool" | "create:cutting/compat/byg/fungal_imparius_stem" | "netherexp:skull_block" | "biomancy:stonecutting/packed_flesh_wall_from_packed_flesh" | "create:crafting/kinetics/brown_seat_from_other_seat" | "create:deploying/waxed_exposed_cut_copper_stairs_from_adding_wax" | "quark:building/stonecutting/stonevariants/andesite_bricks_slab_polished_stonecutting" | "quark:building/crafting/flowering_azalea_hedge_oak" | "protection_pixel:hookloot" | "quark:building/stonecutting/stonevariants/limestone_bricks_slab_rough_stonecutting" | "meed:enlightened_end/bouncy" | "quark:building/crafting/compressed/cocoa_beans_sack_uncompress" | "minecraft:packed_ice" | "cataclysm:polished_obsidian_stairs" | "create:crushing/compat/simplefarming/rye" | "quark:building/crafting/walls/soul_sandstone_bricks_wall" | "cataclysm:obsidian_brick_slab" | "minecraft:deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "jerotesvillage:smooth_glitter_sandstone_craft" | "create:crafting/kinetics/copper_door" | "refinedstorage:coloring_recipes/brown_detector" | "create:crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:andesite_bars_from_andesite_alloy_stonecutting" | "create:crushing/compat/exnihilosequentia/granite" | "refinedstorage:coloring_recipes/blue_pattern_grid" | "create:cutting/compat/regions_unexplored/kapok_wood" | "refinedstorage:coloring_recipes/light_gray_crafting_monitor" | "minecraft:cobbled_deepslate_wall" | "create:cutting/compat/tconstruct/greenheart_wood" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "jerotesvillage:deep_dust_craft" | "meed:enlightened_end/rooted" | "quark:building/stonecutting/vertslabs/polished_blackstone_brick_vertical_slab_stonecutter" | "quark:world/crafting/woodsets/ancient/hanging_sign" | "create:polished_cut_limestone_slab_recycling" | "born_in_chaos_v1:rotteninfernalpumpkin_craft" | "quark:building/crafting/glass_item_frame" | "create:cutting/compat/regions_unexplored/stripped_cypress_wood" | "create:polished_cut_crimsite_wall" | "quark:building/crafting/raw_iron_bricks" | "minecraft:smooth_stone" | "quark:building/crafting/vertslabs/spruce_vertical_slab_revert" | "create:cutting/compat/byg/lament_wood" | "lendersdelight:ham_of_berserker" | "quark:building/crafting/stairs/black_shingles_stairs" | "create:mangrove_window_pane" | "quark:building/crafting/slabs/red_shingles_slab" | "minecraft:purple_carpet" | "create:pressing/compat/infernalexp/warped_nylium_path" | "quark:building/crafting/acacia_hedge" | "cataclysm:chorus_stairs" | "minecraft:polished_granite_slab_from_granite_stonecutting" | "refinedstorage:64k_fluid_storage_block" | "biomancy:decomposing/toxic_paste" | "protection_pixel:linkplatechestloot" | "functionalstorage:gold_upgrade" | "netherexp:nether_pizza" | "jerotesvillage:carved_villager_spectral_arrow_craft" | "create:ornate_iron_window" | "quark:building/stonecutting/vertslabs/polished_diorite_vertical_slab_stonecutter" | "minecraft:ender_eye" | "quark:automation/crafting/obsidian_pressure_plate" | "create:crushing/obsidian" | "farmersdelight:apple_pie_from_slices" | "create:cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "minecraft:birch_slab" | "refinedstorage:coloring_recipes/disk_manipulator" | "create:cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "quark:tweaks/crafting/utility/chest_boat/direct_spruce_chest_boat" | "quark:building/stonecutting/stairs/green_shingles_stairs_stonecutter2" | "jerotesvillage:hag_replacement/minecraft_sand" | "create:milling/gravel" | "sophisticatedbackpacks:battery_upgrade" | "cataclysm:stonecutting/chiseled_stone_brick_pillar_from_stonecutting" | "meed:born_in_chaos_v1/infernal_flame" | "create:cutting/compat/byg/stripped_holly_log" | "minecraft:waxed_cut_copper_stairs" | "jerotesvillage:qoaiku_spike_craft" | "minecraft:quartz_bricks_from_quartz_block_stonecutting" | "prefab:double_compressed_quartz_crete_to_compressed_quartz_crete" | "quark:mobs/smoking/cooked_crab_leg" | "biomancy:decomposing/cod" | "refinedstorage:external_storage" | "minecraft:pink_stained_glass_pane_from_glass_pane" | "pasterdream:crafting_119" | "quark:world/crafting/woodsets/ancient/trapped_chest" | "jerotesvillage:serpon_powerhouse_upgrade_smithing_template_craft" | "quark:building/crafting/glass/light_gray_framed_glass" | "pasterdream:crafting_116" | "create:smelting/ingot_uranium_compat_mekanism" | "quark:building/stonecutting/stonevariants/myalite_bricks_wall_rough_stonecutting" | "pasterdream:crafting_115" | "pasterdream:crafting_118" | "pasterdream:crafting_117" | "create:cutting/compat/byg/witch_hazel_wood" | "minecraft:stone_hoe" | "pasterdream:crafting_112" | "create:cut_deepslate_brick_wall" | "pasterdream:crafting_111" | "pasterdream:crafting_114" | "pasterdream:crafting_113" | "pasterdream:crafting_110" | "create:smelting/silver_ingot_compat_iceandfire" | "create:cutting/compat/twilightforest/stripped_transformation_log" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "sophisticatedbackpacks:smoking_upgrade" | "minecraft:cooked_mutton_from_campfire_cooking" | "quark:building/stonecutting/stairs/black_shingles_stairs_stonecutter2" | "minecraft:dye_black_wool" | "create:splashing/ic2/crushed_raw_tin" | "legendary_monsters:ancient_dripstone_tile_stairs_stonecutter_adp" | "jerotesvillage:anesthetized_spear_craft" | "create:blasting/ingot_lead_compat_immersiveengineering" | "pasterdream:crafting_109" | "create:small_scoria_bricks_from_stone_types_scoria_stonecutting" | "pasterdream:crafting_108" | "minecraft:cooked_beef" | "pasterdream:crafting_105" | "pasterdream:crafting_104" | "refinedstorage:fluid_grid/lime_fluid_grid" | "quark:building/stonecutting/vertslabs/cut_red_sandstone_vertical_slab2_stonecutter" | "pasterdream:crafting_107" | "pasterdream:crafting_106" | "pasterdream:crafting_101" | "pasterdream:crafting_100" | "pasterdream:crafting_103" | "biomancy:digesting/nutrient_paste_from_small_flowers" | "pasterdream:crafting_102" | "minecraft:oxidized_cut_copper" | "create:pressing/silt_dirt_path" | "jerotesvillage:giant_monster_boots_craft" | "create:crushing/raw_gold" | "quark:building/crafting/vertslabs/jasper_vertical_slab" | "refinedstorage:fortune_1_upgrade" | "refinedstorage:coloring_recipes/light_gray_controller" | "quark:building/crafting/vertplanks/vertical_spruce_planks_revert" | "create:smelting/ingot_osmium_compat_mekanism" | "minecraft:gold_nugget_from_smelting" | "quark:world/crafting/stairs/blossom_planks_stairs" | "quark:building/stonecutting/stairs/orange_shingles_stairs_stonecutter" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "create:filling/sweet_roll" | "create:milling/compat/atmospheric/yucca_flower" | "waystones:light_gray_sharestone" | "jerotesvillage:villager_metal_leggings_craft" | "quark:building/crafting/slabs/mossy_cobblestone_bricks_slab" | "netherexp:cut_netherite_block" | "quark:building/crafting/vertplanks/vertical_bamboo_planks" | "jerotesvillage:wonderland_fence_gate_craft" | "netherexp:red_dye_from_weeping_helix" | "netherexp:stonecutting/from_basalt/polished_basalt_brick_wall" | "quark:tweaks/crafting/utility/coral/horn_to_yellow" | "quark:building/crafting/walls/calcite_bricks_wall" | "refinedstorage:coloring_recipes/lime_fluid_grid" | "minecraft:mangrove_pressure_plate" | "create:crafting/kinetics/green_seat_from_other_seat" | "jerotesvillage:sun_sand_craft" | "jerotesvillage:wilderness_giant_camp_map_craft" | "biomancy:stonecutting/malignant_flesh_slab_from_malignant_flesh" | "create:cutting/compat/quark/blossom_wood" | "create:cut_veridium_from_stone_types_veridium_stonecutting" | "pasterdream:crafting_159" | "biomancy:bio_forging/mob_fang" | "quark:building/crafting/framed_glass" | "pasterdream:crafting_156" | "netherexp:netherrack_brick_wall" | "create:splashing/lime_concrete_powder" | "pasterdream:crafting_155" | "refinedstorage:fluid_grid/green_fluid_grid" | "farmersdelight:pink_canvas_sign" | "quark:world/stonecutting/slabs/polished_myalite_slab_stonecutter" | "pasterdream:crafting_158" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "pasterdream:crafting_157" | "pasterdream:crafting_152" | "create:cutting/compat/twilightforest/time_log" | "create:small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "pasterdream:crafting_151" | "pasterdream:crafting_154" | "pasterdream:crafting_153" | "create:deploying/waxed_weathered_copper_tiles_from_adding_wax" | "biomancy:decomposing/goat_horn" | "pasterdream:crafting_150" | "cataclysm:mechanical_fusion_anvil" | "create:small_scorchia_brick_slab" | "legendary_monsters:ancient_dripstone_tile_slab" | "create:crushing/emerald_ore" | "cataclysm:smithing/cursium_helmet" | "meed:divine_weaponry/poison_resistance" | "create:cutting/compat/environmental/stripped_willow_log" | "quark:building/stonecutting/slabs/soul_sandstone_slab_stonecutter" | "quark:building/crafting/walls/tuff_bricks_wall" | "pasterdream:crafting_149" | "pasterdream:crafting_148" | "lendersdelight:berserker_stick" | "pasterdream:crafting_145" | "pasterdream:crafting_144" | "pasterdream:crafting_147" | "farmersdelight:cooked_mutton_chops" | "pasterdream:crafting_146" | "quark:building/stonecutting/vertslabs/polished_tuff_vertical_slab2" | "pasterdream:crafting_141" | "pasterdream:crafting_140" | "pasterdream:crafting_143" | "pasterdream:crafting_142" | "netherexp:stonecutting/from_basalt/polished_basalt_slab" | "minecraft:shulker_box_coloring" | "create:cutting/compat/ecologics/stripped_coconut_log" | "create:cutting/compat/byg/stripped_aspen_log" | "create:splashing/white_concrete_powder" | "create:weathered_copper_shingle_stairs" | "quark:building/crafting/vertslabs/oak_vertical_slab_revert" | "create:crafting/logistics/redstone_link" | "minecraft:deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "tetra:quarry_hammer_scroll" | "refinedstorage:256k_fluid_storage_block" | "create:small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "pasterdream:crafting_138" | "create:milling/compat/atmospheric/gilia" | "pasterdream:crafting_137" | "minecraft:enchanting_table" | "minecraft:white_glazed_terracotta" | "pasterdream:crafting_139" | "create:cutting/compat/goodending/stripped_cypress_wood" | "protection_pixel:falconnestasloot" | "pasterdream:crafting_134" | "minecraft:lead" | "farmersdelight:roast_chicken_block" | "pasterdream:crafting_133" | "pasterdream:crafting_136" | "pasterdream:crafting_135" | "pasterdream:crafting_130" | "legendary_monsters:molten_metal_ingot" | "pasterdream:crafting_132" | "refinedstorage:pattern_grid/magenta_pattern_grid" | "refinedstorage:coloring_recipes/pink_disk_manipulator" | "pasterdream:crafting_131" | "create:cut_asurine_from_stone_types_asurine_stonecutting" | "create:cutting/compat/regions_unexplored/stripped_larch_wood" | "meed:enigmaticlegacy/blazing_strength" | "jerotesvillage:drought_fire_brick_wall_craft" | "refinedstorage:coloring_recipes/pink_network_transmitter" | "pasterdream:crafting_127" | "farmersdelight:cooked_chicken_cuts" | "pasterdream:crafting_126" | "minecraft:stripped_spruce_wood" | "minecraft:acacia_wood" | "pasterdream:crafting_129" | "biomancy:decomposing/horn_coral_fan" | "pasterdream:crafting_128" | "tetra:katana_scroll" | "pasterdream:crafting_123" | "pasterdream:crafting_122" | "pasterdream:crafting_125" | "jerotes:diamond_war_beast_armor_craft" | "pasterdream:crafting_124" | "create:dripstone_pillar_from_stone_types_dripstone_stonecutting" | "pasterdream:crafting_121" | "pasterdream:crafting_120" | "create:acacia_window_pane" | "create:cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "quark:building/crafting/shingles/black_shingles_dye" | "sophisticatedbackpacks:chipped/mason_table_upgrade" | "create:cutting/compat/byg/stripped_rainbow_eucalyptus_log" | "jerotesvillage:chiseled_glitter_sandstone_craft" | "quark:building/crafting/walls/cobblestone_bricks_wall" | "quark:building/stonecutting/stonevariants/polished_tuff_stonecutter" | "quark:building/stonecutting/stairs/white_shingles_stairs_stonecutter" | "create:cut_diorite_brick_wall" | "netherexp:soul_slate_tile_stairs" | "farmersdelight:cutting/beef" | "quark:building/crafting/vertslabs/permafrost_bricks_vertical_slab_revert" | "create:sequenced_assembly/precision_mechanism" | "quark:building/crafting/lamps/black_crystal_lamp" | "pasterdream:crafting_199" | "biomancy:crafting/primal_flesh_wall" | "jerotesvillage:smooth_purple_sandstone_slab_from_smooth_purple_sandstone_stonecutting" | "quark:building/crafting/chests/prismarine_chest" | "quark:building/stonecutting/walls/red_sandstone_bricks_wall_stonecutter" | "pasterdream:crafting_196" | "pasterdream:crafting_195" | "pasterdream:crafting_198" | "pasterdream:crafting_197" | "pasterdream:crafting_192" | "pasterdream:crafting_191" | "minecraft:red_wool" | "pasterdream:crafting_194" | "pasterdream:crafting_193" | "farmersdelight:integration/immersiveengineering/cloche/tomato" | "quark:building/stonecutting/sandstone_bricks_cut_stonecutter" | "pasterdream:crafting_190" | "farmersdelight:bread_from_smoking" | "quark:world/crafting/woodsets/blossom/button" | "jerotesvillage:meror_rapier_craft" | "refinedstorage:coloring_recipes/pink_controller" | "biomancy:decomposing/raccoon_tail" | "jerotesvillage:stripped_black_yellow_wood_craft" | "create:cut_scorchia_wall" | "quark:building/crafting/slabs/shingles_slab" | "pasterdream:crafting_189" | "biomancy:digesting/nutrient_paste_from_tremorsaurus_egg" | "pasterdream:crafting_188" | "quark:building/stonecutting/stairs/shingles_stairs_stonecutter" | "create:polished_cut_deepslate_wall" | "pasterdream:crafting_185" | "pasterdream:crafting_184" | "protection_pixel:cannonloot" | "pasterdream:crafting_187" | "quark:building/crafting/stairs/orange_shingles_stairs" | "pasterdream:crafting_186" | "pasterdream:crafting_181" | "netherexp:gargoyle_statues/ghoul" | "pasterdream:crafting_180" | "create:cut_crimsite_slab_recycling" | "pasterdream:crafting_183" | "create:milling/calcite" | "pasterdream:crafting_182" | "biomancy:decomposing/iron_ingot" | "refinedstorage:crafting_grid/red_crafting_grid" | "create:crafting/kinetics/light_gray_seat" | "quark:building/crafting/shingles/lime_shingles_dye" | "quark:tweaks/crafting/utility/coral/brain_to_pink" | "minecraft:magenta_wool" | "refinedstorage:coloring_recipes/gray_grid" | "pasterdream:crafting_178" | "pasterdream:crafting_177" | "biomancy:bio_forging/string" | "pasterdream:crafting_179" | "pasterdream:crafting_174" | "minecraft:waxed_cut_copper_slab" | "pasterdream:crafting_173" | "create:haunting/lapis_recycling" | "pasterdream:crafting_176" | "pasterdream:crafting_175" | "pasterdream:crafting_170" | "pasterdream:crafting_172" | "biomancy:digesting/nutrient_paste_from_tall_flowers" | "quark:world/crafting/walls/jasper_bricks_wall" | "pasterdream:crafting_171" | "quark:building/crafting/stripped_dark_oak_post" | "biomancy:digesting/nutrient_paste_from_pumpkin" | "quark:building/stonecutting/stonevariants/polished_tuff_slab_stonecutter2" | "jerotesvillage:shrapnel_launcher_craft" | "quark:building/stonecutting/stonevariants/myalite_bricks_stairs_rough_stonecutting" | "quark:building/crafting/stairs/dirt_bricks_stairs" | "tetra:rack" | "pasterdream:crafting_167" | "prefab:compressed_quartz_crete_from_quartz_crete" | "pasterdream:crafting_166" | "pasterdream:crafting_169" | "pasterdream:crafting_168" | "pasterdream:crafting_163" | "pasterdream:crafting_162" | "pasterdream:crafting_165" | "pasterdream:crafting_164" | "create:crushing/gravel" | "create:crafting/kinetics/gearbox" | "pasterdream:crafting_161" | "biomancy:crafting/packed_flesh_wall" | "pasterdream:crafting_160" | "minecraft:cyan_dye_from_pitcher_plant" | "create:small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "minecraft:leather_helmet" | "minecraft:light_blue_bed" | "tetra:aptr" | "quark:tweaks/crafting/utility/chest_boat/direct_oak_chest_boat" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_log" | "minecraft:nether_brick_stairs" | "quark:building/crafting/vertslabs/mossy_cobblestone_bricks_vertical_slab" | "cataclysm:stonecutting/chiseled_purpur_block_from_stonecutting" | "minecraft:purple_wool" | "refinedstorage:coloring_recipes/white_disk_manipulator" | "create:cutting/compat/windswept/stripped_chestnut_wood" | "create:deploying/waxed_oxidized_copper_tile_slab_from_adding_wax" | "minecraft:recovery_compass" | "quark:world/crafting/woodsets/blossom/fence_gate" | "minecraft:magenta_bed" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "create:crushing/uranium_ore" | "biomancy:decomposing/lanternfish" | "minecraft:magenta_dye_from_blue_red_white_dye" | "create:deploying/large_cogwheel" | "minecraft:cherry_fence" | "meed:born_in_chaos_v1/furious_rampage" | "quark:building/crafting/vertslabs/acacia_vertical_slab_revert" | "create:cut_granite_brick_slab_recycling" | "quark:building/crafting/stairs/tuff_bricks_stairs" | "cataclysm:chiseled_stone_brick_pillar" | "refinedstorage:coloring_recipes/magenta_security_manager" | "minecraft:pink_terracotta" | "create:crafting/kinetics/black_valve_handle_from_other_valve_handle" | "minecraft:spire_armor_trim_smithing_template_smithing_trim" | "quark:building/crafting/slabs/blue_nether_bricks_slab" | "create:pressing/compat/environmental/podzol_path" | "jerotesvillage:serpon_powerhouse_chestplate_smith" | "quark:world/stonecutting/walls/calcite_wall_stonecutter" | "jeed:fire_resistance" | "create:filling/chocolate_glazed_berries" | "born_in_chaos_v1:phantom_bomb_k" | "create:small_andesite_bricks_from_stone_types_andesite_stonecutting" | "quark:building/stonecutting/vertslabs/light_blue_shingles_vertical_slab_stonecutter" | "functionalstorage:controller_extension" | "sophisticatedbackpacks:advanced_pump_upgrade" | "meed:mobs_of_sins/lingering_pheromones" | "quark:building/stonecutting/stonevariants/dripstone_bricks_stairs_rough_stonecutting" | "biomancy:bio_forging/bio_lantern_yellow" | "quark:building/crafting/paper_lantern" | "refinedstorage:coloring_recipes/brown_security_manager" | "netherexp:burning_wither_skull_block" | "netherexp:ancient_burning_wither_skull_block" | "legendary_monsters:sand_cannon" | "minecraft:prismarine_stairs" | "titanium:test_serializer/saplings_to_sticks" | "jerotesvillage:dye_from_flashing_grass" | "minecraft:white_dye" | "netherexp:stonecutting/from_bone_block/stacked_bone_stairs" | "refinedstorage:crafting_grid/yellow_crafting_grid" | "create:crafting/kinetics/linear_chassisfrom_conversion" | "refinedstorage:pattern_grid/pattern_grid" | "farmersdelight:organic_compost_from_tree_bark" | "quark:world/stonecutting/walls/permafrost_bricks_wall_stonecutter2" | "born_in_chaos_v1:dark_metal_block_k" | "quark:tweaks/crafting/utility/misc/charcoal_to_black_dye" | "quark:building/crafting/vertslabs/smooth_quartz_vertical_slab" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "create:polished_cut_granite_slab" | "create:milling/compat/regions_unexplored/glistering_bloom" | "create:polished_cut_veridium_stairs" | "quark:building/crafting/stairs/smooth_soul_sandstone_stairs" | "create:cutting/compat/byg/skyris_log" | "create:cutting/compat/nethers_exoticism/stripped_jabuticaba_log" | "minecraft:brown_stained_glass" | "quark:building/crafting/vertslabs/midori_block_vertical_slab" | "jerotesvillage:meror_roller_craft" | "jerotesvillage:ice_rock_throwing_ball_craft" | "create:milling/compat/environmental/pink_delphinium" | "born_in_chaos_v1:transformingeastercake_craft" | "quark:building/crafting/vertslabs/end_stone_brick_vertical_slab_revert" | "minecraft:tinted_glass" | "quark:building/crafting/vertslabs/birch_vertical_slab" | "quark:building/crafting/azalea_hedge_oak" | "biomancy:decomposing/ender_eye" | "minecraft:lodestone" | "create:crafting/kinetics/yellow_seat_from_other_seat" | "create:cut_ochrum_from_stone_types_ochrum_stonecutting" | "biomancy:decomposing/pearlescent_froglight" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "refinedstorage:portable_grid" | "jerotesvillage:sun_sandstone_stairs_from_sun_sandstone_stonecutting" | "create:crafting/kinetics/speedometer" | "farmersdelight:potato_from_crate" | "create:granite_from_stone_types_granite_stonecutting" | "minecraft:stone_stairs" | "meed:mobs_of_sins/piercing_eyes" | "biomancy:crafting/porous_primal_flesh_stairs" | "minecraft:dried_kelp_block" | "quark:building/crafting/vertslabs/polished_shale_vertical_slab_revert" | "minecraft:quartz" | "jerotesvillage:giant_monster_horned_helmet_craft" | "netherexp:polished_basalt_wall" | "create:cutting/compat/byg/stripped_ether_wood" | "minecraft:nether_brick_wall" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_wood" | "refinedstorage:coloring_recipes/purple_crafting_grid" | "constructionwand:core_destruction" | "create:deploying/waxed_weathered_copper_shingle_slab_from_adding_wax" | "jerotesvillage:witch_coven_map_craft" | "netherexp:ecto_soul_sand" | "farmersdelight:beef_patty_from_campfire_cooking" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_wall" | "refinedstorage:coloring_recipes/pink_network_receiver" | "meed:netherexp/betrayed" | "create:polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:industrial_iron_block_from_ingots_iron_stonecutting" | "protection_pixel:jetloot" | "quark:building/crafting/vertslabs/green_shingles_vertical_slab_revert" | "meed:soulsweapons/disable_heal" | "biomancy:decomposing/dead_brain_coral" | "sophisticatedbackpacks:upgrade_base" | "biomancy:decomposing/smooth_primal_flesh_slab" | "create:cutting/compat/byg/stripped_jacaranda_wood" | "biomancy:decomposing/malignant_flesh_slab" | "prefab:glass_stairs" | "waystones:pink_sharestone" | "functionalstorage:ender_drawer" | "minecraft:orange_dye_from_orange_tulip" | "cataclysm:stonecutting/polished_end_stone_slab_from_stonecutting" | "biofactory:emptying/nutrients_fluid_bottle" | "jerotesvillage:explorer_boots_smith" | "create:milling/peony" | "cataclysm:polished_azure_seastone_slab" | "create:polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "biomancy:crafting/decomposer" | "biomancy:decomposing/biomesoplenty_hair" | "legendary_monsters:monstrous_anchor" | "meed:born_in_chaos_v1/light_rampage" | "minecraft:blue_carpet" | "cataclysm:stonecutting/polished_obsidian_from_stonecutting" | "create:cutting/compat/byg/rainbow_eucalyptus_log" | "quark:building/stonecutting/vertslabs/white_shingles_vertical_slab_stonecutter" | "born_in_chaos_v1:green_stained_glass_panel_k" | "quark:building/stonecutting/stonevariants/myalite_bricks_wall_polished_stonecutting" | "quark:building/crafting/stairs/mossy_cobblestone_bricks_stairs" | "create:cut_dripstone_brick_slab" | "cataclysm:frosted_stone_brick_stairs" | "quark:building/crafting/oak_post" | "quark:building/crafting/vertplanks/vertical_oak_planks_revert" | "quark:building/crafting/chests/cherry_trapped_chest" | "quark:building/stonecutting/shingles_stonecutter2" | "create:cut_diorite_wall_from_stone_types_diorite_stonecutting" | "farmersdelight:barbecue_stick" | "create:small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "farmersdelight:stuffed_potato" | "jerotesvillage:wonderland_sign_craft" | "quark:world/crafting/woodsets/ancient/pressure_plate" | "refinedstorage:fluid_grid/fluid_grid" | "quark:world/crafting/slabs/permafrost_bricks_slab" | "create:small_diorite_bricks_from_stone_types_diorite_stonecutting" | "quark:oddities/crafting/encased_pipe" | "create:cut_granite_bricks_from_stone_types_granite_stonecutting" | "create:deploying/waxed_weathered_cut_copper_from_adding_wax" | "create:milling/andesite" | "born_in_chaos_v1:blackargillitebrickslk_2" | "farmersdelight:cooking/rabbit_stew" | "netherexp:stonecutting/from_smooth_netherrack/smooth_netherrack_slab" | "jerotesvillage:serpon_spiked_shield_craft" | "minecraft:cooked_chicken_from_smoking" | "quark:world/crafting/woodsets/blossom/bookshelf" | "meed:biomancy/essence_anemia" | "jerotesvillage:meror_metal_stick_refine_craft" | "biomancy:crafting/primordial_core" | "functionalstorage:redstone_upgrade" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "netherexp:cooking/cooked_hogham_from_campfire_cooking" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "jerotesvillage:virtual_cave_insect_net_craft" | "refinedstorage:4096k_fluid_storage_block" | "create:cutting/compat/architects_palette/twisted_log" | "biomancy:decomposing/rabbit" | "prefab:swift_blade_osmium" | "biomancy:decomposing/fire_coral_fan" | "create:crafting/appliances/attribute_filter_clear" | "jerotesvillage:hag_replacement/jerotesvillage_second_round_nigrum" | "minecraft:dripstone_block" | "lendersdelight:void_popsicle" | "minecraft:mangrove_chest_boat" | "minecraft:iron_hoe" | "minecraft:jungle_hanging_sign" | "lendersdelight:slice/maledictus_heart_slice" | "quark:world/stonecutting/slabs/jasper_slab_stonecutter" | "born_in_chaos_v1:black_argillite_pressure_plate_k" | "create:crushing/golden_horse_armor" | "jerotesvillage:serpon_powerhouse_boots_smith" | "create:compacting/blaze_cake" | "quark:building/crafting/thatch" | "netherexp:stonecutting/from_soul_slate_bricks/slab" | "prefab:swift_blade_wood" | "minecraft:jungle_trapdoor" | "refinedstorage:coloring_recipes/blue_network_transmitter" | "jerotesvillage:explorer_helmet_smith" | "jerotesvillage:slavery_supervisor_leggings_smith" | "refinedstorage:4k_storage_disk" | "functionalstorage:diamond_upgrade" | "sophisticatedbackpacks:filter_upgrade" | "cataclysm:stonecutting/polished_azure_seastone_from_stonecutting" | "create:deploying/waxed_exposed_copper_tile_slab_from_adding_wax" | "create:polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "create:cutting/compat/regions_unexplored/blackwood_log" | "minecraft:polished_blackstone_slab_from_polished_blackstone_stonecutting" | "quark:world/crafting/stairs/polished_jasper_stairs" | "create:cutting/compat/regions_unexplored/magnolia_log" | "biomancy:special_crafting/acolyte_armor_helmet" | "create:deploying/waxed_weathered_cut_copper_slab_from_adding_wax" | "biomancy:decomposing/bison_fur" | "quark:tweaks/blasting/raw_copper_bricks_blast" | "minecraft:target" | "biomancy:bio_forging/chiseled_flesh" | "biomancy:decomposing/forge_leather" | "minecraft:orange_carpet" | "quark:building/stonecutting/stonevariants/jasper_bricks_vertical_slab_rough_stonecutting" | "quark:building/crafting/compressed/beetroot_crate_uncompress" | "create:milling/compat/botania/blue_petal" | "born_in_chaos_v1:dark_ritual_dagger_k" | "jeed:hero_of_the_village" | "meed:born_in_chaos_v1/bone_fracture" | "create:campfire_cooking/bread" | "quark:tweaks/crafting/utility/tools/stone_sword" | "create:cutting/compat/quark/azalea_wood" | "create:small_limestone_brick_wall" | "create:cutting/compat/tconstruct/skyroot_log" | "quark:building/crafting/stonevariants/chiseled_calcite_bricks" | "quark:building/crafting/stairs/green_shingles_stairs" | "create:crushing/tuff" | "create:cut_limestone_wall" | "minecraft:mangrove_slab" | "jerotesvillage:qoaiku_pickaxe_craft" | "quark:building/stonecutting/slabs/light_blue_shingles_slab_stonecutter2" | "farmersdelight:cutting/leather_boots" | "create:crushing/compat/thermal/niter_ore" | "quark:building/crafting/lamps/white_crystal_lamp" | "quark:building/stonecutting/vertslabs/cut_soul_sandstone_vertical_slab_stonecutter2" | "born_in_chaos_v1:gnawed_bones_k" | "create:milling/compat/autumnity/autumn_crocus" | "quark:building/crafting/crimson_bookshelf" | "biomancy:digesting/nutrient_paste_from_crimson_roots" | "create:cut_diorite_slab_recycling" | "refinedstorage:coloring_recipes/black_detector" | "cataclysm:stonecutting/azure_seastone_bricks_from_stonecutting" | "create:cutting/compat/blue_skies/stripped_frostbright_log" | "quark:building/crafting/stairs/shingles_stairs" | "create:cutting/compat/twilightforest/stripped_transformation_wood" | "minecraft:chiseled_stone_bricks_stone_from_stonecutting" | "create:milling/rose_bush" | "minecraft:netherite_sword_smithing" | "cataclysm:weapon_infusion/void_forge" | "create:cutting/compat/botania/glimmering_stripped_livingwood_log" | "create:cutting/compat/ecologics/flowering_azalea_wood" | "quark:building/crafting/furnaces/deepslate_blast_furnace" | "cataclysm:monstrous_eye" | "create:crafting/kinetics/mechanical_crafter" | "quark:building/stonecutting/vertslabs/oxidized_cut_copper_vertical_slab_from_oxidized_copper" | "create:blasting/iron_ingot_from_crushed" | "quark:building/crafting/chests/bamboo_trapped_chest" | "farmersdelight:rice_bale" | "create:diorite_from_stone_types_diorite_stonecutting" | "prefab:bunch_of_carrots" | "quark:building/stonecutting/stonevariants/diorite_bricks_stairs_polished_stonecutting" | "quark:building/crafting/oak_bookshelf" | "quark:building/crafting/vertslabs/waxed_cut_copper_vertical_slab_revert" | "jerotesvillage:smooth_sun_sandstone_stairs_craft" | "biomancy:decomposing/shroomlight" | "minecraft:magenta_concrete_powder" | "minecraft:red_dye_from_poppy" | "create:small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "refinedstorage:disk_manipulator" | "netherexp:stonecutting/from_pale_soul_slate/slab" | "cataclysm:black_steel_targe" | "minecraft:light_blue_candle" | "protection_pixel:prismloot" | "quark:building/crafting/spruce_bookshelf" | "quark:building/crafting/vertslabs/blackstone_vertical_slab_revert" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "quark:building/crafting/shingles/brown_shingles_dye" | "biomancy:decomposing/tube_coral" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "born_in_chaos_v1:scorched_planks_stairs_k" | "create:cutting/cherry_log" | "minecraft:mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "quark:world/stonecutting/stairs/myalite_stairs_stonecutter" | "quark:building/stonecutting/stonevariants/limestone_bricks_wall_polished_stonecutting" | "quark:building/crafting/panes/paper_wall_big" | "create:polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "biomancy:decomposing/wither_rose" | "farmersdelight:light_blue_hanging_canvas_sign" | "biomancy:decomposing/dead_tube_coral" | "tetra:hammer/andesite" | "minecraft:stone_bricks_from_stone_stonecutting" | "quark:building/crafting/vertslabs/polished_diorite_vertical_slab_revert" | "quark:tweaks/smelting/raw_copper_bricks_smelt" | "jerotesvillage:chiseled_glitter_sandstone_from_glitter_sandstone_stonecutting" | "create:milling/oxeye_daisy" | "sophisticatedbackpacks:magnet_upgrade" | "prefab:ton_of_timber_to_heap" | "jerotesvillage:dye_from_awn_herb" | "pasterdream:crafting_237" | "pasterdream:crafting_236" | "biomancy:decomposing/biomesoplenty_flesh_tendons_strand" | "quark:building/crafting/stonevariants/chiseled_diorite_bricks" | "pasterdream:crafting_239" | "pasterdream:crafting_238" | "pasterdream:crafting_233" | "quark:building/crafting/shingles/light_blue_shingles" | "pasterdream:crafting_232" | "pasterdream:crafting_235" | "pasterdream:crafting_234" | "minecraft:yellow_banner" | "biomancy:decomposing/adult_permeable_membrane" | "pasterdream:crafting_231" | "jerotesvillage:dye_from_fragrant_lawn" | "pasterdream:crafting_230" | "jerotesvillage:smooth_purple_sandstone_stairs_from_smooth_purple_sandstone_stonecutting" | "quark:world/stonecutting/stairs/jasper_stairs_stonecutter" | "biomancy:digesting/nutrient_paste_from_tree_star" | "create:cutting/compat/byg/stripped_lament_wood" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "minecraft:soul_lantern" | "legendary_monsters:eye_of_many_ribs" | "quark:building/crafting/vertslabs/polished_granite_vertical_slab_revert" | "refinedstorage:processor_binding" | "quark:building/crafting/slabs/smooth_soul_sandstone_slab" | "pasterdream:crafting_229" | "minecraft:crimson_trapdoor" | "meed:born_in_chaos_v1/rotten_smell" | "pasterdream:crafting_226" | "cataclysm:weapon_infusion/gauntlet_of_bulwark" | "pasterdream:crafting_225" | "functionalstorage:custom_compacting/clay" | "pasterdream:crafting_228" | "create:milling/compat/environmental/dianthus" | "create:milling/compat/regions_unexplored/daisy" | "pasterdream:crafting_227" | "create:crafting/kinetics/mysterious_cuckoo_clock" | "pasterdream:crafting_222" | "pasterdream:crafting_221" | "pasterdream:crafting_224" | "pasterdream:crafting_223" | "create:cutting/compat/byg/witch_hazel_log" | "minecraft:dye_gray_bed" | "minecraft:firework_star_fade" | "quark:world/crafting/slabs/blossom_planks_slab" | "create:cutting/compat/windswept/chestnut_wood" | "pasterdream:crafting_220" | "farmersdelight:cooked_salmon_slice_from_campfire_cooking" | "refinedstorage:coloring_recipes/black_grid" | "refinedstorage:coloring_recipes/brown_crafter_manager" | "create:crafting/logistics/pulse_repeater" | "biomancy:decomposing/bioluminesscence" | "prefab:magic_temple" | "create:small_scoria_brick_slab_recycling" | "minecraft:dye_light_gray_bed" | "minecraft:bamboo_stairs" | "quark:building/crafting/vertslabs/mud_brick_vertical_slab_revert" | "quark:tools/crafting/trowel" | "create:milling/compat/byg/lazarus_bellflower" | "create:polished_cut_tuff_slab_recycling" | "minecraft:smooth_basalt" | "refinedstorage:coloring_recipes/controller" | "pasterdream:crafting_219" | "pasterdream:crafting_218" | "biomancy:decomposing/mosquito_proboscis" | "minecraft:blue_concrete_powder" | "pasterdream:crafting_215" | "minecraft:blue_stained_glass" | "pasterdream:crafting_214" | "pasterdream:crafting_217" | "pasterdream:crafting_216" | "minecraft:iron_ingot_from_smelting_deepslate_iron_ore" | "create:small_granite_brick_wall_from_stone_types_granite_stonecutting" | "pasterdream:crafting_211" | "pasterdream:crafting_210" | "pasterdream:crafting_213" | "pasterdream:crafting_212" | "minecraft:chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "netherexp:stonecutting/from_polished_basalt_bricks/polished_basalt_brick_stairs" | "create:cutting/compat/twilightforest/stripped_canopy_wood" | "jerotesvillage:cut_sun_sandstone_from_sun_sandstone_stonecutting" | "create:small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "create:small_granite_brick_slab" | "quark:building/stonecutting/stonevariants/diorite_pillar_stonecutter" | "create:copper_shingle_slab" | "pasterdream:smelting_12" | "pasterdream:smelting_11" | "biomancy:digesting/nutrient_paste_from_relicheirus_egg" | "pasterdream:smelting_14" | "pasterdream:smelting_13" | "quark:building/crafting/slabs/blackstone_bricks_slab" | "pasterdream:smelting_10" | "create:crushing/netherrack" | "quark:building/crafting/vertslabs/jasper_vertical_slab_revert" | "farmersdelight:packed_mud_from_straw" | "minecraft:blue_candle" | "pasterdream:crafting_208" | "pasterdream:crafting_207" | "create:cut_ochrum_wall" | "quark:building/crafting/vertslabs/shale_bricks_vertical_slab_revert" | "pasterdream:crafting_209" | "legendary_monsters:ancient_dripstone_brick_wall" | "pasterdream:crafting_204" | "pasterdream:crafting_203" | "pasterdream:crafting_206" | "pasterdream:crafting_205" | "pasterdream:crafting_200" | "pasterdream:crafting_202" | "create:milling/compat/regions_unexplored/red_snowbelle" | "pasterdream:crafting_201" | "netherexp:polished_blackstone_pillar" | "quark:building/crafting/vertslabs/bamboo_vertical_slab_revert" | "minecraft:flower_banner_pattern" | "jerotesvillage:raw_meror_metal_block_craft" | "quark:world/stonecutting/stairs/jasper_bricks_stairs_stonecutter" | "netherexp:soul_soil_layer" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "jerotesvillage:smooth_glitter_sandstone_stairs_from_smooth_glitter_sandstone_stonecutting" | "pasterdream:crafting_277" | "biomancy:bio_forging/decomposer" | "pasterdream:crafting_276" | "minecraft:gold_ingot_from_blasting_raw_gold" | "quark:building/crafting/lamps/indigo_corundum_lamp" | "quark:building/stonecutting/walls/netherrack_bricks_wall_stonecutter" | "pasterdream:crafting_279" | "create:cutting/compat/byg/stripped_pine_wood" | "pasterdream:crafting_278" | "protection_pixel:floatshieldloot" | "pasterdream:crafting_273" | "pasterdream:crafting_272" | "pasterdream:crafting_275" | "quark:building/crafting/vertplanks/vertical_ancient_planks" | "pasterdream:crafting_274" | "pasterdream:crafting_271" | "pasterdream:crafting_270" | "minecraft:cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:gold_ingot_from_blasting_gold_ore" | "jerotesvillage:serpon_helmet_craft" | "refinedstorage:fluid_grid/cyan_fluid_grid" | "prefab:dirt_stairs_reverse" | "create:small_diorite_brick_slab" | "cataclysm:black_steel_nugget_from_smelting" | "functionalstorage:oak_drawer_alternate_x2" | "quark:world/crafting/slabs/permafrost_slab" | "functionalstorage:oak_drawer_alternate_x1" | "netherexp:shotgun_fist" | "pasterdream:crafting_269" | "jeed:levitation" | "pasterdream:crafting_266" | "pasterdream:crafting_265" | "pasterdream:crafting_268" | "pasterdream:crafting_267" | "pasterdream:crafting_262" | "pasterdream:crafting_261" | "pasterdream:crafting_264" | "create:cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "pasterdream:crafting_263" | "create:smelting/zinc_ingot_from_raw_ore" | "quark:building/crafting/iron_ladder" | "pasterdream:crafting_260" | "functionalstorage:oak_drawer_alternate_x4" | "quark:building/crafting/vertslabs/weathered_cut_copper_vertical_slab_revert" | "minecraft:purple_banner" | "create:jungle_window_pane" | "farmersdelight:straw_bale" | "biomancy:decomposing/fire_coral" | "create:deepslate_from_stone_types_deepslate_stonecutting" | "pasterdream:crafting_259" | "quark:world/crafting/woodsets/ancient/bookshelf" | "quark:building/crafting/vertslabs/quartz_vertical_slab" | "pasterdream:crafting_258" | "create:cut_dripstone_slab" | "pasterdream:crafting_255" | "pasterdream:crafting_254" | "jerotesvillage:ancient_second_rounder_noble_boots_smith" | "pasterdream:crafting_257" | "minecraft:wooden_hoe" | "pasterdream:crafting_256" | "quark:building/crafting/vertslabs/spruce_vertical_slab" | "pasterdream:crafting_251" | "pasterdream:crafting_250" | "itemfilters:always_true" | "quark:automation/crafting/iron_rod" | "refinedstorage:coloring_recipes/light_gray_network_transmitter" | "pasterdream:crafting_253" | "create:cutting/compat/byg/ebony_wood" | "pasterdream:crafting_252" | "farmersdelight:gray_hanging_canvas_sign" | "netherexp:pale_soul_slate" | "create:small_limestone_bricks_from_stone_types_limestone_stonecutting" | "quark:tweaks/crafting/utility/chests/dark_oak_chest_wood" | "quark:building/stonecutting/vertslabs/exposed_cut_copper_vertical_slab_from_exposed_copper" | "netherexp:shotgun_barrel" | "quark:building/stonecutting/vertslabs/lime_shingles_vertical_slab_stonecutter" | "minecraft:waxed_oxidized_cut_copper_stairs" | "pasterdream:crafting_248" | "pasterdream:crafting_247" | "pasterdream:crafting_249" | "art_of_forging:life_fiber" | "pasterdream:crafting_244" | "pasterdream:crafting_243" | "pasterdream:crafting_246" | "farmersdelight:cutting/leather_horse_armor" | "pasterdream:crafting_245" | "prefab:dirt_slab" | "pasterdream:crafting_240" | "jerotesvillage:qoaiku_metal_nugget_from_smelt" | "pasterdream:crafting_242" | "pasterdream:crafting_241" | "quark:building/crafting/stonevariants/vanilla/polished_tuff" | "biomancy:bio_forging/packed_flesh_stairs" | "create:milling/compat/botania/red_petal" | "create:milling/compat/regions_unexplored/fireweed" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "quark:world/stonecutting/slabs/polished_shale_slab_stonecutter" | "create:crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "minecraft:piston" | "jerotesvillage:cut_sun_sandstone_slab_from_sun_sandstone_stonecutting" | "refinedstorage:coloring_recipes/orange_grid" | "jerotesvillage:cooked_second_round_nigrum_from_smoking" | "jerotesvillage:smooth_purple_sandstone_stairs_craft" | "quark:building/crafting/blue_nether_bricks" | "meed:cataclysm/blessing_of_amethyst" | "biomancy:decomposing/biomesoplenty_flesh" | "jerotesvillage:hag_replacement/jerotesvillage_qoaiku_metal_ingot" | "minecraft:white_banner" | "biomancy:crafting/red_sand_from_mineral_fragment" | "naturescompass:natures_compass" | "minecraft:smooth_quartz" | "quark:building/crafting/acacia_post" | "tetra:purgatory_armor" | "refinedstorage:coloring_recipes/magenta_network_transmitter" | "create:milling/cocoa_beans" | "quark:building/crafting/chests/prismarine_trapped_chest" | "minecraft:cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "create:crafting/kinetics/train_trapdoor" | "quark:building/stonecutting/vertslabs/diorite_bricks_vertical_slab_stonecutter" | "cataclysm:stonecutting/purpur_tile_pillar_from_stonecutting" | "meed:tombstone/diversion" | "quark:building/stonecutting/stonevariants/myalite_bricks_stonecutter" | "biomancy:crafting/flesh_door_from_full_flesh_door" | "create:milling/compat/regions_unexplored/mallow" | "cataclysm:ancient_metal_block" | "jerotesvillage:explorer_chestplate_smith" | "create:cutting/compat/blue_skies/maple_wood" | "create:sequenced_assembly/sturdy_sheet" | "refinedstorage:coloring_recipes/magenta_relay" | "farmersdelight:fried_egg_from_campfire_cooking" | "farmersdelight:cutting/oak_log" | "itemfilters:block" | "netherexp:netherite_plating" | "jerotesvillage:rambler_leather_glove_craft" | "create:cutting/compat/biomesoplenty/stripped_palm_log" | "create:milling/compat/environmental/bluebell" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_tiles" | "prefab:coil_of_lanterns_to_string_of_lanterns" | "prefab:bulldozer" | "legendary_monsters:ancient_dripstone_tile_stairs_stonecutter" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "biomancy:crafting/flesh_stairs" | "jerotesvillage:botanize_powder_sugar_craft" | "biomancy:decomposing/dried_kelp_block" | "create:cutting/compat/regions_unexplored/silver_birch_log" | "pasterdream:crafting_299" | "pasterdream:crafting_298" | "create:small_limestone_brick_stairs" | "pasterdream:crafting_295" | "pasterdream:crafting_294" | "pasterdream:crafting_297" | "pasterdream:crafting_296" | "pasterdream:crafting_291" | "minecraft:green_glazed_terracotta" | "pasterdream:crafting_290" | "pasterdream:crafting_293" | "create:crafting/kinetics/copper_valve_handle" | "pasterdream:crafting_292" | "create:deploying/waxed_oxidized_cut_copper_stairs_from_adding_wax" | "netherexp:stonecutting/from_soul_slate_tiles/etched" | "create:small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "quark:building/crafting/vertslabs/permafrost_bricks_vertical_slab" | "prefab:villager_houses" | "quark:building/crafting/vertslabs/cobblestone_bricks_vertical_slab_revert" | "legendary_monsters:ancient_dripstone_brick_slab_stonecutter_adbr" | "refinedstorage:coloring_recipes/lime_crafting_grid" | "biomancy:decomposing/bloomlight" | "quark:building/stonecutting/vertslabs/soul_sandstone_vertical_slab_stonecutter" | "netherexp:chiseled_soul_slate_tiles" | "pasterdream:crafting_288" | "pasterdream:crafting_287" | "create:milling/compat/byg/california_poppy" | "pasterdream:crafting_289" | "pasterdream:crafting_284" | "pasterdream:crafting_283" | "create:crushing/compat/aether/zanite_ore" | "pasterdream:crafting_286" | "create:cutting/compat/regions_unexplored/stripped_eucalyptus_wood" | "quark:tweaks/crafting/utility/tools/stone_pickaxe" | "quark:building/stonecutting/stonevariants/calcite_bricks_stonecutter" | "pasterdream:crafting_285" | "create:milling/compat/byg/magenta_amaranth" | "pasterdream:crafting_280" | "quark:building/stonecutting/stonevariants/myalite_bricks_slab_rough_stonecutting" | "pasterdream:crafting_282" | "pasterdream:crafting_281" | "netherexp:polished_basalt_brick_wall" | "tetra:emerald" | "farmersdelight:stove" | "quark:tools/smelting/trowel_to_iron_nugget" | "quark:building/crafting/vertslabs/ancient_planks_vertical_slab" | "prefab:clutch_of_eggs_from_crate" | "refinedstorage:stack_upgrade" | "create:cutting/compat/windswept/stripped_holly_wood" | "create:cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "farmersdelight:carrot_crate" | "minecraft:tipped_arrow" | "minecraft:rib_armor_trim_smithing_template_smithing_trim" | "biomancy:bio_brewing/decaying_additive" | "born_in_chaos_v1:black_argillite_wk" | "minecraft:light_blue_carpet" | "create:cutting/compat/regions_unexplored/redwood_log" | "refinedstorage:constructor" | "create:polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "chunkloaders:ultimate_chunk_loader" | "quark:building/crafting/vertslabs/raw_copper_bricks_vertical_slab" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "jerotesvillage:hag_replacement/minecraft_bone" | "meed:deep_aether/valkyrie_valor" | "create:milling/cobblestone" | "quark:building/stonecutting/vertslabs/end_stone_brick_vertical_slab_stonecutter" | "quark:building/crafting/cobblestone_bricks" | "refinedstorage:coloring_recipes/white_crafter_manager" | "create:layered_andesite_from_stone_types_andesite_stonecutting" | "prefab:swift_blade_copper" | "create:cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "create:polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "minecraft:deepslate_tile_slab" | "jerotesvillage:drought_fire_bricks_from_drought_fire_stone_stonecutting" | "quark:building/stonecutting/slabs/raw_iron_bricks_slab_stonecutter" | "create:polished_cut_calcite_from_stone_types_calcite_stonecutting" | "refinedstorage:coloring_recipes/pink_crafting_monitor" | "refinedstorage:coloring_recipes/pink_crafter_manager" | "cataclysm:bulwark_of_the_flame" | "jerotesvillage:carved_villager_concertina_wire_craft" | "create:cutting/compat/environmental/willow_log" | "create:dark_oak_window" | "quark:building/stonecutting/vertslabs/tuff_bricks_vertical_slab_stonecutter" | "quark:building/crafting/vertslabs/limestone_bricks_vertical_slab_revert" | "create:cutting/compat/byg/holly_log" | "quark:tweaks/crafting/utility/wool/light_blue_wool" | "create:small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "minecraft:warped_button" | "create:cut_crimsite_stairs" | "quark:building/stonecutting/vertslabs/dripstone_block_vertical_slab_stonecutter" | "quark:building/crafting/glass/orange_framed_glass" | "quark:building/stonecutting/stairs/light_blue_shingles_stairs_stonecutter" | "create:small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "create:splashing/pink_concrete_powder" | "create:crafting/kinetics/sequenced_gearshift" | "quark:tools/smithing/rune_smithing_brown" | "farmersdelight:cutting/dark_oak_door" | "create:cutting/compat/byg/stripped_mahogany_wood" | "lendersdelight:slice/lionfish_slice" | "minecraft:armor_dye" | "create:cutting/compat/the_vault/stripped_wooden_log" | "quark:building/crafting/stairs/magenta_shingles_stairs" | "jerotesvillage:villager_metal_block_craft" | "create:cutting/compat/byg/stripped_aspen_wood" | "netherexp:stonecutting/from_basalt/polished_basalt_brick_slab" | "quark:building/crafting/crimson_ladder" | "cataclysm:obsidian_explosion_trap_bricks" | "create:polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "farmersdelight:cutting/mangrove_hanging_sign" | "jerotesvillage:cooked_starbrite" | "minecraft:map" | "quark:building/stonecutting/slabs/tuff_slab_stonecutter" | "create:cut_scorchia_stairs" | "minecraft:detector_rail" | "refinedstorage:4096k_fluid_storage_part" | "jerotesvillage:villager_block_hunter_craft" | "biomancy:decomposing/packed_flesh_slab" | "born_in_chaos_v1:pileof_dark_metal_k_2" | "quark:building/crafting/vertslabs/andesite_vertical_slab_revert" | "create:cutting/compat/biomesoplenty/jacaranda_log" | "jerotesvillage:cooked_brown_venomous_slug_from_campfire_cooking" | "quark:building/crafting/vertslabs/cobbled_deepslate_vertical_slab_revert" | "create:blasting/silver_ingot_compat_iceandfire" | "quark:building/crafting/vertplanks/vertical_bamboo_planks_revert" | "quark:building/crafting/vertslabs/duskbound_block_vertical_slab" | "jerotesvillage:qoaiku_metal_ingot_craft" | "create:splashing/mekanism/crushed_raw_uranium" | "minecraft:crafting_table" | "refinedstorage:coloring_recipes/red_controller" | "minecraft:green_stained_glass_pane_from_glass_pane" | "biomancy:decomposing/dead_bubble_coral" | "lendersdelight:slice/amethyst_crab_meat_slice" | "create:crafting/logistics/stockpile_switch" | "jerotesvillage:meror_impact_pistol_craft" | "quark:automation/crafting/feeding_trough" | "create:cutting/compat/blue_skies/starlit_wood" | "minecraft:orange_wool" | "biomancy:crafting/smooth_primal_flesh_slab" | "refinedstorage:fluid_interface" | "legendary_monsters:withered_scythe" | "minecraft:anvil" | "create:cut_scorchia_brick_stairs" | "biomancy:bio_forging/packed_flesh_wall" | "create:milling/compat/regions_unexplored/brown_snowbelle" | "create:polished_cut_andesite_stairs" | "cataclysm:stonecutting/azure_seastone_stairs_from_stonecutting" | "lendersdelight:cook/cooked_amethyst_crab_meat_from_campfire_cooking" | "refinedstorage:coloring_recipes/white_fluid_grid" | "create:crafting/logistics/pulse_extender" | "quark:building/crafting/stripped_acacia_post" | "create:cutting/compat/regions_unexplored/green_bioshroom_stem" | "quark:building/stonecutting/vertslabs/polished_limestone_vertical_slab_stonecutter" | "quark:building/stonecutting/pink_shingles_stonecutter2" | "farmersdelight:magenta_hanging_canvas_sign" | "meed:born_in_chaos_v1/dark_splash" | "quark:building/crafting/stone_lamp" | "born_in_chaos_v1:orange_stained_glass_k" | "create:small_ochrum_brick_slab" | "quark:world/stonecutting/polished_calcite_stonecutter" | "create:polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "minecraft:black_glazed_terracotta" | "create:pressing/compat/byg/lush_grass_path" | "quark:tools/smithing/rune_smithing_pink" | "quark:building/crafting/slabs/iron_plate_slab" | "minecraft:carrot_on_a_stick" | "jerotesvillage:dye_from_white_breeze_violet" | "quark:tweaks/crafting/utility/tools/stone_axe" | "create:cutting/compat/byg/pine_wood" | "create:crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "born_in_chaos_v1:bundleof_bones_l" | "born_in_chaos_v1:bundleof_bones_k" | "quark:building/crafting/glass/magenta_framed_glass" | "refinedstorage:coloring_recipes/light_gray_crafting_grid" | "create:crushing/raw_platinum_block" | "create:exposed_copper_shingle_slab" | "itemfilters:tag" | "quark:building/stonecutting/stonevariants/calcite_bricks_slab_polished_stonecutting" | "cataclysm:stonecutting/azure_seastone_wall_from_stonecutting" | "quark:building/crafting/vertslabs/calcite_bricks_vertical_slab" | "jerotesvillage:serpon_hoe_craft" | "refinedstorage:pattern_grid/orange_pattern_grid" | "biomancy:digesting/nutrient_paste_from_lily_pad" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "create:cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "create:cutting/compat/quark/ancient_wood" | "create:haunting/soul_lantern" | "quark:building/crafting/vertslabs/polished_dripstone_vertical_slab_revert" | "meed:born_in_chaos_v1/stimulatingsurge" | "quark:building/crafting/vertplanks/vertical_mangrove_planks_revert" | "refinedstorage:coloring_recipes/red_disk_manipulator" | "farmersdelight:integration/silentgear/cutting/netherwood" | "minecraft:raw_iron_block" | "refinedstorage:1024k_fluid_storage_disk_from_storage_housing" | "minecraft:oak_button" | "biomancy:digesting/nutrient_paste_from_red_mushroom_block" | "minecraft:dark_oak_hanging_sign" | "create:crushing/compat/elementaryores/ore_diamond_end" | "jerotesvillage:ocean_gemstone_craft" | "minecraft:polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "refinedstorage:coloring_recipes/yellow_grid" | "create:splashing/gray_concrete_powder" | "farmersdelight:milk_bucket_from_bottles" | "quark:building/stonecutting/stairs/tuff_bricks_stairs_stonecutter" | "art_of_forging:rending_scissor_purple" | "quark:building/stonecutting/stairs/raw_gold_bricks_stairs_stonecutter" | "create:milling/compat/byg/rose" | "biomancy:decomposing/lapis_lazuli" | "create:cutting/compat/botania/dreamwood" | "quark:building/crafting/slabs/light_gray_shingles_slab" | "protection_pixel:typhoonloot" | "farmersdelight:cutting/jungle_wood" | "minecraft:waxed_exposed_cut_copper" | "refinedstorage:basic_processor" | "quark:building/crafting/stairs/calcite_bricks_stairs" | "create:crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "farmersdelight:cutting/cooked_chicken" | "refinedstorage:coloring_recipes/cyan_grid" | "protection_pixel:steamexoloot" | "jerotesvillage:leather_sling_craft" | "quark:building/crafting/raw_gold_bricks" | "biomancy:bio_forging/acolyte_armor_boots" | "minecraft:item_frame" | "minecraft:iron_ingot_from_smelting_iron_ore" | "quark:oddities/crafting/bonded_rabbit_hide_uncompress" | "prefab:town_hall" | "refinedstorage:1024k_fluid_storage_part" | "biomancy:decomposing/sand" | "netherexp:netherrack_bricks" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "biomancy:decomposing/skeleton_skull" | "farmersdelight:egg_sandwich" | "meed:pachys_might" | "create:small_diorite_brick_slab_recycling" | "quark:building/stonecutting/walls/cobblestone_bricks_wall_stonecutter" | "create:milling/compat/byg/cyan_tulip" | "minecraft:pink_dye_from_pink_tulip" | "minecraft:arrow" | "quark:building/crafting/walls/raw_iron_bricks_wall" | "biomancy:decomposing/spore_blossom" | "jerotesvillage:hag_replacement/jerotesvillage_ocean_gemstone_fragments" | "quark:tweaks/smelting/raw_iron_block_smelt" | "legendary_monsters:dinosaur_bone_club" | "meed:burning" | "biomancy:decomposing/nutrient_paste" | "jerotesvillage:serpon_alloy_ingot_craft" | "quark:world/stonecutting/stairs/granite_bricks_stairs_stonecutter" | "prefab:coil_of_lanterns_from_string_of_lanterns" | "farmersdelight:purple_canvas_sign" | "jerotesvillage:qoaiku_metal_nugget_craft" | "jerotesvillage:cut_glitter_sandstone_craft" | "protection_pixel:linkplatehelmetloot" | "quark:building/crafting/compressed/beetroot_crate" | "minecraft:red_sandstone_stairs" | "create:cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "create:smelting/ingot_aluminium_compat_ic2" | "cataclysm:stonecutting/obsidian_brick_wall_from_stonecutting" | "biomancy:bio_brewing/exotic_compound" | "farmersdelight:brown_hanging_canvas_sign" | "create:cut_tuff_slab" | "quark:building/crafting/stairs/red_shingles_stairs" | "minecraft:green_wool" | "create:cutting/compat/byg/palm_wood" | "refinedstorage:coloring_recipes/white_wireless_transmitter" | "quark:building/crafting/vertslabs/granite_bricks_vertical_slab" | "born_in_chaos_v1:scorched_log_k" | "create:cut_tuff_brick_slab" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_brick_slab" | "create:crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "create:crushing/coal_ore" | "refinedstorage:disk_drive" | "prefab:grass_slab" | "quark:building/crafting/stonevariants/jasper_bricks" | "born_in_chaos_v1:pileof_dark_metal_d" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_wood" | "quark:building/stonecutting/black_shingles_stonecutter2" | "jerotesvillage:meror_chainsaw_craft" | "quark:building/crafting/furnaces/cobblestone_furnace" | "create:layered_veridium_from_stone_types_veridium_stonecutting" | "minecraft:jungle_button" | "refinedstorage:coloring_recipes/yellow_wireless_transmitter" | "biomancy:decomposing/bear_fur" | "quark:building/stonecutting/stonevariants/limestone_bricks_stairs_rough_stonecutting" | "pasterdream:crafting_318" | "pasterdream:crafting_317" | "pasterdream:crafting_319" | "jerotesvillage:bright_bola_craft" | "pasterdream:crafting_313" | "pasterdream:crafting_316" | "pasterdream:crafting_315" | "pasterdream:crafting_310" | "pasterdream:crafting_312" | "pasterdream:crafting_311" | "netherexp:stonecutting/from_netherrack_bricks/netherrack_pillar" | "create:polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "minecraft:waxed_oxidized_copper_from_honeycomb" | "netherexp:soul_glass" | "minecraft:spruce_trapdoor" | "create:cutting/compat/biomesoplenty/hellbark_log" | "pasterdream:crafting_307" | "create:cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "pasterdream:crafting_306" | "pasterdream:crafting_309" | "minecraft:respawn_anchor" | "pasterdream:crafting_308" | "pasterdream:crafting_303" | "pasterdream:crafting_302" | "create:cutting/compat/byg/skyris_wood" | "pasterdream:crafting_305" | "pasterdream:crafting_304" | "born_in_chaos_v1:fried_maggot_k" | "pasterdream:crafting_301" | "pasterdream:crafting_300" | "protection_pixel:pioneerasloot" | "netherexp:cyan_dye_from_twisting_helix" | "netherexp:netherite_plated_block" | "quark:building/stonecutting/stairs/cyan_shingles_stairs_stonecutter" | "quark:building/crafting/vertslabs/netherrack_bricks_vertical_slab" | "create:milling/compat/byg/pink_allium_flower_bush" | "minecraft:dark_prismarine_stairs" | "create:polished_cut_asurine_from_stone_types_asurine_stonecutting" | "biomancy:decomposing/mob_marrow" | "netherexp:stonecutting/from_blue_nether_bricks/blue_nether_brick_wall" | "quark:building/stonecutting/light_blue_shingles_stonecutter2" | "create:milling/compat/byg/richea" | "biomancy:digesting/nutrient_paste_from_pewen_branch" | "create:milling/compat/regions_unexplored/light_blue_snowbelle" | "netherexp:shroomlight" | "prefab:crate_of_carrots" | "create:cutting/compat/byg/stripped_skyris_wood" | "jerotesvillage:meror_long_knife_craft" | "minecraft:polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "quark:building/crafting/slabs/soul_sandstone_bricks_slab" | "minecraft:snow_block" | "create:pressing/compat/atmospheric/crustose_path" | "quark:building/crafting/dark_oak_bookshelf" | "create:blasting/zinc_ingot_from_crushed" | "minecraft:cyan_wool" | "create:crafting/kinetics/fluid_valve" | "create:polished_cut_veridium_wall" | "minecraft:composter" | "minecraft:sandstone_stairs" | "quark:building/crafting/hollowlogs/hollow_warped_stem" | "create:crushing/compat/aether/ambrosium_ore" | "create:haunting/infested_cracked_stone_bricks" | "quark:building/crafting/shingles/gray_shingles" | "create:copper_tile_stairs" | "prefab:grass_wall_reverse" | "minecraft:coarse_dirt" | "biomancy:digesting/nutrient_paste_from_grass" | "refinedstorage:crafting_grid/green_crafting_grid" | "quark:building/stonecutting/vertslabs/polished_andesite_vertical_slab2_stonecutter" | "create:crafting/kinetics/white_seat" | "quark:building/crafting/stairs/blackstone_bricks_stairs" | "quark:building/crafting/vertslabs/polished_limestone_vertical_slab" | "netherexp:claret_hanging_sign" | "create:crushing/deepslate_coal_ore" | "create:milling/compat/environmental/white_lotus_flower" | "farmersdelight:cutting/dark_oak_trapdoor" | "minecraft:prismarine_slab" | "create:cutting/bamboo_block" | "refinedstorage:relay" | "minecraft:fermented_spider_eye" | "quark:building/crafting/panes/blue_framed_glass_pane" | "minecraft:light_gray_glazed_terracotta" | "born_in_chaos_v1:black_argillite_sk" | "create:blasting/ingot_osmium_compat_mekanism" | "create:cutting/compat/biomesoplenty/mahogany_log" | "refinedstorage:coloring_recipes/white_network_transmitter" | "jerotesvillage:ablepsia_tablet_craft" | "create:crushing/compat/quark/moss_block" | "create:cutting/compat/ecologics/flowering_azalea_log" | "quark:building/crafting/chests/crimson_chest" | "minecraft:gold_ingot_from_gold_block" | "jerotesvillage:giant_monster_chestplate_craft" | "minecraft:cobbled_deepslate_slab" | "quark:building/crafting/slabs/soul_sandstone_slab" | "create:crafting/appliances/dough" | "create:cutting/compat/biomesoplenty/stripped_redwood_wood" | "refinedstorage:coloring_recipes/black_disk_manipulator" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "quark:world/stonecutting/walls/jasper_wall_stonecutter" | "prefab:quartz_crete_wall" | "farmersdelight:cooking/pasta_with_mutton_chop" | "jerotesvillage:iron_nugget_from_explorer_smelt" | "jerotesvillage:carved_leader_boots_smith" | "minecraft:chiseled_quartz_block" | "create:crafting/materials/rose_quartz_tilesfrom_conversion" | "prefab:modern_buildings_improved" | "create:cutting/compat/blue_skies/frostbright_wood" | "jerotesvillage:villager_metal_pressure_plate_craft" | "functionalstorage:spruce_4" | "functionalstorage:spruce_1" | "functionalstorage:spruce_2" | "refinedstorage:coloring_recipes/cyan_crafter" | "tetra:murasama_scroll" | "create:cut_scorchia_brick_slab" | "create:cutting/compat/the_vault/stripped_overgrown_wooden_log" | "create:cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "protection_pixel:workerasloot" | "pasterdream:crafting_332" | "pasterdream:crafting_331" | "cataclysm:black_steel_ingot_from_nuggets" | "pasterdream:crafting_330" | "prefab:bunch_of_potatoes" | "quark:building/stonecutting/mud_pillar_stonecutter" | "jerotesvillage:magicka_scale_leggings_smith" | "quark:building/crafting/chests/warped_chest" | "create:small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:smooth_quartz_stairs" | "pasterdream:crafting_329" | "create:crushing/raw_uranium" | "pasterdream:crafting_328" | "create:blasting/ingot_uranium_compat_mekanism" | "pasterdream:crafting_325" | "pasterdream:crafting_324" | "pasterdream:crafting_327" | "pasterdream:crafting_326" | "pasterdream:crafting_321" | "pasterdream:crafting_320" | "pasterdream:crafting_323" | "pasterdream:crafting_322" | "create:milling/compat/regions_unexplored/purple_lupine" | "create:crafting/kinetics/mechanical_mixer" | "cataclysm:azure_seastone_stairs" | "quark:world/crafting/panes/white_corundum" | "quark:building/crafting/vertslabs/waxed_exposed_cut_copper_vertical_slab" | "quark:building/crafting/vertslabs/polished_jasper_vertical_slab" | "minecraft:lime_dye" | "create:cutting/compat/regions_unexplored/pink_bioshroom_hyphae" | "biomancy:decomposing/apple" | "create:smelting/ingot_lead_compat_mekanism" | "farmersdelight:cabbage_from_leaves" | "minecraft:oak_planks" | "biomancy:special_crafting/player_head" | "minecraft:orange_candle" | "refinedstorage:controller" | "create:cutting/compat/atmospheric/aspen_wood" | "quark:world/stonecutting/stairs/limestone_stairs_stonecutter" | "cataclysm:black_steel_axe" | "minecraft:mangrove_door" | "jerotesvillage:black_yellow_stairs_craft" | "quark:building/stonecutting/stonevariants/andesite_bricks_vertical_slab_polished_stonecutting" | "protection_pixel:prismasloot" | "create:polished_cut_diorite_wall" | "minecraft:stone_brick_wall" | "biomancy:decomposing/dead_fire_coral_fan" | "create:milling/compat/biomesoplenty/blue_hydrangea" | "prefab:swift_blade_bronze" | "minecraft:repair_item" | "jerotesvillage:bright_cobblestone_slab_from_bright_cobblestone_stonecutting" | "biomancy:crafting/malignant_flesh_wall" | "netherexp:stonecutting/from_basalt/polished_basalt_bricks" | "quark:building/stonecutting/walls/soul_sandstone_wall_stonecutter" | "minecraft:light_blue_dye_from_blue_white_dye" | "quark:building/crafting/shingles/pink_shingles" | "explorerscompass:explorers_compass" | "functionalstorage:custom_compacting/amethyst" | "minecraft:cyan_dye" | "netherexp:stonecutting/from_polished_basalt_bricks/polished_basalt_brick_wall" | "biomancy:decomposing/quartz" | "create:oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_log" | "legendary_monsters:ancient_dripstone_brick_stairs" | "farmersdelight:bamboo_cabinet" | "quark:building/stonecutting/stonevariants/dripstone_bricks_stonecutter" | "create:crafting/kinetics/gray_seat_from_other_seat" | "create:cutting/compat/biomesoplenty/palm_wood" | "minecraft:gold_block" | "minecraft:spruce_boat" | "quark:building/stonecutting/vertslabs/shingles_vertical_slab_stonecutter2" | "create:cutting/compat/biomesoplenty/stripped_magic_log" | "biomancy:decomposing/fermented_spider_eye" | "quark:building/crafting/lamps/violet_corundum_lamp" | "minecraft:cherry_wood" | "jerotesvillage:villager_metal_spear_craft" | "jerotesvillage:qoaiku_round_shield_craft" | "biomancy:digesting/nutrient_paste_from_seeds" | "jerotesvillage:cooked_solish_meat_from_campfire_cooking" | "create:cutting/compat/byg/nightshade_log" | "quark:building/crafting/vertplanks/vertical_ancient_planks_revert" | "netherexp:cut_silica_sandstone" | "meed:soulsweapons/freezing" | "born_in_chaos_v1:cobwebcover_craft" | "refinedstorage:crafting_grid/white_crafting_grid" | "meed:fatal_flicker" | "minecraft:copper_ingot_from_blasting_raw_copper" | "minecraft:cut_red_sandstone_slab" | "quark:building/crafting/vertplanks/vertical_acacia_planks" | "quark:building/crafting/vertslabs/nether_brick_vertical_slab_revert" | "farmersdelight:salmon_roll" | "create:splashing/mekanism/crushed_raw_lead" | "quark:building/crafting/walls/dirt_bricks_wall" | "netherexp:soul_slate_wall" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_stem" | "create:cutting/compat/tconstruct/bloodshroom_log" | "refinedstorage:pattern_grid/red_pattern_grid" | "minecraft:emerald_from_smelting_deepslate_emerald_ore" | "create:cut_tuff_brick_slab_recycling" | "create:ornate_iron_window_pane" | "quark:world/stonecutting/walls/granite_bricks_wall_stonecutter" | "minecraft:raw_iron" | "quark:building/stonecutting/slabs/cobblestone_bricks_slab_stonecutter" | "minecraft:iron_nugget" | "biomancy:decomposing/spiked_scute" | "jerotesvillage:bitter_cold_fence_craft" | "farmersdelight:cutting/gravel" | "create:crushing/raw_copper_block" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "jerotesvillage:villager_invitation_craft" | "refinedstorage:4k_storage_block" | "refinedstorage:coloring_recipes/cyan_crafting_grid" | "minecraft:nether_wart_block" | "born_in_chaos_v1:spiritual_dust_k" | "minecraft:bamboo_fence_gate" | "quark:building/crafting/vertslabs/polished_dripstone_vertical_slab" | "farmersdelight:cooking/baked_cod_stew" | "meed:born_in_chaos_v1/vampiric_touch" | "easy_villagers:auto_trader" | "biomancy:bio_forging/extractor" | "refinedstorage:coloring_recipes/blue_controller" | "quark:world/crafting/woodsets/azalea/trapped_chest" | "sophisticatedbackpacks:advanced_magnet_upgrade_from_basic" | "farmersdelight:cherry_cabinet" | "create:crushing/diorite" | "create:cut_veridium_wall" | "biomancy:digesting/nutrient_paste_from_turtle_egg" | "itemfilters:always_false" | "quark:building/stonecutting/slabs/pink_shingles_slab_stonecutter2" | "create:crafting/kinetics/magenta_seat_from_other_seat" | "create:cutting/compat/integrateddynamics/menril_log" | "biomancy:bio_forging/fibrous_flesh_wall" | "cataclysm:weapon_infusion/gauntlet_of_maelstrom" | "farmersdelight:melon_popsicle" | "refinedstorage:coloring_recipes/security_manager" | "farmersdelight:spruce_cabinet" | "biomancy:decomposing/ink_sac" | "quark:building/stonecutting/mud_brick_lattice_stonecutter" | "create:cutting/compat/regions_unexplored/stripped_cobalt_log" | "minecraft:dye_light_gray_wool" | "quark:building/crafting/stonevariants/dripstone_bricks" | "minecraft:writable_book" | "prefab:quartz_crete_stairs_up_right" | "cataclysm:blackstone_pillar" | "create:cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "quark:building/stonecutting/stairs/cyan_shingles_stairs_stonecutter2" | "minecraft:golden_apple" | "quark:building/stonecutting/vertslabs/calcite_bricks_vertical_slab_stonecutter" | "minecraft:diamond_pickaxe" | "minecraft:light_gray_dye_from_oxeye_daisy" | "create:splashing/ic2/crushed_raw_aluminum" | "create:crushing/deepslate_redstone_ore" | "jeed:conduit" | "netherexp:stonecutting/soul_slate_tiles_from_etched_soul_slate_tiles" | "create:milling/compat/botania/pink_petal" | "create:small_deepslate_brick_slab_recycling" | "farmersdelight:steak_and_potatoes" | "quark:world/crafting/woodsets/azalea/sign" | "quark:building/crafting/stairs/calcite_stairs" | "quark:world/crafting/panes/indigo_corundum_pane" | "cataclysm:frosted_stone_brick_slab" | "create:tuff_from_stone_types_tuff_stonecutting" | "biomancy:stonecutting/fibrous_flesh_slab_from_fibrous_flesh" | "refinedstorage:coloring_recipes/magenta_crafter_manager" | "meed:tombstone/true_sight" | "create:cutting/compat/regions_unexplored/kapok_log" | "quark:building/crafting/stairs/raw_iron_bricks_stairs" | "quark:building/crafting/vertslabs/red_sandstone_bricks_vertical_slab" | "quark:world/crafting/panes/orange_corundum_pane" | "quark:building/crafting/bamboo_bookshelf" | "constructionwand:infinity_wand" | "prefab:bunch_of_potatoes_from_crate" | "prefab:aqua_base_improved" | "jerotesvillage:meror_metal_war_beast_armor_craft" | "quark:building/stonecutting/vertslabs/waxed_cut_copper_vertical_slab_from_waxed_cut_copper" | "minecraft:polished_blackstone_wall" | "quark:world/stonecutting/stairs/shale_stairs_stonecutter" | "netherexp:cooking/cooked_hogham_from_smoking" | "farmersdelight:cooking/squid_ink_pasta" | "born_in_chaos_v1:spiny_shell_chestplate_k" | "meed:ars_nouveau/gravity" | "minecraft:redstone_from_smelting_redstone_ore" | "jerotesvillage:botanize_powder_craft" | "farmersdelight:cutting/warped_trapdoor" | "minecraft:suspicious_stew" | "quark:building/crafting/stonevariants/chiseled_granite_bricks" | "create:cutting/compat/biomesoplenty/dead_wood" | "born_in_chaos_v1:marigolds_k" | "farmersdelight:cutting/oak_wood" | "biomancy:decomposing/clay_ball" | "quark:world/crafting/waxed_indigo_corundum" | "quark:building/crafting/purple_stool" | "refinedstorage:coloring_recipes/green_security_manager" | "create:crafting/kinetics/item_vault" | "quark:automation/crafting/ender_watcher" | "jerotes:iron_war_beast_armor_craft" | "create:warped_window_pane" | "create:crafting/schematics/schematic_table" | "biomancy:bio_forging/undead_permeable_membrane_pane" | "create:crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "minecraft:dye_green_carpet" | "jerotesvillage:scaly_bear_helmet_smith" | "farmersdelight:cutting/spruce_log" | "biomancy:decomposing/brain_coral" | "sophisticatedbackpacks:advanced_jukebox_upgrade" | "create:cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "netherexp:cooking/cooked_hogham" | "born_in_chaos_v1:nightmare_mask_k" | "prefab:house_advanced" | "minecraft:wooden_pickaxe" | "create:small_asurine_brick_slab" | "jerotesvillage:villager_block_piglin_craft" | "biomancy:crafting/primal_flesh" | "born_in_chaos_v1:fel_lamp_k" | "create:cut_granite_brick_stairs" | "quark:building/crafting/shingles/magenta_shingles" | "minecraft:stick_from_bamboo_item" | "quark:building/stonecutting/vertslabs/permafrost_vertical_slab_stonecutter" | "refinedstorage:coloring_recipes/pink_pattern_grid" | "create:crafting/kinetics/depot" | "minecraft:diamond_from_blasting_diamond_ore" | "cataclysm:black_steel_shovel" | "legendary_monsters:mossy_chestplate" | "jerotesvillage:cooked_chromasnap_bass_from_smoking" | "netherexp:smokestalk_block" | "create:crushing/tin_ore" | "cataclysm:stonecutting/azure_seastone_brick_slab_from_stonecutting" | "meed:ars_nouveau/shocked" | "minecraft:end_stone_brick_stairs" | "biomancy:decomposing/gazelle_horn" | "create:small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "create:cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "cataclysm:stonecutting/polished_azure_seastone_wall_from_stonecutting" | "minecraft:stripped_crimson_hyphae" | "minecraft:cyan_carpet" | "minecraft:polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "quark:building/stonecutting/stairs/soul_sandstone_bricks_stairs_stonecutter" | "biomancy:bio_forging/modular_larynx" | "quark:building/crafting/glass/red_framed_glass" | "create:polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "meed:relics/immortality" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "biomancy:digesting/nutrient_paste_from_warped_wart_block" | "biomancy:decomposing/biomesoplenty_flesh_tendons" | "cataclysm:stonecutting/chiseled_end_stone_bricks_from_stonecutting" | "create:milling/compat/botania/purple_petal" | "biomancy:decomposing/echo_shard" | "minecraft:cyan_terracotta" | "protection_pixel:alloyplate" | "jerotesvillage:second_round_world_key_craft" | "create:cutting/compat/byg/stripped_bulbis_stem" | "create:cutting/compat/byg/stripped_bulbis_wood" | "quark:building/stonecutting/walls/mossy_cobblestone_bricks_wall_stonecutter" | "minecraft:mangrove_fence" | "netherexp:smokestalk_planks" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "biomancy:bio_brewing/healing_additive" | "biomancy:decomposing/chiseled_flesh" | "quark:building/stonecutting/stonevariants/tuff_bricks_vertical_slab_polished_stonecutting" | "refinedstorage:coloring_recipes/gray_crafting_monitor" | "netherexp:cerebrage_claret_hyphae" | "quark:building/stonecutting/stonevariants/dripstone_bricks_vertical_slab_polished_stonecutting" | "quark:world/crafting/stairs/myalite_stairs" | "minecraft:light_gray_bed" | "biomancy:decomposing/golden_carrot" | "biomancy:decomposing/coarse_dirt" | "biomancy:decomposing/glowstone_dust" | "create:cutting/compat/regions_unexplored/larch_log" | "create:small_veridium_brick_slab" | "jerotesvillage:cooked_brown_venomous_slug" | "minecraft:black_stained_glass_pane" | "create:cutting/compat/goodending/stripped_muddy_oak_wood" | "biomancy:decomposing/baby_permeable_membrane" | "refinedstorage:coloring_recipes/orange_crafter" | "born_in_chaos_v1:green_stained_glass_k" | "tetra:trident_scroll" | "meed:ars_nouveau/bounce" | "refinedstorage:pattern_grid/black_pattern_grid" | "biomancy:bio_forging/thorn_shield" | "biomancy:decomposing/flint" | "minecraft:spruce_chest_boat" | "create:deploying/waxed_oxidized_cut_copper_slab_from_adding_wax" | "create:cutting/spruce_log" | "legendary_monsters:ancient_dripstone_tile_wall_stonecutter_adbr" | "quark:building/crafting/vertslabs/myalite_vertical_slab_revert" | "create:milling/compat/regions_unexplored/green_snowbelle" | "born_in_chaos_v1:soul_saber_k" | "quark:world/crafting/woodsets/azalea/ladder" | "quark:building/stonecutting/vertslabs/red_sandstone_vertical_slab_stonecutter" | "minecraft:golden_axe" | "farmersdelight:sweet_berry_cheesecake_from_slices" | "legendary_monsters:ancient_dripstone_tile_wall_stonecutter_adp" | "create:milling/compat/botania/green_petal" | "quark:world/crafting/panes/orange_corundum" | "create:small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "biomancy:decomposing/poisonous_potato" | "quark:building/crafting/vertplanks/vertical_jungle_planks" | "create:crushing/compat/byg/ametrine_ore" | "quark:world/crafting/slabs/granite_bricks_slab" | "jerotesvillage:cooked_abyssaler_from_campfire_cooking" | "born_in_chaos_v1:icy_sweetness_craft" | "biomancy:crafting/flesh_wall" | "biomancy:decomposing/dead_fire_coral" | "jerotesvillage:serpon_chestplate_craft" | "jerotesvillage:cut_purple_sandstone_craft" | "create:small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:crafting/kinetics/magenta_seat" | "prefab:compressed_stone" | "biomancy:stonecutting/smooth_primal_flesh_from_primal_flesh" | "quark:building/stonecutting/stonevariants/jasper_bricks_stairs_rough_stonecutting" | "biomancy:bio_forging/cobweb" | "minecraft:snow" | "refinedstorage:machine_casing" | "create:cutting/compat/biomesoplenty/hellbark_wood" | "functionalstorage:linking_tool" | "jerotesvillage:wonderland_button_craft" | "create:crafting/kinetics/brown_seat" | "create:cut_crimsite_brick_slab_recycling" | "refinedstorage:coloring_recipes/red_wireless_transmitter" | "create:small_asurine_brick_slab_recycling" | "legendary_monsters:blastproof_helmet" | "cataclysm:blazing_grips" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "refinedstorage:coloring_recipes/light_gray_crafter_manager" | "cataclysm:abyssal_sacrifice" | "farmersdelight:cutting/azure_bluet" | "create:cutting/compat/blue_skies/stripped_dusk_wood" | "quark:building/crafting/slabs/white_shingles_slab" | "create:cutting/compat/regions_unexplored/palm_log" | "art_of_forging:forged_platform_slab" | "jerotes:netherite_spear_smith" | "biomancy:decomposing/porous_primal_flesh_wall" | "create:milling/compat/regions_unexplored/cactus_flower" | "quark:building/crafting/vertslabs/red_sandstone_vertical_slab" | "biomancy:decomposing/ochre_froglight" | "farmersdelight:integration/create/milling/wild_carrots" | "quark:building/crafting/slabs/polished_calcite_slab" | "sophisticatedcore:upgrade_clear" | "create:splashing/crushed_raw_copper" | "minecraft:emerald_from_smelting_emerald_ore" | "quark:building/stonecutting/stonevariants/polished_tuff_stairs_stonecutter2" | "quark:building/crafting/panes/paper_wall" | "create:crafting/appliances/copper_diving_boots" | "quark:building/crafting/walls/tuff_wall" | "tetra:hammer/jungle" | "waystones:lime_sharestone" | "quark:building/crafting/vertslabs/shale_bricks_vertical_slab" | "quark:tweaks/blasting/raw_gold_block_blast" | "farmersdelight:integration/immersiveengineering/crusher/rice_panicle" | "lendersdelight:cook/cooked_netherite_monstrosity_meat" | "create:crafting/kinetics/sail_framefrom_conversion" | "farmersdelight:mixed_salad" | "quark:tools/smithing/flamerang_smithing" | "create:crushing/wool" | "create:crimson_window" | "farmersdelight:cutting/chicken" | "netherexp:skeleton_skull_candle" | "farmersdelight:cutting/cooked_cod" | "minecraft:white_concrete_powder" | "minecraft:yellow_terracotta" | "create:cutting/mangrove_log" | "netherexp:soul_slate_bricks" | "quark:building/crafting/slabs/green_shingles_slab" | "quark:building/crafting/vertslabs/stone_brick_vertical_slab_revert" | "refinedstorage:coloring_recipes/green_controller" | "sophisticatedbackpacks:blasting_upgrade" | "minecraft:cherry_boat" | "jerotesvillage:serpon_signal_bullet_craft" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "biomancy:crafting/ornate_flesh_slab" | "create:small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "refinedstorage:256k_fluid_storage_part" | "quark:building/stonecutting/vertslabs/polished_granite_vertical_slab2_stonecutter" | "jerotes:golden_spear_craft" | "create:deploying/waxed_weathered_copper_shingles_from_adding_wax" | "jerotesvillage:villager_metal_chestplate_craft" | "create:crafting/kinetics/schedule" | "create:milling/compat/regions_unexplored/yellow_snowbelle" | "quark:building/crafting/vertslabs/raw_gold_bricks_vertical_slab_revert" | "quark:building/crafting/vertslabs/thatch_vertical_slab" | "biomancy:decomposing/potato" | "jerotesvillage:deepslate_meror_metal_ore_blast" | "create:crushing/compat/silentgems/sapphire_ore" | "create:cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "legendary_monsters:ancient_dripstone_tile_stairs" | "quark:tweaks/crafting/utility/tools/stone_shovel" | "create:cutting/compat/byg/stripped_ebony_log" | "easy_villagers:trader" | "minecraft:barrel" | "quark:building/crafting/blue_blossom_hedge" | "biomancy:bio_forging/flesh_pillar" | "jerotesvillage:bitter_cold_igloo_map_craft" | "create:cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "create:crushing/compat/elementaryores/ore_emerald_end" | "biomancy:decomposing/iron_nugget" | "create:tuff_pillar_from_stone_types_tuff_stonecutting" | "quark:world/crafting/slabs/ancient_planks_slab" | "quark:building/stonecutting/slabs/orange_shingles_slab_stonecutter2" | "farmersdelight:cutting/wild_onions" | "quark:building/stonecutting/stonevariants/diorite_bricks_vertical_slab_rough_stonecutting" | "quark:building/stonecutting/slabs/purple_shingles_slab_stonecutter2" | "quark:building/stonecutting/stonevariants/andesite_bricks_polished_stonecutting" | "create:cut_asurine_wall_from_stone_types_asurine_stonecutting" | "minecraft:deepslate_brick_slab_from_polished_deepslate_stonecutting" | "quark:building/stonecutting/vertslabs/smooth_soul_sandstone_vertical_slab_stonecutter" | "create:crafting/kinetics/speedometerfrom_conversion" | "quark:world/crafting/woodsets/ancient/wood" | "jerotesvillage:meror_metal_ingot_from_meror_blast" | "quark:building/crafting/lavender_blossom_leaf_carpet" | "minecraft:smithing_table" | "minecraft:dye_gray_carpet" | "minecraft:deepslate_tile_slab_from_polished_deepslate_stonecutting" | "quark:building/stonecutting/stairs/light_blue_shingles_stairs_stonecutter2" | "jerotesvillage:meror_metal_axe_craft" | "minecraft:shaper_armor_trim_smithing_template" | "prefab:instant_bridge" | "legendary_monsters:polished_diorite_pillar_stonecutter" | "jerotesvillage:meror_metal_shovel_craft" | "biomancy:digesting/nutrient_paste_from_moss_block" | "minecraft:cauldron" | "create:cutting/compat/byg/stripped_blue_enchanted_wood" | "create:cutting/compat/windswept/stripped_chestnut_log" | "quark:building/stonecutting/stonevariants/tuff_bricks_slab_rough_stonecutting" | "create:polished_cut_calcite_slab" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "create:cutting/compat/regions_unexplored/stripped_brimwood_log" | "quark:world/crafting/panes/violet_corundum_pane" | "quark:building/stonecutting/vertslabs/mossy_stone_brick_vertical_slab_stonecutter" | "meed:purity" | "minecraft:cobblestone_slab" | "create:oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "create:cutting/compat/byg/cypress_log" | "sophisticatedbackpacks:refill_upgrade" | "minecraft:gold_ingot_from_smelting_gold_ore" | "quark:building/stonecutting/vertslabs/deepslate_brick_vertical_slab_from_cobbled_deepslate" | "minecraft:popped_chorus_fruit" | "create:cutting/compat/byg/stripped_nightshade_wood" | "refinedstorage:coloring_recipes/blue_security_manager" | "minecraft:shaper_armor_trim_smithing_template_smithing_trim" | "create:deploying/waxed_oxidized_copper_shingles_from_adding_wax" | "minecraft:chest" | "minecraft:gray_stained_glass" | "quark:building/crafting/stairs/netherrack_bricks_stairs" | "cataclysm:the_annihilator" | "quark:building/stonecutting/slabs/gray_shingles_slab_stonecutter2" | "quark:world/crafting/woodsets/ancient/ladder" | "create:cutting/compat/byg/bulbis_stem" | "quark:tweaks/blasting/raw_iron_block_blast" | "quark:building/crafting/lamps/blue_corundum_lamp" | "jerotesvillage:golden_bright_melon_crate_by_gold_craft" | "refinedstorage:coloring_recipes/lime_security_manager" | "create:cutting/compat/botania/glimmering_dreamwood_log" | "minecraft:creeper_banner_pattern" | "pasterdream:crafting_40" | "pasterdream:crafting_42" | "pasterdream:crafting_41" | "pasterdream:crafting_44" | "minecraft:red_bed" | "pasterdream:crafting_43" | "refinedstorage:coloring_recipes/gray_crafter" | "pasterdream:crafting_46" | "create:cutting/compat/twilightforest/stripped_mining_wood" | "pasterdream:crafting_45" | "quark:world/stonecutting/walls/permafrost_wall_stonecutter" | "pasterdream:crafting_48" | "pasterdream:crafting_47" | "create:cutting/compat/quark/stripped_blossom_wood" | "pasterdream:crafting_49" | "minecraft:dye_gray_wool" | "easy_villagers:incubator" | "pasterdream:crafting_29" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "quark:building/stonecutting/slabs/raw_gold_bricks_slab_stonecutter" | "biomancy:crafting/ornate_flesh_from_slabs" | "jerotesvillage:mysterest_perfume_from_smoking" | "cataclysm:weapon_infusion/ignitium_elytra_chestplate" | "create:compacting/granite_from_flint" | "quark:building/crafting/vertslabs/wax/waxed_exposed_cut_copper_vertical_slab_hc" | "quark:building/stonecutting/stairs/dripstone_block_stairs_stonecutter" | "create:cutting/compat/byg/bulbis_wood" | "pasterdream:crafting_31" | "pasterdream:crafting_30" | "pasterdream:crafting_33" | "biomancy:stonecutting/porous_primal_flesh_wall_from_porous_primal_flesh" | "pasterdream:crafting_32" | "create:cutting/compat/byg/maple_log" | "pasterdream:crafting_35" | "quark:building/crafting/slabs/dirt_bricks_slab" | "farmersdelight:cooked_cod_slice_from_campfire_cooking" | "pasterdream:crafting_34" | "pasterdream:crafting_37" | "pasterdream:crafting_36" | "create:copper_ladder_from_ingots_copper_stonecutting" | "pasterdream:crafting_39" | "minecraft:end_stone_brick_slab_from_end_stone_stonecutting" | "pasterdream:crafting_38" | "pasterdream:crafting_19" | "create:cutting/compat/upgrade_aquatic/driftwood_log" | "pasterdream:crafting_18" | "quark:building/stonecutting/vertslabs/brown_shingles_vertical_slab_stonecutter" | "jerotesvillage:villager_metal_boots_craft" | "cataclysm:stonecutting/obsidian_brick_stairs_from_stonecutting" | "lendersdelight:cook/fried_abyssal_egg" | "create:cutting/stripped_birch_log" | "biomancy:decomposing/tropical_fish" | "quark:tweaks/crafting/light_gray_glass" | "quark:building/stonecutting/vertslabs/raw_gold_bricks_vertical_slab_stonecutter" | "jerotesvillage:ruin_stone_brick_slab_from_ruin_stone_bricks_stonecutting" | "minecraft:iron_boots" | "transmog:transmogrification_table" | "pasterdream:crafting_20" | "pasterdream:crafting_22" | "pasterdream:crafting_21" | "minecraft:golden_chestplate" | "pasterdream:crafting_24" | "pasterdream:crafting_23" | "refinedstorage:64k_fluid_storage_disk_from_storage_housing" | "pasterdream:crafting_26" | "biomancy:decomposing/raw_azure_neodymium" | "sophisticatedbackpacks:chipped/carpenters_table_upgrade" | "minecraft:copper_ingot_from_smelting_raw_copper" | "pasterdream:crafting_25" | "biomancy:digesting/nutrient_paste_from_small_dripleaf" | "quark:world/stonecutting/walls/shale_wall_stonecutter" | "pasterdream:crafting_28" | "pasterdream:crafting_27" | "farmersdelight:integration/create/filling/chocolate_pie" | "create:cutting/compat/byg/lament_log" | "waystones:green_sharestone" | "minecraft:netherite_ingot" | "farmersdelight:warped_cabinet" | "meed:biomancy/withdrawal" | "biomancy:crafting/dirt_from_stone_powder" | "create:crushing/compat/byg/blue_nether_gold_ore" | "quark:building/stonecutting/vertslabs/permafrost_bricks_vertical_slab_stonecutter" | "cataclysm:abyss_eye" | "refinedstorage:fluid_grid/pink_fluid_grid" | "quark:building/stonecutting/stairs/rusty_iron_plate_stairs_stonecutter" | "refinedstorage:coloring_recipes/green_disk_manipulator" | "pasterdream:crafting_11" | "quark:building/crafting/bamboo_post" | "pasterdream:crafting_10" | "pasterdream:crafting_13" | "pasterdream:crafting_12" | "pasterdream:crafting_15" | "pasterdream:crafting_14" | "jerotesvillage:wonderland_wood_craft" | "pasterdream:crafting_17" | "jerotesvillage:iron_nugget_from_animated_smelt" | "pasterdream:crafting_16" | "minecraft:light_blue_terracotta" | "quark:building/crafting/shingles/light_blue_shingles_dye" | "create:cutting/compat/botania/glimmering_livingwood_log" | "minecraft:spruce_stairs" | "sophisticatedbackpacks:auto_blasting_upgrade_from_auto_smelting_upgrade" | "quark:building/crafting/vertplanks/vertical_cherry_planks_revert" | "born_in_chaos_v1:sharpened_darketal_sword_k" | "minecraft:jungle_sign" | "minecraft:cyan_candle" | "create:deploying/waxed_cut_copper_from_adding_wax" | "pasterdream:crafting_80" | "create:cutting/compat/atmospheric/yucca_wood" | "pasterdream:crafting_82" | "pasterdream:crafting_81" | "biomancy:digesting/nutrient_paste_from_curly_fern" | "pasterdream:crafting_84" | "pasterdream:crafting_83" | "pasterdream:crafting_86" | "pasterdream:crafting_85" | "pasterdream:crafting_88" | "pasterdream:crafting_87" | "pasterdream:crafting_89" | "create:blasting/silver_ingot_compat_galosphere" | "minecraft:light_gray_dye_from_white_tulip" | "create:splashing/byg/cryptic_magma_block" | "quark:building/stonecutting/stonevariants/diorite_bricks_slab_rough_stonecutting" | "create:cutting/compat/blue_skies/bluebright_log" | "quark:building/stonecutting/stonevariants/chiseled_myalite_bricks_stonecutter" | "jerotesvillage:pink_slime_block_craft" | "create:crafting/kinetics/whisk" | "functionalstorage:copper_upgrade" | "create:crafting/kinetics/mechanical_drill" | "create:cutting/compat/quark/azalea_log" | "create:polished_cut_scoria_wall" | "create:cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "pasterdream:crafting_71" | "pasterdream:crafting_70" | "pasterdream:crafting_73" | "pasterdream:crafting_72" | "born_in_chaos_v1:spiritual_gingerbread_craft" | "pasterdream:crafting_75" | "pasterdream:crafting_74" | "create:cutting/compat/autumnity/sappy_maple_log" | "art_of_forging:demonic_blade" | "pasterdream:crafting_77" | "pasterdream:crafting_76" | "pasterdream:crafting_79" | "create:cutting/compat/twilightforest/twilight_oak_log" | "pasterdream:crafting_78" | "sophisticatedbackpacks:deposit_upgrade" | "minecraft:light_gray_dye_from_black_white_dye" | "create:polished_cut_ochrum_wall" | "sophisticatedbackpacks:blasting_upgrade_from_smelting_upgrade" | "minecraft:slime_block" | "meed:soulsweapons/magic_resistance" | "functionalstorage:storage_controller" | "pasterdream:crafting_60" | "pasterdream:crafting_62" | "pasterdream:crafting_61" | "create:copycat_panel_from_ingots_zinc_stonecutting" | "pasterdream:crafting_64" | "create:cut_calcite_from_stone_types_calcite_stonecutting" | "minecraft:cooked_rabbit_from_campfire_cooking" | "pasterdream:crafting_63" | "pasterdream:crafting_66" | "pasterdream:crafting_65" | "pasterdream:crafting_68" | "pasterdream:crafting_67" | "pasterdream:crafting_69" | "minecraft:mud_bricks" | "refinedstorage:coloring_recipes/purple_grid" | "minecraft:netherite_upgrade_smithing_template" | "biomancy:decomposing/biomesoplenty_eyebulb" | "quark:building/crafting/compressed/golden_carrot_crate_uncompress" | "quark:building/stonecutting/stairs/yellow_shingles_stairs_stonecutter2" | "legendary_monsters:shulker_shield" | "quark:building/crafting/raw_copper_bricks" | "minecraft:mud_brick_stairs_from_mud_bricks_stonecutting" | "quark:building/crafting/compressed/glowberry_sack" | "quark:building/stonecutting/vertslabs/permafrost_bricks_vertical_slab_stonecutter2" | "pasterdream:crafting_51" | "pasterdream:crafting_50" | "pasterdream:crafting_53" | "quark:tools/smithing/rune_smithing_yellow" | "pasterdream:crafting_52" | "pasterdream:crafting_55" | "create:splashing/endergetic/petrified_overworld_corrock_block" | "pasterdream:crafting_54" | "pasterdream:crafting_57" | "pasterdream:crafting_56" | "pasterdream:crafting_59" | "create:crushing/raw_nickel_block" | "pasterdream:crafting_58" | "create:polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:cutting/compat/regions_unexplored/stripped_pink_bioshroom_hyphae" | "protection_pixel:hrcsheetloot" | "netherexp:stonecutting/from_soul_slate/soul_slate_stairs" | "quark:tweaks/crafting/utility/misc/easy_sticks" | "create:small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "jerotesvillage:drought_fire_bricks_craft" | "jerotesvillage:ruin_stone_brick_stairs_from_ruin_stone_bricks_stonecutting" | "jerotesvillage:sun_sandstone_stairs_craft" | "minecraft:light_gray_carpet" | "minecraft:magenta_stained_glass_pane_from_glass_pane" | "minecraft:smooth_sandstone" | "create:splashing/green_concrete_powder" | "create:splashing/endergetic/petrified_end_corrock_crown" | "legendary_monsters:guard_summoner" | "create:splashing/endergetic/petrified_nether_corrock_crown" | "create:polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "meed:tombstone/reach" | "minecraft:diorite_wall" | "waystones:purple_sharestone" | "minecraft:spruce_planks" | "quark:automation/crafting/iron_rod_pre_end" | "quark:building/crafting/vertplanks/vertical_birch_planks_revert" | "farmersdelight:cutting/dark_oak_hanging_sign" | "quark:building/crafting/stripped_birch_post" | "jerotesvillage:hag_replacement/minecraft_tnt" | "minecraft:polished_blackstone_bricks" | "minecraft:mossy_cobblestone_from_moss_block" | "biomancy:decomposing/sea_pig" | "meed:ars_nouveau/magic_find" | "create:crushing/compat/byg/brimstone_nether_gold_ore" | "create:small_granite_brick_stairs" | "jerotesvillage:transport_spear_craft" | "art_of_forging:shockwave_chamber" | "minecraft:lantern" | "refinedstorage:speed_upgrade" | "quark:building/crafting/hollowlogs/hollow_jungle_log" | "minecraft:waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "quark:building/stonecutting/stonevariants/andesite_bricks_wall_polished_stonecutting" | "create:polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "quark:building/crafting/vertslabs/brick_vertical_slab" | "refinedstorage:coloring_recipes/black_pattern_grid" | "jerotesvillage:debilitated_tablet_craft" | "quark:building/crafting/cherry_bookshelf" | "quark:building/crafting/stripped_cherry_post" | "create:cutting/compat/byg/willow_wood" | "quark:building/stonecutting/stonevariants/calcite_bricks_slab_rough_stonecutting" | "minecraft:deepslate_brick_wall" | "quark:building/stonecutting/stairs/orange_shingles_stairs_stonecutter2" | "quark:building/stonecutting/stairs/iron_plate_stairs_stonecutter" | "quark:world/crafting/woodsets/blossom/planks" | "create:crafting/kinetics/shaft" | "tetra:diamond" | "biomancy:decomposing/blaze_rod" | "create:small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "create:item_application/andesite_casing_from_log" | "quark:world/stonecutting/polished_limestone_stonecutter" | "netherexp:stonecutting/from_stacked_bones/stacked_bone_stairs" | "biomancy:decomposing/nether_sprouts" | "cataclysm:smithing/ignitium_boots" | "quark:building/stonecutting/vertslabs/tuff_vertical_slab_stonecutter" | "pasterdream:crafting_91" | "minecraft:lime_bed" | "pasterdream:crafting_90" | "pasterdream:crafting_93" | "quark:building/crafting/compressed/bonded_leather" | "pasterdream:crafting_92" | "farmersdelight:rice_from_bag" | "pasterdream:crafting_95" | "pasterdream:crafting_94" | "pasterdream:crafting_97" | "pasterdream:crafting_96" | "pasterdream:crafting_99" | "titanium:test_serializer/dirt_to_used" | "pasterdream:crafting_98" | "create:cutting/compat/silentgear/stripped_netherwood_log" | "quark:building/crafting/lamps/yellow_crystal_lamp" | "refinedstorage:coloring_recipes/blue_detector" | "quark:building/crafting/walls/blue_nether_bricks_wall" | "refinedstorage:coloring_recipes/lime_controller" | "create:blasting/zinc_ingot_from_ore" | "create:haunting/soul_soil" | "farmersdelight:flint_knife" | "cataclysm:stonecutting/polished_end_stone_stairs_from_stonecutting" | "minecraft:cherry_chest_boat" | "quark:world/crafting/slabs/shale_bricks_slab" | "create:polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "waystones:sharestone" | "create:cutting/compat/biomesoplenty/stripped_mahogany_wood" | "create:splashing/thermal/crushed_raw_lead" | "protection_pixel:buoyancyloot" | "protection_pixel:armorkit" | "quark:building/stonecutting/vertslabs/lime_shingles_vertical_slab_stonecutter2" | "jerotesvillage:villager_metal_basein_craft" | "refinedstorage:coloring_recipes/yellow_network_transmitter" | "create:crafting/kinetics/steam_whistle" | "cataclysm:azure_seastone_pillar" | "quark:building/stonecutting/stonevariants/chiseled_diorite_bricks_stonecutter" | "create:cutting/compat/regions_unexplored/stripped_green_bioshroom_stem" | "create:milling/tall_grass" | "quark:building/stonecutting/vertslabs/andesite_vertical_slab_stonecutter" | "biomancy:bio_forging/piglin_head" | "biomancy:decomposing/ghast_tear" | "create:polished_cut_scorchia_slab_recycling" | "quark:building/crafting/chests/mixed_chest" | "minecraft:magenta_dye_from_purple_and_pink" | "minecraft:purpur_pillar" | "quark:building/crafting/vertslabs/brown_shingles_vertical_slab" | "biomancy:digesting/nutrient_paste_from_weeping_vines" | "create:deploying/waxed_oxidized_copper_from_adding_wax" | "quark:building/stonecutting/vertslabs/granite_bricks_vertical_slab_stonecutter" | "quark:building/stonecutting/lime_shingles_stonecutter2" | "quark:building/stonecutting/stonevariants/granite_bricks_slab_polished_stonecutting" | "minecraft:redstone_lamp" | "jerotesvillage:refine_meror_metal_ingot_craft" | "biomancy:digesting/nutrient_paste_from_fern_thatch" | "quark:world/stonecutting/slabs/jasper_bricks_slab_stonecutter" | "minecraft:end_rod" | "biomancy:stonecutting/fibrous_flesh_wall_from_fibrous_flesh" | "netherexp:will_o_wisp" | "create:smelting/ingot_uranium_compat_immersiveengineering" | "minecraft:iron_ingot_from_blasting_iron_ore" | "jerotesvillage:villager_metal_axe_craft" | "biomancy:digesting/nutrient_paste_from_wheat" | "jerotesvillage:villager_metal_base_smith" | "quark:building/stonecutting/stairs/smooth_soul_sandstone_stairs_stonecutter" | "farmersdelight:cutting/cod" | "jerotesvillage:cooked_meganose_snow_lizard_meat_from_campfire_cooking" | "create:polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "quark:building/stonecutting/vertslabs/polished_jasper_vertical_slab_stonecutter" | "born_in_chaos_v1:cultivated_pumpkin_k" | "jerotesvillage:purple_sandstone_stairs_craft" | "create:polished_cut_veridium_slab_recycling" | "quark:tools/smithing/rune_smithing_gray" | "quark:building/crafting/vertslabs/prismarine_brick_vertical_slab_revert" | "quark:building/stonecutting/stairs/purple_shingles_stairs_stonecutter2" | "create:milling/compat/byg/purple_rose" | "farmersdelight:cutting/dark_oak_log" | "cataclysm:stonecutting/chiseled_obsidian_bricks_from_stonecutting" | "biomancy:decomposing/porkchop" | "minecraft:acacia_boat" | "jerotesvillage:carved_brick_wall_from_carved_bricks_stonecutting" | "quark:building/crafting/stairs/polished_calcite_stairs" | "quark:building/crafting/crimson_post" | "jerotesvillage:wooden_slingshot_craft" | "refinedstorage:exporter" | "refinedstorage:security_manager" | "quark:building/crafting/chests/warped_chest_trapped" | "farmersdelight:magenta_canvas_sign" | "minecraft:dye_blue_bed" | "create:milling/bone" | "create:scoria_pillar_from_stone_types_scoria_stonecutting" | "create:polished_cut_dripstone_stairs" | "meed:alexscaves/stunned" | "quark:building/crafting/sakura_paper_wall" | "quark:building/crafting/vertslabs/smooth_soul_sandstone_vertical_slab" | "quark:building/crafting/vertslabs/jungle_vertical_slab_revert" | "biomancy:decomposing/enchanted_golden_apple" | "quark:building/crafting/vertslabs/myalite_bricks_vertical_slab_revert" | "minecraft:painting" | "farmersdelight:cutting/wild_potatoes" | "netherexp:blue_nether_brick_wall" | "lendersdelight:cook/cooked_lionfish_from_campfire_cooking" | "refinedstorage:improved_processor" | "create:cutting/compat/ecologics/stripped_walnut_wood" | "quark:building/stonecutting/stonevariants/calcite_bricks_vertical_slab_rough_stonecutting" | "minecraft:dark_oak_wood" | "create:crafting/kinetics/blue_seat_from_other_seat" | "quark:world/crafting/woodsets/ancient/stripped_wood" | "create:small_ochrum_brick_slab_recycling" | "quark:building/crafting/raw_iron_bricks_revert" | "biomancy:digesting/nutrient_paste_from_nether_wart_block" | "farmersdelight:cutting/birch_hanging_sign" | "jerotesvillage:dye_from_hearsay_grass" | "refinedstorage:coloring_recipes/lime_pattern_grid" | "minecraft:stone_brick_slab_from_stone_stonecutting" | "farmersdelight:integration/create/milling/wild_potatoes" | "quark:building/crafting/stonevariants/diorite_bricks" | "tetra:stonecutter" | "cataclysm:stonecutting/polished_end_stone_from_stonecutting" | "quark:building/crafting/vertslabs/deepslate_tile_vertical_slab_revert" | "create:deploying/waxed_weathered_copper_shingle_stairs_from_adding_wax" | "create:crafting/materials/andesite_alloy_block" | "quark:building/crafting/stairs/purple_shingles_stairs" | "jerotesvillage:cooked_sun_crab_from_smoking" | "netherexp:soul_slate_stairs" | "create:cutting/compat/byg/redwood_wood" | "minecraft:oak_trapdoor" | "create:cutting/compat/architects_palette/stripped_twisted_log" | "quark:dye_item" | "jerotesvillage:hag_replacement/minecraft_red_sand" | "create:crafting/kinetics/pink_seat_from_other_seat" | "create:cutting/compat/hexcasting/edified_log" | "jerotesvillage:black_yellow_door_craft" | "minecraft:waxed_cut_copper_slab_from_honeycomb" | "create:crafting/kinetics/placard" | "minecraft:birch_button" | "farmersdelight:grilled_salmon" | "netherexp:stacked_wither_bone_stairs" | "biomancy:decomposing/glow_berries" | "refinedstorage:coloring_recipes/green_relay" | "create:crushing/diamond_horse_armor" | "jerotesvillage:cooked_rambler_meat" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "quark:building/crafting/chests/mangrove_chest" | "minecraft:cyan_bed" | "netherexp:stacked_bone_slab" | "netherexp:stonecutting/from_netherrack_bricks/netherrack_brick_wall" | "jerotes:giant_beast_armor_base_craft" | "cataclysm:chiseled_seastone" | "jerotesvillage:hag_replacement/minecraft_lapis_block" | "quark:building/crafting/stairs/lime_shingles_stairs" | "quark:building/stonecutting/stairs/blue_shingles_stairs_stonecutter" | "create:pressing/compat/betterendforge/shadow_grass_path" | "create:crafting/kinetics/white_valve_handle_from_other_valve_handle" | "biomancy:stonecutting/smooth_primal_flesh_slab_from_smooth_primal_flesh" | "cataclysm:azure_seastone_brick_wall" | "quark:building/crafting/vertplanks/vertical_jungle_planks_revert" | "functionalstorage:pusher_upgrade" | "farmersdelight:integration/immersiveengineering/squeezer/cabbage_seeds" | "refinedstorage:block_of_quartz_enriched_iron" | "quark:building/crafting/vertslabs/prismarine_vertical_slab_revert" | "create:crafting/kinetics/crafter_slot_cover" | "waystones:gray_sharestone" | "prefab:chiseled_quartz_crete" | "create:crafting/materials/brass_ingot_from_decompacting" | "create:crushing/compat/silentgems/kyanite_ore" | "quark:building/stonecutting/slabs/green_shingles_slab_stonecutter" | "quark:building/stonecutting/stonevariants/dripstone_bricks_stairs_polished_stonecutting" | "farmersdelight:chocolate_pie" | "refinedstorage:coloring_recipes/light_gray_relay" | "quark:building/crafting/slabs/raw_copper_bricks_slab" | "quark:building/crafting/chests/dark_oak_trapped_chest" | "biomancy:decomposing/cake" | "cataclysm:azure_sea_shield" | "create:small_limestone_brick_slab_recycling" | "jerotesvillage:qoaiku_chestplate_craft" | "minecraft:orange_stained_glass_pane" | "prefab:swift_blade_gold" | "minecraft:brick" | "quark:building/crafting/stonevariants/andesite_bricks" | "netherexp:burning_skull_block" | "quark:world/stonecutting/slabs/polished_calcite_slab_stonecutter2" | "protection_pixel:ironplate" | "minecraft:music_disc_5" | "quark:building/stonecutting/stonevariants/limestone_bricks_slab_polished_stonecutting" | "quark:building/stonecutting/stonevariants/dripstone_bricks_polished_stonecutting" | "minecraft:coal" | "quark:building/crafting/stairs/raw_gold_bricks_stairs" | "minecraft:gold_ingot_from_blasting_deepslate_gold_ore" | "quark:building/crafting/vertslabs/polished_blackstone_vertical_slab" | "create:cutting/compat/atmospheric/stripped_aspen_wood" | "create:cutting/compat/byg/stripped_cypress_log" | "netherexp:stonecutting/from_basalt/basalt_wall" | "create:cutting/compat/biomesoplenty/stripped_fir_wood" | "create:cutting/compat/byg/baobab_wood" | "create:filling/blaze_cake" | "quark:building/crafting/vertslabs/shingles_vertical_slab_revert" | "minecraft:smoker" | "refinedstorage:coloring_recipes/cyan_crafter_manager" | "create:splashing/iceandfire/crushed_raw_silver" | "refinedstorage:coloring_recipes/gray_controller" | "create:cutting/compat/byg/baobab_log" | "quark:building/stonecutting/slabs/white_shingles_slab_stonecutter" | "create:copycat_step_from_ingots_zinc_stonecutting" | "create:polished_cut_scorchia_wall" | "quark:building/crafting/slabs/raw_iron_bricks_slab" | "create:deploying/waxed_weathered_copper_tile_slab_from_adding_wax" | "create:cutting/compat/forbidden_arcanus/stripped_aurum_log" | "jerotesvillage:giant_monster_leggings_craft" | "sophisticatedbackpacks:iron_backpack" | "create:andesite_ladder_from_andesite_alloy_stonecutting" | "create:crafting/kinetics/smart_chute" | "create:cutting/compat/ecologics/walnut_wood" | "minecraft:brown_dye" | "minecraft:waxed_exposed_cut_copper_stairs_from_honeycomb" | "minecraft:brick_slab" | "farmersdelight:cutting/clay" | "jerotesvillage:drought_fire_brick_stairs_craft" | "quark:building/crafting/vertslabs/jasper_bricks_vertical_slab_revert" | "create:deploying/waxed_exposed_copper_shingle_stairs_from_adding_wax" | "minecraft:bricks" | "minecraft:red_sandstone_slab" | "quark:tweaks/crafting/utility/chests/acacia_chest_wood" | "quark:world/crafting/panes/blue_corundum" | "minecraft:yellow_glazed_terracotta" | "quark:building/crafting/vertslabs/cut_copper_vertical_slab" | "quark:building/stonecutting/vertslabs/shale_vertical_slab_stonecutter" | "biomancy:decomposing/shulker_shell" | "create:polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:auto_smoking_upgrade_from_auto_smelting_upgrade" | "biomancy:decomposing/wither_skeleton_skull" | "jerotesvillage:villager_block_chef_craft" | "minecraft:exposed_cut_copper" | "meed:born_in_chaos_v1/cursed_mark" | "farmersdelight:cutting/cherry_wood" | "minecraft:dark_oak_stairs" | "minecraft:jungle_pressure_plate" | "farmersdelight:honey_glazed_ham_block" | "minecraft:host_armor_trim_smithing_template" | "create:cut_veridium_brick_slab_recycling" | "minecraft:smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "quark:building/crafting/raw_copper_bricks_revert" | "jerotesvillage:bright_cobblestone_stairs_craft" | "prefab:grassy_plains" | "meed:magnetized" | "refinedstorage:coloring_recipes/green_detector" | "quark:world/crafting/slabs/limestone_slab" | "farmersdelight:orange_hanging_canvas_sign" | "quark:world/stonecutting/slabs/polished_limestone_slab_stonecutter2" | "minecraft:blue_banner" | "jerotesvillage:blamer_robe_craft" | "quark:tweaks/blasting/raw_copper_block_blast" | "quark:building/crafting/stairs/midori_block_stairs" | "quark:world/crafting/stairs/limestone_bricks_stairs" | "meed:symbiosis" | "create:crushing/leather_horse_armor" | "create:crushing/compat/silentgems/ammolite_ore" | "minecraft:glowstone" | "create:copper_tile_slab" | "quark:mobs/smelting/cooked_crab_leg" | "create:crushing/nether_quartz_ore" | "farmersdelight:integration/immersiveengineering/squeezer/tomato_seeds" | "quark:building/crafting/hollowlogs/hollow_crimson_stem" | "biomancy:decomposing/player_head" | "minecraft:vex_armor_trim_smithing_template_smithing_trim" | "create:cut_deepslate_brick_stairs" | "minecraft:red_nether_brick_wall" | "create:small_crimsite_brick_stairs" | "minecraft:chiseled_red_sandstone" | "farmersdelight:fried_egg" | "create:cutting/compat/twilightforest/stripped_time_wood" | "born_in_chaos_v1:solsendk" | "meed:born_in_chaos_v1/myiasis" | "create:filling/gunpowder" | "quark:building/crafting/vertslabs/prismarine_brick_vertical_slab" | "create:cutting/compat/biomesoplenty/mahogany_wood" | "jerotesvillage:piglin_golden_fire_craft" | "born_in_chaos_v1:black_argillite_brick_st_k" | "biomancy:digesting/nutrient_paste_from_platypus_egg" | "create:polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "biomancy:decomposing/shark_tooth" | "minecraft:light_gray_candle" | "quark:building/stonecutting/stonevariants/shale_bricks_vertical_slab_polished_stonecutting" | "jerotesvillage:qoaiku_dagger_craft" | "prefab:double_compressed_glowstone_from_compressed_glowstone" | "minecraft:cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "create:crafting/kinetics/belt_connector" | "jerotesvillage:saddle_by_rambler_leather_craft" | "quark:building/crafting/spruce_post" | "prefab:dirt_slab_reverse" | "minecraft:dye_lime_carpet" | "born_in_chaos_v1:intoxicating_dagger_k" | "farmersdelight:cooking/tomato_sauce" | "farmersdelight:fruit_salad" | "netherexp:nightspores" | "quark:building/crafting/stripped_azalea_post" | "create:milling/compat/byg/yellow_daffodil" | "netherexp:pump_charge_upgrade_smithing_template" | "create:cutting/compat/blue_skies/stripped_dusk_log" | "biomancy:decomposing/corrodent_teeth" | "minecraft:deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "netherexp:stacked_wither_bones" | "create:cutting/compat/environmental/cherry_wood" | "netherexp:stonecutting/from_soul_slate_bricks/etched" | "art_of_forging:endsteel_ingot" | "minecraft:sea_lantern" | "create:weathered_copper_tile_slab" | "meed:netherexp/unbounded_speed" | "biomancy:digesting/nutrient_paste_from_big_dripleaf" | "farmersdelight:cutting/oak_hanging_sign" | "prefab:dark_light_lamp" | "jerotesvillage:hag_replacement/jerotesvillage_ruin_stone_brick_wall" | "create:cutting/compat/regions_unexplored/stripped_brimwood_wood" | "meed:ars_nouveau/looting" | "create:milling/sandstone" | "minecraft:diamond_hoe" | "farmersdelight:tomato_seeds" | "farmersdelight:cutting/dark_oak_sign" | "minecraft:dye_cyan_wool" | "born_in_chaos_v1:fused_bone_k" | "netherexp:smokestalk_trapdoor" | "quark:world/stonecutting/stairs/calcite_bricks_stairs_stonecutter" | "farmersdelight:cutting/allium" | "refinedstorage:coloring_recipes/brown_disk_manipulator" | "create:polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "minecraft:weathered_cut_copper" | "jerotesvillage:qoaiku_knife_craft" | "create:cutting/compat/tconstruct/stripped_bloodshroom_wood" | "jerotesvillage:guidelines_for_the_craft_of_the_second_rounder_gem_craft" | "create:cutting/compat/silentgear/netherwood_log" | "biomancy:digesting/nutrient_paste_from_fiddlehead" | "create:cutting/compat/atmospheric/kousa_log" | "create:cutting/compat/biomesoplenty/palm_log" | "biomancy:decomposing/slime_block" | "create:polished_cut_limestone_stairs" | "waystones:end_stone_waystone" | "create:deploying/waxed_exposed_copper_shingles_from_adding_wax" | "jerotesvillage:bright_melon_crate_craft" | "minecraft:end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "minecraft:dye_pink_carpet" | "minecraft:leather" | "create:polished_cut_ochrum_stairs" | "refinedstorage:coloring_recipes/cyan_disk_manipulator" | "quark:building/stonecutting/stonevariants/shale_bricks_stairs_polished_stonecutting" | "refinedstorage:coloring_recipes/light_gray_crafter" | "create:smelting/ingot_aluminum_compat_immersiveengineering" | "quark:building/stonecutting/stairs/purple_shingles_stairs_stonecutter" | "minecraft:waxed_cut_copper_stairs_from_honeycomb" | "quark:building/stonecutting/stonevariants/diorite_bricks_wall_polished_stonecutting" | "create:cut_diorite_slab" | "jerotesvillage:slavery_supervisor_upgrade_smithing_template_craft" | "refinedstorage:coloring_recipes/green_pattern_grid" | "create:cut_diorite_brick_slab_recycling" | "minecraft:dye_brown_bed" | "sophisticatedbackpacks:gold_backpack" | "quark:world/stonecutting/stairs/calcite_stairs_stonecutter" | "jerotesvillage:qoaiku_hoe_craft" | "quark:building/crafting/compressed/golden_apple_crate" | "minecraft:stone_brick_wall_from_stone_bricks_stonecutting" | "refinedstorage:crafting_grid/orange_crafting_grid" | "quark:building/crafting/cherry_leaf_carpet" | "create:cutting/compat/byg/stripped_witch_hazel_wood" | "minecraft:furnace" | "biomancy:decomposing/nether_star" | "quark:building/crafting/slabs/raw_gold_bricks_slab" | "quark:building/crafting/vertslabs/polished_blackstone_brick_vertical_slab" | "quark:building/crafting/vertslabs/white_shingles_vertical_slab_revert" | "create:cutting/compat/upgrade_aquatic/driftwood" | "born_in_chaos_v1:smoldering_scorche_log_k" | "quark:oddities/crafting/backpack_no_hide" | "refinedstorage:coloring_recipes/magenta_fluid_grid" | "create:crushing/compat/elementaryores/ore_copper_nether" | "pasterdream:cooking_0" | "create:cutting/compat/goodending/cypress_wood" | "minecraft:dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "farmersdelight:cooking/fish_stew" | "create:cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:activator_rail" | "jeed:water_breathing" | "quark:building/stonecutting/stonevariants/granite_pillar_stonecutter" | "create:crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "quark:building/stonecutting/stonevariants/calcite_bricks_stairs_rough_stonecutting" | "meed:soulsweapons/posture_break" | "minecraft:crimson_pressure_plate" | "jerotesvillage:cooked_jewelroamer_from_smoking" | "quark:tweaks/crafting/utility/wool/green_wool" | "create:milling/compat/environmental/bird_of_paradise" | "quark:building/crafting/stripped_oak_post" | "quark:building/crafting/birch_hedge" | "jerotesvillage:cooked_chromasnap_bass" | "functionalstorage:mangrove_4" | "quark:world/crafting/stairs/polished_limestone_stairs" | "functionalstorage:mangrove_2" | "functionalstorage:mangrove_1" | "jerotesvillage:hag_replacement/jerotesvillage_meror_metal_ingot" | "jerotesvillage:meror_standard_chestplate_smith" | "create:veridium_pillar_from_stone_types_veridium_stonecutting" | "minecraft:cherry_stairs" | "create:cutting/compat/byg/stripped_green_enchanted_log" | "refinedstorage:pattern_grid/green_pattern_grid" | "minecraft:red_sandstone" | "create:crafting/appliances/slime_ball" | "quark:building/crafting/stairs/light_blue_shingles_stairs" | "prefab:grass_stairs_reverse" | "create:splashing/light_blue_concrete_powder" | "create:milling/compat/environmental/purple_delphinium" | "farmersdelight:cutting/warped_hanging_sign" | "create:cutting/compat/botania/stripped_livingwood_log" | "biomancy:crafting/full_flesh_door_from_flesh_door" | "cataclysm:desert_eye" | "create:crafting/kinetics/white_sailfrom_conversion" | "biomancy:crafting/nutrient_paste_from_nutrient_bar" | "meed:born_in_chaos_v1/jawattack" | "create:crafting/kinetics/cart_assembler" | "protection_pixel:heatoverlockmechanismloot" | "biomancy:stonecutting/packed_flesh_slab_from_packed_flesh" | "biomancy:decomposing/red_mushroom" | "minecraft:waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "prefab:wind_mill" | "quark:building/crafting/vertslabs/diorite_bricks_vertical_slab" | "minecraft:bamboo_fence" | "minecraft:red_glazed_terracotta" | "create:cutting/compat/twilightforest/dark_wood" | "minecraft:birch_boat" | "refinedstorage:advanced_processor" | "legendary_monsters:guard_summoner_activate" | "create:milling/compat/byg/torch_ginger" | "quark:building/stonecutting/walls/blue_nether_bricks_wall_stonecutter" | "jerotesvillage:raw_meror_metal_craft" | "legendary_monsters:ancient_dripstone_brick_stairs_stonecutter_adp" | "netherexp:spirit_armor_trim_smithing_template" | "create:cutting/compat/byg/stripped_willow_wood" | "lendersdelight:cook/cooked_netherite_monstrosity_meat_from_smoking" | "minecraft:packed_mud" | "jerotesvillage:cooked_bright_grass_carp_from_campfire_cooking" | "refinedstorage:importer" | "create:milling/compat/supplementaries/flax" | "quark:building/crafting/vertslabs/netherrack_bricks_vertical_slab_revert" | "born_in_chaos_v1:black_argillite_column_slab_k" | "minecraft:netherite_helmet_smithing" | "jerotes:stone_spear_craft" | "biomancy:decomposing/cosmic_cod" | "create:crushing/raw_gold_block" | "create:layered_calcite_from_stone_types_calcite_stonecutting" | "create:milling/compat/upgrade_aquatic/pink_searocket" | "create:cutting/compat/byg/stripped_cika_wood" | "create:crafting/kinetics/filter" | "born_in_chaos_v1:great_reaper_ax_k" | "create:crushing/compat/exnihilosequentia/crushed_diorite" | "quark:building/crafting/compressed/golden_carrot_crate" | "quark:building/stonecutting/stonevariants/jasper_bricks_stairs_polished_stonecutting" | "create:crafting/appliances/schedule_clear" | "protection_pixel:hellsnakeasloot" | "quark:building/crafting/vertslabs/soul_sandstone_vertical_slab_revert" | "create:cutting/compat/blue_skies/lunar_wood" | "quark:building/stonecutting/stonevariants/shale_bricks_polished_stonecutting" | "create:mixing/compat/ae2/fluix_crystal" | "netherexp:ancient_campfire" | "born_in_chaos_v1:scorched_planks_fence_gate_k" | "quark:world/stonecutting/walls/jasper_bricks_wall_stonecutter" | "jerotesvillage:iron_nugget_from_explorer_blast" | "quark:building/crafting/shingles/green_shingles_dye" | "jerotes:golden_war_beast_armor_craft" | "create:cutting/compat/byg/green_enchanted_wood" | "minecraft:gray_candle" | "lendersdelight:cook/cooked_coral_golem_meat_from_campfire_cooking" | "minecraft:stripped_dark_oak_wood" | "moblassos:golden_lasso" | "create:milling/red_tulip" | "biomancy:decomposing/piglin_head" | "create:asurine_pillar_from_stone_types_asurine_stonecutting" | "born_in_chaos_v1:evilometer_craft" | "prefab:swift_blade_iron" | "create:crafting/materials/brass_nugget_from_decompacting" | "jerotesvillage:bitter_cold_sign_craft" | "minecraft:birch_fence" | "biomancy:decomposing/fish_bones" | "jerotesvillage:witch_residence_map_craft" | "create:crafting/kinetics/brass_door" | "create:milling/coal" | "create:milling/compat/biomesoplenty/glowflower" | "meed:tombstone/purification" | "quark:building/crafting/slabs/cyan_shingles_slab" | "quark:building/stonecutting/blue_shingles_stonecutter2" | "farmersdelight:cooking_pot" | "biomancy:decomposing/trilocaris_tail" | "biomancy:bio_forging/flesh_slab" | "create:crafting/materials/zinc_ingot_from_compacting" | "minecraft:red_nether_brick_slab" | "quark:building/crafting/glass/black_framed_glass" | "minecraft:cooked_salmon_from_campfire_cooking" | "create:cut_crimsite_brick_slab" | "quark:building/crafting/compressed/nether_wart_block_override" | "jerotesvillage:meror_metal_arrow_craft" | "quark:building/crafting/vertplanks/vertical_dark_oak_planks_revert" | "protection_pixel:magneticloot" | "refinedstorage:1024k_fluid_storage_disk" | "create:milling/compat/byg/cyan_amaranth" | "create:crafting/kinetics/green_valve_handle_from_other_valve_handle" | "create:mixing/compat/regions_unexplored/silt_mud" | "create:cutting/compat/ars_nouveau/blue_archwood_log" | "minecraft:cut_sandstone_slab_from_cut_sandstone_stonecutting" | "minecraft:sugar_from_honey_bottle" | "minecraft:black_wool" | "tetra:deepling1" | "minecraft:spruce_fence_gate" | "quark:world/crafting/panes/green_corundum_pane" | "tetra:deepling2" | "minecraft:leather_chestplate" | "jerotesvillage:rambler_leather_craft" | "jerotesvillage:throwing_stubborn_stone_craft" | "create:milling/compat/ae2/certus_quartz" | "refinedstorage:storage_housing" | "minecraft:beehive" | "minecraft:white_stained_glass_pane_from_glass_pane" | "jerotesvillage:villager_metal_shovel_craft" | "minecraft:birch_wood" | "quark:building/crafting/birch_ladder" | "prefab:swift_blade_diamond" | "minecraft:scaffolding" | "minecraft:acacia_button" | "minecraft:polished_granite_from_granite_stonecutting" | "create:crushing/glowstone" | "cataclysm:ancient_metal_ingot_from_nuggets" | "cataclysm:mech_eye" | "jerotesvillage:cut_glitter_sandstone_slab_craft" | "create:small_asurine_brick_wall" | "minecraft:lapis_lazuli_from_smelting_deepslate_lapis_ore" | "waystones:black_sharestone" | "quark:world/crafting/woodsets/azalea/chest" | "sophisticatedbackpacks:copper_backpack" | "create:mechanical_crafting/extendo_grip" | "meed:un_werewolf" | "create:crushing/compat/simplefarming/barley" | "quark:building/crafting/dark_oak_post" | "meed:ars_nouveau/flight" | "meed:aether/remedy" | "born_in_chaos_v1:transformativeflower_k" | "quark:building/crafting/vertslabs/soul_sandstone_bricks_vertical_slab_revert" | "minecraft:andesite_slab" | "minecraft:bamboo_chest_raft" | "jerotesvillage:ruin_stone_brick_stairs_craft" | "minecraft:honey_block" | "create:cutting/compat/byg/stripped_holly_wood" | "minecraft:bamboo_planks" | "jerotesvillage:meror_metal_nugget_from_meror_blast" | "netherexp:cooking/cracked_quartz_bricks" | "farmersdelight:melon_juice" | "create:cutting/compat/byg/jacaranda_wood" | "jerotesvillage:dexterous_tablet_use_mortar_and_pestle_craft" | "create:crafting/kinetics/large_cogwheel" | "create:pressing/cursed_earth_path_from_grass" | "quark:world/crafting/walls/shale_wall" | "quark:building/crafting/grate" | "cataclysm:stonecutting/frosted_stone_brick_wall_from_stonecutting" | "create:crafting/kinetics/metal_bracket" | "jerotesvillage:ocean_gemstone_fragments_craft" | "jerotesvillage:serpon_pike_craft" | "quark:world/crafting/woodsets/ancient/fence_gate" | "minecraft:stone_brick_stairs_from_stone_bricks_stonecutting" | "create:cutting/compat/byg/ether_log" | "quark:building/crafting/compressed/carrot_crate_uncompress" | "jerotesvillage:black_yellow_wood_craft" | "cataclysm:stonecutting/polished_obsidian_slab_from_stonecutting" | "quark:building/crafting/shingles/cyan_shingles" | "quark:building/stonecutting/vertslabs/waxed_exposed_cut_copper_vertical_slab_from_waxed_exposed_cut_copper" | "jerotesvillage:wonderland_door_craft" | "quark:building/stonecutting/stonevariants/dripstone_bricks_wall_polished_stonecutting" | "create:crafting/kinetics/framed_glass_door" | "minecraft:coal_from_blasting_coal_ore" | "jerotesvillage:piglin_base_map_craft" | "tetra:chainmail_chestplate" | "refinedstorage:coloring_recipes/blue_grid" | "jerotesvillage:malignasaur_arrow_craft" | "netherexp:stonecutting/nether_bricks_from_red_nether_bricks" | "quark:building/crafting/slabs/netherrack_bricks_slab" | "refinedstorage:destruction_core" | "quark:building/stonecutting/stonevariants/dripstone_pillar_stonecutter" | "create:milling/compat/byg/alpine_bellflower" | "protection_pixel:anchorpointloot" | "cataclysm:smithing/ignitium_leggings" | "create:crafting/kinetics/gantry_carriage" | "farmersdelight:cutting/red_tulip" | "create:cutting/compat/byg/cika_log" | "jerotesvillage:qoaiku_metal_nugget_from_blast" | "quark:building/crafting/sturdy_stone_cyclic" | "biomancy:digesting/nutrient_paste_from_warped_fungus" | "farmersdelight:cutting/spruce_wood" | "create:crafting/logistics/powered_latch" | "netherexp:rusty_cut_netherite_pillar" | "biomancy:decomposing/caiman_egg" | "refinedstorage:coloring_recipes/blue_crafter_manager" | "create:ochrum_pillar_from_stone_types_ochrum_stonecutting" | "netherexp:stripped_claret_hyphae" | "farmersdelight:cutting/crimson_hyphae" | "minecraft:warped_hanging_sign" | "quark:building/crafting/sakura_paper_lantern" | "minecraft:cracked_deepslate_bricks" | "minecraft:orange_dye_from_torchflower" | "quark:building/crafting/vertslabs/limestone_bricks_vertical_slab" | "create:cutting/compat/regions_unexplored/pine_log" | "create:smelting/iron_ingot_from_crushed" | "jerotesvillage:serpon_axe_craft" | "biomancy:decomposing/kangaroo_hide" | "netherexp:smooth_silica_sandstone" | "jerotesvillage:mysterest_perfume_from_cooking" | "farmersdelight:cooking/pasta_with_meatballs" | "create:crafting/kinetics/track_signal" | "jerotesvillage:villager_block_captain_craft" | "create:crafting/materials/andesite_alloy_from_block" | "create:milling/compat/buzzier_bees/buttercup" | "minecraft:jungle_fence_gate" | "create:crushing/nickel_ore" | "born_in_chaos_v1:scorched_planks_pressure_plates_k" | "refinedstorage:coloring_recipes/yellow_detector" | "create:cut_asurine_wall" | "create:crafting/kinetics/water_wheel" | "create:polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:mixing/chocolate_melting" | "create:milling/compat/byg/snowdrops" | "pasterdream:stonecutting_8" | "pasterdream:stonecutting_9" | "meed:tombstone/aquatic_life" | "quark:building/crafting/lamps/black_corundum_lamp" | "functionalstorage:dark_oak_1" | "functionalstorage:dark_oak_2" | "biomancy:decomposing/bamboo" | "netherexp:stonecutting/from_basalt/polished_basalt_wall" | "create:crafting/materials/raw_zinc_block" | "protection_pixel:hellsnakeloot" | "create:cutting/andesite_alloy" | "functionalstorage:dark_oak_4" | "create:pressing/copper_ingot" | "farmersdelight:light_blue_canvas_sign" | "create:cut_diorite_slab_from_stone_types_diorite_stonecutting" | "minecraft:polished_basalt_from_basalt_stonecutting" | "jerotesvillage:cooked_brown_venomous_slug_from_smoking" | "create:cutting/compat/ars_nouveau/stripped_purple_archwood_wood" | "create:cutting/compat/tconstruct/stripped_greenheart_log" | "biomancy:crafting/porous_primal_flesh_from_slabs" | "biofactory:filling/rich_soil" | "biomancy:decomposing/dead_horn_coral_fan" | "jerotesvillage:hag_replacement/jerotesvillage_glitter_sand" | "meed:soulsweapons/fear" | "chunkloaders:single_chunk_loader" | "cataclysm:stonecutting/obsidian_bricks_from_stonecutting" | "minecraft:polished_granite_slab_from_polished_granite_stonecutting" | "biomancy:crafting/malignant_flesh_stairs" | "quark:tweaks/crafting/utility/wool/lime_wool" | "prefab:carton_of_eggs" | "legendary_monsters:ancient_dripstone_tiles_stonecutter_adp" | "minecraft:warped_planks" | "minecraft:red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "legendary_monsters:chiseled_ancient_dripstone_bricks_bricks_stonecutter" | "create:crafting/kinetics/sticker" | "biomancy:decomposing/withered_mob_marrow" | "quark:automation/crafting/iron_button" | "create:cutting/compat/hexcasting/edified_wood" | "minecraft:red_candle" | "quark:building/crafting/vertslabs/acacia_vertical_slab" | "create:polished_cut_scoria_stairs" | "jerotesvillage:illager_tower_map_craft" | "refinedstorage:coloring_recipes/green_wireless_transmitter" | "sophisticatedbackpacks:chipped/glassblower_upgrade" | "create:milling/compat/botania/cyan_petal" | "minecraft:brown_carpet" | "lendersdelight:cook/cooked_lionfish_from_smoking" | "create:cut_granite_brick_slab" | "quark:building/crafting/yellow_stool" | "create:oxidized_copper_tile_slab" | "born_in_chaos_v1:eternalcandy_craft" | "minecraft:crimson_fence" | "create:cutting/compat/ars_nouveau/green_archwood_wood" | "quark:building/crafting/lamps/orange_corundum_lamp" | "minecraft:oxidized_cut_copper_slab" | "jerotesvillage:villager_block_forger_craft" | "jerotesvillage:cooked_rambler_meat_from_smoking" | "quark:tools/crafting/pickarang_no_heart" | "quark:world/stonecutting/stairs/polished_limestone_stairs_stonecutter" | "protection_pixel:buoyancyasloot" | "minecraft:light_gray_stained_glass" | "quark:building/crafting/ancient_post" | "jerotesvillage:hag_replacement/jerotesvillage_ruin_stone_brick_stairs" | "sophisticatedbackpacks:backpack_dye" | "cataclysm:blasting/ancient_metal_nugget_from_blasting" | "jerotesvillage:cooked_chromasnap_bass_from_campfire_cooking" | "lendersdelight:cook/cooked_coboleton_meat" | "pasterdream:stonecutting_6" | "quark:building/crafting/azalea_post" | "pasterdream:stonecutting_7" | "pasterdream:stonecutting_4" | "pasterdream:stonecutting_5" | "pasterdream:stonecutting_3" | "quark:world/stonecutting/polished_jasper_stonecutter" | "create:cutting/compat/environmental/stripped_wisteria_log" | "refinedstorage:coloring_recipes/orange_fluid_grid" | "minecraft:decorated_pot_simple" | "quark:tweaks/crafting/utility/chest_boat/direct_azalea_chest_boat" | "minecraft:oak_pressure_plate" | "quark:building/stonecutting/stairs/magenta_shingles_stairs_stonecutter2" | "legendary_monsters:soul_great_sword" | "biomancy:decomposing/malignant_flesh" | "minecraft:diorite" | "netherexp:gargoyle_statues/ossified" | "refinedstorage:coloring_recipes/purple_wireless_transmitter" | "create:milling/poppy" | "minecraft:snout_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/bricks" | "quark:building/stonecutting/vertslabs/cyan_shingles_vertical_slab_stonecutter2" | "minecraft:crimson_button" | "netherexp:shroomnight" | "quark:building/crafting/chests/spruce_chest" | "born_in_chaos_v1:pileof_skulls_k" | "create:cutting/compat/autumnity/sappy_maple_wood" | "biomancy:digesting/nutrient_paste_from_atlatitan_egg" | "minecraft:jungle_planks" | "minecraft:netherite_axe_smithing" | "quark:building/stonecutting/stonevariants/shale_bricks_vertical_slab_rough_stonecutting" | "biomancy:bio_brewing/enlargement_serum" | "refinedstorage:crafter" | "biomancy:decomposing/cocoa_beans" | "create:cutting/compat/regions_unexplored/cobalt_log" | "quark:building/crafting/mangrove_ladder" | "create:milling/compat/regions_unexplored/blue_snowbelle" | "born_in_chaos_v1:nightmare_robe_k" | "jerotesvillage:hag_replacement/jerotesvillage_pink_slime_ball" | "quark:building/stonecutting/vertslabs/magenta_shingles_vertical_slab_stonecutter" | "legendary_monsters:chorus_cannon" | "minecraft:polished_deepslate_slab_from_polished_deepslate_stonecutting" | "jerotesvillage:villager_block_breeder_craft" | "create:cutting/compat/regions_unexplored/stripped_palm_log" | "quark:building/stonecutting/slabs/iron_plate_slab_stonecutter" | "functionalstorage:iron_downgrade" | "minecraft:red_nether_bricks" | "quark:building/stonecutting/slabs/brown_shingles_slab_stonecutter2" | "create:crushing/blaze_rod" | "create:milling/compat/byg/tall_pink_allium" | "quark:building/crafting/vertslabs/blue_shingles_vertical_slab" | "quark:building/crafting/stairs/brown_shingles_stairs" | "minecraft:warped_slab" | "minecraft:mangrove_stairs" | "minecraft:prismarine" | "quark:building/stonecutting/vertslabs/weathered_cut_copper_vertical_slab_from_weathered_cut_copper" | "minecraft:chiseled_sandstone" | "biofactory:compacting/flesh_block_from_flesh_bits" | "minecraft:bamboo_raft" | "jerotesvillage:sediment_mud_brick_slab_craft" | "jerotesvillage:rambler_leather_block_craft" | "quark:building/stonecutting/slabs/midori_block_slab_stonecutter" | "biomancy:decomposing/fibrous_flesh_slab" | "quark:building/stonecutting/slabs/yellow_shingles_slab_stonecutter" | "biomancy:decomposing/kelp" | "minecraft:moss_carpet" | "netherexp:stonecutting/from_wither_stacked_bones/stacked_bone_stairs" | "minecraft:mossy_cobblestone_slab" | "create:crafting/kinetics/nozzle" | "jerotesvillage:qoaiku_leggings_craft" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "minecraft:cake" | "create:crafting/kinetics/linear_chassis" | "lendersdelight:ender_blood" | "create:polished_cut_asurine_slab" | "quark:building/crafting/shingles/shingles" | "minecraft:granite_slab" | "protection_pixel:breakerloot" | "minecraft:mud_brick_stairs" | "create:pressing/sugar_cane" | "cataclysm:astrape" | "jerotesvillage:pink_cactus_dye_smelt" | "biomancy:decomposing/atlatitan_egg" | "jerotesvillage:carved_brick_wall_craft" | "faded_conquest_2:abyssaldevicer" | "minecraft:lime_concrete_powder" | "refinedstorage:coloring_recipes/purple_network_transmitter" | "minecraft:leather_leggings" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "create:crushing/raw_iron_block" | "create:crushing/compat/silentgems/topaz_ore" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "quark:building/crafting/vertslabs/bamboo_mosaic_vertical_slab_revert" | "biomancy:decomposing/scute" | "quark:world/crafting/woodsets/azalea/door" | "quark:building/crafting/vertslabs/polished_myalite_vertical_slab" | "minecraft:cherry_pressure_plate" | "create:cutting/compat/byg/palm_log" | "biomancy:decomposing/subterranodon_egg" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "create:milling/compat/byg/incan_lily" | "create:cutting/compat/botania/stripped_dreamwood_log" | "minecraft:netherite_scrap_from_blasting" | "create:cut_scoria_slab_recycling" | "jerotesvillage:qoaiku_trident_craft" | "quark:building/stonecutting/vertslabs/polished_andesite_vertical_slab_stonecutter" | "refinedstorage:coloring_recipes/orange_security_manager" | "quark:world/crafting/slabs/polished_limestone_slab" | "farmersdelight:cutting/crimson_trapdoor" | "refinedstorage:coloring_recipes/orange_detector" | "minecraft:book" | "jerotesvillage:cooked_jewelroamer_from_campfire_cooking" | "quark:building/crafting/vertslabs/azalea_planks_vertical_slab" | "quark:world/crafting/polished_jasper" | "create:crafting/kinetics/flywheel" | "refinedstorage:coloring_recipes/orange_crafting_monitor" | "farmersdelight:cutting/cooked_salmon" | "born_in_chaos_v1:black_argillite_wk_2" | "refinedstorage:coloring_recipes/magenta_disk_manipulator" | "quark:building/stonecutting/stonevariants/andesite_pillar_stonecutter" | "quark:tweaks/crafting/dirty_glass" | "create:cut_scoria_brick_stairs" | "create:cutting/compat/byg/stripped_nightshade_log" | "protection_pixel:reactorloot" | "sophisticatedbackpacks:advanced_deposit_upgrade" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "quark:building/crafting/white_stool" | "minecraft:red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "refinedstorage:coloring_recipes/lime_crafting_monitor" | "create:small_granite_brick_slab_from_stone_types_granite_stonecutting" | "jerotesvillage:smooth_sun_sandstone_stairs_from_smooth_sun_sandstone_stonecutting" | "jerotesvillage:immortal_brew_craft" | "quark:building/crafting/rusty_iron_plate" | "create:cut_limestone_stairs" | "netherexp:claret_slab" | "biomancy:crafting/sand_from_stone_powder" | "biomancy:stonecutting/primal_flesh_slab_from_primal_flesh" | "minecraft:redstone_from_smelting_deepslate_redstone_ore" | "quark:building/stonecutting/iron_pillar_stonecutter" | "create:polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:splashing/crushed_raw_zinc" | "minecraft:sandstone_slab" | "jerotesvillage:stripped_wonderland_wood_craft" | "jerotesvillage:slavery_supervisor_boots_smith" | "lendersdelight:void_custard" | "quark:world/crafting/woodsets/blossom/chest" | "meed:tombstone/preservation" | "quark:building/crafting/compressed/gunpowder_sack" | "minecraft:wild_armor_trim_smithing_template" | "jerotesvillage:sediment_mud_brick_slab_from_drought_fire_bricks_stonecutting" | "minecraft:cracked_polished_blackstone_bricks" | "minecraft:deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "farmersdelight:cutting/jungle_sign" | "create:deploying/waxed_oxidized_copper_shingle_slab_from_adding_wax" | "minecraft:snout_armor_trim_smithing_template" | "quark:building/crafting/chiseled_soul_sandstone" | "jerotesvillage:cooked_bitter_cod_from_campfire_cooking" | "biomancy:digesting/nutrient_paste_from_vallumraptor_egg" | "protection_pixel:leggingsliningloot" | "netherexp:stonecutting/from_pale_soul_slate/chiseled" | "born_in_chaos_v1:scorched_planks_trapdoor_k" | "biomancy:bio_forging/packed_flesh_slab" | "quark:building/stonecutting/stonevariants/andesite_bricks_slab_rough_stonecutting" | "biomancy:bio_forging/flesh" | "minecraft:pink_candle" | "biomancy:bio_forging/storage_sac" | "lendersdelight:maledictus_heart_stew" | "minecraft:red_terracotta" | "protection_pixel:pioneerloot" | "meed:serene" | "refinedstorage:crafting_grid/black_crafting_grid" | "create:splashing/mekanism/crushed_raw_osmium" | "minecraft:ward_armor_trim_smithing_template_smithing_trim" | "minecraft:deepslate_tile_stairs" | "titanium:test_serializer/dirt_to_diamod" | "jerotesvillage:potion_throwing_ball_craft" | "create:crafting/kinetics/encased_chain_drive" | "farmersdelight:mangrove_cabinet" | "minecraft:oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "quark:world/stonecutting/stairs/polished_shale_stairs_stonecutter2" | "refinedstorage:64k_fluid_storage_disk" | "quark:tweaks/crafting/utility/chests/bamboo_chest_wood" | "quark:building/stonecutting/vertslabs/prismarine_brick_vertical_slab_stonecutter" | "minecraft:eye_armor_trim_smithing_template_smithing_trim" | "minecraft:polished_diorite_slab" | "refinedstorage:coloring_recipes/gray_crafter_manager" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "create:cutting/compat/botania/glimmering_livingwood" | "create:milling/compat/druidcraft/lavender" | "create:cutting/compat/regions_unexplored/maple_wood" | "create:crafting/copper/waxed_copper_tiles_from_honeycomb" | "netherexp:stonecutting/from_bone_block/stacked_bone_slab" | "quark:building/stonecutting/stonevariants/granite_bricks_vertical_slab_polished_stonecutting" | "minecraft:netherite_hoe_smithing" | "quark:world/stonecutting/slabs/myalite_slab_stonecutter" | "netherexp:smokestalk_pressure_plate" | "jerotesvillage:meror_metal_spear_craft" | "quark:building/stonecutting/vertslabs/waxed_weathered_cut_copper_vertical_slab_from_waxed_weathered_cut_copper" | "meed:alexscaves/irradiated" | "legendary_monsters:axe_of_lightning" | "create:milling/white_tulip" | "quark:tweaks/crafting/utility/chests/crimson_chest_wood" | "farmersdelight:diamond_knife" | "minecraft:prismarine_stairs_from_prismarine_stonecutting" | "refinedstorage:coloring_recipes/green_crafting_grid" | "create:crushing/compat/silentgems/alexandrite_ore" | "quark:building/stonecutting/stonevariants/chiseled_granite_bricks_stonecutter" | "minecraft:quartz_stairs_from_quartz_block_stonecutting" | "quark:tweaks/crafting/utility/bent/paper" | "quark:building/crafting/chests/acacia_chest" | "legendary_monsters:dinosaur_bone_shield" | "minecraft:wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:diamond_from_smelting_deepslate_diamond_ore" | "farmersdelight:yellow_hanging_canvas_sign" | "jerotesvillage:cut_sun_sandstone_slab_craft" | "minecraft:birch_pressure_plate" | "netherexp:smokestalk_door" | "refinedstorage:coloring_recipes/pink_crafting_grid" | "biomancy:stonecutting/flesh_slab_from_flesh" | "create:cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "quark:building/crafting/vertslabs/cobbled_deepslate_vertical_slab" | "create:crafting/materials/zinc_nugget_from_decompacting" | "refinedstorage:crafting_grid/lime_crafting_grid" | "create:cut_scorchia_from_stone_types_scorchia_stonecutting" | "jerotesvillage:prosperous_perfume_craft" | "create:spruce_window" | "netherexp:blue_mixed_nether_bricks" | "create:crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "minecraft:emerald_from_blasting_deepslate_emerald_ore" | "minecraft:black_bed" | "refinedstorage:coloring_recipes/black_crafting_monitor" | "prefab:bunch_of_beets" | "meed:sculk_lure" | "meed:ars_nouveau/summoning_sickness" | "create:crafting/kinetics/hose_pulley" | "quark:building/crafting/compressed/stick_block" | "create:crushing/lead_ore" | "farmersdelight:cooked_bacon" | "create:cut_ochrum_brick_wall" | "create:crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "quark:building/crafting/slabs/midori_block_slab" | "create:cut_andesite_slab_from_stone_types_andesite_stonecutting" | "netherexp:skull_on_a_stick" | "functionalstorage:framed_1" | "biomancy:decomposing/flesh_slab" | "functionalstorage:framed_2" | "functionalstorage:framed_4" | "prefab:modern_buildings" | "prefab:grass_stairs" | "minecraft:bowl" | "quark:building/crafting/stripped_warped_post" | "refinedstorage:coloring_recipes/cyan_pattern_grid" | "quark:building/crafting/vertslabs/waxed_oxidized_cut_copper_vertical_slab_revert" | "quark:building/crafting/compressed/carrot_crate" | "minecraft:purple_concrete_powder" | "biomancy:decomposing/straddlite" | "quark:building/crafting/chests/purpur_chest" | "quark:building/crafting/vertslabs/polished_blackstone_vertical_slab_revert" | "quark:tools/smithing/rune_smithing_cyan" | "cataclysm:quartz_brick_wall" | "minecraft:spectral_arrow" | "minecraft:red_carpet" | "create:blasting/tin_ingot_compat_thermal" | "quark:building/stonecutting/vertslabs/red_shingles_vertical_slab_stonecutter" | "create:cutting/compat/regions_unexplored/eucalyptus_log" | "tetra:thousand_cold_night_scroll" | "waystones:warp_stone" | "quark:building/crafting/stairs/sandstone_bricks_stairs" | "jerotesvillage:dye_from_purple_ponuo" | "refinedstorage:wireless_crafting_monitor" | "born_in_chaos_v1:black_argillite_brick_wall_k_3" | "create:crafting/materials/red_sand_paper" | "create:polished_cut_diorite_from_stone_types_diorite_stonecutting" | "born_in_chaos_v1:black_argillite_brick_wall_k_2" | "jerotesvillage:bitter_cold_stairs_craft" | "refinedstorage:coloring_recipes/black_fluid_grid" | "minecraft:dye_magenta_bed" | "prefab:swift_blade_stone" | "create:cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "quark:tweaks/crafting/utility/wool/purple_wool" | "create:crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "minecraft:bamboo_block" | "farmersdelight:cooking/dog_food" | "quark:building/crafting/shingles/lime_shingles" | "create:small_scoria_brick_stairs" | "create:cutting/compat/byg/pine_log" | "create:polished_cut_ochrum_slab_recycling" | "refinedstorage:coloring_recipes/brown_grid" | "minecraft:dye_orange_bed" | "create:smelting/silver_ingot_compat_oreganized" | "waystones:red_sharestone" | "jerotesvillage:villager_metal_crossbow_craft" | "farmersdelight:cutting/wild_tomatoes" | "jerotesvillage:carved_brick_slab_craft" | "sophisticatedbackpacks:iron_backpack_from_copper" | "quark:building/stonecutting/slabs/shingles_slab_stonecutter" | "minecraft:waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "create:crafting/kinetics/white_sail" | "netherexp:wither_bone_block" | "jerotesvillage:bitter_cold_wood_craft" | "quark:building/stonecutting/soul_sandstone_bricks_cut_stonecutter" | "quark:automation/crafting/gravisand" | "refinedstorage:pattern_grid/yellow_pattern_grid" | "minecraft:smooth_red_sandstone_stairs" | "quark:building/stonecutting/slabs/soul_sandstone_bricks_slab_stonecutter" | "minecraft:stone_pickaxe" | "netherexp:ancient_torch_from_fossil_fuel" | "minecraft:light_blue_glazed_terracotta" | "refinedstorage:coloring_recipes/lime_crafter" | "netherexp:stonecutting/from_pale_soul_slate/indented" | "minecraft:dispenser" | "create:splashing/quark/rusty_iron_plate" | "minecraft:cyan_stained_glass_pane" | "create:crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "minecraft:daylight_detector" | "biomancy:decomposing/lobster_tail" | "jerotesvillage:qoaiku_war_beast_armor_craft" | "quark:building/stonecutting/stonevariants/jasper_bricks_wall_polished_stonecutting" | "prefab:compressed_obsidian" | "minecraft:purple_glazed_terracotta" | "jerotesvillage:carved_brick_stairs_from_carved_bricks_stonecutting" | "farmersdelight:cutting/salmon" | "farmersdelight:cooking/ratatouille" | "jerotesvillage:glitter_sandstone_slab_from_glitter_sandstone_stonecutting" | "create:cutting/jungle_log" | "refinedstorage:coloring_recipes/magenta_detector" | "farmersdelight:hanging_canvas_sign" | "create:crafting/kinetics/mechanical_pump" | "minecraft:hopper" | "create:cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "born_in_chaos_v1:seedof_chaos_k_1" | "create:cut_tuff_slab_recycling" | "create:crafting/logistics/powered_toggle_latch" | "jerotesvillage:villager_block_horseman_craft" | "create:deploying/waxed_weathered_copper_tile_stairs_from_adding_wax" | "lendersdelight:leviathan_and_abyssal_egg" | "create:milling/compat/botania/white_petal" | "minecraft:raw_gold" | "minecraft:green_banner" | "jerotesvillage:black_yellow_sign_craft" | "quark:building/crafting/vertslabs/cut_sandstone_vertical_slab_revert" | "farmersdelight:paper_from_tree_bark" | "refinedstorage:coloring_recipes/purple_controller" | "born_in_chaos_v1:spider_bite_craft" | "refinedstorage:coloring_recipes/orange_controller" | "farmersdelight:cutting/lily_of_the_valley" | "create:cut_dripstone_stairs" | "quark:building/stonecutting/stonevariants/myalite_bricks_stairs_polished_stonecutting" | "minecraft:cooked_cod" | "refinedstorage:coloring_recipes/detector" | "minecraft:iron_helmet" | "create:cutting/compat/botania/glimmering_stripped_dreamwood" | "create:blasting/ingot_silver_compat_ic2" | "create:cut_diorite_brick_slab" | "create:crafting/kinetics/cyan_seat" | "minecraft:cartography_table" | "biomancy:crafting/baby_permeable_membrane_pane_from_baby_permeable_membrane" | "minecraft:polished_diorite" | "quark:building/stonecutting/stonevariants/calcite_pillar_stonecutter" | "prefab:crate_of_beets" | "jerotesvillage:glutinous_crust_meat_pie_craft" | "create:polished_cut_ochrum_slab" | "minecraft:cooked_porkchop_from_smoking" | "quark:building/crafting/vertslabs/tuff_bricks_vertical_slab" | "create:splashing/galosphere/crushed_raw_silver" | "create:splashing/black_concrete_powder" | "quark:tweaks/smelting/raw_gold_bricks_smelt" | "biomancy:decomposing/mutton" | "quark:building/crafting/vertslabs/deepslate_brick_vertical_slab_revert" | "create:small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "refinedstorage:coloring_recipes/blue_crafter" | "create:crushing/veridium_recycling" | "prefab:bunch_of_carrots_from_crate" | "quark:world/crafting/woodsets/azalea/trapdoor" | "netherexp:etched_soul_slate_bricks" | "farmersdelight:gray_canvas_sign" | "cataclysm:prismarine_brick_wall" | "biomancy:decomposing/brown_mushroom" | "quark:building/stonecutting/vertslabs/deepslate_brick_vertical_slab_from_polished_deepslate" | "legendary_monsters:ancient_dripstone_tile_slab_stonecutter_adbr" | "biomancy:decomposing/primal_flesh_stairs" | "create:polished_cut_deepslate_stairs" | "create:milling/compat/biomesoplenty/pink_hibiscus" | "minecraft:light_blue_banner" | "refinedstorage:security_card" | "quark:world/crafting/stairs/permafrost_stairs" | "minecraft:heavy_weighted_pressure_plate" | "jerotesvillage:black_yellow_trapdoor_craft" | "minecraft:stone_shovel" | "minecraft:deepslate_tiles_from_polished_deepslate_stonecutting" | "create:cut_calcite_brick_slab_recycling" | "create:polished_cut_crimsite_slab" | "create:blasting/ingot_tin_compat_ic2" | "create:layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:polished_blackstone_stairs" | "minecraft:netherite_pickaxe_smithing" | "minecraft:deepslate_brick_stairs" | "create:crushing/raw_silver_block" | "legendary_monsters:purified_soul" | "art_of_forging:forged_steel_from_blasting_alloy" | "farmersdelight:cooking/fried_rice" | "quark:building/stonecutting/cut_soul_sandstone_stonecutter" | "create:milling/compat/byg/yellow_tulip" | "create:cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "biomancy:decomposing/fibrous_flesh" | "create:milling/compat/regions_unexplored/tassel" | "quark:building/stonecutting/walls/dripstone_bricks_wall_stonecutter" | "create:splashing/stained_glass_pane" | "quark:building/crafting/slabs/tuff_bricks_slab" | "create:cutting/compat/windswept/stripped_holly_log" | "farmersdelight:honey_cookie" | "quark:tweaks/crafting/utility/wool/brown_wool" | "minecraft:golden_helmet" | "refinedstorage:1k_storage_block" | "minecraft:light_blue_dye_from_blue_orchid" | "quark:building/crafting/vertslabs/pink_shingles_vertical_slab_revert" | "prefab:house" | "minecraft:mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "create:cutting/compat/botania/glimmering_stripped_dreamwood_log" | "cataclysm:ignitium_block" | "biomancy:stonecutting/primal_flesh_stairs_from_primal_flesh" | "biomancy:bio_forging/fleshkin_pressure_plate" | "quark:building/crafting/compressed/nether_wart_sack" | "create:small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "minecraft:polished_deepslate" | "quark:world/crafting/woodsets/blossom/boat" | "meed:born_in_chaos_v1/medium_rampage" | "create:scoria_from_stone_types_scoria_stonecutting" | "biofactory:compacting/nutrient_bar_from_fluid" | "create:crafting/kinetics/rose_quartz_lamp" | "farmersdelight:cutting/birch_log" | "biomancy:decomposing/oxeye_daisy" | "netherexp:stonecutting/from_soul_slate_tiles/chiseled" | "create:crushing/compat/silentgems/rose_quartz_ore" | "biomancy:bio_forging/packed_flesh" | "sophisticatedbackpacks:advanced_void_upgrade" | "prefab:double_compressed_glowstone_to_compressed_glowstone" | "functionalstorage:framed_storage_controller" | "create:small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "born_in_chaos_v1:darkcharge_k" | "create:small_scorchia_brick_stairs" | "biomancy:bio_forging/flesh_stairs" | "create:cutting/compat/twilightforest/stripped_sorting_wood" | "quark:building/crafting/vertslabs/blossom_planks_vertical_slab" | "create:crushing/raw_nickel" | "biomancy:digesting/nutrient_paste_from_caiman_egg" | "farmersdelight:black_hanging_canvas_sign" | "create:cutting/compat/biomesoplenty/fir_wood" | "create:milling/compat/regions_unexplored/hyssop" | "farmersdelight:cutting/warped_stem" | "rsinfinitybooster:infinity_card" | "create:milling/compat/byg/purple_tulip" | "born_in_chaos_v1:nightmare_boots_k" | "minecraft:cooked_porkchop_from_campfire_cooking" | "create:cut_calcite_wall_from_stone_types_calcite_stonecutting" | "minecraft:cyan_stained_glass_pane_from_glass_pane" | "quark:world/stonecutting/slabs/limestone_slab_stonecutter" | "legendary_monsters:void_entity_warper" | "create:cutting/compat/byg/aspen_log" | "minecraft:dye_red_carpet" | "create:spruce_window_pane" | "quark:building/crafting/stonevariants/chiseled_dripstone_bricks" | "create:item_application/andesite_casing_from_wood" | "quark:tweaks/crafting/utility/wool/gray_wool" | "quark:building/crafting/compressed/cactus_block" | "jerotesvillage:cooked_abyssaler" | "biomancy:decomposing/baked_potato" | "create:small_scorchia_brick_slab_recycling" | "cataclysm:smithing/cursium_chestplate" | "create:cutting/compat/autumnity/maple_log" | "create:cutting/compat/regions_unexplored/brimwood_log_magma" | "create:cut_asurine_brick_slab_recycling" | "quark:building/crafting/vertslabs/limestone_vertical_slab" | "create:cut_veridium_brick_wall" | "refinedstorage:coloring_recipes/white_crafting_grid" | "jerotesvillage:ominous_war_beast_armor_craft" | "jerotesvillage:dye_from_second_round_dandelion" | "farmersdelight:jungle_cabinet" | "netherexp:stonecutting/from_wither_stacked_bones/skull_block" | "ftbquests:screen_5" | "quark:building/crafting/hollowlogs/hollow_ancient_log" | "jerotesvillage:wonderland_fruit_crate" | "ftbquests:screen_7" | "ftbquests:screen_1" | "quark:world/crafting/woodsets/azalea/chest_wood" | "ftbquests:screen_3" | "netherexp:smokestalk_fence" | "quark:building/crafting/hollowlogs/hollow_acacia_log" | "quark:building/stonecutting/stonevariants/limestone_bricks_stonecutter" | "minecraft:smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "meed:health_reduction" | "jerotesvillage:hag_replacement/jerotesvillage_ruin_stone_brick_slab" | "lendersdelight:cook/cooked_coral_golem_meat_from_smoking" | "create:haunting/infested_stone_bricks" | "create:haunting/poisonous_potato" | "farmersdelight:iron_nugget_from_blasting_knife" | "netherexp:polished_basalt_brick_stairs" | "jerotesvillage:meror_metal_chestplate_craft" | "minecraft:wooden_sword" | "create:blasting/copper_ingot_from_crushed" | "quark:tweaks/crafting/blue_glass" | "jerotesvillage:cooked_bitter_cod" | "quark:building/crafting/vertslabs/orange_shingles_vertical_slab_revert" | "biomancy:decomposing/blobfish" | "quark:building/stonecutting/stonevariants/jasper_bricks_slab_rough_stonecutting" | "create:smelting/glass_pane_from_framed_glass_pane" | "quark:building/crafting/shingles/cyan_shingles_dye" | "quark:building/stonecutting/brown_shingles_stonecutter2" | "biofactory:filling/nutrients_fluid_bottle" | "create:milling/compat/byg/white_puffball_cap" | "refinedstorage:regulator_upgrade" | "biomancy:decomposing/raw_gold" | "create:cutting/compat/regions_unexplored/stripped_redwood_log" | "create:cutting/compat/blue_skies/stripped_frostbright_wood" | "jerotesvillage:iron_nugget_from_other_smelt" | "jerotes:beast_armor_base_craft" | "farmersdelight:blue_hanging_canvas_sign" | "jerotesvillage:second_rounder_gem_craft" | "biomancy:bio_brewing/breeding_stimulant" | "minecraft:smooth_quartz_slab" | "create:cutting/compat/regions_unexplored/stripped_palm_wood" | "create:scorchia_from_stone_types_scorchia_stonecutting" | "create:small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "farmersdelight:cutting/poppy" | "tetra:chainmail_boots" | "minecraft:lapis_lazuli_from_smelting_lapis_ore" | "biomancy:bio_forging/flesh_door" | "create:milling/compat/atmospheric/warm_monkey_brush" | "quark:building/stonecutting/vertslabs/waxed_exposed_cut_copper_vertical_slab_from_waxed_exposed_copper" | "jerotesvillage:rambler_leather_helmet_craft" | "biomancy:decomposing/torchflower" | "minecraft:purple_stained_glass_pane_from_glass_pane" | "create:cut_limestone_brick_wall" | "quark:tweaks/crafting/panes/dirty_glass_pane" | "lendersdelight:ender_blood_glazed_maledictus_heart" | "minecraft:cookie" | "minecraft:lightning_rod" | "minecraft:brown_stained_glass_pane_from_glass_pane" | "create:milling/compat/regions_unexplored/salmon_poppy_bush" | "minecraft:orange_concrete_powder" | "quark:building/crafting/vertslabs/jungle_vertical_slab" | "minecraft:shears" | "biomancy:crafting/porous_primal_flesh" | "meed:born_in_chaos_v1/stimulation" | "quark:building/crafting/vertslabs/dripstone_bricks_vertical_slab" | "quark:world/crafting/waxed_white_corundum" | "quark:building/crafting/vertslabs/midori_block_vertical_slab_revert" | "legendary_monsters:ancient_dripstone_tile_stairs_left" | "quark:building/stonecutting/stonevariants/shale_bricks_wall_rough_stonecutting" | "minecraft:yellow_stained_glass_pane_from_glass_pane" | "quark:building/stonecutting/vertslabs/cut_soul_sandstone_vertical_slab_stonecutter" | "quark:building/crafting/vertplanks/vertical_dark_oak_planks" | "jerotesvillage:meror_metal_bow_craft" | "quark:building/crafting/stairs/cyan_shingles_stairs" | "create:small_scorchia_brick_wall" | "minecraft:stone_brick_slab_from_stone_bricks_stonecutting" | "create:crafting/appliances/filter_clear" | "jerotesvillage:virtual_cave_evil_block_craft" | "quark:building/crafting/duskbound_block" | "quark:tweaks/crafting/elytra_duplication" | "quark:building/stonecutting/stairs/black_shingles_stairs_stonecutter" | "create:milling/compat/biomesoplenty/pink_daffodil" | "create:cutting/stripped_dark_oak_wood" | "create:milling/terracotta" | "create:cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "jerotesvillage:dye_from_red_lush" | "born_in_chaos_v1:scorched_planks_door_k" | "farmersdelight:sweet_berry_cookie" | "create:crafting/kinetics/rope_pulley" | "create:crafting/kinetics/cuckoo_clock" | "refinedstorage:coloring_recipes/gray_detector" | "refinedstorage:coloring_recipes/white_crafting_monitor" | "quark:world/crafting/woodsets/ancient/button" | "quark:building/stonecutting/vertslabs/iron_plate_vertical_slab_stonecutter" | "create:polished_cut_deepslate_slab_recycling" | "create:crafting/kinetics/pink_seat" | "quark:building/stonecutting/vertslabs/oxidized_cut_copper_vertical_slab_from_oxidized_cut_copper" | "refinedstorage:coloring_recipes/black_controller" | "create:copper_tile_slab_from_copper_tiles_stonecutting" | "create:polished_cut_andesite_slab" | "quark:building/crafting/sturdy_stone" | "create:crushing/compat/elementaryores/ore_coal_nether" | "biomancy:crafting/packed_flesh_slab" | "quark:building/crafting/jungle_post" | "cataclysm:black_steel_nugget" | "quark:building/crafting/vertslabs/mossy_cobblestone_vertical_slab" | "create:crafting/schematics/schematicannon" | "create:cutting/compat/twilightforest/stripped_mining_log" | "minecraft:oak_fence_gate" | "farmersdelight:beetroot_crate" | "quark:world/crafting/walls/permafrost_wall" | "prefab:quartz_crete_smooth_wall" | "quark:building/crafting/vertslabs/deepslate_tile_vertical_slab" | "itemfilters:max_count" | "quark:building/crafting/slabs/calcite_slab" | "lendersdelight:cook/deepling_meat" | "quark:tools/crafting/abacus" | "create:crushing/raw_osmium_block" | "create:cutting/compat/byg/stripped_maple_log" | "legendary_monsters:eye_of_soul" | "netherexp:stonecutting/from_smooth_netherrack/smooth_netherrack_wall" | "create:cutting/compat/atmospheric/stripped_grimwood_log" | "create:splashing/ic2/crushed_raw_silver" | "create:cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "minecraft:coast_armor_trim_smithing_template_smithing_trim" | "protection_pixel:tosakilegloot" | "minecraft:sandstone_stairs_from_sandstone_stonecutting" | "quark:building/crafting/dark_oak_ladder" | "refinedstorage:pattern_grid/lime_pattern_grid" | "jerotesvillage:giant_monster_horned_helmet_smith" | "jerotesvillage:scaly_bear_chestplate_smith" | "minecraft:gray_carpet" | "lendersdelight:cook/cooked_berserker_from_campfire_cooking" | "minecraft:crimson_hanging_sign" | "create:polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "quark:building/crafting/vertslabs/pink_shingles_vertical_slab" | "create:crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "waystones:mossy_waystone_convert" | "biomancy:bio_forging/fibrous_flesh_stairs" | "moblassos:hostile_lasso" | "minecraft:red_nether_brick_stairs" | "farmersdelight:pink_hanging_canvas_sign" | "minecraft:brewing_stand" | "create:cutting/compat/byg/stripped_fir_log" | "create:mechanical_crafting/potato_cannon" | "biomancy:decomposing/tough_hide" | "biomancy:decomposing/pitcher_plant" | "sophisticatedbackpacks:chipped/loom_table_upgrade" | "netherexp:phasmo_shard" | "quark:building/crafting/slabs/sandstone_bricks_slab" | "quark:building/crafting/stairs/gray_shingles_stairs" | "farmersdelight:yellow_canvas_sign" | "biomancy:digesting/nutrient_paste_from_dried_kelp_block" | "create:cutting/compat/regions_unexplored/stripped_mauve_wood" | "biomancy:decomposing/netherite_scrap" | "refinedstorage:16k_storage_disk" | "create:crafting/kinetics/gearboxfrom_conversion" | "create:cutting/compat/ars_nouveau/red_archwood_log" | "cataclysm:weapon_infusion/the_immolator" | "born_in_chaos_v1:webbed_cobblestone_craft" | "create:crafting/kinetics/orange_seat" | "refinedstorage:coloring_recipes/white_relay" | "quark:building/stonecutting/stairs/duskbound_block_stairs_stonecutter" | "create:cutting/compat/windswept/chestnut_log" | "create:cutting/compat/biomesoplenty/umbran_wood" | "minecraft:diamond_block" | "born_in_chaos_v1:stimulating_bomb_k" | "quark:building/crafting/mud_pillar" | "create:crushing/compat/byg/pervaded_netherrack" | "minecraft:deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "quark:building/crafting/midori_block" | "create:cutting/compat/windswept/holly_wood" | "minecraft:diorite_slab" | "farmersdelight:lime_canvas_sign" | "quark:oddities/crafting/backpack" | "create:polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_bricks" | "minecraft:yellow_stained_glass" | "create:cutting/birch_wood" | "quark:building/crafting/vertslabs/waxed_exposed_cut_copper_vertical_slab_revert" | "netherexp:smokestalk_fence_gate" | "quark:building/crafting/stripped_blossom_post" | "refinedstorage:coloring_recipes/brown_network_transmitter" | "netherexp:gargoyle_statues/cirripedia" | "jerotesvillage:cooked_lake_loach_from_campfire_cooking" | "minecraft:pumpkin_seeds" | "quark:building/stonecutting/vertslabs/polished_calcite_vertical_slab_stonecutter2" | "create:milling/compat/byg/bistort" | "jerotesvillage:hag_replacement/minecraft_mud" | "born_in_chaos_v1:stained_black_argillite_brick_k" | "quark:building/crafting/vertslabs/light_blue_shingles_vertical_slab" | "create:milling/compat/environmental/white_delphinium" | "quark:tweaks/crafting/magenta_glass" | "jerotesvillage:cooked_flowminnow_from_smoking" | "sophisticatedbackpacks:restock_upgrade" | "create:cutting/compat/atmospheric/rosewood" | "jerotesvillage:serpon_chariot_craft" | "quark:building/crafting/vertslabs/blackstone_vertical_slab" | "create:milling/compat/byg/foxglove" | "minecraft:cooked_mutton" | "create:cut_andesite_wall" | "create:cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "farmersdelight:wheat_dough_from_eggs" | "minecraft:bookshelf" | "biomancy:digesting/nutrient_paste_from_nether_sprouts" | "create:cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "minecraft:lapis_block" | "jerotesvillage:bitter_cold_boat_craft" | "create:cutting/compat/regions_unexplored/stripped_magnolia_wood" | "create:cutting/stripped_crimson_hyphae" | "farmersdelight:pumpkin_seeds_from_slice" | "quark:building/stonecutting/stairs/dripstone_bricks_stairs_stonecutter" | "farmersdelight:cutting/birch_sign" | "jerotesvillage:golden_bright_melon_craft_by_crate" | "cataclysm:cursium_upgrade_smithing_template" | "cataclysm:laser_gatling" | "jerotesvillage:ruin_stone_brick_wall_craft" | "lendersdelight:cook/cooked_berserker_from_smoking" | "create:cutting/compat/twilightforest/stripped_canopy_log" | "quark:building/crafting/hollowlogs/hollow_dark_oak_log" | "minecraft:light_gray_terracotta" | "quark:world/stonecutting/slabs/limestone_bricks_slab_stonecutter" | "biomancy:decomposing/nautilus_shell" | "refinedstorage:coloring_recipes/cyan_wireless_transmitter" | "netherexp:smokestalk_hanging_sign" | "create:milling/compat/byg/white_anemone" | "minecraft:oak_boat" | "quark:building/stonecutting/red_sandstone_bricks_stonecutter" | "jerotesvillage:dye_from_green_humanoid_cane" | "create:layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:red_dye_from_rose_bush" | "quark:building/stonecutting/gray_shingles_stonecutter2" | "create:cutting/compat/regions_unexplored/stripped_pine_log" | "quark:building/crafting/stonevariants/chiseled_limestone_bricks" | "quark:building/crafting/shingles/black_shingles" | "minecraft:jungle_fence" | "create:polished_cut_granite_slab_recycling" | "quark:world/crafting/walls/myalite_wall" | "minecraft:glass_bottle" | "minecraft:iron_ingot_from_smelting_raw_iron" | "create:milling/compat/byg/lolipop_flower" | "quark:building/crafting/slabs/black_shingles_slab" | "netherexp:silica_sandstone_slab" | "jerotesvillage:hag_replacement/minecraft_cobblestone" | "netherexp:stonecutting/from_wither_bone_block/stacked_bones" | "netherexp:gargoyle_statues/obfuscated" | "jerotesvillage:cooked_bitter_cod_from_smoking" | "create:crafting/materials/copper_ingot" | "minecraft:stripped_warped_hyphae" | "create:cut_calcite_brick_stairs" | "netherexp:smooth_netherrack" | "create:smelting/glass_pane_from_tiled_glass_pane" | "refinedstorage:wireless_grid" | "jerotesvillage:serpon_shovel_craft" | "netherexp:claret_planks" | "refinedstorage:coloring_recipes/red_network_receiver" | "create:cutting/compat/regions_unexplored/ashen_log" | "refinedstorage:coloring_recipes/pink_grid" | "create:small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "sophisticatedbackpacks:stack_downgrade_tier_2" | "sophisticatedbackpacks:stack_downgrade_tier_1" | "born_in_chaos_v1:darkmetalblockk_2" | "minecraft:cherry_hanging_sign" | "create:cutting/compat/the_vault/driftwood_log" | "sophisticatedbackpacks:stack_downgrade_tier_3" | "create:milling/compat/botania/orange_petal" | "quark:building/stonecutting/vertslabs/polished_myalite_vertical_slab_stonecutter" | "born_in_chaos_v1:black_argillite_column_k_2" | "create:layered_deepslate_from_stone_types_deepslate_stonecutting" | "cataclysm:smithing/ignitium_chestplate" | "jerotesvillage:cooked_bright_grass_carp_from_smoking" | "jerotesvillage:sediment_mud_brick_wall_from_sediment_mud_bricks_stonecutting" | "quark:building/crafting/vertslabs/polished_deepslate_vertical_slab_revert" | "netherexp:quartz_crystal_block" | "biomancy:bio_forging/adult_permeable_membrane" | "quark:building/stonecutting/slabs/purple_shingles_slab_stonecutter" | "netherexp:stonecutting/from_smooth_netherrack/netherrack" | "quark:tweaks/blasting/raw_gold_bricks_blast" | "create:crushing/quicksilver_ore" | "quark:building/stonecutting/slabs/blue_shingles_slab_stonecutter2" | "biomancy:decomposing/lily_of_the_valley" | "create:cutting/compat/regions_unexplored/stripped_willow_wood" | "create:crushing/compat/byg/anthracite_ore" | "refinedstorage:cover" | "legendary_monsters:chiseled_sandstone" | "biomancy:crafting/flesh_slab" | "minecraft:bamboo_hanging_sign" | "netherexp:stonecutting/from_soul_slate/chiseled_soul_slate_bricks" | "quark:building/crafting/vertslabs/diorite_vertical_slab_revert" | "create:crafting/curiosities/cake" | "jerotesvillage:hag_replacement/jerotesvillage_serpon_alloy_block" | "minecraft:waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:copper_shingle_stairs_from_copper_shingles_stonecutting" | "quark:building/crafting/compressed/golden_apple_crate_uncompress" | "create:milling/compat/byg/begonia" | "minecraft:deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:purple_dye" | "jerotesvillage:meror_standard_boots_smith" | "create:cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "create:crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "minecraft:quartz_slab" | "netherexp:rusty_cut_netherite_stairs" | "jerotesvillage:second_round_world_teleport_stone_smith" | "farmersdelight:cabbage" | "create:crushing/compat/elementaryores/ore_lapis_nether" | "quark:building/stonecutting/slabs/cyan_shingles_slab_stonecutter" | "quark:building/stonecutting/vertslabs/deepslate_tile_vertical_slab_from_polished_deepslate" | "create:crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "jerotesvillage:hag_replacement/minecraft_splash_potion" | "netherexp:stonecutting/from_soul_slate/etched_soul_slate_bricks" | "create:exposed_copper_tile_stairs" | "farmersdelight:iron_knife" | "farmersdelight:bread_from_smelting" | "farmersdelight:cutting/blue_orchid" | "biomancy:decomposing/raw_scarlet_neodymium" | "create:polished_cut_limestone_from_stone_types_limestone_stonecutting" | "biofactory:mixing/nutrients_fluid_from_paste" | "quark:building/crafting/stairs/white_shingles_stairs" | "legendary_monsters:eye_of_sandstorm" | "create:cutting/compat/regions_unexplored/eucalyptus_wood" | "create:small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "create:cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "create:cutting/compat/windswept/holly_log" | "cataclysm:crystallized_coral" | "create:haunting/nether_brick" | "netherexp:silica_sandstone" | "minecraft:cut_sandstone_slab_from_sandstone_stonecutting" | "create:haunting/infested_mossy_stone_bricks" | "netherexp:smokestalk_stairs" | "meed:mobs_of_sins/emergency_peel" | "minecraft:polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "quark:building/crafting/stripped_jungle_post" | "farmersdelight:rice_bag" | "lendersdelight:cook/cooked_lionfish" | "create:milling/compat/botania/light_blue_petal" | "minecraft:bucket" | "farmersdelight:cutting/crimson_hanging_sign" | "quark:building/crafting/vertslabs/blackstone_bricks_vertical_slab_revert" | "minecraft:silence_armor_trim_smithing_template_smithing_trim" | "farmersdelight:chicken_sandwich" | "minecraft:coal_from_blasting_deepslate_coal_ore" | "create:splashing/immersiveengineering/crushed_raw_silver" | "minecraft:polished_andesite" | "create:crafting/kinetics/white_seat_from_other_seat" | "biomancy:digesting/nutrient_paste_from_sugar_cane" | "quark:building/crafting/birch_post" | "jerotesvillage:cut_purple_sandstone_slab_from_cut_purple_sandstone_stonecutting" | "jerotesvillage:cut_glitter_sandstone_slab_from_cut_glitter_sandstone_stonecutting" | "quark:building/crafting/vertslabs/black_shingles_vertical_slab_revert" | "quark:building/crafting/orange_stool" | "pasterdream:smithing_28" | "pasterdream:smithing_29" | "pasterdream:smithing_26" | "create:exposed_copper_tile_slab" | "pasterdream:smithing_27" | "minecraft:charcoal" | "cataclysm:flame_eye" | "cataclysm:purpur_wall" | "minecraft:diorite_wall_from_diorite_stonecutting" | "minecraft:polished_blackstone_brick_slab" | "cataclysm:witherite_block" | "minecraft:rabbit_stew_from_brown_mushroom" | "biomancy:bio_brewing/frenzy_serum" | "biomancy:decomposing/zombie_head" | "quark:building/stonecutting/stairs/netherrack_bricks_stairs_stonecutter" | "create:milling/compat/byg/tall_allium" | "biomancy:digesting/nutrient_paste_from_carved_pumpkin" | "born_in_chaos_v1:fired_black_argillite_k_3" | "pasterdream:smithing_19" | "create:cutting/stripped_jungle_wood" | "create:milling/lily_of_the_valley" | "pasterdream:smithing_17" | "pasterdream:smithing_18" | "pasterdream:smithing_15" | "pasterdream:smithing_16" | "itemfilters:damage" | "jerotesvillage:cooked_second_round_nigrum" | "born_in_chaos_v1:fired_black_argillite_k_2" | "sophisticatedbackpacks:stonecutter_upgrade" | "born_in_chaos_v1:fired_black_argillite_k_1" | "create:crushing/compat/elementaryores/ore_iron_nether" | "meed:tombstone/unstable_intangibility" | "jerotesvillage:bitter_cold_hanging_sign_craft" | "create:milling/compat/regions_unexplored/red_lupine" | "pasterdream:smithing_24" | "pasterdream:smithing_25" | "netherexp:stonecutting/from_smooth_netherrack/smooth_netherrack_stairs" | "pasterdream:smithing_22" | "pasterdream:smithing_23" | "pasterdream:smithing_20" | "pasterdream:smithing_21" | "farmersdelight:cooked_salmon_slice" | "netherexp:soul_slate_brick_slab" | "create:cutting/stripped_bamboo_block" | "create:milling/compat/environmental/yellow_hibiscus" | "create:polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "quark:building/crafting/slabs/yellow_shingles_slab" | "create:milling/compat/byg/firecracker_flower_bush" | "legendary_monsters:the_great_frost" | "create:cutting/compat/goodending/muddy_oak_wood" | "minecraft:warped_pressure_plate" | "create:cut_scoria_brick_wall" | "biomancy:decomposing/mob_sinew" | "farmersdelight:birch_cabinet" | "prefab:compressed_chest" | "pasterdream:smithing_13" | "pasterdream:smithing_14" | "pasterdream:smithing_11" | "pasterdream:smithing_12" | "pasterdream:smithing_10" | "quark:building/crafting/vertslabs/blue_nether_bricks_vertical_slab" | "jerotesvillage:explorer_iron_upgrade_smithing_template_craft" | "biomancy:digesting/nutrient_paste_from_terrapin_egg" | "quark:building/stonecutting/vertslabs/andesite_bricks_vertical_slab_stonecutter" | "farmersdelight:brown_canvas_sign" | "minecraft:cooked_porkchop" | "sophisticatedbackpacks:advanced_compacting_upgrade" | "create:cutting/compat/ecologics/stripped_azalea_log" | "create:cutting/compat/silentgear/stripped_netherwood_wood" | "meed:biomancy/bleed" | "quark:building/crafting/stairs/blue_shingles_stairs" | "lendersdelight:glazed_remnant_skull" | "biomancy:bio_forging/maw_hopper" | "minecraft:oak_wood" | "quark:building/crafting/vertslabs/sandstone_vertical_slab" | "born_in_chaos_v1:fire_light_dust_k" | "create:cutting/dark_oak_wood" | "minecraft:magenta_stained_glass_pane" | "farmersdelight:cutting/wild_rice" | "create:haunting/soul_sand" | "create:milling/compat/biomesoplenty/orange_cosmos" | "farmersdelight:canvas" | "minecraft:chiseled_stone_bricks_from_stone_bricks_stonecutting" | "biomancy:decomposing/creeper_head" | "jerotesvillage:ominous_banner_raid_tag_deployer_craft" | "create:splashing/red_concrete_powder" | "create:cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "minecraft:spruce_wood" | "create:crafting/materials/raw_zinc" | "minecraft:spruce_fence" | "protection_pixel:bloodprisonerloot" | "create:cutting/compat/ecologics/coconut_log" | "jerotesvillage:cooked_flowminnow_from_campfire_cooking" | "minecraft:dark_prismarine_slab" | "create:milling/compat/regions_unexplored/gray_snowbelle" | "jerotesvillage:cooked_rambler_meat_from_campfire_cooking" | "minecraft:green_dye" | "quark:building/crafting/oak_ladder" | "create:small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "quark:tweaks/crafting/gray_glass" | "minecraft:dried_kelp_from_smoking" | "quark:building/crafting/spruce_ladder" | "minecraft:waxed_exposed_cut_copper_stairs" | "jerotesvillage:serpon_pickaxe_craft" | "quark:building/stonecutting/slabs/lime_shingles_slab_stonecutter2" | "quark:building/crafting/bamboo_mat" | "create:cut_diorite_wall" | "create:crafting/curiosities/brown_toolbox" | "create:deploying/waxed_weathered_copper_from_adding_wax" | "jerotesvillage:bandage_craft" | "create:cutting/compat/nethers_exoticism/ramboutan_log" | "create:ochrum_from_stone_types_ochrum_stonecutting" | "jerotesvillage:cooked_greyscale" | "create:cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create:cutting/compat/regions_unexplored/mauve_wood" | "minecraft:weathered_cut_copper_slab" | "refinedstorage:coloring_recipes/cyan_controller" | "minecraft:waxed_weathered_copper_from_honeycomb" | "netherexp:stonecutting/from_wither_stacked_bones/stacked_bone_slab" | "jerotesvillage:drought_fire_brick_wall_from_drought_fire_bricks_stonecutting" | "itemfilters:custom" | "farmersdelight:integration/immersiveengineering/crusher/wild_potatoes" | "create:birch_window" | "quark:building/stonecutting/stonevariants/myalite_bricks_slab_polished_stonecutting" | "minecraft:andesite_wall_from_andesite_stonecutting" | "legendary_monsters:polished_diorite_pillar" | "meed:tombstone/frost_resistance" | "quark:building/stonecutting/stonevariants/granite_bricks_polished_stonecutting" | "jerotesvillage:qoaiku_fishing_rod_craft" | "jerotesvillage:bitter_cold_fat_craft" | "create:cutting/compat/byg/stripped_zelkova_log" | "prefab:light_switch" | "minecraft:redstone" | "create:crimsite_from_stone_types_crimsite_stonecutting" | "cataclysm:black_steel_fence" | "protection_pixel:lancerasloot" | "minecraft:powered_rail" | "biomancy:bio_forging/mascot_patterns" | "create:cutting/stripped_mangrove_wood" | "jerotesvillage:bitter_cold_planks_craft" | "create:cutting/compat/blue_skies/stripped_bluebright_wood" | "minecraft:firework_star" | "minecraft:green_concrete_powder" | "quark:building/crafting/stripped_crimson_post" | "minecraft:dye_white_bed" | "create:milling/compat/byg/kovan_flower" | "create:deploying/waxed_cut_copper_slab_from_adding_wax" | "jerotesvillage:sediment_catacombs_map_craft" | "biomancy:decomposing/fibrous_flesh_stairs" | "minecraft:blue_terracotta" | "create:cutting/compat/byg/maple_wood" | "create:cut_calcite_stairs" | "create:small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "minecraft:yellow_concrete_powder" | "minecraft:gray_terracotta" | "create:cutting/compat/byg/zelkova_log" | "create:cutting/compat/upgrade_aquatic/river_wood" | "minecraft:netherite_boots_smithing" | "netherexp:claret_trapdoor" | "quark:world/stonecutting/walls/limestone_bricks_wall_stonecutter" | "quark:building/crafting/vertslabs/raw_gold_bricks_vertical_slab" | "minecraft:fishing_rod" | "cataclysm:stone_tiles" | "minecraft:cooked_beef_from_smoking" | "create:milling/compat/byg/hydrangea_bush" | "jerotesvillage:virtual_cave_crystal_arrow_craft" | "minecraft:terracotta" | "create:exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "create:crafting/appliances/clipboard_clear" | "create:small_calcite_brick_wall" | "constructionwand:stone_wand" | "quark:building/crafting/compressed/charcoal_block" | "quark:building/crafting/slabs/blue_shingles_slab" | "quark:building/stonecutting/vertslabs/jasper_vertical_slab_stonecutter" | "prefab:modern_buildings_advanced" | "legendary_monsters:eye_of_air" | "farmersdelight:cutting/rice_panicle" | "netherexp:soul_soil_from_soul_soil_layer" | "quark:building/crafting/vertslabs/purple_shingles_vertical_slab" | "create:copper_tiles_from_ingots_copper_stonecutting" | "minecraft:wayfinder_armor_trim_smithing_template" | "minecraft:dye_light_blue_bed" | "quark:tweaks/smelting/clean_glass" | "quark:building/crafting/acacia_leaf_carpet" | "quark:building/stonecutting/vertslabs/stone_brick_vertical_slab_stonecutter" | "tetra:hammer/acacia" | "cataclysm:stonecutting/stone_tile_stairs_from_stonecutting" | "quark:building/crafting/vertslabs/diorite_bricks_vertical_slab_revert" | "meed:biomancy/primordial_infestation" | "create:cutting/compat/blue_skies/dusk_wood" | "biomancy:decomposing/raw_iron" | "quark:building/stonecutting/stairs/blue_shingles_stairs_stonecutter2" | "create:cutting/compat/byg/stripped_pine_log" | "farmersdelight:cutting/pumpkin" | "create:cut_andesite_brick_stairs" | "minecraft:red_dye_from_tulip" | "create:cutting/compat/regions_unexplored/yellow_bioshroom_stem" | "create:cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "jerotesvillage:explorer_leggings_smith" | "meed:ars_nouveau/immolate" | "minecraft:beacon" | "biomancy:bio_brewing/rejuvenation_serum" | "minecraft:tnt" | "minecraft:mossy_stone_bricks_from_vine" | "create:crushing/compat/elementaryores/ore_ender_end" | "create:milling/fern" | "minecraft:dye_yellow_bed" | "minecraft:flint_and_steel" | "protection_pixel:plagueasloot" | "cataclysm:bone_reptile_helmet" | "create:crushing/compat/elementaryores/ore_emerald_nether" | "meed:galosphere/block_bane" | "cataclysm:polished_obsidian_wall" | "create:haunting/haunted_bell" | "netherexp:cooking/cut_netherite_stairs" | "create:cutting/compat/environmental/stripped_cherry_wood" | "born_in_chaos_v1:scorched_planks_k" | "quark:building/crafting/compressed/bonded_leather_uncompress" | "quark:building/stonecutting/vertslabs/purple_shingles_vertical_slab_stonecutter2" | "quark:building/crafting/jungle_leaf_carpet" | "born_in_chaos_v1:black_argillite_column_k" | "minecraft:black_dye" | "create:polished_cut_deepslate_slab" | "create:cutting/compat/regions_unexplored/stripped_magnolia_log" | "create:crushing/compat/druidcraft/fiery_glass_ore" | "create:cut_granite_wall_from_stone_types_granite_stonecutting" | "meed:soulsweapons/veil_of_fire" | "netherexp:stonecutting/from_soul_slate/soul_slate_brick_wall" | "quark:building/stonecutting/stairs/green_shingles_stairs_stonecutter" | "quark:building/stonecutting/slabs/duskbound_block_slab_stonecutter" | "create:crafting/kinetics/blue_seat" | "jerotesvillage:meror_riot_shield_craft" | "quark:world/stonecutting/stairs/myalite_bricks_stairs_stonecutter" | "create:cutting/compat/blue_skies/stripped_bluebright_log" | "quark:building/crafting/hollowlogs/hollow_blossom_log" | "minecraft:dune_armor_trim_smithing_template_smithing_trim" | "farmersdelight:integration/create/mixing/pie_crust_from_mixing" | "netherexp:claret_stairs" | "quark:building/crafting/shingles/blue_shingles" | "create:deploying/waxed_cut_copper_stairs_from_adding_wax" | "born_in_chaos_v1:armor_plate_from_dark_metal_k_3" | "refinedstorage:crafting_monitor" | "create:polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "born_in_chaos_v1:armor_plate_from_dark_metal_k_4" | "netherexp:bone_rod" | "born_in_chaos_v1:armor_plate_from_dark_metal_k_5" | "quark:building/crafting/vertslabs/polished_shale_vertical_slab" | "cataclysm:smithing/ignitium_helmet" | "born_in_chaos_v1:armor_plate_from_dark_metal_k_2" | "quark:building/crafting/stonevariants/vanilla/polished_dripstone" | "quark:building/crafting/vertslabs/waxed_weathered_cut_copper_vertical_slab_revert" | "minecraft:dye_light_blue_wool" | "minecraft:light_blue_stained_glass_pane" | "create:rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:brown_concrete_powder" | "quark:building/crafting/chests/chest_trapped" | "quark:building/crafting/compressed/sugar_cane_block_uncompress" | "quark:building/stonecutting/stonevariants/tuff_bricks_polished_stonecutting" | "farmersdelight:rice" | "cataclysm:stonecutting/end_stone_pillar_from_stonecutting" | "quark:building/crafting/walls/red_sandstone_bricks_wall" | "minecraft:crimson_hyphae" | "quark:building/crafting/vertslabs/tuff_vertical_slab" | "create:crafting/kinetics/turntable" | "create:cutting/compat/byg/stripped_fir_wood" | "minecraft:coal_from_smelting_coal_ore" | "jerotesvillage:cooked_meganose_snow_lizard_meat_from_smoking" | "create:deploying/waxed_exposed_copper_from_adding_wax" | "quark:building/crafting/chests/cherry_chest" | "create:cutting/compat/quark/stripped_azalea_log" | "refinedstorage:crafting_grid/cyan_crafting_grid" | "quark:building/crafting/stonevariants/limestone_pillar" | "create:crushing/compat/thermal/sulfur_ore" | "waystones:cyan_sharestone" | "create:crushing/nether_wart_block" | "create:cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "create:cutting/compat/byg/stripped_ebony_wood" | "prefab:farm" | "create:cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "jerotesvillage:awn_herb_bandage_craft" | "minecraft:grindstone" | "create:milling/compat/byg/winter_scilla" | "cataclysm:polished_azure_seastone_stairs" | "farmersdelight:crimson_cabinet" | "create:horizontal_framed_glass_from_glass_colorless_stonecutting" | "create:milling/compat/regions_unexplored/pink_snowbelle" | "quark:building/crafting/mangrove_hedge" | "protection_pixel:lancerloot" | "biomancy:bio_forging/impermeable_membrane" | "quark:building/stonecutting/stonevariants/limestone_pillar_stonecutter" | "farmersdelight:cutting/cooked_mutton" | "create:crushing/compat/galosphere/allurite" | "minecraft:granite_slab_from_granite_stonecutting" | "jerotesvillage:black_yellow_button_craft" | "refinedstorage:coloring_recipes/lime_relay" | "biomancy:digesting/nutrient_paste_from_twisting_vines" | "create:emptying/honey_bottle" | "quark:building/stonecutting/light_gray_shingles_stonecutter2" | "create:splashing/the_vault/ornate_chain_rusty" | "minecraft:golden_sword" | "protection_pixel:wingloot" | "quark:building/stonecutting/stonevariants/jasper_bricks_slab_polished_stonecutting" | "create:cutting/compat/regions_unexplored/stripped_eucalyptus_log" | "biomancy:decomposing/gold_nugget" | "create:small_tuff_brick_wall" | "meed:relics/vanishing" | "create:polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "create:milling/compat/environmental/orange_hibiscus" | "quark:building/stonecutting/slabs/dripstone_bricks_slab_stonecutter" | "biomancy:decomposing/heart_of_the_sea" | "create:compacting/diorite_from_flint" | "netherexp:stonecutting/from_polished_basalt/polished_basalt_bricks" | "quark:world/stonecutting/slabs/calcite_slab_stonecutter" | "legendary_monsters:ancient_dripstone_tile_stairs_stonecutter_adbr" | "quark:world/stonecutting/stairs/polished_jasper_stairs_stonecutter2" | "quark:tools/smithing/rune_smithing_light_blue" | "quark:building/stonecutting/stairs/shingles_stairs_stonecutter2" | "minecraft:furnace_minecart" | "quark:tweaks/crafting/utility/wool/light_gray_wool" | "create:crafting/kinetics/cogwheel" | "quark:world/crafting/walls/jasper_wall" | "jerotesvillage:ruin_stone_brick_wall_from_ruin_stone_bricks_stonecutting" | "farmersdelight:scaffolding_from_canvas" | "minecraft:gray_wool" | "quark:building/crafting/stonevariants/shale_pillar" | "minecraft:waxed_weathered_cut_copper" | "legendary_monsters:mossy_hammer" | "refinedstorage:64k_storage_disk" | "create:crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "netherexp:stonecutting/from_bone_block/bone_fence" | "create:cut_granite_slab" | "jerotesvillage:ancient_second_rounder_noble_helmet_smith" | "create:crafting/materials/zinc_block_from_compacting" | "create:cutting/compat/integrateddynamics/menril_wood" | "create:crafting/kinetics/red_valve_handle_from_other_valve_handle" | "minecraft:netherite_ingot_from_netherite_block" | "biomancy:decomposing/melon_slice" | "quark:building/crafting/shingles/light_gray_shingles_dye" | "quark:building/crafting/stonevariants/chiseled_shale_bricks" | "create:crafting/appliances/netherite_diving_boots_from_netherite" | "jerotesvillage:carved_horse_slab_craft" | "create:crushing/raw_tin" | "cataclysm:stonecutting/frosted_stone_brick_slab_from_stonecutting" | "quark:world/stonecutting/slabs/diorite_bricks_slab_stonecutter" | "quark:world/crafting/panes/green_corundum" | "quark:tweaks/crafting/orange_glass" | "biomancy:decomposing/crocodile_scute" | "biomancy:decomposing/cookie" | "art_of_forging:forged_wall" | "biomancy:crafting/primal_flesh_slab" | "biomancy:digesting/nutrient_paste_from_underweed" | "create:smelting/silver_ingot_compat_galosphere" | "quark:building/stonecutting/vertslabs/duskbound_block_vertical_slab_stonecutter" | "create:weathered_copper_shingle_slab" | "quark:building/stonecutting/vertslabs/waxed_oxidized_cut_copper_vertical_slab_from_waxed_oxidized_copper" | "refinedstorage:quartz_enriched_iron_from_block" | "minecraft:red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "jerotesvillage:sediment_mud_brick_wall_craft" | "quark:oddities/crafting/magnet" | "quark:building/crafting/stripped_bamboo_post" | "minecraft:chiseled_stone_bricks" | "jerotesvillage:villager_block_piscator_craft" | "quark:building/crafting/vertslabs/mangrove_vertical_slab_revert" | "quark:building/crafting/chests/chest_revert" | "lendersdelight:cook/cooked_ender_golem_meat_from_campfire_cooking" | "jeed:bad_omen" | "create:cutting/compat/regions_unexplored/redwood_wood" | "create:crushing/ochrum" | "minecraft:polished_granite_stairs_from_granite_stonecutting" | "create:cutting/stripped_oak_wood" | "functionalstorage:cherry_4" | "quark:world/crafting/waxed_yellow_corundum" | "functionalstorage:cherry_2" | "minecraft:spruce_pressure_plate" | "functionalstorage:cherry_1" | "quark:experimental/trowel" | "minecraft:purple_terracotta" | "quark:building/crafting/slabs/polished_dripstone_slab" | "create:cutting/compat/regions_unexplored/stripped_socotra_log" | "create:cutting/compat/nethers_exoticism/stripped_ramboutan_log" | "jerotesvillage:sun_sandstone_slab_craft" | "meed:tombstone/mercy" | "biomancy:crafting/porous_primal_flesh_slab" | "biomancy:digesting/nutrient_paste_from_honeycomb" | "minecraft:deepslate_tiles_from_deepslate_bricks_stonecutting" | "quark:building/stonecutting/stonevariants/jasper_bricks_stonecutter" | "quark:tweaks/crafting/utility/tools/stone_hoe" | "meed:relics/anti_heal" | "minecraft:hay_block" | "quark:building/crafting/vertslabs/cyan_shingles_vertical_slab_revert" | "create:small_deepslate_brick_stairs" | "quark:building/crafting/vertslabs/mud_brick_vertical_slab" | "create:crafting/kinetics/vertical_gearboxfrom_conversion" | "jerotesvillage:carved_flag_craft" | "biomancy:decomposing/forge_seeds" | "create:mangrove_window" | "quark:building/crafting/slabs/polished_tuff_slab" | "quark:world/crafting/woodsets/azalea/stripped_wood" | "create:jungle_window" | "jeed:compat/tipped_spikes_potion_provider" | "cataclysm:stonecutting/quartz_brick_wall_from_stonecutting" | "quark:building/crafting/vertslabs/polished_calcite_vertical_slab" | "meed:cataclysm/blazing_brand" | "minecraft:smooth_quartz_slab_from_smooth_quartz_stonecutting" | "biomancy:decomposing/guano" | "jerotesvillage:villager_block_villagehead_craft" | "create:polished_cut_tuff_stairs" | "biomancy:decomposing/sniffer_egg" | "refinedstorage:coloring_recipes/light_gray_network_receiver" | "refinedstorage:coloring_recipes/pink_wireless_transmitter" | "create:cut_calcite_slab" | "born_in_chaos_v1:mossy_black_argillite_brick_k" | "create:crafting/kinetics/train_door" | "biomancy:decomposing/impermeable_membrane" | "create:crafting/kinetics/rotation_speed_controller" | "prefab:quartz_crete_pillar" | "quark:world/stonecutting/stairs/permafrost_stairs_stonecutter" | "create:cutting/compat/twilightforest/stripped_sorting_log" | "minecraft:cut_copper" | "quark:building/stonecutting/vertslabs/cut_copper_vertical_slab_from_cut_copper" | "create:cutting/compat/byg/jacaranda_log" | "cataclysm:stonecutting/obsidian_brick_slab_from_stonecutting" | "create:polished_cut_dripstone_slab" | "biomancy:decomposing/amber_curiosity" | "create:haunting/compat/hauntedharvest/rotten_apple" | "farmersdelight:cutting/birch_door" | "jerotesvillage:meror_shotgun_craft" | "create:cutting/compat/atmospheric/stripped_rosewood" | "protection_pixel:tosakihelmetloot" | "jerotesvillage:carved_bricks_craft" | "refinedstorage:coloring_recipes/green_grid" | "minecraft:smooth_sandstone_stairs" | "biomancy:bio_forging/digester" | "minecraft:copper_ingot_from_blasting_copper_ore" | "quark:building/crafting/vertslabs/red_nether_brick_vertical_slab_revert" | "jeed:potion_accepors" | "create:exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "cataclysm:burning_ashes" | "netherexp:pumpkin_seeds_from_sorrowsquash" | "create:crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "netherexp:cooking/iron_nugget_from_iron_scrap" | "jerotesvillage:golden_bright_melon_crate_craft" | "minecraft:rabbit_stew_from_red_mushroom" | "minecraft:prismarine_brick_stairs" | "biomancy:decomposing/moose_ribs" | "biomancy:decomposing/primal_orifice" | "quark:building/stonecutting/stonevariants/polished_dripstone_slab_stonecutter2" | "farmersdelight:cutting/white_tulip" | "quark:world/crafting/woodsets/blossom/fence" | "create:crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "farmersdelight:potato_crate" | "quark:building/crafting/chests/oak_chest" | "minecraft:exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "pasterdream:stongcutting_40" | "create:splashing/cyan_concrete_powder" | "waystones:bound_scroll" | "meed:trials/trial_curse" | "quark:world/crafting/woodsets/blossom/wood" | "quark:building/crafting/chests/purpur_trapped_chest" | "quark:building/stonecutting/green_shingles_stonecutter2" | "quark:building/stonecutting/vertslabs/prismarine_vertical_slab_stonecutter" | "refinedstorage:fluid_grid/orange_fluid_grid" | "minecraft:netherite_block" | "create:oxidized_copper_shingle_slab" | "create:cutting/compat/forbidden_arcanus/stripped_aurum_wood" | "create:milling/pink_tulip" | "sophisticatedbackpacks:backpack" | "quark:building/stonecutting/slabs/light_blue_shingles_slab_stonecutter" | "meed:sanguinare" | "create:milling/compat/environmental/cartwheel" | "create:cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "refinedstorage:coloring_recipes/purple_disk_manipulator" | "refinedstorage:coloring_recipes/cyan_detector" | "create:cutting/compat/twilightforest/stripped_twilight_oak_log" | "farmersdelight:cod_roll" | "create:crushing/deepslate_iron_ore" | "quark:building/crafting/stonevariants/myalite_bricks" | "quark:building/crafting/vertslabs/dark_prismarine_vertical_slab" | "sophisticatedbackpacks:pump_upgrade" | "minecraft:crossbow" | "create:splashing/thermal/crushed_raw_silver" | "quark:building/crafting/compressed/berry_sack" | "create:splashing/immersiveengineering/crushed_raw_uranium" | "quark:building/crafting/vertslabs/iron_plate_vertical_slab" | "quark:building/crafting/vertslabs/dark_prismarine_vertical_slab_revert" | "create:crushing/diorite_recycling" | "lendersdelight:cook/cooked_amethyst_crab_meat" | "minecraft:diamond" | "create:cutting/compat/atmospheric/stripped_rosewood_log" | "minecraft:crimson_slab" | "jerotesvillage:sun_sandstone_wall_craft" | "biomancy:digesting/nutrient_paste_from_cactus" | "create:milling/compat/byg/pink_allium" | "netherexp:soul_permafrost" | "quark:building/crafting/gold_bars" | "jerotesvillage:wonderland_hanging_sign_craft" | "protection_pixel:susploot" | "jerotesvillage:wonderland_fruit_craft" | "quark:building/crafting/stonevariants/calcite_bricks" | "create:crafting/curiosities/peculiar_bell" | "born_in_chaos_v1:smoldering_infernal_ember_craft" | "create:polished_cut_tuff_wall" | "quark:building/stonecutting/vertslabs/blackstone_bricks_vertical_slab_stonecutter" | "create:cutting/compat/regions_unexplored/stripped_willow_log" | "create:polished_cut_limestone_wall" | "refinedstorage:coloring_recipes/yellow_controller" | "quark:world/crafting/waxed_orange_corundum" | "create:small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "biomancy:stonecutting/smooth_primal_flesh_wall_from_smooth_primal_flesh" | "moblassos:aqua_lasso" | "biomancy:decomposing/rotten_flesh" | "minecraft:waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "create:splashing/yellow_concrete_powder" | "lendersdelight:cook/cooked_amethyst_crab_meat_from_smoking" | "create:milling/compat/regions_unexplored/day_lily" | "create:andesite_pillar_from_stone_types_andesite_stonecutting" | "minecraft:mossy_cobblestone_stairs" | "itemfilters:and" | "lendersdelight:amethyst_crab_sandwich" | "lendersdelight:improved_dog_food" | "create:crushing/compat/silentgems/carnelian_ore" | "quark:building/stonecutting/vertslabs/polished_blackstone_vertical_slab_stonecutter" | "minecraft:acacia_hanging_sign" | "create:small_limestone_brick_slab" | "quark:building/crafting/vertslabs/polished_granite_vertical_slab" | "jerotesvillage:meror_bullet_craft" | "refinedstorage:coloring_recipes/yellow_relay" | "jerotesvillage:golden_bright_melon_crate" | "cataclysm:stonecutting/chiseled_azure_seastone_pillar_wall_from_stonecutting" | "biomancy:bio_forging/ornate_flesh" | "minecraft:blue_bed" | "netherexp:light_blue_dye_from_soul_torchflower" | "create:crushing/raw_lead" | "create:crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "netherexp:etched_soul_slate_tiles" | "quark:world/stonecutting/slabs/granite_bricks_slab_stonecutter" | "jerotesvillage:gold_nugget_from_other_blast" | "quark:building/stonecutting/vertslabs/deepslate_tile_vertical_slab_from_cobbled_deepslate" | "create:crafting/kinetics/mechanical_harvester" | "create:polished_cut_scorchia_stairs" | "quark:building/crafting/chests/crimson_chest_trapped" | "jerotesvillage:dye_from_sun_orange_flower" | "quark:building/stonecutting/stairs/gray_shingles_stairs_stonecutter" | "quark:building/stonecutting/vertslabs/white_shingles_vertical_slab_stonecutter2" | "netherexp:polished_basalt_bricks" | "cataclysm:chorus_slab" | "minecraft:sponge" | "minecraft:quartz_stairs" | "jeed:regeneration" | "waystones:yellow_sharestone" | "farmersdelight:full_tatami_mat_from_halves" | "quark:building/crafting/vertslabs/oxidized_cut_copper_vertical_slab_revert" | "quark:building/stonecutting/vertslabs/deepslate_brick_vertical_slab_from_deepslate_bricks" | "jerotesvillage:hag_replacement/jerotesvillage_purple_sand_alchemy_bomb" | "quark:building/stonecutting/vertslabs/polished_deepslate_vertical_slab_from_polished_deepslate" | "minecraft:red_stained_glass" | "create:small_calcite_brick_slab_recycling" | "quark:building/crafting/walls/dripstone_bricks_wall" | "quark:building/crafting/shingles/white_shingles" | "quark:building/stonecutting/vertslabs/cobblestone_vertical_slab_stonecutter" | "minecraft:light_gray_stained_glass_pane_from_glass_pane" | "create:cutting/compat/upgrade_aquatic/stripped_driftwood" | "minecraft:green_carpet" | "minecraft:waxed_exposed_cut_copper_from_honeycomb" | "create:haunting/compat/farmersdelight/rotten_tomato" | "farmersdelight:beef_patty" | "quark:world/crafting/walls/limestone_wall" | "quark:building/crafting/vertslabs/polished_diorite_vertical_slab" | "quark:building/stonecutting/stairs/gray_shingles_stairs_stonecutter2" | "farmersdelight:integration/immersiveengineering/cloche/rice" | "sophisticatedbackpacks:tool_swapper_upgrade" | "quark:building/stonecutting/vertslabs/exposed_cut_copper_vertical_slab_from_exposed_cut_copper" | "minecraft:beetroot_soup" | "create:blasting/ingot_silver_compat_immersiveengineering" | "create:splashing/mekanism/crushed_raw_tin" | "minecraft:lime_terracotta" | "refinedstorage:16k_storage_disk_from_storage_housing" | "create:crushing/raw_zinc_block" | "minecraft:blackstone_slab_from_blackstone_stonecutting" | "minecraft:jungle_wood" | "incendium:upgrade_elytra" | "create:crafting/materials/experience_nugget_from_block" | "minecraft:gray_stained_glass_pane_from_glass_pane" | "create:milling/wither_rose" | "minecraft:stone_slab" | "protection_pixel:watertankloot" | "legendary_monsters:soul_summoner_activate" | "create:pressing/compat/betterendforge/chorus_nylium_path" | "minecraft:acacia_slab" | "minecraft:brick_stairs_from_bricks_stonecutting" | "minecraft:jungle_stairs" | "create:milling/compat/byg/pink_anemone" | "netherexp:black_ice" | "cataclysm:stonecutting/azure_seastone_tiles_from_stonecutting" | "create:small_crimsite_brick_slab" | "quark:world/crafting/walls/andesite_bricks_wall" | "create:polished_cut_asurine_slab_recycling" | "refinedstorage:coloring_recipes/purple_crafter" | "quark:building/crafting/furnaces/blackstone_minecart" | "create:cutting/oak_log" | "farmersdelight:tomato" | "farmersdelight:dark_oak_cabinet" | "create:cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "create:milling/cornflower" | "lendersdelight:koboleton_pumpkin" | "create:cutting/compat/regions_unexplored/stripped_kapok_log" | "create:smelting/glass_pane_from_vertical_framed_glass_pane" | "cataclysm:azure_seastone_pillar_wall" | "cataclysm:stonecutting/azure_seastone_brick_stairs_from_stonecutting" | "minecraft:cobbled_deepslate_stairs" | "minecraft:baked_potato" | "biomancy:decomposing/sponge" | "lendersdelight:cook/fried_abyssal_egg_from_campfire_cooking" | "minecraft:cooked_salmon" | "legendary_monsters:eye_of_moss" | "cataclysm:frosted_stone_bricks" | "prefab:heap_of_timber_to_bundle" | "quark:building/stonecutting/stonevariants/myalite_pillar_stonecutter" | "quark:world/crafting/stairs/andesite_bricks_stairs" | "jerotesvillage:anesthetized_bandage_craft" | "meed:biomancy/armor_shred" | "biomancy:decomposing/mosquito_larva" | "biomancy:bio_forging/wither_skeleton_skull" | "minecraft:golden_leggings" | "jerotesvillage:villager_metal_sword_craft" | "farmersdelight:hamburger" | "quark:building/crafting/vertslabs/shale_vertical_slab" | "biomancy:decomposing/smooth_primal_flesh_stairs" | "minecraft:stone_pressure_plate" | "quark:building/stonecutting/stairs/cobblestone_bricks_stairs_stonecutter" | "create:cut_asurine_brick_wall" | "quark:building/crafting/oak_hedge" | "quark:building/crafting/shingles/green_shingles" | "quark:building/stonecutting/slabs/lime_shingles_slab_stonecutter" | "create:crushing/compat/exnihilosequentia/end_stone" | "quark:building/crafting/cherry_ladder" | "create:milling/compat/regions_unexplored/bleeding_heart" | "minecraft:tide_armor_trim_smithing_template_smithing_trim" | "create:crafting/kinetics/yellow_seat" | "create:cutting/compat/biomesoplenty/willow_log" | "farmersdelight:integration/immersiveengineering/metalpress/pumpkin" | "quark:building/crafting/slabs/red_sandstone_bricks_slab" | "jerotesvillage:hag_replacement/minecraft_mud_bricks" | "cataclysm:ceraunus" | "quark:building/crafting/mangrove_post" | "farmersdelight:integration/immersiveengineering/cloche/cabbage" | "minecraft:bone_meal_from_bone_block" | "quark:building/crafting/slabs/gray_shingles_slab" | "minecraft:mangrove_boat" | "create:crushing/crimsite_recycling" | "quark:building/crafting/stairs/raw_copper_bricks_stairs" | "biomancy:decomposing/pointed_dripstone" | "jerotesvillage:carved_leader_upgrade_smithing_template_craft" | "biomancy:crafting/malignant_flesh_slab" | "quark:building/crafting/lavender_blossom_hedge" | "create:blasting/zinc_ingot_from_raw_ore" | "netherexp:stonecutting/from_polished_basalt_bricks/polished_basalt_brick_slab" | "create:mixing/mud_by_mixing" | "meed:tombstone/feather_fall" | "quark:building/crafting/pink_stool" | "meed:soulsweapons/moon_herald" | "minecraft:cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "farmersdelight:cooking/vegetable_soup" | "netherexp:basalt_slab" | "quark:building/stonecutting/orange_shingles_stonecutter2" | "quark:world/stonecutting/slabs/permafrost_bricks_slab_stonecutter2" | "create:crafting/kinetics/portable_fluid_interface" | "jerotesvillage:slavery_supervisor_chestplate_smith" | "create:smelting/ingot_tin_compat_ic2" | "create:cutting/compat/twilightforest/stripped_twilight_oak_wood" | "born_in_chaos_v1:skull_crusher_k" | "quark:building/crafting/compressed/gunpowder_sack_uncompress" | "create:deploying/waxed_copper_tiles_from_adding_wax" | "create:cutting/compat/regions_unexplored/stripped_maple_wood" | "minecraft:dark_oak_trapdoor" | "create:crushing/compat/thermal/cinnabar_ore" | "jerotesvillage:villager_block_jailer_craft" | "refinedstorage:coloring_recipes/cyan_network_transmitter" | "quark:world/crafting/waxed_green_corundum" | "create:cutting/compat/regions_unexplored/stripped_redwood_wood" | "netherexp:cooking/netherrack" | "create:smelting/ingot_lead_compat_immersiveengineering" | "create:cutting/compat/the_vault/overgrown_wooden_log" | "quark:building/crafting/vertslabs/cherry_vertical_slab_revert" | "quark:tweaks/crafting/utility/chests/warped_chest_wood" | "create:cutting/compat/architects_palette/stripped_twisted_wood" | "netherexp:stonecutting/from_basalt/basalt_stairs" | "minecraft:polished_deepslate_slab" | "minecraft:acacia_chest_boat" | "quark:building/crafting/compressed/potato_crate_uncompress" | "create:cut_limestone_slab_from_stone_types_limestone_stonecutting" | "biomancy:decomposing/mob_claw" | "create:cutting/compat/regions_unexplored/willow_log" | "biomancy:decomposing/moose_antler" | "jerotesvillage:serpon_alloy_ingotin_craft" | "create:crafting/appliances/linked_controller" | "minecraft:orange_glazed_terracotta" | "minecraft:pink_carpet" | "minecraft:deepslate_bricks" | "quark:building/stonecutting/stairs/lime_shingles_stairs_stonecutter2" | "minecraft:waxed_exposed_copper_from_honeycomb" | "jerotesvillage:carved_contacter_craft" | "prefab:double_compressed_dirt_from_compressed_dirt" | "legendary_monsters:soul_summoner" | "jerotesvillage:pink_slime_ball_craft" | "minecraft:waxed_weathered_cut_copper_stairs" | "jerotesvillage:carved_horn_craft" | "netherexp:stonecutting/from_smooth_netherrack/netherrack_brick_wall" | "born_in_chaos_v1:purple_stained_glass_panel_k" | "minecraft:mossy_stone_brick_stairs" | "create:crushing/compat/exnihilosequentia/diorite" | "jerotesvillage:dye_from_tinbush" | "minecraft:amethyst_block" | "create:granite_pillar_from_stone_types_granite_stonecutting" | "protection_pixel:magneticasloot" | "jerotesvillage:cut_sun_sandstone_slab_from_cut_sun_sandstone_stonecutting" | "jerotesvillage:black_yellow_boat_craft" | "quark:building/crafting/chests/mangrove_trapped_chest" | "quark:building/stonecutting/slabs/brown_shingles_slab_stonecutter" | "create:cutting/compat/byg/stripped_cika_log" | "quark:building/crafting/vertplanks/vertical_cherry_planks" | "create:milling/compat/regions_unexplored/alpha_dandelion" | "create:cutting/compat/goodending/muddy_oak_log" | "create:deploying/waxed_exposed_copper_tiles_from_adding_wax" | "farmersdelight:integration/immersiveengineering/crusher/wild_beetroots" | "minecraft:nether_brick" | "lendersdelight:pasta_with_witherite" | "biomancy:decomposing/diamond" | "create:crafting/kinetics/wrench" | "prefab:wooden_crate" | "quark:building/stonecutting/vertslabs/diorite_vertical_slab_stonecutter" | "create:cutting/compat/the_vault/stripped_driftwood_log" | "netherexp:basalt_stairs" | "waystones:clear_sharestone" | "prefab:quartz_crete_slab" | "biomancy:crafting/malignant_flesh_from_slabs" | "minecraft:brown_wool" | "jerotesvillage:golden_bright_melon_craft" | "quark:building/crafting/vertslabs/purpur_vertical_slab_revert" | "netherexp:smooth_netherrack_wall" | "minecraft:purple_bed" | "born_in_chaos_v1:dark_stained_glass_panel_k" | "create:cutting/compat/biomesoplenty/jacaranda_wood" | "create:cut_scoria_stairs" | "quark:world/crafting/woodsets/ancient/sign" | "meed:biomancy/frenzy" | "born_in_chaos_v1:dark_atrium_craft" | "create:crushing/raw_osmium" | "jerotesvillage:magicka_scale_upgrade_smithing_template_craft" | "create:crafting/kinetics/furnace_minecart_from_contraption_cart" | "biomancy:crafting/smooth_primal_flesh_stairs" | "cataclysm:stonecutting/azure_seastone_fence_from_stonecutting" | "refinedstorage:coloring_recipes/blue_network_receiver" | "quark:world/crafting/stairs/polished_myalite_stairs" | "biomancy:decomposing/salmon" | "farmersdelight:cutting/cherry_log" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "biomancy:crafting/despoil_sickle" | "minecraft:wheat" | "create:cutting/acacia_log" | "create:cut_tuff_brick_stairs" | "born_in_chaos_v1:fire_dust_k_4" | "born_in_chaos_v1:fire_dust_k_2" | "born_in_chaos_v1:fire_dust_k_3" | "born_in_chaos_v1:nightmarestalkerskullk" | "create:small_scoria_brick_wall" | "born_in_chaos_v1:fire_dust_k_1" | "jerotesvillage:wonderland_boat_craft" | "create:cut_scoria_wall_from_stone_types_scoria_stonecutting" | "quark:building/crafting/slabs/lime_shingles_slab" | "prefab:heap_of_timber" | "farmersdelight:cutting/wild_cabbages" | "quark:tweaks/crafting/utility/misc/tnt_minecart" | "jerotesvillage:therapeutic_tablet_use_mortar_and_pestle_craft" | "minecraft:bow" | "jerotesvillage:giant_monster_helmet_craft" | "cataclysm:meat_shredder" | "create:polished_cut_calcite_stairs" | "quark:building/stonecutting/stonevariants/chiseled_calcite_bricks_stonecutter" | "protection_pixel:anchorpointasloot" | "netherexp:wraithing_lesion" | "farmersdelight:cutting/amethyst_block" | "jerotesvillage:purple_sand_tnt_craft" | "minecraft:andesite_stairs" | "farmersdelight:gold_nugget_from_smelting_knife" | "refinedstorage:coloring_recipes/purple_crafting_monitor" | "create:cut_limestone_from_stone_types_limestone_stonecutting" | "jerotesvillage:hag_replacement/jerotesvillage_marine_reptiles_fine_scale" | "create:milling/compat/biomesoplenty/wilted_lily" | "create:cutting/compat/environmental/stripped_cherry_log" | "cataclysm:black_steel_ingot_from_block" | "tetra:chainmail_leggings" | "farmersdelight:cutting/ham" | "quark:building/stonecutting/stonevariants/diorite_bricks_vertical_slab_polished_stonecutting" | "refinedstorage:coloring_recipes/brown_crafter" | "biomancy:decomposing/malignant_flesh_wall" | "create:cut_ochrum_brick_slab_recycling" | "protection_pixel:evasionwingloot" | "minecraft:dark_oak_boat" | "quark:building/crafting/vertslabs/smooth_sandstone_vertical_slab" | "create:cutting/compat/the_vault/chromatic_log" | "protection_pixel:bloodprisonerasloot" | "prefab:quartz_crete_stairs_up_left" | "quark:building/crafting/stonevariants/jasper_pillar" | "prefab:compressed_dirt_from_dirt" | "minecraft:copper_ingot_from_smelting_deepslate_copper_ore" | "create:small_diorite_brick_stairs" | "minecraft:mossy_stone_brick_wall" | "jerotesvillage:ruin_stone_brick_slab_craft" | "create:cutting/compat/botania/stripped_livingwood" | "sophisticatedbackpacks:feeding_upgrade" | "quark:building/stonecutting/stonevariants/jasper_bricks_wall_rough_stonecutting" | "create:crafting/kinetics/clutch" | "jerotesvillage:scrap_villager_metal_from_blasting" | "farmersdelight:smoked_ham" | "minecraft:firework_rocket_simple" | "create:milling/orange_tulip" | "quark:world/crafting/stairs/permafrost_bricks_stairs" | "create:crafting/kinetics/encased_fan" | "refinedstorage:coloring_recipes/network_receiver" | "netherexp:silica_sandstone_stairs" | "create:smelting/lead_ingot_compat_thermal" | "jerotesvillage:rambler_leather_shield_craft" | "born_in_chaos_v1:spinyshelltrap_k" | "jerotes:golden_giant_beast_armor_craft" | "easy_villagers:converter" | "minecraft:andesite" | "create:polished_cut_diorite_slab" | "meed:enlightened_end/frigid" | "create:crafting/kinetics/lime_seat_from_other_seat" | "functionalstorage:collector_upgrade" | "quark:building/crafting/vertslabs/calcite_vertical_slab_revert" | "meed:mobs_of_sins/serrated" | "create:cutting/compat/byg/stripped_blue_enchanted_log" | "cataclysm:void_scatter_arrow" | "refinedstorage:wireless_transmitter" | "jerotesvillage:villager_block_illager_craft" | "cataclysm:bone_reptile_chestplate" | "create:milling/compat/regions_unexplored/orange_coneflower" | "farmersdelight:cooking/apple_cider" | "create:polished_cut_calcite_slab_recycling" | "minecraft:dye_light_gray_carpet" | "farmersdelight:integration/create/mixing/cabbage_slice_from_mixing" | "create:pressing/compat/betterendforge/crystal_moss_path" | "art_of_forging:demonic_axe" | "create:crafting/kinetics/red_seat_from_other_seat" | "jerotesvillage:serpon_blowpipe_craft" | "create:smelting/ingot_tin_compat_mekanism" | "refinedstorageaddons:wireless_crafting_grid" | "minecraft:stone" | "minecraft:blackstone_stairs" | "refinedstorage:coloring_recipes/magenta_grid" | "minecraft:dye_orange_carpet" | "jerotesvillage:second_round_world_exploration_guide_craft" | "quark:building/crafting/rusty_iron_plate2" | "biomancy:stonecutting/malignant_flesh_stairs_from_malignant_flesh" | "prefab:clutch_of_eggs" | "quark:building/crafting/slabs/light_blue_shingles_slab" | "jerotesvillage:villager_block_lamplighter_craft" | "minecraft:dye_cyan_bed" | "create:crafting/appliances/tree_fertilizer" | "netherexp:claret_fence_gate" | "create:cutting/compat/atmospheric/stripped_yucca_log" | "quark:tweaks/crafting/utility/wool/black_wool" | "quark:world/crafting/walls/shale_bricks_wall" | "refinedstorage:crafting_grid/pink_crafting_grid" | "netherexp:ghoul_o_lantern" | "create:crafting/kinetics/display_board" | "refinedstorage:crafter_manager" | "create:cutting/compat/regions_unexplored/stripped_blackwood_wood" | "create:polished_cut_crimsite_stairs" | "quark:tweaks/crafting/utility/coral/tube_to_blue" | "minecraft:nether_brick_fence" | "farmersdelight:cutting/wither_rose" | "farmersdelight:cutting/porkchop" | "create:cutting/compat/hexcasting/stripped_edified_log" | "create:small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "create:haunting/infested_stone" | "create:layered_diorite_from_stone_types_diorite_stonecutting" | "jerotesvillage:meror_standard_helmet_smith" | "biomancy:decomposing/hemolymph_sac" | "biomancy:bio_forging/fibrous_flesh_slab" | "quark:building/crafting/vertplanks/vertical_spruce_planks" | "biomancy:decomposing/glow_lichen" | "minecraft:iron_ingot_from_blasting_raw_iron" | "jerotesvillage:cooked_greyscale_from_smoking" | "biomancy:bio_forging/tall_full_flesh_door" | "minecraft:birch_chest_boat" | "jerotesvillage:botanize_village_map_craft" | "biomancy:crafting/primal_flesh_from_slabs" | "create:filling/compat/aether/aether_grass_block" | "jerotesvillage:villager_block_shopkeeper_craft" | "netherexp:smokestalk_slab" | "quark:building/crafting/stairs/cobblestone_bricks_stairs" | "create:crafting/kinetics/mechanical_press" | "art_of_forging:rending_scissor_red" | "quark:building/crafting/vertslabs/green_shingles_vertical_slab" | "netherexp:soul_slate_bricks_from_etched" | "minecraft:polished_deepslate_wall_from_polished_deepslate_stonecutting" | "biomancy:bio_forging/bio_lantern_blue" | "create:cut_scorchia_brick_slab_recycling" | "create:cutting/compat/blue_skies/crystallized_log" | "quark:world/crafting/polished_limestone" | "create:tiled_glass_pane" | "minecraft:green_candle" | "quark:building/stonecutting/slabs/green_shingles_slab_stonecutter2" | "quark:building/crafting/vertslabs/wax/waxed_cut_copper_vertical_slab_hc" | "minecraft:waxed_weathered_cut_copper_stairs_from_honeycomb" | "biomancy:decomposing/brain_coral_fan" | "create:small_veridium_brick_wall" | "cataclysm:stonecutting/stone_tile_slab_from_stonecutting" | "minecraft:coal_from_smelting_deepslate_coal_ore" | "jerotesvillage:smooth_sun_sandstone_slab_from_smooth_sun_sandstone_stonecutting" | "create:small_ochrum_brick_wall" | "quark:building/crafting/vertplanks/vertical_birch_planks" | "protection_pixel:brassplate" | "create:small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "refinedstorage:256k_fluid_storage_disk_from_storage_housing" | "tetra:blazing_grips" | "born_in_chaos_v1:bone_handle_k" | "farmersdelight:lime_hanging_canvas_sign" | "minecraft:mud_brick_slab" | "quark:world/crafting/waxed_violet_corundum" | "quark:building/stonecutting/vertslabs/cut_sandstone_vertical_slab_stonecutter" | "quark:tweaks/crafting/light_blue_glass" | "quark:building/crafting/walls/soul_sandstone_wall" | "minecraft:cooked_mutton_from_smoking" | "minecraft:hopper_minecart" | "minecraft:blue_stained_glass_pane" | "quark:tools/smithing/rune_smithing_purple" | "moblassos:emerald_lasso" | "waystones:magenta_sharestone" | "farmersdelight:integration/immersiveengineering/crusher/wild_onions" | "jerotesvillage:dye_from_fibre_dust_flower" | "farmersdelight:pie_crust" | "born_in_chaos_v1:purple_stained_glass_k" | "quark:world/stonecutting/slabs/andesite_bricks_slab_stonecutter" | "quark:building/stonecutting/stonevariants/diorite_bricks_slab_polished_stonecutting" | "create:milling/compat/regions_unexplored/dorcel" | "biomancy:decomposing/lost_tentacle" | "create:crushing/compat/druidcraft/moonstone_ore" | "born_in_chaos_v1:shellmace_k" | "create:cutting/compat/environmental/wisteria_log" | "create:cutting/acacia_wood" | "farmersdelight:cooked_chicken_cuts_from_campfire_cooking" | "farmersdelight:cutting/jungle_hanging_sign" | "quark:building/crafting/slabs/dripstone_block_slab" | "create:crushing/compat/silentgems/black_diamond_ore" | "refinedstorage:coloring_recipes/grid" | "cataclysm:stonecutting/polished_azure_seastone_stairs_from_stonecutting" | "jerotesvillage:meror_metal_mixture_blast" | "meed:alexscaves/darkness_incarnate" | "refinedstorage:coloring_recipes/orange_network_transmitter" | "create:cutting/compat/byg/stripped_palm_wood" | "minecraft:light_gray_concrete_powder" | "farmersdelight:apple_pie" | "netherexp:stonecutting/from_soul_slate/soul_slate_slab" | "farmersdelight:black_canvas_sign" | "jerotesvillage:cooked_lake_loach_from_smoking" | "create:cutting/stripped_birch_wood" | "minecraft:diorite_stairs" | "create:crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "create:cutting/compat/byg/willow_log" | "biomancy:decomposing/cockroach_wing" | "quark:building/stonecutting/slabs/light_gray_shingles_slab_stonecutter2" | "refinedstorage:coloring_recipes/red_crafting_grid" | "biomancy:decomposing/forge_string" | "create:cut_crimsite_slab" | "create:dark_oak_window_pane" | "create:pressing/aether_dirt_path" | "farmersdelight:purple_hanging_canvas_sign" | "minecraft:deepslate_brick_wall_from_polished_deepslate_stonecutting" | "quark:building/stonecutting/stonevariants/jasper_bricks_polished_stonecutting" | "create:cut_veridium_slab_recycling" | "minecraft:end_stone_brick_stairs_from_end_stone_stonecutting" | "farmersdelight:cooked_cod_slice_from_smoking" | "born_in_chaos_v1:carrotsword_craft" | "quark:building/stonecutting/vertslabs/polished_deepslate_vertical_slab_from_cobbled_deepslate" | "prefab:ski_lodge" | "born_in_chaos_v1:spiny_shell_helm_k" | "quark:world/stonecutting/slabs/permafrost_slab_stonecutter" | "jerotesvillage:raw_meror_metal_blast" | "quark:building/crafting/vertplanks/vertical_mangrove_planks" | "refinedstorage:coloring_recipes/orange_relay" | "lendersdelight:cook/deepling_meat_from_smoking" | "minecraft:netherite_scrap" | "create:crafting/kinetics/wooden_bracket" | "create:splashing/endergetic/petrified_overworld_corrock_crown" | "minecraft:cut_sandstone" | "quark:building/crafting/furnaces/blackstone_minecart_tweaked" | "create:mixing/honey" | "waystones:orange_sharestone" | "create:cutting/stripped_dark_oak_log" | "create:cutting/compat/blue_skies/stripped_starlit_log" | "minecraft:nether_brick_slab" | "quark:building/stonecutting/vertslabs/cut_sandstone_vertical_slab2_stonecutter" | "biomancy:decomposing/primal_flesh_slab" | "jerotesvillage:purple_sandstone_slab_craft" | "create:small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "biomancy:crafting/fibrous_flesh_slab" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_log" | "refinedstorage:coloring_recipes/lime_disk_manipulator" | "biomancy:digesting/nutrient_paste_from_tall_grass" | "minecraft:campfire" | "biomancy:decomposing/dropbear_claw" | "farmersdelight:cutting/oak_sign" | "create:cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:brick_stairs" | "jerotesvillage:heal_spear_craft" | "farmersdelight:cooking/chicken_soup" | "create:polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "quark:world/crafting/walls/permafrost_bricks_wall" | "create:cut_tuff_from_stone_types_tuff_stonecutting" | "create:cutting/compat/byg/stripped_palm_log" | "create:small_deepslate_brick_wall" | "minecraft:waxed_cut_copper_from_waxed_copper_block_stonecutting" | "jerotesvillage:bright_land_drumstick_craft" | "quark:building/crafting/stripped_spruce_post" | "cataclysm:stonecutting/polished_azure_seastone_slab_from_stonecutting" | "minecraft:black_stained_glass" | "minecraft:dye_purple_wool" | "jerotesvillage:black_yellow_chest_boat_craft" | "quark:building/stonecutting/vertslabs/pink_shingles_vertical_slab_stonecutter";
    type LangKey = "item.lendersdelight.lionfish_slice" | "block.quark.lootr_blossom_trapped_chest" | "subtitle.jerotesvillage.meganose_snow_lizard_walk" | "multiplayer.disconnect.flying" | "create.ponder.piston_pole.text_2" | "fancymenu.placeholders.world.active_effect" | "create.ponder.piston_pole.text_1" | "item.minecraft.potion.effect.weakness" | "config.jade.flip_main_hand" | "item.farmersdelight.rotten_tomato" | "subtitles.malfunction" | "item.minecraft.splash_potion.effect.intoxication_potion" | "lanserverproperties.gui.max_player" | "advancements.achievement_hide_14.title" | "options.onlyShowSecureChat.tooltip" | "tetra.stats.truesweep.tooltip" | "tetra.module.double/basic_hammer.prefix" | "structure.repurposed_structures.mansion_oak" | "fancymenu.helper.editor.items.visibilityrequirements.is_number" | "modernui.center.tooltip.cornerRadius" | "tetra/schematic/double/shared_head/hone_damage_flat_1.description" | "gamerule.disableElytraMovementCheck" | "tetra/schematic/sword/crucible/crucible_blade.name" | "advancements.nether.create_full_beacon.description" | "subtitles.step5" | "subtitles.step1" | "ftbquests.file.defaults.quest_disable_jei" | "block.create.copper_tiles" | "misc.refinedstorage.network_item.tooltip" | "item.jerotesvillage.mysterest_perfume" | "tetra/schematic/sword/unbound_stonecutter/adjustable_focus.description" | "ftbquests.reward.ftbquests.advancement.criterion" | "item.jerotesvillage.heal_spear.desc_1" | "linkingtool.linkingmode" | "item.jerotesvillage.heal_spear.desc_0" | "subtitles.entity.iron_golem.hurt" | "tetra/schematic/double/unbound_extractor/lateral_limiter.name" | "trim_pattern.jerotesvillage.serpent_dominater" | "item.minecraft.bowl" | "gamerule.disappearanceofSpiritsUndertheSun" | "item.ftbquests.book.tooltip" | "item.minecraft.bone_meal" | "incendium.item.trailblazer.system.fail" | "gui.sophisticatedcore.label.no_search_results" | "gui.xaero_waypoint_distance_vertical_visibility_angle" | "ftbquests.quest.visibility.hide_text_until_complete" | "effect.jerotesvillage.unclean_body" | "block.create.cut_limestone_wall" | "farmersdelight.advancement.place_feast.desc" | "multiplayer.status.no_connection" | "fancymenu.elements.widgets.generic.navigatable" | "modernfix.message.reload_config" | "config.jade.plugin_minecraft.item_storage_extra_msg" | "spell.jerotesvillage.indomitable_will" | "constructionwand.option.cores.constructionwand:core_angel.desc" | "libipn.common.gui.config.advanced_keybind_settings" | "remnant_tail_slam.sub" | "remnant_charge_prepare.sub" | "create.gui.sequenced_gearshift.instruction.turn_distance.descriptive" | "block.minecraft.banner.stripe_bottom.light_blue" | "fancymenu.overlay.menu_bar.help.discord.tooltip" | "advancements.legendary_monsters.defeat_haunted_knight.title" | "block.biomancy.malignant_flesh" | "item.tetra.vent_plate.description" | "spell.jerotesvillage.malignasaur_bomb.desc" | "item.lendersdelight.maledictus_heart_stew" | "fancymenu.element.anchor_point.top_right" | "block.minecraft.potted_white_tulip" | "chat.cannotSend" | "mco.download.title" | "tetra.variant.potion_storage/forged_mesh" | "tetra.improvement.scanner/percussion_scanner.description" | "item.jerotesvillage.sun_crab" | "subtitles.dream1" | "subtitles.dream0" | "effect.born_in_chaos_v1.undead_summonun" | "tetra.tweak.bow/multishot_spread.label" | "subtitles.dream2" | "libipn.common.enum.context.ingame" | "gui.xaero_safe_mode" | "stat.minecraft.damage_dealt" | "createWorld.customize.presets.list" | "gui.xaero_other_teams" | "iris.shaders.reloaded" | "tetra/schematic/single/head/halberd_head/halberd_head.slot1" | "item.prefab.item_defense_bunker" | "gui.sophisticatedcore.settings.item_display.tooltip_open_detail" | "title.32bit.deprecation.realms.check" | "tag.item.balm.red_dyes" | "ftbquests.task.ftbquests.buildcraft_mj.value" | "item.sophisticatedbackpacks.auto_blasting_upgrade" | "mco.backup.entry.gameMode" | "item.jerotesvillage.purple_sand_hag_eye.desc_3" | "block.minecraft.oak_planks" | "item.jerotesvillage.purple_sand_hag_eye.desc_1" | "state.biomancy.living_tool.dormant" | "item.jerotesvillage.purple_sand_hag_eye.desc_2" | "tetra/schematic/single/handle/long_handle.name" | "item.jerotesvillage.purple_sand_hag_eye.desc_0" | "art_of_forging.effect.disorienting.name" | "config.jade.plugin_jade.coordinates_extra_msg" | "lanserverproperties.options.online_mode" | "tooltip.biomancy.fire_rate" | "fancymenu.helper.editor.items.features.advanced_positioning.desc" | "tutorial.socialInteractions.title" | "block.minecraft.purple_shulker_box" | "item.sophisticatedbackpacks.xp_pump_upgrade.tooltip" | "block.netherexp.occult_gargoyle_statue" | "commands.item.source.not_a_container" | "block.quark.blackstone_furnace" | "item.minecraft.splash_potion.effect.strong_wilderness_giant_poison" | "inventoryprofiles.config.name.open_gui_editor" | "datapackFailure.safeMode" | "block.minecraft.light_blue_bed" | "block.born_in_chaos_v1.black_argillite_button" | "block.pasterdream.ecology_glass_jar" | "ali.property.branch.all" | "fancymenu.elements.slider.v2.type.range.set_max.desc" | "tetra/schematic/toolbelt/storage/quickslot.slot1" | "create.ponder.cogwheel_casing.text_1" | "create.ponder.cogwheel_casing.text_2" | "tetra/schematic/double/shared_head/hone_pickaxe_efficiency_3.description" | "create.ponder.cogwheel_casing.text_3" | "commands.ftbquests.command.delete_empty_reward_tables.text" | "advancements.nether.exorcism.title" | "block.jerotesvillage.sediment_mud_brick_stairs" | "item.pasterdream.machine_wing_chestplate" | "advancements.adventure.honey_block_slide.title" | "painting.jerotesvillage.god.title" | "ftbquests.null" | "prefab.gui.house.improved.crimson_house" | "gui.chatReport.report_sent_msg" | "tetra.material.feature.crying.tooltip" | "biome.minecraft.warped_forest" | "create.subtitle.cranking" | "ftbquests.task.ftbquests.npc_dialog.id" | "item.sophisticatedbackpacks.chipped.botanist_workbench_upgrade.tooltip" | "item.minecraft.book" | "block.cataclysm.azure_seastone_pillar" | "leviathan_tentacle_strike.sub" | "config.tooltips_reforged.effectsTooltip" | "effect.alexscaves.stunned.description" | "tetra.stats.toolbelt.booster.tooltip" | "gui.xaero_howto_cancel" | "create.item_attributes.enchanted.inverted" | "create.schedule.condition.redstone_link_on" | "tetra/schematic/double/shared_head/hone_durability_4.name" | "quark.jei.hint.minecraft.sponge" | "block.minecraft.black_shulker_box" | "subtitles.block.amethyst_block.chime" | "tetra/schematic/bow/stave/remembrance_stave.slot1" | "item.born_in_chaos_v1.seared_spirit_not_despawn_spawn_egg" | "create.display_link.too_far" | "create.schedule.condition.player_count" | "tipsmod.tip.crouch_blocks" | "gui.xaero_custom_settings" | "fancymenu.menu_background.choose" | "block.create.clutch" | "item.create.tree_fertilizer.tooltip.condition1" | "block.netherexp.soul_slate_tile_wall" | "fancymenu.overlay.debug.screen_active_element_count" | "subtitle.jerotesvillage.ominous_banner_projection_hurt" | "create.gui.attribute_filter.deny_list" | "tetra.material.phantom_membrane" | "item.minecraft.bamboo_chest_raft" | "gui.sophisticatedcore.buttons.transfer_to_inventory_filtered" | "item.lendersdelight.amethyst_crab_meat_slice" | "ali.property.branch.any" | "pehkui.configgui.scale_limits.attack.maximum" | "gui.xaero_make_multi_automatic" | "item.create.polished_rose_quartz" | "create.gui.schematicannon.option.dontReplaceSolid.description" | "subtitles.entity.slime.hurt" | "message.jerotes.freeze" | "ftbquests.chapter.image" | "block.minecraft.bamboo_slab" | "gamerule.reducedDebugInfo.description" | "effect.twist.hazy.description" | "item.prefab.item_saloon" | "fancymenu.requirements.is_key_pressed.screen.title" | "block.minecraft.brown_wool" | "subtitles.entity.ghast.ambient" | "arguments.function.tag.unknown" | "subtitles.entity.ravager.stunned" | "ali/loot_table/chests/shipwreck_map" | "item.art_of_forging.dragon_soul" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.guiheight.desc" | "subtitles.entity.bee.loop" | "create.display_source.value_list.full_number" | "ftbquests.quest.appearance.icon_scale" | "item.minecraft.bone" | "fancymenu.editor.action.screens.build_screen.edit_value.desc.normal" | "item.create.tree_fertilizer.tooltip.behaviour1" | "tetra/schematic/double/unbound_extractor/potency_1.name" | "argument.angle.incomplete" | "effect.netherexp.unbounded_speed" | "tetra.tool.available" | "fancymenu.helper.editor.items.visibilityrequirements.language" | "gui.chatReport.read_info" | "art_of_forging.advancements.materials.endsteel_ingot.description" | "death.attack.punishment" | "fml.messages.version.restriction.any" | "tetra.stats.cut.tooltip" | "advancements.achievement_treasure_a_1.descr" | "multiplayer.status.version.narration" | "item.kubejs.leviathan_star" | "mco.configure.world.buttons.switchminigame" | "citadel.follower.citadel_gray" | "inventoryprofiles.config.name.show_locked_slots_hotbar_color" | "entity.faded_conquest_2.terrible_ten" | "subtitles.entity.guardian.attack" | "ftbquests.file.defaults" | "block.quark.thatch_slab" | "attributeslib:mining_speed.desc" | "fluid_tank.polylib.fluid_storage" | "incendium.inferno.spell.shulker.fireballs" | "block.quark.golden_apple_crate" | "subtitle.jerotesvillage.ruins_breeze_slide" | "subtitles.entity.generic.death" | "block.create.black_seat" | "block.minecraft.banner.square_bottom_left.gray" | "commands.scoreboard.objectives.display.set" | "effect.xaerominimap.no_minimap_beneficial" | "damage_number:config.x" | "damage_number:config.y" | "pack.source.builtin" | "jade.instrument.skeleton" | "commands.perf.reportFailed" | "block.minecraft.cyan_stained_glass" | "advancements.quark.mine_fed_toretoise.title" | "misc.refinedstorage.total" | "fancymenu.elements.music_controller.desc" | "commands.place.structure.success" | "fancymenu.helper.visibilityrequirement.gamemode.is_survival.desc" | "_quark.config.automation.feeding_trough.love_chance.name" | "item.jerotesvillage.meror_metal_stick" | "modernfix.option.mixin.perf.blast_search_trees" | "advancements.biomancy.cradle.description" | "tetra/schematic/sword/unbound_stonecutter/planar_guide.description" | "item.geckolib.jack_in_the_box.opening" | "fancymenu.editor.loading_requirement.elements.loading_requirements.desc" | "gui.sophisticatedcore.settings.message.load_template" | "item.tetra.tooltip_expand" | "advancement.create.arm_blaze_burner.desc" | "advancements.refinedstorage.detecting" | "tetra/schematic/double/butt/butt.slot1" | "tetra.stats.tool.striking" | "item.jerotes.vicious_mockery" | "create.ponder.tag.arm_targets" | "gamerule.JerotesArmorCanBreak" | "structure.structory_towers.ocean_pillar" | "item.jerotesvillage.villager_metal_spear" | "block.netherexp.claret_door" | "item.sophisticatedbackpacks.advanced_magnet_upgrade.tooltip" | "tetra.stats.overpower" | "gamerule.zombieBruiserSpawn" | "fancymenu.helper.placeholder.elementposy.desc" | "block.quark.red_crystal_lamp" | "incendium.advancement.ash_barrens.conquer_castle.title" | "block.minecraft.banner.creeper.red" | "item.netherexp.claret_sign" | "tetra.advancements.upgrades.shield_upgrade.description" | "tetra.integer_predicate_max" | "tooltip.waystones.blue_sharestone" | "item.legendary_monsters.chorus_blade" | "container.hopper" | "entity.jerotesvillage.wonderlin_painting" | "dimension.hyperbox.hyperbox" | "structure.repurposed_structures.mineshaft_birch" | "fancymenu.editor.render_custom_behind_vanilla" | "block.structure_gel.cyan_gel" | "ftbquests.gui.collect_rewards" | "block.minecraft.white_bed" | "jei.tooltip.recipe.sort.bookmarks.first.disabled" | "createWorld.customize.custom.presets.title" | "subtitles.entity.pillager.ambient" | "advancements.legendary_monsters.defeat_dune_sentinel.title" | "entity.jerotesvillage.carved_villager.enderman" | "subtitle.jerotesvillage.flowminnow_death" | "item.minecraft.tropical_fish" | "itemGroup.refinedstorage" | "mco.download.percent" | "fancymenu.placeholders.screen_identifier" | "modernfix.option.category.expert_only.description" | "options.telemetry.state.minimal" | "tetra.aspect.bow" | "item.jerotesvillage.worm_thunderstorm" | "block.netherexp.bone_rod" | "item.cataclysm.scylla_spawn_egg" | "block.biomancy.malignant_flesh_veins.tooltip" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.guiwidth.desc" | "subtitles.entity.apparition.hurt" | "quark.misc.equip_armor" | "subtitles.entity.villager.work_toolsmith" | "block.legendary_monsters.ancient_dripstone_bricks" | "block.create.train_trapdoor" | "block.quark.stone_brick_lamp" | "tetra.slot.double/head_left" | "item.minecraft.tipped_arrow.effect.harming" | "tetra/schematic/single/head/unbound_earthpiercer/fracture_1.name" | "effect.born_in_chaos_v1.sacrifice.description" | "effect.jerotes.phantasmal_killer.description" | "fancymenu.elements.item.key.desc" | "config.jade.display_item_extra_msg" | "create.ponder.close" | "block.minecraft.cartography_table" | "effect.terramity.misprogrammed.description" | "gui.xaero_waypoint_shared_dimension2" | "fancymenu.resources.source_type.web.desc" | "sidebutton.refinedstorage.exact_mode.off" | "item.jerotesvillage.explorer_iron_upgrade_smithing_template.desc_0" | "item.jerotesvillage.explorer_iron_upgrade_smithing_template.desc_1" | "ali.property.branch.equipment_slots" | "jei.chat.error.no.cheat.permission.enabled" | "block.quark.ancient_button" | "block.ftbquests.screen.task_index" | "tetra/schematic/shield/grip/hone_damage_1_mult.description" | "create.boiler.water_dots" | "commands.enchant.success.multiple" | "block.netherexp.cut_silica_sandstone" | "ali.property.value.amplifier" | "subtitles.fire0" | "subtitles.entity.llama.spit" | "effect.immersiveengineering.sticky.description" | "create.subtitle.controller_put" | "tipsmod.tip.joke.skulls" | "create.ponder.shaft.header" | "quark.category.oddities" | "item.jerotesvillage.bright_land_beast_fluff" | "item.jerotesvillage.zsiein_sonic" | "create.station.assemble_train" | "tetra.module.shield/tower.description" | "subtitle.jerotesvillage.slider_ambient" | "block.minecraft.mangrove_hanging_sign" | "entity.minecraft.villager.butcher" | "gui.xaero_box_export" | "block.minecraft.banner.half_horizontal_bottom.light_gray" | "tetra.advancements.spelunking.find_planar.description" | "fancymenu.customization.items.text.v2.desc" | "fancymenu.requirements.world.is_player_riding_entity_with_health.desc" | "death.attack.attributeslib:fire_damage.item" | "item.tetra.scroll.otherworldly.details" | "gamerule.doMobSpawning.description" | "fancymenu.editor.elements.vanilla_widget.generic" | "block.minecraft.skeleton_skull" | "gui.chatReport.more_comments" | "subtitles.block.shulker_box.close" | "tetra.aspect.pointy_weapon" | "create.ponder.shared.behaviour_modify_value_panel" | "block.cataclysm.door_of_seal_part" | "tetra.module.double/basic_hammer.item_name" | "gui.stats" | "effect.vinery.improved_strength.description" | "incendium.item.battle_helm.name" | "mco.upload.done" | "item.jerotes.leather_war_beast_armor" | "gui.xaero_entity_category_friendly" | "entity.born_in_chaos_v1.seared_spirit" | "inventoryhud.config.gui.armcount.tt" | "subtitles.magic_staff_shoot" | "create.schedule.condition.delay_short" | "block.minecraft.bricks" | "block.create.jungle_window_pane" | "block.minecraft.diorite_slab" | "create.generic.clockwise" | "subtitles.block.soul_slate.solidifying" | "stat.lootr.looted_stat" | "block.create.cut_scorchia" | "item.cataclysm.black_steel_hoe" | "ftbquests.quest.appearance.shape" | "block.quark.polished_diorite_vertical_slab" | "quark.gui.config.social.forum" | "block.biomancy.flesh_fence_gate.tooltip" | "entity.minecraft.villager.jerotesvillage.villager_shopkeeper" | "entity.born_in_chaos_v1.bone_imp_minion" | "block.minecraft.melon_stem" | "multiplayer.status.unknown" | "item.minecraft.iron_pickaxe" | "fancymenu.elements.multiselect.loading_requirements.warning.override" | "item.cataclysm.remnant_skull" | "forge.experimentalsettings.tooltip" | "tetra.integer_predicate_min" | "tetra.advancements.spelunking.schematic_shatter.description" | "block.quark.myalite_bricks" | "item.pasterdream.dyedream_hoe" | "item.born_in_chaos_v1.krampus_spawn_egg" | "effect.biomancy.armor_shred" | "item.quark.music_disc_fire" | "tetra.aspect.armor" | "tetra.module.shield/kite.item_name" | "gui.xaero_other" | "subtitles.block.lightspores.shear" | "advancements.trickor_treat.title" | "mco.configure.world.spawnMonsters" | "gui.xaero_clear_set_message" | "disconnect.loginFailedInfo" | "tetra/schematic/single/head/unbound_earthpiercer/unbound_earthpiercer.slot1" | "text.autoconfig.obscuria/loot_journal-client.option.display.displayExperience" | "item.jerotesvillage.meror_metal_spear.desc" | "create.track.selection_cleared" | "multiplayer.requiredTexturePrompt.disconnect" | "subtitles.entity.shulker_bullet.hurt" | "item.jerotesvillage.slavery_supervisor_leggings" | "create.display_source.boiler.not_enough_space" | "tetra/schematic/sword/crucible/hone_vengeance_1.description" | "item.jerotesvillage.horned_helmet" | "item.tetra.scroll.axe_efficiency.description" | "inventoryhud.config.gui.blacklist.tt" | "tetra.material.bone.prefix" | "item.biomancy.mob_sinew.tooltip" | "effect.terramity.resourceful_rounds.description" | "quark.gui.button.sort_container" | "tetra/schematic/sword/crucible/hone_esoteric_3.name" | "subtitle.jerotesvillage.frost_yeti_rush" | "gui.sophisticatedcore.upgrades.magnet" | "quark.subtitles.bucket.fill_crab" | "death.attack.biomancy.slash.item" | "fancymenu.editor.custombutton.config.actiontype.join_last_world" | "fancymenu.placeholders.world.max_mount_health" | "block.summoningrituals.indestructible_altar" | "effect.unusualprehistory.pachys_might.description" | "inventoryprofiles.config.name.custom_rule" | "tetra.unlock.tetra.extractor.description" | "item.protection_pixel.incompleteanchorpoint" | "sleep.skipping_night" | "fancymenu.overlay.menu_bar.variables" | "create.item_attributes.compostable.inverted" | "container.enchant.lapis.many" | "item.jerotesvillage.aloe_vera_pulp" | "item.born_in_chaos_v1.spiny_shell_armor_helmet" | "subtitles.entity.parrot.imitate.witch" | "block.jerotesvillage.brown_mud_thorns" | "options.chat.height.unfocused" | "subtitles.entity.stray.ambient" | "block.minecraft.bed.not_safe" | "damage_number:config.setting" | "block.minecraft.banner.straight_cross.light_blue" | "gui.xaero_connect_with_auto_msg" | "jer.dungeon.desertPyramidChest" | "item.cataclysm.ceraunus.desc" | "commands.place.template.failed" | "death.attack.bypasses_cooldown_shoot.player" | "fml.modmismatchscreen.additional" | "advancements.end.find_end_city.description" | "commands.drop.success.multiple" | "advancements.jerotesvillage.prohibit_rip_of.title" | "tetra.improvement.halberd_head/serrated.name" | "item.jerotesvillage.spirve_kitchen_knife" | "item.minecraft.iron_axe" | "mco.selectServer.openserver" | "libipn.common.gui.config.modifier_key" | "gui.xaero_unknown_biome" | "commands.team.option.collisionRule.unchanged" | "options.vsync" | "block.cataclysm.curved_azure_seastone_urchinkin" | "entity.cataclysm.sandstorm" | "enchantment.improved_exp.jumper.desc" | "prefab.gui.material.brick" | "gui.xaero_waypoint_visibility_type_world_map_global" | "effect.tombstone.lightning_resistance.description" | "block.create.scoria_pillar" | "gui.modernui.button.exit" | "inventoryprofiles.config.description.in_columns_post_action" | "item.create.wrench.tooltip.condition2" | "gui.waystones.waystone_settings.is_global" | "entity.jerotes.projectile_throw_wooden_spear" | "block.minecraft.mangrove_fence_gate" | "block.quark.myalite_bricks_stairs" | "block.create.copper_tile_slab" | "fancymenu.helper.editor.items.visibilityrequirements.is_button_active.desc" | "item.quark.music_disc_chatter" | "tipsmod.tip.animal_growing" | "effect.pasterdream.guard_block_buff" | "tetra.advancements.spelunking.percussion_scanner.title" | "item.protection_pixel.magneticstorm_chestplate" | "structure_block.show_air" | "structure.ctov.large.village_taiga_fortified" | "item.create.wrench.tooltip.condition1" | "advancements.nether.ultrakill.title" | "tetra.improvement.workable.description" | "chat.type.text.narrate" | "create.train.status.no_match" | "item.cataclysm.deepling_warlock_spawn_egg" | "quark.camera.filter.yellowfocus" | "item.pasterdream.copper_shovel" | "text.cloth-config.quit_config" | "tetra.module.crossbow/dreadnought_cross_stave.prefix" | "fancymenu.elements.music_controller.play_world_music" | "fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_blacklist" | "subtitles.stalker_dead" | "create.gui.goggles.basin_contents" | "translation.test.complex" | "ftbquests.task.ftbquests.botania_mana.text" | "item.quark.music_disc_wind.desc" | "gui.xaero_box_entity_radar_icons" | "gui.sophisticatedbackpacks.upgrades.refill.scroll.tooltip" | "commands.setidletimeout.success" | "advancements.biomancy.living_flesh.title" | "title.multiplayer.disabled.banned.temporary" | "tipsmod.tip.wooden_tool_fuel" | "quark.subtitles.foxhound_hurt" | "item.waystones.crumbling_attuned_shard" | "block.pasterdream.shadow_shroomlight" | "info.structure_gel.building_tool_description" | "advancements.bornin_chaos.descr" | "subtitles.entity.villager.yes" | "block.quark.lime_shingles_stairs" | "gui.multiLineEditBox.character_limit" | "block.jerotesvillage.wonderland_door" | "advancements.adventure.totem_of_undying.description" | "button.corpse.show_items" | "advancements.nether.stayin_frosty.description" | "fancymenu.editor.anchor_overlay.charging_time.slider_label" | "boss.jerotesvillage.ominous_banner_projection" | "effect.cofh_core.magic_resistance.description" | "event.minecraft.raid.victory" | "block.ftbquests.loot_crate_opener.rightclick" | "key.keyboard.keypad.equal" | "subtitles.block.pressure_plate.click" | "fancymenu.editor.action.screens.remove_action" | "argument.uuid.invalid" | "fancymenu.helper.editor.items.playerentity.parrot.desc" | "item.tetra.scroll.warforge/pickaxe.description_extended" | "tetra/schematic/sword/rending_scissor_purple.description" | "item.born_in_chaos_v1.spawn_structures_farm" | "item.minecraft.blaze_spawn_egg" | "block.biomancy.fibrous_flesh_stairs" | "tetra.variant.core/dim" | "block.create.cut_granite_brick_wall" | "modernui.center.text.defaultFontRuleSet_desc" | "tetra.stats.stabilizing" | "chat.powerful_dummy.damagelog.time.current" | "fancymenu.requirements.world.is_left_handed" | "block.minecraft.warped_slab" | "config.jade.item_mod_name_extra_msg" | "gui.sophisticatedcore.settings.buttons.save_template.controls" | "subtitle.jerotesvillage.solish_ambient" | "block.quark.blossom_sign" | "item.prefab.item_sickle_wood" | "block.create.cut_veridium_brick_slab" | "tetra.module.bow/remembrance_stave.description" | "incendium.advancement.quartz_flats.torte.root.desc" | "ftbquests.ui.old_scroll_wheel.tooltip" | "item.biomancy.volatile_gland.tooltip" | "commands.drop.no_loot_table" | "incendium.advancement.toxic_heap.slime_poison.title" | "block.create.fluid_tank" | "item.legendary_monsters.withered_horn" | "gui.sophisticatedbackpacks.settings.buttons.context_backpack" | "jei.key.shift" | "tipsmod.tip.swamp_slime" | "tetra.variant.straight_stave/stick" | "tetra.synergy.double/battleadze" | "ali/loot_table/chests/village/village_mason" | "mco.configure.world.spawnAnimals" | "linkingtool.ender.clear" | "advancement.create.extendo_grip.desc" | "block.minecraft.magma_block" | "effect.sons_of_sins.arctic_cells.description" | "block.create.gray_seat" | "item.biomancy.caustic_gunblade.tooltip" | "commands.forge.gen.complete" | "fml.modloading.missinglicense" | "tetra.module.toolbelt/belt.item_name" | "tutorial.find_tree.title" | "gui.xaero_world_save" | "subtitles.entity.mule.death" | "advancements.legendary_monsters.defeat_frostbitten_golem.description" | "item.protection_pixel.equipmentkit" | "commands.ride.already_riding" | "block.create.lime_valve_handle" | "fancymenu.elements.text.v2.source_mode.resource" | "block.create.chocolate" | "block.jerotesvillage.bright_melons" | "prefab.gui.silver" | "effect.eidolon.chilled.description" | "item.art_of_forging.demonic_blade" | "block.minecraft.sponge" | "block.netherexp.violet_mixed_nether_bricks" | "key.refinedstorage.focusSearchBar" | "options.online.title" | "block.minecraft.light_gray_candle" | "pehkui.configgui.scale_limits.hitbox_height.maximum" | "effect.legendary_monsters.chorus_infection" | "effect.goodending.strong_immunity.description" | "forge.configgui.logCascadingWorldGeneration" | "create.schematicAndQuill.noTarget" | "options.sounds" | "advancement.create.andesite_alloy" | "block.pasterdream.uuz_doll_0" | "tetra/schematic/double/soul_fire_scythe/hone_soul_fire_1.name" | "block.biomancy.primal_permeable_membrane_pane" | "type.tooltips_reforged.illager" | "subtitles.entity.evoker.prepare_summon" | "entity.jerotesvillage.serpon_pioneer" | "gui.xaero_display_redstone" | "block.minecraft.banner.stripe_downright.light_blue" | "subtitles.corpse_fly_ambient" | "lootr.advancements.10loot.description" | "gui.xaero_wm_purple" | "block.jerotesvillage.carved_villager_concertina_wire" | "mco.template.title.minigame" | "item.tetra.modular.magic_capacity.description" | "fancymenu.guicomponents.set" | "msg.biomancy.failed_to_store_mob" | "entity.jerotesvillage.dust_moth.queen" | "create.ponder.contraption_controls.header" | "modernui.center.font.chooseFont" | "enchantment.improved_exp.autosmelt.desc" | "block.minecraft.banner.cross.purple" | "gui.hours" | "item.minecraft.carrot" | "gui.refinedstorage.item_amount" | "fancymenu.editor.anchor_overlay.overlay_color_border" | "create.crafting_blueprint.display_slot" | "subtitles.portal" | "painting.minecraft.wasteland.title" | "modernui.center.text.substringAlgo" | "block.biomancy.chiseled_flesh.tooltip" | "entity.jerotesvillage.royal_war_python" | "advancements.jerotes.a_brand_new_world.title" | "ability.biomancy.bleed_proc.desc" | "art_of_forging.effect.haste_infused.tooltip" | "subtitles.spirit_idle" | "entity.faded_conquest_2.mimic" | "item.create.wrench.tooltip.behaviour2" | "item.create.wrench.tooltip.behaviour1" | "commands.locate.structure.not_found" | "fancymenu.overlay.menu_bar.customization.settings.play_menu_music" | "stat.minecraft.open_chest" | "block.minecraft.quartz_stairs" | "commands.advancement.grant.many.to.one.success" | "item.jerotesvillage.piglin_golden_fire.desc_0" | "item.jerotesvillage.piglin_golden_fire.desc_1" | "commands.team.option.name.success" | "death.attack.cataclysm.sword_dance" | "item.minecraft.oak_boat" | "create.gui.terrainzapper.placement.inserted" | "rune.quark.light_gray" | "sidebutton.refinedstorage.grid.size" | "key.mount_jump" | "fancymenu.background.image.type.web.fallback" | "effect.pasterdream.dreamwish_buff" | "quark.keybind.camera_mode" | "tag.item.c.storage_blocks.beetroot" | "pehkui.configgui.scale_limits.width.maximum" | "fancymenu.editor.shortcuts.cut" | "chat.powerful_dummy.damagelog.time.set" | "ali.property.value.probability" | "effect.vinery.armor_effect.description" | "block.minecraft.white_shulker_box" | "ftbteams.api_override" | "tetra/schematic/sword/crucible/hone_esoteric_2.description" | "tetra/schematic/bow/riser/stabilizer.name" | "gui.sophisticatedcore.upgrades.buttons.void_anything_disabled" | "art_of_forging.effect.sonic_shock.tooltip" | "fancymenu.requirements.world.is_snowing" | "iris.shaders.debug.disabled" | "block.minecraft.melon" | "fancymenu.placeholders.world.world_game_time" | "item.pasterdream.embryo_necklace" | "tetra.stats.integrity_usage.tooltip" | "gui.sophisticatedbackpacks.upgrades.smithing" | "ali.property.value.absolute" | "entity.jerotesvillage.sandstone_beast" | "item.biomancy.flesh_chicken_spawn_egg" | "filled_map.dungeons_arise:illager_fort" | "tetra.advancements.scrolls.find_scroll_key_guard.title" | "structure.ctov.small.village_mountain_alpine" | "fancymenu.helper.editor.edit_menu_title.reset.invalid_title" | "item.refinedstorage.upgrade" | "advancement.create.train_crash_backwards" | "block.quark.duskbound_block_slab" | "gui.xaero_box_controls" | "block.quark.light_blue_shingles_slab" | "config.waystones.restrictions.leashedDenyList.tooltip" | "block.netherexp.thin_black_ice" | "spell.jerotesvillage.ice_rock_throw" | "fancymenu.layout_editor.grid.snapping.strength.standard" | "quark.gui.button.emotes" | "tetra.material.turtle_scute" | "options.chat.scale" | "item.farmersdelight.salmon_roll" | "tetra.material.diorite" | "subtitles.entity.warden.listening_angry" | "ftbquests.reward.ftbquests.item.only_one.tooltip" | "block.netherexp.smokestalk_fence" | "tetra.tweak.sword_tweak/binding_bolt.label" | "more_requirement.holo.other_module_requirement" | "effect.nethervinery.netherite.description" | "commands.experience.query.levels" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line2" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line1" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line3" | "gui.sophisticatedcore.upgrades.chipped_botanist_workbench" | "quark.jei.hint.repair_item_changed" | "item.netherexp.antidote.effect.luck" | "enchantment.improved_exp.levitation.desc" | "block.quark.blackstone_bricks_stairs" | "block.biomancy.primal_permeable_membrane.tooltip" | "block.create.layered_tuff" | "item.minecraft.firework_star.fade_to" | "entity.jerotesvillage.projectile_meror_charging_arrow_5" | "tetra.improvement.unbound_stonecutter/shatter_instability.name" | "item.minecraft.music_disc_cat" | "quark.subtitles.foxhound_death" | "quark.jei.hint.beacon_amethyst" | "block.minecraft.oak_wood" | "entity.jerotesvillage.projectile_meror_charging_arrow_2" | "entity.jerotesvillage.projectile_meror_charging_arrow_1" | "block.minecraft.powered_rail" | "block.refinedstorage.creative_portable_grid" | "subtitles.shadow_music_0" | "entity.jerotesvillage.projectile_meror_charging_arrow_4" | "inventoryhud.config.gui.arrowswithoutweapon.tt" | "filled_map.dungeons_arise:fishing_hut" | "entity.jerotesvillage.projectile_meror_charging_arrow_3" | "item.liolib.parasite_spawn_egg" | "argument.dimension.invalid" | "block.pasterdream.shadow_stone_tiles_wall" | "modernui.center.text.smartSDFShaders" | "boss.jerotesvillage.gemstone_malignasaur" | "block.pasterdream.aaroncos_arena_portals" | "subtitles.life_crystal" | "block.quark.vertical_azalea_planks" | "tooltip.waystones.green_sharestone" | "commands.team.option.prefix.success" | "inventoryprofiles.config.description.do_local_trade" | "sodium.dynamiclights.options.mode" | "fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_16" | "subtitle.jerotesvillage.blaster_cheer" | "tetra.stats.art_of_forging:beheading.tooltip_short" | "create.gui.terrainzapper.tool.place" | "effect.deeperdarker.sculk_affinity.description" | "tooltip.summoningrituals.region" | "advancement.create.track_crafting_factory.desc" | "block.minecraft.green_shulker_box" | "entity.minecraft.wither_skeleton" | "tetra.variant_category.fabric.label" | "ali.property.branch.targeted_entity" | "tetra.module.sword/short_blade.material_name" | "commands.terrablender.biomeparams.success" | "attribute.name.projectile_damage.generic" | "chat.powerful_dummy.damage" | "gui.structure_gel.data_handler.structure_gel:archaeology.generation_chance.label" | "commands.reload.failure" | "tetra.stats.art_of_forging:karma_infused" | "fancymenu.helper.editor.items.buttons.buttonbackground.set" | "item.minecraft.dark_oak_chest_boat" | "item.cataclysm.ender_golem_spawn_egg" | "quark.gui.celebration.minecraft" | "block.minecraft.petrified_oak_slab" | "incendium.advancement.quartz_flats.sanctum.vault_hunter.desc" | "fancymenu.customization.items.text.set_source.web.desc" | "block.biomancy.smooth_primal_flesh_slab.tooltip" | "block.quark.magenta_framed_glass_pane" | "advancements.adventure.arbalistic.description" | "block.netherexp.ancient_lantern" | "create.subtitle.saw_activate_stone" | "effect.pasterdream.lethargy_buff" | "tetra.module.double/tomahawk.description" | "serum.biomancy.absorption_boost" | "misc.refinedstorage.last_modified.week" | "block.minecraft.banner.half_vertical.pink" | "block.minecraft.zombie_head" | "create.schedule.condition.redstone_link.frequency_powered" | "block.quark.ancient_planks_vertical_slab" | "block.born_in_chaos_v1.black_argillite_brick_stairs_n" | "effect.mahoutsukai.black_flame_eyes.description" | "block.minecraft.warped_roots" | "item.jerotesvillage.giant_monster_spawn_egg" | "item.born_in_chaos_v1.sir_pumpkinhead_without_horse_spawn_egg" | "fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_32" | "fancymenu.elements.element.load_once_per_session.desc" | "telemetry.property.client_modded.title" | "block.liolib.gecko_habitat" | "entity.cataclysm.void_vortex" | "item.cataclysm.deepling_priest_spawn_egg" | "block.minecraft.piglin_head" | "sodium.options.translucent_face_sorting.tooltip" | "prefab.gui.farm.berry" | "effect.cofh_core.cold_resistance.description" | "ftbquests.gui.change_progress.complete" | "item.minecraft.music_disc_relic.desc" | "item.born_in_chaos_v1.evilometer" | "item.cataclysm.ceraunus" | "item.farmersdelight.shepherds_pie" | "ftbquests.task.ftbquests.fluid.fluid" | "subtitle.jerotesvillage.jewelroamer_flop" | "gui.xaero_box_only_current_map_waypoints" | "item.pasterdream.pulse_windrunner_crystal" | "incendium.mob.castle.archer.name" | "subtitles.shadow_sword" | "block.minecraft.sand" | "inventoryprofiles.config.name.export_external_hints" | "inventoryprofiles.update.available" | "effect.jerotesvillage.meror_wanted_order.description" | "painting.pasterdream.pasterdream_draw.title" | "item.prefab.item_watch_tower_dark" | "gui.xaero_compass_color" | "incendium.advancement.ash_barrens.root.title" | "block.minecraft.smooth_quartz_stairs" | "item.art_of_forging.enigmatic_construct" | "commands.data.get.invalid" | "tetra.stats.puncture_echo.tooltip" | "item.jerotesvillage.lodestone_carved_contacter" | "subtitles.block.end_portal_frame.fill" | "subtitles.entity.puffer_fish.flop" | "block.quark.orange_shingles" | "create.station.one_bogey" | "item.jerotesvillage.meror_chainsaw" | "incendium.admin.menu.give" | "fancymenu.editor.action.screens.manage_screen.info.value.none" | "effect.born_in_chaos_v1.soul_stratification.description" | "tetra.improvement.unbound_extractor/medial_limiter.description" | "advancements.husbandry.safely_harvest_honey.title" | "block.netherexp.strange_enigma_flesh" | "block.quark.blossom_planks_vertical_slab" | "stat.minecraft.damage_absorbed" | "tetra.module.double/shockwave_hammer.name" | "fancymenu.element.general.appearance_delay.no_delay" | "tetra.variant_category.wool.label" | "structure.repurposed_structures.mansion_desert" | "item.born_in_chaos_v1.elixirof_insect_protection" | "block.quark.potted_sunflower" | "item.minecraft.tipped_arrow.effect.slowness" | "subtitles.entity.dolphin.jump" | "create.schedule.condition.player_count.or_above" | "quark.jei.hint.beacon_corundum" | "block.pasterdream.wind_iron_block" | "subtitle.jerotesvillage.magic_sediment_missile" | "art_of_forging.effect.carnage.name" | "inventoryprofiles.enum.sorting_method.raw_id" | "multiplayer.status.player_count.narration" | "block.minecraft.banner.triangles_bottom.yellow" | "text.cloth-config.disabled_tooltip" | "item.minecraft.music_disc_otherside.desc" | "gui.xaero_box_ui_scale" | "item.jerotesvillage.ancient_second_rounder_noble_helmet.desc" | "config.waystones.restrictions.restrictToCreative" | "death.attack.legioner.item" | "structure.repurposed_structures.fortress_jungle" | "gui.sophisticatedcore.upgrades.buttons.store_levels" | "item.born_in_chaos_v1.bone_imp_spawn_egg" | "effect.netherexp.brain_damage_immunity.description" | "tooltip.titanium.redstone.once" | "ignis_ambient.sub" | "jei.tooltip.error.recipe.transfer.inventory.full" | "subtitle.jerotesvillage.corrosiver_freeze" | "selectWorld.incompatible_series" | "soundCategory.voice" | "attribute.name.generic.knockback_resistance" | "item.pasterdream.qym_head" | "item.jerotesvillage.second_rounder_golem_debris.desc" | "createWorld.customize.custom.lowerLimitScale" | "entity.legendary_monsters.warped_fungussus" | "effect.minecraft.night_vision.description" | "serum.biomancy.rejuvenation_serum" | "advancements.nether.eldritch_manipulation.title" | "biome.minecraft.old_growth_spruce_taiga" | "item.farmersdelight.sweet_berry_cheesecake_slice" | "structure.repurposed_structures.village_ocean" | "item.jerotesvillage.meror_metal_nugget" | "block.minecraft.light_gray_concrete_powder" | "string.naturescompass.snow" | "options.iris.shaderPackSelection.addedPack" | "tetra.module.single/earthpiercer.description" | "tetra.stats.reap_combo.tooltip_extended" | "item.sophisticatedbackpacks.jukebox_upgrade.tooltip" | "block.minecraft.red_sandstone_wall" | "item.minecraft.diamond_axe" | "fancymenu.element.anchor_point.vanilla" | "tetra.material.wool" | "fancymenu.actions.audio.next_track" | "tetra.variant.strap3/iron.description" | "ftbteamsconfig.ftbteams" | "effect.sculkhorde.sculk_vessel.description" | "commands.scoreboard.players.list.success" | "effect.upgrade_aquatic.vibing.description" | "book.byAuthor" | "block.jerotesvillage.villager_block_bartender" | "item.born_in_chaos_v1.spiritual_guide_sombrero_helmet" | "item.legendary_monsters.eye_of_ghost" | "revenant_hurt.sub" | "subtitles.entity.parrot.imitate.illusioner" | "commands.sophisticatedbackpacks.list.cloth_color" | "tetra.advancements.upgrades.hammer_2.title" | "pehkui.configgui.scale_limits.model_height.maximum" | "more_requirement.holo.entities_requirement" | "effect.biomancy.drowsy" | "item.born_in_chaos_v1.spawn_structures_dark_tower" | "message.summoningrituals.rain" | "tetra.stats.hoe_dig.tooltip" | "forge.configgui.clumpingThreshold" | "fancymenu.elements.button.is_template" | "item.jerotesvillage.lightning_worm_spawn_egg" | "block.cataclysm.ignitium_block" | "item.minecraft.diamond_pickaxe" | "tetra.module.sword/scissor_blade_left.item_name" | "entity.minecraft.sheep" | "subtitles.entity.player.hurt_drown" | "block.minecraft.light_gray_carpet" | "iris.shaders.toggled" | "subtitles.entity.item.pickup" | "item.jerotesvillage.villager_metal_base.desc_2" | "item.jerotesvillage.villager_metal_base.desc_1" | "subtitle.jerotesvillage.mapmaker_spell" | "biome.minecraft.snowy_plains" | "entity.jerotesvillage.carved_villager.piglin" | "fancymenu.elements.item.nbt.desc" | "subtitle.jerotesvillage.meror_monstrosity_death" | "create.gui.sequenced_gearshift.instruction.end.descriptive" | "item.born_in_chaos_v1.phantom_creeper_copy_spawn_egg" | "block.quark.bamboo_bookshelf" | "fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal" | "fml.menu.accessdenied.title" | "enchantment.minecraft.soul_speed.desc" | "item.farmersdelight.sweet_berry_cookie" | "tetra.salvage_beam_action.label" | "key.jei.closeRecipeGui" | "tetra/schematic/bow/string/hone_damage_2.description" | "block.functionalstorage.framed_4" | "block.functionalstorage.framed_1" | "text.autoconfig.obscuria/loot_journal-client.option.display.displayTotal" | "block.functionalstorage.framed_2" | "commands.whitelist.reloaded" | "subtitle.jerotesvillage.rigider_ambient" | "block.minecraft.mud_bricks" | "subtitles.entity.axolotl.attack" | "item.jerotesvillage.villager_metal_base.desc_0" | "createWorld.customize.custom.stretchY" | "sidebutton.refinedstorage.iomode.extract" | "effect.infernalexp.luminous.description" | "block.pasterdream.dyedream_bud_slab" | "subtitles.entity.bat.ambient" | "commands.tag.add.success.multiple" | "tooltip.tooltips_reforged.loot_table" | "fancymenu.editor.text_editor.single_line_warning" | "Find all new Igloos!" | "message.jerotes.enemy" | "gui.xaero_minimap_frame_colored_thick" | "gui.xaero_wm_toggle_minimap_radar" | "selectWorld.edit.export_worldgen_settings.failure" | "item.tetra.scroll.hone/gild_1.prefix" | "create.ponder.deployer_contraption.header" | "block.jerotesvillage.purple_sandstone_stairs" | "commands.recipe.give.success.single" | "fancymenu.customization.items.text.auto_line_wrapping" | "tag.item.c.storage_blocks.gunpowder" | "subtitles.block.generic.footsteps" | "block.quark.lootr_jungle_trapped_chest" | "commands.title.show.actionbar.multiple" | "block.netherexp.chiseled_soul_slate_tiles" | "block.minecraft.netherite_block" | "fancymenu.requirements.world.is_player_riding_jumpable_entity" | "gui.xaero_box_waypoints_distance_scale" | "item.minecraft.tipped_arrow.effect.thick" | "modernui.center.tab.developerOptions" | "ftbquests.gui.key_reference.editor" | "tetra.module.double/unbound_extractor.prefix" | "gui.xaero_filter_waypoints_by_name" | "item.pasterdream.black_beetle_carapace" | "enchantment.dungeonsenchantments.radiance_shot.desc" | "block.minecraft.oak_hanging_sign" | "item.jerotesvillage.serpon_dagger" | "tetra.holo.craft.materials.stat.tertiary" | "advancements.biomancy.organic_compounds.description" | "effect.born_in_chaos_v1.intoxication" | "inventoryprofiles.config.category.auto-refill.general" | "item.jerotesvillage.rambler_spawn_egg" | "gui.xaero_held_centered_position" | "ali.property.value.mob_effect" | "gui.removed" | "painting.netherexp.house.author" | "config.jade.plugin_minecraft.item_storage" | "tetra/schematic/sword/unbound_stonecutter/empower.slot1" | "item.quark.biome_map.flower_forest" | "options.graphics.warning.accept" | "subtitles.block.chorus_flower.grow" | "block.pasterdream.dyedream_lotus" | "painting.minecraft.creebet.title" | "item.pasterdream.copper_axe" | "create.contraption.door_control.east" | "structure.repurposed_structures.outpost_giant_tree_taiga" | "gui.xaero_set_name" | "container.chestDouble" | "ftbquests.gui.no_dependants" | "tetra.improvement.single_handle/wrap.name" | "item.jerotesvillage.predation_toothed_flower_shoot" | "config.jade.display_mode" | "block.netherexp.enigma_crown" | "block.cataclysm.void_crystal" | "item.minecraft.splash_potion.effect.weakness" | "tetra.toolbelt.binding.secondary_use" | "effect.vampirism.disguise_as_vampire" | "item.jerotesvillage.bulge_spawn_egg" | "tetra.material.end_rod.prefix" | "item.cataclysm.laser_gatling" | "item.minecraft.ghast_tear" | "ftbquests.quest.appearance.min_width" | "block.cataclysm.prismarine_brick_fence" | "commands.worldborder.set.failed.big" | "item.minecraft.potion.effect.serpent_scale" | "gui.xaero_infodisplay_time" | "item.tetra.scroll.metal_expertise.description" | "block.pasterdream.congeal_wind_block" | "gui.sophisticatedcore.settings.buttons.keep_tab_open.on" | "warning.modernui.old_java" | "tetra.advancements.spelunking.schematic_empower.description" | "subtitle.jerotesvillage.slavery_supervisor_ambient" | "advancements.refinedstorage.autocrafting.description" | "block.pasterdream.deepslate_titanium_ore" | "tetra/schematic/shared/hone_gild_4.description" | "item.minecraft.lingering_potion.effect.dreamwish_potion" | "quark.subtitles.pipe_shoot" | "block.minecraft.lime_banner" | "jei.tooltip.bookmarks.usage.key" | "entity.jerotesvillage.earthquake_falling_block" | "create.ponder.tag.logistics" | "jer.slimeBall.text" | "ftbquests.task.ftbquests.advancement.criterion" | "gui.structure_gel.data_handler.structure_gel:entity.chestplate.description" | "block.quark.magenta_shingles_stairs" | "subtitle.jerotesvillage.firepower_pourer_death" | "gui.xaero_both_light_value" | "effect.biomancy.frenzy" | "leviathan_idle.sub" | "gui.xaero_box_start_fading_at" | "gui.xaero_compass_over_everything" | "fancymenu.elements.audio.play_mode.shuffle" | "quark.jei.hint.crab_info" | "quark.jei.hint.minecraft.clock" | "item.netherexp.grenade_antidote.effect.leaping" | "subtitle.jerotesvillage.wild_finder_death" | "create.hint.empty_bearing" | "item.takesapillage.bastille_blues_music_disc" | "gui.xaero_weather_display" | "gui.xaero_narrator_select_nothing" | "mco.create.world.reset.title" | "stat_type.minecraft.killed" | "item.ftbquests.lootcrate.missing" | "create.subtitle.train" | "advancements.achievement_special_0.descr" | "fancymenu.element.fading.fade_out.desc" | "energy_bar.polylib.capacity" | "block.minecraft.banner.diagonal_right.gray" | "block.quark.calcite_slab" | "arguments.nbtpath.too_large" | "item.prefab.item_sickle_diamond" | "block.ftbquests.chest" | "commands.curios.replace.success" | "entity.quark.forgotten" | "item.jerotesvillage.ancient_second_rounder_noble_upgrade_smithing_template" | "item.create.netherite_diving_boots.tooltip.summary" | "block.quark.blue_nether_bricks_wall" | "item.jerotesvillage.meror_shotgun" | "sounds.biomancy.block.digester.crafting" | "instrument.minecraft.admire_goat_horn" | "create.ponder.redstone_link.text_6" | "create.ponder.redstone_link.text_5" | "create.ponder.redstone_link.text_4" | "create.ponder.redstone_link.text_3" | "create.ponder.redstone_link.text_2" | "subtitles.entity.chicken.ambient" | "create.ponder.redstone_link.text_1" | "item.farmersdelight.cooked_cod_slice" | "gui.sophisticatedbackpacks.upgrades.buttons.do_not_swap_weapon.detail" | "commands.forceload.added.none" | "gui.xaero_wm_box_biome_blending" | "entity.jerotesvillage.carved_allay.vex" | "item.minecraft.smithing_template.armor_trim.applies_to" | "text.tooltips_reforged.mob_type" | "subtitle.jerotesvillage.hag_ambient" | "key.saveToolbarActivator" | "fancymenu.ui.text_editor.paste" | "ftbquests.task.ftbquests.stat" | "type.tooltips_reforged.aquatic" | "gui.xaero_waypoints_edit_hide" | "modernui.center.text.fixSurrogate" | "item.tetra.hu_xin_jing1" | "block.minecraft.banner.biomancy.mascot_base.light_gray" | "block.minecraft.banner.square_bottom_left.pink" | "block.minecraft.warped_trapdoor" | "block.quark.azalea_planks" | "block.jerotesvillage.potted_tinbush" | "fluid_type.biofactory.nutrients_fluid" | "tetra.improvement.grip/blazing.name" | "tetra.salvage_vent_plate_action.label" | "advancements.cataclysm.kill_maledictus.title" | "config.waystones.worldGen" | "fancymenu.requirements.world.is_player_in_fluid.desc" | "entity.jerotesvillage.wonderland_giant_frog" | "ftbquests.reward.ftbquests.command" | "block.prefab.block_double_compressed_quartz_crete" | "effect.simplyswords.fatal_flicker.description" | "tetra/schematic/sword/flamberge/flamberge_blade.name" | "block.cataclysm.emp" | "death.attack.fall" | "block.quark.cobblestone_bricks_stairs" | "tetra/schematic/bow/riser/stabilizer.description" | "tetra/schematic/bow/string/hone_damage_3.name" | "subtitle.jerotesvillage.hag_laugh_2" | "subtitle.jerotesvillage.hag_laugh_1" | "subtitle.jerotesvillage.hag_laugh_3" | "fancymenu.editor.widgets" | "block.minecraft.dragon_wall_head" | "create.schedule.condition.redstone_link.status" | "block.quark.chorus_weeds" | "patchouli.gui.lexicon.relations" | "fancymenu.customization.items.text.horizontal_scroll_grabber_texture.hover" | "create.logistics.creative_crate.supply" | "config.jade.plugin_minecraft.mob_breeding" | "block.create.haunted_bell.tooltip.condition1" | "argument.pehkui.modifier.invalid" | "ali/loot_table/gameplay/sniffer_digging" | "entity.cataclysm.netherite_ministrosity" | "options.iris.profile" | "gui.pasterdream.blueprint_gui_0.label_ye" | "item.create.refined_radiance" | "tooltip.biomancy.action.reload" | "ftblibrary.gui.nbt_copied" | "modernui.center.tooltip.borderWidth" | "config.waystones.worldGen.frequency" | "prefab.gui.house.improved.jungle" | "item.pasterdream.popping_candy" | "gui.xaero_enlarge_map" | "fml.modmismatchscreen.missingmods.client" | "subtitle.jerotesvillage.serpon_combat_executer_flame" | "subtitle.jerotesvillage.rust_beetle_ambient" | "enchantment.improved_exp.blindness.desc" | "gui.xaero_entity_icon_name_fallback" | "item.cataclysm.void_forge.desc" | "block.quark.lootr_birch_trapped_chest" | "chat.powerful_dummy.total_damage" | "gui.structure_gel.data_handler.structure_gel:spawner.generation_chance.label" | "death.attack.bitter_cold_fall_attack" | "linkingtool.linkingaction.add" | "commands.execute.conditional.pass_count" | "sidebutton.refinedstorage.type.0" | "sidebutton.refinedstorage.type.1" | "block.quark.mangrove_ladder" | "ftbquests.reward.exclude_from_claim_all" | "advancements.nether.find_fortress.description" | "item.minecraft.splash_potion.effect.fondillusion_potion" | "tetra/schematic/bow/stave/dreadnought_stave.slot1" | "create.gui.terrainzapper.brush.surface" | "entity.legendary_monsters.ambusher" | "inventoryprofiles.update.or" | "art_of_forging.effect.judgement.tooltip" | "item.minecraft.birch_boat" | "ftbquests.task.click_to_submit_all" | "subtitles.block.amethyst_block.resonate" | "create.command.debuginfo.saved_to_clipboard" | "effect.spore.symbiosis.description" | "item.minecraft.wooden_sword" | "jigsaw_block.generate" | "gui.socialInteractions.search_empty" | "remnant_idle.sub" | "painting.minecraft.pigscene.author" | "block.jerotesvillage.villager_metal_door" | "effect.tetra.steeled.tooltip" | "incendium.item.scarlet_dagger.desc1" | "config.jade.plugin_minecraft.harvest_tool.creative" | "commands.effect.give.success.multiple" | "item.jerotesvillage.music_disc_sediment_lord.desc" | "tetra.stats.arthropod" | "effect.jerotesvillage.dazzling_light" | "block.minecraft.black_concrete" | "item.create.netherite_diving_helmet.tooltip.summary" | "item.born_in_chaos_v1.lord_pumpkinhead_withouta_horse_spawn_egg" | "ftbquests.chapter.image.hover" | "placebo.cmd.serialize_failure" | "subtitle.jerotesvillage.meganose_snow_lizard_ambient" | "tetra/schematic/sword/shared_blade/hone_speed_5.name" | "block.quark.lootr_mangrove_trapped_chest" | "selectServer.title" | "fancymenu.element.anchor_point" | "advancement.create.diving_suit_lava.desc" | "create.display_link.writing_to" | "tetra.stats.execute_overextend.tooltip" | "config.jade.plugin_jade.mod_name_extra_msg" | "block.quark.potted_glow_lichen_growth" | "fancymenu.elements.element.stay_on_screen" | "advancements.unitywith_darknessachievement.descr" | "commands.bossbar.set.players.success.none" | "create.gui.schematicannon.option.replaceWithEmpty" | "gui.xaero_explosion_setting" | "advancements.jerotesvillage.damaged_ruins.desc" | "advancement.create.fan_processing.desc" | "block.biomancy.flesh_slab.tooltip" | "item.unbreakable" | "advancements.cataclysm.acropolis.title" | "block.minecraft.tinted_glass" | "fancymenu.editor.custombutton.config.actiontype.opengui" | "fancymenu.placeholders.world.current_player_level" | "tetra.holo.craft.materials.stat.durability.short" | "tetra/schematic/sword/unbound_stonecutter/bind_8.description" | "block.netherexp.magma_cream_block" | "block.jerotesvillage.smooth_sun_sandstone_stairs" | "jei.easy_villagers.incubating" | "subtitle.jerotesvillage.starbrite_swim" | "rune.quark.yellow" | "info.structure_gel.building_tool.property.fuzzy.value.false" | "demo.help.jump" | "parsing.double.expected" | "item.legendary_monsters.eye_of_sandstorm" | "commands.gamemode.success.self" | "cataclysm.container.weapon_fusion" | "tetra.holo.craft.translation_module" | "item.tetra.scroll.warforge/claw.description" | "tetra/schematic/sword/basic_hilt/hone_speed_4.description" | "quark.category.world" | "mco.configure.world.slot.tooltip.minigame" | "menu.sendFeedback" | "fancymenu.editor.anchor_overlay.invert_colors.desc" | "advancement.dungeons_arise.find_illager_windmill.title" | "gui.abuseReport.reason.non_consensual_intimate_imagery.description" | "attributeslib.adv.sharpness_bonus" | "gui.xaero_box_rendering_current_set" | "advancements.achievement_b_3.descr" | "ali.type.function.looting_enchant" | "block.create.toolbox.tooltip.condition2" | "serum.biomancy.empty" | "item.jerotesvillage.cooked_second_round_nigrum" | "block.create.toolbox.tooltip.condition3" | "block.minecraft.orange_glazed_terracotta" | "block.create.toolbox.tooltip.condition1" | "gui.refinedstorage.jei.transfer.request_autocrafting" | "item.tetra.forged_beam" | "info.jerotesvillage.second_round_world_exploration_guide.landing" | "commands.worldborder.set.failed.far" | "item.jerotesvillage.giant_monster_chestplate.desc" | "chunkloaders.keys.open_screen" | "fancymenu.overlay.menu_bar.tools.dirt_message_screen.desc" | "tetra.material.string" | "item.cataclysm.music_disc_the_leviathan.desc" | "block.jerotesvillage.wonderland_flower" | "inventoryprofiles.gui.editor.description.help.move.keys" | "effect.cataclysm.abyssal_burn.description" | "biome.minecraft.plains" | "tetra/schematic/single/handle/hone_speed_1.name" | "item.minecraft.honey_bottle" | "fancymenu.customization.items.input_field" | "gui.entity_tooltip.type" | "gui.sophisticatedcore.upgrades.advanced_feeding.tooltip" | "entity.pasterdream.aaroncos_lefthand_0" | "fancymenu.editor.dynamicvariabletextfield.variables.loadedmods.desc" | "tetra/schematic/shield/grip/hone_speed_1_flat.name" | "fancymenu.placeholders.min_number.desc" | "gui.xaero_light_overlay_color" | "fancymenu.background.animation.configure" | "enchantment.minecraft.bane_of_arthropods.desc" | "create.logistics.filter.exactly" | "fancymenu.helper.editor.items.visibilityrequirements.multiplayer" | "item.cataclysm.immolator2.desc" | "gamerule.bonescallerSpawn" | "item.faded_conquest_2.dormant_cube_spawn_egg" | "block.pasterdream.jungle_spore_plant" | "create.symmetry.mirror.triplePlane" | "item.protection_pixel.slingshotas_leggings" | "block.minecraft.bed.occupied" | "item.pasterdream.sculk_heart" | "structure_block.hover.load" | "advancements.quark.mine_toretoise.title" | "art_of_forging.effect.sonic_shock.name" | "farmersdelight.tooltip.cooking_pot.many_servings" | "tetra/schematic/shield/spike.description" | "subtitles.block.bubble_column.whirlpool_inside" | "advancements.achievement_treasure_start.descr" | "item.cataclysm.void_assault_shoulder_weapon.desc" | "block.minecraft.banner.rhombus.cyan" | "modernfix.option.mixin.perf.cache_blockstate_cache_arrays" | "gamerule.category.updates" | "create.train.relocate.invalid" | "fancymenu.placeholders.fps" | "gui.xaero_wm_cave_mode_type_full" | "block.minecraft.yellow_stained_glass_pane" | "ftbquests.raymatcher.entity_id" | "subtitles.block.ectoplasm.freeze" | "attribute.modifier.equals.2" | "attribute.modifier.equals.1" | "attribute.modifier.equals.0" | "subtitles.spider_mother_death" | "ftbquests.gui.clear_reward_all" | "block.quark.raw_gold_bricks_wall" | "gui.xaero_restores" | "block.biomancy.maw_hopper.tooltip" | "fancymenu.editor.items.splash.bounce.on" | "quark.subtitles.pipe_pickup" | "entity.cataclysm.kobolediator" | "fancymenu.placeholders.world.current_mount_jump_meter" | "create.contraption.controls.all_actor_toggle" | "linkingtool.linkingmode.single.desc" | "item.minecraft.splash_potion.effect.sea_monster_worship" | "argument.range.empty" | "tetra.variant.compound_cross_string/phantom_membrane" | "tetra.improvement.plate_hone/durability.name" | "create.gui.assembly.exception.noPistonPoles" | "sounds.biomancy.entity.flesh_blob.hurt" | "create.item_attributes.shulker_level" | "fancymenu.background.animation.configure.restart_on_load.on" | "advancements.jerotesvillage.mental_strength.desc" | "gui.xaero_light_both2" | "generator.single_biome_floating_islands" | "effect.biomancy.primordial_infestation" | "advancement.dungeons_arise.find_mechanical_nest.desc" | "createWorld.customize.presets.share" | "tetra.stats.art_of_forging:arcane_protection" | "fancymenu.editor.custombutton.config.actiontype.join_last_world.desc" | "sidebutton.refinedstorage.redstone_mode.2" | "sidebutton.refinedstorage.redstone_mode.1" | "sidebutton.refinedstorage.redstone_mode.0" | "tipsmod.tip.boat_passenger" | "item.cataclysm.azure_sea_shield" | "config.jade.reset_settings.confirm" | "item.minecraft.shield.yellow" | "advancements.achievement_hide_13.title" | "commands.ftbquests.command.error.no_file" | "block.minecraft.stripped_birch_wood" | "item.minecraft.firework_star.flicker" | "create.schedule.condition.for_x_time" | "fancymenu.customization.items.slider.editor.set_label_prefix" | "create.ponder.item_drain.text_4" | "create.ponder.item_drain.text_5" | "item.pasterdream.pen_and_ink" | "create.ponder.item_drain.text_2" | "create.ponder.item_drain.text_3" | "create.ponder.item_drain.text_1" | "item.tetra.ryzz" | "item.tetra.scroll.sword/howling.description" | "item.jerotesvillage.ancient_second_rounder_chestplate" | "subtitles.item.shears.shear" | "item.minecraft.potion.effect.long_wilderness_giant_poison" | "spell.jerotesvillage.push_force.desc" | "structure_block.hover.save" | "fml.menu.multiplayer.truncated" | "info.structure_gel.building_tool.message.grabbed_bounds" | "tetra/schematic/double/shared_head/hone_speed_4.name" | "create.gui.schematicannon.slot.schematic" | "structure.ctov.large.village_mountain_alpine" | "item.create.crafting_blueprint.behaviour2" | "block.minecraft.jukebox" | "item.create.crafting_blueprint.behaviour1" | "effect.biomancy.essence_anemia" | "item.born_in_chaos_v1.fire_dust" | "advancement.create.train_portal.desc" | "item.jerotesvillage.prosperous_perfume" | "block.minecraft.lime_concrete_powder" | "subtitles.cloak" | "telemetry.property.platform.title" | "item.jerotesvillage.serpon_colonial_soldier_spawn_egg" | "block.born_in_chaos_v1.black_argillite_stairs_n" | "item.born_in_chaos_v1.gummy_vampire_teeth" | "advancement.dungeons_arise.find_illager_windmill.desc" | "block.quark.yellow_blossom_leaves" | "tetra.module.sword/scissor_blade_right.item_name" | "create.ponder.nixie_tube.text_3" | "item.pasterdream.shadow_sword_embryo" | "ftbteams.name_too_short" | "create.ponder.nixie_tube.text_2" | "legendary_monsters.message.mossy_golem_string_message_name" | "create.ponder.nixie_tube.text_1" | "message.jerotes.machine" | "block.minecraft.banner.stripe_right.black" | "disconnect.kicked" | "item.protection_pixel.lancer_helmet" | "block.minecraft.banner.skull.green" | "create.schematicannon.status.finished" | "fancymenu.editor.actions.blocks.add.while" | "filled_map.dungeons_arise:illager_castle" | "tetra/schematic/double/shared_head/hone_shovel_efficiency_1.name" | "item.sophisticatedbackpacks.advanced_refill_upgrade" | "item.pasterdream.wind_journey_disc.desc" | "fancymenu.helper.editor.items.copyid" | "demo.help.later" | "effect.tconstruct.insatiable_melee.description" | "block.minecraft.exposed_copper" | "subtitle.jerotesvillage.tyrant_of_the_mountain_realm_block" | "tetra.stats.extractionMedialLimit.tooltip" | "advancements.jerotesvillage.coven.desc" | "entity.jerotesvillage.qoaiku_seeker" | "sodium.options.buttons.apply" | "effect.minecraft.hunger.description" | "compliance.playtime.message" | "tetra/schematic/crossbow/stock/basic_stock.slot1" | "tetra/schematic/sword/shared_blade/hooked_1.description" | "block.quark.blue_blossom_leaf_carpet" | "block.quark.polished_shale_stairs" | "effect.farmersdelight.nourishment" | "block.minecraft.dead_horn_coral_fan" | "mco.configure.world.subscription.days" | "gui.refinedstorage.fluid_interface.in" | "block.born_in_chaos_v1.tombstone_fubuki_banzai" | "block.minecraft.iron_trapdoor" | "enchantment.moblassos.holding.desc" | "arguments.item.overstacked" | "death.attack.fallingBlock" | "block.minecraft.banner.flower.magenta" | "subtitle.jerotesvillage.bright_land_beast_hurt" | "block.jerotesvillage.deepslate_meror_metal_ore" | "item.minecraft.firework_star" | "advancements.achievement_hide_15.title" | "quark.emote.salute" | "jer.dungeon.village_plains_house" | "tetra.advancements.art_of_forging.crucible_upgrade.title" | "createWorld.customize.custom.mainNoiseScaleX" | "item.tetra.scroll.skin_expertise.prefix" | "createWorld.customize.custom.mainNoiseScaleY" | "key.modernui.zoom" | "createWorld.customize.custom.mainNoiseScaleZ" | "block.create.gearshift" | "block.biomancy.bio_lab.tooltip" | "misc.refinedstorage.storage.full" | "item.cataclysm.blazing_grips.desc" | "effect.netherexp.absorption_immunity.description" | "item.tetra.scroll.warforge/hammer.description_extended" | "block.minecraft.banner.half_vertical.orange" | "tetra/schematic/single/head/unbound_earthpiercer/bind_1.description" | "block.farmersdelight.pink_canvas_sign" | "commands.data.modify.invalid_index" | "item.born_in_chaos_v1.spiritual_easter_egg" | "block.create.crimson_window_pane" | "block.minecraft.banner.square_bottom_left.black" | "block.minecraft.spruce_wall_hanging_sign" | "block.minecraft.cornflower" | "constructionwand.option.replace.yes.desc" | "effect.minecraft.jump_boost.description" | "gui.xaero_box_arrow_color" | "block.minecraft.bamboo_fence" | "structure.structory_towers.nether/strange_outpost" | "debug.inspect.client.block" | "subtitles.gadfly_idle" | "mco.activity.noactivity" | "tetra/schematic/double/basic_handle/hone_speed_1.name" | "entity.minecraft.villager.weaponsmith" | "menu.paused" | "block.netherexp.smooth_netherrack_stairs" | "item.pasterdream.protect_deck" | "effect.mahoutsukai.bleeding.description" | "advancements.my_size.title" | "item.faded_conquest_2.gate_key" | "commands.trigger.failed.unprimed" | "key.jade.show_details_alternative" | "attributeslib:ghost_health.desc" | "options.language" | "fancymenu.customization.items.text.markdown.code_block.multi.color" | "chat.waystones.cannot_transport_leashed_dimensional" | "advancement.create.andesite_casing.desc" | "tetra.stats.art_of_forging:healing_infused.tooltip_short" | "tetra.module.sword/machete.name" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.player" | "tetra/schematic/double/extractor/hone_extractor_3.description" | "gui.download" | "create.gui.schematicannon.option.skipMissing.description" | "advancements.refinedstorage.conditional_connecting.description" | "advancements.shakeand_mix.descr" | "item.tetra.forged_mesh" | "incendium.inferno.spell.last.clear" | "item.legendary_monsters.ancient_spike" | "effect.nethervinery.gravedigger.description" | "tetra/schematic/double/unbound_extractor/medial_limiter.name" | "block.minecraft.infested_stone_bricks" | "tag.item.quark.posts" | "incendium.inferno.spell.lasers.all" | "block.minecraft.magenta_wool" | "fancymenu.elements.button.template_settings" | "create.schedule.continued" | "subtitles.entity.goat.hurt" | "block.jerotesvillage.resurrecter_empty_coffin" | "fancymenu.custom_guis.build.identifier.invalid" | "block.netherexp.discernment_glass" | "fml.menu.mods.info.trust" | "create.generic.unit.minutes" | "createWorld.customize.custom.depthNoiseScaleExponent" | "block.born_in_chaos_v1.black_argillite_wall_n" | "item.lendersdelight.pasta_with_witherite" | "gui.xaero_arrow_colour" | "item.geckolib.mutant_zombie_spawn_egg" | "gui.xaero_category_settings_confirm" | "item.pasterdream.light_organ" | "structure.repurposed_structures.outpost_desert" | "create.schedule.condition.redstone_link.frequency_unpowered" | "tetra.variant.light_handle/stick" | "block.quark.hollow_mangrove_log" | "create.track_signal.cannot_change_mode" | "block.minecraft.waxed_cut_copper" | "painting.minecraft.alban.title" | "tetra.module.sword/basic_hilt.material_name" | "mco.upload.failed" | "options.framerateLimit" | "block.netherexp.carved_sorrowsquash" | "subtitles.minion_death" | "enchantment.shieldsplus.reinforced.desc" | "tetra.improvement.stonecutter_hone/efficiency.name" | "death.attack.punishment.player" | "trim_material.minecraft.amethyst" | "narrator.button.difficulty_lock.unlocked" | "item.sophisticatedbackpacks.everlasting_upgrade.tooltip" | "commands.datapack.list.available.none" | "subtitles.nsstep1" | "effect.minecraft.saturation.description" | "item.legendary_monsters.monstrous_anchor" | "tetra/schematic/double/shared_head/hone_pickaxe_efficiency_4.name" | "item.cataclysm.ancient_remnant_spawn_egg" | "block.minecraft.brown_concrete" | "tetra/schematic/sword/saber_blade.description" | "block.minecraft.potted_bamboo" | "fancymenu.helper.editor.items.visibilityrequirements.realtimeminute" | "effect.xaerominimap.no_entity_radar_harmful.description" | "incendium.item.hazmat.helmet.name" | "quark.jei.hint.use_for_vanishing" | "axe_swing.sub" | "info.structure_gel.dynamic_spawner_description" | "create.schematicannon.status.clearing" | "create.schedule.condition.player_count.status" | "biome.incendium.inverted_forest" | "effect.soulsweapons.blight.description" | "quark.subtitles.ambient.fire" | "patchouli.gui.lexicon.not_anchored" | "create.schematic.invalid" | "tetra.advancements.spelunking.find_ruins_map.title" | "string.naturescompass.fillerBlock" | "item.jerotesvillage.wonderland_challenge.desc_1" | "death.attack.attributeslib:bleeding" | "item.jerotesvillage.wonderland_challenge.desc_0" | "item.minecraft.shelter_pottery_sherd" | "resourcePack.server.name" | "tetra.module.bow/long_stave.name" | "block.born_in_chaos_v1.tombstone_mike_rory" | "tetra.stats.counterweight" | "item.minecraft.potion.effect.haunting_imp" | "create.schematicannon.status.ready" | "item.lendersdelight.glazed_remnant_skull" | "block.prefab.block_quartz_crete_bricks" | "entity.minecraft.warden" | "item.biomancy.healing_additive.tooltip" | "mco.selectServer.mapOnlySupportedForVersion" | "block.quark.permafrost" | "death.attack.biomancy.bleed.player" | "string.explorerscompass.local_modifications" | "ali.type.condition.match_player" | "block.minecraft.deepslate_tiles" | "gui.xaero_waypoints_global" | "create.gui.schematicannon.slot.gunpowder" | "block.quark.jungle_leaf_carpet" | "jei.easy_villagers.breeding" | "biome.minecraft.snowy_slopes" | "create.logistics.recipe_filter" | "selectWorld.import_worldgen_settings" | "item.pasterdream.shadow_npc_0_spawn_egg" | "argument.pehkui.type.invalid" | "fancymenu.elements.browser.url" | "mco.terms.title" | "modernui.center.screen.blurRadius" | "effect.born_in_chaos_v1.stimulatingsurge" | "modernfix.connectedness_dynresoruces" | "create.gui.schematicTable.title" | "fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups" | "item.pasterdream.titanium_armor_boots" | "item.minecraft.heartbreak_pottery_shard" | "item.faded_conquest_2.fadedking_p_2egg" | "inventoryprofiles.config.description.open_gui_editor" | "gui.xaero_ui_scale_auto" | "chunkloaders.legacy_message" | "item.minecraft.lingering_potion.effect.purple_sands_secret" | "inventoryprofiles.config.notification.tool_replace_failed.replacing" | "item.protection_pixel.incompletetyphoon" | "jer.notBurning.text" | "enchdesc.jei.compatible_items.title" | "effect.dungeons_mobs.warped.description" | "tetra.module.sword/bastard_blade.description" | "ftbquests.reward.team_reward.tooltip" | "advancements.jerotesvillage.serpon.desc" | "subtitle.jerotesvillage.little_velvet_ambient" | "subtitle.jerotesvillage.magic_push_force" | "advancements.legendary_monsters.defeat_ambusher.title" | "entity.jerotesvillage.wonderlin" | "item.farmersdelight.fruit_salad" | "key.curios.open.desc" | "gui.xaero_tracked_player_world_name_scale" | "subtitles.block.beehive.exit" | "block.ftbquests.screen.fullscreen" | "gui.xaero_wm_legible_cave_maps" | "block.create.millstone" | "block.quark.spruce_leaf_carpet" | "subtitles.block.chest.open" | "effect.epicfight.instability.description" | "tetra.variant.rending_scissor_complete/rending_scissor_complete" | "tooltip.jade.villager_profession" | "entity.quark.stoneling" | "block.quark.gray_shingles_slab" | "subtitle.jerotesvillage.ruins_breeze_ambient_air" | "tooltip.waystones.black_sharestone" | "tetra.stats.ability_speed" | "item.create.goggles" | "subtitle.jerotesvillage.second_rounder_golem_ambient" | "options.credits_and_attribution" | "tetra.module.bow/basic_string.description" | "filled_map.dungeons_arise:illager_galley" | "advancements.unlucky_hunter.descr" | "item.born_in_chaos_v1.sweet_axe" | "tag.item.quark.big_harvesting_hoes" | "block.minecraft.banner.circle.light_blue" | "item.minecraft.bundle" | "tetra.stats.earthbind.tooltip" | "fancymenu.helper.placeholder.elementposx" | "fancymenu.helper.placeholder.elementposy" | "advancement.create.belt.desc" | "tag.item.quark.seed_pouch_fertilizers" | "boss.jerotesvillage.serpon_combat_executer" | "item.jerotesvillage.anesthetized_arrow" | "fancymenu.editor.loading_requirement.category.world" | "tetra.variant.scanner/default" | "block.minecraft.magenta_glazed_terracotta" | "tetra.module.bow/recurve_stave.prefix" | "subtitles.entity.puffer_fish.hurt" | "farmersdelight.advancement.hit_raider_with_rotten_tomato.desc" | "block.quark.mangrove_bookshelf" | "message.jerotes.is_faction_yes" | "sodium.options.use_fog_occlusion.name" | "block.minecraft.moving_piston" | "ftbquests.raymatcher.block_entity_id" | "block.biomancy.smooth_primal_flesh.tooltip" | "chat.corpse.teleport_death_location" | "gui.xaero_edit_mode" | "__comment" | "tetra.tweak.double_tweak/binding_bolt.left" | "quark.jei.hint.blaze_lantern" | "tetra.module.sword/crucible_blade.prefix" | "block.minecraft.smooth_sandstone_stairs" | "item.jerotesvillage.archnosed_hornbeast_spawn_egg" | "incendium.advancement.infernal_dunes.inferno.root.title" | "gui.xaero_tracked_player_world_icon_scale" | "stat.minecraft.open_barrel" | "attributeslib:arrow_damage" | "debug.creative_spectator.error" | "mco.brokenworld.nonowner.title" | "item.born_in_chaos_v1.damned_demomans_hat_helmet" | "create.gui.terrainzapper.brush.cylinder" | "subtitle.jerotesvillage.rust_beetle_hurt" | "entity.jerotesvillage.ominous_banner_raid_count" | "advancements.quark.get_own_head.description" | "tetra.module.double/binding.name" | "block.minecraft.banner.half_vertical.gray" | "gui.socialInteractions.search_hint" | "subtitles.persecutor_scream" | "spell.jerotesvillage.conjure_iron_teeth.desc" | "painting.jerotesvillage.boss.author" | "pehkui.configgui.scale_limits.view_bobbing.minimum" | "advancements.legendary_monsters.defeat_posessed_paladin.description" | "item.cataclysm.witherite_ingot" | "biome.minecraft.basalt_deltas" | "block.quark.limestone_bricks_stairs" | "block.netherexp.soul_candle" | "gui.xaero_howto_save" | "advancements.nether.tower_defense.description" | "block.ftbquests.screen.input_only" | "advancements.nether.sanctum_of_wax.description" | "block.minecraft.pink_glazed_terracotta" | "info.structure_gel.building_tool.property.move_distance.description" | "advancements.achievement_treasure_a_3.descr" | "message.jerotes.is_avoid_damage_no" | "subtitles.entity.hoglin.retreat" | "world.jerotesvillage.second_round_world" | "fancymenu.elements.text.v2.interactable" | "entity.faded_conquest_2.blocknightfist" | "button.corpse.previous" | "tetra/schematic/sword/basic_hilt/hone_speed_2.name" | "gui.sophisticatedbackpacks.upgrades.deposit" | "item.jerotesvillage.explorer_upgrade_smithing_template.desc_0" | "item.jerotesvillage.explorer_upgrade_smithing_template.desc_1" | "item.jerotesvillage.explorer_upgrade_smithing_template.desc_2" | "item.biomancy.chroma_sheep_spawn_egg" | "fancymenu.editor.close_audio.desc" | "info.structure_gel.building_tool.property.replace" | "item.jerotesvillage.slavery_supervisor_helmet" | "advancements.legendary_monsters.locate_ancient_tower_remains.title" | "quark.jei.hint.repair_item_changed_multiple" | "ali.property.value.zoom" | "item.minecraft.potion.effect.slowness" | "block.minecraft.mossy_stone_brick_slab" | "biome.minecraft.stony_peaks" | "gui.modernui.settings.category.video" | "sounds.biomancy.entity.flesh_cow.death" | "item.jerotesvillage.meror_standard_boots.desc_1" | "item.jerotesvillage.meror_standard_boots.desc_0" | "tetra/schematic/shield/plate/hone_damage_3.description" | "subtitles.entity.slime.death" | "prefab.gui.modern.tree_house" | "modernui.center.tooltip.shadowOpacity" | "subtitles.entity.firework_rocket.blast" | "art_of_forging.advancements.materials.sigil_of_eden.title" | "create.display_source.observed_train_name" | "block.quark.light_gray_shingles" | "mco.selectServer.expired" | "block.create.andesite_door" | "entity.pasterdream.fox_fire" | "item.jerotesvillage.meror_standard_boots.desc_2" | "block.minecraft.enchanting_table" | "structure.repurposed_structures.igloo_mangrove" | "narrator.button.language" | "itemfilters.help_text.nbt" | "trim_pattern.netherexp.rift" | "painting.minecraft.plant.title" | "subtitle.jerotesvillage.virtual_cave_cockroach_ambient_small" | "subtitles.entity.villager.death" | "fancymenu.helper.editor.items.visibilityrequirements.is_button_active" | "entity.cataclysm.abyss_blast_portal" | "stat.minecraft.interact_with_smithing_table" | "item.pasterdream.bacone_egg" | "advancements.refinedstorage.wireless_items" | "item.functionalstorage.configuration_tool" | "fancymenu.placeholders.world.current_player_hunger_percent.desc" | "incendium.advancement.volcanic_deltas.hidden_debris.title" | "tetra.stats.slam" | "msg.biomancy.item_interaction_not_allowed" | "item.cataclysm.necklace_of_the_desert" | "ali.property.value.done" | "key.mouse" | "ali.type.function.set_instrument" | "block.minecraft.banner.triangles_bottom.blue" | "tetra/schematic/shield/grip/hone_damage_5_flat.description" | "config.jade.plugin_minecraft.villager_profession" | "item.tetra.scroll.tetra/crucible_blade.description_extended" | "fancymenu.helper.placeholder.calc" | "block.minecraft.banner.border.pink" | "prefab.gui.villager.house.angled" | "quark.gui.config.social.patreon" | "mco.configure.world.restore.question.line2" | "mco.configure.world.restore.question.line1" | "disconnect.genericReason" | "block.minecraft.bamboo_mosaic_stairs" | "lootr.message.cannot_break" | "biome.minecraft.flower_forest" | "drippyloadingscreen.elements.vanilla_bar.desc" | "block.quark.polished_shale" | "biome.netherexp.exhaust_mire" | "ali.property.branch.scores" | "incendium.advancement.infernal_dunes.pipeline.unlimited_power.title" | "modernfix.option.mixin.bugfix.missing_block_entities" | "menu.playdemo" | "constructionwand.option.match.exact" | "item.quark.dragon_scale" | "block.cataclysm.purpur_wall" | "block.minecraft.stone_pressure_plate" | "structure.incendium.infernal_altar" | "advancements.food_fight.descr" | "block.tetra.multi_schematic.extractor.name" | "item_group.born_in_chaos_v1.weapons_bornin_chaos" | "ali.type.function.set_damage" | "fancymenu.resources.pre_loading.desc" | "prefab.gui.house.snowy.display" | "item.pasterdream.copper_sword" | "spell.jerotesvillage.thorn_spike" | "item.create.filter.tooltip.behaviour1" | "inventoryhud.config.gui.bardur" | "subtitle.jerotesvillage.celestial_coilvine_four" | "argument.entity.options.distance.negative" | "quark.jei.hint.minecraft.chain" | "entity.jerotesvillage.ominous_bomb" | "subtitles.entity.skeleton_horse.death" | "commands.ftbquests.change_consumable.text" | "block.quark.bamboo_trapped_chest" | "item.protection_pixel.incompletehellsnake" | "item.pasterdream.copper_armor_chestplate" | "item.pasterdream.red_dew_3_ring" | "ftbquests.reward.ftbquests.npc_mail" | "config.jeiintegration.tooltips.nbtTooltipMode" | "enchantment.improved_exp.resistance.desc" | "item.tetra.modular.hone_progress.description_extended" | "block.minecraft.spruce_wall_sign" | "block.minecraft.banner.gradient_up.red" | "create.schedule.loop" | "subtitles.entity.zombie_horse.hurt" | "sidebutton.refinedstorage.exact_mode" | "create.gui.schedule.alternative_condition" | "modernui.center.screen.blurEffect_desc" | "deepling_light.sub" | "config.waystones.client.disableTextGlow" | "item.minecraft.splash_potion.effect.slowness" | "ftbteams.message.promoted" | "item.minecraft.music_disc_mall.desc" | "gui.sophisticatedcore.upgrades.feeding.tooltip" | "item.minecraft.shield.blue" | "death.attack.player" | "item.jerotesvillage.beach_terror_bird_spawn_egg" | "block.jerotesvillage.wonderland_leaves" | "mco.worldSlot.minigame" | "block.waystones.white_sharestone" | "block.lootr.lootr_trapped_chest" | "entity.cataclysm.porta_abyss_blast" | "entity.jerotesvillage.glass_throwing_ball" | "prefab.gui.house.subaquatic.display" | "block.pasterdream.breakwind_curtain" | "block.minecraft.andesite_wall" | "block.netherexp.soul_skeleton_skull_candle" | "category.tooltips_reforged.keys" | "subtitle.jerotesvillage.necromancy_warlock_scream" | "config.waystones.xpCost.dimensionalWarpXpCost.tooltip" | "gamerule.pasterdreamDebugmode.description" | "tetra.holo.improvement_requirement_level.level_label" | "quark.jei.hint.ambience_discs" | "item.jerotesvillage.spirve_razor" | "item.born_in_chaos_v1.glutton_fish_spawn_egg" | "advancements.story.follow_ender_eye.description" | "block.minecraft.birch_trapdoor" | "fancymenu.layout.manage.layouts.sort_by" | "gamerule.logAdminCommands" | "gui.waystones.waystone_selection.next_page" | "item.utility.direction" | "block.biomancy.impermeable_membrane_pane.tooltip" | "block.quark.acacia_bookshelf" | "advancements.story.smelt_iron.title" | "tetra/schematic/bow/string/release_latch.name" | "tetra.variant.quiver/leather" | "inventoryprofiles.config.name.show_locked_slots_bg_color" | "item.farmersdelight.cooked_bacon" | "block.netherexp.soul_slate_bricks" | "subtitles.faded_king_block" | "constructionwand.option.replace.yes" | "gui.xaero_box_entity_radar_categories" | "subtitles.krampus_blow" | "tetra.variant.basic_hilt/blaze_rod" | "effect.kubejs.suo_xiao" | "config.tooltips_reforged.backgroundColor" | "inventoryprofiles.config.description.villager_trading_enable" | "advMode.mode.redstoneTriggered" | "options.darknessEffectScale.tooltip" | "entity.jerotesvillage.qoaiku" | "item.jerotesvillage.meror_standard_upgrade_smithing_template.desc_0" | "item.jerotesvillage.meror_standard_upgrade_smithing_template.desc_1" | "quark.gui.keygroup.emote" | "create.schedule.condition.redstone_link.frequency_state" | "painting.minecraft.void.title" | "gui.jei.category.smoking" | "item.cataclysm.the_baby_leviathan_bucket" | "ftbquests.chapter.image.alpha" | "config.waystones.restrictions.dimensionalWarp.tooltip" | "jei.key.category.search" | "create.ponder.train_signal_redstone.header" | "item.prefab.item_nether_gate" | "farmersdelight.container.recipe_book.cookable" | "attributeslib:current_hp_damage.desc" | "fancymenu.helper.placeholder.stringify" | "fancymenu.helper.editor.layoutoptions.universal_layout.options" | "effect.vampirism.sanguinare.description" | "effect.vampirism.garlic.description" | "block.quark.birch_trapped_chest" | "gui.xaero_box_keep_enlarged_minimap_unlocked" | "gui.xaero_hide_minimap_under_screen" | "tetra/schematic/sword/tsuba_guard.name" | "advancement.dungeons_arise.find_bandit_towers.desc" | "block.minecraft.bamboo_planks" | "advancement.create.ejector_maxed" | "item.sophisticatedbackpacks.pump_upgrade" | "effect.terramity.slam_state.description" | "effect.minecraft.slowness.description" | "gamerule.category.chat" | "block.tetra.forged_pillar" | "item.quark.gray_shard" | "subtitle.jerotesvillage.corrosiver_hurt" | "item.jerotesvillage.lightning_worm_chitin.desc" | "effect.casualness_delight.rotten.description" | "block.minecraft.warped_sign" | "enchantment.improved_exp.indestructible.desc" | "death.attack.thorns.item" | "item.minecraft.cooked_porkchop" | "gui.xaero_waypoints_edit_show" | "item.jerotesvillage.tyrant_of_the_mountain_realm_helmet_plume" | "item.create.filter" | "commands.experience.set.points.success.single" | "create.ponder.shared.sneak_and" | "block.minecraft.banner.square_bottom_left.red" | "gui.refinedstorage.interface.import" | "subtitle.jerotesvillage.magic_botanize_bullet" | "effect.twilightforest.frosted.description" | "gui.xaero_entity_category_hostile_tamed" | "fancymenu.helper.buttonaction.enable_layout.value.desc" | "tetra.improvement.blade/vengeance_tier.prefix" | "item.sophisticatedbackpacks.chipped.alchemy_bench_upgrade.tooltip" | "patchouli.gui.lexicon.keybind_missing" | "advancements.adventure.adventuring_time.title" | "subtitles.fallen_idle" | "itemfilters.help_text.damage" | "item.minecraft.firework_star.light_blue" | "block.minecraft.banner.stripe_downright.blue" | "item.minecraft.tipped_arrow.effect.water_breathing" | "advancements.nether.all_potions.title" | "painting.minecraft.fire.author" | "item.born_in_chaos_v1.shakeand_mixicon" | "gui.xaero_error_loading_properties" | "tetra.aspect.crossbow.description" | "entity.cataclysm.ender_golem" | "quark.jei.hint.crate" | "effect.terramity.immunity.description" | "item.citadel.citadel_book" | "item.pasterdream.shadow_vortex_item" | "ftbfiltersystem.message.changes_saved" | "item.liolib.gecko_armor_leggings" | "item.protection_pixel.hellsnake_chestplate" | "enchantment.dungeonsenchantments.ambush.desc" | "createWorld.customize.custom.useStrongholds" | "tetra.aspect.fishing_rod.description" | "fancymenu.customization.elements.cursor.hotspot_x.desc" | "block.quark.crafter" | "item.born_in_chaos_v1.pumpkinhandgun" | "block.biomancy.packed_flesh_slab.tooltip" | "gui.xaero_settings_search_placeholder" | "gui.xaero_world_connection_tooltip" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.realtimeday" | "create.item_attributes.fluid_container.inverted" | "item.jerotesvillage.ominous_war_beast_armor" | "item.jerotesvillage.golden_bright_melon" | "commands.advancement.grant.many.to.many.success" | "tetra/schematic/crossbow/stave/basic_stave.slot1" | "tetra.improvement.blade/infernal.name" | "block.create.spruce_window_pane" | "entity.minecraft.salmon" | "item.pasterdream.boboji_curio" | "fancymenu.placeholders.math_round" | "advancements.horrorofthe_depths.title" | "inventoryprofiles.config.name.include_custom_name" | "create.generic.unit.seconds" | "item.pasterdream.iceshadow_curio" | "fancymenu.customization.elements.cursor.hotspot_y" | "fancymenu.customization.elements.cursor.hotspot_x" | "fml.menu.loadingmods" | "block.minecraft.banner.stripe_top.yellow" | "block.minecraft.redstone_ore" | "item.biomancy.gift_sac.tooltip" | "effect.vinery.shiraaz_effect.description" | "block.minecraft.banner.stripe_left.red" | "entity.minecraft.villager.jerotesvillage:villager_villagehead" | "prefab.gui.compressed_chest_desc" | "subtitles.block.frogspawn.hatch" | "fancymenu.customization.items.input_field.editor.set_type.desc" | "create.ponder.associated" | "attributeslib:prot_pierce" | "fancymenu.editor.elements.player_entity.pose.left_arm" | "disconnect.disconnected" | "tetra.holo.craft.materials.stat.integrity" | "gui.pasterdream.research_table_gui.button_copy" | "fancymenu.editor.add.animation.desc" | "create.schematicAndQuill.convert" | "item.minecraft.splash_potion.effect.lich_curse" | "block.quark.ancient_ladder" | "tetra.variant_category.metal.label" | "subtitle.jerotesvillage.bloodsucker_death" | "ali.type.condition.location_check" | "item.minecraft.minecart" | "tetra/schematic/bow/riser/extended_rest.description" | "inventoryprofiles.gui.editor.name.screen.force" | "optimizeWorld.stage.upgrading" | "text.autoconfig.obscuria/loot_journal-client.option.filtering.tabsBlacklist" | "remnant_hurt.sub" | "Raider of the Tombs" | "item.jerotesvillage.rambler_leather_war_beast_armor" | "block.minecraft.banner.biomancy.mascot_accent.black" | "item.born_in_chaos_v1.empty_fel_lamp" | "fancymenu.customization.items.text.alignment.left" | "tutorial.punch_tree.title" | "inventoryprofiles.config.name.restock_hotbar" | "painting.minecraft.match.author" | "inventoryprofiles.common.gui.config.keybind_settings_tips" | "quark.misc.rotation_lock" | "key.sprint" | "string.naturescompass.average" | "attributeslib.modifier.plus" | "advancements.hat_for_dark_deeds.descr" | "structure.repurposed_structures.pyramid_badlands" | "inventoryprofiles.config.description.include_custom_name" | "config.jade.display_bosses" | "tetra.stats.blocking.tooltip" | "block.create.creative_motor" | "painting.minecraft.pointer.author" | "gui.refinedstorage.disk_drive" | "gamerule.restlessSpiritSpawn" | "mco.configure.world.slot.tooltip" | "item.pasterdream.pink_chicken_spawn_egg" | "item.minecraft.clay_ball" | "fancymenu.background.image.configure.parallax_intensity.desc" | "item.protection_pixel.blooddialysisdevice.description_0" | "block.jerotesvillage.unstable_hags_cauldron" | "ftblibrary.panel.position.bottom" | "tetra.stats.execute_overcharge.tooltip" | "jer.dungeon.bastion_hoglin_stable" | "death.attack.dragonBreath.player" | "advancements.adventure.two_birds_one_arrow.description" | "item.netherexp.antidote.effect.poison" | "jigsaw_block.joint.rollable" | "effect.terramity.nyxium_fire.description" | "block.minecraft.light_gray_wool" | "advancements.nether.return_to_sender.title" | "prefab.gui.farm.advanced.produce" | "modernfix.option.mixin.bugfix.entity_pose_stack" | "item.structure_gel.building_tool.mode.structure_gel:shape" | "subtitles.stalker_death2" | "quark.jei.influence" | "text.cloth-config.quit_config_sure" | "create.item_attributes.furnace_fuel" | "item.pasterdream.true_moltengold_wand" | "effect.netherexp.betrayed" | "config.jade.plugin_minecraft.mob_spawner" | "item.quark.ancient_chest_boat" | "subtitles.entity.vindicator.death" | "item.jerotesvillage.glaive_of_serpent_dominater.desc" | "advancement.create.self_deploying.desc" | "structure.repurposed_structures.temple_nether_crimson" | "narration.jade.negative" | "commands.trigger.failed.invalid" | "block.create.framed_glass" | "block.netherexp.soul_burning_skull_block" | "subtitle.jerotesvillage.chibao_hurt" | "gui.xaero_wm_option_requires_ingame" | "tetra.improvement.stave_grip/wrap_vine.description" | "quark.keybind.patreon_emote.dance" | "gui.pasterdream.blueprint_gui_0.button_empty1" | "gui.sophisticatedcore.upgrades.buttons.previous_result" | "advMode.notEnabled" | "entity.jerotesvillage.coilvine_botanize" | "item.jerotesvillage.cleaning_robot_spawn_egg" | "item.create.copper_diving_helmet.tooltip.condition1" | "block.pasterdream.frame_clarity_glasspane" | "takesapillage.configGui.normalGolemRate.title" | "create.display_source.entity_name" | "block.create.small_scorchia_brick_stairs" | "advancements.adventure.trim_with_all_exclusive_armor_patterns.description" | "item.create.copper_diving_helmet.tooltip.behaviour1" | "drippyloadingscreen.deepcustomization.overlay.logo.display_name" | "inventoryprofiles.config.description.notification_step" | "death.attack.create.mechanical_saw" | "create.boiler.max_lvl" | "item.create.netherite_backtank.tooltip.summary" | "commands.bookshelf.loot_tables.wildcard" | "ftbquests.reward_table.edit" | "item.jerotesvillage.sediment_catacombs_map" | "fancymenu.elements.animation_controller.keyframe_manager.pause" | "argument.range.ints" | "prefab.gui.farm.multi_level" | "spell.jerotesvillage.wilt_missile" | "effect.mobs_of_sins.lingering_pheromones.description" | "advancements.achievement_b_2.descr" | "tetra_view.view" | "biome.minecraft.savanna" | "effect.born_in_chaos_v1.vampiric_touch.description" | "structure.structory_towers.lighthouse" | "tetra.stats.slam.tooltip_extended" | "effect.archers_paradox.training_miss.description" | "subtitles.entity.warden.sonic_charge" | "inventoryprofiles.config.name.ignore_durability" | "block.create.cut_ochrum_brick_slab" | "gamerule.boneImpSpawn" | "advancements.jerotesvillage.elemental_materials.desc" | "gui.xaero_requires_reload" | "options.iris.apply" | "tetra.material.stick.prefix" | "gui.xaero_radar_over_map_never" | "gui.xaero_armour_status_settings" | "subtitles.entity.fox.eat" | "inventoryprofiles.config.description.auto_refill_temp_disable_refill_for_tools" | "tetra.tweak.double_tweak/binding_bolt.right" | "block.quark.sandstone_bricks_slab" | "forge.configgui.skipEmptyShapelessCheck" | "inventoryprofiles.config.name.enable_analytics" | "block.create.polished_cut_scoria_slab" | "create.super_glue.click_to_discard" | "subtitles.entity.warden.nearby_close" | "item.minecraft.scute" | "item.minecraft.lingering_potion.effect.swiftness" | "itemfilters.variants" | "item.protection_pixel.magneticstorm_chestplate.description_0" | "item.jerotesvillage.bright_melon" | "modernui.center.tooltip.borderCycle_desc" | "item.protection_pixel.buoyancyas_leggings" | "stat.minecraft.inspect_hopper" | "item.protection_pixel.magneticstorm_chestplate.description_1" | "item.protection_pixel.steamectoskeleton.description_0" | "item.minecraft.brewer_pottery_sherd" | "sidebutton.refinedstorage.exact_mode.on" | "tetra.stats.execute.tooltip" | "effect.kubejs.zhou_yi" | "fancymenu.editor.anchor_overlay.visibility_mode.keybind" | "item.jerotesvillage.scaly_bear_spawn_egg" | "ftbquests.reward.claim_all" | "structure.ctov.small.village_jungle_tree" | "gui.xaero_cave_maps_depth" | "tetra.stats.tool.unboundExtraction" | "block.create.seat.tooltip.summary" | "entity.jerotes.poison_breath" | "create.ponder.large_cogwheel.header" | "advancements.hatman.descr" | "fancymenu.file_types.fma" | "block.create.cut_diorite_brick_slab" | "gui.narrate.slider" | "selectWorld.access_failure" | "block.minecraft.deepslate_redstone_ore" | "tetra.stats.reach" | "gui.easy_villagers.input" | "block.netherexp.polished_basalt_slab" | "create.schematic.tool.deploy" | "painting.minecraft.fire.title" | "tetra.improvement.blade/tempered.name" | "quark.misc.opened_screen" | "effect.xreliquary.pacification.description" | "inventoryprofiles.enum.tool_replace_visual_notification.chat" | "entity.born_in_chaos_v1.swarmer" | "subtitle.takesapillage.entity.legioner.ambient" | "patchouli.gui.lexicon.button.advancements" | "block.minecraft.mangrove_pressure_plate" | "item.itemfilters.weak_nbt" | "effect.biomancy.bleed" | "item.legendary_monsters.fiery_boots" | "advancements.achievement_shadow_b_0.descr" | "create.display_source.kinetic_speed" | "jeed.tooltip.color_complete" | "tetra.stats.armor.tooltip" | "painting.jerotesvillage.boss.title" | "tetra/schematic/shared/hone_gild_3.description" | "item.jerotesvillage.arc_arrow" | "block.biomancy.biometric_membrane.unique" | "item.netherexp.stampede_spawn_egg" | "gui.xaero_wm_connect_with_auto_msg" | "item.minecraft.rabbit" | "item.minecraft.tipped_arrow.effect.weakness" | "block.minecraft.crying_obsidian" | "block.refinedstorage.portable_grid.tooltip" | "subtitle.jerotesvillage.starbrite_hurt" | "item.minecraft.music_disc_mellohi.desc" | "tetra.improvement.quality.name" | "item.jerotesvillage.meror_standard_helmet" | "item.explorerscompass.explorerscompass" | "tetra/schematic/sword/unbound_stonecutter/adjustable_focus.name" | "modernfix.option.enabled" | "mco.template.button.select" | "item.kubejs.ancient_star" | "config.jade.plugin_jade.mod_name" | "citadel.gui.cape_type" | "tetra/schematic/double/shockwave_hammer/shockwave_hammer.description" | "subtitles.entity.drowned.swim" | "trashslot.hint.toggledOff" | "create.subtitle.haunted_bell_use" | "commands.title.show.title.multiple" | "effect.occultism.third_eye.description" | "item.jerotesvillage.wonderland_giant_frog_tadpole_bucket" | "item.sophisticatedbackpacks.stack_downgrade_tier_1" | "block.minecraft.banner.biomancy.mascot_base.orange" | "block.minecraft.banner.creeper.light_blue" | "item.cataclysm.ignitium_helmet.desc2" | "ali/loot_table/archaeology/trail_ruins_rare" | "item.netherexp.necromium_plating" | "tetra.advancements.art_of_forging.rapier_upgrade.description" | "item.sophisticatedbackpacks.stack_downgrade_tier_3" | "tetra.variant.belt/buckled.description" | "item.sophisticatedbackpacks.stack_downgrade_tier_2" | "subtitles.vortex_hurt1" | "subtitles.vortex_hurt2" | "item.born_in_chaos_v1.pumpkinhead_icon" | "commands.spawnpoint.success.multiple" | "item.born_in_chaos_v1.elixirof_ice_barrier" | "gui.refinedstorage.fluid_amount" | "item.tetra.dragon_sinew.description" | "gui.xaero_map_name" | "mco.gui.ok" | "death.attack.syringe.item" | "inventoryprofiles.config.name.in_rows_custom_rule" | "gui.xaero_sky_light_value" | "fancymenu.background.panorama" | "create.ponder.clockwork_bearing.header" | "tetra/schematic/double/extractor/hone_extractor_4.description" | "fancymenu.helper.editor.items.visibilityrequirements.windowwidth.valuename" | "item.minecraft.spider_eye" | "tetra/schematic/artifact/casing/relic.name" | "commands.clone.toobig" | "item.art_of_forging.potent_mixture" | "effect.bloodmagic.flight.description" | "inventoryprofiles.tooltip.move_all_button.move_matching_only" | "modernui.defaultFontBehavior.keep_other" | "item.minecraft.smithing_template" | "item.quark.ancient_fruit" | "block.quark.andesite_bricks_slab" | "jupiter.screen.current_modifying_dedicate_server" | "item.sophisticatedbackpacks.netherite_backpack" | "fancymenu.custom_guis.manage.edit" | "block.minecraft.banner.diagonal_up_left.blue" | "item.jerotesvillage.explorer_tracked_rocord" | "config.jade.overlay_pos_x_extra_msg" | "ftbquests.reward_table.loot_crate.monster_weight" | "options.difficulty.online" | "watcher_death.sub" | "effect.born_in_chaos_v1.bone_fracture.description" | "effect.divine_weaponry.frosted.description" | "key.refinedstorage.clearGridCraftingMatrix" | "entity.minecraft.villager.shepherd" | "item.jerotesvillage.meror_scythe.desc_3" | "block.minecraft.obsidian" | "item.jerotesvillage.meror_scythe.desc_0" | "attribute.name.horse.jump_strength" | "tetra.module.sword/eerie_fuller.name" | "item.jerotesvillage.meror_scythe.desc_2" | "item.jerotesvillage.meror_scythe.desc_1" | "advancement.dungeons_arise.find_heavenly_rider.desc" | "block.create.cut_crimsite_brick_wall" | "item.minecraft.diamond_boots" | "tetra.workbench.schematic_detail.material_tooltip" | "subtitles.swarmer_death" | "fancymenu.customization.items.text.markdown.quote.indent" | "subtitle.jerotesvillage.dust_moth_ambient" | "entity.born_in_chaos_v1.lifestealer_true_form" | "item.minecraft.acacia_boat" | "item.lendersdelight.witherite_knife" | "config.tooltips_reforged.saturationTooltip" | "fancymenu.editor.action.screens.move_action_up.desc" | "block.biomancy.ornate_flesh_slab" | "tetra.stats.holo.percussionScanner.tooltip" | "item.jerotesvillage.serpon_chariot_item.desc" | "create.ponder.mechanical_pump_speed.text_2" | "create.ponder.mechanical_pump_speed.text_3" | "gui.xaero_category_delete_confirm" | "tetra.tweak.bow/adjustable_strength.left" | "create.ponder.mechanical_pump_speed.text_4" | "create.ponder.mechanical_pump_speed.text_5" | "create.gui.stressometer.title" | "fancymenu.editor.edit.undo" | "create.ponder.mechanical_pump_speed.text_1" | "item.tetra.combustion_chamber.description" | "subtitles.entity.sniffer.step" | "gui.xaero_box_compass_color" | "tetra/schematic/shield/grip/hone_durability_2.name" | "subtitle.jerotesvillage.meror_monstrosity_hurt" | "potion.whenDrank" | "effect.sculkhorde.sculk_infected.description" | "item.quark.music_disc_drips.desc" | "block.legendary_monsters.ancient_dripstone_tile_wall" | "jer.randomAspect.text" | "block.create.cut_o