// priority: 10

//提示
ItemEvents.tooltip(event => {
    for (let item of global.materials) {
        if (item.material) {
            event.add(item.material, Text.red([Text.translate('item.kubejs.tooltips.shift_z_1')]));
            event.add(item.material, Text.red([Text.translate('item.kubejs.tooltips.shift_z_2')]));
        }
    }
});


//ctrl获取提示
ItemEvents.tooltip(event => {
    let itemtooltip = (item, lang) => {
        event.addAdvanced(item, (itemStack, advanced, text) => {
            if (!event.ctrl) {
                //未按下 ctrl 键时显示提示信息
                text.add(1, Text.gold([Text.translate('item.kubejs.tooltips.hold_ctrl')]));
            } else {
                //按下 ctrl 键时显示具体提示信息
                text.add(1, Text.gold([Text.translate(lang)]))
            }
        });
    }
    //萤石
    itemtooltip('minecraft:glowstone_dust', 'tooltop.glowstone_dust');
    itemtooltip('create:blaze_burner', 'blaze_burner')
    itemtooltip('create:empty_blaze_burner', 'empty_blaze_burner');
    itemtooltip('minecraft:blaze_powder', 'blaze_powder');
    itemtooltip('minecraft:blaze_rod', 'blaze_rod');
    itemtooltip('minecraft:netherrack', 'netherrack');
    itemtooltip('minecraft:quartz', 'quartz');
    itemtooltip('minecraft:blackstone', 'blackstone');

    //幻翼锻造模板
    event.add('kubejs:phantom_membrane_upgrade', Text.translatable('tooltop.phantom_membrane_upgrade'));
    //锻造模板
    event.add('minecraft:netherite_upgrade_smithing_template', Text.translatable('tooltop.netherite_upgrade_smithing_template'));
    //遗忘者之帽
    event.add('quark:forgotten_hat', Text.translatable('tooltop.forgotten_hat'));
    //荣耀之证
    event.add('kubejs:rong_yao_zhi_zheng', Text.translatable('ti_shi.rong_yao_zhi_zheng'))
    //绞肉锯
    event.add('cataclysm:meat_shredder', Text.translatable('ti_shi.meat_shredder'))
    //磁盘提示
    event.add('refinedstorage:1k_storage_disk', Text.translatable('tooltop.storage_disk'))
    event.add('refinedstorage:4k_storage_disk', Text.translatable('tooltop.storage_disk'))
    event.add('refinedstorage:16k_storage_disk', Text.translatable('tooltop.storage_disk'))
    event.add('refinedstorage:64k_storage_disk', Text.translatable('tooltop.storage_disk'))
    //饰品/盔甲提示
    //饰品
    event.add('tetra:shou_tao1', Text.translatable('tooltop.curios'))
    event.add('tetra:huang_guan1', Text.translatable('tooltop.curios'))
    event.add('tetra:hu_xin_jing1', Text.translatable('tooltop.curios'))
    event.add('tetra:yuan_chu_wen_chuang1', Text.translatable('tooltop.curios'))
    event.add('tetra:zu_li_jian1', Text.translatable('tooltop.curios'))
    event.add('tetra:biotoxin_bottles', Text.translatable('tooltop.curios'))
    event.add('tetra:ryzz', Text.translatable('tooltop.curios'))
    event.add('tetra:zai_bian_zhi_xin1', Text.translatable('tooltop.curios'))
    event.add('tetra:necklace', Text.translatable('tooltop.curios'))

    //盔甲
    event.add('tetra:helmet', Text.translatable('tooltop.armor'))
    event.add('tetra:chestplate', Text.translatable('tooltop.armor'))
    event.add('tetra:feet', Text.translatable('tooltop.armor'))
    event.add('tetra:legging', Text.translatable('tooltop.armor'))

})

let HoldTime = -1

NativeEvents.onEvent($ItemTooltipEvent, event => {
    if (HoldTime < 1) return
    let item = event.itemStack
    let itemId = item.id
    //获取ftb任务章节的id
    let ftb_id = global.materials.find(material => material.material === itemId)?.ftb_id;
    if (ftb_id) {
        $ClientQuestFile.openGui(
            $ClientQuestFile.INSTANCE.getQuest($Long.parseLong(ftb_id, 16)),
            true
        )
        HoldTime = -1
    }
})

//在背包界面，检测按键
KeyBindEvents.keyPressInGui('ftb_prompt', event => {
    HoldTime++
})

KeyBindEvents.keyReleaseInGui('ftb_prompt', event => {
    HoldTime = -1
})
