/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.tetra_addition.util;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.yiran.tetra_addition.util.IConfigSchematic;
import net.yiran.tetra_addition.util.ISchematicRegistry;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.ConfigSchematic;
import se.mickelus.tetra.module.schematic.OutcomeDefinition;
import se.mickelus.tetra.module.schematic.SchematicDefinition;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class MyTetraUtil {
    public static MyTetraUtil instance = new MyTetraUtil();
    @Nullable
    private Map<String, ConfigSchematic> moduleKey2Schematic;
    @Nullable
    private Set<ConfigSchematic> schematicsSet;

    public Map<ResourceLocation, UpgradeSchematic> getSchematicMap() {
        return ((ISchematicRegistry)SchematicRegistry.instance).getSchematicMap();
    }

    public String getModuleKey(@NotNull ItemStack itemStack, String slot) {
        return itemStack.m_41784_().m_128461_(slot);
    }

    public String getModuleMaterial(@NotNull ItemStack itemStack, String slot) {
        return itemStack.m_41784_().m_128461_(this.getModuleKey(itemStack, slot) + "_material").split("/")[1];
    }

    public int getMaterialCount(@NotNull ItemStack itemStack, String slot) {
        ConfigSchematic schematic = this.getModuleKey2Schematic().get(this.getModuleKey(itemStack, slot));
        if (schematic == null) {
            return 1;
        }
        return ((IConfigSchematic)schematic).getDefinition().outcomes[0].material.count;
    }

    @Info(value="\u7cbe\u51c6\u786e\u5b9aoutcomeItemStack\u7684\u6750\u6599\u6570\u91cf")
    public ItemStack getModuleMaterial(@NotNull ItemStack itemStack, String slot, ItemStack outcomeItemStack) {
        ConfigSchematic schematic = this.getModuleKey2Schematic().get(this.getModuleKey(itemStack, slot));
        if (schematic == null) {
            return ItemStack.f_41583_;
        }
        for (OutcomeDefinition outcome : ((IConfigSchematic)schematic).getDefinition().outcomes) {
            for (ItemStack stack : outcome.material.getApplicableItemStacks()) {
                if (stack.m_41720_() != outcomeItemStack.m_41720_()) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public Map<String, ConfigSchematic> getModuleKey2Schematic() {
        if (this.moduleKey2Schematic == null) {
            return this.getAndUpdateModuleKey2Schematic();
        }
        return this.moduleKey2Schematic;
    }

    @Info(value="\u5f53\u4f60\u4f7f\u7528\u4e86reload\u6307\u4ee4\u4f1a\u5bfc\u81f4Schematic\u91cd\u65b0\u6784\u9020,\u4e8e\u662f\u4fbf\u9700\u8981\u4f7f\u7528\u8fd9\u4e2a\u65b9\u6cd5")
    public Map<String, ConfigSchematic> getAndUpdateModuleKey2Schematic() {
        HashMap<String, ConfigSchematic> moduleKey2Schematic = new HashMap<String, ConfigSchematic>();
        HashSet<ConfigSchematic> schematicsSet = new HashSet<ConfigSchematic>();
        this.getSchematicMap().forEach((k, v) -> {
            if (v instanceof ConfigSchematic) {
                ConfigSchematic configSchematic = (ConfigSchematic)v;
                if (!v.isHoning()) {
                    SchematicDefinition schematicDefinition = ((IConfigSchematic)configSchematic).getDefinition();
                    String moduleKey = schematicDefinition.outcomes[0].moduleKey;
                    if (moduleKey != null) {
                        if (schematicDefinition.keySuffixes.length > 0) {
                            for (String keySuffix : schematicDefinition.keySuffixes) {
                                moduleKey2Schematic.put(moduleKey + keySuffix, configSchematic);
                            }
                        }
                        moduleKey2Schematic.put(moduleKey, configSchematic);
                        schematicsSet.add(configSchematic);
                    }
                }
            }
        });
        this.schematicsSet = schematicsSet;
        this.moduleKey2Schematic = moduleKey2Schematic;
        return moduleKey2Schematic;
    }

    public boolean isSame(ItemStack itemStack, String slot, ConfigSchematic schematic) {
        return this.getModuleKey2Schematic().get(this.getModuleKey(itemStack, slot)) == schematic;
    }

    public boolean isReplace(ConfigSchematic schematic) {
        if (this.schematicsSet == null) {
            this.getAndUpdateModuleKey2Schematic();
        }
        return this.schematicsSet.contains(schematic);
    }
}

