/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.tetra_addition.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.module.ItemModule;

public class ModularItemHelper {
    public static ModularItemHelper INSTANCE = new ModularItemHelper();

    private ModularItem is(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof ModularItem) {
            ModularItem modularItem = (ModularItem)item2;
            return modularItem;
        }
        throw new IllegalArgumentException("item is not a ModularItem");
    }

    public Collection<ItemModule> getAllModules(ItemStack item) {
        return this.is(item).getAllModules(item);
    }

    public int getMagicCapacity(ItemModule module, ItemStack item) {
        return module.getMagicCapacity(item);
    }

    public Map<String, Integer> getAllMagicCapacity(ItemStack item) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (ItemModule module : this.getAllModules(item)) {
            map.put(module.getSlot(), this.getMagicCapacity(module, item));
        }
        return map;
    }

    public Map<ToolAction, Integer> getToolLevels(ItemStack item) {
        return this.is(item).getToolLevels(item);
    }

    public int getToolLevel(ItemStack item, ToolAction toolAction) {
        return this.getToolLevels(item).getOrDefault(toolAction, 0);
    }

    public Map<ItemEffect, Integer> getArmorEffectsLevel(LivingEntity entity) {
        HashMap<ItemEffect, Integer> map = new HashMap<ItemEffect, Integer>();
        for (ItemStack itemStack : entity.m_6168_()) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof ModularItem)) continue;
            ModularItem modularItem = (ModularItem)item;
            for (ItemEffect effect : modularItem.getEffects(itemStack)) {
                map.merge(effect, modularItem.getEffectLevel(itemStack, effect), ArmorEffectLevelMath.getMath(effect));
            }
        }
        return map;
    }

    public static class ArmorEffectLevelMath {
        public static Map<ItemEffect, BiFunction<Integer, Integer, Integer>> MATHS = new HashMap<ItemEffect, BiFunction<Integer, Integer, Integer>>();
        public static BiFunction<Integer, Integer, Integer> DEFAULT = Integer::sum;

        public static BiFunction<Integer, Integer, Integer> getMath(ItemEffect effect) {
            return MATHS.getOrDefault(effect, DEFAULT);
        }

        public static void registerMath(ItemEffect effect, BiFunction<Integer, Integer, Integer> function) {
            MATHS.put(effect, function);
        }
    }
}

