/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.tetra_addition.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.AttributeHelper;

public class YiRanModular
extends ItemModularHandheld
implements Equipable {
    private final GuiModuleOffsets majorOffsets;
    private final GuiModuleOffsets minorOffsets;
    public EquipmentSlot slotType;
    public AttributeMode mode;

    public YiRanModular(Builder builder) {
        super(new Item.Properties().m_41487_(1));
        this.majorModuleKeys = builder.majorModuleKeys.toArray(new String[0]);
        this.majorOffsets = new GuiModuleOffsets(builder.majorOffsets.stream().mapToInt(i -> i).toArray());
        this.minorModuleKeys = builder.minorModuleKeys.toArray(new String[0]);
        this.minorOffsets = new GuiModuleOffsets(builder.minorOffsets.stream().mapToInt(i -> i).toArray());
        this.requiredModules = builder.requiredModules.toArray(new String[0]);
        this.slotType = builder.slotType;
        this.mode = builder.mode;
        this.updateConfig(builder.honeBase, builder.honeMultiplier);
        SchematicRegistry.instance.registerSchematic((UpgradeSchematic)new RepairSchematic((IModularItem)this, builder.identifier));
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (this.isBroken(itemStack) || this.mode == AttributeMode.NONE) {
            return AttributeHelper.emptyMap;
        }
        if (slot == this.slotType) {
            if (this.mode == AttributeMode.TETRA) {
                return this.getAttributeModifiersCached(itemStack);
            }
            if (this.mode == AttributeMode.EFFECT_ARMOR) {
                HashMultimap modifierMultimap = HashMultimap.create();
                int armor = this.getEffectLevel(itemStack, Builder.ARMOR);
                int armor_toughness = this.getEffectLevel(itemStack, Builder.ARMOR_TOUGHNESS);
                if (armor != 0) {
                    modifierMultimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(slot.m_20751_() + "armor", (double)armor, AttributeModifier.Operation.ADDITION));
                }
                if (armor_toughness != 0) {
                    modifierMultimap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(slot.m_20751_() + "armor_toughness", (double)armor_toughness, AttributeModifier.Operation.ADDITION));
                }
                return modifierMultimap;
            }
        }
        return AttributeHelper.emptyMap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets(ItemStack itemStack) {
        return this.majorOffsets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets(ItemStack itemStack) {
        return this.minorOffsets;
    }

    @NotNull
    public EquipmentSlot m_40402_() {
        return this.slotType;
    }

    public static class Builder {
        public static ItemEffect ARMOR_TOUGHNESS = ItemEffect.get((String)"armor_toughness");
        public static ItemEffect ARMOR = ItemEffect.get((String)"armor");
        public String identifier;
        public int honeBase = 200;
        public int honeMultiplier = 1;
        public List<String> majorModuleKeys = new ArrayList<String>();
        public List<String> minorModuleKeys = new ArrayList<String>();
        public List<String> requiredModules = new ArrayList<String>();
        public List<Integer> majorOffsets = new ArrayList<Integer>();
        public List<Integer> minorOffsets = new ArrayList<Integer>();
        public EquipmentSlot slotType = EquipmentSlot.MAINHAND;
        public AttributeMode mode = AttributeMode.TETRA;

        public Builder(String identifier) {
            this.identifier = identifier;
        }

        public Builder honeBase(int honeBase) {
            this.honeBase = honeBase;
            return this;
        }

        public Builder honeMultiplier(int honeMultiplier) {
            this.honeMultiplier = honeMultiplier;
            return this;
        }

        public Builder addMajorModuleKey(String majorModuleKey, int x, int y, boolean required) {
            if (required) {
                this.requiredModules.add(majorModuleKey);
            }
            this.majorModuleKeys.add(majorModuleKey);
            this.majorOffsets.add(x);
            this.majorOffsets.add(y);
            return this;
        }

        public Builder addMajorModuleKey(String majorModuleKey, int x, int y) {
            return this.addMajorModuleKey(majorModuleKey, x, y, false);
        }

        public Builder addMinorModuleKey(String minorModuleKey, int x, int y) {
            this.minorModuleKeys.add(minorModuleKey);
            this.minorOffsets.add(x);
            this.minorOffsets.add(y);
            return this;
        }

        public Builder setSlotType(EquipmentSlot slotType) {
            this.slotType = slotType;
            return this;
        }

        public Builder setAttributeMode(AttributeMode mode) {
            this.mode = mode;
            return this;
        }

        public YiRanModular build() {
            return new YiRanModular(this);
        }
    }

    public static enum AttributeMode {
        TETRA,
        NONE,
        EFFECT_ARMOR;

    }
}

