/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.util;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

public class ThreadManager {
    private static final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.factory.newThread(r);
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }
    });
    private static final ExecutorService gameLogicExecutor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.factory.newThread(r);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setName("GameLogic-" + thread.getId());
            return thread;
        }
    });
    private static final ExecutorService renderExecutor = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2), new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.factory.newThread(r);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setName("Render-" + thread.getId());
            return thread;
        }
    });
    private static final ExecutorService networkExecutor = Executors.newFixedThreadPool(4, new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.factory.newThread(r);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setName("Network-" + thread.getId());
            return thread;
        }
    });
    private static final ExecutorService computeExecutor = Executors.newWorkStealingPool();
    private static volatile boolean enabled = true;
    private static final long MEMORY_CHECK_INTERVAL = 30000L;
    private static final long DISK_CACHE_CHECK_INTERVAL = 60000L;
    private static volatile long lastMemoryCheckTime = 0L;
    private static volatile long lastDiskCacheCheckTime = 0L;
    private static volatile long memoryThreshold = Runtime.getRuntime().maxMemory() * 70L / 100L;
    private static volatile boolean memoryOverloaded = false;

    public static boolean isMemoryOverloaded() {
        return memoryOverloaded;
    }

    public static void submitTask(Runnable task) {
        if (enabled) {
            executor.submit(() -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    ThreadManager.handleThreadException(e);
                }
            });
        } else {
            task.run();
        }
    }

    public static void submitGameLogicTask(Runnable task) {
        if (enabled) {
            gameLogicExecutor.submit(() -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    ThreadManager.handleThreadException(e);
                }
            });
        } else {
            task.run();
        }
    }

    public static void submitRenderTask(Runnable task) {
        if (enabled) {
            renderExecutor.submit(() -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    ThreadManager.handleThreadException(e);
                }
            });
        } else {
            task.run();
        }
    }

    public static void submitNetworkTask(Runnable task) {
        if (enabled) {
            networkExecutor.submit(() -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    ThreadManager.handleThreadException(e);
                }
            });
        } else {
            task.run();
        }
    }

    public static void submitComputeTask(Runnable task) {
        if (enabled) {
            computeExecutor.submit(() -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    ThreadManager.handleThreadException(e);
                }
            });
        } else {
            task.run();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void submitClientTask(Runnable task) {
        ThreadManager.submitTask(task);
    }

    @Environment(value=EnvType.SERVER)
    public static void submitServerTask(Runnable task) {
        ThreadManager.submitTask(task);
    }

    public static void setEnabled(boolean enabled) {
        ThreadManager.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void checkAndCleanDiskCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastDiskCacheCheckTime > 60000L) {
            lastDiskCacheCheckTime = currentTime;
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                File[] tempFiles = tempDir.listFiles();
                if (tempFiles != null) {
                    for (File file : tempFiles) {
                        if (!file.getName().startsWith("mc-") || file.lastModified() >= currentTime - 86400000L) continue;
                        file.delete();
                    }
                }
                System.out.println("The expired disk cache has been cleared");
            }
            catch (Exception e) {
                System.err.println("Disk cache cleanup failed");
                e.printStackTrace();
            }
        }
    }

    public static void checkMemoryUsage() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastMemoryCheckTime > 30000L) {
            lastMemoryCheckTime = currentTime;
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            if (usedMemory > memoryThreshold) {
                memoryOverloaded = true;
                System.gc();
                System.out.println("Warning: Memory usage exceeds the threshold, triggering GC cleanup");
            } else {
                memoryOverloaded = false;
            }
        }
    }

    public static void setMemoryThreshold(int percent) {
        if (percent < 1 || percent > 100) {
            throw new IllegalArgumentException("The memory threshold percentage must be between 1 and 100");
        }
        memoryThreshold = Runtime.getRuntime().maxMemory() * (long)percent / 100L;
    }

    public static String getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        return String.format("\u5185\u5b58\u4f7f\u7528: %.2f/%.2fMB (%.1f%%)", (double)used / 1048576.0, (double)max / 1048576.0, (double)used * 100.0 / (double)max);
    }

    private static void handleThreadException(Exception e) {
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            System.err.println("The client thread task execution is abnormal:");
            e.printStackTrace();
        } else {
            System.err.println("Server thread task execution exception: " + e.getMessage());
        }
    }
}

