/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.optimization;

import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import net.shuyanmc.mpem.config.CoolConfig;

public class MemoryCleaner {
    private long lastCleanTime = 0L;

    public void onServerTick(MinecraftServer server) {
        long interval;
        if (server.method_3724() || server.method_3820() || server.method_16043() || !server.method_24488() || !server.method_3806()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanTime > (interval = (long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get() * 1000))) {
            this.cleanupResources(server);
            this.lastCleanTime = currentTime;
        }
    }

    private void cleanupResources(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (((Boolean)CoolConfig.OPTIMIZE_ENTITY_CLEANUP.get()).booleanValue()) {
            for (class_3218 world : server.method_3738()) {
                world.method_31592().method_31803().forEach(entity -> {
                    if (!entity.method_5805() && entity.field_6008 > 600) {
                        entity.method_31472();
                    }
                });
            }
        }
        if ((long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get()).intValue() > this.lastCleanTime) {
            System.gc();
            this.cleanupResources(server);
            System.out.println("[MPEM] Memory cleaning completed!");
        }
    }
}

