/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.mixin.client;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.shuyanmc.mpem.config.CoolConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_824.class})
public abstract class OptimizedChestRenderer {
    @Inject(method={"get"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends class_2586> void handleRendering(E entity, CallbackInfoReturnable<class_827<E>> cir) {
        if (!((Boolean)CoolConfig.ENABLE_OPTIMIZATION.get()).booleanValue() || entity == null || entity.method_10997() == null || entity.method_11015()) {
            return;
        }
        boolean isChest = entity instanceof class_2595;
        boolean isEnderChest = entity instanceof class_2611;
        if (!isChest && !isEnderChest) {
            return;
        }
        if (isChest && !((Boolean)CoolConfig.ENABLE_OPTIMIZATION.get()).booleanValue()) {
            return;
        }
        if (isEnderChest && !((Boolean)CoolConfig.OPTIMIZE_ENDER_CHESTS.get()).booleanValue()) {
            return;
        }
        try {
            class_2338 pos = entity.method_11016();
            class_1937 level = entity.method_10997();
            if (level == null || pos == null) {
                this.logDebug("Invalid level or position for chest at " + pos);
                return;
            }
            class_1657 player = this.getNearestPlayerSafely(level, pos);
            if (player == null) {
                cir.setReturnValue(null);
                return;
            }
            if (this.isBeyondRenderDistance(pos, player.method_24515())) {
                cir.setReturnValue(null);
                this.logDebug("Skipped distant chest at " + pos);
            }
        }
        catch (Exception e) {
            this.logDebug("Error optimizing chest: " + e.getMessage());
        }
    }

    private class_1657 getNearestPlayerSafely(class_1937 level, class_2338 pos) {
        try {
            return level.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)((Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16), false);
        }
        catch (Exception e) {
            this.logDebug("Player detection failed: " + e.getMessage());
            return null;
        }
    }

    private boolean isBeyondRenderDistance(class_2338 pos, class_2338 playerPos) {
        double maxDistance = (Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16;
        return pos.method_10262((class_2382)playerPos) > maxDistance * maxDistance;
    }

    private void logDebug(String message) {
        if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
            System.out.println("[MPEM] " + message);
        }
    }
}

