/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.mixin;

import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.shuyanmc.mpem.config.CoolConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    @Unique
    private int lastMergeTick = -1;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        class_1542 self = (class_1542)this;
        if (self.method_37908().field_9236) {
            return;
        }
        this.updateStackDisplay(self);
        long gameTime = self.method_37908().method_8510();
        if (this.lastMergeTick == -1 || gameTime - (long)this.lastMergeTick >= 5L) {
            this.lastMergeTick = (int)gameTime;
            this.tryMergeItems(self);
        }
    }

    @Unique
    private void tryMergeItems(class_1542 self) {
        int maxStack;
        double mergeDistance = (Double)CoolConfig.mergeDistance.get();
        int configMaxStack = (Integer)CoolConfig.maxStackSize.get();
        int listMode = (Integer)CoolConfig.listMode.get();
        List itemList = (List)CoolConfig.itemList.get();
        if (!this.isMergeAllowed(self.method_6983(), listMode, itemList)) {
            return;
        }
        class_1799 stack = self.method_6983();
        int n = maxStack = configMaxStack > 0 ? configMaxStack : 2147483547;
        if (stack.method_7947() >= maxStack) {
            return;
        }
        List nearby = self.method_37908().method_8390(class_1542.class, self.method_5829().method_1014(mergeDistance), e -> this.isValidMergeTarget(self, (class_1542)e, listMode, itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((class_1542)self).method_5858(arg_0)));
        int remainingSpace = maxStack - stack.method_7947();
        for (class_1542 other : nearby) {
            if (remainingSpace <= 0) break;
            class_1799 otherStack = other.method_6983();
            int transfer = Math.min(otherStack.method_7947(), remainingSpace);
            stack.method_7933(transfer);
            self.method_6979(stack);
            self.method_6975();
            if (otherStack.method_7947() == transfer) {
                other.method_31472();
            } else {
                otherStack.method_7934(transfer);
                other.method_6979(otherStack);
                ((ItemEntityMixin)other).updateStackDisplay(other);
            }
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void updateStackDisplay(class_1542 entity) {
        if (!((Boolean)CoolConfig.showStackCount.get()).booleanValue()) {
            entity.method_5665(null);
            entity.method_5880(false);
            return;
        }
        class_1799 stack = entity.method_6983();
        if (stack.method_7947() > 1) {
            class_5250 countText = class_2561.method_43470((String)("\u00d7" + stack.method_7947())).method_27692(class_124.field_1077).method_27692(class_124.field_1067);
            entity.method_5665((class_2561)countText);
            entity.method_5880(true);
        } else {
            entity.method_5665(null);
            entity.method_5880(false);
        }
    }

    @Unique
    private boolean isValidMergeTarget(class_1542 self, class_1542 other, int listMode, List<? extends String> itemList) {
        return self != other && !other.method_31481() && this.isSameItem(self.method_6983(), other.method_6983()) && this.isMergeAllowed(other.method_6983(), listMode, itemList);
    }

    @Unique
    private boolean isSameItem(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    @Unique
    private boolean isMergeAllowed(class_1799 stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (id == null) {
            return false;
        }
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 ? inList : !inList;
    }
}

