/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.engine;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.shuyanmc.mpem.config.CoolConfig;
import org.apache.logging.log4j.LogManager;

public final class RenderOptimizer {
    private static final ExecutorService RT_POOL = Executors.newFixedThreadPool(Math.min(4, Runtime.getRuntime().availableProcessors()));
    private static int cullingDepth = 2;
    private static float rejectionRate = 0.15f;
    private static boolean enabled = true;
    public static boolean transparencyCheck = true;

    public static void init() {
        RenderOptimizer.updateConfig();
    }

    public static void updateConfig() {
        enabled = CoolConfig.isEnabled();
        cullingDepth = Math.max(1, CoolConfig.getCullingDepth());
        rejectionRate = Math.max(0.0f, Math.min(1.0f, CoolConfig.getRejectionRate()));
        transparencyCheck = CoolConfig.isTransparencyCheck();
    }

    public static CompletableFuture<Boolean> isVisibleAsync(class_243 start, class_243 end, class_1922 level) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return RenderOptimizer.traceVisibility(start, end, level);
            }
            catch (Exception e) {
                LogManager.getLogger().error("Error in async visibility check", (Throwable)e);
                return true;
            }
        }, RT_POOL);
    }

    private static boolean traceVisibility(class_243 start, class_243 end, class_1922 level) {
        try {
            class_243 direction = end.method_1020(start);
            double distance = direction.method_1033();
            if (distance < 0.001) {
                return true;
            }
            direction = direction.method_1029();
            double stepSize = 0.25;
            int steps = (int)(distance / stepSize);
            class_243 current = new class_243(start.field_1352, start.field_1351, start.field_1350);
            class_2338.class_2339 mpos = new class_2338.class_2339();
            for (int i = 0; i < steps; ++i) {
                current = current.method_1019(direction.method_1021(stepSize));
                mpos.method_10102(current.field_1352, current.field_1351, current.field_1350);
                class_2680 state = level.method_8320((class_2338)mpos);
                if (state.method_26215()) continue;
                if (state.method_26220(level, (class_2338)mpos).method_1110()) {
                    if (!RenderOptimizer.isSemiTransparent(state, level, (class_2338)mpos)) continue;
                    return false;
                }
                if (RenderOptimizer.isSemiTransparent(state, level, (class_2338)mpos)) {
                    try {
                        class_238 aabb = state.method_26220(level, (class_2338)mpos).method_1107().method_996((class_2338)mpos);
                        if (!aabb.method_1006(current)) continue;
                        return false;
                    }
                    catch (Exception e) {
                        LogManager.getLogger().warn("Error checking Box for block {}", (Object)state.method_26204(), (Object)e);
                        return false;
                    }
                }
                if (!state.method_26225()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LogManager.getLogger().error("Error in traceVisibility", (Throwable)e);
            return true;
        }
    }

    public static boolean shouldSkipEntity(class_1297 entity) {
        if (!enabled) {
            return false;
        }
        try {
            class_243 eyePos = class_310.method_1551().field_1773.method_19418().method_19326();
            class_243 entityPos = entity.method_19538().method_1031(0.0, (double)(entity.method_49476() / 2.0f), 0.0);
            return !RenderOptimizer.traceVisibilitySync(eyePos, entityPos, (class_1922)entity.method_37908());
        }
        catch (Exception e) {
            LogManager.getLogger().error("Error in entity visibility check", (Throwable)e);
            return false;
        }
    }

    public static boolean traceVisibilitySync(class_243 start, class_243 end, class_1922 level) {
        return RenderOptimizer.traceVisibility(start, end, level);
    }

    public static boolean shouldCullFaceRT(class_1922 level, class_2338 pos, class_2350 face) {
        if (!enabled) {
            return false;
        }
        try {
            class_243 end;
            class_2680 adjacentState = level.method_8320(pos.method_10093(face));
            if (adjacentState.method_26215() || RenderOptimizer.isSemiTransparent(adjacentState, level, pos.method_10093(face))) {
                return false;
            }
            class_243 start = new class_243((double)pos.method_10263() + 0.5 + (double)face.method_10148() * 0.501, (double)pos.method_10264() + 0.5 + (double)face.method_10164() * 0.501, (double)pos.method_10260() + 0.5 + (double)face.method_10165() * 0.501);
            return !RenderOptimizer.traceVisibility(start, end = start.method_1019(new class_243((double)(face.method_10148() * cullingDepth), (double)(face.method_10164() * cullingDepth), (double)(face.method_10165() * cullingDepth))), level);
        }
        catch (Exception e) {
            LogManager.getLogger().error("Error in face culling", (Throwable)e);
            return false;
        }
    }

    private static boolean isSemiTransparent(class_2680 state, class_1922 level, class_2338 pos) {
        try {
            if (state.method_26164(class_3481.field_15503)) {
                return true;
            }
            if (state.method_26204() instanceof class_2397) {
                return true;
            }
            String path = ((class_5321)class_7923.field_41175.method_29113((Object)state.method_26204()).get()).method_29177().method_12832();
            return path.contains("glass") || path.contains("ice") || !state.method_26225() || state.method_26210(level, pos) < 15.0f;
        }
        catch (Exception e) {
            LogManager.getLogger().warn("Error checking transparency for block {}", (Object)state.method_26204(), (Object)e);
            return true;
        }
    }
}

