/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.engine;

import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public final class LeafOptiEngine {
    private static boolean initialized = false;
    private static int[][] directionOffsets;

    public static void initialize() {
        if (initialized) {
            return;
        }
        directionOffsets = new int[26][3];
        int index = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    LeafOptiEngine.directionOffsets[index++] = new int[]{x, y, z};
                }
            }
        }
        initialized = true;
    }

    public static boolean shouldCullFace(class_1922 level, class_2338 pos, class_2350 face, Predicate<class_2248> blockPred, int depth, float rejectionRate) {
        if (depth <= 0 || rejectionRate < 0.0f) {
            return false;
        }
        class_2338 adjacentPos = pos.method_10093(face);
        if (!blockPred.test(level.method_8320(adjacentPos).method_26204())) {
            return false;
        }
        long spatialHash = LeafOptiEngine.calculateSpatialHash(pos);
        if (rejectionRate > 0.0f && (float)(spatialHash % 100L) < rejectionRate * 100.0f) {
            return true;
        }
        return LeafOptiEngine.analyzeNeighborhood(level, pos.method_10093(face), face, blockPred, depth - 1, spatialHash);
    }

    private static long calculateSpatialHash(class_2338 pos) {
        long x = (long)pos.method_10263() * 731881375L;
        long z = (long)pos.method_10260() * 8369621L;
        long y = pos.method_10264();
        return (x ^ z ^ y) & 0xFFFFFFFFFL;
    }

    private static boolean analyzeNeighborhood(class_1922 level, class_2338 pos, class_2350 face, Predicate<class_2248> blockPred, int depth, long spatialHash) {
        class_2338.class_2339 mpos = new class_2338.class_2339();
        int[] dirVec = new int[]{face.method_10148(), face.method_10164(), face.method_10165()};
        for (int i = 1; i <= depth; ++i) {
            mpos.method_10103(pos.method_10263() + dirVec[0] * i, pos.method_10264() + dirVec[1] * i, pos.method_10260() + dirVec[2] * i);
            class_2680 state = level.method_8320((class_2338)mpos);
            if (!blockPred.test(state.method_26204())) {
                if (i != 1 && (spatialHash & 0xFL) >= 3L) break;
                return false;
            }
            if (i != depth) continue;
            return true;
        }
        return spatialHash % 16L < 2L;
    }
}

