/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.engine;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public final class AsyncTracer {
    private static final ExecutorService TRACER_POOL = Executors.newWorkStealingPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 2));
    private static final ScheduledExecutorService TIMEOUT_CHECKER = Executors.newSingleThreadScheduledExecutor();

    public static CompletableFuture<Boolean> traceAsync(class_243 start, class_243 end, class_1922 level) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Future<?> task = TRACER_POOL.submit(() -> {
            try {
                future.complete(AsyncTracer.traceVisibility(start, end, level));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        TIMEOUT_CHECKER.schedule(() -> {
            if (!future.isDone()) {
                task.cancel(true);
                future.complete(false);
            }
        }, 1L, TimeUnit.MINUTES);
        return future;
    }

    private static boolean traceVisibility(class_243 start, class_243 end, class_1922 level) {
        class_243 dir = end.method_1020(start);
        double dist = dir.method_1033();
        if (dist < 0.001) {
            return true;
        }
        dir = dir.method_1029();
        double step = Math.min(0.5, dist / 10.0);
        class_243 current = start;
        class_2338.class_2339 mpos = new class_2338.class_2339();
        while (current.method_1022(start) < dist) {
            class_265 shape;
            if (Thread.interrupted()) {
                return false;
            }
            mpos.method_10102(current.field_1352, current.field_1351, current.field_1350);
            class_2680 state = level.method_8320((class_2338)mpos);
            if (!state.method_26215() && !(shape = state.method_26220(level, (class_2338)mpos)).method_1110() && shape.method_1107().method_996((class_2338)mpos).method_1006(current)) {
                return false;
            }
            current = current.method_1019(dir.method_1021(step));
        }
        return true;
    }

    public static void shutdown() {
        TRACER_POOL.shutdownNow();
        TIMEOUT_CHECKER.shutdownNow();
    }
}

