/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.shuyanmc.mpem.engine.RenderOptimizer;

public class CoolConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue disableEntityCollisions;
    public static ForgeConfigSpec.BooleanValue optimizeEntityAI;
    public static ForgeConfigSpec.IntValue entityActivationRange;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENTITY_CLEANUP;
    public static final ForgeConfigSpec.BooleanValue reduceEntityUpdates;
    public static ForgeConfigSpec.IntValue maxStackSize;
    public static ForgeConfigSpec.DoubleValue mergeDistance;
    public static ForgeConfigSpec.IntValue listMode;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemList;
    public static ForgeConfigSpec.BooleanValue showStackCount;
    public static final ForgeConfigSpec.BooleanValue ENABLED;
    public static final ForgeConfigSpec.IntValue MAX_STACK_SIZE;
    public static final ForgeConfigSpec.IntValue MEMORY_CLEAN_INTERVAL;
    public static final ForgeConfigSpec.BooleanValue ENABLE_GC;
    public static final ForgeConfigSpec.BooleanValue DEBUG_LOGGING;
    public static final ForgeConfigSpec.BooleanValue LOG_BLOCK_EVENTS;
    public static ForgeConfigSpec.BooleanValue aggressiveChunkUnloading;
    public static ForgeConfigSpec.IntValue chunkUnloadDelay;
    public static final ForgeConfigSpec.BooleanValue reduceChunkUpdates;
    public static final ForgeConfigSpec.BooleanValue filterRedundantBlockUpdates;
    public static final ForgeConfigSpec.IntValue CHUNK_GEN_THREADS;
    public static final ForgeConfigSpec.BooleanValue block_no_render_when_no_air;
    public static final ForgeConfigSpec.BooleanValue ASYNC_PARTICLES;
    public static final ForgeConfigSpec.IntValue MAX_ASYNC_OPERATIONS_PER_TICK;
    public static final ForgeConfigSpec.BooleanValue DISABLE_ASYNC_ON_ERROR;
    public static final ForgeConfigSpec.IntValue ASYNC_EVENT_TIMEOUT;
    public static final ForgeConfigSpec.BooleanValue WAIT_FOR_ASYNC_EVENTS;
    public static ForgeConfigSpec.IntValue maxCPUPro;
    public static ForgeConfigSpec.IntValue maxthreads;
    public static ForgeConfigSpec.BooleanValue FEATURE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ASYNC_EVENT_CLASS_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ASYNC_EVENT_MOD_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue STRICT_CLASS_CHECKING;
    public static final ForgeConfigSpec.IntValue ENTITY_LOAD_BATCH_SIZE;
    public static final ForgeConfigSpec.IntValue TILE_ENTITY_LOAD_BATCH_SIZE;
    public static final ForgeConfigSpec.IntValue MIN_TICK_INTERVAL;
    public static final ForgeConfigSpec.IntValue MAX_TICK_INTERVAL;
    public static final ForgeConfigSpec.DoubleValue TPS_ADJUST_THRESHOLD;
    public static ForgeConfigSpec.BooleanValue optimizeEntities;
    public static ForgeConfigSpec.IntValue horizontalRange;
    public static ForgeConfigSpec.IntValue verticalRange;
    public static ForgeConfigSpec.BooleanValue ignoreDeadEntities;
    public static ForgeConfigSpec.BooleanValue optimizeItems;
    public static ForgeConfigSpec.BooleanValue tickRaidersInRaid;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionWhitelist;
    public static ForgeConfigSpec.BooleanValue sendLoginMessage;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> entityWhitelist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> entityModWhitelist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> raidEntityWhitelist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemWhitelist;
    public static ForgeConfigSpec.BooleanValue REDUCE_FPS_WHEN_INACTIVE;
    public static ForgeConfigSpec.IntValue INACTIVE_FPS_LIMIT;
    public static ForgeConfigSpec.BooleanValue REDUCE_RENDER_DISTANCE_WHEN_INACTIVE;
    public static ForgeConfigSpec.IntValue INACTIVE_RENDER_DISTANCE;
    public static ForgeConfigSpec.BooleanValue reloadResourcesAsync;
    public static final ForgeConfigSpec.BooleanValue FORCE_METAL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLEDCULL;
    public static final ForgeConfigSpec.ConfigValue<Integer> CULLING_DEPTH;
    public static final ForgeConfigSpec.ConfigValue<Double> REJECTION_RATE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_MANGROVE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_OPTIMIZATION;
    public static final ForgeConfigSpec.EnumValue<RenderMode> RENDER_MODE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENDER_CHESTS;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_TRAPPED_CHESTS;
    public static final ForgeConfigSpec.IntValue MAX_RENDER_DISTANCE;
    public static final ForgeConfigSpec.BooleanValue ULTRA_CULLING;
    public static final ForgeConfigSpec.IntValue ULTRA_DEPTH;
    public static final ForgeConfigSpec.DoubleValue ULTRA_BACKFACE;
    public static final ForgeConfigSpec.BooleanValue ADVANCED_CULLING;
    public static ForgeConfigSpec.BooleanValue useAsyncTracing;
    public static ForgeConfigSpec.IntValue tracingThreads;
    public static ForgeConfigSpec.DoubleValue traceDistance;
    public static ForgeConfigSpec.DoubleValue fallbackDistance;
    private static Consumer<Void> changeListener;

    public static void onChange(Consumer<Void> listener) {
        changeListener = listener;
    }

    public static Set<String> getAsyncEventClassBlacklist() {
        return new HashSet<String>((Collection)ASYNC_EVENT_CLASS_BLACKLIST.get());
    }

    public static boolean isEnabled() {
        return (Boolean)FEATURE_ENABLED.get();
    }

    public static Set<String> getAsyncEventModBlacklist() {
        return new HashSet<String>((Collection)ASYNC_EVENT_MOD_BLACKLIST.get());
    }

    public static boolean isStrictClassCheckingEnabled() {
        return (Boolean)STRICT_CLASS_CHECKING.get();
    }

    public static int getCullingDepth() {
        return (Integer)CULLING_DEPTH.get();
    }

    public static boolean useUltraCulling() {
        return (Boolean)ULTRA_CULLING.get();
    }

    public static int ultraCullingDepth() {
        return (Integer)ULTRA_DEPTH.get();
    }

    public static double ultraBackfaceThreshold() {
        return (Double)ULTRA_BACKFACE.get();
    }

    public static float getRejectionRate() {
        return ((Double)REJECTION_RATE.get()).floatValue();
    }

    public static boolean optimizeMangrove() {
        return (Boolean)OPTIMIZE_MANGROVE.get();
    }

    public static boolean isTransparencyCheck() {
        return RenderOptimizer.transparencyCheck;
    }

    public static boolean useAdvancedCulling() {
        return (Boolean)ADVANCED_CULLING.get();
    }

    public static boolean forceMetal() {
        return (Boolean)FORCE_METAL.get();
    }

    public static void resetToDefault() {
        ForgeConfigSpec newSpec;
        SPEC = newSpec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            new CoolConfig();
            return builder.build();
        }).getRight();
        newSpec.save();
    }

    public static boolean useAsyncTracing() {
        return (Boolean)useAsyncTracing.get();
    }

    public static double getTraceDistance() {
        return (Double)traceDistance.get();
    }

    static {
        block_no_render_when_no_air = BUILDER.define("black_no_render_no_air", true);
        BUILDER.push("Metal Renderer Configuration");
        FORCE_METAL = BUILDER.comment("Force Metal renderer even on non-Mac systems").define("forceMetal", false);
        BUILDER.pop();
        BUILDER.push("chest_optimization");
        ENABLE_OPTIMIZATION = BUILDER.comment("Enable chest rendering optimization").define("enableOptimization", true);
        RENDER_MODE = BUILDER.comment("Rendering mode").defineEnum("renderMode", (Enum)RenderMode.SIMPLE);
        OPTIMIZE_ENDER_CHESTS = BUILDER.comment("Optimize ender chests").define("optimizeEnderChests", true);
        OPTIMIZE_TRAPPED_CHESTS = BUILDER.comment("Optimize trapped chests").define("optimizeTrappedChests", false);
        MAX_RENDER_DISTANCE = BUILDER.comment("Max render distance in chunks").defineInRange("maxRenderDistance", 32, 1, 128);
        BUILDER.pop();
        BUILDER.push("Renderer Configuration");
        BUILDER.push("Ultra Culling");
        ULTRA_CULLING = BUILDER.comment("\u542f\u7528\u8d85\u6fc0\u8fdb\u5254\u9664\uff08\u5bf9\u6240\u6709\u65b9\u5757/\u5b9e\u4f53\u751f\u6548\uff09").define("ultraCulling", true);
        ULTRA_DEPTH = BUILDER.comment(new String[]{"\u5254\u9664\u6df1\u5ea6\uff081-4\uff09", "\u8d8a\u5927\u5254\u9664\u8d8a\u6fc0\u8fdb\uff0c\u4f46\u53ef\u80fd\u51fa\u73b0bug"}).defineInRange("ultraDepth", 3, 1, 4);
        ULTRA_BACKFACE = BUILDER.comment("\u4ec5\u5254\u9664\u80cc\u5411\u73a9\u5bb6\u7684\u9762\uff08\u9632\u6b62\u6b63\u9762nothing\uff09").defineInRange("ultraBackfaceOnly", 0.95, 0.0, 1.0);
        BUILDER.pop();
        ENABLEDCULL = BUILDER.comment("Enable leaf rendering optimizations").define("enabled", true);
        CULLING_DEPTH = BUILDER.comment(new String[]{"Culling depth (1-5)", "Higher values = better performance but may cause visual artifacts"}).defineInRange("cullingDepth", 3, 1, 5);
        REJECTION_RATE = BUILDER.comment(new String[]{"Random rejection rate (0.0-1.0)", "Prevents visible culling patterns"}).defineInRange("rejectionRate", 0.15, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Advanced Features");
        OPTIMIZE_MANGROVE = BUILDER.comment("Enable mangrove roots optimization").define("optimizeMangrove", true);
        ADVANCED_CULLING = BUILDER.comment(new String[]{"Use advanced culling algorithm", "More precise but slightly slower"}).define("advancedCulling", true);
        BUILDER.pop();
        BUILDER.push("\u8def\u5f84\u8ffd\u8e2a | Path Tracing");
        useAsyncTracing = BUILDER.comment(new String[]{"\u542f\u7528\u5f02\u6b65\u8def\u5f84\u8ffd\u8e2a\u8fdb\u884c\u5254\u9664", "Enable async path tracing for culling"}).define("asyncTracing", true);
        tracingThreads = BUILDER.comment(new String[]{"\u8def\u5f84\u8ffd\u8e2a\u7ebf\u7a0b\u6570 (1-8)", "Number of threads for path tracing (1-8)"}).defineInRange("tracingThreads", 2, 1, 8);
        traceDistance = BUILDER.comment(new String[]{"\u6700\u5927\u8ffd\u8e2a\u8ddd\u79bb\uff08\u65b9\u5757\uff09", "Max tracing distance in blocks"}).defineInRange("traceDistance", 6.0, 1.0, 16.0);
        fallbackDistance = BUILDER.comment(new String[]{"\u56de\u9000\u7b80\u5355\u5254\u9664\u8ddd\u79bb\uff08\u65b9\u5757\uff09", "Fallback simple culling distance in blocks"}).defineInRange("fallbackDistance", 16.0, 4.0, 32.0);
        BUILDER.pop();
        BUILDER.push("FPS Settings");
        REDUCE_FPS_WHEN_INACTIVE = BUILDER.comment("Enable FPS reduction when window is inactive").define("reduceFpsWhenInactive", true);
        INACTIVE_FPS_LIMIT = BUILDER.comment("FPS limit when window is inactive (5-60)").defineInRange("inactiveFpsLimit", 10, 5, 60);
        REDUCE_RENDER_DISTANCE_WHEN_INACTIVE = BUILDER.comment("Enable render distance reduction when window is inactive").define("reduceRenderDistanceWhenInactive", true);
        INACTIVE_RENDER_DISTANCE = BUILDER.comment("Render distance when window is inactive (2-12)").defineInRange("inactiveRenderDistance", 2, 2, 12);
        BUILDER.pop();
        BUILDER.push("\u5b9e\u4f53\u4f18\u5316");
        optimizeEntities = BUILDER.comment("\u542f\u7528\u5b9e\u4f53tick\u4f18\u5316").define("enable", true);
        horizontalRange = BUILDER.comment("\u6c34\u5e73\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)").defineInRange("horizontalRange", 64, 1, 256);
        verticalRange = BUILDER.comment("\u5782\u76f4\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)").defineInRange("verticalRange", 32, 1, 256);
        ignoreDeadEntities = BUILDER.comment("\u5ffd\u7565\u5df2\u6b7b\u4ea1\u7684\u5b9e\u4f53").define("ignoreDead", false);
        BUILDER.pop();
        BUILDER.push("\u7269\u54c1\u5b9e\u4f53");
        optimizeItems = BUILDER.comment("\u4f18\u5316\u7269\u54c1\u5b9e\u4f53tick").define("enable", false);
        BUILDER.pop();
        BUILDER.push("\u88ad\u51fb\u4e8b\u4ef6");
        tickRaidersInRaid = BUILDER.comment("\u5728\u88ad\u51fb\u4e2d\u4fdd\u6301\u88ad\u51fb\u8005tick").define("enable", true);
        BUILDER.pop();
        BUILDER.push("Entities");
        optimizeEntities = BUILDER.define("optimizeEntities", true);
        horizontalRange = BUILDER.defineInRange("horizontalRange", 64, 1, 256);
        verticalRange = BUILDER.defineInRange("verticalRange", 32, 1, 256);
        ignoreDeadEntities = BUILDER.define("ignoreDeadEntities", false);
        entityWhitelist = BUILDER.defineList("entityWhitelist", List.of("minecraft:ender_dragon"), o -> true);
        entityModWhitelist = BUILDER.defineList("entityModWhitelist", List.of("create"), o -> true);
        tickRaidersInRaid = BUILDER.define("tickRaidersInRaid", true);
        raidEntityWhitelist = BUILDER.defineList("raidEntityWhitelist", List.of("minecraft:witch"), o -> true);
        BUILDER.pop();
        BUILDER.push("Items");
        optimizeItems = BUILDER.define("optimizeItems", false);
        itemWhitelist = BUILDER.defineList("itemWhitelist", List.of("minecraft:diamond"), o -> true);
        BUILDER.pop();
        BUILDER.push("Messages");
        sendLoginMessage = BUILDER.define("sendLoginMessage", true);
        BUILDER.pop();
        BUILDER.push("Progressive Entity Loading Settings");
        ENTITY_LOAD_BATCH_SIZE = BUILDER.comment("Number of entities to load per tick").defineInRange("entityLoadBatchSize", 10, 1, 100);
        TILE_ENTITY_LOAD_BATCH_SIZE = BUILDER.comment("Number of tile entities to load per tick").defineInRange("tileEntityLoadBatchSize", 5, 1, 50);
        MIN_TICK_INTERVAL = BUILDER.comment("Minimum tick interval (ms) between entity updates").defineInRange("minTickInterval", 10, 1, 100);
        MAX_TICK_INTERVAL = BUILDER.comment("Maximum tick interval (ms) between entity updates").defineInRange("maxTickInterval", 100, 10, 1000);
        TPS_ADJUST_THRESHOLD = BUILDER.comment("TPS threshold for adjusting tick rate (percentage of 20)").defineInRange("tpsAdjustThreshold", 0.85, 0.1, 1.0);
        BUILDER.pop();
        BUILDER.comment("\u5b9e\u4f53\u4f18\u5316\u8bbe\u7f6e | Entity Optimization Settings").push("entity_optimization");
        disableEntityCollisions = BUILDER.comment("\u4f18\u5316\u5b9e\u4f53\u78b0\u649e\u68c0\u6d4b | Optimize entity collision detection").define("disableEntityCollisions", true);
        optimizeEntityAI = BUILDER.comment("\u4f18\u5316\u5b9e\u4f53AI\u8ba1\u7b97 | Optimize entity AI calculations").define("optimizeEntityAI", true);
        entityActivationRange = BUILDER.comment("\u5b9e\u4f53\u6fc0\u6d3b\u8303\u56f4 (\u65b9\u5757) | Entity activation range (blocks)").defineInRange("entityActivationRange", 32, 16, 128);
        OPTIMIZE_ENTITY_CLEANUP = BUILDER.comment("\u542f\u7528\u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406 | Enable dead entity cleanup").define("entityCleanup", true);
        reduceEntityUpdates = BUILDER.comment("\u51cf\u5c11\u8fdc\u5904\u5b9e\u4f53\u7684\u540c\u6b65\u9891\u7387 | Reduce entity sync frequency for distant entities").define("reduceEntityUpdates", true);
        BUILDER.pop();
        BUILDER.comment("\u7269\u54c1\u4f18\u5316\u8bbe\u7f6e | Item Optimization Settings").push("item_optimization");
        maxStackSize = BUILDER.comment("\u5408\u5e76\u7269\u54c1\u7684\u6700\u5927\u5806\u53e0\u6570\u91cf\uff080\u8868\u793a\u65e0\u9650\u5236,-1 \u8868 \u539f\u7248\u903b\u8f91\uff09| Maximum stack size for merged items (0 = no limit)").defineInRange("maxStackSize", -1, -1, Integer.MAX_VALUE);
        mergeDistance = BUILDER.comment("\u7269\u54c1\u5408\u5e76\u68c0\u6d4b\u534a\u5f84\uff08\u5355\u4f4d\uff1a\u65b9\u5757\uff09| Item merge detection radius in blocks").defineInRange("mergeDistance", 0.5, 0.1, 10.0);
        listMode = BUILDER.comment("0: \u7981\u7528 1: \u767d\u540d\u5355\u6a21\u5f0f 2: \u9ed1\u540d\u5355\u6a21\u5f0f | 0: Disabled, 1: Whitelist, 2: Blacklist").defineInRange("listMode", 0, 0, 2);
        itemList = BUILDER.comment("\u767d\u540d\u5355/\u9ed1\u540d\u5355\u4e2d\u7684\u7269\u54c1\u6ce8\u518c\u540d\u5217\u8868 | Item registry names for whitelist/blacklist").defineList("itemList", Collections.emptyList(), o -> o instanceof String);
        showStackCount = BUILDER.comment("\u662f\u5426\u5728\u5408\u5e76\u540e\u7684\u7269\u54c1\u4e0a\u663e\u793a\u5806\u53e0\u6570\u91cf | Whether to show stack count on merged items").define("showStackCount", true);
        BUILDER.push("stack_size");
        ENABLED = BUILDER.comment("\u542f\u7528\u81ea\u5b9a\u4e49\u5806\u53e0\u5927\u5c0f | Enable custom stack sizes").define("enabled", true);
        MAX_STACK_SIZE = BUILDER.comment("\u6700\u5927\u7269\u54c1\u5806\u53e0\u5927\u5c0f (1-9999) | Maximum item stack size (1-9999)").defineInRange("maxStackSize", 64, 1, 9999);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u5185\u5b58\u4f18\u5316\u8bbe\u7f6e | Memory Optimization Settings").push("memory_optimization");
        MEMORY_CLEAN_INTERVAL = BUILDER.comment("\u5185\u5b58\u6e05\u7406\u95f4\u9694(\u79d2) | Memory cleanup interval (seconds)").defineInRange("cleanInterval", 600, 60, 3600);
        ENABLE_GC = BUILDER.comment("\u662f\u5426\u5728\u6e05\u7406\u65f6\u89e6\u53d1\u5783\u573e\u56de\u6536 | Whether to trigger garbage collection during cleanup").define("enableGC", false);
        BUILDER.pop();
        BUILDER.comment("\u8c03\u8bd5\u8bbe\u7f6e | Debug Settings").push("debug");
        DEBUG_LOGGING = BUILDER.comment("\u542f\u7528\u8c03\u8bd5\u65e5\u5fd7 | Enable debug logging").define("debug", false);
        LOG_BLOCK_EVENTS = BUILDER.comment("\u8bb0\u5f55\u65b9\u5757\u76f8\u5173\u4e8b\u4ef6 | Log block related events").define("logBlockEvents", false);
        BUILDER.pop();
        BUILDER.comment("\u533a\u5757\u4f18\u5316\u8bbe\u7f6e | Chunk Optimization Settings").push("chunk_optimization");
        aggressiveChunkUnloading = BUILDER.comment("\u4e3b\u52a8\u5378\u8f7d\u975e\u6d3b\u52a8\u533a\u5757 | Aggressively unload inactive chunks").define("aggressiveChunkUnloading", true);
        chunkUnloadDelay = BUILDER.comment("\u533a\u5757\u5378\u8f7d\u5ef6\u8fdf (\u79d2) | Chunk unload delay (seconds)").defineInRange("chunkUnloadDelay", 60, 10, 600);
        reduceChunkUpdates = BUILDER.comment("\u5f53\u73a9\u5bb6\u79fb\u52a8\u77ed\u8ddd\u79bb\u65f6\u51cf\u5c11\u533a\u5757\u66f4\u65b0\u9891\u7387 | Reduce chunk update frequency when player moves short distances").define("reduceChunkUpdates", true);
        filterRedundantBlockUpdates = BUILDER.comment("\u8fc7\u6ee4\u5197\u4f59\u7684\u65b9\u5757\u66f4\u65b0\u6570\u636e\u5305 | Filter redundant block update packets").define("filterRedundantBlockUpdates", true);
        CHUNK_GEN_THREADS = BUILDER.comment("\u5f02\u6b65\u533a\u5757\u751f\u6210\u7684\u7ebf\u7a0b\u6570 | Number of threads for async chunk generation").defineInRange("chunkGenThreads", 2, 1, 8);
        BUILDER.pop();
        BUILDER.comment("\u5f02\u6b65\u4f18\u5316\u8bbe\u7f6e | Async Optimization Settings").push("async_optimization");
        ASYNC_PARTICLES = BUILDER.comment("\u542f\u7528\u5f02\u6b65\u7c92\u5b50\u5904\u7406 | Enable asynchronous particle processing").define("asyncParticles", true);
        MAX_ASYNC_OPERATIONS_PER_TICK = BUILDER.comment("\u6bcftick\u5904\u7406\u7684\u6700\u5927\u5f02\u6b65\u64cd\u4f5c\u6570 | Max async operations processed per tick").defineInRange("maxAsyncOpsPerTick", 1000, 100, 10000);
        DISABLE_ASYNC_ON_ERROR = BUILDER.comment("\u51fa\u9519\u540e\u7981\u7528\u8be5\u4e8b\u4ef6\u7c7b\u578b\u7684\u5f02\u6b65\u5904\u7406 | Disable async for event type after errors").define("disableAsyncOnError", true);
        ASYNC_EVENT_TIMEOUT = BUILDER.comment("\u5f02\u6b65\u4e8b\u4ef6\u8d85\u65f6\u65f6\u95f4(\u79d2) | Timeout in seconds for async events").defineInRange("asyncEventTimeout", 2, 1, 10);
        WAIT_FOR_ASYNC_EVENTS = BUILDER.comment("\u7b49\u5f85\u5f02\u6b65\u4e8b\u4ef6\u5b8c\u6210 | Wait for async events to complete").define("waitForAsyncEvents", false);
        BUILDER.push("async_cpu_config");
        maxCPUPro = BUILDER.comment("\u5f02\u6b65\u7cfb\u7edf\u6700\u5927CPU\u6838\u5fc3\u6570 | Max CPU Cores for async system (only for async threads, not world async)").defineInRange("maxCPUPro", 2, 2, 9999);
        maxthreads = BUILDER.comment("\u6700\u5927\u7ebf\u7a0b\u6570 | Max Threads (only for general async threads, not dedicated async threads)").defineInRange("maxthreads", 2, 2, 9999);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u4e8b\u4ef6\u7cfb\u7edf\u8bbe\u7f6e | Event System Settings").push("event_system");
        FEATURE_ENABLED = BUILDER.comment("\u542f\u7528\u9ad8\u6027\u80fd\u5f02\u6b65\u4e8b\u4ef6\u529f\u80fd").define("featureEnabled", true);
        ASYNC_EVENT_CLASS_BLACKLIST = BUILDER.comment(new String[]{"\u4e0d\u5e94\u5f02\u6b65\u5904\u7406\u7684\u4e8b\u4ef6\u7c7b\u5217\u8868 | List of event classes that should NOT be processed asynchronously", "\u652f\u6301\u901a\u914d\u7b26 (\u5982 'net.minecraftforge.event.entity.living.*') | Supports wildcards (e.g. 'net.minecraftforge.event.entity.living.*')"}).defineList("classBlacklist", List.of("net.minecraftforge.event.TickEvent", "net.minecraftforge.event.level.LevelTickEvent", "net.minecraftforge.event.entity.living.*"), o -> o instanceof String);
        ASYNC_EVENT_MOD_BLACKLIST = BUILDER.comment("\u4e0d\u5e94\u5f02\u6b65\u5904\u7406\u7684\u6a21\u7ec4ID\u5217\u8868 | List of mod IDs whose events should NOT be processed asynchronously").defineList("modBlacklist", Collections.emptyList(), o -> o instanceof String);
        STRICT_CLASS_CHECKING = BUILDER.comment("\u542f\u7528\u4e25\u683c\u7684\u7c7b\u5b58\u5728\u68c0\u67e5 (\u63a8\u8350\u4e3a\u7a33\u5b9a\u6027) | Enable strict class existence checking (recommended for stability)").define("strictClassChecking", true);
        BUILDER.pop();
        reloadResourcesAsync = BUILDER.define("reload_resources_no_lag", false);
        SPEC = BUILDER.build();
    }

    public static enum RenderMode {
        SIMPLE,
        VANILLA,
        SEMI_COMPLEX;

    }
}

