/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.forgeconfigapiport.impl.config.ForgeConfigRegistryImpl;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.shuyanmc.mpem.config.CoolConfig;
import net.shuyanmc.mpem.events.EntitySyncHandler;
import net.shuyanmc.mpem.optimization.ChunkManager;
import net.shuyanmc.mpem.optimization.EntityActivator;
import net.shuyanmc.mpem.optimization.EntityOptimizer;
import net.shuyanmc.mpem.optimization.MemoryCleaner;
import net.shuyanmc.mpem.util.EntityCleaner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MpemMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "mpem";
    public static final String VERSION = "2.1.3";
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final MemoryCleaner memoryCleaner = new MemoryCleaner();
    private final EntityOptimizer optimizer = new EntityOptimizer();
    private final EntityCleaner cleaner = new EntityCleaner();
    private final EntityActivator activator = new EntityActivator();
    private final EntitySyncHandler entitySyncHandler = new EntitySyncHandler();
    private ChunkManager chunkManager = new ChunkManager();
    private static final String PROTOCOL_VERSION = "1";
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public MpemMod() {
        LOGGER.info("MPEM Mod is Loading...");
        ForgeConfigRegistryImpl.INSTANCE.register(MODID, ModConfig.Type.COMMON, (IConfigSpec)CoolConfig.SPEC);
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            if (minecraftServer.method_30002() != null) {
                this.memoryCleaner.onServerTick(minecraftServer);
                this.cleaner.onServerTick(minecraftServer);
            }
            this.activator.onServerTick(minecraftServer);
            this.chunkManager.onServerTick(minecraftServer);
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            this.optimizer.onEntityJoin(entity);
            this.entitySyncHandler.onEntityJoinLevel(entity);
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, serverWorld) -> this.optimizer.onEntityLeave(entity));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> this.cleaner.onCommandRegister((CommandDispatcher<class_2168>)commandDispatcher));
        LOGGER.info("Initializing MPEM MOD v{}", (Object)VERSION);
        LOGGER.info("MPEM Mod's other features loading...");
        System.gc();
        LOGGER.info("GC Firstly!");
        LOGGER.info("Please make sure there is an English half-width symbol 'before the mod name! Only in this way will the mod be the first to load! There will be better optimization!");
        LOGGER.info("Notice: Anti-cheating defaults to disabling class name detection. Server administrators who need it can enable it. After the 2.0.6 update, this mod basically does not send false alarms with common mods. You can use it with confidence. If there are still some mods with false alarms, you can provide feedback in the SYMC player exchange group!");
        LOGGER.info("SYMC player exchange group in QQ\uff1a372378451");
    }

    public static int getMaxWorkerThreads() {
        String propValue = System.getProperty("max.worker.threads");
        try {
            if (propValue != null) {
                int value = Integer.parseInt(propValue);
                return Math.max(1, Math.min(value, Short.MAX_VALUE));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors() * 2);
    }
}

