/*
 * Decompiled with CFR 0.152.
 */
package net.shuyanmc.mpem;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_7923;
import net.shuyanmc.mpem.api.IOptimizableEntity;
import net.shuyanmc.mpem.config.CoolConfig;

public final class EntityTickHelper {
    private static final Supplier<Set<class_1792>> ITEM_WHITELIST_CACHE = Suppliers.memoize(() -> ((List)CoolConfig.itemWhitelist.get()).stream().map(s -> (class_1792)class_7923.field_41178.method_10223(new class_2960(s))).filter(Objects::nonNull).collect(Collectors.toSet()));

    public static boolean shouldCancelTick(class_1297 entity) {
        if (entity == null || entity.method_5770() == null || !((Boolean)CoolConfig.optimizeEntities.get()).booleanValue()) {
            return false;
        }
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (!livingEntity.method_5805()) {
            return false;
        }
        class_1937 level = entity.method_37908();
        class_2338 pos = entity.method_24515();
        if (EntityTickHelper.isAlwaysTicking(entity)) {
            return false;
        }
        if (EntityTickHelper.shouldBypassForRaid(entity, level, pos)) {
            return false;
        }
        if (EntityTickHelper.isBossMob(livingEntity)) {
            return false;
        }
        return !EntityTickHelper.isPlayerNearby(level, pos);
    }

    private static boolean isAlwaysTicking(class_1297 entity) {
        return ((IOptimizableEntity)entity.method_5864()).shouldAlwaysTick();
    }

    private static boolean isBossMob(class_1309 entity) {
        class_1308 mob;
        if (entity.method_5864() == class_1299.field_6116) {
            return true;
        }
        if (entity.method_5864() == class_1299.field_6119) {
            return true;
        }
        if (entity.method_5864() == class_1299.field_6086 || entity.method_5864() == class_1299.field_38095) {
            return true;
        }
        return entity instanceof class_1308 && (mob = (class_1308)entity).method_35053();
    }

    private static boolean isDeadEntity(class_1297 entity) {
        class_1309 living;
        return (Boolean)CoolConfig.ignoreDeadEntities.get() == false && entity instanceof class_1309 && (living = (class_1309)entity).method_29504();
    }

    private static boolean shouldOptimizeItemEntity(class_1542 itemEntity) {
        return (Boolean)CoolConfig.optimizeItems.get() != false && !ITEM_WHITELIST_CACHE.get().contains(itemEntity.method_6983().method_7909());
    }

    private static boolean shouldBypassForRaid(class_1297 entity, class_1937 level, class_2338 pos) {
        class_3218 serverLevel;
        return (Boolean)CoolConfig.tickRaidersInRaid.get() != false && level instanceof class_3218 && (serverLevel = (class_3218)level).method_19503(pos) && (entity instanceof class_3763 || ((IOptimizableEntity)entity.method_5864()).shouldTickInRaid());
    }

    private static boolean isPlayerNearby(class_1937 level, class_2338 pos) {
        int horizontalRange = (Integer)CoolConfig.horizontalRange.get();
        int verticalRange = (Integer)CoolConfig.verticalRange.get();
        double rangeSq = horizontalRange * horizontalRange;
        class_238 checkArea = new class_238((double)(pos.method_10263() - horizontalRange), (double)(pos.method_10264() - verticalRange), (double)(pos.method_10260() - horizontalRange), (double)(pos.method_10263() + horizontalRange), (double)(pos.method_10264() + verticalRange), (double)(pos.method_10260() + horizontalRange));
        return !level.method_8390(class_1657.class, checkArea, player -> player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < rangeSq).isEmpty();
    }

    public static boolean shouldCancelTick(class_1937 level) {
        return true;
    }
}

