/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.morerequirement.requirements;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;

public class TimeRequirement
implements CraftingRequirement {
    public String time;

    public boolean test(CraftingContext cxt) {
        Level level = cxt.world;
        if (level == null) {
            return false;
        }
        long timeOfDay = level.m_8044_() % 24000L;
        return switch (this.time) {
            case "day" -> TimeRequirement.isDaytime(timeOfDay);
            case "night" -> {
                if (!TimeRequirement.isDaytime(timeOfDay)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isDaytime(long timeOfDay) {
        return timeOfDay >= 23950L || timeOfDay < 12750L;
    }

    @Nullable
    public List<Component> getDescription() {
        return List.of(Component.m_237110_((String)"more_requirement.holo.time_requirement", (Object[])new Object[]{Component.m_237115_((String)("more_requirement.holo.time_requirement." + this.time))}));
    }
}

