/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.morerequirement.requirements;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;

public class MultiblockRequirement
implements CraftingRequirement {
    public Map<Block, Integer> blocks;
    public int x = 3;
    public int y = 2;
    public int z = 3;

    public boolean test(CraftingContext cxt) {
        Level level = cxt.world;
        if (level == null) {
            return false;
        }
        BlockPos pos = cxt.pos;
        if (pos == null) {
            return false;
        }
        AABB aabb = new AABB(pos).m_82377_((double)this.x, (double)this.y, (double)this.z);
        Map map = level.m_46847_(aabb).map(BlockBehaviour.BlockStateBase::m_60734_).collect(Collectors.groupingBy(Function.identity(), Collectors.summingInt(i -> 1)));
        for (Map.Entry<Block, Integer> entry : this.blocks.entrySet()) {
            if (map.getOrDefault(entry.getKey(), 0) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public List<Component> getDescription() {
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = this.blocks.size();
        int index = 0;
        builder.add((Object)Component.m_237110_((String)"more_requirement.holo.multiblock_requirement", (Object[])new Object[]{this.x * 2 + 1, this.y * 2 + 1, this.z * 2 + 1}));
        for (Map.Entry<Block, Integer> entry : this.blocks.entrySet()) {
            if (++index == size) {
                builder.add((Object)Component.m_237113_((String)" \u00a78\u2514\u00a7r ").m_7220_((Component)entry.getKey().m_49954_()).m_130946_(" x" + entry.getValue()));
                continue;
            }
            builder.add((Object)Component.m_237113_((String)" \u00a78\u251c\u00a7r ").m_7220_((Component)entry.getKey().m_49954_()).m_130946_(" x" + entry.getValue()));
        }
        return builder.build();
    }
}

