/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.morerequirement.data;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.yiran.morerequirement.MoreRequirement;
import net.yiran.morerequirement.data.MRUpdateDataPacket;
import net.yiran.morerequirement.requirements.grouprequirement.GroupRequirementStore;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.data.DataManager;

public class MRDataManager
implements DataDistributor {
    public static MRDataManager instance;
    public DataStore<GroupRequirementStore> groupRequirement;
    public DataStore<ScrollData[]> scrolls;
    public List<DataStore<?>> dataStores = new ArrayList(10);

    public MRDataManager() {
        instance = this;
        this.groupRequirement = new DataStore(DataManager.gson, "morerequirement", "group", GroupRequirementStore.class, (DataDistributor)this);
        this.scrolls = new DataStore(DataManager.gson, "morerequirement", "scrolls", ScrollData[].class, (DataDistributor)this);
        this.groupRequirement.onReload(() -> GroupRequirementStore.handler(this.groupRequirement.getData()));
        this.addDatastore(this.groupRequirement, this.scrolls);
    }

    public void addDatastore(DataStore<?> ... datastore) {
        this.dataStores.addAll(List.of(datastore));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void addReloadListener(AddReloadListenerEvent event) {
        this.dataStores.forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    @SubscribeEvent
    public void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        this.dataStores.forEach(dataStore -> dataStore.sendToPlayer((ServerPlayer)event.getEntity()));
    }

    public void onDataReceived(String directory, Map<ResourceLocation, String> data) {
        this.dataStores.stream().filter(dataStore -> dataStore.getDirectory().equals(directory)).forEach(dataStore -> dataStore.loadFromPacket(data));
    }

    public void sendToAll(String directory, Map<ResourceLocation, JsonElement> data) {
        MoreRequirement.NETWORK.sendToAllPlayers((AbstractPacket)new MRUpdateDataPacket(directory, data));
    }

    public void sendToPlayer(ServerPlayer player, String directory, Map<ResourceLocation, JsonElement> data) {
        MoreRequirement.NETWORK.sendTo((AbstractPacket)new MRUpdateDataPacket(directory, data), player);
    }
}

