/*
 * Decompiled with CFR 0.152.
 */
package net.yiran.morerequirement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.yiran.morerequirement.MoreRequirement;
import net.yiran.morerequirement.data.MRDataManager;
import se.mickelus.mutil.util.HexCodec;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollItem;

public class CreativeTabHandler {
    public static Codec<Integer> IntClamp = Codec.INT.xmap(i -> Mth.m_14045_((int)i, (int)0, (int)15), i -> Mth.m_14045_((int)i, (int)0, (int)15));
    public static Codec<ScrollData> ScrollDataCodec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(i -> i.key), (App)Codec.STRING.optionalFieldOf("details").forGetter(i -> Optional.ofNullable(i.details)), (App)Codec.BOOL.fieldOf("intricate").forGetter(i -> i.isIntricate), (App)Codec.INT.fieldOf("material").forGetter(i -> i.material), (App)HexCodec.instance.fieldOf("ribbon").forGetter(i -> i.ribbon), (App)IntClamp.listOf().optionalFieldOf("glyphs", Collections.emptyList()).forGetter(i -> i.glyphs), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("schematics", Collections.emptyList()).forGetter(i -> i.schematics), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("effects", Collections.emptyList()).forGetter(i -> i.craftingEffects)).apply((Applicative)instance, ScrollData::new));

    public static void init() {
        if (CreativeTabHandler.needCreateCreativeTab()) {
            CreativeTabHandler.registerCreativeModeTab();
        } else {
            MoreRequirement.ModEventBus.addListener(CreativeTabHandler::onCreativeTabsBuild);
        }
    }

    public static boolean needCreateCreativeTab() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("morerequirement-common.toml");
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            return Files.readAllLines(path).stream().filter(line -> !line.isBlank()).filter(line -> !line.startsWith("#")).filter(line -> line.contains("CreateSingleCreativeTab")).anyMatch(line -> line.contains("true"));
        }
        catch (IOException e) {
            return true;
        }
    }

    public static void addScrollItems(CreativeModeTab.Output output) {
        MRDataManager.instance.scrolls.getData().values().stream().flatMap(Stream::of).map(CreativeTabHandler::getScrollItem).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }

    public static void writeScrollData(ItemStack stack) {
        JsonArray data = new JsonArray();
        JsonObject data1 = CreativeTabHandler.getScrollData(stack).getAsJsonObject();
        data1.addProperty("ribbon", (Number)Integer.parseInt(data1.get("ribbon").getAsString(), 16));
        data.add((JsonElement)data1);
        Path path = FMLPaths.GAMEDIR.get().resolve("kubejs").resolve("data").resolve("morerequirement").resolve("scrolls").resolve(data1.get("key").getAsString().replace(":", "_").replace("/", "_") + ".json");
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (BufferedWriter fileWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);
            jsonWriter.setIndent("\t");
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            Streams.write((JsonElement)data, (JsonWriter)jsonWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement getScrollData(ItemStack stack) {
        ScrollData data1 = ScrollData.read((ItemStack)stack);
        return (JsonElement)ScrollDataCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data1).result().get();
    }

    public static ItemStack getScrollItem(ScrollData scrollData) {
        ItemStack stack = new ItemStack((ItemLike)ScrollItem.instance);
        CompoundTag tag = new CompoundTag();
        stack.m_41700_("BlockEntityTag", (Tag)tag);
        ListTag list = new ListTag();
        tag.m_128365_("data", (Tag)list);
        list.add((Object)((Tag)ScrollDataCodec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)scrollData).result().get()));
        return stack;
    }

    public static void onCreativeTabsBuild(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("tetra", "default"))) {
            CreativeTabHandler.addScrollItems((CreativeModeTab.Output)event);
        }
    }

    public static void registerCreativeModeTab() {
        DeferredRegister creativeTabs = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"morerequirement");
        RegistryObject creativeTab = creativeTabs.register("scroll", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ScrollItem.instance)).m_257941_((Component)Component.m_237115_((String)"more_requirement.scrollGroup")).m_257501_((itemDisplayParameters, output) -> {
            CreativeTabHandler.addScrollItems(output);
            ScrollItem.instance.getCreativeTabItems().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        }).m_257652_());
        creativeTabs.register(MoreRequirement.ModEventBus);
    }
}

