/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobType;

public class MobTypeHelper {
    private static final Map<Integer, MobType> ID_TO_TYPE = new LinkedHashMap<Integer, MobType>();
    private static final Map<MobType, Integer> TYPE_TO_ID = new HashMap<MobType, Integer>();
    private static final Map<MobType, String> DISPLAY_NAMES = new HashMap<MobType, String>();

    public static MobType fromId(int id) {
        return ID_TO_TYPE.getOrDefault(id, MobType.f_21640_);
    }

    public static int toId(MobType type) {
        return TYPE_TO_ID.getOrDefault(type, 0);
    }

    public static List<MobType> getAllMobTypes() {
        ArrayList<MobType> list = new ArrayList<MobType>();
        list.add(MobType.f_21640_);
        list.add(MobType.f_21641_);
        list.add(MobType.f_21643_);
        list.add(MobType.f_21644_);
        list.add(MobType.f_21642_);
        return list;
    }

    public static Component getDisplayName(MobType type) {
        return Component.m_237115_((String)MobTypeHelper.getDisplayNameString(type));
    }

    public static String getDisplayNameString(MobType type) {
        return DISPLAY_NAMES.getOrDefault(type, "\u672a\u77e5\u7c7b\u578b");
    }

    public static MobType getNextMobType(MobType current) {
        List<MobType> all = MobTypeHelper.getAllMobTypes();
        int index = all.indexOf(current);
        if (index == -1 || index == all.size() - 1) {
            return all.get(0);
        }
        return all.get(index + 1);
    }

    static {
        for (int i = 0; i < 5; ++i) {
            ID_TO_TYPE.put(i, MobTypeHelper.getAllMobTypes().get(i));
            TYPE_TO_ID.put(MobTypeHelper.getAllMobTypes().get(i), i);
        }
        DISPLAY_NAMES.put(MobType.f_21640_, "button.powerful_dummy.undefined");
        DISPLAY_NAMES.put(MobType.f_21641_, "button.powerful_dummy.undead");
        DISPLAY_NAMES.put(MobType.f_21642_, "button.powerful_dummy.arthropod");
        DISPLAY_NAMES.put(MobType.f_21643_, "button.powerful_dummy.illager");
        DISPLAY_NAMES.put(MobType.f_21644_, "button.powerful_dummy.water");
    }
}

