/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;

public class EditBoxInfoHelper {
    private static final EditBoxInfoHelper INSTANCE = new EditBoxInfoHelper();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private HashMap<String, HashMap<String, Attribute>> attributesMap = new HashMap();
    private String lastLoadedLang;

    public static EditBoxInfoHelper getInstance() {
        return INSTANCE;
    }

    private EditBoxInfoHelper() {
        this.initAttributesMap();
    }

    private void ensureInitialized() {
        if (this.attributesMap.isEmpty() || this.isLanguageChanged()) {
            this.initAttributesMap();
            this.lastLoadedLang = this.getCurrentLanguage();
        }
    }

    private boolean isLanguageChanged() {
        return !Objects.equals(this.getCurrentLanguage(), this.lastLoadedLang);
    }

    private String getCurrentLanguage() {
        return this.minecraft.m_91102_().m_264236_();
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public HashMap<String, HashMap<String, Attribute>> getAttributesMap() {
        this.ensureInitialized();
        return this.attributesMap;
    }

    public HashMap<String, Attribute> getAttributesByLang(String langCode) {
        this.ensureInitialized();
        return this.getAttributesMap().getOrDefault(langCode, new HashMap());
    }

    public Attribute getAttributeByDescriptionName(String name) {
        this.ensureInitialized();
        return this.getAttributesInSelected().getOrDefault(name.toLowerCase(Locale.ROOT), null);
    }

    public HashMap<String, Attribute> getAttributesInSelected() {
        this.ensureInitialized();
        return this.getAttributesByLang(this.getCurrentLanguage());
    }

    public void initAttributesMap() {
        this.attributesMap.clear();
        RegistryAccess registryAccess = this.getMinecraft().f_91073_.m_9598_();
        Registry attributeRegistry = registryAccess.m_175515_(Registries.f_256728_);
        String currentLang = this.getCurrentLanguage();
        for (ResourceLocation key : attributeRegistry.m_6566_()) {
            Attribute attribute = (Attribute)attributeRegistry.m_7745_(key);
            if (attribute == null) continue;
            String localizedName = Component.m_237115_((String)attribute.m_22087_()).getString();
            this.attributesMap.computeIfAbsent(currentLang, k -> new HashMap()).put(localizedName.toLowerCase(Locale.ROOT), attribute);
        }
    }

    public Optional<Attribute> findAttributeByName(String inputName) {
        if (inputName == null || inputName.isEmpty()) {
            return Optional.empty();
        }
        this.ensureInitialized();
        String lowerInput = inputName.toLowerCase(Locale.ROOT);
        HashMap<String, Attribute> attrMap = this.getAttributesInSelected();
        return attrMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(lowerInput)).map(Map.Entry::getValue).findFirst();
    }

    public Attribute getAttributeFromId(String idStr) {
        this.ensureInitialized();
        ResourceLocation id = ResourceLocation.m_135820_((String)idStr);
        if (id != null) {
            return (Attribute)this.getMinecraft().f_91073_.m_9598_().m_175515_(Registries.f_256728_).m_7745_(id);
        }
        return null;
    }

    public Collection<String> getAllLocalizedAttributeNames() {
        this.ensureInitialized();
        return this.getAttributesInSelected().keySet();
    }

    public void reloadForLanguage(String langCode) {
        this.ensureInitialized();
        if (this.attributesMap.containsKey(langCode)) {
            return;
        }
        Registry attributeRegistry = this.getMinecraft().f_91073_.m_9598_().m_175515_(Registries.f_256728_);
        HashMap<String, Attribute> langMap = new HashMap<String, Attribute>();
        for (ResourceLocation key : attributeRegistry.m_6566_()) {
            Attribute attribute = (Attribute)attributeRegistry.m_7745_(key);
            if (attribute == null) continue;
            String localizedName = Component.m_237115_((String)attribute.m_22087_()).getString();
            langMap.put(localizedName.toLowerCase(Locale.ROOT), attribute);
        }
        this.attributesMap.put(langCode, langMap);
    }

    public ResourceLocation getAttributeResourceLocationByName(String attributeName) {
        this.ensureInitialized();
        HashMap<String, Attribute> attributesInSelectedLang = this.getAttributesInSelected();
        for (Map.Entry<String, Attribute> entry : attributesInSelectedLang.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(attributeName)) continue;
            return this.minecraft.f_91073_.m_9598_().m_175515_(Registries.f_256728_).m_7981_((Object)entry.getValue());
        }
        return null;
    }
}

