/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.network;

import com.whisent.powerful_dummy.dps.DpsTracker;
import com.whisent.powerful_dummy.impl.IActionBarDisplay;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ClearDpsDataPacket {
    private byte clear;

    public ClearDpsDataPacket(byte clear) {
        this.clear = clear;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte((int)this.clear);
    }

    public static ClearDpsDataPacket decode(FriendlyByteBuf buf) {
        return new ClearDpsDataPacket(buf.readByte());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    return;
                }
                DpsTracker.getDpsData((Entity)player).reset();
                ((IActionBarDisplay)player).sendActionBarMessage((Component)Component.m_237115_((String)"powerful_dummy.dps.cleared"));
            } else {
                System.out.print("\u5ba2\u6237\u7aef");
            }
        });
        context.setPacketHandled(true);
    }
}

