/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.gui.widget;

import com.whisent.powerful_dummy.gui.widget.AbstractAutoCompleteEditBox;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;

public class AttributeAutoCompleteEditBox
extends AbstractAutoCompleteEditBox {
    public LivingEntity entity;
    public final HashMap<String, Boolean> attributesNotZero;
    public boolean hovered = false;

    public AttributeAutoCompleteEditBox(Font font, int x, int y, int width, int height, Component message, LivingEntity entity) {
        super(font, x, y, width, height, message);
        this.entity = entity;
        this.attributesNotZero = new HashMap();
        this.setVisibleCount(5);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public void loadSuggestions() {
        if (this.getEntity().m_6084_()) {
            this.suggestions.clear();
            this.attributesNotZero.clear();
            RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
            Registry attributeRegistry = registryAccess.m_175515_(Registries.f_256728_);
            for (ResourceLocation key : attributeRegistry.m_6566_()) {
                Attribute attribute = (Attribute)attributeRegistry.m_7745_(key);
                if (attribute == null || this.getEntity().m_21051_(attribute) == null) continue;
                String name = Component.m_237115_((String)attribute.m_22087_()).getString();
                if (this.getEntity().m_21051_(attribute).m_22115_() != 0.0) {
                    this.suggestions.add(name);
                    this.attributesNotZero.putIfAbsent(name, true);
                    continue;
                }
                this.suggestions.add(name);
            }
            this.suggestions.sort(String.CASE_INSENSITIVE_ORDER);
        }
    }

    @Override
    protected void drawSuggestions(GuiGraphics guiGraphics, List<String> list, int mouseX, int mouseY) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.loadSuggestions();
        int x = this.m_252754_();
        int y = this.m_252907_() + this.m_93694_();
        int width = this.m_5711_();
        int visibleCount = Math.min(this.SUGGESTIONS_VISIBLE_COUNT, list.size());
        guiGraphics.m_280509_(x, y, x + width, y + visibleCount * 12, -1879048192);
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        for (int i = 0; i < visibleCount; ++i) {
            boolean hovered;
            int index = i + this.scrollOffset;
            if (index < 0 || index >= list.size()) continue;
            String suggestion = list.get(index);
            boolean bl = hovered = mouseX >= x && mouseX <= x + width && mouseY >= y + i * 12 && mouseY <= y + (i + 1) * 12;
            if (hovered || index == this.selectedIndex) {
                guiGraphics.m_280509_(x, y + i * 12, x + width, y + (i + 1) * 12, -1336584875);
            }
            int maxWidth = 88;
            Object finalSuggestion = font.m_92895_(suggestion) > maxWidth ? font.m_92834_(suggestion, maxWidth) + ".." : suggestion;
            int color = this.attributesNotZero.getOrDefault(suggestion, false) != false ? 16558080 : 0xE0E0E0;
            guiGraphics.m_280488_(font, (String)finalSuggestion, x + 4, y + i * 12 + 2, color);
        }
    }
}

