/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public abstract class AbstractAutoCompleteEditBox
extends EditBox {
    protected final List<String> suggestions = new ArrayList<String>();
    protected int selectedIndex = -1;
    protected int scrollOffset = 0;
    protected int SUGGESTIONS_VISIBLE_COUNT = 10;
    public boolean displaySuggestions = false;

    public AbstractAutoCompleteEditBox(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
    }

    public void setVisibleCount(int count) {
        this.SUGGESTIONS_VISIBLE_COUNT = count;
    }

    public abstract void loadSuggestions();

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.m_280168_();
        RenderSystem.enableBlend();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 1.0f);
        if (this.m_93696_()) {
            List<String> filtered = this.getSuggestions(this.m_94155_());
            this.displaySuggestions = !filtered.isEmpty() || this.m_94155_().isEmpty();
            if (this.displaySuggestions) {
                this.drawSuggestions(guiGraphics, filtered.isEmpty() ? this.suggestions : filtered, mouseX, mouseY);
            }
        } else {
            this.displaySuggestions = false;
        }
        poseStack.m_85849_();
    }

    protected List<String> getSuggestions(String input) {
        return this.suggestions.stream().filter(s -> s.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
    }

    protected void drawSuggestions(GuiGraphics guiGraphics, List<String> list, int mouseX, int mouseY) {
        int index;
        int x = this.m_252754_();
        int y = this.m_252907_() + this.m_93694_();
        int width = this.m_5711_();
        int visibleCount = Math.min(this.SUGGESTIONS_VISIBLE_COUNT, list.size());
        guiGraphics.m_280509_(x, y, x + width, y + visibleCount * 12, -1879048192);
        for (int i = 0; i < visibleCount && (index = i + this.scrollOffset) < list.size(); ++i) {
            boolean hovered;
            String suggestion = list.get(index);
            boolean bl = hovered = mouseX >= x && mouseX <= x + width && mouseY >= y + i * 12 && mouseY <= y + (i + 1) * 12;
            if (hovered || index == this.selectedIndex) {
                guiGraphics.m_280509_(x, y + i * 12, x + width, y + (i + 1) * 12, -1336584875);
            }
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, suggestion, x + 4, y + i * 12 + 2, 0xE0E0E0);
        }
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.m_93696_()) {
            return false;
        }
        List<String> filtered = this.getSuggestions(this.m_94155_());
        switch (keyCode) {
            case 265: {
                if (this.selectedIndex > 0) {
                    --this.selectedIndex;
                } else if (!filtered.isEmpty()) {
                    this.selectedIndex = filtered.size() - 1;
                }
                this.updateTextFromSelection(filtered);
                return true;
            }
            case 264: {
                this.selectedIndex = this.selectedIndex < filtered.size() - 1 ? ++this.selectedIndex : 0;
                this.updateTextFromSelection(filtered);
                return true;
            }
            case 257: 
            case 335: {
                if (this.selectedIndex >= 0 && this.selectedIndex < filtered.size()) {
                    this.m_94144_(filtered.get(this.selectedIndex));
                    this.selectedIndex = -1;
                    return true;
                }
                return false;
            }
        }
        if (keyCode != 259) {
            this.selectedIndex = -1;
        }
        return false;
    }

    protected void updateTextFromSelection(List<String> list) {
        if (this.selectedIndex >= 0 && this.selectedIndex < list.size()) {
            this.m_94144_(list.get(this.selectedIndex));
        }
    }

    public boolean handleMouseClick(double mouseX, double mouseY) {
        int index;
        if (!this.m_93696_()) {
            return false;
        }
        List<String> filtered = this.getSuggestions(this.m_94155_());
        if (filtered.isEmpty()) {
            return false;
        }
        int x = this.m_252754_();
        int yStart = this.m_252907_() + this.m_93694_();
        for (int i = 0; i < this.SUGGESTIONS_VISIBLE_COUNT && (index = i + this.scrollOffset) < filtered.size(); ++i) {
            int yMin = yStart + i * 12;
            int yMax = yMin + 12;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + this.m_5711_())) || !(mouseY >= (double)yMin) || !(mouseY <= (double)yMax)) continue;
            this.m_94144_(filtered.get(index));
            this.selectedIndex = -1;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.m_93696_()) {
            return false;
        }
        List<String> filtered = this.getSuggestions(this.m_94155_());
        if (!filtered.isEmpty()) {
            int maxScrollOffset = Math.max(0, filtered.size() - this.SUGGESTIONS_VISIBLE_COUNT);
            if (delta < 0.0) {
                this.scrollOffset = Math.min(this.scrollOffset + 1, maxScrollOffset);
            } else if (delta > 0.0) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
            }
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean handled = super.m_5534_(codePoint, modifiers);
        if (handled) {
            this.selectedIndex = -1;
            this.scrollOffset = 0;
        }
        return handled;
    }
}

