/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.whisent.powerful_dummy.data.AttributeData;
import com.whisent.powerful_dummy.data.AttributeLoader;
import com.whisent.powerful_dummy.entity.TestDummyEntity;
import com.whisent.powerful_dummy.gui.TestDummyEntityMenu;
import com.whisent.powerful_dummy.gui.widget.AttributeAutoCompleteEditBox;
import com.whisent.powerful_dummy.gui.widget.CustomFocusButton;
import com.whisent.powerful_dummy.network.DummyInfoPacket;
import com.whisent.powerful_dummy.network.NetWorkHandler;
import com.whisent.powerful_dummy.utils.EditBoxInfoHelper;
import com.whisent.powerful_dummy.utils.MobTypeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class TestDummyEntityScreen
extends AbstractContainerScreen<TestDummyEntityMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("powerful_dummy", "textures/gui/test_dummy_screen.png");
    private static final ResourceLocation CURIOS_TEX = new ResourceLocation("powerful_dummy", "textures/gui/test_dummy_curios.png");
    private MobType mobType;
    private AttributeAutoCompleteEditBox attributeAutoCompleteBox;
    private CustomFocusButton applyAttributeButton;
    private EditBox attributeInputField;
    private final CompoundTag attributesMap = new CompoundTag();

    public TestDummyEntityScreen(TestDummyEntityMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, (Component)Component.m_237113_((String)"\u6d4b\u8bd5"));
        this.f_97726_ = 200;
        this.f_97727_ = 200;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        if (ModList.get().isLoaded("curios")) {
            ICuriosItemHandler handler = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity().getCapability(CuriosCapability.INVENTORY).resolve().orElse(null);
            if (handler == null) {
                return;
            }
            int number = handler.getSlots() / 9;
            for (int j = 0; j < number + 1; ++j) {
                guiGraphics.m_280398_(CURIOS_TEX, this.f_97735_ - 13 - j * 18, this.f_97736_, 0, 0.0f, 0.0f, 30, 200, 200, 200);
            }
        }
        this.armorRender(guiGraphics);
        this.curiosRender(guiGraphics);
    }

    private ResourceLocation getIconByIndex(int index) {
        return switch (index) {
            case 0 -> new ResourceLocation("minecraft", "textures/item/empty_armor_slot_helmet.png");
            case 1 -> new ResourceLocation("minecraft", "textures/item/empty_armor_slot_chestplate.png");
            case 2 -> new ResourceLocation("minecraft", "textures/item/empty_armor_slot_leggings.png");
            case 3 -> new ResourceLocation("minecraft", "textures/item/empty_armor_slot_boots.png");
            case 5 -> new ResourceLocation("minecraft", "textures/item/empty_slot_sword.png");
            case 4 -> new ResourceLocation("minecraft", "textures/item/empty_armor_slot_shield.png");
            default -> null;
        };
    }

    private void armorRender(GuiGraphics guiGraphics) {
        int startX = this.f_97735_ + 21;
        int startY = this.f_97736_ + 8;
        int x = startX;
        TestDummyEntity entity = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity();
        ArrayList slots = new ArrayList();
        entity.m_20158_().forEach(slots::add);
        Collections.reverse(slots);
        for (int i = 0; i < slots.size(); ++i) {
            if (i < 4) {
                ResourceLocation icon;
                if (((ItemStack)slots.get(i)).m_41619_() && (icon = this.getIconByIndex(i)) != null) {
                    guiGraphics.m_280163_(icon, x, startY, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            } else {
                ResourceLocation icon;
                int iFix = i;
                switch (iFix) {
                    case 4: {
                        int n = 5;
                        break;
                    }
                    case 5: {
                        int n = 4;
                        break;
                    }
                    default: {
                        int n = iFix = iFix;
                    }
                }
                if (((ItemStack)slots.get(iFix)).m_41619_() && (icon = this.getIconByIndex(iFix)) != null) {
                    guiGraphics.m_280163_(icon, x, startY, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            x += 18;
        }
    }

    private void curiosRender(GuiGraphics guiGraphics) {
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        ICuriosItemHandler handler = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity().getCapability(CuriosCapability.INVENTORY).resolve().orElse(null);
        if (handler == null) {
            return;
        }
        int startX = this.f_97735_ - 6;
        int startY = this.f_97736_ + 7;
        int slotSize = 18;
        int gap = 0;
        int row = 0;
        int col = 0;
        int index = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ResourceLocation icon;
            if (i != 0 && i % 10 == 0) {
                ++col;
                row = 0;
            }
            String identifier = ((TestDummyEntityMenu)this.f_97732_).getCuriosContainer().getIdentifier(i);
            ItemStack item = handler.getEquippedCurios().getStackInSlot(index);
            if (CuriosApi.getSlot((String)identifier).isPresent() && (icon = ((ISlotType)CuriosApi.getSlot((String)identifier).get()).getIcon()) != null) {
                ResourceLocation newIcon = new ResourceLocation(icon.m_135827_(), "textures/" + icon.m_135815_() + ".png");
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)CURIOS_TEX);
                int x = startX - col * slotSize;
                int y = startY + row * (slotSize + gap);
                guiGraphics.m_280398_(CURIOS_TEX, x, y, 0, 32.0f, 0.0f, 18, 18, 200, 200);
                if (item.m_41619_()) {
                    guiGraphics.m_280163_(newIcon, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
                }
            }
            ++row;
            ++index;
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int baseY = this.f_97736_ + 20;
        int yOffset = 40;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"button.powerful_dummy.mobType"), this.f_97735_ + 20, baseY + yOffset - 3, 0, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"button.powerful_dummy.attribute"), this.f_97735_ + 20, baseY + 8, 0, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"button.powerful_dummy.value"), this.f_97735_ + 65, baseY + 37, 0, false);
        this.renderDisplayAttributes(guiGraphics, ((TestDummyEntityMenu)this.f_97732_).getTargetEntity());
    }

    private void renderDisplayAttributes(GuiGraphics guiGraphics, TestDummyEntity entity) {
        ResourceLocation dataId = new ResourceLocation("powerful_dummy", "attribute_display");
        AttributeData data = AttributeLoader.getData(dataId);
        if (data == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        int x = this.f_97735_ + 95;
        int y = this.f_97736_ + 24;
        int offset = 3;
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 9;
        for (AttributeData.AttributeEntry entry : data.attributes) {
            Attribute attribute = entry.getAttribute();
            if (attribute == null) continue;
            double value = entity.m_21133_(attribute);
            String attributeText = Component.m_237115_((String)attribute.m_22087_()).getString();
            String formattedValue = entry.usePercent ? String.format("%.2f", value * 100.0) : String.format("%.2f", value);
            String fullText = attributeText + ": " + formattedValue;
            guiGraphics.m_280056_(this.f_96547_, fullText, x, y + offset, entry.getDisplayColor(), false);
            offset += lineHeight + 5;
            y += lineHeight * 2;
        }
    }

    private void putEditBoxes() {
        int Xpos = this.f_97735_ + 20;
        TestDummyEntity entity = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity();
        this.attributeAutoCompleteBox = new AttributeAutoCompleteEditBox(this.f_96547_, Xpos, this.f_97736_ + 38, 72, 16, (Component)Component.m_237113_((String)"Attributes"), (LivingEntity)entity);
        this.attributeAutoCompleteBox.loadSuggestions();
        this.attributeAutoCompleteBox.m_94151_(newText -> {
            try {
                Attribute atb = EditBoxInfoHelper.getInstance().getAttributeByDescriptionName((String)newText);
                this.attributeInputField.m_94144_(String.valueOf(((TestDummyEntityMenu)this.f_97732_).getTargetEntity().m_21172_(atb)));
            }
            catch (Exception e) {
                System.err.println("\u975e\u6cd5\u5c5e\u6027");
            }
        });
        this.attributeInputField = new EditBox(this.f_96547_, Xpos + 44, this.f_97736_ + 67, 28, 18, (Component)Component.m_237113_((String)"AttributeValue"));
        this.attributeInputField.m_94198_();
        this.attributeInputField.m_94199_(10);
        this.attributeInputField.m_94151_(newText -> {
            try {
                double newValue = Double.parseDouble(newText);
                String attributeName = this.attributeAutoCompleteBox.m_94155_();
                ResourceLocation attributeKey = EditBoxInfoHelper.getInstance().getAttributeResourceLocationByName(attributeName);
                if (attributeKey != null) {
                    this.attributesMap.m_128347_(attributeKey.toString(), newValue);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("\u65e0\u6cd5\u5c06\u8f93\u5165\u8f6c\u6362\u4e3a\u6570\u5b57");
            }
        });
        this.m_142416_((GuiEventListener)this.attributeInputField);
        this.m_142416_((GuiEventListener)this.attributeAutoCompleteBox);
    }

    protected void m_7856_() {
        MobType initialType;
        super.m_7856_();
        this.putEditBoxes();
        int Xpos = this.f_97735_ + 20;
        this.f_97731_ = Integer.MIN_VALUE;
        this.f_97729_ = Integer.MIN_VALUE;
        TestDummyEntity entity = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity();
        this.mobType = initialType = entity.m_6336_();
        Button changeTypeButton = Button.m_253074_((Component)MobTypeHelper.getDisplayName(initialType), button -> {
            TestDummyEntity target = ((TestDummyEntityMenu)this.f_97732_).getTargetEntity();
            if (target == null) {
                return;
            }
            MobType next = MobTypeHelper.getNextMobType(this.mobType);
            button.m_93666_(MobTypeHelper.getDisplayName(next));
            this.mobType = next;
        }).m_252794_(Xpos, this.f_97736_ + 30 + 36).m_253046_(40, 20).m_253136_();
        this.m_142416_((GuiEventListener)changeTypeButton);
        this.applyAttributeButton = new CustomFocusButton.Builder((Component)Component.m_237115_((String)"button.powerful_dummy.apply"), button -> this.sendData(), this.attributeAutoCompleteBox).pos(Xpos, this.f_97736_ + 93).size(73, 16).build();
        this.m_142416_((GuiEventListener)this.applyAttributeButton);
    }

    public void m_7861_() {
        this.sendData();
        super.m_7861_();
    }

    public boolean m_6913_() {
        return super.m_6913_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.attributeAutoCompleteBox != null && this.attributeAutoCompleteBox.handleKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.attributeAutoCompleteBox != null && this.attributeAutoCompleteBox.handleMouseClick(mouseX, mouseY)) {
            this.attributeAutoCompleteBox.m_93692_(false);
            return false;
        }
        if (this.attributeAutoCompleteBox != null && this.attributeAutoCompleteBox.handleMouseClick(mouseX, mouseY)) {
            this.attributeAutoCompleteBox.m_93692_(false);
        }
        if (this.attributeAutoCompleteBox != null) {
            this.attributeAutoCompleteBox.m_93692_(false);
        }
        this.attributeInputField.m_93692_(false);
        this.applyAttributeButton.m_93692_(false);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.attributeAutoCompleteBox != null && this.attributeAutoCompleteBox.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void sendData() {
        NetWorkHandler.CHANNEL.sendToServer((Object)new DummyInfoPacket(((TestDummyEntityMenu)this.f_97732_).getTargetEntity().m_19879_(), MobTypeHelper.toId(this.mobType), this.attributesMap));
    }
}

