/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.gui;

import com.whisent.powerful_dummy.entity.TestDummyEntity;
import com.whisent.powerful_dummy.gui.MenuRegistry;
import com.whisent.powerful_dummy.gui.container.TestDummyArmorContainer;
import com.whisent.powerful_dummy.gui.container.TestDummyCuriosContainer;
import com.whisent.powerful_dummy.gui.slot.TestDummyCurioSlot;
import com.whisent.powerful_dummy.utils.Debugger;
import java.io.Serializable;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class TestDummyEntityMenu
extends AbstractContainerMenu {
    private final TestDummyEntity entity;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private final TestDummyArmorContainer armorContainer;
    private TestDummyCuriosContainer curiosContainer;

    public TestDummyEntityMenu(int containerId, Inventory inv, FriendlyByteBuf data) {
        this(containerId, inv, TestDummyEntityMenu.getEntityFromBuf(data, inv.f_35978_.m_9236_()));
    }

    public TestDummyEntityMenu(int containerId, Inventory inv, @Nullable TestDummyEntity entity) {
        super((MenuType)MenuRegistry.TEST_DUMMY_MENU.get(), containerId);
        this.entity = entity;
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Creating menu for entity: " + (Serializable)(entity != null ? Integer.valueOf(entity.m_19879_()) : "null"));
        this.armorContainer = new TestDummyArmorContainer(entity);
        if (entity != null) {
            this.addArmorSlots(entity);
            this.addPlayerSlots(inv);
            if (ModList.get().isLoaded("curios")) {
                this.addCurioSlots(entity);
            }
        }
    }

    private static TestDummyEntity getEntityFromBuf(FriendlyByteBuf buf, Level level) {
        int entityId = buf.readInt();
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Reading entity ID from buffer: " + entityId);
        Entity entity = level.m_6815_(entityId);
        if (entity instanceof TestDummyEntity) {
            Debugger.sendDebugMessage("[TestDummyEntityMenu] Found TestDummyEntity: " + entityId);
            return (TestDummyEntity)entity;
        }
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Entity not found or not a TestDummyEntity: " + entityId);
        return null;
    }

    private EquipmentSlot getEquipmentSlot(int slot) {
        EquipmentSlot result = switch (slot) {
            case 0 -> EquipmentSlot.HEAD;
            case 1 -> EquipmentSlot.CHEST;
            case 2 -> EquipmentSlot.LEGS;
            case 3 -> EquipmentSlot.FEET;
            case 4 -> EquipmentSlot.MAINHAND;
            case 5 -> EquipmentSlot.OFFHAND;
            default -> null;
        };
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Mapping slot " + slot + " to equipment slot: " + result);
        return result;
    }

    private void addArmorSlots(TestDummyEntity entity) {
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Adding armor slots for entity: " + entity.m_19879_());
        for (int i = 0; i < 6; ++i) {
            this.m_38897_(new Slot((Container)this.armorContainer, i, i * 18 + 21, 8){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    ArmorItem armorItem;
                    Item item;
                    boolean canPlace = this.f_40219_ < 4 ? (item = stack.m_41720_()) instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == TestDummyEntityMenu.this.getEquipmentSlot(this.f_40219_) : true;
                    Debugger.sendDebugMessage("[TestDummyEntityMenu] Slot " + this.f_40219_ + " can place item '" + stack.m_41611_().getString() + "'? " + canPlace);
                    return canPlace;
                }
            });
        }
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Add armor slots successfully for entity: " + entity.m_19879_());
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Quick move stack from slot: " + index);
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack = slot.m_7993_();
            originalStack = itemStack.m_41777_();
            Debugger.sendDebugMessage("[TestDummyEntityMenu] Moving item: " + itemStack.m_41611_().getString() + " (count: " + itemStack.m_41613_() + ")");
            if (index < 6) {
                Debugger.sendDebugMessage("[TestDummyEntityMenu] Moving from armor/hand slot");
                if (!this.m_38903_(itemStack, 42, this.f_38839_.size(), false) && !this.m_38903_(itemStack, 6, 42, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 42) {
                Debugger.sendDebugMessage("[TestDummyEntityMenu] Moving from player inventory");
                if (!this.m_38903_(itemStack, 42, this.f_38839_.size(), false)) {
                    boolean movedToArmor = false;
                    Item item = itemStack.m_41720_();
                    if (item instanceof ArmorItem) {
                        ArmorItem armorItem = (ArmorItem)item;
                        for (int i = 0; i < 4; ++i) {
                            if (armorItem.m_40402_() != this.getEquipmentSlot(i) || !this.m_38903_(itemStack, i, i + 1, false)) continue;
                            movedToArmor = true;
                            break;
                        }
                    }
                    if (!(movedToArmor || itemStack.m_41619_() || this.m_38903_(itemStack, 4, 6, false))) {
                        return ItemStack.f_41583_;
                    }
                }
            } else {
                Debugger.sendDebugMessage("[TestDummyEntityMenu] Moving from curios slot");
                if (!this.m_38903_(itemStack, 6, 42, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack);
        }
        return originalStack;
    }

    public boolean m_6875_(Player playerIn) {
        return this.entity != null && !this.entity.m_213877_() && playerIn.m_20270_((Entity)this.entity) < 64.0f;
    }

    public TestDummyEntity getTargetEntity() {
        return this.entity;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int x;
        int col;
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Adding player inventory slots");
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int PLAYER_INV_START_X = 21;
        int PLAYER_INV_START_Y = 115;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = 21 + col * 18;
                int y = 115 + row * 18;
                int index = col + row * 9 + 9;
                this.m_38897_(new Slot((Container)playerInventory, index, x, y));
            }
        }
        int HOTBAR_Y = 173;
        for (col = 0; col < 9; ++col) {
            x = 21 + col * 18;
            this.m_38897_(new Slot((Container)playerInventory, col, x, 173));
        }
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Add player slots successfully for entity: " + this.entity.m_19879_());
    }

    private void addCurioSlots(TestDummyEntity entity) {
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Adding curios slots for entity: " + entity.m_19879_());
        this.curiosContainer = new TestDummyCuriosContainer(entity);
        int slotIndex = 0;
        int startX = -5;
        int startY = 8;
        for (int i = 0; i < this.curiosContainer.getCuriosHandlerRaw().getSlots(); ++i) {
            if (i != 0 && i % 10 == 0) {
                startX -= 18;
                startY = 8;
            }
            String identifier = this.curiosContainer.getIdentifier(i);
            ICurioStacksHandler handler = (ICurioStacksHandler)this.curiosContainer.getCuriosHandlerRaw().getCurios().get(identifier);
            int amount = handler.getSlots();
            if (!handler.isVisible()) continue;
            for (int j = 0; j < amount; ++j) {
                this.m_38897_(new TestDummyCurioSlot((Container)this.curiosContainer, slotIndex, startX, startY, identifier, entity));
            }
            ++slotIndex;
            startY += 18;
        }
        for (Map.Entry entry : this.curiosContainer.getCuriosHandlerRaw().getCurios().entrySet()) {
            String string = (String)entry.getKey();
        }
        Debugger.sendDebugMessage("[TestDummyEntityMenu] Add curios slots successfully for entity: " + entity.m_19879_());
    }

    public TestDummyCuriosContainer getCuriosContainer() {
        return this.curiosContainer;
    }
}

