/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.events;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.whisent.powerful_dummy.data.AttributeLoader;
import com.whisent.powerful_dummy.data.tag.DamageTagLoader;
import com.whisent.powerful_dummy.dps.DamageData;
import com.whisent.powerful_dummy.dps.DpsTracker;
import com.whisent.powerful_dummy.utils.Debugger;
import com.whisent.powerful_dummy.utils.TimeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="powerful_dummy", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventsHandler {
    @SubscribeEvent
    public static void dataListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new AttributeLoader());
        event.addListener((PreparableReloadListener)new DamageTagLoader());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"damagelog").requires(source -> source.m_6761_(0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            List<DamageData> list = DpsTracker.getDpsData((Entity)player).getDamageDataList();
            int maxEntries = 20;
            ForgeEventsHandler.displayDamageLog(player, list, maxEntries);
            return 1;
        })).then(Commands.m_82129_((String)"maxEntries", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            int maxEntries = IntegerArgumentType.getInteger((CommandContext)context, (String)"maxEntries");
            List<DamageData> list = DpsTracker.getDpsData((Entity)player).getDamageDataList();
            ForgeEventsHandler.displayDamageLog(player, list, maxEntries);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"time").then(Commands.m_82127_((String)"get").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            long currentDuration = DpsTracker.getDpsData((Entity)player).getResetTime();
            player.m_213846_((Component)Component.m_237110_((String)"chat.powerful_dummy.damagelog.time.current", (Object[])new Object[]{currentDuration / 1000L}));
            return 1;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            int seconds = IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds");
            DpsTracker.getDpsData((Entity)player).setResetTime(seconds);
            player.m_213846_((Component)Component.m_237110_((String)"chat.powerful_dummy.damagelog.time.set", (Object[])new Object[]{seconds}));
            return 1;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debuglog").then(Commands.m_82129_((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean open = BoolArgumentType.getBool((CommandContext)context, (String)"state");
            Debugger.setOpen(open);
            MutableComponent message = Component.m_237113_((String)("Debug mode set to: " + open));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ForgeEventsHandler.lambda$onRegisterCommands$5((Component)message), false);
            Debugger.sendAlwaysDebugMessage("[Command] Debug mode set to: " + open);
            return 1;
        }))).executes(context -> {
            boolean currentState = Debugger.isOpen();
            MutableComponent message = Component.m_237113_((String)("Debug mode is currently: " + currentState));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ForgeEventsHandler.lambda$onRegisterCommands$7((Component)message), false);
            Debugger.sendAlwaysDebugMessage("[Command] Debug mode query: " + currentState);
            return 1;
        }));
    }

    private static void displayDamageLog(ServerPlayer player, List<DamageData> list, int maxEntries) {
        if (list.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"chat.powerful_dummy.damagelog.nodata"));
            return;
        }
        int displayCount = Math.min(maxEntries, list.size());
        player.m_213846_((Component)Component.m_237115_((String)"chat.powerful_dummy.damagelog.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        player.m_213846_((Component)Component.m_237110_((String)"chat.powerful_dummy.damagelog.display", (Object[])new Object[]{displayCount}).m_7220_((Component)Component.m_237110_((String)"chat.powerful_dummy.damagelog.display2", (Object[])new Object[]{list.size()})).m_130940_(ChatFormatting.YELLOW));
        List<DamageData> subList = list.subList(Math.max(0, list.size() - displayCount), list.size());
        subList.forEach(damageData -> {
            int color = DamageTagLoader.findDisplayColor(damageData.getDamageSource());
            MutableComponent damageComponent = Component.m_237115_((String)"chat.powerful_dummy.damage").m_130938_(style -> style.m_131140_(ChatFormatting.WHITE));
            MutableComponent damageCountComponent = Component.m_237113_((String)String.format("%.1f", damageData.getAmount())).m_130938_(style -> style.m_178520_(color));
            MutableComponent dpsComponent = Component.m_237115_((String)"chat.powerful_dummy.dps").m_7220_((Component)Component.m_237113_((String)String.format("%.1f", damageData.getCurrentDps())).m_130938_(style -> style.m_131140_(ChatFormatting.WHITE)));
            MutableComponent timeComponent = Component.m_237113_((String)" [").m_7220_(TimeUtils.formatRelativeTime(damageData.getTimestamp())).m_7220_((Component)Component.m_237113_((String)"] ")).m_130940_(ChatFormatting.GRAY);
            MutableComponent totalComponent = damageComponent.m_7220_((Component)damageCountComponent).m_7220_((Component)dpsComponent).m_7220_((Component)timeComponent);
            player.m_213846_((Component)totalComponent);
        });
        if (list.size() > maxEntries) {
            player.m_213846_((Component)Component.m_237110_((String)"chat.powerful_dummy.damagelog.return", (Object[])new Object[]{list.size()}).m_130940_(ChatFormatting.GREEN));
        }
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$7(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$5(Component message) {
        return message;
    }
}

