/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.entity;

import com.whisent.powerful_dummy.dps.DpsTracker;
import com.whisent.powerful_dummy.gui.TestDummyEntityMenu;
import com.whisent.powerful_dummy.item.ItemRegistry;
import com.whisent.powerful_dummy.utils.Debugger;
import com.whisent.powerful_dummy.utils.DummyEventUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class TestDummyEntity
extends Mob {
    public MobType mobType;
    public Player lastInteractPlayer;
    private final SimpleContainer inventory = new SimpleContainer(4);

    public TestDummyEntity(EntityType<? extends TestDummyEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21557_(false);
        this.f_21364_ = 0;
        this.m_21553_(false);
        this.m_20331_(false);
        this.mobType = MobType.f_21640_;
        if (!this.m_9236_().f_46443_) {
            Debugger.sendDebugMessage("[TestDummyEntity] Created new dummy at position: " + this.m_20183_());
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 9.223372036854776E18).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    public InteractionResult m_7111_(Player player, Vec3 pos, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            Debugger.sendDebugMessage("[TestDummyEntity] Player interaction: " + player.m_7755_().getString() + " at position: " + pos + " with hand: " + hand.name());
        }
        if (player.m_6047_() && player.m_21205_().m_41619_()) {
            if (!player.m_7500_()) {
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)ItemRegistry.DUMMY_STAND.get()));
            }
            this.popEquipmentSlots();
            this.m_6074_();
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
            this.showBreakingParticles();
            return InteractionResult.SUCCESS;
        }
        if (!player.m_9236_().m_5776_() && hand == InteractionHand.MAIN_HAND) {
            Debugger.sendDebugMessage("[TestDummyEntity] Opening menu for player: " + player.m_7755_().getString());
            this.lastInteractPlayer = player;
            if (player.m_21205_().m_41619_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new TestDummyEntityMenu(id, inventory, this), (Component)Component.m_237115_((String)"gui.test.title")), friendlyByteBuf -> friendlyByteBuf.writeInt(this.m_19879_()));
                return InteractionResult.SUCCESS;
            }
            Debugger.sendDebugMessage("[TestDummyEntity] Player holding item: " + player.m_21205_().m_41611_().getString());
        }
        return super.m_7111_(player, pos, hand);
    }

    public void popEquipmentSlots() {
        this.m_20158_().forEach(itemStack -> {
            if (!itemStack.m_41619_()) {
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)itemStack);
                Debugger.sendDebugMessage("[TestDummyEntity] Popped item: " + itemStack.m_41611_().getString());
            }
        });
        if (ModList.get().isLoaded("curios")) {
            if (this.getCapability(CuriosCapability.INVENTORY).resolve().isEmpty()) {
                return;
            }
            int amount = ((ICuriosItemHandler)this.getCapability(CuriosCapability.INVENTORY).resolve().get()).getEquippedCurios().getSlots();
            for (int i = 0; i < amount; ++i) {
                ItemStack itemStack2 = ((ICuriosItemHandler)this.getCapability(CuriosCapability.INVENTORY).resolve().get()).getEquippedCurios().getStackInSlot(i);
                if (itemStack2.m_41619_()) continue;
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)itemStack2);
                Debugger.sendDebugMessage("[TestDummyEntity] Popped curios item: " + itemStack2.m_41611_().getString());
            }
        }
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        if (!this.m_9236_().f_46443_) {
            Debugger.sendDebugMessage("[TestDummyEntity] Dummy died due to: " + p_21014_.m_19385_());
        }
        if (this.m_9236_() instanceof ServerLevel && this.m_213877_()) {
            this.popEquipmentSlots();
        }
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.m_9236_().f_46443_) {
            Component nameComponent;
            String entityName = "null";
            if (source.m_7639_() != null && (nameComponent = source.m_7639_().m_7755_()) != null) {
                entityName = nameComponent.getString();
            }
            Debugger.sendDebugMessage("[TestDummyEntity] Hurt by: " + source.m_19385_() + " with damage: " + damage + " - Source entity: " + entityName);
        }
        return super.m_6469_(source, damage);
    }

    protected void m_6475_(@NotNull DamageSource source, float damage) {
        if (!this.m_9236_().m_5776_()) {
            String msgId;
            Component name;
            if (source == null) {
                return;
            }
            String entityName = "null";
            String damageSourceMsgId = "null";
            Entity entity = source.m_7639_();
            if (entity != null && (name = entity.m_7755_()) != null) {
                entityName = name.getString();
            }
            if ((msgId = source.m_19385_()) != null) {
                damageSourceMsgId = msgId;
            }
            Debugger.sendDebugMessage(String.format("[TestDummyEntity] Actually hurt by: %s | Damage: %f | Source: %s", damageSourceMsgId, Float.valueOf(damage), entityName));
            Player player = null;
            if (entity instanceof Player) {
                player = (Player)entity;
                this.setLastInteractPlayer(player);
                DpsTracker.onEntityDamage(source, damage);
            } else {
                player = this.getLastInteractPlayer();
                if (player != null) {
                    DpsTracker.onEntityDamage(source, player, damage);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DummyEventUtils.sendHurtMessage(serverPlayer);
            }
        }
        super.m_6475_(source, damage);
    }

    public EntityType<?> m_6095_() {
        return super.m_6095_();
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public MobType m_6336_() {
        return this.mobType;
    }

    public void setMobType(MobType type) {
        this.mobType = type;
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_6074_() {
        if (!this.m_9236_().f_46443_) {
            Debugger.sendDebugMessage("[TestDummyEntity] Killing dummy");
        }
        this.f_20890_ = true;
        this.m_146870_();
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    private void showBreakingParticles() {
        Debugger.sendDebugMessage("[TestDummyEntity] Showing breaking particles");
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_5634_(this.m_21233_());
    }

    public Player getLastInteractPlayer() {
        return this.lastInteractPlayer;
    }

    public void setLastInteractPlayer(Player lastInteractPlayer) {
        this.lastInteractPlayer = lastInteractPlayer;
    }

    public AttributeMap m_21204_() {
        return super.m_21204_();
    }

    public void m_5618_(float p_21309_) {
        super.m_5618_(p_21309_);
    }

    public void m_5616_(float p_21306_) {
        super.m_5616_(p_21306_);
    }

    public void m_146926_(float p_146927_) {
        super.m_146926_(p_146927_);
    }

    public void m_146922_(float p_146923_) {
        super.m_146922_(p_146923_);
    }

    @Nullable
    public LivingEntity m_21188_() {
        return super.m_21188_();
    }
}

