/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.dps;

import com.whisent.powerful_dummy.dps.DpsData;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DpsTracker {
    private static final Map<UUID, DpsData> ENTITY_DPS_MAP = new WeakHashMap<UUID, DpsData>();

    public static void onEntityDamage(DamageSource damageSource, double damage) {
        DpsTracker.checkAndResetDps();
        Entity source = damageSource.m_7639_();
        if (source instanceof Player) {
            UUID playerId = source.m_20148_();
            DpsData data = ENTITY_DPS_MAP.computeIfAbsent(playerId, id -> new DpsData());
            data.addDamage(damage, damageSource);
        }
    }

    public static void onEntityDamage(DamageSource damageSource, Player player, double damage) {
        DpsTracker.checkAndResetDps();
        UUID playerId = player.m_20148_();
        DpsData data = ENTITY_DPS_MAP.computeIfAbsent(playerId, id -> new DpsData());
        data.addDamage(damage, damageSource);
    }

    public static float getDps(Entity entity) {
        DpsData data = ENTITY_DPS_MAP.get(entity.m_20148_());
        return data == null ? 0.0f : data.getDps();
    }

    public static DpsData getDpsData(Entity entity) {
        DpsData data = ENTITY_DPS_MAP.get(entity.m_20148_());
        return data == null ? new DpsData() : data;
    }

    public static void checkAndResetDps() {
        for (Map.Entry<UUID, DpsData> entry : ENTITY_DPS_MAP.entrySet()) {
            DpsData data = entry.getValue();
            if (!data.needsReset()) continue;
            data.reset();
        }
    }
}

