/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.dps;

import com.whisent.powerful_dummy.dps.DamageData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;

public class DpsData {
    private double totalDamage = 0.0;
    private double lastDamage = 0.0;
    private DamageSource ds = null;
    private final List<DamageData> damageDataList;
    private long startTime = System.currentTimeMillis();
    private long lastAttackTime = System.currentTimeMillis();
    private long resetTime = 3000L;

    public DpsData() {
        this.damageDataList = new ArrayList<DamageData>();
    }

    public void addDamage(double damage, DamageSource damageSource) {
        if (this.needsReset()) {
            this.reset();
        }
        this.totalDamage += damage;
        this.lastDamage = damage;
        this.ds = damageSource;
        this.lastAttackTime = System.currentTimeMillis();
        this.damageDataList.add(new DamageData(damage, damageSource, this.getDps()));
    }

    public float getLastDamage() {
        return (float)this.lastDamage;
    }

    public float getDps() {
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.startTime;
        if (elapsedTime <= 0L) {
            return 0.0f;
        }
        if (now - this.startTime < 1000L) {
            return (float)this.totalDamage;
        }
        return (float)(this.totalDamage / ((double)elapsedTime / 1000.0));
    }

    public float getTotalDamage() {
        return (float)this.totalDamage;
    }

    public boolean needsReset() {
        long now = System.currentTimeMillis();
        return now - this.lastAttackTime > this.getResetTime();
    }

    public boolean hasDamageTag(TagKey<DamageType> tag) {
        return this.ds.m_269533_(tag);
    }

    public DamageSource getDamageSource() {
        return this.ds;
    }

    public void reset() {
        this.totalDamage = 0.0;
        this.lastAttackTime = this.startTime = System.currentTimeMillis();
        this.damageDataList.clear();
    }

    public List<DamageData> getDamageDataList() {
        return this.damageDataList;
    }

    public long getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(int seconds) {
        this.resetTime = (long)seconds * 1000L;
    }
}

