/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.powerful_dummy.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="powerful_dummy", value={Dist.CLIENT})
public class DpsActionBar {
    private static Component currentText = null;
    private static int ticksVisible = 0;
    private static final int FADE_TICKS = 10;
    private static final int STAY_TICKS = 30;
    private static final int MAX_VISIBLE_TICKS = 50;

    public DpsActionBar() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void sendText(Component text) {
        currentText = text;
        ticksVisible = 0;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && currentText != null) {
            ++ticksVisible;
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        float alpha;
        if (currentText == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int x = screenWidth / 2;
        int y = screenHeight / 2 + screenHeight / 10 * 2;
        if (ticksVisible < 40) {
            alpha = 1.0f;
        } else if (ticksVisible < 50) {
            alpha = 1.0f - (float)(ticksVisible - 40) / 10.0f;
        } else {
            currentText = null;
            return;
        }
        int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24 & 0xFF000000;
        guiGraphics.m_280614_(mc.f_91062_, currentText, x - mc.f_91062_.m_92852_((FormattedText)currentText) / 2, y, color, true);
    }
}

