/*
 * Decompiled with CFR 0.152.
 */
package com.nakuring.enhanced_boss_bars;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nakuring.enhanced_boss_bars.BossBars;
import com.nakuring.enhanced_boss_bars.BossBarsConfig;
import com.nakuring.enhanced_boss_bars.EnhancedBossBars;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enhanced_boss_bars", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CustomBarRenderer {
    private static final ResourceLocation BAR_BACKGROUND = new ResourceLocation("enhanced_boss_bars", "textures/gui/bars/background.png");
    private static final Map<BossEvent, Boolean> SecondFase = new HashMap<BossEvent, Boolean>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCustomGuiOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent EventBoss = event.getBossEvent();
        String BossName = EventBoss.m_18861_().getString();
        for (Map.Entry<String, String> entry : EnhancedBossBars.BossNametoTranslatable.entrySet()) {
            String translatedName = Component.m_237115_((String)entry.getValue()).getString();
            if (BossName.equals(translatedName) && BossBarsConfig.NametoConfig.containsKey(BossName = entry.getKey()) && ((Boolean)BossBarsConfig.NametoConfig.get(BossName).get()).booleanValue()) {
                event.setCanceled(true);
                CustomBarRenderer.prepareBossBar(event, BossBars.BossBarsMap.get(BossName));
            }
            if (!EnhancedBossBars.ModInstalledIDs.contains("aether") || !BossName.contains(translatedName) || !((Boolean)BossBarsConfig.NametoConfig.get(entry.getKey()).get()).booleanValue()) continue;
            event.setCanceled(true);
            CustomBarRenderer.prepareBossBar(event, BossBars.BossBarsMap.get(entry.getKey()));
            return;
        }
    }

    private static void prepareBossBar(CustomizeGuiOverlayEvent.BossEventProgress event, BossBars BossBar) {
        PoseStack Pose = event.getGuiGraphics().m_280168_();
        LerpingBossEvent EventBoss = event.getBossEvent();
        event.setIncrement(BossBar.getIncrement());
        SecondFase.putIfAbsent((BossEvent)EventBoss, false);
        if (BossBar.hasSecondFase() && (double)EventBoss.m_142717_() < BossBar.getThresholdFase() || SecondFase.get(EventBoss).booleanValue()) {
            SecondFase.put((BossEvent)EventBoss, true);
            CustomBarRenderer.renderHealthBar(Pose, event, BossBar.getBarHealthOffsetX(), event.getY() + BossBar.getBarHealthPosY() - 12, BossBar.getBarHealthWidth(), BossBar.getBarHealthHeight(), BossBar.getSecondBarColor());
            CustomBarRenderer.renderBarOverlay(Pose, event.getY() + BossBar.getBarOverlayPosY() - 12, BossBar.getBarOverlayWidth(), BossBar.getBarOverlayHeight(), BossBar.getSecondBarOverlay());
            return;
        }
        CustomBarRenderer.renderHealthBar(Pose, event, BossBar.getBarHealthOffsetX(), event.getY() + BossBar.getBarHealthPosY() - 12, BossBar.getBarHealthWidth(), BossBar.getBarHealthHeight(), BossBar.getBarColor());
        CustomBarRenderer.renderBarOverlay(Pose, event.getY() + BossBar.getBarOverlayPosY() - 12, BossBar.getBarOverlayWidth(), BossBar.getBarOverlayHeight(), BossBar.getBarOverlay());
    }

    private static void renderHealthBar(PoseStack Pose, CustomizeGuiOverlayEvent.BossEventProgress event, int OffsetX, int y, int Width, int Height, ResourceLocation BAR_COLOR) {
        LerpingBossEvent EventBoss = event.getBossEvent();
        int x = (Minecraft.m_91087_().m_91268_().m_85445_() - Width) / 2 + OffsetX;
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        guiGraphics.m_280163_(BAR_BACKGROUND, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
        if (EventBoss.m_142717_() > 0.0f) {
            guiGraphics.m_280163_(BAR_COLOR, x, y, 0.0f, 0.0f, (int)(EventBoss.m_142717_() * (float)Width), Height, Width, Height);
        }
    }

    public static void renderBarOverlay(PoseStack Pose, int y, int Width, int Height, ResourceLocation BOSS_TEXTURE) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        GuiGraphics guiGraphics = new GuiGraphics(minecraft, bufferSource);
        int x = (minecraft.m_91268_().m_85445_() - Width) / 2;
        guiGraphics.m_280163_(BOSS_TEXTURE, x, y, 0.0f, 0.0f, Width, Height, Width, Height);
    }
}

