/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;

public class BlockEntityHelper {
    public static void sendCustomUpdate(BlockEntity entity, CompoundTag tag) {
        Level level = Objects.requireNonNull(entity.m_58904_());
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = entity.m_58899_();
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)entity, entity1 -> tag);
            List players = cache.f_8325_.m_183262_(new ChunkPos(pos), false);
            players.forEach(player -> player.f_8906_.m_9829_((Packet)packet));
        }
    }

    public static void saveItems(String key, CompoundTag tag, NonNullList<ItemStack> items) {
        ListTag list = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128344_("Slot", (byte)i);
            stack.m_41739_(slot);
            list.add((Object)slot);
        }
        tag.m_128365_(key, (Tag)list);
    }

    public static void loadItems(String key, CompoundTag tag, NonNullList<ItemStack> items) {
        items.clear();
        if (tag.m_128425_(key, 9)) {
            ListTag list = tag.m_128437_(key, 10);
            list.forEach(nbt -> {
                byte index;
                CompoundTag slot = (CompoundTag)nbt;
                if (slot.m_128425_("Slot", 1) && (index = slot.m_128445_("Slot")) >= 0 && index < items.size()) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)slot);
                    items.set((int)index, (Object)stack);
                }
            });
        }
    }

    public static NonNullList<ItemStack> nonNullListFromContainer(Container container) {
        int size = container.m_6643_();
        NonNullList items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            items.set(i, (Object)container.m_8020_(i));
        }
        return items;
    }
}

