/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.platform;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.furniture.refurbished.client.ForgeRenderType;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.FreezerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.MicrowaveScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.StoveScreen;
import com.mrcrayfish.furniture.refurbished.inventory.FreezerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.MicrowaveMenu;
import com.mrcrayfish.furniture.refurbished.inventory.StoveMenu;
import com.mrcrayfish.furniture.refurbished.platform.services.IClientHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public class ForgeClientHelper
implements IClientHelper {
    @Override
    public int getGuiLeft(AbstractContainerScreen<?> screen) {
        return screen.getGuiLeft();
    }

    @Override
    public int getGuiTop(AbstractContainerScreen<?> screen) {
        return screen.getGuiTop();
    }

    @Override
    public CreativeModeTab getSelectedCreativeModeTab() {
        return CreativeModeInventoryScreen.f_98507_;
    }

    @Override
    public void setTooltipCache(Tooltip tooltip, List<FormattedCharSequence> lines) {
        tooltip.f_256766_ = ImmutableList.copyOf(lines);
    }

    @Override
    public TextureAtlasSprite[] getFluidSprites(Fluid fluid, @Nullable BlockAndTintGetter getter, @Nullable BlockPos pos, FluidState state) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        return new TextureAtlasSprite[]{this.getBlockTextures().apply(extensions.getStillTexture(state, getter, pos)), this.getBlockTextures().apply(extensions.getFlowingTexture(state, getter, pos))};
    }

    @Override
    public void drawBakedModel(BakedModel model, PoseStack poseStack, VertexConsumer consumer, int light, int overlay) {
        Minecraft.m_91087_().m_91291_().m_115189_(model, ItemStack.f_41583_, light, overlay, poseStack, consumer);
    }

    @Override
    public BakedModel getBakedModel(ResourceLocation location) {
        return Minecraft.m_91087_().m_91304_().getModel(location);
    }

    @Override
    public RenderType getTelevisionScreenRenderType(ResourceLocation id) {
        return ForgeRenderType.televisionScreen(id);
    }

    @Override
    public void renderTooltip(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner position) {
        graphics.m_280497_(font, components, mouseX, mouseY, position);
    }

    @Override
    public AbstractContainerScreen createFreezerScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new FreezerScreen((FreezerMenu)menu, playerInventory, title);
    }

    @Override
    public AbstractContainerScreen createMicrowaveScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new MicrowaveScreen((MicrowaveMenu)menu, playerInventory, title);
    }

    @Override
    public AbstractContainerScreen createStoveScreen(AbstractContainerMenu menu, Inventory playerInventory, Component title) {
        return new StoveScreen((StoveMenu)menu, playerInventory, title);
    }

    private Function<ResourceLocation, TextureAtlasSprite> getBlockTextures() {
        return Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_);
    }
}

