/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.authlib.GameProfile;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public record Mailbox(UUID id, ResourceKey<Level> levelKey, BlockPos pos, MutableObject<UUID> owner, MutableObject<String> customName, Queue<ItemStack> queue, MutableBoolean removed, DeliveryService service) implements IMailbox
{
    public static final int MAX_NAME_LENGTH = 32;

    public boolean rename(String customName) {
        if (!customName.isBlank() && customName.length() <= 32) {
            this.customName.setValue((Object)customName);
            this.service.m_77762_();
            return true;
        }
        return false;
    }

    public boolean hasOwner() {
        return this.owner.getValue() != null;
    }

    public void setOwner(UUID uuid) {
        this.owner.setValue((Object)uuid);
        this.service.m_77762_();
    }

    void tick() {
        if (this.removed.booleanValue()) {
            return;
        }
        MinecraftServer server = this.service.getServer();
        ServerLevel level = server.m_129880_(this.levelKey);
        if (level == null || !level.m_46749_(this.pos)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            if (blockEntity2.getMailbox() != this) {
                this.remove();
                return;
            }
            if (this.queue.isEmpty()) {
                return;
            }
            ItemStack stack = this.queue.peek();
            if (blockEntity2.deliverItem(stack)) {
                this.queue.remove();
            }
        } else {
            this.remove();
        }
    }

    public void remove() {
        this.service.removeMailbox(this);
        this.removed.setValue(true);
    }

    public void writeQueue(CompoundTag compound) {
        ListTag list = new ListTag();
        this.queue.forEach(stack -> list.add((Object)stack.m_41739_(new CompoundTag())));
        compound.m_128365_("Queue", (Tag)list);
    }

    public static Queue<ItemStack> readQueueListTag(CompoundTag compound) {
        if (compound.m_128425_("Queue", 9)) {
            ArrayDeque<ItemStack> queue = new ArrayDeque<ItemStack>();
            ListTag list = compound.m_128437_("Queue", 10);
            list.forEach(tag -> queue.offer(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))));
            return queue;
        }
        return new ArrayDeque<ItemStack>();
    }

    void spawnQueueIntoLevel() {
        ServerLevel level = this.service.getServer().m_129880_(this.levelKey);
        if (level != null) {
            Queue<ItemStack> queue = this.queue;
            while (!queue.isEmpty()) {
                ItemStack stack = queue.poll();
                Containers.m_18992_((Level)level, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (ItemStack)stack);
            }
        }
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)obj;
        return this.id.equals(mailbox.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Optional<GameProfile> getOwner() {
        GameProfileCache cache;
        UUID ownerId = (UUID)this.owner.getValue();
        if (ownerId != null && (cache = this.service.getServer().m_129927_()) != null) {
            return cache.m_11002_(ownerId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCustomName() {
        return Optional.ofNullable((String)this.customName.getValue());
    }
}

