/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.RangeHoodBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlipAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.Vec3;

public class GrillBlockEntity
extends BlockEntity
implements WorldlyContainer {
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final NonNullList<ItemStack> fuel = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> cooking = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final ImmutableList<CookingSpace> spaces;
    protected final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> recipeCache;
    protected final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> campfireCookingCache;
    private int remainingFuel;
    private float storedExperience;

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.GRILL.get(), pos, state, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.GRILL_COOKING.get()));
    }

    protected GrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state);
        this.recipeCache = RecipeManager.m_220267_(recipeType);
        this.campfireCookingCache = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);
        this.spaces = (ImmutableList)Util.m_137537_(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.cooking.size());
            IntStream.range(0, this.cooking.size()).forEach(i -> builder.add((Object)new CookingSpace(i, this)));
            return builder.build();
        });
    }

    public CookingSpace getCookingSpace(int position) {
        return (CookingSpace)this.spaces.get(position);
    }

    public NonNullList<ItemStack> getCookingItems() {
        return this.cooking;
    }

    public NonNullList<ItemStack> getFuelItems() {
        return this.fuel;
    }

    public boolean addCookingItem(ItemStack stack, int position, int rotation) {
        Optional<? extends ProcessingRecipe> optional;
        if (((ItemStack)this.cooking.get(position)).m_41619_() && (optional = this.getRecipe(stack)).isPresent()) {
            ProcessingRecipe recipe = optional.get();
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.cooking.set(position, (Object)copy);
            ((CookingSpace)this.spaces.get(position)).update(recipe.getTime(), 0.0f, rotation);
            this.syncCookingSpace(position);
            this.playPlaceSound((CookingSpace)this.spaces.get(position), false, 0.85f);
            return true;
        }
        return false;
    }

    public boolean addFuel(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42414_) {
            for (int i = 0; i < this.fuel.size(); ++i) {
                if (!((ItemStack)this.fuel.get(i)).m_41619_()) continue;
                ItemStack fuel = stack.m_41777_();
                fuel.m_41764_(1);
                this.fuel.set(i, (Object)fuel);
                this.syncFuel();
                return true;
            }
        }
        return false;
    }

    public void flipItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((ItemStack)this.cooking.get(position)).m_41619_()) {
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isHalfCooked()) {
                space.flip();
                this.sendFlipAnimationToPlayers(position);
                this.syncCookingSpace(position);
                this.m_6596_();
            } else if (space.isFullyCooked()) {
                this.removeCookingItem(position);
            }
        }
    }

    private void sendFlipAnimationToPlayers(int position) {
        Level level = Objects.requireNonNull(this.f_58857_);
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            BlockPos pos = this.m_58899_();
            List players = cache.f_8325_.m_183262_(new ChunkPos(pos), false);
            players.forEach(player -> Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageFlipAnimation(pos, position)));
        }
    }

    public boolean flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.cooking.get(i)).m_41619_() || !((CookingSpace)this.spaces.get(i)).isHalfCooked()) continue;
            this.flipItem(i);
            return true;
        }
        return false;
    }

    public void removeCookingItem(int position) {
        if (position >= 0 && position < this.cooking.size() && !((ItemStack)this.cooking.get(position)).m_41619_()) {
            double posX = (double)this.f_58858_.m_123341_() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.f_58858_.m_123342_() + 1.0;
            double posZ = (double)this.f_58858_.m_123343_() + 0.3 + 0.4 * (double)(position / 2);
            ItemEntity entity = new ItemEntity(this.f_58857_, posX, posY + 0.1, posZ, ((ItemStack)this.cooking.get(position)).m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            this.cooking.set(position, (Object)ItemStack.f_41583_);
            CookingSpace space = (CookingSpace)this.spaces.get(position);
            if (space.isFullyCooked()) {
                this.spawnExperience(posX, posY, posZ, space.getExperience());
            }
            space.update(0, 0.0f, 0);
            CompoundTag compound = new CompoundTag();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        boolean canCook = grill.canCook();
        if (grill.remainingFuel == 0 && canCook) {
            for (int i = grill.fuel.size() - 1; i >= 0; --i) {
                ItemStack fuel = (ItemStack)grill.fuel.get(i);
                if (fuel.m_41619_()) continue;
                grill.remainingFuel = Services.ITEM.getBurnTime(fuel, RecipeType.f_44108_);
                grill.fuel.set(i, (Object)ItemStack.f_41583_);
                CompoundTag compound = new CompoundTag();
                grill.writeFuel(compound);
                grill.writeRemainingFuel(compound);
                BlockEntityHelper.sendCustomUpdate(grill, compound);
                break;
            }
        }
        if (canCook && grill.remainingFuel > 0) {
            grill.cookItems();
            --grill.remainingFuel;
            if (grill.remainingFuel == 0) {
                CompoundTag compound = new CompoundTag();
                grill.writeRemainingFuel(compound);
                BlockEntityHelper.sendCustomUpdate(grill, compound);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        grill.spawnParticles();
        grill.spaces.forEach(space -> {
            AudioManager.get().playLevelAudio((ILevelAudio)space);
            FlipAnimation animation = space.getAnimation();
            boolean wasPlaying = animation.isPlaying();
            animation.tick();
            if (wasPlaying && !animation.isPlaying()) {
                grill.playPlaceSound((CookingSpace)space, true, 1.0f);
            }
        });
    }

    private boolean canCook() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((ItemStack)this.cooking.get(i)).m_41619_() || !space.canCook()) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean changed = false;
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space;
            if (((ItemStack)this.cooking.get(i)).m_41619_() || !(space = (CookingSpace)this.spaces.get(i)).canCook()) continue;
            space.cook();
            if (!space.isCooked()) continue;
            if (space.isFlipped()) {
                Level level = Objects.requireNonNull(this.f_58857_);
                Optional<? extends ProcessingRecipe> optional = this.getRecipe((ItemStack)this.cooking.get(i));
                if (optional.isPresent()) {
                    this.cooking.set(i, (Object)optional.get().m_8043_(level.m_9598_()).m_41777_());
                }
            }
            this.syncCookingSpace(i);
            changed = true;
        }
        if (changed) {
            CompoundTag compound = new CompoundTag();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
            this.m_6596_();
        }
    }

    private void spawnParticles() {
        Level level = this.m_58904_();
        if (level != null) {
            if (this.isCooking()) {
                double posX = (double)this.f_58858_.m_123341_() + 0.2 + 0.6 * level.f_46441_.m_188500_();
                double posY = (double)this.f_58858_.m_123342_() + 0.85;
                double posZ = (double)this.f_58858_.m_123343_() + 0.2 + 0.6 * level.f_46441_.m_188500_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < this.cooking.size(); ++i) {
                CookingSpace space;
                if (((ItemStack)this.cooking.get(i)).m_41619_()) continue;
                if (level.f_46441_.m_188501_() < 0.1f && (space = (CookingSpace)this.spaces.get(i)).isHalfCooked()) {
                    Vec3 spacePos = space.getWorldPosition();
                    for (int j = 0; j < 4; ++j) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, spacePos.f_82479_, spacePos.f_82480_, spacePos.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
                space = (CookingSpace)this.spaces.get(i);
                if (this.remainingFuel <= 0 || !space.canCook() || space.isCooked() || space.getAnimation().isPlaying()) continue;
                Vec3 spacePos = space.getWorldPosition();
                spacePos = spacePos.m_82520_(0.05 * level.f_46441_.m_188583_(), 0.0, 0.05 * level.f_46441_.m_188583_());
                this.spawnSteam(level, spacePos.f_82479_, spacePos.f_82480_, spacePos.f_82481_);
            }
        }
    }

    public void spawnSteam(Level level, double x, double y, double z) {
        double ySpeed = 0.01;
        if (this.isRangeHoodPowered(level, this.f_58858_.m_6630_(2))) {
            ySpeed = 0.05;
        } else if (this.isRangeHoodPowered(level, this.f_58858_.m_6630_(3))) {
            ySpeed = 0.1;
        }
        level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, ySpeed, 0.0);
    }

    private boolean isRangeHoodPowered(Level level, BlockPos pos) {
        BlockPos start = this.f_58858_.m_7494_();
        while (start.m_123342_() < pos.m_123342_()) {
            if (!level.m_8055_(start).m_60795_()) {
                return false;
            }
            start = start.m_7494_();
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof RangeHoodBlock) {
            return (Boolean)state.m_61143_((Property)RangeHoodBlock.POWERED);
        }
        return false;
    }

    private boolean isCooking() {
        for (int i = 0; i < this.cooking.size(); ++i) {
            CookingSpace space = (CookingSpace)this.spaces.get(i);
            if (((ItemStack)this.cooking.get(i)).m_41619_() || !space.canCook() && !space.isHalfCooked()) continue;
            return this.remainingFuel > 0;
        }
        return false;
    }

    private Optional<? extends ProcessingRecipe> getRecipe(ItemStack stack) {
        Optional<? extends ProcessingRecipe> optional = this.getRecipeFromCache(this.recipeCache, stack);
        optional = optional.isEmpty() ? this.getCookingRecipe(this.campfireCookingCache, stack) : optional;
        return optional;
    }

    private Optional<ProcessingRecipe> getCookingRecipe(RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> cache, ItemStack stack) {
        return cache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_)).map(recipe -> ProcessingRecipe.Item.from(recipe, this.f_58857_.m_9598_()));
    }

    private Optional<? extends ProcessingRecipe> getRecipeFromCache(RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> cache, ItemStack stack) {
        return cache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(this.f_58857_));
    }

    public int m_6643_() {
        return this.fuel.size() + this.cooking.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.fuel) {
            if (stack.m_41619_()) continue;
            return false;
        }
        for (ItemStack stack : this.cooking) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        if (index - this.fuel.size() >= 0) {
            return (ItemStack)this.cooking.get(index - this.fuel.size());
        }
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            ItemStack result = ContainerHelper.m_18969_(this.cooking, (int)(index -= this.fuel.size()), (int)count);
            if (((ItemStack)this.cooking.get(index)).m_41619_()) {
                CookingSpace space = (CookingSpace)this.spaces.get(index);
                if (space.isFullyCooked()) {
                    double posX = (double)this.f_58858_.m_123341_() + 0.3 + 0.4 * (double)(index % 2);
                    double posY = (double)this.f_58858_.m_123342_() + 1.0;
                    double posZ = (double)this.f_58858_.m_123343_() + 0.3 + 0.4 * (double)(index / 2);
                    this.spawnExperience(posX, posY, posZ, space.getExperience());
                }
                space.update(0, 0.0f, 0);
            }
            CompoundTag compound = new CompoundTag();
            this.writeCookingItems(compound);
            BlockEntityHelper.sendCustomUpdate(this, compound);
            return result;
        }
        ItemStack result = ContainerHelper.m_18969_(this.fuel, (int)index, (int)count);
        this.syncFuel();
        return result;
    }

    public ItemStack m_8016_(int index) {
        if (index - this.fuel.size() >= 0) {
            return ContainerHelper.m_18966_(this.cooking, (int)(index - this.fuel.size()));
        }
        return ContainerHelper.m_18966_(this.fuel, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        NonNullList<ItemStack> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            index -= this.fuel.size();
            inventory = this.cooking;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe(stack);
            if (optional.isPresent()) {
                ProcessingRecipe recipe = optional.get();
                ((CookingSpace)this.spaces.get(index)).update(recipe.getTime(), 0.0f, 0);
                this.syncCookingSpace(index);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        CompoundTag compound = new CompoundTag();
        this.writeCookingItems(compound);
        this.writeFuel(compound);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6211_() {
        this.fuel.clear();
        this.cooking.clear();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("Grill", 9)) {
            this.cooking.clear();
            BlockEntityHelper.loadItems("Grill", compound, this.cooking);
        }
        if (compound.m_128425_("Fuel", 9)) {
            this.fuel.clear();
            BlockEntityHelper.loadItems("Fuel", compound, this.fuel);
        }
        if (compound.m_128425_("RemainingFuel", 3)) {
            this.remainingFuel = compound.m_128451_("RemainingFuel");
        }
        if (compound.m_128425_("StoredExperience", 5)) {
            this.storedExperience = compound.m_128457_("StoredExperience");
        }
        this.readCookingSpaces(compound);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeCookingItems(tag);
        this.writeFuel(tag);
        this.writeRemainingFuel(tag);
        this.writeCookingSpaces(tag);
        tag.m_128350_("StoredExperience", this.storedExperience);
    }

    private CompoundTag writeCookingItems(CompoundTag compound) {
        BlockEntityHelper.saveItems("Grill", compound, this.cooking);
        return compound;
    }

    private CompoundTag writeFuel(CompoundTag compound) {
        BlockEntityHelper.saveItems("Fuel", compound, this.fuel);
        return compound;
    }

    private CompoundTag writeRemainingFuel(CompoundTag compound) {
        compound.m_128405_("RemainingFuel", this.remainingFuel);
        return compound;
    }

    private CompoundTag writeCookingSpaces(CompoundTag compound) {
        this.writeCookingSpaces(compound, -1);
        return compound;
    }

    private CompoundTag writeCookingSpaces(CompoundTag compound, int position) {
        ListTag list = new ListTag();
        if (position >= 0 && position < this.spaces.size()) {
            CompoundTag tag = new CompoundTag();
            ((CookingSpace)this.spaces.get(position)).writeToTag(tag);
            tag.m_128405_("Position", position);
            list.add((Object)tag);
        } else if (position == -1) {
            for (int i = 0; i < this.spaces.size(); ++i) {
                CompoundTag tag = new CompoundTag();
                ((CookingSpace)this.spaces.get(i)).writeToTag(tag);
                tag.m_128405_("Position", i);
                list.add((Object)tag);
            }
        }
        compound.m_128365_("CookingSpaces", (Tag)list);
        return compound;
    }

    private void readCookingSpaces(CompoundTag compound) {
        if (compound.m_128425_("CookingSpaces", 9)) {
            ListTag list = compound.m_128437_("CookingSpaces", 10);
            list.forEach(nbt -> {
                int position;
                CompoundTag tag = (CompoundTag)nbt;
                if (tag.m_128425_("Position", 3) && (position = tag.m_128451_("Position")) >= 0 && position < this.spaces.size()) {
                    ((CookingSpace)this.spaces.get(position)).readFromTag(tag);
                }
            });
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (!this.m_8020_(index).m_41619_()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.getRecipe(stack).isPresent();
        }
        return stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index - this.fuel.size() >= 0 && ((CookingSpace)this.spaces.get(index -= this.fuel.size())).isFullyCooked()) {
            return this.getRecipe(stack).isEmpty();
        }
        return false;
    }

    private void playPlaceSound(CookingSpace space, boolean client, float pitch) {
        Level level = Objects.requireNonNull(this.f_58857_);
        Vec3 pos = space.getWorldPosition();
        if (client) {
            level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch, false);
            return;
        }
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.BLOCK_FRYING_PAN_PLACE_INGREDIENT.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    private void syncCookingSpace(int position) {
        CompoundTag compound = new CompoundTag();
        this.writeCookingItems(compound);
        this.writeCookingSpaces(compound, position);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    private void syncFuel() {
        CompoundTag compound = new CompoundTag();
        this.writeFuel(compound);
        BlockEntityHelper.sendCustomUpdate(this, compound);
    }

    private void spawnExperience(double x, double y, double z, float exp) {
        Level level;
        this.storedExperience += Math.max(exp, 0.0f);
        if ((float)Mth.m_14143_((float)this.storedExperience) >= 1.0f && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int amount = Mth.m_14143_((float)this.storedExperience);
            ExperienceOrb.m_147082_((ServerLevel)level2, (Vec3)new Vec3(x, y, z), (int)amount);
            this.storedExperience = Math.max(this.storedExperience - (float)amount, 0.0f);
        }
    }

    public void playFlipAnimation(int position) {
        if (Objects.requireNonNull(this.f_58857_).m_5776_() && position >= 0 && position < this.spaces.size()) {
            ((CookingSpace)this.spaces.get(position)).getAnimation().play();
        }
    }

    public static class CookingSpace
    implements ILevelAudio {
        public static final double MAX_AUDIO_DISTANCE = Mth.m_144944_((int)8);
        private final int index;
        private final GrillBlockEntity grill;
        private int cookingTime = 0;
        private int totalCookingTime = 0;
        private boolean flipped = false;
        private float experience = 0.0f;
        private int rotation = 0;
        private FlipAnimation animation;

        public CookingSpace(int index, GrillBlockEntity grill) {
            this.index = index;
            this.grill = grill;
        }

        public boolean isFlipped() {
            return this.flipped;
        }

        public float getExperience() {
            return this.experience;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void cook() {
            if (this.cookingTime < this.totalCookingTime) {
                ++this.cookingTime;
            }
        }

        public boolean isCooked() {
            return this.cookingTime == this.totalCookingTime;
        }

        public boolean isHalfCooked() {
            return !this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean isFullyCooked() {
            return this.flipped && this.cookingTime == this.totalCookingTime;
        }

        public boolean canCook() {
            return this.cookingTime < this.totalCookingTime;
        }

        public void update(int cookTime, float experience, int rotation) {
            this.cookingTime = 0;
            this.totalCookingTime = cookTime / 2;
            this.flipped = false;
            this.experience = experience;
            this.rotation = rotation;
        }

        public void flip() {
            if (!this.flipped) {
                this.flipped = true;
                this.cookingTime = 0;
            }
        }

        public Vec3 getWorldPosition() {
            BlockPos pos = this.grill.f_58858_;
            double x = (double)pos.m_123341_() + 0.3 + 0.4 * (double)(this.index % 2);
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.3 + 0.4 * (double)(this.index / 2);
            return new Vec3(x, y, z);
        }

        public void writeToTag(CompoundTag tag) {
            tag.m_128405_("CookingTime", this.cookingTime);
            tag.m_128405_("TotalCookingTime", this.totalCookingTime);
            tag.m_128379_("Flipped", this.flipped);
            tag.m_128350_("Experience", this.experience);
            tag.m_128405_("Rotation", this.rotation);
        }

        public void readFromTag(CompoundTag tag) {
            if (tag.m_128425_("CookingTime", 3)) {
                this.cookingTime = tag.m_128451_("CookingTime");
            }
            if (tag.m_128425_("TotalCookingTime", 3)) {
                this.totalCookingTime = tag.m_128451_("TotalCookingTime");
            }
            if (tag.m_128425_("Flipped", 1)) {
                this.flipped = tag.m_128471_("Flipped");
            }
            if (tag.m_128425_("Experience", 5)) {
                this.experience = tag.m_128457_("Experience");
            }
            if (tag.m_128425_("Rotation", 3)) {
                this.rotation = tag.m_128451_("Rotation");
            }
        }

        public FlipAnimation getAnimation() {
            if (this.animation == null) {
                this.animation = new FlipAnimation();
            }
            return this.animation;
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ModSounds.BLOCK_FRYING_PAN_SIZZLING.get();
        }

        @Override
        public SoundSource getSource() {
            return SoundSource.BLOCKS;
        }

        @Override
        public Vec3 getAudioPosition() {
            return this.getWorldPosition();
        }

        @Override
        public boolean canPlayAudio() {
            return !this.grill.m_58901_() && this.grill.remainingFuel > 0 && !((ItemStack)this.grill.cooking.get(this.index)).m_41619_() && (!this.isCooked() || this.isHalfCooked());
        }

        @Override
        public float getAudioVolume() {
            return (this.canCook() && !this.isCooked() || this.isHalfCooked()) && !this.getAnimation().isPlaying() ? 1.0f : 0.0f;
        }

        @Override
        public float getAudioPitch() {
            return this.isHalfCooked() ? 0.8f : 1.0f;
        }

        @Override
        public double getAudioRadiusSqr() {
            return MAX_AUDIO_DISTANCE;
        }

        @Override
        public int getAudioHash() {
            return Objects.hash(this.grill.f_58858_, this.index);
        }

        @Override
        public boolean isAudioEqual(ILevelAudio other) {
            return other == this;
        }
    }
}

