/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.ElectricityGeneratorBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricitySourceLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ElectricityGeneratorBlockEntity
extends ElectricitySourceLootBlockEntity
implements IProcessingBlock,
IPowerSwitch,
ILevelAudio {
    public static final int DATA_ENERGY = 0;
    public static final int DATA_TOTAL_ENERGY = 1;
    public static final int DATA_ENABLED = 2;
    public static final int DATA_OVERLOADED = 3;
    public static final int DATA_POWERED = 4;
    public static final int DATA_NODE_COUNT = 5;
    protected final Vec3 audioPosition;
    protected int totalEnergy;
    protected int energy;
    protected boolean enabled;
    protected int nodeCount;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.energy, value -> {});
        builder.add(1, () -> this.totalEnergy, value -> {});
        builder.add(2, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(3, () -> this.overloaded ? 1 : 0, value -> {});
        builder.add(4, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(5, () -> this.nodeCount, value -> {});
    });

    public ElectricityGeneratorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.ELECTRICITY_GENERATOR.get(), pos, state);
    }

    public ElectricityGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 1);
        this.audioPosition = pos.m_252807_().m_82520_(0.0, -0.375, 0.0);
    }

    @Override
    public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerElectricityGenerator.get();
    }

    protected Component m_6820_() {
        return Utils.translation("container", "electricity_generator", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        if (!this.enabled) {
            this.searchNodeNetwork(false);
        }
        return new ElectricityGeneratorMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        ElectricityGeneratorMenu generator;
        return menu instanceof ElectricityGeneratorMenu && (generator = (ElectricityGeneratorMenu)menu).getContainer() == this;
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_ELECTRICITY_GENERATOR_ENGINE.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && !this.m_58901_();
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)ElectricityGeneratorBlock.POWERED)) {
            return (Boolean)state.m_61143_((Property)ElectricityGeneratorBlock.POWERED);
        }
        return false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)ElectricityGeneratorBlock.POWERED)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ElectricityGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void togglePower() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            NodeSearchResult result = this.searchNodeNetwork(false);
            if (!result.overloaded()) {
                if (this.overloaded) {
                    this.overloaded = false;
                }
            } else {
                this.enabled = false;
            }
        }
        this.m_6596_();
    }

    @Override
    public void onNodeOverloaded() {
        this.enabled = false;
        this.m_6596_();
    }

    @Override
    public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        NodeSearchResult result = super.searchNodeNetwork(cancelAtLimit);
        this.nodeCount = result.nodes().size();
        return result;
    }

    @Override
    public IProcessingBlock.EnergyMode getEnergyMode() {
        return IProcessingBlock.EnergyMode.ONLY_WHEN_PROCESSING;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
    }

    @Override
    public boolean requiresEnergy() {
        return true;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        int energy;
        ItemStack stack = this.m_8020_(0);
        if (!stack.m_41619_() && (energy = Services.ITEM.getBurnTime(stack, null) * (Integer)Config.SERVER.electricity.fuelToPowerRatio.get()) > 0) {
            if (!simulate) {
                Item remainingItem = stack.m_41720_().m_41469_();
                if (stack.m_41741_() == 1 && remainingItem != null) {
                    this.m_6836_(0, new ItemStack((ItemLike)remainingItem));
                } else {
                    stack.m_41774_(1);
                }
                this.totalEnergy = energy;
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    @Override
    public int getTotalProcessingTime() {
        return 1;
    }

    @Override
    public int getProcessingTime() {
        return 0;
    }

    @Override
    public void setProcessingTime(int time) {
        if (this.isNodePowered()) {
            if (time == 0) {
                this.setNodePowered(false);
            }
        } else if (time == 1) {
            this.setNodePowered(true);
        }
    }

    @Override
    public void onCompleteProcess() {
    }

    @Override
    public boolean canProcess() {
        return this.enabled && !this.isNodeOverloaded();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ElectricityGeneratorBlockEntity generator) {
        AudioManager.get().playLevelAudio(generator);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Enabled", this.enabled);
    }

    @Override
    public void earlyNodeTick(Level level) {
        if (!level.m_5776_()) {
            this.processTick();
        }
        super.earlyNodeTick(level);
    }
}

