/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.item.armor;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mindoth.dreadsteel.DreadsteelClient;
import net.mindoth.dreadsteel.client.models.armor.DreadsteelModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.DistExecutor;

public class DreadsteelArmor
extends ArmorItem {
    private final LazyLoadedValue<HumanoidModel<?>> model = (LazyLoadedValue)DistExecutor.unsafeRunForDist(() -> () -> new LazyLoadedValue(() -> this.provideArmorModelForSlot(type)), () -> () -> null);

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.dreadsteel.dreadsteel_setbonus"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public boolean m_8120_(ItemStack p_77616_1_) {
        return true;
    }

    public DreadsteelArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.m_41486_());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag tag = stack.m_41783_();
        String color = null;
        if (tag != null) {
            if (tag.m_128451_("CustomModelData") == 1) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_white.png";
            }
            if (tag.m_128451_("CustomModelData") == 2) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_black.png";
            }
            if (tag.m_128451_("CustomModelData") == 3) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_bronze.png";
            }
            if (tag.m_128451_("CustomModelData") == 0) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
            }
        } else {
            color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
        }
        return color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel<?> provideArmorModelForSlot(ArmorItem.Type type) {
        return new DreadsteelModel(Minecraft.m_91087_().m_167973_().m_171103_(DreadsteelClient.DREADSTEEL_ARMOR), type);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return (HumanoidModel)DreadsteelArmor.this.model.m_13971_();
            }
        });
    }
}

