/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.menu.MarketClientMenu;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MarketScreen
extends AbstractContainerScreen<MarketMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = Lists.newArrayList();
    private final MarketClientMenu clientContainer;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private EditBox searchBar;

    public MarketScreen(MarketMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
        this.clientContainer = (MarketClientMenu)container;
    }

    public void m_7856_() {
        this.f_97727_ = 174;
        super.m_7856_();
        Font font = Minecraft.m_91087_().f_91062_;
        this.searchBar = new EditBox(font, this.f_97735_ + this.f_97726_ - 78, this.f_97736_ - 5, 70, 10, this.searchBar, (Component)Component.m_237119_());
        this.m_264313_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.searchBar);
        this.updateCategoryFilters();
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        IMarketCategory[] categories;
        for (MarketFilterButton filterButton : this.filterButtons) {
            ((ScreenAccessor)this).balm_getChildren().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getRenderables().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getNarratables().remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curY = -80;
        for (IMarketCategory category : categories = (IMarketCategory[])this.clientContainer.getCategories().stream().sorted().toArray(IMarketCategory[]::new)) {
            MarketFilterButton filterButton = new MarketFilterButton(this.f_96543_ / 2 + 87, this.f_96544_ / 2 + curY, this.clientContainer, category, button -> {
                if (this.clientContainer.getCurrentCategory() == category) {
                    this.clientContainer.setFilterCategory(null);
                } else {
                    this.clientContainer.setFilterCategory(category);
                }
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.m_142416_((GuiEventListener)filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (Math.abs(delta) > 0.0) {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.m_252754_() && mouseX < (double)(this.searchBar.m_252754_() + this.searchBar.m_5711_()) && mouseY >= (double)this.searchBar.m_252907_() && mouseY < (double)(this.searchBar.m_252907_() + this.searchBar.m_93694_())) {
            this.searchBar.m_94144_("");
            this.clientContainer.search(null);
            this.clientContainer.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char c, int keyCode) {
        boolean result = super.m_5534_(c, keyCode);
        this.clientContainer.search(this.searchBar.m_94155_());
        this.clientContainer.populateMarketSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.m_7933_(keyCode, scanCode, modifiers) || this.searchBar.m_93696_()) {
            if (keyCode == 256) {
                this.f_96541_.f_91074_.m_6915_();
            } else {
                this.clientContainer.search(this.searchBar.m_94155_());
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (MarketFilterButton sortButton : this.filterButtons) {
            if (!sortButton.m_5953_(mouseX, mouseY) || !sortButton.f_93623_) continue;
            guiGraphics.m_280677_(this.f_96547_, sortButton.getTooltipLines(), Optional.empty(), mouseX, mouseY);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.clientContainer.isDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            this.clientContainer.setDirty(false);
        }
        Font font = this.f_96541_.f_91062_;
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_ - 10, 0, 0, this.f_97726_, this.f_97727_ + 10);
        if (((MarketMenu)this.f_97732_).getSelectedEntry() != null && !((MarketMenu)this.f_97732_).isReadyToBuy()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 43, this.f_97736_ + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        guiGraphics.m_280056_(font, I18n.m_118938_((String)"container.farmingforblockheads.market", (Object[])new Object[0]), this.f_97735_ + 10, this.f_97736_ + 10, 0xFFFFFF, true);
        if (((MarketMenu)this.f_97732_).getSelectedEntry() == null) {
            guiGraphics.m_280137_(font, I18n.m_118938_((String)"gui.farmingforblockheads:market.no_selection", (Object[])new Object[0]), this.f_97735_ + 49, this.f_97736_ + 65, 0xFFFFFF);
        } else {
            guiGraphics.m_280653_(font, MarketScreen.getPriceText(((MarketMenu)this.f_97732_).getSelectedEntry()), this.f_97735_ + 49, this.f_97736_ + 65, 0xFFFFFF);
        }
        guiGraphics.m_280509_(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.f_97735_ + this.f_97726_ - 7 - 9;
        this.scrollBarYPos = this.f_97736_ + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4));
        this.clientContainer.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public static Component getPriceText(IMarketEntry entry) {
        MutableComponent textComponent = Component.m_237110_((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().m_41613_(), entry.getCostItem().m_41611_()});
        textComponent.m_130940_(MarketScreen.getPriceColor(entry));
        return textComponent;
    }

    public static ChatFormatting getPriceColor(IMarketEntry entry) {
        ChatFormatting color = ChatFormatting.GREEN;
        String unlocalizedName = entry.getCostItem().m_41778_().toLowerCase(Locale.ENGLISH);
        if (unlocalizedName.contains("diamond")) {
            color = ChatFormatting.AQUA;
        } else if (unlocalizedName.contains("gold")) {
            color = ChatFormatting.YELLOW;
        } else if (unlocalizedName.contains("iron")) {
            color = ChatFormatting.WHITE;
        }
        return color;
    }
}

