/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.audio;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tejty.gamediscs.sounds.SoundRegistry;

@OnlyIn(value=Dist.CLIENT)
public class SoundPlayer {
    private final SoundManager manager = Minecraft.m_91087_().m_91106_();
    private final Random random = new Random();

    public void play(SoundEvent event) {
        this.play(event, 1.0f);
    }

    public void play(SoundEvent event, float pitch) {
        this.play(event, pitch, 1.0f);
    }

    public void play(SoundEvent event, float pitch, float volume) {
        this.manager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)pitch, (float)volume));
    }

    public void playRandom(SoundEvent event, float minPitch, float maxPitch, float volume) {
        this.play(event, this.random.nextFloat(minPitch, maxPitch), volume);
    }

    public void playRandom(SoundEvent event, float minPitch, float maxPitch, float minVolume, float maxVolume) {
        this.playRandom(event, minPitch, maxPitch, this.random.nextFloat(minVolume, maxVolume));
    }

    public void playClick(boolean down) {
        this.playRandom((SoundEvent)SoundRegistry.CLICK.get(), down ? 0.3f : 1.0f, down ? 0.6f : 1.5f, down ? 0.7f : 0.2f, down ? 0.9f : 0.4f);
    }

    public void playJump() {
        this.playRandom((SoundEvent)SoundRegistry.JUMP.get(), 0.8f, 1.2f, 0.8f, 1.2f);
    }

    public void playPoint() {
        this.play((SoundEvent)SoundRegistry.POINT.get(), 1.0f, 0.7f);
    }

    public void playNewBest() {
        this.play((SoundEvent)SoundRegistry.NEW_BEST.get(), 1.5f, 2.0f);
    }

    public void playGameOver() {
        this.play((SoundEvent)SoundRegistry.GAME_OVER.get(), 0.9f, 2.0f);
    }

    public void playSelect() {
        this.play((SoundEvent)SoundRegistry.SELECT.get(), 0.5f, 0.5f);
    }

    public void playConfirm() {
        this.play((SoundEvent)SoundRegistry.CONFIRM.get(), 1.0f, 0.5f);
    }
}

