/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.datagen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.util.loot.ItemModifier;

public class DiscLootModifierProvider
extends GlobalLootModifierProvider {
    public DiscLootModifierProvider(PackOutput output) {
        super(output, "gamediscs");
    }

    protected void start() {
        HashMap<String, Float> lootTables = new HashMap<String, Float>();
        lootTables.put("chests/simple_dungeon", Float.valueOf(0.2f));
        lootTables.put("chests/stronghold_corridor", Float.valueOf(0.2f));
        lootTables.put("chests/stronghold_crossing", Float.valueOf(0.2f));
        lootTables.put("chests/stronghold_library", Float.valueOf(0.2f));
        lootTables.put("chests/end_city_treasure", Float.valueOf(0.2f));
        lootTables.put("chests/woodland_mansion", Float.valueOf(0.2f));
        lootTables.put("chests/buried_treasure", Float.valueOf(0.2f));
        lootTables.put("chests/ruined_portal", Float.valueOf(0.2f));
        lootTables.put("chests/ancient_city", Float.valueOf(0.2f));
        lootTables.put("chests/ancient_city_ice_box", Float.valueOf(0.2f));
        lootTables.put("chests/abandoned_mineshaft", Float.valueOf(0.2f));
        lootTables.put("chests/jungle_temple", Float.valueOf(0.2f));
        lootTables.put("chests/desert_pyramid", Float.valueOf(0.2f));
        lootTables.put("chests/bastion_bridge", Float.valueOf(0.2f));
        lootTables.put("chests/bastion_hoglin_stable", Float.valueOf(0.2f));
        lootTables.put("chests/bastion_other", Float.valueOf(0.2f));
        lootTables.put("chests/bastion_treasure", Float.valueOf(0.2f));
        HashMap<String, Object> gameDiscs = new HashMap<String, Object>();
        gameDiscs.put("flappy_bird", ItemRegistry.GAME_DISC_FLAPPY_BIRD.get());
        gameDiscs.put("slime", ItemRegistry.GAME_DISC_SLIME.get());
        gameDiscs.put("blocktris", ItemRegistry.GAME_DISC_BLOCKTRIS.get());
        gameDiscs.put("tnt_sweeper", ItemRegistry.GAME_DISC_TNT_SWEEPER.get());
        gameDiscs.put("pong", ItemRegistry.GAME_DISC_PONG.get());
        gameDiscs.put("froggie", ItemRegistry.GAME_DISC_FROGGIE.get());
        for (Map.Entry lootTableEntry : lootTables.entrySet()) {
            String lootTable = (String)lootTableEntry.getKey();
            float chance = ((Float)lootTableEntry.getValue()).floatValue();
            for (Map.Entry gameDiscEntry : gameDiscs.entrySet()) {
                String gameName = (String)gameDiscEntry.getKey();
                Object gameDisc = gameDiscEntry.getValue();
                this.add(gameName + "_disc_from_" + lootTable, (IGlobalLootModifier)new ItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(new ResourceLocation(lootTable)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)chance).m_6409_()}, (Item)gameDisc));
            }
        }
    }
}

