/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDetector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Set<String> loadedMods = null;

    public static boolean isModLoaded(String modid) {
        if (loadedMods == null) {
            ModDetector.initializeModList();
        }
        return loadedMods.contains(modid);
    }

    private static void initializeModList() {
        loadedMods = new HashSet<String>();
        for (ModInfo info : FMLLoader.getLoadingModList().getMods()) {
            loadedMods.add(info.getModId());
        }
        LOGGER.debug("\u5df2\u52a0\u8f7d {} \u4e2a\u6a21\u7ec4", (Object)loadedMods.size());
    }

    public static Set<String> getLoadedMods() {
        if (loadedMods == null) {
            ModDetector.initializeModList();
        }
        return new HashSet<String>(loadedMods);
    }

    public static String extractModId(String reference) {
        if (reference == null || !reference.contains(":")) {
            return null;
        }
        int colonIndex = reference.indexOf(58);
        return colonIndex > 0 ? reference.substring(0, colonIndex) : null;
    }

    public static boolean isModReference(String str) {
        return str != null && str.contains(":") && ModDetector.extractModId(str) != null;
    }
}

