/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.processor.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.xinian.datapackloaderrorfix.processor.BaseProcessor;
import com.xinian.datapackloaderrorfix.util.BackupManager;
import com.xinian.datapackloaderrorfix.util.ModDetector;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;

public class DatapackProcessor
extends BaseProcessor {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String[] CONFIG_EXTENSIONS = new String[]{".json", ".mcmeta"};
    private static final String[] DATAPACK_DIRECTORIES = new String[]{"data"};
    private static final String[] REMOVABLE_KEYS = new String[]{"parent", "model", "texture", "item", "block", "entity", "type", "source", "target", "result", "ingredient", "advancement", "recipe", "loot_table", "structure"};

    public DatapackProcessor() {
        super(LogManager.getLogger());
    }

    public void processDatapacks(File worldDir) {
        File globalDatapacksDir;
        this.logProcessStart("\u6570\u636e\u5305", worldDir.getName());
        File worldDatapacksDir = new File(worldDir, "datapacks");
        if (worldDatapacksDir.exists() && worldDatapacksDir.isDirectory()) {
            this.logger.info("\u6b63\u5728\u5904\u7406\u4e16\u754c\u6570\u636e\u5305\u76ee\u5f55: {}", (Object)worldDatapacksDir.getPath());
            this.processDatapacksDirectory(worldDatapacksDir);
        }
        if ((globalDatapacksDir = new File("datapacks")).exists() && globalDatapacksDir.isDirectory()) {
            this.logger.info("\u6b63\u5728\u5904\u7406\u5168\u5c40\u6570\u636e\u5305\u76ee\u5f55: {}", (Object)globalDatapacksDir.getPath());
            this.processDatapacksDirectory(globalDatapacksDir);
        }
        this.logProcessComplete("\u6570\u636e\u5305", worldDir.getName(), true);
    }

    private void processDatapacksDirectory(File datapacksDir) {
        File[] datapacks = datapacksDir.listFiles(File::isDirectory);
        if (datapacks == null) {
            return;
        }
        for (File datapack : datapacks) {
            this.logger.info("\u6b63\u5728\u5904\u7406\u6570\u636e\u5305: {}", (Object)datapack.getName());
            this.processDatapack(datapack);
        }
    }

    private void processDatapack(File datapackDir) {
        File mcmetaFile = new File(datapackDir, "pack.mcmeta");
        if (mcmetaFile.exists()) {
            try {
                this.processConfigFile(mcmetaFile);
            }
            catch (Exception e) {
                this.logError("\u5904\u7406\u6570\u636e\u5305\u5143\u6570\u636e", mcmetaFile.getPath(), e);
            }
        }
        for (String dirName : DATAPACK_DIRECTORIES) {
            File dataDir = new File(datapackDir, dirName);
            if (!dataDir.exists() || !dataDir.isDirectory()) continue;
            try {
                this.processDataDirectory(dataDir);
            }
            catch (Exception e) {
                this.logError("\u5904\u7406\u6570\u636e\u76ee\u5f55", dataDir.getPath(), e);
            }
        }
    }

    private void processDataDirectory(File dataDir) throws IOException {
        List<File> configFiles = this.findConfigFiles(dataDir);
        for (File configFile : configFiles) {
            try {
                this.processConfigFile(configFile);
            }
            catch (Exception e) {
                this.logError("\u5904\u7406\u914d\u7f6e\u6587\u4ef6", configFile.getPath(), e);
            }
        }
    }

    private List<File> findConfigFiles(File dataDir) throws IOException {
        try (Stream<Path> paths = Files.walk(dataDir.toPath(), new FileVisitOption[0]);){
            List<File> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isConfigFile).map(Path::toFile).toList();
            return list;
        }
    }

    private boolean isConfigFile(Path path) {
        String fileName = path.getFileName().toString().toLowerCase();
        for (String ext : CONFIG_EXTENSIONS) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private void processConfigFile(File configFile) throws IOException {
        JsonElement root;
        this.logger.debug("\u6b63\u5728\u5904\u7406\u914d\u7f6e\u6587\u4ef6: {}", (Object)configFile.getPath());
        if (!BackupManager.createBackup(configFile)) {
            this.logger.warn("\u65e0\u6cd5\u521b\u5efa\u5907\u4efd\uff0c\u8df3\u8fc7\u914d\u7f6e\u6587\u4ef6: {}", (Object)configFile.getName());
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            root = JsonParser.parseReader((Reader)reader);
        }
        boolean changed = this.cleanJsonElement(root);
        if (changed) {
            this.logger.info("\u4fee\u590d\u4e86\u914d\u7f6e\u6587\u4ef6: {}", (Object)configFile.getPath());
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson(root, (Appendable)writer);
            }
        }
    }

    private boolean cleanJsonElement(JsonElement element) {
        if (element.isJsonObject()) {
            return this.cleanJsonObject(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return this.cleanJsonArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return this.checkJsonPrimitive(element.getAsJsonPrimitive());
        }
        return false;
    }

    private boolean checkJsonPrimitive(JsonPrimitive primitive) {
        String modId;
        String value;
        if (primitive.isString() && ModDetector.isModReference(value = primitive.getAsString()) && (modId = ModDetector.extractModId(value)) != null && !ModDetector.isModLoaded(modId)) {
            this.logger.warn("\u53d1\u73b0\u5f15\u7528\u4e0d\u5b58\u5728\u6a21\u7ec4\u7684\u5b57\u7b26\u4e32: {}", (Object)value);
        }
        return false;
    }

    private boolean cleanJsonObject(JsonObject obj) {
        boolean changed = false;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (Map.Entry entry : obj.entrySet()) {
            String modId;
            String strValue;
            String modId2;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (ModDetector.isModReference(key) && (modId2 = ModDetector.extractModId(key)) != null && !ModDetector.isModLoaded(modId2)) {
                keysToRemove.add(key);
                this.logger.info("\u53d1\u73b0\u5f15\u7528\u4e0d\u5b58\u5728\u6a21\u7ec4\u7684\u952e: {}", (Object)key);
                changed = true;
                continue;
            }
            if (this.cleanJsonElement(value)) {
                changed = true;
            }
            if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString() || !ModDetector.isModReference(strValue = value.getAsString()) || (modId = ModDetector.extractModId(strValue)) == null || ModDetector.isModLoaded(modId) || !this.isRemovableKey(key)) continue;
            keysToRemove.add(key);
            this.logger.info("\u79fb\u9664\u5f15\u7528\u4e0d\u5b58\u5728\u6a21\u7ec4\u7684\u952e\u503c\u5bf9: {} -> {}", (Object)key, (Object)strValue);
            changed = true;
        }
        for (String key : keysToRemove) {
            obj.remove(key);
        }
        return changed;
    }

    private boolean cleanJsonArray(JsonArray array) {
        boolean changed = false;
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            String modId;
            String value;
            JsonElement element = (JsonElement)iterator.next();
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && ModDetector.isModReference(value = element.getAsString()) && (modId = ModDetector.extractModId(value)) != null && !ModDetector.isModLoaded(modId)) {
                iterator.remove();
                this.logger.info("\u4ece\u6570\u7ec4\u4e2d\u79fb\u9664\u5f15\u7528\u4e0d\u5b58\u5728\u6a21\u7ec4\u7684\u5143\u7d20: {}", (Object)value);
                changed = true;
                continue;
            }
            if (!element.isJsonObject() && !element.isJsonArray() || !this.cleanJsonElement(element)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean isRemovableKey(String key) {
        for (String removableKey : REMOVABLE_KEYS) {
            if (!key.equals(removableKey)) continue;
            return true;
        }
        return false;
    }
}

