/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.processor.impl;

import com.xinian.datapackloaderrorfix.processor.BaseProcessor;
import com.xinian.datapackloaderrorfix.util.BackupManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;

public class ChunkDataProcessor
extends BaseProcessor {
    public ChunkDataProcessor() {
        super(LogManager.getLogger());
    }

    public void processChunkData(File worldDir) {
        this.logProcessStart("\u533a\u5757\u6570\u636e", worldDir.getName());
        try {
            this.processDimensionChunks(new File(worldDir, "region"), "\u4e3b\u4e16\u754c");
            this.processDimensionChunks(new File(worldDir, "DIM-1/region"), "\u4e0b\u754c");
            this.processDimensionChunks(new File(worldDir, "DIM1/region"), "\u672b\u5730");
            this.processCustomDimensions(worldDir);
            this.logProcessComplete("\u533a\u5757\u6570\u636e", worldDir.getName(), true);
        }
        catch (Exception e) {
            this.logError("\u5904\u7406\u533a\u5757\u6570\u636e", worldDir.getName(), e);
        }
    }

    private void processDimensionChunks(File regionDir, String dimensionName) {
        if (!regionDir.exists() || !regionDir.isDirectory()) {
            this.logger.debug("\u7ef4\u5ea6\u533a\u5757\u76ee\u5f55\u4e0d\u5b58\u5728: {} ({})", (Object)regionDir.getPath(), (Object)dimensionName);
            return;
        }
        this.logger.info("\u6b63\u5728\u5904\u7406{}\u533a\u5757\u76ee\u5f55: {}", (Object)dimensionName, (Object)regionDir.getPath());
        File[] regionFiles = regionDir.listFiles((dir, name) -> name.endsWith(".mca"));
        if (regionFiles == null || regionFiles.length == 0) {
            this.logger.debug("{}\u6ca1\u6709\u627e\u5230\u533a\u5757\u6587\u4ef6", (Object)dimensionName);
            return;
        }
        for (File regionFile : regionFiles) {
            try {
                this.processRegionFile(regionFile);
            }
            catch (Exception e) {
                this.logError("\u5904\u7406\u533a\u5757\u6587\u4ef6", regionFile.getName(), e);
            }
        }
    }

    private void processRegionFile(File regionFile) {
        if (!BackupManager.createBackup(regionFile)) {
            this.logger.warn("\u65e0\u6cd5\u521b\u5efa\u5907\u4efd\uff0c\u8df3\u8fc7\u533a\u5757\u6587\u4ef6: {}", (Object)regionFile.getName());
            return;
        }
        this.logger.info("\u5904\u7406\u533a\u5757\u6587\u4ef6: {}", (Object)regionFile.getName());
        try {
            this.cleanRegionFile(regionFile);
        }
        catch (Exception e) {
            this.logError("\u6e05\u7406\u533a\u5757\u6587\u4ef6", regionFile.getName(), e);
        }
    }

    private void cleanRegionFile(File regionFile) {
        this.logger.debug("\u533a\u5757\u6587\u4ef6\u6e05\u7406\u529f\u80fd\u5f85\u5b9e\u73b0: {}", (Object)regionFile.getName());
    }

    private void processCustomDimensions(File worldDir) {
        File dimensionsDir = new File(worldDir, "dimensions");
        if (!dimensionsDir.exists() || !dimensionsDir.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(dimensionsDir.toPath(), new FileVisitOption[0]);){
            List<File> regionDirs = paths.filter(path -> path.toFile().isDirectory()).filter(path -> "region".equals(path.getFileName().toString())).map(Path::toFile).toList();
            for (File regionDir : regionDirs) {
                String customDimName = regionDir.getParentFile().getName();
                this.processDimensionChunks(regionDir, "\u81ea\u5b9a\u4e49\u7ef4\u5ea6:" + customDimName);
            }
        }
        catch (IOException e) {
            this.logError("\u5904\u7406\u81ea\u5b9a\u4e49\u7ef4\u5ea6", dimensionsDir.getName(), e);
        }
    }
}

