/*
 * Decompiled with CFR 0.152.
 */
package com.tighug.zenith.world.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tighug.zenith.Zenith;
import com.tighug.zenith.item.ModItem;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public final class ZenithProjectile
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"zenith");
    public static final RegistryObject<EntityType<ZenithProjectile>> ZENITH_PROJECTILE = ENTITIES.register("zenith_projectile", () -> EntityType.Builder.m_20704_(ZenithProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(6).m_20717_(100).m_20712_("zenith_projectile"));
    @NotNull
    private Map<Enchantment, Integer> enchantments = Map.of();
    private float acceleration = 4.0f;
    @NotNull
    private Vec3 ODirection = Vec3.f_82478_;
    private byte tickCount;
    private byte life;
    private Vec3 OPosition = Vec3.f_82478_;
    private float curvature;
    private Vec3 OYRot = Vec3.f_82478_;

    private ZenithProjectile(EntityType<ZenithProjectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
        this.curvature = 0.25f + this.f_19796_.m_188501_() * 2.0f;
        this.f_19794_ = true;
    }

    private ZenithProjectile(Level level, @NotNull Player player) {
        this((EntityType<ZenithProjectile>)((EntityType)ZENITH_PROJECTILE.get()), level);
        this.setEnchantments(EnchantmentHelper.m_44831_((ItemStack)player.m_21205_()));
        this.m_5602_((Entity)player);
        this.m_146884_(player.m_20182_().m_82520_(0.0, 0.8, 0.0).m_82549_(this.m_20171_(0.0f, player.m_146908_()).m_82490_(-1.0)));
        this.OPosition = this.m_20182_();
        this.m_19915_(player.m_146908_() + 90.0f, 0.0f);
        this.f_19859_ = this.m_146908_();
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (!this.enchantments.isEmpty()) {
            ListTag listTag = new ListTag();
            this.enchantments.forEach((enchantment, integer) -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("id", Objects.requireNonNull(EnchantmentHelper.m_182432_((Enchantment)enchantment)).toString());
                tag.m_128405_("lvl", integer.intValue());
                listTag.add((Object)tag);
            });
            compoundTag.m_128365_("enchantments", (Tag)listTag);
        }
        compoundTag.m_128347_("OX", this.ODirection.m_7096_());
        compoundTag.m_128347_("OY", this.ODirection.m_7098_());
        compoundTag.m_128347_("OZ", this.ODirection.m_7094_());
        compoundTag.m_128344_("tickCount", this.tickCount);
        compoundTag.m_128344_("life", this.life);
        compoundTag.m_128347_("OPX", this.OPosition.m_7096_());
        compoundTag.m_128347_("OPY", this.OPosition.m_7098_());
        compoundTag.m_128347_("OPZ", this.OPosition.m_7094_());
        compoundTag.m_128350_("curvature", this.curvature);
        compoundTag.m_128350_("acceleration", this.acceleration);
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (!compoundTag.m_128437_("enchantments", 10).isEmpty()) {
            this.enchantments = EnchantmentHelper.m_44882_((ListTag)compoundTag.m_128437_("enchantments", 10));
        }
        this.ODirection = new Vec3(compoundTag.m_128459_("OX"), compoundTag.m_128459_("OY"), compoundTag.m_128459_("OZ"));
        this.OPosition = new Vec3(compoundTag.m_128459_("OPX"), compoundTag.m_128459_("OPY"), compoundTag.m_128459_("OPZ"));
        this.tickCount = compoundTag.m_128445_("tickCount");
        this.life = compoundTag.m_128445_("life");
        this.curvature = compoundTag.m_128457_("curvature");
        this.acceleration = compoundTag.m_128457_("acceleration");
    }

    @NotNull
    public static ZenithProjectile of(Level level, @NotNull Player player) {
        ZenithProjectile zenithProjectile = new ZenithProjectile(level, player);
        zenithProjectile.setODirection(player.m_20154_());
        zenithProjectile.life = (byte)20;
        zenithProjectile.acceleration -= 0.9848077f * zenithProjectile.curvature / 5.0f;
        zenithProjectile.OYRot = zenithProjectile.m_20154_().m_82490_((double)(-zenithProjectile.curvature / 10.0f));
        return zenithProjectile;
    }

    @NotNull
    public static ZenithProjectile of(Level level, @NotNull Player player, Vec3 vec3) {
        ZenithProjectile zenithProjectile = new ZenithProjectile(level, player);
        vec3 = player.m_20182_().m_82505_(vec3).m_82520_(0.0, -0.8, 0.0);
        zenithProjectile.setODirection(vec3);
        zenithProjectile.life = (byte)Mth.m_14008_((double)(vec3.m_82553_() / 2.0 + 2.0), (double)8.0, (double)20.0);
        zenithProjectile.life = (byte)(zenithProjectile.life + (zenithProjectile.life & 1));
        zenithProjectile.acceleration = (float)((double)zenithProjectile.acceleration - Math.sin(90 / zenithProjectile.life * zenithProjectile.life) * 2.0 * (double)zenithProjectile.curvature / 10.0);
        zenithProjectile.OYRot = zenithProjectile.m_20154_().m_82490_((double)(-zenithProjectile.curvature / (float)zenithProjectile.life / 2.0f));
        return zenithProjectile;
    }

    public void setODirection(@NotNull Vec3 vec3) {
        double length = vec3.m_82553_();
        if (Math.abs(1.0 - length) > 0.01) {
            vec3 = vec3.m_82490_(1.0 / length);
        }
        this.ODirection = vec3;
    }

    public void setEnchantments(@NotNull Map<Enchantment, Integer> map) {
        this.enchantments = map;
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_8119_() {
        Player entity;
        Entity entity2;
        Level level;
        super.m_8119_();
        if (this.tickCount == this.life / 2) {
            this.acceleration *= -1.0f;
            this.OYRot = this.OYRot.m_82490_(-1.0);
        }
        if (!(level = this.m_9236_()).m_5776_() && (entity2 = this.m_19749_()) instanceof Player && (entity = (Player)entity2).m_21205_().m_150930_((Item)ModItem.ZENITH.get())) {
            AABB aabb = new AABB(this.m_20183_()).m_82400_(2.0);
            float f = (float)entity.m_21133_(Attributes.f_22281_);
            DamageSource ds = this.m_269291_().m_269075_(entity);
            level.m_6249_((Entity)null, aabb, e -> e.m_6097_() && !e.equals((Object)entity)).forEach(e -> {
                e.f_19802_ = 0;
                float f1 = f;
                for (Enchantment enchantment : this.enchantments.keySet()) {
                    int p_44688_ = this.enchantments.get(enchantment);
                    f1 += enchantment.getDamageBonus(p_44688_, e instanceof LivingEntity ? ((LivingEntity)e).m_6336_() : MobType.f_21640_, entity.m_21205_());
                    enchantment.m_7677_((LivingEntity)entity, e, p_44688_);
                    if (enchantment != Enchantments.f_44981_ || !(e instanceof LivingEntity) || e.m_6060_()) continue;
                    e.m_20254_(4 * this.enchantments.get(enchantment));
                }
                e.m_6469_(ds, f1);
            });
        }
        if (this.tickCount < this.life) {
            Vec3 vec3 = this.ODirection.m_82490_((double)this.acceleration).m_82549_(this.m_20154_().m_82490_((double)this.curvature)).m_82549_(this.OYRot);
            if (this.tickCount >= this.life / 2 && this.m_19749_() != null) {
                Vec3 v3 = this.OPosition.m_82505_(this.m_19749_().m_20182_().m_82520_(0.0, 0.8, 0.0).m_82549_(this.m_20171_(0.0f, this.m_19749_().m_146908_()).m_82490_(-1.0)));
                if (v3.m_82553_() > 80.0) {
                    this.m_6074_();
                    return;
                }
                v3 = v3.m_82490_(1.0 / ((double)this.life - (double)this.tickCount));
                this.OPosition = this.OPosition.m_82549_(v3);
                vec3 = vec3.m_82549_(v3);
            }
            this.m_20256_(vec3);
            this.m_6478_(MoverType.SELF, vec3);
            this.f_19859_ = this.m_146908_();
            this.m_19915_(this.m_146908_() - 360.0f / (float)this.life, 0.0f);
        } else if (this.tickCount > this.life + 1) {
            this.m_6074_();
        }
        this.tickCount = (byte)(this.tickCount + 1);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6478_(@NotNull MoverType moverType, @NotNull Vec3 vec3) {
        if (moverType == MoverType.SELF) {
            super.m_6478_(moverType, vec3);
        }
    }

    protected void m_8097_() {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.m_20148_());
        buffer.m_130130_(this.m_19879_());
        buffer.m_130130_(this.m_19749_() == null ? 0 : this.m_19749_().m_19879_());
        buffer.writeDouble(this.ODirection.m_7096_());
        buffer.writeDouble(this.ODirection.m_7098_());
        buffer.writeDouble(this.ODirection.m_7094_());
        buffer.writeByte((int)this.life);
        buffer.writeFloat(this.curvature);
        buffer.writeFloat(this.acceleration);
        buffer.writeFloat(this.m_146908_());
        buffer.writeFloat(this.m_146909_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_20084_(additionalData.m_130259_());
        this.m_20234_(additionalData.m_130242_());
        this.m_5602_(this.m_9236_().m_6815_(additionalData.m_130242_()));
        this.ODirection = new Vec3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.life = additionalData.readByte();
        this.curvature = additionalData.readFloat();
        this.acceleration = additionalData.readFloat();
        this.m_146922_(additionalData.readFloat());
        this.m_146926_(additionalData.readFloat());
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5496_((SoundEvent)Zenith.ZENITH_ATTACK.get(), 1.0f, 1.0f);
        }
        this.OPosition = this.m_20182_();
        this.OYRot = this.m_20154_().m_82490_((double)(-this.curvature / (float)this.life / 2.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class ZenithProjectileRenderer
    extends EntityRenderer<ZenithProjectile> {
        public static final ResourceLocation LAYER_LOCATION = new ResourceLocation("zenith", "textures/item/texture.png");
        private final ItemStack defaultInstance = ((Item)ModItem.ZENITH.get()).m_7968_();

        public void render(@NotNull ZenithProjectile zenithProjectile, float p_113840_, float p_113841_, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-zenithProjectile.m_146908_() - 45.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedmodel = itemRenderer.m_174264_(this.defaultInstance, zenithProjectile.m_9236_(), null, zenithProjectile.m_19879_());
            itemRenderer.m_115143_(this.defaultInstance, ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, i, OverlayTexture.f_118083_, bakedmodel);
            poseStack.m_85849_();
            super.m_7392_((Entity)zenithProjectile, p_113840_, p_113841_, poseStack, multiBufferSource, i);
        }

        public ZenithProjectileRenderer(EntityRendererProvider.Context p_174008_) {
            super(p_174008_);
        }

        @NotNull
        public ResourceLocation getTextureLocation(@NotNull ZenithProjectile p_114482_) {
            return LAYER_LOCATION;
        }
    }
}

