/*
 * Decompiled with CFR 0.152.
 */
package com.tighug.zenith.event;

import com.google.common.collect.Queues;
import com.tighug.zenith.event.IR;
import java.util.Queue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class Event {
    public static final Queue<IR> DELAYS = Queues.newArrayDeque();

    @SubscribeEvent
    public static void onPlayerTickEvent(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            int l = DELAYS.size();
            for (int i = 0; i < l; ++i) {
                IR poll = DELAYS.poll();
                assert (poll != null);
                poll.run();
            }
        }
    }

    public static void addDelay(int t, IR ir) {
        DELAYS.add(new Delay(t, ir));
    }

    private record Delay(int t, IR ir) implements IR
    {
        @Override
        public void run() {
            if (this.t > 0) {
                DELAYS.add(new Delay(this.t - 1, this.ir));
            } else {
                this.ir.run();
            }
        }
    }
}

