/*
 * Decompiled with CFR 0.152.
 */
package net.everla.commandsceptre.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.everla.commandsceptre.CommandsceptreMod;
import net.everla.commandsceptre.procedures.SceptreArrowModeProcedure;
import net.everla.commandsceptre.procedures.SceptreCobwebModeProcedure;
import net.everla.commandsceptre.procedures.SceptreDestroyModeProcedure;
import net.everla.commandsceptre.procedures.SceptreFireballModeProcedure;
import net.everla.commandsceptre.procedures.SceptreFlightToggleProcedure;
import net.everla.commandsceptre.procedures.SceptreLightningModeProcedure;
import net.everla.commandsceptre.procedures.SceptreObsidianModeProcedure;
import net.everla.commandsceptre.procedures.SceptreParryModeProcedure;
import net.everla.commandsceptre.procedures.SceptreSculkBlastModeProcedure;
import net.everla.commandsceptre.procedures.SceptreStrengthenModeProcedure;
import net.everla.commandsceptre.procedures.SceptreTNTModeProcedure;
import net.everla.commandsceptre.procedures.SceptreTeleportModeToggleProcedure;
import net.everla.commandsceptre.world.inventory.SceptreGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SceptreGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SceptreGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SceptreGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SceptreGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SceptreGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SceptreGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SceptreGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SceptreFlightToggleProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SceptreTeleportModeToggleProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SceptreFireballModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SceptreSculkBlastModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SceptreLightningModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SceptreArrowModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SceptreDestroyModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            SceptreObsidianModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SceptreParryModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            SceptreStrengthenModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            SceptreTNTModeProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SceptreCobwebModeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CommandsceptreMod.addNetworkMessage(SceptreGuiButtonMessage.class, SceptreGuiButtonMessage::buffer, SceptreGuiButtonMessage::new, SceptreGuiButtonMessage::handler);
    }
}

